/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef TRIG_DQSEGWRITER_HH
#define TRIG_DQSEGWRITER_HH

#include "Segment.hh"
#include "TrigProc.hh"
#include "TrigWriter.hh"
#include <list>

namespace trig {

    class TrigBase;
    class Segment;

    /**  The DQSegWriter class writes triggers to the mySql segment database.
     *  @memo Trigger writer API
     *  @author J. Zweizig
     *  @version 1.0; Last Modified September 23, 2005
     */
    class DQSegWriter : public TrigWriter {
    public:
	DQSegWriter(void);
	~DQSegWriter(void);
	lmsg::error_type addTrigger(const TrigBase& t, const TrigProc& p);
	lmsg::error_type addSegment(const Segment& s,  const TrigProc& p);
	void clear(const Time& start, const Time& end);
	Time getEarly(void) const;
	TrigWriter::trig_mode getMode(void) const;
	int getNSegs(const Time& t) const;
	lmsg::error_type setProcess(const TrigProc& p);
	lmsg::error_type write(const std::string& file, const Time& start, 
			       const Time& end) const;

    private:
	typedef std::list<TrigProc>       proc_list;
	typedef proc_list::iterator       proc_iter;
	typedef proc_list::const_iterator const_proc_iter;
	typedef std::list<Segment>        seg_list;
	typedef seg_list::iterator        seg_iter;
	typedef seg_list::const_iterator  const_seg_iter;

    private:
	proc_iter insert_proc(const TrigProc& p);

    private:
	proc_list    mProcList;
	seg_list     mSegList;
    };

    //====================================  Inline methods.
    inline TrigWriter::trig_mode 
    DQSegWriter::getMode(void) const {
	return kSegWrt;
    }

} // namespace trig

#endif // TRIG_DQSEGWRITER_HH
