/* -*- mode: c++; c-basic-offset: 3; -*- */
#include "stdio_fd.hh"
#include <fstream>
#include <iostream>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>
#include "PConfig.h"

using namespace std;

//====================================== Construct from an stdio FILE pointer
stdio_fd::stdio_fd(FILE* file) {
   _fd = fileno(file);
}

#ifndef P__DARWIN
//======================================  Moan hard/ugly stuff...
template<typename _CharT, typename _Traits>
class pseudo_filebuf : private basic_filebuf<_CharT, _Traits>
{
public:
   pseudo_filebuf() {}
   int fd(void) {return basic_filebuf<_CharT, _Traits>::_M_file.fd();}
};

typedef pseudo_filebuf<std::ofstream::char_type,std::ofstream::traits_type> ofb;
typedef pseudo_filebuf<std::ifstream::char_type,std::ifstream::traits_type> ifb;

stdio_fd::stdio_fd(const std::ofstream& fs) {
   _fd = reinterpret_cast<ofb*>(fs.rdbuf())->fd();
}

stdio_fd::stdio_fd(const std::ifstream& fs) {
   _fd = reinterpret_cast<ifb*>(fs.rdbuf())->fd();
}
#endif

void 
stdio_fd::block(bool on) {
   int flags = fcntl(_fd, F_GETFL);
   if (on) flags &= ~O_NONBLOCK;
   else    flags |=  O_NONBLOCK;
   fcntl(_fd, F_SETFL, flags);
}

bool 
stdio_fd::is_pipe(void) const {
   struct stat fdstat;
   if (fstat(_fd, &fdstat)) {
      perror("is_pipe: fd is not kosher");
      return false;
   }
   return S_ISFIFO(fdstat.st_mode);
}

//=====================================  Set the buffer size of named pipe files
void
set_pipe_size(int buf_size) {
#if 0
   fcntl(_fd, F_SETPIPE_SZ, buf_size);
#else
   cout << "The set_pipe_size funtion is not implemented yet" << endl;
#endif
}

//   This function doesn't use fd and hasn't been needed so I suppressed 
//   it from this class
//
#if 0
int 
stdio_fd::sig_pipe(bool on) {
   struct sigaction sa;
   sa.sa_handler = SIG_IGN;
   sigemptyset(&sa.sa_mask);
   sa.sa_flags   = SA_RESTART;

   if (sigaction(SIGPIPE, &sa, 0)) {
      perror("Error in sig_pipe");
   }
   return 0;
}
#endif
