/* -*- mode: c++; c-basic-offset: 4; -*- */
//
//    File: NormTest
//
//    Bit Test monitor class definition.
//
#include "DatEnv.hh"
#include "Time.hh"
#include "TrigClient.hh"
#include "framecpp/Types.hh"
#include <list>
#include <iosfwd>
#include <string>

class ChanNORM;
class Time;

/**  @name NormTest
  *  NormTest prints out times (resolutiuon 1 s) with dataValid on a 
  *  specified channel.
  *
  *  The NormTest command line syntax is as follows:
  *
  *  \begin{verbatim}
         NormTest [-conf <cfile>] [-log] [-trig]
     \end{verbatim}
  *
  *  Where:
  *  \begin{tabular}{ll}
  *  -conf <cfile> & Specify the configuration file name [NormTest.cfg]. \\
  *  -log          & Indicates that NormTest is to log all errors found. \\
  *  -trig         & Enable trigger generation.
  *  \end{tabular}
  *
  *  @memo Look for dataValid errors in frames.
  *  @author J. Zweizig 
  *  @version 1.0; Modified November 14, 2006
  */
//@{
//@}

//======================================  Monitor class definition
class NormTest : public DatEnv {
public:
    NormTest(int argc, const char *argv[]);
    ~NormTest();

    //----------------------------------  Print channel status information
    void PrintStatus(std::ostream& out) const;

    void ProcessData(void);
    bool ReadConfig(void);

private:
    std::string mConfig;
    std::string mStatusFile;
    typedef std::list<ChanNORM> ChanList;
    typedef ChanList::iterator channel_iter;
    typedef ChanList::const_iterator const_chan_iter;
    ChanList mChanList;
    TrigClient mTrig;
    bool mGblLog;
    bool mGblTrig;
    Time mLastPrint;
};

//
//    ChanNORM Class
//
//    The ChanNORM class carries the status of each channel to be followed
//    by the normalized tester.
//
class ChanNORM {
public:
    ChanNORM(const char *chan, TrigClient& tc);
    ~ChanNORM(void);

    //----------------------------------  Print status page.
    static void PrintHeader(std::ostream& out);
    void PrintStatus(std::ostream& out) const;

    //----------------------------------  Scan the data
    void Scan(const TSeries& ts);
    void segment(const Time& t0, Interval dT);
    const char* getChannel(void) const;
    void setTrigEnable(bool te);
    void setLog(bool le);
    void writeSegment(void);

public:
    std::string mChanName;
    bool mTrigEnable;
    bool mLogEnable;
    TrigClient& mTrig;
    short  mCurVal;
    Time   mStart;
    Time   mCurrent;

    //-----------------------------------  Statistics.
    long mCount;
    Time mLast;
};

inline const char*
ChanNORM::getChannel(void) const {
    return mChanName.c_str();
}
