#ifndef SetInfo_HH
#define SetInfo_HH

#include <iostream>
#include <string>
#include <vector>
#include <fstream>
#include <deque>
#include <map>

#include "Dacc.hh"
#include "Time.hh"
#include "TSeries.hh"
#include "Histogram1.hh"
#include "Trend.hh"
#include "html/table.hh"
#include "ChannelInfo.hh"
#include "ConfContainer.hh"
#include "LockStatus.hh"


const static double kHistUpdateInt = 3600.0;
const static int kTSMaxNArray = 24 * 60;
const static double kTSUpdateInt = 60.0;

class SetInfo {
public:
  typedef std::vector<ChannelInfo> ChannelList;
  typedef std::vector<EventInfo> EventList;
  typedef std::vector<ConfigInfo> ConfigList;
  typedef std::vector<int> config_numbers;
  typedef std::map<std::string, config_numbers> ChanConfig_map;
   
private:
  // Set name/description
  std::string fSName;
  ChanConfig_map fCCmap;
  std::string trigger;
  bool sinit;

  static int sfData_attn [];

public:
//----------------------- Histogram & TSeries
  HistogramInfo* fHist;

	/// temp histograms
  std::vector < std::deque < Histogram1 > > fHist_buff;

	/// 2hr histogram.
  std::vector<Histogram1> fHistS;

	/// 24hr histogram.
  std::vector<Histogram1> fHistL;

	/// time series of event rate.
  std::vector < std::deque < int > > fRate;
  std::vector<TSeries> fTSRate;
  std::vector<Time> fTSRateStartTime;

  std::vector<std::string> trend_channel_name;



  SetInfo (); 
  ~SetInfo () ;
  void Attention () ;
  void TSSave( std::ofstream& out );
  void SetName(std::string& value);
  void SetTrigger(std::string& value);
  std::string GetName();
  int GetNConf();
  void AddPair(std::string chname, config_numbers c_numbers);
  void findCoincidentEvents(EventList& master_elist, std::vector<std::string>& Einfo_log, ChannelList& ChList);
  void ConfigLog(html::table& results, ChannelList& ChList);
  void ResetStat ( MonServer& mserv, Trend& trend, const std::vector<TSeries>& tlist, int ts_interval) ;
  void Init (const Time& t);
  bool IsInit();
  void UpdateHistogram( const Time& t, Trend& trend );
};

#endif
