/* this function applies a second order section */
/* to an input number (a double)                */

#include "IIRfilter_structures.hh"

void sos_apply (second_order_section* sec)
{
  int zero = (sec->shift_count)%3;
  int one = ((sec->shift_count)+1)%3;
  int two = ((sec->shift_count)+2)%3;

  /* apply recursive filter coefficients (poles in transfer function) */

  sec->shift_reg[ zero ] = sec->in - 
    sec->a[1] * sec->shift_reg[ one ] -
    sec->a[2] * sec->shift_reg[ two ];

  /* apply direct filter coefficients (zeros in transfer function) */

  *(sec->pout) = 
    sec->b[0] * sec->shift_reg[ zero ] +
    sec->b[1] * sec->shift_reg[ one ] +
    sec->b[2] * sec->shift_reg[ two ] ;

  /* increment shift_register; this is the same as */
  /* copying shift_reg[0] to shift_reg[1], and     */
  /* shift_reg[1] to shift_reg[2]                  */

  sec->shift_count = ((sec->shift_count) + 5)%3;

  return;
}
    
    

    
