// C++ classes for IIR filters
//
// Edward Daw, 2nd September 2000

#include <cstdio>
#include <cstdlib>
#include "logicals.h"
#include "IIRfilter_structures.hh"
#include "IIRfilter.hh"
#include "IIRfilter_bank.hh"
#include <iostream>
 
using namespace std;

IIRfilter_bank::
IIRfilter_bank(const string& filename )
{
  if(get_filter_specs_from_file(filename, &no_of_filters) == -1 ) {
    exit(0);
  }
}

int 
IIRfilter_bank::
get_filter_specs_from_file(const string& filename, int* pno_of_filters) {
  // open file and read number of filters

  FILE* bank_file = fopen(filename.c_str(), "r");
  if( bank_file == NULL ) {
    cout << "ERROR: Cannot open " << filename << "." << endl;
    return -1;
  }

  if (fscanf(bank_file, "%d", pno_of_filters) != 1) {
    cerr << "Error in filter bank file syntax." << endl;
    return -1;
  }

  // allocate array space for filters
  filter_data = new IIRfilter [ *pno_of_filters ] ();

  int filter_counter;
  int section_counter;
  char filter_name[20];
  int filter_samp_rate;
  int no_of_sections_in_filter;
  double fset[5];
  for(filter_counter = 0;
      filter_counter < (*pno_of_filters);
      filter_counter++) {

    if (fscanf(bank_file, "%s", filter_name) <= 0 ||
	fscanf(bank_file, "%d", &filter_samp_rate) != 1 ||
	fscanf(bank_file, "%d", &no_of_sections_in_filter) != 1) {
      cerr << "Error in filter bank file syntax." << endl;
      return -1;
    }

    (filter_data + filter_counter)->
      set_name_srate_and_size( no_of_sections_in_filter,
			       filter_name,
			       filter_samp_rate );
    
    for(section_counter = 0;
	section_counter < no_of_sections_in_filter;
	section_counter++ ) {
      if (fscanf(bank_file,"%lf\t%lf\t%lf\t%lf\t%lf",
		 fset,fset+1,fset+2,fset+3,fset+4) != 5)  {
	cerr << "Error in filter bank file syntax." << endl;
	return -1;
      }

      (filter_data + filter_counter)->set_sos_coeff( fset , section_counter );
    }
  }
  fclose(bank_file);

  // (filter_data +2)->put_filter_data();

  _bank_loaded = 1;
  return 0;
}

// The filter number
// is 0 for the first filter in the bank and (order-1) for the last.

int
IIRfilter_bank::get_order( int filter_index,
			   int* porder )
{
  *porder = (filter_data + filter_index) -> no_of_sos_in_filter;
  return 0;
}

// function to get sampling rate for any individual filter;
int IIRfilter_bank::get_sampling_rate( int filter_index,
				       int* psampling_rate )
{
  *psampling_rate = (filter_data + filter_index)->sampling_rate;
  return 0;
}

// function to get filter name
char* IIRfilter_bank::get_filter_name( int filter_index )
{
  return (filter_data + filter_index)->filter_name;
}

// functions to get individual filter coefficients

int IIRfilter_bank::get_b0( int filter_index,
			    int section_index,
			    double* pb0 )
{
  (filter_data + filter_index)->get_b0( section_index, pb0 );
  return 0;
}

int IIRfilter_bank::get_b1( int filter_index,
			    int section_index,
			    double* pb1 )
{
  (filter_data + filter_index)->get_b1( section_index, pb1 );
  return 0;
}

int IIRfilter_bank::get_b2( int filter_index,
			    int section_index,
			    double* pb2 )
{
  (filter_data + filter_index)->get_b2( section_index, pb2 );
  return 0;
}

int IIRfilter_bank::get_a1( int filter_index,
			    int section_index,
			    double* pa1 )
{
  (filter_data + filter_index)->get_a1( section_index, pa1 );
  return 0;
}

int IIRfilter_bank::get_a2( int filter_index,
			    int section_index,
			    double* pa2 )
{
  (filter_data + filter_index)->get_a2( section_index, pa2 );
  return 0;
}

// destructor
IIRfilter_bank::~IIRfilter_bank( )
{
  // clear the filter array, and implicitly clear
  // the arrays of filter coefficients stored in each filter.
  delete [] filter_data;
}


















