#ifndef __SPECTRUM_FOLD_HH__
#define __SPECTRUM_FOLD_HH__

#include "DatEnv.hh"
#include "MonServer.hh"
#include "FixedLenTS.hh"
#include "Trend.hh"
#include <string>

//
//    Data Monitor template class.

/**  @name SpectrumFold
  *  @memo 
  *  The SpectrumFold monitor is designed to measure an excess in power at bins
  *  spaced at multiples of a given frequency (defaulting to 0.25 Hz)
  *
  *  {\bf {\Large Running SpectrumFold}}
  *
  *  The SpectrumFold command line syntax is:
  *  \begin{verbatim}
        SpectrumFold [-frames <number>] [-stride <time>] \
                    [-filter <filter>] [-settle <s-time>] [-dvIndex] \
		    [-f-start <freq>] [-f-stop <freq>] [-fold-length <freq>] \
		    [-channel <channel>] 
     \end{verbatim}
  *  The #<number># argument specifies the number of data strides to process
  *  before terminating the program. The #<time># argument specifies the data
  *  stride. If "-dvIndex" is specified, a trend index file will be written
  *  to '\$DMTOUTPUT/channel.cnf'.
  *
  *  -f-start and -f-stop specify the starting and ending frequencies of summation
  *  -fold-length specifies multiples of what frequency should be considered.
  *
  *  -channel instructs SpectrumFold to add this channel to the list of monitored
  *  channels with parameter values specified just before this option. 
  *  For example, -f-stop 1500.0 -channel H1:LSC-AS_Q -f-stop 300.0 H0:PEM_MIC1
  *  will assign f-stop=1500 to AS_Q channel and f-stop=300.0 to microphone channel
  *
  *  {\bf {\Large Configuration File}}
  *
  *  SpectrumFold uses a fixed configuration. There is therfore no 
  *  configuration file
  *
  *  {\bf {\Large SpectrumFold Output}}
  *
  *  {\bf Trend channels}
  *  SpectrumFold produces a minute trend of all folded bins as well
  *  as SFT level. All channel names start with SpectrumFold
  *
  *  {\bf Monitor data channels}
  *  SpectrumFold publishes a time series history of the folded bins as
  *  well as average SFT level. All channel names start with SpectrumFold
  *
  *  @author Vladimir Dergachev; University of Michigan
  *  @version 0.10; Last modified November 21, 2004
  */
//{
//}

class Pipe;

class BIN_DATA {
    public:
    BIN_DATA(void);
    
    std::string name;     
    FixedLenTS  mHistory;           
	};

class CHAN_DATA {
    public:
    CHAN_DATA(void);
    
    std::string name;       //  Channel name
    std::string mFilter;        //  Filter description
    Pipe*       mPipe;          // Pipe pointer
    
    float	f_start;	// Starting fold frequency
    float	f_stop;		// Ending fold frequency
    float	fold_length;    //  length of spectrum fold step (default: 0.25 Hz)    
    
    BIN_DATA *bins;
    int bins_size;
    int bins_free;    
    
    BIN_DATA SFT_level;
    BIN_DATA veto2;
    BIN_DATA count;
	};

class SpectrumFold : public DatEnv, MonServer {
public:
    SpectrumFold(int argc, const char *argv[]);  // Constructor
    ~SpectrumFold(void);                         // Destructor
    void ProcessData(void);                     // Process 1 data stride
    void Attention(void);                       // Handle Message signal.
  void add_channel(const std::string& chan_name, float f_start, 
		   float f_stop, float fold_length, 
		   const std::string& mFilter);
private:
    int         maxFrame;       //  Number of frames to process
    Trend       mTrend;         //  Trend writer
    Interval    mSettle;        //  Settling time.
    Interval    mStep;          //  Time stride.
    int debug;                  //  debugging level
    //  Channel data and trend name
    
    CHAN_DATA  *channels;
    int chan_size;
    int chan_free;

    void ProcessChannelData(int ch);                     // Process 1 data stride
};

#endif     //  __SPECTRUM_FOLD_HH__
