/* -*- mode: c++; c-basic-offset: 3; -*- */
#include "THTFD.hh"
#include "TVirtualPad.h"

//======================================  Default constructor
THTFD::THTFD(void) {
}

//======================================  Equal spacing y axis
THTFD::THTFD(const char *name, const char *title, Int_t nbinsx, Double_t xlow,
	     Double_t xup, Int_t nbinsy, Double_t ylow, Double_t yup)
  : TH2D(name, title, nbinsx, xlow, xup, nbinsy, ylow, yup)
{
}

//======================================  Enumerated y axis
THTFD::THTFD(const char *name, const char *title, Int_t nbinsx, Double_t xlow,
	     Double_t xup, Int_t nbinsy, const Double_t *ybins) 
  : TH2D(name, title, nbinsx, xlow, xup, nbinsy, ybins)
{}


//======================================  Enumerated y axis
void 
THTFD::ShiftX(Int_t nShift, const Double_t* col, Bool_t update_axis) {
   if (!nShift) return;
   Double_t* ar00 = GetArray(); 
   Int_t Ny = GetNbinsY() + 2;
   Int_t Nx = GetNbinsX() + 2;

   //-----------------------------------  Shift left
   //  Root histogram bins are stored in the order:
   //  index = binx + nx*biny
   //  where nx = fXaxis.GetNbins()+2
   //
   if (nShift < 0) {
      Int_t nCol = -nShift;
      Int_t nMov = Nx - nCol - 1;
      Double_t* arji = ar00 + Nx;
      for (Int_t iy=1; iy < Ny-1; ++iy) {
	 //-----------------------------  shift by nCol columns
	 for (Int_t j=0; j<=nMov; j++) {
	    *arji = arji[nCol];
	    arji++;
	 }

	 //-----------------------------  Fill new data into last columns
	 for (Int_t j=0; j<nCol; j++) *arji++ = *col++;
	 *arji++ = 0; // clear the overflow bin
      }
   } 

   //-----------------------------------  Shift to the right
   else {
      Int_t nCol = nShift;
      Int_t nMov = Nx - nCol - 1;
      Double_t* arji = ar00 + Nx;
      for (Int_t iy=0; iy <= Ny; ++iy) {
	 for (Int_t j=nMov; j>0; --j) {
	    arji[j+nCol] = arji[j];
	 }
	 arji[0] = 0; // clear underflow bin
	 for (Int_t j=1; j<=nCol; j++) arji[j] = *col++;
	 arji += Nx;
      }
   }

   //-----------------------------------  Update the axis limits.
   if (update_axis) {
      TAxis& xax = *GetXaxis();
      Int_t    nx = xax.GetNbins();
      Double_t dx = Double_t(nShift) * xax.GetBinWidth(1);
      xax.Set(nx, xax.GetXmin() - dx, xax.GetXmax() - dx);
   }
}
