#ifndef RAYLEIGHCONFIG_HH
#define RAYLEIGHCONFIG_HH 

#include <cstdio>

/* -*- mode: c++; c-basic-offset: 3; -*- */
const int max_channame_length = 30;
const int max_file_path_length = 200;
 

/** The RayleighConfig class reads a configuration file containing 
  * input parameters and passes them to the RayleighMonitor class DMT monitor.
  * Adapted from RmsConfig by Ed Daw.
  * @memo Configuration tool for the RayleighMonitor class DMT monitor. 
  * @author Patrick J. Sutton
  * @version 6.1; Last Modified 2002/08/16. 
  */
class RayleighConfig {
 
  public:
 
    /** Construct a RayleighConfig object.
      * @memo Constructor.
      * @param input_param_file_name   Name of configuration file. 
      */
    RayleighConfig(const char* input_param_file_name ); 

    /** Destroy a RayleighConfig object.
      * @memo Destructor.  
      */
    ~RayleighConfig();
 
    /** Verify that N, Stride parameters are acceptable.  Returns?
      * @memo Verify that N, Stride parameters are acceptable.  Returns?
      */
    bool CheckParameters();  

    /** Length of each data segment (sec). 
      * @memo Length of each data segment (sec).
      */
    double Stride;  

    /** Number of data segments to average. 
      * @memo Number of data segments to average. 
      */
    int N; 

    /** Maximum number of strides to process. 
      * @memo Maximum number of strides to process.      
      */
    int MaxStride;  

    /** Number of channels to process. 
      * @memo Number of channels to process. 
      */
    int number_of_channels;

    /** Pointer to list of channel names. 
      * @memo Pointer to list of channel names. 
      */
    char** channel_names;

    /** Pointer to list of channel rates. 
      * @memo Pointer to list of channel rates. 
      */
    int* channel_rates;

    /** Minimum frequency to analyze.
      * @memo Minimum frequency to analyze. 
      */
    double* f_lower;

    /** Maximum frequency to analyze.
      * @memo Maximum frequency to analyze. 
      */
    double* f_upper;

  private:

};

#endif     //  RAYLEIGHCONFIG_HH  
