/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef PCALMON_HH
#define PCALMON_HH

// startincludes
#include "DatEnv.hh"
#include "MonServer.hh"
#include "OperStateCondList.hh"
#include "FixedLenTS.hh"
#include "Trend.hh"
#include "TrigClient.hh"
#include "SegAccountant.hh"
#include "autopipe.hh"
#include <string>
// endincludes


/**  @name PCalMon
  *  @memo Photon Calibration Monitor
  *
  *  For the Method used, see: LIGO-P1300120 "Spectral Line Monitoring Tool"
  *
  *  {\bf {\Large Running PCalMon}}
  *
  *  The PCalMon command line syntax is:
  *  \begin{verbatim}
        PCalMon [-c <channel>] [-f <frequency>] [-frames <number>] [-stride <time>] \
     \end{verbatim}
  *  The channel and frequencies arguments can be repeated. 
  *  The optional frame argument specifies the number of data strides to process
  *  before terminating the program. The stride argument specifies the data stride. 
  *
  *  {\bf {\Large Configuration File}}
  *
  *  PCalMon configuration file format is pending.
  *
  *  {\bf {\Large PCalMon Output}}
  *
  *  {\bf Trend channels}
  *  PCalMon produces minute trends of line amplitudes at specified frequencies
  *
  *  {\bf Monitor data channels}
  *  PCalMon publishes a time series history of the amplitude values 
  *
  *  @author Greg Mendell; LIGO Hanford Observatory
  *  @version 1.0; Started November 3, 2014
  */
//{
//}

// classdef
class PCalMon : public DatEnv, MonServer 
{
public:
    PCalMon(int argc, const char *argv[]);  // Constructor
    ~PCalMon(void);                         // Destructor
    void ProcessData(void);                     // Process 1 data stride
    void Attention(void);                       // Handle Message signal.
private:
    int         maxFrame;       //  Number of frames to process
    Interval    mStep;          //  Time stride.
    Trend       mTrend;         //  Trend writer
    std::vector<char *> channelName; // array of data channels
    std::vector<char *> frequencies; // array of frequencies at which to find amplitudes 
    int nChan;                       // number of channels
    std::vector<char      *> amplitude_name;    // array of output amplitude channel names 
    std::vector<FixedLenTS*> amplitude_tseries; // array of time series output amplitudes
    OperStateCondList  *mOsclist;  // Container for Operating State Conditions (IFO Locked Conditions)
    std::string mOsc_file_name;   // File that defines the Operating State Conditions 
    std::string mOsc_cond;        // The condition to check, as defined in the mOsc_file_name
    std::string mFilter;        //  Filter description (Not yet implemented.) 
    Interval    mSettle;        //  Settling time.
    auto_pipe   mPipe;          // Pipe pointer
    double      mLowLimit;
    double      mHiLimit;
    bool        mSeg;
    TrigClient  mTClient;
    trig::SegAccountant mSegAcct;
    typedef trig::SegAccountant::seg_id segid_type;
    segid_type mLoSegId;
    segid_type mHiSegId;
};

#endif     //  PCALMON_HH
