#ifndef WPIPE_PARAM_LIST_HH
#define WPIPE_PARAM_LIST_HH
#include "wtypes.hh"
#include <iosfwd>

class Time;

namespace wpipe {
  class param_list {
  public:
    param_list(void);
    virtual ~param_list(void);
    void add_param(const std::string& name, int& var);
    void add_param(const std::string& name, double& var);
    void add_param(const std::string& name, std::string& var);
    void add_param(const std::string& name, dble_vect& var);
    void add_param(const std::string& name, str_vect& var);
    void add_param(const std::string& name, Time& var);
    void add_param(const std::string& name, bool& var);
    std::ostream& display(std::ostream& out, const std::string& pfx=0) const;
    void set_param(const std::string& name, const std::string& value);
  private:
    enum param_type {
      tInt,
      tDouble,
      tString,
      tNumVec,
      tStrVec,
      tTime,
      tBool
    };
    union param_ptr {
      int*         i;
      double*      d;
      std::string* s;
      dble_vect*   dv;
      str_vect*    sv;
      Time*        t;
      bool*        b;
    };
    struct param {
      bool operator==(const std::string& name) const {return _name == name;}
      std::string _name;
      param_type  _type;
      param_ptr   _par;
    };
    typedef std::vector<param> param_vect;
    typedef param_vect::iterator param_iter;
    typedef param_vect::const_iterator const_param_iter;
    param_iter find(const std::string& name);
    const_param_iter find(const std::string& name) const;
  private:
    param_vect  _list;
  };
} // namespace wpipe

#endif // !defined(WPIPE_PARAM_LIST_HH)
