#ifndef MEDIAN_MEAN_AVERAGE_PSD_HH
#define MEDIAN_MEAN_AVERAGE_PSD_HH
// MEDIANMEANAVERAGESPECTRUM - power spectrum estimation a la FINDCHIRP.
//
// usage
//
//   S = medianmeanaveragespectrum(data,fs,N,w)
//
// data      Vector of noise data.
// fs        Scalar.  Sample rate [Hz].  Must be a positive integer.
// N         Scalar.  Desired FFT length [samples].  Must be a power of 2.
// w         Optional vector.  Window to be used in FFT [default hann].
//           If specified, it must be of length N.
//
// S         Resulting PSD estimate.
//
// The power spectrum S is estimated using the median-mean algorithm of the
// FINDCHIRP pipeline (gr-qc/0509116).  The data is segmented in segments of
// length N samples with 50% overlap between consecutive segments and FFTed.  
// The segments are grouped into two sets on non-overlapping segments, the
// median power in each set is computed, and the two median estimates are
// then averaged to give S.  The use of the median gives some robustness
// against glitches in the input data stream.
//
// Note that the data length must be an integer multiple of N.  Also, the
// window, if (specified, is normalized to unity RMS for computing S.
//
// The output power spectrum is one-sided and has units Hz^(-1/2).  For
// example, white noise of variance sigma^2 will have a power spectrum of 
//
//   S = 2 sigma^2 / fs;
// 
// The first and last frequency bins (DC and Nyquist) typically have about
// 2/3 the value of S as the other bins.
//
#include "fSeries/PSD.hh"
class TSeries;
class Window;

namespace wpipe {

  containers::PSD medianmeanaveragespectrum(const TSeries& data, double fs, 
					    int N, Window* w=0);

} // namespace wpipe

#endif  //  !defined(MEDIAN_MEAN_AVERAGE_PSD_HH)
