/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef GDSPLOT_HH
#define GDSPLOT_HH

#include <string>
class TCanvas;
class TSeries;
class DVector;
class TH1;

namespace containers {
    class PSD;
}

class GDSPlot {
public:
    GDSPlot(TCanvas* tc=0);
    void boxes(size_t nbox, const double* x0, const double* x1, 
	       const double* y0, const double* y1, const double* z);
    void new_plot(void);
    void plot(const containers::PSD& psd);
    void plot(const TSeries& ts);
    void plot(const DVector& dvec, double xmin, double dx, 
	      const std::string& title=0);
    void print(const std::string& file) const;
    void set_canvas(TCanvas* tc);
    void set_color(int trace_col);
    void set_palette(void);
    void set_range(double xmin, double xmax, double ymin, double ymax);

    /**  Set the smoothing. the \a nSmooth argument indicates the number 
      *  of smoothing passes are to be performed. Setting this argument 
      *  zero disables smoothing. The \a smoothOpt argument soecifies the 
      *  kernel to be used. 2D kernels include "k5a" (five points in each
      *  direction, default), "k5b" stronger than k5a, and "k3a".
      *  \brief Set smoothing parameters.
      *  \param nSmooth Number of smoothing passes or zero.
      *  \param smoothOpt Smoothing kernel.
      */
    void set_smooth(int nSmooth, const std::string& smoothOpt);

    /**  Set the graphics style. The default id (0) sets pads to flat white, 
      *  disables stsatistics boxes, etc. This function is used in the 
      *  constructor.
      *  \brief Set the graphics style.
      *  \param id Style identifier.
      */
    void set_style(int id=0);

    /**  Set the plot size in.
      *  \brief set plot size.
      *  \param xsize X dimension in cm.
      *  \param ysize Y dimension in cm.
      */
    void set_size(double xsize, double ysize) const;
    void set_zrange(double zmin, double zmax);
    void surf(int nx, const double* x, int ny, const double* y, 
	      const double* z);
    void title(const std::string& titl);
    void xlabel(const std::string& titl);
    void xlog(bool logx=true);
    double xTimeScale(double dt, const std::string& xttl="Time");
    
    void ylabel(const std::string& titl);
    void ylog(bool logy=true);

    void zlabel(const std::string& titl);

private:
    /** Set the title and axis labels from the stored values.
     */
    void set_axes(TH1& histo);

private:
    TCanvas* mCanvas;
    int    mTrace;
    double mXmin;
    double mXmax;
    double mYmin;
    double mYmax;
    double mZmin;
    double mZmax;
    bool   mLogX;
    bool   mLogY;
    int    mPalletID;
    int    mNextColor;
    int    mNSmooth;
    std::string mTitle;
    std::string mXlabel;
    std::string mYlabel;
    std::string mZlabel;
    std::string mSmoothOpt;
};
#endif // !defined(GDSPLOT_HH)

