////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//                                OmegaMon.hh                                 //
//                                                                            //
//              DMT interface to Omega Online trigger properties              //
//                                                                            //
//                      Zhang Fan <zf19830622@gmail.com>                      //
//              Shourov K. Chatterji <shourov@ligo.caltech.edu>               //
//                                                                            //
//                                2009-Jan-19                                 //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

// $Id: OmegaMon.hh 5427 2009-01-22 22:44:49Z shourov.chatterji $


#ifndef OMEGAMON_HH
#define OMEGAMON_HH

#include "DatEnv.hh"
#include "MonServer.hh"
#include "TrigClient.hh"
#include "Trend.hh"
#include "TSeries.hh"
#include "FixedLenTS.hh"
#include "OperStateCondList.hh"
#include "DVecType.hh"
#include <string>
#include <vector>
#include <stdexcept>

//
//   DMT interface to Omega Online trigger properties

/**  @name OmegaMon
  *  @memo DMT interface to Omega Online trigger properties
  *  OmegaMon is a monitor that ingests triggers from the Omega Online analysis,
  *  computed summary statistics, and makes these statistics available as trend
  *  frame files and data objects that can be viewed using DMT Viewer.
  *
  *  usage:
  *
  *  \begin{verbatim}
        OmegaMon
     \end{verbatim}
  *
  *  @author Zhang Fan; zf19830622@gmail.com;
  *  @author Shourov K. Chatterji; shourov@ligo.caltech.edu
  *  @version 1.1; Last modified 2009-Jan-15
  */
//{
//}

class OmegaMon : public DatEnv, MonServer {

public:

  OmegaMon(int argc, const char *argv[]);     // Constructor
  ~OmegaMon(void);                            // Destructor
  void ProcessData(void);                     // Process 1 data stride
  void Attention(void);                       // Handle Message signal.

private:

  int         maxFrame;       //  Number of frames to process
  Interval    mStep;          //  Time stride.
  Trend       mTrend;         //  Trend writer
  std::string mChannel;       //  Channel name
  std::string mFilter;        //  Filter description
  Interval    mSettle;        //  Settling time.
  std::string mSigmaName;     //  Channel data and trend name
  FixedLenTS  mHistory;       //  X sigma history.

};

#endif // OMEGAMON_HH
