#ifndef __CINT__
#include <time.h>
#include <iostream>
#include <fstream>
#include <string.h>
#include "TSeries.hh"
#include "Time.hh"
#include "Hanning.hh"
#include "VoltWatcher.hh"
#include "VoltWriter.hh"
#include "VoltBase.hh"
#include "VWMath.cc"
#endif

using namespace std;

   VoltWatcher::VoltWatcher (DaccAPI& In, int ID, const char* configfile, 
			     u_short bufSize)
     : _ID(ID), _chanName (0), _VWrite(0), _bufSize(bufSize), TS(0), 
       _bufStat(EVEN), _bufCount(0), _errStat(false)
   {
     GetConfiguration(In, configfile);		// Gets _chanName, _offset, _scale from config.vw
   
      dt = 0.00048828125;			// 1/2048
      n = 2048 * bufSize;			// This may not be safe
      S = new basicplx<float>[n];		// Initialize complex array
      window.setWindow(n);			// Initialize Hanning object
   }

   VoltWatcher::VoltWatcher(char* channel, float offset, float scale, 
			    int ID, u_short bufSize)
   : _ID(ID), _chanName(channel), _VWrite(0), _bufSize(bufSize), 
     _offset(offset), _scale(scale), TS(0), _bufStat(EVEN), _bufCount(0), 
     _errStat(false)
   {
      dt = 0.00048828125;			 // 1/2048
      n = 2048 * bufSize;			 // This may not be safe
      S = new basicplx<float>[n];		 // Initialize complex array
      window.setWindow(n);			 // Initialize Hanning object
   }

   // size_t VoltWatcher::Fill()
   // {
      // In.fillData(1.0,true);
   // 
   // // This returns the fill time, not the current time //
      // return (In.getCurrentTime().getS() - 1);
   // }

   void VoltWatcher::AppendBuffers()
   {
      TSeries* tVoltP = ( _bufStat==EVEN ? &tVolt_even : &tVolt_odd);
   
      if(_bufCount==_bufSize) {tVoltP->Clear(); _bufCount = 0;}		
      else if (_bufCount==_bufSize-1) _bufStat=(_bufStat==EVEN? ODD : EVEN);
   
      tVoltP->Append(*TS);
      _bufCount++;
   }

   int VoltWatcher::Analyze()
   {
      TSeries* tVoltP = (_bufStat==ODD ? &tVolt_even : &tVolt_odd);
   
      *tVoltP -= _offset;					// Removes DC offset
      *tVoltP /= _scale;					// Scales amplitude to Volts
      window(*tVoltP).getData(n,S);			// Loads buffer into the array
   
      u_long t = tVoltP->getStartTime().getS();	// GPS time of buffer's
   									// 1st Fill()
   
      float rms = RMS();					// RMS
      float crest = fabs(tVoltP->getMinimum());
      if(tVoltP->getMaximum() > crest)		// Finds highest or lowest value
         crest = tVoltP->getMaximum();
      float factor = (crest/rms);			// Crest Factor
   
      float maxF = ApproxMaxF(60.0);		// Frequency
      float thd =0;						// Harmonics & THD
   
   // ALL "setData"s MUST COME AFTER "setTimeArray"
   
      if(_VWrite)
      {
         _VWrite->setTimeArray(_ID, t);
         _VWrite->setData(_ID, v_RMS, rms);		
         _VWrite->setData(_ID, v_FACTOR, factor);
         _VWrite->setData(_ID, v_MAXF, maxF);
      }
      else cout << _chanName << " has no writer\n";
   
      thd = Harmonics(maxF);				// Harmonics uses setData itself
      if(_VWrite) _VWrite->setData(_ID, v_THD, thd);
   
   
      return _ID;
   }

   // void VoltWatcher::Delay(const u_short delay)
   // {
      // In.seek(Now());		// Ignore "jumpy" data at beginning
   // 
      // if (delay < 60) {
         // cout<<"Waiting "<<60-In.getCurrentTime().getS()%60
            // <<" seconds... "; cout.flush();
      // 
         // do Fill(); while(In.getCurrentTime().getS()%60 != delay);
      // }
      // cout<<" READY!\n";
   // }

   // void VoltWatcher::Watch (const u_short duration, const u_short delay)
   // {
      // _bufStat = EVEN;					// Initialize
      // _bufCount = 0;
   // 
      // Delay(delay);
   // 
      // for(int count=0; duration==0 || count<duration*_bufSize; count++)
      // {
         // Fill();
         // AppendBuffers();
      // 
         // if(_bufCount == _bufSize) Analyze();
      // }
   // }

   void VoltWatcher::GetConfiguration (DaccAPI& In, const char* configfile)
   {
      ifstream getConfig(configfile);			// Open configuration file
      int checkID = -1;
   
      while(!getConfig.eof())
      {
         getConfig.ignore(9999, '#');			// Find an ID number
         getConfig >> checkID;				// Put ID in checkID
         if(checkID != _ID) 
            continue;			// Retry if IDs don't match
      
         _chanName = new char[80];			// Allocate memory for name
         getConfig.ignore(9999, '$');			// Find channel name
         if(!getConfig)
         {
            strcpy (_chanName , "NONAME");
            break;
         }
         getConfig.get(_chanName, 80, '\t');	// Put name in string
      
         while(getConfig.peek()=='\t')	getConfig.ignore(1);	// Skip tabs
         getConfig >> _offset;
         while(getConfig.peek()=='\t')	getConfig.ignore(1);	// Skip tabs
         getConfig >> _scale;
         while(getConfig.peek()=='\t')	getConfig.ignore(1);	// Skip tabs
         int samp = 0; getConfig >> samp;
      
         if(!getConfig) { ErrMsg("NOT configured"); 
            return; }
      
         if(samp < 2048) { ErrMsg("sampling rate is too low"); 
            return; }
      
         double x = log(double(samp))/log(2.0);
         if( x != floor(x) ) { ErrMsg(" sampling rate is invalid"); 
            return; }
         samp /= 2048;
      
         TestChannel(In, samp);
         if(_errStat == true) 
            return;
      
         cout << _chanName << " configured (ID# "<<_ID<<")\n";
         return;
      }
   
      ErrMsg("configuration not found");
   }

   void VoltWatcher::TestChannel(DaccAPI& In, const int decim8)
   {
   // Test for a duplicate of the channel name	
      if(In.isChannelRead(_chanName) == true)
      {
         ErrMsg("channel already requested");
         return;
      }
   
   // If the channel name is new, add it to the list
      In.addChannel(_chanName, decim8, &TS);
   
   // Test whether the channel exists - fillData() returns -3 if it isn't found
   // and -4 if it is having trouble reading frames
      int DACCerr = In.fillData(0.1);
      if(DACCerr == -3)
      {
         In.rmChannel(_chanName);
         _errStat = true; 
         return;
      }
      
      else if(DACCerr == -4)
      {
         cout << "There was an error reading a frame - "
            << "try typing \"smrepair\" at the command line\n";
         exit(-4);
      }
   
   // If the channel exists, say so and get back to GetConfiguration()
      cout << _chanName << " was found ... ";
   }
