//
// TriggerFiles class implementation
//
#include <iostream>
#include <cstdlib>
#include <cstring>
#include <stdexcept>
#include <glob.h>
#include "TriggerFiles.hh"

using namespace std;

//===================================== default constructor
TriggerFiles::TriggerFiles(void)
  : mTe(0)
{
}

//===================================== constructor with path and time
TriggerFiles::TriggerFiles(const string& path, const unsigned long t0)
  : mT0(t0), mTe(0), mPath(path)
{
}

//===================================== destructor
TriggerFiles::~TriggerFiles(void)
{
}

//===================================== dump the contents of the hash
ostream&
TriggerFiles::Dump(ostream& out) const
{
  filemap_t::const_iterator il;
  filemap_t::const_iterator iendl = mFiles.end();
  
  for ( il = mFiles.begin(); il != iendl; ++il )
    out << il->second.name << " " << il->first << " " << il->second.length 
      << endl;

  return out;
}

//===================================== set an end time for testing
void TriggerFiles::setEndTime(const unsigned long& te)
{
  mTe = te;
}

//===================================== update and return new files
vector< string >
TriggerFiles::newFiles(void)
{
  vector< string > result;
  
  // glob all files in the specified directory
  glob_t xmlFiles;
  size_t gl_i;
  memset( &xmlFiles, 0, sizeof(glob_t) );
  if ( glob( (mPath + "/*.xml").c_str() , GLOB_ERR, NULL, &xmlFiles ) )
    throw runtime_error( string("error globing directory ") + mPath );

  // look for any new files in the globbed list
  filemap_t::const_iterator i;
  triggerfile_t newFile;

  for ( gl_i = 0; gl_i < xmlFiles.gl_pathc; ++gl_i )
  {
    // extract the gps time and the length from the globbed file
    string thisFile(xmlFiles.gl_pathv[gl_i]);
    unsigned int gpsEndPos   = thisFile.find_last_of("-");
    unsigned int gpsStartPos = thisFile.find_last_of("-",--gpsEndPos);
    char *pEnd;
    unsigned long thisGPSTime = strtoul( ( thisFile.substr(
            ++gpsStartPos, ++gpsEndPos - gpsStartPos
            ) ).c_str(), &pEnd, 10 );
    unsigned long thisLength = strtoul( (thisFile.substr( 
            ++gpsEndPos, thisFile.find_last_of(".") - gpsEndPos - 1
            )).c_str(), &pEnd, 10 );

    // if the any part of the file is within the requested time
    if ( (! mTe || thisGPSTime + thisLength < mTe) && 
        (thisGPSTime + thisLength > mT0) )
    {
      // add it to the hash if it's not already there
      i = mFiles.find(thisGPSTime);
      if ( i == mFiles.end() )
      {
        // store the filename and length
        newFile.name = thisFile.substr(thisFile.find_last_of("/") + 1);
        newFile.length = thisLength;
        mFiles[thisGPSTime] = newFile;
        // and add the fill path to the vector to be returned
        result.push_back(thisFile);
      }
    }
  }

  // free the memory used by glob
  globfree( &xmlFiles );
  
  return result;
}

//===================================== flush old files and update t0
void
TriggerFiles::flushOld(const unsigned long t0)
{
  mT0 = t0;
  
  filemap_t::const_iterator il;
  for ( il = mFiles.begin(); il != mFiles.end(); ++il )
    if ( il->first + il->second.length < mT0 )
      mFiles.erase(il->first);

  return;
}
