#include "xsil/MetaTable.hh"
#include "xsil/table.hh"
#include "xsil/column.hh"
#include "xsil/stream.hh"
#include "xsil/ligolw.hh"
#include "xsil/Xwriter.hh"
#include "PConfig.h"
#ifdef __GNU_STDC_OLD
#include <gnusstream.h>
#else
#include <sstream>
#endif

using namespace xsil;
using namespace std;

//======================================  Default constructor
MetaTable::MetaTable(void) 
  :  mRow(0)
{
    refStream().delimit(',');
}

//======================================  Data constructor
MetaTable::MetaTable(const char* Name, const char* Type) 
  :  mGroup(Name), mCList(), mRow(0)
{
    setName(getTableName().c_str());
    refStream().delimit(',');
    refStream().setName(getTableName().c_str());
    mCList.clear();
}

//======================================  Copy constructor
MetaTable::MetaTable(const MetaTable& x) 
  :  table(x), mGroup(x.mGroup), mCList(), mRow(x.mRow)
{
}

//======================================  Destructor
MetaTable::~MetaTable(void) {
}

//======================================  Clone a MetaTable
// MetaTable*
// MetaTable::Clone(void) const {
//     return new MetaTable(*this);
// }

void 
MetaTable::check(const char* title, int csiz) const {
    if (!csiz) {
        cout << "MetaTable check at: " << title << endl;
	cout << "Group: " << mGroup << " # rows is: " << mRow << endl;
    }
    for (col_iter i=mCList.begin() ; i != mCList.end() ; i++) {
	if (csiz) {
	    long offset = long(i->data_Addr)-long(this);
	    if (offset < 0 || offset > csiz) 
	      cout << "Error found in MetaTable: " << mGroup 
		   << " at: " << title << ". Offset=" << offset 
		   << " c-size=" << csiz << endl;
	} else {
	    cout << "Type: "   << i->data_Type 
		 << " Addr: "  << long(i->data_Addr)
		 << " Param: " << i->data_Param << endl;
	}
    }
}

//======================================  Clear the table
void
MetaTable::clear(void) {
    mCList.clear();
}

//======================================  Define a column
void
MetaTable::defineColumn(const char* Name, const int* Addr) {
    addColumn(column(getItemName(Name).c_str(), "int_4s"));
    mCList.push_back(eventcolumn(eventcolumn::t_int4s, Addr));
}

void
MetaTable::defineColumn(const char* Name, const long* Addr) {
    addColumn(column(getItemName(Name).c_str(), "int_8s"));
    mCList.push_back(eventcolumn(eventcolumn::t_longs, Addr));
}

void
MetaTable::defineColumn(const char* Name, const char* Addr, bool ilwc) {
    if (ilwc) addColumn(column(getItemName(Name).c_str(), "ilwd:char"));
    else      addColumn(column(getItemName(Name).c_str(), "lstring"));
    mCList.push_back(eventcolumn(eventcolumn::t_chars, Addr));
}

void
MetaTable::defineColumn(const char* Name, const string* Addr, bool ilwc) {
    if (ilwc) addColumn(column(getItemName(Name).c_str(), "ilwd:char"));
    else      addColumn(column(getItemName(Name).c_str(), "lstring"));
    mCList.push_back(eventcolumn(eventcolumn::t_string, Addr));
}

void
MetaTable::defineColumn(const char* Name, const UCVec* Addr) {
    addColumn(column(getItemName(Name).c_str(), "ilwd:char_u"));
    mCList.push_back(eventcolumn(eventcolumn::t_charu, Addr));
}

void
MetaTable::defineColumn(const char* Name, const float* Addr) {
    addColumn(column(getItemName(Name).c_str(), "real_4"));
    mCList.push_back(eventcolumn(eventcolumn::t_real4, Addr));
}

void
MetaTable::defineColumn(const char* Name, const double* Addr) {
    addColumn(column(getItemName(Name).c_str(), "real_8"));
    mCList.push_back(eventcolumn(eventcolumn::t_real8, Addr));
}

void
MetaTable::defineColumn(const char* Name, const MetaTable* Addr,
			      const char* Col) {
    if (!Col) Col = Name;
    addColumn(column(getItemName(Name).c_str(), "ilwd:char"));
    mCList.push_back(eventcolumn(eventcolumn::t_cite, Addr, Col));
}

//======================================  Enter a new row into the table
void
MetaTable::putRow(void) {
    mRow++;
    for (col_iter i=mCList.begin() ; i != mCList.end() ; i++) {
        if (!i->data_Addr) {
	    refStream().Add("00");
        } else {
	    bool escsp = false;
	    switch (i->data_Type) {
	    case eventcolumn::t_none:
	        break;
	    case eventcolumn::t_int4s:
	        refStream().Add( *(const int*)i->data_Addr );
		break;
	    case eventcolumn::t_longs:
	        refStream().Add( double(*(const long*)i->data_Addr) );
		break;
	    case eventcolumn::t_chars:
	        if (i->data_Param == "ilwd:char") escsp = true;
	        refStream().Add( (const char*)i->data_Addr, escsp);
		break;
	    case eventcolumn::t_string:
	        if (i->data_Param == "ilwd:char") escsp = true;
	        refStream().Add( *(const string*)i->data_Addr, escsp);
		break;
	    case eventcolumn::t_real4:
	        refStream().Add( *(float*)i->data_Addr );
		break;
	    case eventcolumn::t_real8:
	        refStream().Add( *(double*)i->data_Addr );
		break;
	    case eventcolumn::t_charu:
	        refStream().Add( *(UCVec*)i->data_Addr );
		break;
	    case eventcolumn::t_cite:
	        const MetaTable* cite = (MetaTable*)i->data_Addr;
		refStream().Add(cite->citeTable(i->data_Param));
	    }
	}
    }
    refStream().lineBreak();
}

//======================================  Generate a table citation.
string
MetaTable::citeTable(const string& column) const {
    return citeTable(column, mRow-1);
}

string
MetaTable::citeTable(const string& column, int row) const {
    ostringstream id;
    id << mGroup << ":" << column << ":" << row;
    return id.str();
}

//======================================  Clear the table stream.
void
MetaTable::resetStream(void) {
    refStream().Clear();
    mRow = 0;
}

//======================================  Return the table name
string
MetaTable::getTableName(void) const {
    return getItemName("table");
}

//======================================  Return the name of an item
string
MetaTable::getItemName(const string& Name) const {
    return mGroup + "group:" + mGroup + ":" + Name;
}

//======================================  Event column stuff

MetaTable::eventcolumn::eventcolumn(void) 
  : data_Type(t_none), data_Addr(0), data_Param("")
{}

MetaTable::eventcolumn::eventcolumn(d_type d, const void* a, const char* p) 
  : data_Type(d), data_Addr(a), data_Param("")
{
    if (p) data_Param = p;
}

MetaTable::eventcolumn::~eventcolumn(void) {
}
