//
//    Dump shared memory partition status.
//
//
#include "lsmp.hh"
#include <stdlib.h>
#include <fstream>
#include <iostream>
#include <string>

int main(int argc, const char *argv[]) {
    bool syntax(false);
    const char *name = getenv("LIGOSMPART");
    int inx(1), jBuf(-1), len(0);
    if (std::string(argv[inx]) == "length") {
        len = strtol(argv[++inx], 0, 0);
	inx++;
    }
    if (argc > inx+2) name = argv[inx++];
    if (inx < argc) {
        char* ptr;
        jBuf = strtol(argv[inx++], &ptr, 0);
	if (*ptr) {
	    std::cerr << "smspew: Illegal buffer ID specified" << std::endl;
	    syntax = true;
	}
    } else {
        std::cerr << "smspew: Buffer ID not specified" << std::endl;
        syntax = true;
    }
    if (inx >= argc) {
        std::cerr << "smspew: Not enough arguments specified" << std::endl;
        syntax = true;
    }
    if (syntax) {
        std::cerr << "Syntax:" << std::endl;
        std::cerr << "smspew [length <len>] [<partition-name>] <buffer> <ofile>" 
		  << std::endl;
	return 1;}

    //----------------------------------  Open the output file
    std::ofstream fout(argv[inx]);
    if (!fout.good()) {
        std::cerr << "Unable to open file " << argv[inx] << std::endl;
	return 4;
    }

    //----------------------------------  Attach the partition.
    LSMP_ACCESS* part = new LSMP_ACCESS(name);
    if (!part || !part->valid()) {
        std::cerr << "Unable to attach partition " << name << std::endl;
	return 2;
    }

    //----------------------------------  Check the buffer number
    if (jBuf < 0 || jBuf >= part->getBufferCount()) {
        std::cerr << "Invalid buffer id (" << jBuf << " for partition " << name
		  << std::endl;
	return 3;
    }

    //----------------------------------  Spew the buffer
    part->Spew(jBuf, fout, len);

    //----------------------------------  Clean up and go away
    delete part;
    fout.close();
    return 0;
}
