#include "lmsg/Buffer.hh"
#include "lmsg/BufferPool.hh"
#include <new>

lmsg::Buffer::~Buffer(void) {
    if (mLocalData) delete[] mData;
}

lmsg::Buffer::Buffer(size_type size, char* data) 
  :  mSize(size), mLength(0), mPool(0), mLocalData(false)
{
    if (data) {
        mData = data;
    } else {
        size_type nDoubles = (mSize + sizeof(double) - 1) / sizeof(double);
        mData = reinterpret_cast<char*>(new double[nDoubles]);
	mLocalData = true;
    }
}

void 
lmsg::Buffer::Return(void) {
    if (!mPool) delete this;
    else        mPool->returnBuffer(this);
}

void
lmsg::Buffer::setLength(size_type length) {
    mLength = length;
}

void
lmsg::Buffer::setDataLength(size_type length) {
    mLength = length + sizeof(MsgHeader);
}

void 
lmsg::Buffer::setPool(BufferPool& pool) {
    mPool = &pool;
}




