#include "html/color.hh"
#include "html/writer.hh"

//======================================  Construct a default color specifier
html::color::color(void)
  : mMode(k_default), mRed(0), mGreen(0), mBlue(0)
{}

//======================================  Specify a color from the RGB numbers
html::color::color(int red, int green, int blue)
  : mMode(k_rgb), mRed(red), mGreen(green), mBlue(blue)
{}

//======================================  Specify a color by name
html::color::color(const std::string& clr)
  : mMode(k_named), mName(clr)
{}

//======================================  Color destructor
html::color::~color(void) {}

//======================================  Clone a color specifier
html::color*
html::color::clone(void) const {
    return new color(*this);
}

//======================================  Internal numeric conversion.
static void 
puti(std::string& x, int n, int w=0, int r=10, char p=' ') {
    int d=n/r;
    if (w > 1 || d) puti(x,d,w-1,r,p);
    x += "0123456789ABCDEF"[n%r];
}


//======================================  Test for default color.
bool 
html::color::isDefault(void) const {
    return mMode == k_default;
}

//======================================  Print attribute list
void 
html::color::putAttr(writer& w) const {
    std::string txt;
    switch (mMode) {
    case k_default:
        break;
    case k_rgb:
        txt = "\"#";
	puti(txt, mRed,   2, 16, '0');
	puti(txt, mGreen, 2, 16, '0');
	puti(txt, mBlue,  2, 16, '0');
	txt += "\"";
	break;
    case k_named:
        txt = mName;
    }
    w.text(txt);
}

//======================================  Set color to default.
void 
html::color::setDefault(void) {
    mMode = k_default;
}

//======================================  Set color
void 
html::color::setRGB(int red, int green, int blue) {
    mMode = k_rgb;
    mRed = red;
    mGreen = green;
    mBlue = blue;
}

//======================================  Set color.
void 
html::color::setColorName(const std::string& name) {
    mMode = k_named;
    mName = name;
}

//======================================  Compare colors.
bool 
html::color::operator==(const color& x) const {
    switch (mMode) {
    case k_default:
        if (x.mMode == k_default) return true;
        break;
    case k_rgb:
        if (x.mMode == k_rgb && mBlue == x.mBlue && 
	    mGreen == x.mGreen && mRed == x.mRed) return true;
	break;
    case k_named:
        if (x.mMode == k_named && mName == x.mName) return true;
    }
    return false;
}




