#include "html/Table2C.hh"
#include "html/text.hh"

using namespace html;
using namespace std;

Table2C::Table2C(const char* ttl, const char* c1ttl, const char* c2ttl) 
  : table(ttl) 
{
    if (c1ttl) addColumn(c1ttl);
    else       addColumn("Parameter");

    if (c2ttl) addColumn(c2ttl);
    else       addColumn("Value");
}

Table2C::~Table2C(void) {}

void 
Table2C::addRow(const string& c1, const string& c2) {
    int i=table::addRow();
    insertData(i, 0, text(c1));
    insertData(i, 1, text(c2));
}

void 
Table2C::addRow(const string& c1, double c2) {
    int i=table::addRow();
    insertData(i, 0, text(c1));
    insertData(i, 1, text(c2));
}

void 
Table2C::addRow(const string& c1, const Time& c2, const char* fmt) {
    int i=table::addRow();
    insertData(i, 0, text(c1));
    insertData(i, 1, text(c2, fmt));
}
