{
printf("LIGO Root initialization starting.\n");
//--------------------------------------  Enable the standard I/O
// G__loadfile("iostream.h");

//--------------------------------------  Load the shared libraries.
printf("Loading libraries from <LIBDIR>\n");
gSystem->Load("<LIBDIR>/libgdsbase.so");
gSystem->Load("<LIBDIR>/libgdscntr.so");
gSystem->Load("<LIBDIR>/libclient.so");
gSystem->Load("<LIBDIR>/libframeio.so");
gSystem->Load("<LIBDIR>/libdmtsigp.so");
gSystem->Load("<LIBDIR>/libxsil.so");
gSystem->Load("<LIBDIR>/libgdsevent.so");
// gSystem->Load("<LIBDIR>/libdmtsigp.so");
// gSystem->Load("<LIBDIR>/libdmtsigp.so");
if (!gROOT->IsBatch()) {
    gSystem->Load("<LIBDIR>/libligogui.so");
    gSystem->Load("<LIBDIR>/libdttview.so");
    gSystem->Load("<LIBDIR>/libgdsplot.so");
    TString fi("<LIBDIR>/");
    const char* DmtHome = gSystem->Getenv("DMTHOME");
    if (DmtHome) fi.ReplaceAll("$DMTHOME", DmtHome);
} else {
    printf("Graphics libraries not loaded: Batch mode.\n");
}

//--------------------------------------  Set up the include directories.
G__add_ipath("<TARGET>/share/gds/macros");
G__add_ipath("<TARGET>/include");

//--------------------------------------  Create a data access object.
Dacc In;
const char* InPath = gSystem->Getenv("DMTINPUT");
// if (!InPath || !*InPath) InPath = "<DMTINPUT>";
if (InPath && *InPath) {
    printf("Connecting default input accessor (In) to %s.\n", InPath);
    In.addFile(InPath);
    In.open();
} else {
    printf("Default input accessor (In) not opened. No input file specified.\n");
}

//--------------------------------------  Create a display canvas.
if (!gROOT->IsBatch()) {
    TCanvas gds("cGDS", "GDS Data Monitor Tool");
}

//--------------------------------------  Load some common functions.
gROOT->LoadMacro("uniqueName.cc");
gROOT->LoadMacro("TPlot.cc");
gROOT->LoadMacro("THist.cc");
gROOT->LoadMacro("Bode.cc");
gROOT->LoadMacro("Spectrum.cc");
gROOT->LoadMacro("DatEnv.hh");
// gROOT->LoadMacro("DatEnv.cc");
gROOT->LoadMacro("pTrend.cc");

printf("Root initialization complete\n");
}
