//
//    fast fourier transforms.
//
#include "Complex.hh"

typedef float    FLOAT;
typedef double   FLINT;  // internal floating point results
typedef fComplex COMPLEX;

struct fftplan {
  struct data_struct {
    data_struct() : WSave(0), NAlloc(0), LastN(0) {}
    FLOAT* WSave;
    unsigned int NAlloc;
    unsigned int LastN;
  };
  data_struct c;
  data_struct r;
};

void cffti(int n, FLOAT* wsave);
void cfftf(int n, FLOAT* r, FLOAT* wsave);
void cfftb(int n, FLOAT* r, FLOAT* wsave);
void cfftp(int n, FLOAT* wsave);

void rffti(int n, FLOAT* wsave);
void rfftf(int n, const FLOAT* x, COMPLEX* y, FLOAT* wsave);
//void rfftb(int n, const FLOAT* x, COMPLEX* y, FLOAT* wsave);

// static const FLOAT tpi = 6.28318530717959;


