/******************************************************************************
 * $Id: ogr_arcgen.h bc3d9f5351962c422f3e57a9ab1a251d91659192 2020-05-09 21:07:14 +0200 Even Rouault $
 *
 * Project:  Arc/Info Generate Translator
 * Purpose:  Definition of classes for OGR .arcgen driver.
 * Author:   Even Rouault, even dot rouault at spatialys.com
 *
 ******************************************************************************
 * Copyright (c) 2011, Even Rouault <even dot rouault at spatialys.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMARCGENS OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 ****************************************************************************/

#ifndef OGR_ARCGEN_H_INCLUDED
#define OGR_ARCGEN_H_INCLUDED

#include "ogrsf_frmts.h"

/************************************************************************/
/*                          OGRARCGENLayer                              */
/************************************************************************/

class OGRARCGENLayer final: public OGRLayer, public OGRGetNextFeatureThroughRaw<OGRARCGENLayer>
{
    OGRFeatureDefn*    poFeatureDefn;

    VSILFILE*          fp;
    bool               bEOF;

    int                nNextFID;

    OGRFeature *       GetNextRawFeature();

  public:
                        OGRARCGENLayer(const char* pszFilename,
                                    VSILFILE* fp, OGRwkbGeometryType eType);
                        virtual ~OGRARCGENLayer();

    virtual void                ResetReading() override;
    DEFINE_GET_NEXT_FEATURE_THROUGH_RAW(OGRARCGENLayer)

    virtual OGRFeatureDefn *    GetLayerDefn() override { return poFeatureDefn; }

    virtual int                 TestCapability( const char * ) override;
};

/************************************************************************/
/*                        OGRARCGENDataSource                           */
/************************************************************************/

class OGRARCGENDataSource final: public OGRDataSource
{
    char*               pszName;

    OGRLayer**          papoLayers;
    int                 nLayers;

  public:
                        OGRARCGENDataSource();
               virtual ~OGRARCGENDataSource();

    int                 Open( const char * pszFilename );

    virtual const char*         GetName() override { return pszName; }

    virtual int                 GetLayerCount() override { return nLayers; }
    virtual OGRLayer*           GetLayer( int ) override;

    virtual int                 TestCapability( const char * ) override;
};

#endif /* ndef OGR_ARCGEN_H_INCLUDED */
