GDAL - Geospatial Data Abstraction Library
====

[![Build Status](https://travis-ci.com/OSGeo/gdal.svg?branch=master)](https://travis-ci.com/OSGeo/gdal)
[![Build status](https://ci.appveyor.com/api/projects/status/jtwx0pcr0y01i17p/branch/master?svg=true)](https://ci.appveyor.com/project/OSGeo/gdal)
[![Build Status](https://scan.coverity.com/projects/749/badge.svg?flat=1)](https://scan.coverity.com/projects/gdal)
[gdalautotest coverage](https://gdalautotest-coverage-results.github.io/coverage_html/index.html)

| Tested configurations    |
| ------------------------ |
| Ubuntu 14.04 32 bit      |
| Ubuntu 14.04 64 bit      |
| Ubuntu 16.04 64 / CL 3.9 |
| Ubuntu 18.04 64 bit      |
| Python 3                 |
| MacOS X                  |
| MSVC 2015-64b & 2017-32b |
| MinGW_W64                |
| Android                  |
| Big endian host          |
| GCC 5.2 C++14 -fsanitize |
| Clang Static Analyzer    |
| Coverity Scan            |

GDAL is an open source X/MIT licensed translator library for raster and vector geospatial data formats.

* Main site: http://www.gdal.org - Developer and user docs, links to other resources
* GIT repository: https://github.com/OSGeo/gdal
* Bug tracker: https://github.com/OSGeo/gdal
* Download: http://download.osgeo.org/gdal
* Wiki: http://trac.osgeo.org/gdal - Various user and developer contributed documentation and hints
* Mailing list: http://lists.osgeo.org/mailman/listinfo/gdal-dev

### How to contribute

See [CONTRIBUTING.md](CONTRIBUTING.md)

### Docker images

See [gdal/docker/](gdal/docker/)

### Citing GDAL/OGR in publications

See [CITATION](CITATION)
