//  { dg-do run }

// test boolean return from await_suspend ().

#include "../coro.h"

struct coro1 {
  struct promise_type;
  using handle_type = coro::coroutine_handle<coro1::promise_type>;
  handle_type handle;
  coro1 () : handle(0) {}
  coro1 (handle_type _handle)
    : handle(_handle) {
        PRINT("Created coro1 object from handle");
  }
  coro1 (const coro1 &) = delete; // no copying
  coro1 (coro1 &&s) : handle(s.handle) {
	s.handle = nullptr;
	PRINT("coro1 mv ctor ");
  }
  coro1 &operator = (coro1 &&s) {
	handle = s.handle;
	s.handle = nullptr;
	PRINT("coro1 op=  ");
	return *this;
  }
  ~coro1() {
        PRINT("Destroyed coro1");
        if ( handle )
          handle.destroy();
  }

  struct suspend_never_prt {
  bool await_ready() const noexcept { return true; }
  bool await_suspend(handle_type) const noexcept {
    PRINT ("susp-never-susp"); // never executed.
    return true; // ...
  }
  void await_resume() const noexcept {PRINT ("susp-never-resume");}
  ~suspend_never_prt() {};
  };

  struct  suspend_always_prt {
  bool await_ready() const noexcept { return false; }
  bool await_suspend(handle_type) const noexcept {
    PRINT ("susp-always-susp, but we're going to continue.. ");
    return false; // not going to suspend.
  }
  void await_resume() const noexcept { PRINT ("susp-always-resume");}
  };

  struct promise_type {
  promise_type() {  PRINT ("Created Promise"); }
  ~promise_type() { PRINT ("Destroyed Promise"); }

  coro1 get_return_object () {
    PRINT ("get_return_object: from handle from promise");
    return coro1 (handle_type::from_promise (*this));
  }
  auto initial_suspend () {
    PRINT ("get initial_suspend (always, but really never) ");
    return suspend_always_prt{};
  }
  auto final_suspend () {
    PRINT ("get final_suspend (always, but never) ");
    return suspend_always_prt{};
  }
  void return_void () {
    PRINT ("return_void ()");
  }
  void unhandled_exception() { PRINT ("** unhandled exception"); }
  };
};

struct coro1
f () noexcept
{
  PRINT ("coro1: about to return");
  co_return;
}

int main ()
{
  PRINT ("main: create coro1");
  struct coro1 x = f ();
  auto p = x.handle.promise ();
  auto aw = p.initial_suspend();
  auto f = aw.await_suspend(coro::coroutine_handle<coro1::promise_type>::from_address ((void *)&x));
  PRINT ("main: got coro1 - should be done");
  if (!x.handle.done())
    {
      PRINT ("main: apparently was not done...");
      abort ();
    }
  PRINT ("main: returning");
  return 0;
}
