/* Subroutines used for code generation on IBM RS/6000.
   Copyright (C) 1991-2019 Free Software Foundation, Inc.
   Contributed by Richard Kenner (kenner@vlsi1.ultra.nyu.edu)

   This file is part of GCC.

   GCC is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published
   by the Free Software Foundation; either version 3, or (at your
   option) any later version.

   GCC is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with GCC; see the file COPYING3.  If not see
   <http://www.gnu.org/licenses/>.  */

#define IN_TARGET_CODE 1

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "backend.h"
#include "rtl.h"
#include "tree.h"
#include "memmodel.h"
#include "gimple.h"
#include "cfghooks.h"
#include "cfgloop.h"
#include "df.h"
#include "tm_p.h"
#include "stringpool.h"
#include "expmed.h"
#include "optabs.h"
#include "regs.h"
#include "ira.h"
#include "recog.h"
#include "cgraph.h"
#include "diagnostic-core.h"
#include "insn-attr.h"
#include "flags.h"
#include "alias.h"
#include "fold-const.h"
#include "attribs.h"
#include "stor-layout.h"
#include "calls.h"
#include "print-tree.h"
#include "varasm.h"
#include "explow.h"
#include "expr.h"
#include "output.h"
#include "dbxout.h"
#include "common/common-target.h"
#include "langhooks.h"
#include "reload.h"
#include "sched-int.h"
#include "gimplify.h"
#include "gimple-fold.h"
#include "gimple-iterator.h"
#include "gimple-ssa.h"
#include "gimple-walk.h"
#include "intl.h"
#include "params.h"
#include "tm-constrs.h"
#include "tree-vectorizer.h"
#include "target-globals.h"
#include "builtins.h"
#include "tree-vector-builder.h"
#include "context.h"
#include "tree-pass.h"
#include "except.h"
#if TARGET_XCOFF
#include "xcoffout.h"  /* get declarations of xcoff_*_section_name */
#endif
#if TARGET_MACHO
#include "gstab.h"  /* for N_SLINE */
#endif
#include "case-cfn-macros.h"
#include "ppc-auxv.h"
#include "tree-ssa-propagate.h"
#include "tree-vrp.h"
#include "tree-ssanames.h"

/* This file should be included last.  */
#include "target-def.h"

#ifndef TARGET_NO_PROTOTYPE
#define TARGET_NO_PROTOTYPE 0
#endif

  /* Set -mabi=ieeelongdouble on some old targets.  In the future, power server
     systems will also set long double to be IEEE 128-bit.  AIX and Darwin
     explicitly redefine TARGET_IEEEQUAD and TARGET_IEEEQUAD_DEFAULT to 0, so
     those systems will not pick up this default.  This needs to be after all
     of the include files, so that POWERPC_LINUX and POWERPC_FREEBSD are
     properly defined.  */
#ifndef TARGET_IEEEQUAD_DEFAULT
#if !defined (POWERPC_LINUX) && !defined (POWERPC_FREEBSD)
#define TARGET_IEEEQUAD_DEFAULT 1
#else
#define TARGET_IEEEQUAD_DEFAULT 0
#endif
#endif

static pad_direction rs6000_function_arg_padding (machine_mode, const_tree);

/* Structure used to define the rs6000 stack */
typedef struct rs6000_stack {
  int reload_completed;		/* stack info won't change from here on */
  int first_gp_reg_save;	/* first callee saved GP register used */
  int first_fp_reg_save;	/* first callee saved FP register used */
  int first_altivec_reg_save;	/* first callee saved AltiVec register used */
  int lr_save_p;		/* true if the link reg needs to be saved */
  int cr_save_p;		/* true if the CR reg needs to be saved */
  unsigned int vrsave_mask;	/* mask of vec registers to save */
  int push_p;			/* true if we need to allocate stack space */
  int calls_p;			/* true if the function makes any calls */
  int world_save_p;		/* true if we're saving *everything*:
				   r13-r31, cr, f14-f31, vrsave, v20-v31  */
  enum rs6000_abi abi;		/* which ABI to use */
  int gp_save_offset;		/* offset to save GP regs from initial SP */
  int fp_save_offset;		/* offset to save FP regs from initial SP */
  int altivec_save_offset;	/* offset to save AltiVec regs from initial SP */
  int lr_save_offset;		/* offset to save LR from initial SP */
  int cr_save_offset;		/* offset to save CR from initial SP */
  int vrsave_save_offset;	/* offset to save VRSAVE from initial SP */
  int varargs_save_offset;	/* offset to save the varargs registers */
  int ehrd_offset;		/* offset to EH return data */
  int ehcr_offset;		/* offset to EH CR field data */
  int reg_size;			/* register size (4 or 8) */
  HOST_WIDE_INT vars_size;	/* variable save area size */
  int parm_size;		/* outgoing parameter size */
  int save_size;		/* save area size */
  int fixed_size;		/* fixed size of stack frame */
  int gp_size;			/* size of saved GP registers */
  int fp_size;			/* size of saved FP registers */
  int altivec_size;		/* size of saved AltiVec registers */
  int cr_size;			/* size to hold CR if not in fixed area */
  int vrsave_size;		/* size to hold VRSAVE */
  int altivec_padding_size;	/* size of altivec alignment padding */
  HOST_WIDE_INT total_size;	/* total bytes allocated for stack */
  int savres_strategy;
} rs6000_stack_t;

/* A C structure for machine-specific, per-function data.
   This is added to the cfun structure.  */
typedef struct GTY(()) machine_function
{
  /* Flags if __builtin_return_address (n) with n >= 1 was used.  */
  int ra_needs_full_frame;
  /* Flags if __builtin_return_address (0) was used.  */
  int ra_need_lr;
  /* Cache lr_save_p after expansion of builtin_eh_return.  */
  int lr_save_state;
  /* Whether we need to save the TOC to the reserved stack location in the
     function prologue.  */
  bool save_toc_in_prologue;
  /* Offset from virtual_stack_vars_rtx to the start of the ABI_V4
     varargs save area.  */
  HOST_WIDE_INT varargs_save_offset;
  /* Alternative internal arg pointer for -fsplit-stack.  */
  rtx split_stack_arg_pointer;
  bool split_stack_argp_used;
  /* Flag if r2 setup is needed with ELFv2 ABI.  */
  bool r2_setup_needed;
  /* The number of components we use for separate shrink-wrapping.  */
  int n_components;
  /* The components already handled by separate shrink-wrapping, which should
     not be considered by the prologue and epilogue.  */
  bool gpr_is_wrapped_separately[32];
  bool fpr_is_wrapped_separately[32];
  bool lr_is_wrapped_separately;
  bool toc_is_wrapped_separately;
} machine_function;

/* Support targetm.vectorize.builtin_mask_for_load.  */
static GTY(()) tree altivec_builtin_mask_for_load;

/* Set to nonzero once AIX common-mode calls have been defined.  */
static GTY(()) int common_mode_defined;

/* Label number of label created for -mrelocatable, to call to so we can
   get the address of the GOT section */
static int rs6000_pic_labelno;

#ifdef USING_ELFOS_H
/* Counter for labels which are to be placed in .fixup.  */
int fixuplabelno = 0;
#endif

/* Whether to use variant of AIX ABI for PowerPC64 Linux.  */
int dot_symbols;

/* Specify the machine mode that pointers have.  After generation of rtl, the
   compiler makes no further distinction between pointers and any other objects
   of this machine mode.  */
scalar_int_mode rs6000_pmode;

#if TARGET_ELF
/* Note whether IEEE 128-bit floating point was passed or returned, either as
   the __float128/_Float128 explicit type, or when long double is IEEE 128-bit
   floating point.  We changed the default C++ mangling for these types and we
   may want to generate a weak alias of the old mangling (U10__float128) to the
   new mangling (u9__ieee128).  */
static bool rs6000_passes_ieee128;
#endif

/* Generate the manged name (i.e. U10__float128) used in GCC 8.1, and not the
   name used in current releases (i.e. u9__ieee128).  */
static bool ieee128_mangling_gcc_8_1;

/* Width in bits of a pointer.  */
unsigned rs6000_pointer_size;

#ifdef HAVE_AS_GNU_ATTRIBUTE
# ifndef HAVE_LD_PPC_GNU_ATTR_LONG_DOUBLE
# define HAVE_LD_PPC_GNU_ATTR_LONG_DOUBLE 0
# endif
/* Flag whether floating point values have been passed/returned.
   Note that this doesn't say whether fprs are used, since the
   Tag_GNU_Power_ABI_FP .gnu.attributes value this flag controls
   should be set for soft-float values passed in gprs and ieee128
   values passed in vsx registers.  */
static bool rs6000_passes_float;
static bool rs6000_passes_long_double;
/* Flag whether vector values have been passed/returned.  */
static bool rs6000_passes_vector;
/* Flag whether small (<= 8 byte) structures have been returned.  */
static bool rs6000_returns_struct;
#endif

/* Value is TRUE if register/mode pair is acceptable.  */
static bool rs6000_hard_regno_mode_ok_p
  [NUM_MACHINE_MODES][FIRST_PSEUDO_REGISTER];

/* Maximum number of registers needed for a given register class and mode.  */
unsigned char rs6000_class_max_nregs[NUM_MACHINE_MODES][LIM_REG_CLASSES];

/* How many registers are needed for a given register and mode.  */
unsigned char rs6000_hard_regno_nregs[NUM_MACHINE_MODES][FIRST_PSEUDO_REGISTER];

/* Map register number to register class.  */
enum reg_class rs6000_regno_regclass[FIRST_PSEUDO_REGISTER];

static int dbg_cost_ctrl;

/* Built in types.  */
tree rs6000_builtin_types[RS6000_BTI_MAX];
tree rs6000_builtin_decls[RS6000_BUILTIN_COUNT];

/* Flag to say the TOC is initialized */
int toc_initialized, need_toc_init;
char toc_label_name[10];

/* Cached value of rs6000_variable_issue. This is cached in
   rs6000_variable_issue hook and returned from rs6000_sched_reorder2.  */
static short cached_can_issue_more;

static GTY(()) section *read_only_data_section;
static GTY(()) section *private_data_section;
static GTY(()) section *tls_data_section;
static GTY(()) section *tls_private_data_section;
static GTY(()) section *read_only_private_data_section;
static GTY(()) section *sdata2_section;
static GTY(()) section *toc_section;

struct builtin_description
{
  const HOST_WIDE_INT mask;
  const enum insn_code icode;
  const char *const name;
  const enum rs6000_builtins code;
};

/* Describe the vector unit used for modes.  */
enum rs6000_vector rs6000_vector_unit[NUM_MACHINE_MODES];
enum rs6000_vector rs6000_vector_mem[NUM_MACHINE_MODES];

/* Register classes for various constraints that are based on the target
   switches.  */
enum reg_class rs6000_constraints[RS6000_CONSTRAINT_MAX];

/* Describe the alignment of a vector.  */
int rs6000_vector_align[NUM_MACHINE_MODES];

/* Map selected modes to types for builtins.  */
static GTY(()) tree builtin_mode_to_type[MAX_MACHINE_MODE][2];

/* What modes to automatically generate reciprocal divide estimate (fre) and
   reciprocal sqrt (frsqrte) for.  */
unsigned char rs6000_recip_bits[MAX_MACHINE_MODE];

/* Masks to determine which reciprocal esitmate instructions to generate
   automatically.  */
enum rs6000_recip_mask {
  RECIP_SF_DIV		= 0x001,	/* Use divide estimate */
  RECIP_DF_DIV		= 0x002,
  RECIP_V4SF_DIV	= 0x004,
  RECIP_V2DF_DIV	= 0x008,

  RECIP_SF_RSQRT	= 0x010,	/* Use reciprocal sqrt estimate.  */
  RECIP_DF_RSQRT	= 0x020,
  RECIP_V4SF_RSQRT	= 0x040,
  RECIP_V2DF_RSQRT	= 0x080,

  /* Various combination of flags for -mrecip=xxx.  */
  RECIP_NONE		= 0,
  RECIP_ALL		= (RECIP_SF_DIV | RECIP_DF_DIV | RECIP_V4SF_DIV
			   | RECIP_V2DF_DIV | RECIP_SF_RSQRT | RECIP_DF_RSQRT
			   | RECIP_V4SF_RSQRT | RECIP_V2DF_RSQRT),

  RECIP_HIGH_PRECISION	= RECIP_ALL,

  /* On low precision machines like the power5, don't enable double precision
     reciprocal square root estimate, since it isn't accurate enough.  */
  RECIP_LOW_PRECISION	= (RECIP_ALL & ~(RECIP_DF_RSQRT | RECIP_V2DF_RSQRT))
};

/* -mrecip options.  */
static struct
{
  const char *string;		/* option name */
  unsigned int mask;		/* mask bits to set */
} recip_options[] = {
  { "all",	 RECIP_ALL },
  { "none",	 RECIP_NONE },
  { "div",	 (RECIP_SF_DIV | RECIP_DF_DIV | RECIP_V4SF_DIV
		  | RECIP_V2DF_DIV) },
  { "divf",	 (RECIP_SF_DIV | RECIP_V4SF_DIV) },
  { "divd",	 (RECIP_DF_DIV | RECIP_V2DF_DIV) },
  { "rsqrt",	 (RECIP_SF_RSQRT | RECIP_DF_RSQRT | RECIP_V4SF_RSQRT
		  | RECIP_V2DF_RSQRT) },
  { "rsqrtf",	 (RECIP_SF_RSQRT | RECIP_V4SF_RSQRT) },
  { "rsqrtd",	 (RECIP_DF_RSQRT | RECIP_V2DF_RSQRT) },
};

/* Used by __builtin_cpu_is(), mapping from PLATFORM names to values.  */
static const struct
{
  const char *cpu;
  unsigned int cpuid;
} cpu_is_info[] = {
  { "power9",	   PPC_PLATFORM_POWER9 },
  { "power8",	   PPC_PLATFORM_POWER8 },
  { "power7",	   PPC_PLATFORM_POWER7 },
  { "power6x",	   PPC_PLATFORM_POWER6X },
  { "power6",	   PPC_PLATFORM_POWER6 },
  { "power5+",	   PPC_PLATFORM_POWER5_PLUS },
  { "power5",	   PPC_PLATFORM_POWER5 },
  { "ppc970",	   PPC_PLATFORM_PPC970 },
  { "power4",	   PPC_PLATFORM_POWER4 },
  { "ppca2",	   PPC_PLATFORM_PPCA2 },
  { "ppc476",	   PPC_PLATFORM_PPC476 },
  { "ppc464",	   PPC_PLATFORM_PPC464 },
  { "ppc440",	   PPC_PLATFORM_PPC440 },
  { "ppc405",	   PPC_PLATFORM_PPC405 },
  { "ppc-cell-be", PPC_PLATFORM_CELL_BE }
};

/* Used by __builtin_cpu_supports(), mapping from HWCAP names to masks.  */
static const struct
{
  const char *hwcap;
  int mask;
  unsigned int id;
} cpu_supports_info[] = {
  /* AT_HWCAP masks.  */
  { "4xxmac",		PPC_FEATURE_HAS_4xxMAC,		0 },
  { "altivec",		PPC_FEATURE_HAS_ALTIVEC,	0 },
  { "arch_2_05",	PPC_FEATURE_ARCH_2_05,		0 },
  { "arch_2_06",	PPC_FEATURE_ARCH_2_06,		0 },
  { "archpmu",		PPC_FEATURE_PERFMON_COMPAT,	0 },
  { "booke",		PPC_FEATURE_BOOKE,		0 },
  { "cellbe",		PPC_FEATURE_CELL_BE,		0 },
  { "dfp",		PPC_FEATURE_HAS_DFP,		0 },
  { "efpdouble",	PPC_FEATURE_HAS_EFP_DOUBLE,	0 },
  { "efpsingle",	PPC_FEATURE_HAS_EFP_SINGLE,	0 },
  { "fpu",		PPC_FEATURE_HAS_FPU,		0 },
  { "ic_snoop",		PPC_FEATURE_ICACHE_SNOOP,	0 },
  { "mmu",		PPC_FEATURE_HAS_MMU,		0 },
  { "notb",		PPC_FEATURE_NO_TB,		0 },
  { "pa6t",		PPC_FEATURE_PA6T,		0 },
  { "power4",		PPC_FEATURE_POWER4,		0 },
  { "power5",		PPC_FEATURE_POWER5,		0 },
  { "power5+",		PPC_FEATURE_POWER5_PLUS,	0 },
  { "power6x",		PPC_FEATURE_POWER6_EXT,		0 },
  { "ppc32",		PPC_FEATURE_32,			0 },
  { "ppc601",		PPC_FEATURE_601_INSTR,		0 },
  { "ppc64",		PPC_FEATURE_64,			0 },
  { "ppcle",		PPC_FEATURE_PPC_LE,		0 },
  { "smt",		PPC_FEATURE_SMT,		0 },
  { "spe",		PPC_FEATURE_HAS_SPE,		0 },
  { "true_le",		PPC_FEATURE_TRUE_LE,		0 },
  { "ucache",		PPC_FEATURE_UNIFIED_CACHE,	0 },
  { "vsx",		PPC_FEATURE_HAS_VSX,		0 },

  /* AT_HWCAP2 masks.  */
  { "arch_2_07",	PPC_FEATURE2_ARCH_2_07,		1 },
  { "dscr",		PPC_FEATURE2_HAS_DSCR,		1 },
  { "ebb",		PPC_FEATURE2_HAS_EBB,		1 },
  { "htm",		PPC_FEATURE2_HAS_HTM,		1 },
  { "htm-nosc",		PPC_FEATURE2_HTM_NOSC,		1 },
  { "htm-no-suspend",	PPC_FEATURE2_HTM_NO_SUSPEND,	1 },
  { "isel",		PPC_FEATURE2_HAS_ISEL,		1 },
  { "tar",		PPC_FEATURE2_HAS_TAR,		1 },
  { "vcrypto",		PPC_FEATURE2_HAS_VEC_CRYPTO,	1 },
  { "arch_3_00",	PPC_FEATURE2_ARCH_3_00,		1 },
  { "ieee128",		PPC_FEATURE2_HAS_IEEE128,	1 },
  { "darn",		PPC_FEATURE2_DARN,		1 },
  { "scv",		PPC_FEATURE2_SCV,		1 }
};

/* On PowerPC, we have a limited number of target clones that we care about
   which means we can use an array to hold the options, rather than having more
   elaborate data structures to identify each possible variation.  Order the
   clones from the default to the highest ISA.  */
enum {
  CLONE_DEFAULT		= 0,		/* default clone.  */
  CLONE_ISA_2_05,			/* ISA 2.05 (power6).  */
  CLONE_ISA_2_06,			/* ISA 2.06 (power7).  */
  CLONE_ISA_2_07,			/* ISA 2.07 (power8).  */
  CLONE_ISA_3_00,			/* ISA 3.00 (power9).  */
  CLONE_MAX
};

/* Map compiler ISA bits into HWCAP names.  */
struct clone_map {
  HOST_WIDE_INT isa_mask;	/* rs6000_isa mask */
  const char *name;		/* name to use in __builtin_cpu_supports.  */
};

static const struct clone_map rs6000_clone_map[CLONE_MAX] = {
  { 0,				"" },		/* Default options.  */
  { OPTION_MASK_CMPB,		"arch_2_05" },	/* ISA 2.05 (power6).  */
  { OPTION_MASK_POPCNTD,	"arch_2_06" },	/* ISA 2.06 (power7).  */
  { OPTION_MASK_P8_VECTOR,	"arch_2_07" },	/* ISA 2.07 (power8).  */
  { OPTION_MASK_P9_VECTOR,	"arch_3_00" },	/* ISA 3.00 (power9).  */
};


/* Newer LIBCs explicitly export this symbol to declare that they provide
   the AT_PLATFORM and AT_HWCAP/AT_HWCAP2 values in the TCB.  We emit a
   reference to this symbol whenever we expand a CPU builtin, so that
   we never link against an old LIBC.  */
const char *tcb_verification_symbol = "__parse_hwcap_and_convert_at_platform";

/* True if we have expanded a CPU builtin.  */
bool cpu_builtin_p;

/* Pointer to function (in rs6000-c.c) that can define or undefine target
   macros that have changed.  Languages that don't support the preprocessor
   don't link in rs6000-c.c, so we can't call it directly.  */
void (*rs6000_target_modify_macros_ptr) (bool, HOST_WIDE_INT, HOST_WIDE_INT);

/* Simplfy register classes into simpler classifications.  We assume
   GPR_REG_TYPE - FPR_REG_TYPE are ordered so that we can use a simple range
   check for standard register classes (gpr/floating/altivec/vsx) and
   floating/vector classes (float/altivec/vsx).  */

enum rs6000_reg_type {
  NO_REG_TYPE,
  PSEUDO_REG_TYPE,
  GPR_REG_TYPE,
  VSX_REG_TYPE,
  ALTIVEC_REG_TYPE,
  FPR_REG_TYPE,
  SPR_REG_TYPE,
  CR_REG_TYPE
};

/* Map register class to register type.  */
static enum rs6000_reg_type reg_class_to_reg_type[N_REG_CLASSES];

/* First/last register type for the 'normal' register types (i.e. general
   purpose, floating point, altivec, and VSX registers).  */
#define IS_STD_REG_TYPE(RTYPE) IN_RANGE(RTYPE, GPR_REG_TYPE, FPR_REG_TYPE)

#define IS_FP_VECT_REG_TYPE(RTYPE) IN_RANGE(RTYPE, VSX_REG_TYPE, FPR_REG_TYPE)


/* Register classes we care about in secondary reload or go if legitimate
   address.  We only need to worry about GPR, FPR, and Altivec registers here,
   along an ANY field that is the OR of the 3 register classes.  */

enum rs6000_reload_reg_type {
  RELOAD_REG_GPR,			/* General purpose registers.  */
  RELOAD_REG_FPR,			/* Traditional floating point regs.  */
  RELOAD_REG_VMX,			/* Altivec (VMX) registers.  */
  RELOAD_REG_ANY,			/* OR of GPR, FPR, Altivec masks.  */
  N_RELOAD_REG
};

/* For setting up register classes, loop through the 3 register classes mapping
   into real registers, and skip the ANY class, which is just an OR of the
   bits.  */
#define FIRST_RELOAD_REG_CLASS	RELOAD_REG_GPR
#define LAST_RELOAD_REG_CLASS	RELOAD_REG_VMX

/* Map reload register type to a register in the register class.  */
struct reload_reg_map_type {
  const char *name;			/* Register class name.  */
  int reg;				/* Register in the register class.  */
};

static const struct reload_reg_map_type reload_reg_map[N_RELOAD_REG] = {
  { "Gpr",	FIRST_GPR_REGNO },	/* RELOAD_REG_GPR.  */
  { "Fpr",	FIRST_FPR_REGNO },	/* RELOAD_REG_FPR.  */
  { "VMX",	FIRST_ALTIVEC_REGNO },	/* RELOAD_REG_VMX.  */
  { "Any",	-1 },			/* RELOAD_REG_ANY.  */
};

/* Mask bits for each register class, indexed per mode.  Historically the
   compiler has been more restrictive which types can do PRE_MODIFY instead of
   PRE_INC and PRE_DEC, so keep track of sepaate bits for these two.  */
typedef unsigned char addr_mask_type;

#define RELOAD_REG_VALID	0x01	/* Mode valid in register..  */
#define RELOAD_REG_MULTIPLE	0x02	/* Mode takes multiple registers.  */
#define RELOAD_REG_INDEXED	0x04	/* Reg+reg addressing.  */
#define RELOAD_REG_OFFSET	0x08	/* Reg+offset addressing. */
#define RELOAD_REG_PRE_INCDEC	0x10	/* PRE_INC/PRE_DEC valid.  */
#define RELOAD_REG_PRE_MODIFY	0x20	/* PRE_MODIFY valid.  */
#define RELOAD_REG_AND_M16	0x40	/* AND -16 addressing.  */
#define RELOAD_REG_QUAD_OFFSET	0x80	/* quad offset is limited.  */

/* Register type masks based on the type, of valid addressing modes.  */
struct rs6000_reg_addr {
  enum insn_code reload_load;		/* INSN to reload for loading. */
  enum insn_code reload_store;		/* INSN to reload for storing.  */
  enum insn_code reload_fpr_gpr;	/* INSN to move from FPR to GPR.  */
  enum insn_code reload_gpr_vsx;	/* INSN to move from GPR to VSX.  */
  enum insn_code reload_vsx_gpr;	/* INSN to move from VSX to GPR.  */
  addr_mask_type addr_mask[(int)N_RELOAD_REG]; /* Valid address masks.  */
  bool scalar_in_vmx_p;			/* Scalar value can go in VMX.  */
};

static struct rs6000_reg_addr reg_addr[NUM_MACHINE_MODES];

/* Helper function to say whether a mode supports PRE_INC or PRE_DEC.  */
static inline bool
mode_supports_pre_incdec_p (machine_mode mode)
{
  return ((reg_addr[mode].addr_mask[RELOAD_REG_ANY] & RELOAD_REG_PRE_INCDEC)
	  != 0);
}

/* Helper function to say whether a mode supports PRE_MODIFY.  */
static inline bool
mode_supports_pre_modify_p (machine_mode mode)
{
  return ((reg_addr[mode].addr_mask[RELOAD_REG_ANY] & RELOAD_REG_PRE_MODIFY)
	  != 0);
}

/* Return true if we have D-form addressing in altivec registers.  */
static inline bool
mode_supports_vmx_dform (machine_mode mode)
{
  return ((reg_addr[mode].addr_mask[RELOAD_REG_VMX] & RELOAD_REG_OFFSET) != 0);
}

/* Return true if we have D-form addressing in VSX registers.  This addressing
   is more limited than normal d-form addressing in that the offset must be
   aligned on a 16-byte boundary.  */
static inline bool
mode_supports_dq_form (machine_mode mode)
{
  return ((reg_addr[mode].addr_mask[RELOAD_REG_ANY] & RELOAD_REG_QUAD_OFFSET)
	  != 0);
}

/* Given that there exists at least one variable that is set (produced)
   by OUT_INSN and read (consumed) by IN_INSN, return true iff
   IN_INSN represents one or more memory store operations and none of
   the variables set by OUT_INSN is used by IN_INSN as the address of a
   store operation.  If either IN_INSN or OUT_INSN does not represent
   a "single" RTL SET expression (as loosely defined by the
   implementation of the single_set function) or a PARALLEL with only
   SETs, CLOBBERs, and USEs inside, this function returns false.

   This rs6000-specific version of store_data_bypass_p checks for
   certain conditions that result in assertion failures (and internal
   compiler errors) in the generic store_data_bypass_p function and
   returns false rather than calling store_data_bypass_p if one of the
   problematic conditions is detected.  */

int
rs6000_store_data_bypass_p (rtx_insn *out_insn, rtx_insn *in_insn)
{
  rtx out_set, in_set;
  rtx out_pat, in_pat;
  rtx out_exp, in_exp;
  int i, j;

  in_set = single_set (in_insn);
  if (in_set)
    {
      if (MEM_P (SET_DEST (in_set)))
	{
	  out_set = single_set (out_insn);
	  if (!out_set)
	    {
	      out_pat = PATTERN (out_insn);
	      if (GET_CODE (out_pat) == PARALLEL)
		{
		  for (i = 0; i < XVECLEN (out_pat, 0); i++)
		    {
		      out_exp = XVECEXP (out_pat, 0, i);
		      if ((GET_CODE (out_exp) == CLOBBER)
			  || (GET_CODE (out_exp) == USE))
			continue;
		      else if (GET_CODE (out_exp) != SET)
			return false;
		    }
		}
	    }
	}
    }
  else
    {
      in_pat = PATTERN (in_insn);
      if (GET_CODE (in_pat) != PARALLEL)
	return false;

      for (i = 0; i < XVECLEN (in_pat, 0); i++)
	{
	  in_exp = XVECEXP (in_pat, 0, i);
	  if ((GET_CODE (in_exp) == CLOBBER) || (GET_CODE (in_exp) == USE))
	    continue;
	  else if (GET_CODE (in_exp) != SET)
	    return false;

	  if (MEM_P (SET_DEST (in_exp)))
	    {
	      out_set = single_set (out_insn);
	      if (!out_set)
		{
		  out_pat = PATTERN (out_insn);
		  if (GET_CODE (out_pat) != PARALLEL)
		    return false;
		  for (j = 0; j < XVECLEN (out_pat, 0); j++)
		    {
		      out_exp = XVECEXP (out_pat, 0, j);
		      if ((GET_CODE (out_exp) == CLOBBER)
			  || (GET_CODE (out_exp) == USE))
			continue;
		      else if (GET_CODE (out_exp) != SET)
			return false;
		    }
		}
	    }
	}
    }
  return store_data_bypass_p (out_insn, in_insn);
}


/* Processor costs (relative to an add) */

const struct processor_costs *rs6000_cost;

/* Instruction size costs on 32bit processors.  */
static const
struct processor_costs size32_cost = {
  COSTS_N_INSNS (1),    /* mulsi */
  COSTS_N_INSNS (1),    /* mulsi_const */
  COSTS_N_INSNS (1),    /* mulsi_const9 */
  COSTS_N_INSNS (1),    /* muldi */
  COSTS_N_INSNS (1),    /* divsi */
  COSTS_N_INSNS (1),    /* divdi */
  COSTS_N_INSNS (1),    /* fp */
  COSTS_N_INSNS (1),    /* dmul */
  COSTS_N_INSNS (1),    /* sdiv */
  COSTS_N_INSNS (1),    /* ddiv */
  32,			/* cache line size */
  0,			/* l1 cache */
  0,			/* l2 cache */
  0,			/* streams */
  0,			/* SF->DF convert */
};

/* Instruction size costs on 64bit processors.  */
static const
struct processor_costs size64_cost = {
  COSTS_N_INSNS (1),    /* mulsi */
  COSTS_N_INSNS (1),    /* mulsi_const */
  COSTS_N_INSNS (1),    /* mulsi_const9 */
  COSTS_N_INSNS (1),    /* muldi */
  COSTS_N_INSNS (1),    /* divsi */
  COSTS_N_INSNS (1),    /* divdi */
  COSTS_N_INSNS (1),    /* fp */
  COSTS_N_INSNS (1),    /* dmul */
  COSTS_N_INSNS (1),    /* sdiv */
  COSTS_N_INSNS (1),    /* ddiv */
  128,			/* cache line size */
  0,			/* l1 cache */
  0,			/* l2 cache */
  0,			/* streams */
  0,			/* SF->DF convert */
};

/* Instruction costs on RS64A processors.  */
static const
struct processor_costs rs64a_cost = {
  COSTS_N_INSNS (20),   /* mulsi */
  COSTS_N_INSNS (12),   /* mulsi_const */
  COSTS_N_INSNS (8),    /* mulsi_const9 */
  COSTS_N_INSNS (34),   /* muldi */
  COSTS_N_INSNS (65),   /* divsi */
  COSTS_N_INSNS (67),   /* divdi */
  COSTS_N_INSNS (4),    /* fp */
  COSTS_N_INSNS (4),    /* dmul */
  COSTS_N_INSNS (31),   /* sdiv */
  COSTS_N_INSNS (31),   /* ddiv */
  128,			/* cache line size */
  128,			/* l1 cache */
  2048,			/* l2 cache */
  1,			/* streams */
  0,			/* SF->DF convert */
};

/* Instruction costs on MPCCORE processors.  */
static const
struct processor_costs mpccore_cost = {
  COSTS_N_INSNS (2),    /* mulsi */
  COSTS_N_INSNS (2),    /* mulsi_const */
  COSTS_N_INSNS (2),    /* mulsi_const9 */
  COSTS_N_INSNS (2),    /* muldi */
  COSTS_N_INSNS (6),    /* divsi */
  COSTS_N_INSNS (6),    /* divdi */
  COSTS_N_INSNS (4),    /* fp */
  COSTS_N_INSNS (5),    /* dmul */
  COSTS_N_INSNS (10),   /* sdiv */
  COSTS_N_INSNS (17),   /* ddiv */
  32,			/* cache line size */
  4,			/* l1 cache */
  16,			/* l2 cache */
  1,			/* streams */
  0,			/* SF->DF convert */
};

/* Instruction costs on PPC403 processors.  */
static const
struct processor_costs ppc403_cost = {
  COSTS_N_INSNS (4),    /* mulsi */
  COSTS_N_INSNS (4),    /* mulsi_const */
  COSTS_N_INSNS (4),    /* mulsi_const9 */
  COSTS_N_INSNS (4),    /* muldi */
  COSTS_N_INSNS (33),   /* divsi */
  COSTS_N_INSNS (33),   /* divdi */
  COSTS_N_INSNS (11),   /* fp */
  COSTS_N_INSNS (11),   /* dmul */
  COSTS_N_INSNS (11),   /* sdiv */
  COSTS_N_INSNS (11),   /* ddiv */
  32,			/* cache line size */
  4,			/* l1 cache */
  16,			/* l2 cache */
  1,			/* streams */
  0,			/* SF->DF convert */
};

/* Instruction costs on PPC405 processors.  */
static const
struct processor_costs ppc405_cost = {
  COSTS_N_INSNS (5),    /* mulsi */
  COSTS_N_INSNS (4),    /* mulsi_const */
  COSTS_N_INSNS (3),    /* mulsi_const9 */
  COSTS_N_INSNS (5),    /* muldi */
  COSTS_N_INSNS (35),   /* divsi */
  COSTS_N_INSNS (35),   /* divdi */
  COSTS_N_INSNS (11),   /* fp */
  COSTS_N_INSNS (11),   /* dmul */
  COSTS_N_INSNS (11),   /* sdiv */
  COSTS_N_INSNS (11),   /* ddiv */
  32,			/* cache line size */
  16,			/* l1 cache */
  128,			/* l2 cache */
  1,			/* streams */
  0,			/* SF->DF convert */
};

/* Instruction costs on PPC440 processors.  */
static const
struct processor_costs ppc440_cost = {
  COSTS_N_INSNS (3),    /* mulsi */
  COSTS_N_INSNS (2),    /* mulsi_const */
  COSTS_N_INSNS (2),    /* mulsi_const9 */
  COSTS_N_INSNS (3),    /* muldi */
  COSTS_N_INSNS (34),   /* divsi */
  COSTS_N_INSNS (34),   /* divdi */
  COSTS_N_INSNS (5),    /* fp */
  COSTS_N_INSNS (5),    /* dmul */
  COSTS_N_INSNS (19),   /* sdiv */
  COSTS_N_INSNS (33),   /* ddiv */
  32,			/* cache line size */
  32,			/* l1 cache */
  256,			/* l2 cache */
  1,			/* streams */
  0,			/* SF->DF convert */
};

/* Instruction costs on PPC476 processors.  */
static const
struct processor_costs ppc476_cost = {
  COSTS_N_INSNS (4),    /* mulsi */
  COSTS_N_INSNS (4),    /* mulsi_const */
  COSTS_N_INSNS (4),    /* mulsi_const9 */
  COSTS_N_INSNS (4),    /* muldi */
  COSTS_N_INSNS (11),   /* divsi */
  COSTS_N_INSNS (11),   /* divdi */
  COSTS_N_INSNS (6),    /* fp */
  COSTS_N_INSNS (6),    /* dmul */
  COSTS_N_INSNS (19),   /* sdiv */
  COSTS_N_INSNS (33),   /* ddiv */
  32,			/* l1 cache line size */
  32,			/* l1 cache */
  512,			/* l2 cache */
  1,			/* streams */
  0,			/* SF->DF convert */
};

/* Instruction costs on PPC601 processors.  */
static const
struct processor_costs ppc601_cost = {
  COSTS_N_INSNS (5),    /* mulsi */
  COSTS_N_INSNS (5),    /* mulsi_const */
  COSTS_N_INSNS (5),    /* mulsi_const9 */
  COSTS_N_INSNS (5),    /* muldi */
  COSTS_N_INSNS (36),   /* divsi */
  COSTS_N_INSNS (36),   /* divdi */
  COSTS_N_INSNS (4),    /* fp */
  COSTS_N_INSNS (5),    /* dmul */
  COSTS_N_INSNS (17),   /* sdiv */
  COSTS_N_INSNS (31),   /* ddiv */
  32,			/* cache line size */
  32,			/* l1 cache */
  256,			/* l2 cache */
  1,			/* streams */
  0,			/* SF->DF convert */
};

/* Instruction costs on PPC603 processors.  */
static const
struct processor_costs ppc603_cost = {
  COSTS_N_INSNS (5),    /* mulsi */
  COSTS_N_INSNS (3),    /* mulsi_const */
  COSTS_N_INSNS (2),    /* mulsi_const9 */
  COSTS_N_INSNS (5),    /* muldi */
  COSTS_N_INSNS (37),   /* divsi */
  COSTS_N_INSNS (37),   /* divdi */
  COSTS_N_INSNS (3),    /* fp */
  COSTS_N_INSNS (4),    /* dmul */
  COSTS_N_INSNS (18),   /* sdiv */
  COSTS_N_INSNS (33),   /* ddiv */
  32,			/* cache line size */
  8,			/* l1 cache */
  64,			/* l2 cache */
  1,			/* streams */
  0,			/* SF->DF convert */
};

/* Instruction costs on PPC604 processors.  */
static const
struct processor_costs ppc604_cost = {
  COSTS_N_INSNS (4),    /* mulsi */
  COSTS_N_INSNS (4),    /* mulsi_const */
  COSTS_N_INSNS (4),    /* mulsi_const9 */
  COSTS_N_INSNS (4),    /* muldi */
  COSTS_N_INSNS (20),   /* divsi */
  COSTS_N_INSNS (20),   /* divdi */
  COSTS_N_INSNS (3),    /* fp */
  COSTS_N_INSNS (3),    /* dmul */
  COSTS_N_INSNS (18),   /* sdiv */
  COSTS_N_INSNS (32),   /* ddiv */
  32,			/* cache line size */
  16,			/* l1 cache */
  512,			/* l2 cache */
  1,			/* streams */
  0,			/* SF->DF convert */
};

/* Instruction costs on PPC604e processors.  */
static const
struct processor_costs ppc604e_cost = {
  COSTS_N_INSNS (2),    /* mulsi */
  COSTS_N_INSNS (2),    /* mulsi_const */
  COSTS_N_INSNS (2),    /* mulsi_const9 */
  COSTS_N_INSNS (2),    /* muldi */
  COSTS_N_INSNS (20),   /* divsi */
  COSTS_N_INSNS (20),   /* divdi */
  COSTS_N_INSNS (3),    /* fp */
  COSTS_N_INSNS (3),    /* dmul */
  COSTS_N_INSNS (18),   /* sdiv */
  COSTS_N_INSNS (32),   /* ddiv */
  32,			/* cache line size */
  32,			/* l1 cache */
  1024,			/* l2 cache */
  1,			/* streams */
  0,			/* SF->DF convert */
};

/* Instruction costs on PPC620 processors.  */
static const
struct processor_costs ppc620_cost = {
  COSTS_N_INSNS (5),    /* mulsi */
  COSTS_N_INSNS (4),    /* mulsi_const */
  COSTS_N_INSNS (3),    /* mulsi_const9 */
  COSTS_N_INSNS (7),    /* muldi */
  COSTS_N_INSNS (21),   /* divsi */
  COSTS_N_INSNS (37),   /* divdi */
  COSTS_N_INSNS (3),    /* fp */
  COSTS_N_INSNS (3),    /* dmul */
  COSTS_N_INSNS (18),   /* sdiv */
  COSTS_N_INSNS (32),   /* ddiv */
  128,			/* cache line size */
  32,			/* l1 cache */
  1024,			/* l2 cache */
  1,			/* streams */
  0,			/* SF->DF convert */
};

/* Instruction costs on PPC630 processors.  */
static const
struct processor_costs ppc630_cost = {
  COSTS_N_INSNS (5),    /* mulsi */
  COSTS_N_INSNS (4),    /* mulsi_const */
  COSTS_N_INSNS (3),    /* mulsi_const9 */
  COSTS_N_INSNS (7),    /* muldi */
  COSTS_N_INSNS (21),   /* divsi */
  COSTS_N_INSNS (37),   /* divdi */
  COSTS_N_INSNS (3),    /* fp */
  COSTS_N_INSNS (3),    /* dmul */
  COSTS_N_INSNS (17),   /* sdiv */
  COSTS_N_INSNS (21),   /* ddiv */
  128,			/* cache line size */
  64,			/* l1 cache */
  1024,			/* l2 cache */
  1,			/* streams */
  0,			/* SF->DF convert */
};

/* Instruction costs on Cell processor.  */
/* COSTS_N_INSNS (1) ~ one add.  */
static const
struct processor_costs ppccell_cost = {
  COSTS_N_INSNS (9/2)+2,    /* mulsi */
  COSTS_N_INSNS (6/2),    /* mulsi_const */
  COSTS_N_INSNS (6/2),    /* mulsi_const9 */
  COSTS_N_INSNS (15/2)+2,   /* muldi */
  COSTS_N_INSNS (38/2),   /* divsi */
  COSTS_N_INSNS (70/2),   /* divdi */
  COSTS_N_INSNS (10/2),   /* fp */
  COSTS_N_INSNS (10/2),   /* dmul */
  COSTS_N_INSNS (74/2),   /* sdiv */
  COSTS_N_INSNS (74/2),   /* ddiv */
  128,			/* cache line size */
  32,			/* l1 cache */
  512,			/* l2 cache */
  6,			/* streams */
  0,			/* SF->DF convert */
};

/* Instruction costs on PPC750 and PPC7400 processors.  */
static const
struct processor_costs ppc750_cost = {
  COSTS_N_INSNS (5),    /* mulsi */
  COSTS_N_INSNS (3),    /* mulsi_const */
  COSTS_N_INSNS (2),    /* mulsi_const9 */
  COSTS_N_INSNS (5),    /* muldi */
  COSTS_N_INSNS (17),   /* divsi */
  COSTS_N_INSNS (17),   /* divdi */
  COSTS_N_INSNS (3),    /* fp */
  COSTS_N_INSNS (3),    /* dmul */
  COSTS_N_INSNS (17),   /* sdiv */
  COSTS_N_INSNS (31),   /* ddiv */
  32,			/* cache line size */
  32,			/* l1 cache */
  512,			/* l2 cache */
  1,			/* streams */
  0,			/* SF->DF convert */
};

/* Instruction costs on PPC7450 processors.  */
static const
struct processor_costs ppc7450_cost = {
  COSTS_N_INSNS (4),    /* mulsi */
  COSTS_N_INSNS (3),    /* mulsi_const */
  COSTS_N_INSNS (3),    /* mulsi_const9 */
  COSTS_N_INSNS (4),    /* muldi */
  COSTS_N_INSNS (23),   /* divsi */
  COSTS_N_INSNS (23),   /* divdi */
  COSTS_N_INSNS (5),    /* fp */
  COSTS_N_INSNS (5),    /* dmul */
  COSTS_N_INSNS (21),   /* sdiv */
  COSTS_N_INSNS (35),   /* ddiv */
  32,			/* cache line size */
  32,			/* l1 cache */
  1024,			/* l2 cache */
  1,			/* streams */
  0,			/* SF->DF convert */
};

/* Instruction costs on PPC8540 processors.  */
static const
struct processor_costs ppc8540_cost = {
  COSTS_N_INSNS (4),    /* mulsi */
  COSTS_N_INSNS (4),    /* mulsi_const */
  COSTS_N_INSNS (4),    /* mulsi_const9 */
  COSTS_N_INSNS (4),    /* muldi */
  COSTS_N_INSNS (19),   /* divsi */
  COSTS_N_INSNS (19),   /* divdi */
  COSTS_N_INSNS (4),    /* fp */
  COSTS_N_INSNS (4),    /* dmul */
  COSTS_N_INSNS (29),   /* sdiv */
  COSTS_N_INSNS (29),   /* ddiv */
  32,			/* cache line size */
  32,			/* l1 cache */
  256,			/* l2 cache */
  1,			/* prefetch streams /*/
  0,			/* SF->DF convert */
};

/* Instruction costs on E300C2 and E300C3 cores.  */
static const
struct processor_costs ppce300c2c3_cost = {
  COSTS_N_INSNS (4),    /* mulsi */
  COSTS_N_INSNS (4),    /* mulsi_const */
  COSTS_N_INSNS (4),    /* mulsi_const9 */
  COSTS_N_INSNS (4),    /* muldi */
  COSTS_N_INSNS (19),   /* divsi */
  COSTS_N_INSNS (19),   /* divdi */
  COSTS_N_INSNS (3),    /* fp */
  COSTS_N_INSNS (4),    /* dmul */
  COSTS_N_INSNS (18),   /* sdiv */
  COSTS_N_INSNS (33),   /* ddiv */
  32,
  16,			/* l1 cache */
  16,			/* l2 cache */
  1,			/* prefetch streams /*/
  0,			/* SF->DF convert */
};

/* Instruction costs on PPCE500MC processors.  */
static const
struct processor_costs ppce500mc_cost = {
  COSTS_N_INSNS (4),    /* mulsi */
  COSTS_N_INSNS (4),    /* mulsi_const */
  COSTS_N_INSNS (4),    /* mulsi_const9 */
  COSTS_N_INSNS (4),    /* muldi */
  COSTS_N_INSNS (14),   /* divsi */
  COSTS_N_INSNS (14),   /* divdi */
  COSTS_N_INSNS (8),    /* fp */
  COSTS_N_INSNS (10),   /* dmul */
  COSTS_N_INSNS (36),   /* sdiv */
  COSTS_N_INSNS (66),   /* ddiv */
  64,			/* cache line size */
  32,			/* l1 cache */
  128,			/* l2 cache */
  1,			/* prefetch streams /*/
  0,			/* SF->DF convert */
};

/* Instruction costs on PPCE500MC64 processors.  */
static const
struct processor_costs ppce500mc64_cost = {
  COSTS_N_INSNS (4),    /* mulsi */
  COSTS_N_INSNS (4),    /* mulsi_const */
  COSTS_N_INSNS (4),    /* mulsi_const9 */
  COSTS_N_INSNS (4),    /* muldi */
  COSTS_N_INSNS (14),   /* divsi */
  COSTS_N_INSNS (14),   /* divdi */
  COSTS_N_INSNS (4),    /* fp */
  COSTS_N_INSNS (10),   /* dmul */
  COSTS_N_INSNS (36),   /* sdiv */
  COSTS_N_INSNS (66),   /* ddiv */
  64,			/* cache line size */
  32,			/* l1 cache */
  128,			/* l2 cache */
  1,			/* prefetch streams /*/
  0,			/* SF->DF convert */
};

/* Instruction costs on PPCE5500 processors.  */
static const
struct processor_costs ppce5500_cost = {
  COSTS_N_INSNS (5),    /* mulsi */
  COSTS_N_INSNS (5),    /* mulsi_const */
  COSTS_N_INSNS (4),    /* mulsi_const9 */
  COSTS_N_INSNS (5),    /* muldi */
  COSTS_N_INSNS (14),   /* divsi */
  COSTS_N_INSNS (14),   /* divdi */
  COSTS_N_INSNS (7),    /* fp */
  COSTS_N_INSNS (10),   /* dmul */
  COSTS_N_INSNS (36),   /* sdiv */
  COSTS_N_INSNS (66),   /* ddiv */
  64,			/* cache line size */
  32,			/* l1 cache */
  128,			/* l2 cache */
  1,			/* prefetch streams /*/
  0,			/* SF->DF convert */
};

/* Instruction costs on PPCE6500 processors.  */
static const
struct processor_costs ppce6500_cost = {
  COSTS_N_INSNS (5),    /* mulsi */
  COSTS_N_INSNS (5),    /* mulsi_const */
  COSTS_N_INSNS (4),    /* mulsi_const9 */
  COSTS_N_INSNS (5),    /* muldi */
  COSTS_N_INSNS (14),   /* divsi */
  COSTS_N_INSNS (14),   /* divdi */
  COSTS_N_INSNS (7),    /* fp */
  COSTS_N_INSNS (10),   /* dmul */
  COSTS_N_INSNS (36),   /* sdiv */
  COSTS_N_INSNS (66),   /* ddiv */
  64,			/* cache line size */
  32,			/* l1 cache */
  128,			/* l2 cache */
  1,			/* prefetch streams /*/
  0,			/* SF->DF convert */
};

/* Instruction costs on AppliedMicro Titan processors.  */
static const
struct processor_costs titan_cost = {
  COSTS_N_INSNS (5),    /* mulsi */
  COSTS_N_INSNS (5),    /* mulsi_const */
  COSTS_N_INSNS (5),    /* mulsi_const9 */
  COSTS_N_INSNS (5),    /* muldi */
  COSTS_N_INSNS (18),   /* divsi */
  COSTS_N_INSNS (18),   /* divdi */
  COSTS_N_INSNS (10),   /* fp */
  COSTS_N_INSNS (10),   /* dmul */
  COSTS_N_INSNS (46),   /* sdiv */
  COSTS_N_INSNS (72),   /* ddiv */
  32,			/* cache line size */
  32,			/* l1 cache */
  512,			/* l2 cache */
  1,			/* prefetch streams /*/
  0,			/* SF->DF convert */
};

/* Instruction costs on POWER4 and POWER5 processors.  */
static const
struct processor_costs power4_cost = {
  COSTS_N_INSNS (3),    /* mulsi */
  COSTS_N_INSNS (2),    /* mulsi_const */
  COSTS_N_INSNS (2),    /* mulsi_const9 */
  COSTS_N_INSNS (4),    /* muldi */
  COSTS_N_INSNS (18),   /* divsi */
  COSTS_N_INSNS (34),   /* divdi */
  COSTS_N_INSNS (3),    /* fp */
  COSTS_N_INSNS (3),    /* dmul */
  COSTS_N_INSNS (17),   /* sdiv */
  COSTS_N_INSNS (17),   /* ddiv */
  128,			/* cache line size */
  32,			/* l1 cache */
  1024,			/* l2 cache */
  8,			/* prefetch streams /*/
  0,			/* SF->DF convert */
};

/* Instruction costs on POWER6 processors.  */
static const
struct processor_costs power6_cost = {
  COSTS_N_INSNS (8),    /* mulsi */
  COSTS_N_INSNS (8),    /* mulsi_const */
  COSTS_N_INSNS (8),    /* mulsi_const9 */
  COSTS_N_INSNS (8),    /* muldi */
  COSTS_N_INSNS (22),   /* divsi */
  COSTS_N_INSNS (28),   /* divdi */
  COSTS_N_INSNS (3),    /* fp */
  COSTS_N_INSNS (3),    /* dmul */
  COSTS_N_INSNS (13),   /* sdiv */
  COSTS_N_INSNS (16),   /* ddiv */
  128,			/* cache line size */
  64,			/* l1 cache */
  2048,			/* l2 cache */
  16,			/* prefetch streams */
  0,			/* SF->DF convert */
};

/* Instruction costs on POWER7 processors.  */
static const
struct processor_costs power7_cost = {
  COSTS_N_INSNS (2),	/* mulsi */
  COSTS_N_INSNS (2),	/* mulsi_const */
  COSTS_N_INSNS (2),	/* mulsi_const9 */
  COSTS_N_INSNS (2),	/* muldi */
  COSTS_N_INSNS (18),	/* divsi */
  COSTS_N_INSNS (34),	/* divdi */
  COSTS_N_INSNS (3),	/* fp */
  COSTS_N_INSNS (3),	/* dmul */
  COSTS_N_INSNS (13),	/* sdiv */
  COSTS_N_INSNS (16),	/* ddiv */
  128,			/* cache line size */
  32,			/* l1 cache */
  256,			/* l2 cache */
  12,			/* prefetch streams */
  COSTS_N_INSNS (3),	/* SF->DF convert */
};

/* Instruction costs on POWER8 processors.  */
static const
struct processor_costs power8_cost = {
  COSTS_N_INSNS (3),	/* mulsi */
  COSTS_N_INSNS (3),	/* mulsi_const */
  COSTS_N_INSNS (3),	/* mulsi_const9 */
  COSTS_N_INSNS (3),	/* muldi */
  COSTS_N_INSNS (19),	/* divsi */
  COSTS_N_INSNS (35),	/* divdi */
  COSTS_N_INSNS (3),	/* fp */
  COSTS_N_INSNS (3),	/* dmul */
  COSTS_N_INSNS (14),	/* sdiv */
  COSTS_N_INSNS (17),	/* ddiv */
  128,			/* cache line size */
  32,			/* l1 cache */
  256,			/* l2 cache */
  12,			/* prefetch streams */
  COSTS_N_INSNS (3),	/* SF->DF convert */
};

/* Instruction costs on POWER9 processors.  */
static const
struct processor_costs power9_cost = {
  COSTS_N_INSNS (3),	/* mulsi */
  COSTS_N_INSNS (3),	/* mulsi_const */
  COSTS_N_INSNS (3),	/* mulsi_const9 */
  COSTS_N_INSNS (3),	/* muldi */
  COSTS_N_INSNS (8),	/* divsi */
  COSTS_N_INSNS (12),	/* divdi */
  COSTS_N_INSNS (3),	/* fp */
  COSTS_N_INSNS (3),	/* dmul */
  COSTS_N_INSNS (13),	/* sdiv */
  COSTS_N_INSNS (18),	/* ddiv */
  128,			/* cache line size */
  32,			/* l1 cache */
  512,			/* l2 cache */
  8,			/* prefetch streams */
  COSTS_N_INSNS (3),	/* SF->DF convert */
};

/* Instruction costs on POWER A2 processors.  */
static const
struct processor_costs ppca2_cost = {
  COSTS_N_INSNS (16),    /* mulsi */
  COSTS_N_INSNS (16),    /* mulsi_const */
  COSTS_N_INSNS (16),    /* mulsi_const9 */
  COSTS_N_INSNS (16),   /* muldi */
  COSTS_N_INSNS (22),   /* divsi */
  COSTS_N_INSNS (28),   /* divdi */
  COSTS_N_INSNS (3),    /* fp */
  COSTS_N_INSNS (3),    /* dmul */
  COSTS_N_INSNS (59),   /* sdiv */
  COSTS_N_INSNS (72),   /* ddiv */
  64,
  16,			/* l1 cache */
  2048,			/* l2 cache */
  16,			/* prefetch streams */
  0,			/* SF->DF convert */
};


/* Table that classifies rs6000 builtin functions (pure, const, etc.).  */
#undef RS6000_BUILTIN_0
#undef RS6000_BUILTIN_1
#undef RS6000_BUILTIN_2
#undef RS6000_BUILTIN_3
#undef RS6000_BUILTIN_A
#undef RS6000_BUILTIN_D
#undef RS6000_BUILTIN_H
#undef RS6000_BUILTIN_P
#undef RS6000_BUILTIN_X

#define RS6000_BUILTIN_0(ENUM, NAME, MASK, ATTR, ICODE) \
  { NAME, ICODE, MASK, ATTR },

#define RS6000_BUILTIN_1(ENUM, NAME, MASK, ATTR, ICODE) \
  { NAME, ICODE, MASK, ATTR },

#define RS6000_BUILTIN_2(ENUM, NAME, MASK, ATTR, ICODE)  \
  { NAME, ICODE, MASK, ATTR },

#define RS6000_BUILTIN_3(ENUM, NAME, MASK, ATTR, ICODE)  \
  { NAME, ICODE, MASK, ATTR },

#define RS6000_BUILTIN_A(ENUM, NAME, MASK, ATTR, ICODE)  \
  { NAME, ICODE, MASK, ATTR },

#define RS6000_BUILTIN_D(ENUM, NAME, MASK, ATTR, ICODE)  \
  { NAME, ICODE, MASK, ATTR },

#define RS6000_BUILTIN_H(ENUM, NAME, MASK, ATTR, ICODE)  \
  { NAME, ICODE, MASK, ATTR },

#define RS6000_BUILTIN_P(ENUM, NAME, MASK, ATTR, ICODE)  \
  { NAME, ICODE, MASK, ATTR },

#define RS6000_BUILTIN_X(ENUM, NAME, MASK, ATTR, ICODE)  \
  { NAME, ICODE, MASK, ATTR },

struct rs6000_builtin_info_type {
  const char *name;
  const enum insn_code icode;
  const HOST_WIDE_INT mask;
  const unsigned attr;
};

static const struct rs6000_builtin_info_type rs6000_builtin_info[] =
{
#include "rs6000-builtin.def"
};

#undef RS6000_BUILTIN_0
#undef RS6000_BUILTIN_1
#undef RS6000_BUILTIN_2
#undef RS6000_BUILTIN_3
#undef RS6000_BUILTIN_A
#undef RS6000_BUILTIN_D
#undef RS6000_BUILTIN_H
#undef RS6000_BUILTIN_P
#undef RS6000_BUILTIN_X

/* Support for -mveclibabi=<xxx> to control which vector library to use.  */
static tree (*rs6000_veclib_handler) (combined_fn, tree, tree);


static bool rs6000_debug_legitimate_address_p (machine_mode, rtx, bool);
static struct machine_function * rs6000_init_machine_status (void);
static int rs6000_ra_ever_killed (void);
static tree rs6000_handle_longcall_attribute (tree *, tree, tree, int, bool *);
static tree rs6000_handle_altivec_attribute (tree *, tree, tree, int, bool *);
static tree rs6000_handle_struct_attribute (tree *, tree, tree, int, bool *);
static tree rs6000_builtin_vectorized_libmass (combined_fn, tree, tree);
static void rs6000_emit_set_long_const (rtx, HOST_WIDE_INT);
static int rs6000_memory_move_cost (machine_mode, reg_class_t, bool);
static bool rs6000_debug_rtx_costs (rtx, machine_mode, int, int, int *, bool);
static int rs6000_debug_address_cost (rtx, machine_mode, addr_space_t,
				      bool);
static int rs6000_debug_adjust_cost (rtx_insn *, int, rtx_insn *, int,
				     unsigned int);
static bool is_microcoded_insn (rtx_insn *);
static bool is_nonpipeline_insn (rtx_insn *);
static bool is_cracked_insn (rtx_insn *);
static bool is_load_insn (rtx, rtx *);
static bool is_store_insn (rtx, rtx *);
static bool set_to_load_agen (rtx_insn *,rtx_insn *);
static bool insn_terminates_group_p (rtx_insn *, enum group_termination);
static bool insn_must_be_first_in_group (rtx_insn *);
static bool insn_must_be_last_in_group (rtx_insn *);
static void altivec_init_builtins (void);
static tree builtin_function_type (machine_mode, machine_mode,
				   machine_mode, machine_mode,
				   enum rs6000_builtins, const char *name);
static void rs6000_common_init_builtins (void);
static void htm_init_builtins (void);
static rs6000_stack_t *rs6000_stack_info (void);
static void is_altivec_return_reg (rtx, void *);
int easy_vector_constant (rtx, machine_mode);
static rtx rs6000_debug_legitimize_address (rtx, rtx, machine_mode);
static rtx rs6000_legitimize_tls_address (rtx, enum tls_model);
static rtx rs6000_darwin64_record_arg (CUMULATIVE_ARGS *, const_tree,
				       bool, bool);
#if TARGET_MACHO
static void macho_branch_islands (void);
static tree get_prev_label (tree);
#endif
static bool rs6000_mode_dependent_address (const_rtx);
static bool rs6000_debug_mode_dependent_address (const_rtx);
static bool rs6000_offsettable_memref_p (rtx, machine_mode, bool);
static enum reg_class rs6000_secondary_reload_class (enum reg_class,
						     machine_mode, rtx);
static enum reg_class rs6000_debug_secondary_reload_class (enum reg_class,
							   machine_mode,
							   rtx);
static enum reg_class rs6000_preferred_reload_class (rtx, enum reg_class);
static enum reg_class rs6000_debug_preferred_reload_class (rtx,
							   enum reg_class);
static bool rs6000_debug_secondary_memory_needed (machine_mode,
						  reg_class_t,
						  reg_class_t);
static bool rs6000_debug_can_change_mode_class (machine_mode,
						machine_mode,
						reg_class_t);
static bool rs6000_save_toc_in_prologue_p (void);
static rtx rs6000_internal_arg_pointer (void);

static bool (*rs6000_mode_dependent_address_ptr) (const_rtx)
  = rs6000_mode_dependent_address;

enum reg_class (*rs6000_secondary_reload_class_ptr) (enum reg_class,
						     machine_mode, rtx)
  = rs6000_secondary_reload_class;

enum reg_class (*rs6000_preferred_reload_class_ptr) (rtx, enum reg_class)
  = rs6000_preferred_reload_class;

const int INSN_NOT_AVAILABLE = -1;

static void rs6000_print_isa_options (FILE *, int, const char *,
				      HOST_WIDE_INT);
static void rs6000_print_builtin_options (FILE *, int, const char *,
					  HOST_WIDE_INT);
static HOST_WIDE_INT rs6000_disable_incompatible_switches (void);

static enum rs6000_reg_type register_to_reg_type (rtx, bool *);
static bool rs6000_secondary_reload_move (enum rs6000_reg_type,
					  enum rs6000_reg_type,
					  machine_mode,
					  secondary_reload_info *,
					  bool);
rtl_opt_pass *make_pass_analyze_swaps (gcc::context*);
static bool rs6000_keep_leaf_when_profiled () __attribute__ ((unused));
static tree rs6000_fold_builtin (tree, int, tree *, bool);

/* Hash table stuff for keeping track of TOC entries.  */

struct GTY((for_user)) toc_hash_struct
{
  /* `key' will satisfy CONSTANT_P; in fact, it will satisfy
     ASM_OUTPUT_SPECIAL_POOL_ENTRY_P.  */
  rtx key;
  machine_mode key_mode;
  int labelno;
};

struct toc_hasher : ggc_ptr_hash<toc_hash_struct>
{
  static hashval_t hash (toc_hash_struct *);
  static bool equal (toc_hash_struct *, toc_hash_struct *);
};

static GTY (()) hash_table<toc_hasher> *toc_hash_table;

/* Hash table to keep track of the argument types for builtin functions.  */

struct GTY((for_user)) builtin_hash_struct
{
  tree type;
  machine_mode mode[4];	/* return value + 3 arguments.  */
  unsigned char uns_p[4];	/* and whether the types are unsigned.  */
};

struct builtin_hasher : ggc_ptr_hash<builtin_hash_struct>
{
  static hashval_t hash (builtin_hash_struct *);
  static bool equal (builtin_hash_struct *, builtin_hash_struct *);
};

static GTY (()) hash_table<builtin_hasher> *builtin_hash_table;


/* Default register names.  */
char rs6000_reg_names[][8] =
{
  /* GPRs */
      "0",  "1",  "2",  "3",  "4",  "5",  "6",  "7",
      "8",  "9", "10", "11", "12", "13", "14", "15",
     "16", "17", "18", "19", "20", "21", "22", "23",
     "24", "25", "26", "27", "28", "29", "30", "31",
  /* FPRs */
      "0",  "1",  "2",  "3",  "4",  "5",  "6",  "7",
      "8",  "9", "10", "11", "12", "13", "14", "15",
     "16", "17", "18", "19", "20", "21", "22", "23",
     "24", "25", "26", "27", "28", "29", "30", "31",
  /* VRs */
      "0",  "1",  "2",  "3",  "4",  "5",  "6",  "7",
      "8",  "9", "10", "11", "12", "13", "14", "15",
     "16", "17", "18", "19", "20", "21", "22", "23",
     "24", "25", "26", "27", "28", "29", "30", "31",
  /* lr ctr ca ap */
     "lr", "ctr", "ca", "ap",
  /* cr0..cr7 */
      "0",  "1",  "2",  "3",  "4",  "5",  "6",  "7",
  /* vrsave vscr sfp */
      "vrsave", "vscr", "sfp",
};

#ifdef TARGET_REGNAMES
static const char alt_reg_names[][8] =
{
  /* GPRs */
   "%r0",  "%r1",  "%r2",  "%r3",  "%r4",  "%r5",  "%r6",  "%r7",
   "%r8",  "%r9", "%r10", "%r11", "%r12", "%r13", "%r14", "%r15",
  "%r16", "%r17", "%r18", "%r19", "%r20", "%r21", "%r22", "%r23",
  "%r24", "%r25", "%r26", "%r27", "%r28", "%r29", "%r30", "%r31",
  /* FPRs */
   "%f0",  "%f1",  "%f2",  "%f3",  "%f4",  "%f5",  "%f6",  "%f7",
   "%f8",  "%f9", "%f10", "%f11", "%f12", "%f13", "%f14", "%f15",
  "%f16", "%f17", "%f18", "%f19", "%f20", "%f21", "%f22", "%f23",
  "%f24", "%f25", "%f26", "%f27", "%f28", "%f29", "%f30", "%f31",
  /* VRs */
   "%v0",  "%v1",  "%v2",  "%v3",  "%v4",  "%v5",  "%v6",  "%v7",
   "%v8",  "%v9", "%v10", "%v11", "%v12", "%v13", "%v14", "%v15",
  "%v16", "%v17", "%v18", "%v19", "%v20", "%v21", "%v22", "%v23",
  "%v24", "%v25", "%v26", "%v27", "%v28", "%v29", "%v30", "%v31",
  /* lr ctr ca ap */
    "lr",  "ctr",   "ca",   "ap",
  /* cr0..cr7 */
  "%cr0",  "%cr1", "%cr2", "%cr3", "%cr4", "%cr5", "%cr6", "%cr7",
  /* vrsave vscr sfp */
  "vrsave", "vscr", "sfp",
};
#endif

/* Table of valid machine attributes.  */

static const struct attribute_spec rs6000_attribute_table[] =
{
  /* { name, min_len, max_len, decl_req, type_req, fn_type_req,
       affects_type_identity, handler, exclude } */
  { "altivec",   1, 1, false, true,  false, false,
    rs6000_handle_altivec_attribute, NULL },
  { "longcall",  0, 0, false, true,  true,  false,
    rs6000_handle_longcall_attribute, NULL },
  { "shortcall", 0, 0, false, true,  true,  false,
    rs6000_handle_longcall_attribute, NULL },
  { "ms_struct", 0, 0, false, false, false, false,
    rs6000_handle_struct_attribute, NULL },
  { "gcc_struct", 0, 0, false, false, false, false,
    rs6000_handle_struct_attribute, NULL },
#ifdef SUBTARGET_ATTRIBUTE_TABLE
  SUBTARGET_ATTRIBUTE_TABLE,
#endif
  { NULL,        0, 0, false, false, false, false, NULL, NULL }
};

#ifndef TARGET_PROFILE_KERNEL
#define TARGET_PROFILE_KERNEL 0
#endif

/* The VRSAVE bitmask puts bit %v0 as the most significant bit.  */
#define ALTIVEC_REG_BIT(REGNO) (0x80000000 >> ((REGNO) - FIRST_ALTIVEC_REGNO))

/* Initialize the GCC target structure.  */
#undef TARGET_ATTRIBUTE_TABLE
#define TARGET_ATTRIBUTE_TABLE rs6000_attribute_table
#undef TARGET_SET_DEFAULT_TYPE_ATTRIBUTES
#define TARGET_SET_DEFAULT_TYPE_ATTRIBUTES rs6000_set_default_type_attributes
#undef TARGET_ATTRIBUTE_TAKES_IDENTIFIER_P
#define TARGET_ATTRIBUTE_TAKES_IDENTIFIER_P rs6000_attribute_takes_identifier_p

#undef TARGET_ASM_ALIGNED_DI_OP
#define TARGET_ASM_ALIGNED_DI_OP DOUBLE_INT_ASM_OP

/* Default unaligned ops are only provided for ELF.  Find the ops needed
   for non-ELF systems.  */
#ifndef OBJECT_FORMAT_ELF
#if TARGET_XCOFF
/* For XCOFF.  rs6000_assemble_integer will handle unaligned DIs on
   64-bit targets.  */
#undef TARGET_ASM_UNALIGNED_HI_OP
#define TARGET_ASM_UNALIGNED_HI_OP "\t.vbyte\t2,"
#undef TARGET_ASM_UNALIGNED_SI_OP
#define TARGET_ASM_UNALIGNED_SI_OP "\t.vbyte\t4,"
#undef TARGET_ASM_UNALIGNED_DI_OP
#define TARGET_ASM_UNALIGNED_DI_OP "\t.vbyte\t8,"
#else
/* For Darwin.  */
#undef TARGET_ASM_UNALIGNED_HI_OP
#define TARGET_ASM_UNALIGNED_HI_OP "\t.short\t"
#undef TARGET_ASM_UNALIGNED_SI_OP
#define TARGET_ASM_UNALIGNED_SI_OP "\t.long\t"
#undef TARGET_ASM_UNALIGNED_DI_OP
#define TARGET_ASM_UNALIGNED_DI_OP "\t.quad\t"
#undef TARGET_ASM_ALIGNED_DI_OP
#define TARGET_ASM_ALIGNED_DI_OP "\t.quad\t"
#endif
#endif

/* This hook deals with fixups for relocatable code and DI-mode objects
   in 64-bit code.  */
#undef TARGET_ASM_INTEGER
#define TARGET_ASM_INTEGER rs6000_assemble_integer

#if defined (HAVE_GAS_HIDDEN) && !TARGET_MACHO
#undef TARGET_ASM_ASSEMBLE_VISIBILITY
#define TARGET_ASM_ASSEMBLE_VISIBILITY rs6000_assemble_visibility
#endif

#undef TARGET_SET_UP_BY_PROLOGUE
#define TARGET_SET_UP_BY_PROLOGUE rs6000_set_up_by_prologue

#undef TARGET_SHRINK_WRAP_GET_SEPARATE_COMPONENTS
#define TARGET_SHRINK_WRAP_GET_SEPARATE_COMPONENTS rs6000_get_separate_components
#undef TARGET_SHRINK_WRAP_COMPONENTS_FOR_BB
#define TARGET_SHRINK_WRAP_COMPONENTS_FOR_BB rs6000_components_for_bb
#undef TARGET_SHRINK_WRAP_DISQUALIFY_COMPONENTS
#define TARGET_SHRINK_WRAP_DISQUALIFY_COMPONENTS rs6000_disqualify_components
#undef TARGET_SHRINK_WRAP_EMIT_PROLOGUE_COMPONENTS
#define TARGET_SHRINK_WRAP_EMIT_PROLOGUE_COMPONENTS rs6000_emit_prologue_components
#undef TARGET_SHRINK_WRAP_EMIT_EPILOGUE_COMPONENTS
#define TARGET_SHRINK_WRAP_EMIT_EPILOGUE_COMPONENTS rs6000_emit_epilogue_components
#undef TARGET_SHRINK_WRAP_SET_HANDLED_COMPONENTS
#define TARGET_SHRINK_WRAP_SET_HANDLED_COMPONENTS rs6000_set_handled_components

#undef TARGET_EXTRA_LIVE_ON_ENTRY
#define TARGET_EXTRA_LIVE_ON_ENTRY rs6000_live_on_entry

#undef TARGET_INTERNAL_ARG_POINTER
#define TARGET_INTERNAL_ARG_POINTER rs6000_internal_arg_pointer

#undef TARGET_HAVE_TLS
#define TARGET_HAVE_TLS HAVE_AS_TLS

#undef TARGET_CANNOT_FORCE_CONST_MEM
#define TARGET_CANNOT_FORCE_CONST_MEM rs6000_cannot_force_const_mem

#undef TARGET_DELEGITIMIZE_ADDRESS
#define TARGET_DELEGITIMIZE_ADDRESS rs6000_delegitimize_address

#undef TARGET_CONST_NOT_OK_FOR_DEBUG_P
#define TARGET_CONST_NOT_OK_FOR_DEBUG_P rs6000_const_not_ok_for_debug_p

#undef TARGET_LEGITIMATE_COMBINED_INSN
#define TARGET_LEGITIMATE_COMBINED_INSN rs6000_legitimate_combined_insn

#undef TARGET_ASM_FUNCTION_PROLOGUE
#define TARGET_ASM_FUNCTION_PROLOGUE rs6000_output_function_prologue
#undef TARGET_ASM_FUNCTION_EPILOGUE
#define TARGET_ASM_FUNCTION_EPILOGUE rs6000_output_function_epilogue

#undef TARGET_ASM_OUTPUT_ADDR_CONST_EXTRA
#define TARGET_ASM_OUTPUT_ADDR_CONST_EXTRA rs6000_output_addr_const_extra

#undef TARGET_LEGITIMIZE_ADDRESS
#define TARGET_LEGITIMIZE_ADDRESS rs6000_legitimize_address

#undef  TARGET_SCHED_VARIABLE_ISSUE
#define TARGET_SCHED_VARIABLE_ISSUE rs6000_variable_issue

#undef TARGET_SCHED_ISSUE_RATE
#define TARGET_SCHED_ISSUE_RATE rs6000_issue_rate
#undef TARGET_SCHED_ADJUST_COST
#define TARGET_SCHED_ADJUST_COST rs6000_adjust_cost
#undef TARGET_SCHED_ADJUST_PRIORITY
#define TARGET_SCHED_ADJUST_PRIORITY rs6000_adjust_priority
#undef TARGET_SCHED_IS_COSTLY_DEPENDENCE
#define TARGET_SCHED_IS_COSTLY_DEPENDENCE rs6000_is_costly_dependence
#undef TARGET_SCHED_INIT
#define TARGET_SCHED_INIT rs6000_sched_init
#undef TARGET_SCHED_FINISH
#define TARGET_SCHED_FINISH rs6000_sched_finish
#undef TARGET_SCHED_REORDER
#define TARGET_SCHED_REORDER rs6000_sched_reorder
#undef TARGET_SCHED_REORDER2
#define TARGET_SCHED_REORDER2 rs6000_sched_reorder2

#undef TARGET_SCHED_FIRST_CYCLE_MULTIPASS_DFA_LOOKAHEAD
#define TARGET_SCHED_FIRST_CYCLE_MULTIPASS_DFA_LOOKAHEAD rs6000_use_sched_lookahead

#undef TARGET_SCHED_FIRST_CYCLE_MULTIPASS_DFA_LOOKAHEAD_GUARD
#define TARGET_SCHED_FIRST_CYCLE_MULTIPASS_DFA_LOOKAHEAD_GUARD rs6000_use_sched_lookahead_guard

#undef TARGET_SCHED_ALLOC_SCHED_CONTEXT
#define TARGET_SCHED_ALLOC_SCHED_CONTEXT rs6000_alloc_sched_context
#undef TARGET_SCHED_INIT_SCHED_CONTEXT
#define TARGET_SCHED_INIT_SCHED_CONTEXT rs6000_init_sched_context
#undef TARGET_SCHED_SET_SCHED_CONTEXT
#define TARGET_SCHED_SET_SCHED_CONTEXT rs6000_set_sched_context
#undef TARGET_SCHED_FREE_SCHED_CONTEXT
#define TARGET_SCHED_FREE_SCHED_CONTEXT rs6000_free_sched_context

#undef TARGET_SCHED_CAN_SPECULATE_INSN
#define TARGET_SCHED_CAN_SPECULATE_INSN rs6000_sched_can_speculate_insn

#undef TARGET_VECTORIZE_BUILTIN_MASK_FOR_LOAD
#define TARGET_VECTORIZE_BUILTIN_MASK_FOR_LOAD rs6000_builtin_mask_for_load
#undef TARGET_VECTORIZE_SUPPORT_VECTOR_MISALIGNMENT
#define TARGET_VECTORIZE_SUPPORT_VECTOR_MISALIGNMENT		\
  rs6000_builtin_support_vector_misalignment
#undef TARGET_VECTORIZE_VECTOR_ALIGNMENT_REACHABLE
#define TARGET_VECTORIZE_VECTOR_ALIGNMENT_REACHABLE rs6000_vector_alignment_reachable
#undef TARGET_VECTORIZE_BUILTIN_VECTORIZATION_COST
#define TARGET_VECTORIZE_BUILTIN_VECTORIZATION_COST \
  rs6000_builtin_vectorization_cost
#undef TARGET_VECTORIZE_PREFERRED_SIMD_MODE
#define TARGET_VECTORIZE_PREFERRED_SIMD_MODE \
  rs6000_preferred_simd_mode
#undef TARGET_VECTORIZE_INIT_COST
#define TARGET_VECTORIZE_INIT_COST rs6000_init_cost
#undef TARGET_VECTORIZE_ADD_STMT_COST
#define TARGET_VECTORIZE_ADD_STMT_COST rs6000_add_stmt_cost
#undef TARGET_VECTORIZE_FINISH_COST
#define TARGET_VECTORIZE_FINISH_COST rs6000_finish_cost
#undef TARGET_VECTORIZE_DESTROY_COST_DATA
#define TARGET_VECTORIZE_DESTROY_COST_DATA rs6000_destroy_cost_data

#undef TARGET_INIT_BUILTINS
#define TARGET_INIT_BUILTINS rs6000_init_builtins
#undef TARGET_BUILTIN_DECL
#define TARGET_BUILTIN_DECL rs6000_builtin_decl

#undef TARGET_FOLD_BUILTIN
#define TARGET_FOLD_BUILTIN rs6000_fold_builtin
#undef TARGET_GIMPLE_FOLD_BUILTIN
#define TARGET_GIMPLE_FOLD_BUILTIN rs6000_gimple_fold_builtin

#undef TARGET_EXPAND_BUILTIN
#define TARGET_EXPAND_BUILTIN rs6000_expand_builtin

#undef TARGET_MANGLE_TYPE
#define TARGET_MANGLE_TYPE rs6000_mangle_type

#undef TARGET_INIT_LIBFUNCS
#define TARGET_INIT_LIBFUNCS rs6000_init_libfuncs

#if TARGET_MACHO
#undef TARGET_BINDS_LOCAL_P
#define TARGET_BINDS_LOCAL_P darwin_binds_local_p
#endif

#undef TARGET_MS_BITFIELD_LAYOUT_P
#define TARGET_MS_BITFIELD_LAYOUT_P rs6000_ms_bitfield_layout_p

#undef TARGET_ASM_OUTPUT_MI_THUNK
#define TARGET_ASM_OUTPUT_MI_THUNK rs6000_output_mi_thunk

#undef TARGET_ASM_CAN_OUTPUT_MI_THUNK
#define TARGET_ASM_CAN_OUTPUT_MI_THUNK hook_bool_const_tree_hwi_hwi_const_tree_true

#undef TARGET_FUNCTION_OK_FOR_SIBCALL
#define TARGET_FUNCTION_OK_FOR_SIBCALL rs6000_function_ok_for_sibcall

#undef TARGET_REGISTER_MOVE_COST
#define TARGET_REGISTER_MOVE_COST rs6000_register_move_cost
#undef TARGET_MEMORY_MOVE_COST
#define TARGET_MEMORY_MOVE_COST rs6000_memory_move_cost
#undef TARGET_IRA_CHANGE_PSEUDO_ALLOCNO_CLASS
#define TARGET_IRA_CHANGE_PSEUDO_ALLOCNO_CLASS \
  rs6000_ira_change_pseudo_allocno_class
#undef TARGET_CANNOT_COPY_INSN_P
#define TARGET_CANNOT_COPY_INSN_P rs6000_cannot_copy_insn_p
#undef TARGET_RTX_COSTS
#define TARGET_RTX_COSTS rs6000_rtx_costs
#undef TARGET_ADDRESS_COST
#define TARGET_ADDRESS_COST hook_int_rtx_mode_as_bool_0
#undef TARGET_INSN_COST
#define TARGET_INSN_COST rs6000_insn_cost

#undef TARGET_INIT_DWARF_REG_SIZES_EXTRA
#define TARGET_INIT_DWARF_REG_SIZES_EXTRA rs6000_init_dwarf_reg_sizes_extra

#undef TARGET_PROMOTE_FUNCTION_MODE
#define TARGET_PROMOTE_FUNCTION_MODE rs6000_promote_function_mode

#undef TARGET_RETURN_IN_MEMORY
#define TARGET_RETURN_IN_MEMORY rs6000_return_in_memory

#undef TARGET_RETURN_IN_MSB
#define TARGET_RETURN_IN_MSB rs6000_return_in_msb

#undef TARGET_SETUP_INCOMING_VARARGS
#define TARGET_SETUP_INCOMING_VARARGS setup_incoming_varargs

/* Always strict argument naming on rs6000.  */
#undef TARGET_STRICT_ARGUMENT_NAMING
#define TARGET_STRICT_ARGUMENT_NAMING hook_bool_CUMULATIVE_ARGS_true
#undef TARGET_PRETEND_OUTGOING_VARARGS_NAMED
#define TARGET_PRETEND_OUTGOING_VARARGS_NAMED hook_bool_CUMULATIVE_ARGS_true
#undef TARGET_SPLIT_COMPLEX_ARG
#define TARGET_SPLIT_COMPLEX_ARG hook_bool_const_tree_true
#undef TARGET_MUST_PASS_IN_STACK
#define TARGET_MUST_PASS_IN_STACK rs6000_must_pass_in_stack
#undef TARGET_PASS_BY_REFERENCE
#define TARGET_PASS_BY_REFERENCE rs6000_pass_by_reference
#undef TARGET_ARG_PARTIAL_BYTES
#define TARGET_ARG_PARTIAL_BYTES rs6000_arg_partial_bytes
#undef TARGET_FUNCTION_ARG_ADVANCE
#define TARGET_FUNCTION_ARG_ADVANCE rs6000_function_arg_advance
#undef TARGET_FUNCTION_ARG
#define TARGET_FUNCTION_ARG rs6000_function_arg
#undef TARGET_FUNCTION_ARG_PADDING
#define TARGET_FUNCTION_ARG_PADDING rs6000_function_arg_padding
#undef TARGET_FUNCTION_ARG_BOUNDARY
#define TARGET_FUNCTION_ARG_BOUNDARY rs6000_function_arg_boundary

#undef TARGET_BUILD_BUILTIN_VA_LIST
#define TARGET_BUILD_BUILTIN_VA_LIST rs6000_build_builtin_va_list

#undef TARGET_EXPAND_BUILTIN_VA_START
#define TARGET_EXPAND_BUILTIN_VA_START rs6000_va_start

#undef TARGET_GIMPLIFY_VA_ARG_EXPR
#define TARGET_GIMPLIFY_VA_ARG_EXPR rs6000_gimplify_va_arg

#undef TARGET_EH_RETURN_FILTER_MODE
#define TARGET_EH_RETURN_FILTER_MODE rs6000_eh_return_filter_mode

#undef TARGET_TRANSLATE_MODE_ATTRIBUTE
#define TARGET_TRANSLATE_MODE_ATTRIBUTE rs6000_translate_mode_attribute

#undef TARGET_SCALAR_MODE_SUPPORTED_P
#define TARGET_SCALAR_MODE_SUPPORTED_P rs6000_scalar_mode_supported_p

#undef TARGET_VECTOR_MODE_SUPPORTED_P
#define TARGET_VECTOR_MODE_SUPPORTED_P rs6000_vector_mode_supported_p

#undef TARGET_FLOATN_MODE
#define TARGET_FLOATN_MODE rs6000_floatn_mode

#undef TARGET_INVALID_ARG_FOR_UNPROTOTYPED_FN
#define TARGET_INVALID_ARG_FOR_UNPROTOTYPED_FN invalid_arg_for_unprototyped_fn

#undef TARGET_MD_ASM_ADJUST
#define TARGET_MD_ASM_ADJUST rs6000_md_asm_adjust

#undef TARGET_OPTION_OVERRIDE
#define TARGET_OPTION_OVERRIDE rs6000_option_override

#undef TARGET_VECTORIZE_BUILTIN_VECTORIZED_FUNCTION
#define TARGET_VECTORIZE_BUILTIN_VECTORIZED_FUNCTION \
  rs6000_builtin_vectorized_function

#undef TARGET_VECTORIZE_BUILTIN_MD_VECTORIZED_FUNCTION
#define TARGET_VECTORIZE_BUILTIN_MD_VECTORIZED_FUNCTION \
  rs6000_builtin_md_vectorized_function

#undef TARGET_STACK_PROTECT_GUARD
#define TARGET_STACK_PROTECT_GUARD rs6000_init_stack_protect_guard

#if !TARGET_MACHO
#undef TARGET_STACK_PROTECT_FAIL
#define TARGET_STACK_PROTECT_FAIL rs6000_stack_protect_fail
#endif

#ifdef HAVE_AS_TLS
#undef TARGET_ASM_OUTPUT_DWARF_DTPREL
#define TARGET_ASM_OUTPUT_DWARF_DTPREL rs6000_output_dwarf_dtprel
#endif

/* Use a 32-bit anchor range.  This leads to sequences like:

	addis	tmp,anchor,high
	add	dest,tmp,low

   where tmp itself acts as an anchor, and can be shared between
   accesses to the same 64k page.  */
#undef TARGET_MIN_ANCHOR_OFFSET
#define TARGET_MIN_ANCHOR_OFFSET -0x7fffffff - 1
#undef TARGET_MAX_ANCHOR_OFFSET
#define TARGET_MAX_ANCHOR_OFFSET 0x7fffffff
#undef TARGET_USE_BLOCKS_FOR_CONSTANT_P
#define TARGET_USE_BLOCKS_FOR_CONSTANT_P rs6000_use_blocks_for_constant_p
#undef TARGET_USE_BLOCKS_FOR_DECL_P
#define TARGET_USE_BLOCKS_FOR_DECL_P rs6000_use_blocks_for_decl_p

#undef TARGET_BUILTIN_RECIPROCAL
#define TARGET_BUILTIN_RECIPROCAL rs6000_builtin_reciprocal

#undef TARGET_SECONDARY_RELOAD
#define TARGET_SECONDARY_RELOAD rs6000_secondary_reload
#undef TARGET_SECONDARY_MEMORY_NEEDED
#define TARGET_SECONDARY_MEMORY_NEEDED rs6000_secondary_memory_needed
#undef TARGET_SECONDARY_MEMORY_NEEDED_MODE
#define TARGET_SECONDARY_MEMORY_NEEDED_MODE rs6000_secondary_memory_needed_mode

#undef TARGET_LEGITIMATE_ADDRESS_P
#define TARGET_LEGITIMATE_ADDRESS_P rs6000_legitimate_address_p

#undef TARGET_MODE_DEPENDENT_ADDRESS_P
#define TARGET_MODE_DEPENDENT_ADDRESS_P rs6000_mode_dependent_address_p

#undef TARGET_COMPUTE_PRESSURE_CLASSES
#define TARGET_COMPUTE_PRESSURE_CLASSES rs6000_compute_pressure_classes

#undef TARGET_CAN_ELIMINATE
#define TARGET_CAN_ELIMINATE rs6000_can_eliminate

#undef TARGET_CONDITIONAL_REGISTER_USAGE
#define TARGET_CONDITIONAL_REGISTER_USAGE rs6000_conditional_register_usage

#undef TARGET_SCHED_REASSOCIATION_WIDTH
#define TARGET_SCHED_REASSOCIATION_WIDTH rs6000_reassociation_width

#undef TARGET_TRAMPOLINE_INIT
#define TARGET_TRAMPOLINE_INIT rs6000_trampoline_init

#undef TARGET_FUNCTION_VALUE
#define TARGET_FUNCTION_VALUE rs6000_function_value

#undef TARGET_OPTION_VALID_ATTRIBUTE_P
#define TARGET_OPTION_VALID_ATTRIBUTE_P rs6000_valid_attribute_p

#undef TARGET_OPTION_SAVE
#define TARGET_OPTION_SAVE rs6000_function_specific_save

#undef TARGET_OPTION_RESTORE
#define TARGET_OPTION_RESTORE rs6000_function_specific_restore

#undef TARGET_OPTION_PRINT
#define TARGET_OPTION_PRINT rs6000_function_specific_print

#undef TARGET_CAN_INLINE_P
#define TARGET_CAN_INLINE_P rs6000_can_inline_p

#undef TARGET_SET_CURRENT_FUNCTION
#define TARGET_SET_CURRENT_FUNCTION rs6000_set_current_function

#undef TARGET_LEGITIMATE_CONSTANT_P
#define TARGET_LEGITIMATE_CONSTANT_P rs6000_legitimate_constant_p

#undef TARGET_VECTORIZE_VEC_PERM_CONST
#define TARGET_VECTORIZE_VEC_PERM_CONST rs6000_vectorize_vec_perm_const

#undef TARGET_CAN_USE_DOLOOP_P
#define TARGET_CAN_USE_DOLOOP_P can_use_doloop_if_innermost

#undef TARGET_ATOMIC_ASSIGN_EXPAND_FENV
#define TARGET_ATOMIC_ASSIGN_EXPAND_FENV rs6000_atomic_assign_expand_fenv

#undef TARGET_LIBGCC_CMP_RETURN_MODE
#define TARGET_LIBGCC_CMP_RETURN_MODE rs6000_abi_word_mode
#undef TARGET_LIBGCC_SHIFT_COUNT_MODE
#define TARGET_LIBGCC_SHIFT_COUNT_MODE rs6000_abi_word_mode
#undef TARGET_UNWIND_WORD_MODE
#define TARGET_UNWIND_WORD_MODE rs6000_abi_word_mode

#undef TARGET_OFFLOAD_OPTIONS
#define TARGET_OFFLOAD_OPTIONS rs6000_offload_options

#undef TARGET_C_MODE_FOR_SUFFIX
#define TARGET_C_MODE_FOR_SUFFIX rs6000_c_mode_for_suffix

#undef TARGET_INVALID_BINARY_OP
#define TARGET_INVALID_BINARY_OP rs6000_invalid_binary_op

#undef TARGET_OPTAB_SUPPORTED_P
#define TARGET_OPTAB_SUPPORTED_P rs6000_optab_supported_p

#undef TARGET_CUSTOM_FUNCTION_DESCRIPTORS
#define TARGET_CUSTOM_FUNCTION_DESCRIPTORS 1

#undef TARGET_COMPARE_VERSION_PRIORITY
#define TARGET_COMPARE_VERSION_PRIORITY rs6000_compare_version_priority

#undef TARGET_GENERATE_VERSION_DISPATCHER_BODY
#define TARGET_GENERATE_VERSION_DISPATCHER_BODY				\
  rs6000_generate_version_dispatcher_body

#undef TARGET_GET_FUNCTION_VERSIONS_DISPATCHER
#define TARGET_GET_FUNCTION_VERSIONS_DISPATCHER				\
  rs6000_get_function_versions_dispatcher

#undef TARGET_OPTION_FUNCTION_VERSIONS
#define TARGET_OPTION_FUNCTION_VERSIONS common_function_versions

#undef TARGET_HARD_REGNO_NREGS
#define TARGET_HARD_REGNO_NREGS rs6000_hard_regno_nregs_hook
#undef TARGET_HARD_REGNO_MODE_OK
#define TARGET_HARD_REGNO_MODE_OK rs6000_hard_regno_mode_ok

#undef TARGET_MODES_TIEABLE_P
#define TARGET_MODES_TIEABLE_P rs6000_modes_tieable_p

#undef TARGET_HARD_REGNO_CALL_PART_CLOBBERED
#define TARGET_HARD_REGNO_CALL_PART_CLOBBERED \
  rs6000_hard_regno_call_part_clobbered

#undef TARGET_SLOW_UNALIGNED_ACCESS
#define TARGET_SLOW_UNALIGNED_ACCESS rs6000_slow_unaligned_access

#undef TARGET_CAN_CHANGE_MODE_CLASS
#define TARGET_CAN_CHANGE_MODE_CLASS rs6000_can_change_mode_class

#undef TARGET_CONSTANT_ALIGNMENT
#define TARGET_CONSTANT_ALIGNMENT rs6000_constant_alignment

#undef TARGET_STARTING_FRAME_OFFSET
#define TARGET_STARTING_FRAME_OFFSET rs6000_starting_frame_offset

#if TARGET_ELF && RS6000_WEAK
#undef TARGET_ASM_GLOBALIZE_DECL_NAME
#define TARGET_ASM_GLOBALIZE_DECL_NAME rs6000_globalize_decl_name
#endif

#undef TARGET_SETJMP_PRESERVES_NONVOLATILE_REGS_P
#define TARGET_SETJMP_PRESERVES_NONVOLATILE_REGS_P hook_bool_void_true

#undef TARGET_MANGLE_DECL_ASSEMBLER_NAME
#define TARGET_MANGLE_DECL_ASSEMBLER_NAME rs6000_mangle_decl_assembler_name


/* Processor table.  */
struct rs6000_ptt
{
  const char *const name;		/* Canonical processor name.  */
  const enum processor_type processor;	/* Processor type enum value.  */
  const HOST_WIDE_INT target_enable;	/* Target flags to enable.  */
};

static struct rs6000_ptt const processor_target_table[] =
{
#define RS6000_CPU(NAME, CPU, FLAGS) { NAME, CPU, FLAGS },
#include "rs6000-cpus.def"
#undef RS6000_CPU
};

/* Look up a processor name for -mcpu=xxx and -mtune=xxx.  Return -1 if the
   name is invalid.  */

static int
rs6000_cpu_name_lookup (const char *name)
{
  size_t i;

  if (name != NULL)
    {
      for (i = 0; i < ARRAY_SIZE (processor_target_table); i++)
	if (! strcmp (name, processor_target_table[i].name))
	  return (int)i;
    }

  return -1;
}


/* Return number of consecutive hard regs needed starting at reg REGNO
   to hold something of mode MODE.
   This is ordinarily the length in words of a value of mode MODE
   but can be less for certain modes in special long registers.

   POWER and PowerPC GPRs hold 32 bits worth;
   PowerPC64 GPRs and FPRs point register holds 64 bits worth.  */

static int
rs6000_hard_regno_nregs_internal (int regno, machine_mode mode)
{
  unsigned HOST_WIDE_INT reg_size;

  /* 128-bit floating point usually takes 2 registers, unless it is IEEE
     128-bit floating point that can go in vector registers, which has VSX
     memory addressing.  */
  if (FP_REGNO_P (regno))
    reg_size = (VECTOR_MEM_VSX_P (mode) || FLOAT128_VECTOR_P (mode)
		? UNITS_PER_VSX_WORD
		: UNITS_PER_FP_WORD);

  else if (ALTIVEC_REGNO_P (regno))
    reg_size = UNITS_PER_ALTIVEC_WORD;

  else
    reg_size = UNITS_PER_WORD;

  return (GET_MODE_SIZE (mode) + reg_size - 1) / reg_size;
}

/* Value is 1 if hard register REGNO can hold a value of machine-mode
   MODE.  */
static int
rs6000_hard_regno_mode_ok_uncached (int regno, machine_mode mode)
{
  int last_regno = regno + rs6000_hard_regno_nregs[mode][regno] - 1;

  if (COMPLEX_MODE_P (mode))
    mode = GET_MODE_INNER (mode);

  /* PTImode can only go in GPRs.  Quad word memory operations require even/odd
     register combinations, and use PTImode where we need to deal with quad
     word memory operations.  Don't allow quad words in the argument or frame
     pointer registers, just registers 0..31.  */
  if (mode == PTImode)
    return (IN_RANGE (regno, FIRST_GPR_REGNO, LAST_GPR_REGNO)
	    && IN_RANGE (last_regno, FIRST_GPR_REGNO, LAST_GPR_REGNO)
	    && ((regno & 1) == 0));

  /* VSX registers that overlap the FPR registers are larger than for non-VSX
     implementations.  Don't allow an item to be split between a FP register
     and an Altivec register.  Allow TImode in all VSX registers if the user
     asked for it.  */
  if (TARGET_VSX && VSX_REGNO_P (regno)
      && (VECTOR_MEM_VSX_P (mode)
	  || FLOAT128_VECTOR_P (mode)
	  || reg_addr[mode].scalar_in_vmx_p
	  || mode == TImode
	  || (TARGET_VADDUQM && mode == V1TImode)))
    {
      if (FP_REGNO_P (regno))
	return FP_REGNO_P (last_regno);

      if (ALTIVEC_REGNO_P (regno))
	{
	  if (GET_MODE_SIZE (mode) != 16 && !reg_addr[mode].scalar_in_vmx_p)
	    return 0;

	  return ALTIVEC_REGNO_P (last_regno);
	}
    }

  /* The GPRs can hold any mode, but values bigger than one register
     cannot go past R31.  */
  if (INT_REGNO_P (regno))
    return INT_REGNO_P (last_regno);

  /* The float registers (except for VSX vector modes) can only hold floating
     modes and DImode.  */
  if (FP_REGNO_P (regno))
    {
      if (FLOAT128_VECTOR_P (mode))
	return false;

      if (SCALAR_FLOAT_MODE_P (mode)
	  && (mode != TDmode || (regno % 2) == 0)
	  && FP_REGNO_P (last_regno))
	return 1;

      if (GET_MODE_CLASS (mode) == MODE_INT)
	{
	  if(GET_MODE_SIZE (mode) == UNITS_PER_FP_WORD)
	    return 1;

	  if (TARGET_P8_VECTOR && (mode == SImode))
	    return 1;

	  if (TARGET_P9_VECTOR && (mode == QImode || mode == HImode))
	    return 1;
	}

      return 0;
    }

  /* The CR register can only hold CC modes.  */
  if (CR_REGNO_P (regno))
    return GET_MODE_CLASS (mode) == MODE_CC;

  if (CA_REGNO_P (regno))
    return mode == Pmode || mode == SImode;

  /* AltiVec only in AldyVec registers.  */
  if (ALTIVEC_REGNO_P (regno))
    return (VECTOR_MEM_ALTIVEC_OR_VSX_P (mode)
	    || mode == V1TImode);

  /* We cannot put non-VSX TImode or PTImode anywhere except general register
     and it must be able to fit within the register set.  */

  return GET_MODE_SIZE (mode) <= UNITS_PER_WORD;
}

/* Implement TARGET_HARD_REGNO_NREGS.  */

static unsigned int
rs6000_hard_regno_nregs_hook (unsigned int regno, machine_mode mode)
{
  return rs6000_hard_regno_nregs[mode][regno];
}

/* Implement TARGET_HARD_REGNO_MODE_OK.  */

static bool
rs6000_hard_regno_mode_ok (unsigned int regno, machine_mode mode)
{
  return rs6000_hard_regno_mode_ok_p[mode][regno];
}

/* Implement TARGET_MODES_TIEABLE_P.

   PTImode cannot tie with other modes because PTImode is restricted to even
   GPR registers, and TImode can go in any GPR as well as VSX registers (PR
   57744).

   Altivec/VSX vector tests were moved ahead of scalar float mode, so that IEEE
   128-bit floating point on VSX systems ties with other vectors.  */

static bool
rs6000_modes_tieable_p (machine_mode mode1, machine_mode mode2)
{
  if (mode1 == PTImode)
    return mode2 == PTImode;
  if (mode2 == PTImode)
    return false;

  if (ALTIVEC_OR_VSX_VECTOR_MODE (mode1))
    return ALTIVEC_OR_VSX_VECTOR_MODE (mode2);
  if (ALTIVEC_OR_VSX_VECTOR_MODE (mode2))
    return false;

  if (SCALAR_FLOAT_MODE_P (mode1))
    return SCALAR_FLOAT_MODE_P (mode2);
  if (SCALAR_FLOAT_MODE_P (mode2))
    return false;

  if (GET_MODE_CLASS (mode1) == MODE_CC)
    return GET_MODE_CLASS (mode2) == MODE_CC;
  if (GET_MODE_CLASS (mode2) == MODE_CC)
    return false;

  return true;
}

/* Implement TARGET_HARD_REGNO_CALL_PART_CLOBBERED.  */

static bool
rs6000_hard_regno_call_part_clobbered (rtx_insn *insn ATTRIBUTE_UNUSED,
				       unsigned int regno, machine_mode mode)
{
  if (TARGET_32BIT
      && TARGET_POWERPC64
      && GET_MODE_SIZE (mode) > 4
      && INT_REGNO_P (regno))
    return true;

  if (TARGET_VSX
      && FP_REGNO_P (regno)
      && GET_MODE_SIZE (mode) > 8
      && !FLOAT128_2REG_P (mode))
    return true;

  return false;
}

/* Print interesting facts about registers.  */
static void
rs6000_debug_reg_print (int first_regno, int last_regno, const char *reg_name)
{
  int r, m;

  for (r = first_regno; r <= last_regno; ++r)
    {
      const char *comma = "";
      int len;

      if (first_regno == last_regno)
	fprintf (stderr, "%s:\t", reg_name);
      else
	fprintf (stderr, "%s%d:\t", reg_name, r - first_regno);

      len = 8;
      for (m = 0; m < NUM_MACHINE_MODES; ++m)
	if (rs6000_hard_regno_mode_ok_p[m][r] && rs6000_hard_regno_nregs[m][r])
	  {
	    if (len > 70)
	      {
		fprintf (stderr, ",\n\t");
		len = 8;
		comma = "";
	      }

	    if (rs6000_hard_regno_nregs[m][r] > 1)
	      len += fprintf (stderr, "%s%s/%d", comma, GET_MODE_NAME (m),
			     rs6000_hard_regno_nregs[m][r]);
	    else
	      len += fprintf (stderr, "%s%s", comma, GET_MODE_NAME (m));

	    comma = ", ";
	  }

      if (call_used_regs[r])
	{
	  if (len > 70)
	    {
	      fprintf (stderr, ",\n\t");
	      len = 8;
	      comma = "";
	    }

	  len += fprintf (stderr, "%s%s", comma, "call-used");
	  comma = ", ";
	}

      if (fixed_regs[r])
	{
	  if (len > 70)
	    {
	      fprintf (stderr, ",\n\t");
	      len = 8;
	      comma = "";
	    }

	  len += fprintf (stderr, "%s%s", comma, "fixed");
	  comma = ", ";
	}

      if (len > 70)
	{
	  fprintf (stderr, ",\n\t");
	  comma = "";
	}

      len += fprintf (stderr, "%sreg-class = %s", comma,
		      reg_class_names[(int)rs6000_regno_regclass[r]]);
      comma = ", ";

      if (len > 70)
	{
	  fprintf (stderr, ",\n\t");
	  comma = "";
	}

      fprintf (stderr, "%sregno = %d\n", comma, r);
    }
}

static const char *
rs6000_debug_vector_unit (enum rs6000_vector v)
{
  const char *ret;

  switch (v)
    {
    case VECTOR_NONE:	   ret = "none";      break;
    case VECTOR_ALTIVEC:   ret = "altivec";   break;
    case VECTOR_VSX:	   ret = "vsx";       break;
    case VECTOR_P8_VECTOR: ret = "p8_vector"; break;
    default:		   ret = "unknown";   break;
    }

  return ret;
}

/* Inner function printing just the address mask for a particular reload
   register class.  */
DEBUG_FUNCTION char *
rs6000_debug_addr_mask (addr_mask_type mask, bool keep_spaces)
{
  static char ret[8];
  char *p = ret;

  if ((mask & RELOAD_REG_VALID) != 0)
    *p++ = 'v';
  else if (keep_spaces)
    *p++ = ' ';

  if ((mask & RELOAD_REG_MULTIPLE) != 0)
    *p++ = 'm';
  else if (keep_spaces)
    *p++ = ' ';

  if ((mask & RELOAD_REG_INDEXED) != 0)
    *p++ = 'i';
  else if (keep_spaces)
    *p++ = ' ';

  if ((mask & RELOAD_REG_QUAD_OFFSET) != 0)
    *p++ = 'O';
  else if ((mask & RELOAD_REG_OFFSET) != 0)
    *p++ = 'o';
  else if (keep_spaces)
    *p++ = ' ';

  if ((mask & RELOAD_REG_PRE_INCDEC) != 0)
    *p++ = '+';
  else if (keep_spaces)
    *p++ = ' ';

  if ((mask & RELOAD_REG_PRE_MODIFY) != 0)
    *p++ = '+';
  else if (keep_spaces)
    *p++ = ' ';

  if ((mask & RELOAD_REG_AND_M16) != 0)
    *p++ = '&';
  else if (keep_spaces)
    *p++ = ' ';

  *p = '\0';

  return ret;
}

/* Print the address masks in a human readble fashion.  */
DEBUG_FUNCTION void
rs6000_debug_print_mode (ssize_t m)
{
  ssize_t rc;
  int spaces = 0;

  fprintf (stderr, "Mode: %-5s", GET_MODE_NAME (m));
  for (rc = 0; rc < N_RELOAD_REG; rc++)
    fprintf (stderr, " %s: %s", reload_reg_map[rc].name,
	     rs6000_debug_addr_mask (reg_addr[m].addr_mask[rc], true));

  if ((reg_addr[m].reload_store != CODE_FOR_nothing)
      || (reg_addr[m].reload_load != CODE_FOR_nothing))
    {
      fprintf (stderr, "%*s  Reload=%c%c", spaces, "",
	       (reg_addr[m].reload_store != CODE_FOR_nothing) ? 's' : '*',
	       (reg_addr[m].reload_load != CODE_FOR_nothing) ? 'l' : '*');
      spaces = 0;
    }
  else
    spaces += sizeof ("  Reload=sl") - 1;

  if (reg_addr[m].scalar_in_vmx_p)
    {
      fprintf (stderr, "%*s  Upper=y", spaces, "");
      spaces = 0;
    }
  else
    spaces += sizeof ("  Upper=y") - 1;

  if (rs6000_vector_unit[m] != VECTOR_NONE
      || rs6000_vector_mem[m] != VECTOR_NONE)
    {
      fprintf (stderr, "%*s  vector: arith=%-10s mem=%s",
	       spaces, "",
	       rs6000_debug_vector_unit (rs6000_vector_unit[m]),
	       rs6000_debug_vector_unit (rs6000_vector_mem[m]));
    }

  fputs ("\n", stderr);
}

#define DEBUG_FMT_ID "%-32s= "
#define DEBUG_FMT_D   DEBUG_FMT_ID "%d\n"
#define DEBUG_FMT_WX  DEBUG_FMT_ID "%#.12" HOST_WIDE_INT_PRINT "x: "
#define DEBUG_FMT_S   DEBUG_FMT_ID "%s\n"

/* Print various interesting information with -mdebug=reg.  */
static void
rs6000_debug_reg_global (void)
{
  static const char *const tf[2] = { "false", "true" };
  const char *nl = (const char *)0;
  int m;
  size_t m1, m2, v;
  char costly_num[20];
  char nop_num[20];
  char flags_buffer[40];
  const char *costly_str;
  const char *nop_str;
  const char *trace_str;
  const char *abi_str;
  const char *cmodel_str;
  struct cl_target_option cl_opts;

  /* Modes we want tieable information on.  */
  static const machine_mode print_tieable_modes[] = {
    QImode,
    HImode,
    SImode,
    DImode,
    TImode,
    PTImode,
    SFmode,
    DFmode,
    TFmode,
    IFmode,
    KFmode,
    SDmode,
    DDmode,
    TDmode,
    V16QImode,
    V8HImode,
    V4SImode,
    V2DImode,
    V1TImode,
    V32QImode,
    V16HImode,
    V8SImode,
    V4DImode,
    V2TImode,
    V4SFmode,
    V2DFmode,
    V8SFmode,
    V4DFmode,
    CCmode,
    CCUNSmode,
    CCEQmode,
  };

  /* Virtual regs we are interested in.  */
  const static struct {
    int regno;			/* register number.  */
    const char *name;		/* register name.  */
  } virtual_regs[] = {
    { STACK_POINTER_REGNUM,			"stack pointer:" },
    { TOC_REGNUM,				"toc:          " },
    { STATIC_CHAIN_REGNUM,			"static chain: " },
    { RS6000_PIC_OFFSET_TABLE_REGNUM,		"pic offset:   " },
    { HARD_FRAME_POINTER_REGNUM,		"hard frame:   " },
    { ARG_POINTER_REGNUM,			"arg pointer:  " },
    { FRAME_POINTER_REGNUM,			"frame pointer:" },
    { FIRST_PSEUDO_REGISTER,			"first pseudo: " },
    { FIRST_VIRTUAL_REGISTER,			"first virtual:" },
    { VIRTUAL_INCOMING_ARGS_REGNUM,		"incoming_args:" },
    { VIRTUAL_STACK_VARS_REGNUM,		"stack_vars:   " },
    { VIRTUAL_STACK_DYNAMIC_REGNUM,		"stack_dynamic:" },
    { VIRTUAL_OUTGOING_ARGS_REGNUM,		"outgoing_args:" },
    { VIRTUAL_CFA_REGNUM,			"cfa (frame):  " },
    { VIRTUAL_PREFERRED_STACK_BOUNDARY_REGNUM,	"stack boundry:" },
    { LAST_VIRTUAL_REGISTER,			"last virtual: " },
  };

  fputs ("\nHard register information:\n", stderr);
  rs6000_debug_reg_print (FIRST_GPR_REGNO, LAST_GPR_REGNO, "gr");
  rs6000_debug_reg_print (FIRST_FPR_REGNO, LAST_FPR_REGNO, "fp");
  rs6000_debug_reg_print (FIRST_ALTIVEC_REGNO,
			  LAST_ALTIVEC_REGNO,
			  "vs");
  rs6000_debug_reg_print (LR_REGNO, LR_REGNO, "lr");
  rs6000_debug_reg_print (CTR_REGNO, CTR_REGNO, "ctr");
  rs6000_debug_reg_print (CR0_REGNO, CR7_REGNO, "cr");
  rs6000_debug_reg_print (CA_REGNO, CA_REGNO, "ca");
  rs6000_debug_reg_print (VRSAVE_REGNO, VRSAVE_REGNO, "vrsave");
  rs6000_debug_reg_print (VSCR_REGNO, VSCR_REGNO, "vscr");

  fputs ("\nVirtual/stack/frame registers:\n", stderr);
  for (v = 0; v < ARRAY_SIZE (virtual_regs); v++)
    fprintf (stderr, "%s regno = %3d\n", virtual_regs[v].name, virtual_regs[v].regno);

  fprintf (stderr,
	   "\n"
	   "d  reg_class = %s\n"
	   "f  reg_class = %s\n"
	   "v  reg_class = %s\n"
	   "wa reg_class = %s\n"
	   "we reg_class = %s\n"
	   "wr reg_class = %s\n"
	   "wx reg_class = %s\n"
	   "wA reg_class = %s\n"
	   "\n",
	   reg_class_names[rs6000_constraints[RS6000_CONSTRAINT_d]],
	   reg_class_names[rs6000_constraints[RS6000_CONSTRAINT_f]],
	   reg_class_names[rs6000_constraints[RS6000_CONSTRAINT_v]],
	   reg_class_names[rs6000_constraints[RS6000_CONSTRAINT_wa]],
	   reg_class_names[rs6000_constraints[RS6000_CONSTRAINT_we]],
	   reg_class_names[rs6000_constraints[RS6000_CONSTRAINT_wr]],
	   reg_class_names[rs6000_constraints[RS6000_CONSTRAINT_wx]],
	   reg_class_names[rs6000_constraints[RS6000_CONSTRAINT_wA]]);

  nl = "\n";
  for (m = 0; m < NUM_MACHINE_MODES; ++m)
    rs6000_debug_print_mode (m);

  fputs ("\n", stderr);

  for (m1 = 0; m1 < ARRAY_SIZE (print_tieable_modes); m1++)
    {
      machine_mode mode1 = print_tieable_modes[m1];
      bool first_time = true;

      nl = (const char *)0;
      for (m2 = 0; m2 < ARRAY_SIZE (print_tieable_modes); m2++)
	{
	  machine_mode mode2 = print_tieable_modes[m2];
	  if (mode1 != mode2 && rs6000_modes_tieable_p (mode1, mode2))
	    {
	      if (first_time)
		{
		  fprintf (stderr, "Tieable modes %s:", GET_MODE_NAME (mode1));
		  nl = "\n";
		  first_time = false;
		}

	      fprintf (stderr, " %s", GET_MODE_NAME (mode2));
	    }
	}

      if (!first_time)
	fputs ("\n", stderr);
    }

  if (nl)
    fputs (nl, stderr);

  if (rs6000_recip_control)
    {
      fprintf (stderr, "\nReciprocal mask = 0x%x\n", rs6000_recip_control);

      for (m = 0; m < NUM_MACHINE_MODES; ++m)
	if (rs6000_recip_bits[m])
	  {
	    fprintf (stderr,
		     "Reciprocal estimate mode: %-5s divide: %s rsqrt: %s\n",
		     GET_MODE_NAME (m),
		     (RS6000_RECIP_AUTO_RE_P (m)
		      ? "auto"
		      : (RS6000_RECIP_HAVE_RE_P (m) ? "have" : "none")),
		     (RS6000_RECIP_AUTO_RSQRTE_P (m)
		      ? "auto"
		      : (RS6000_RECIP_HAVE_RSQRTE_P (m) ? "have" : "none")));
	  }

      fputs ("\n", stderr);
    }

  if (rs6000_cpu_index >= 0)
    {
      const char *name = processor_target_table[rs6000_cpu_index].name;
      HOST_WIDE_INT flags
	= processor_target_table[rs6000_cpu_index].target_enable;

      sprintf (flags_buffer, "-mcpu=%s flags", name);
      rs6000_print_isa_options (stderr, 0, flags_buffer, flags);
    }
  else
    fprintf (stderr, DEBUG_FMT_S, "cpu", "<none>");

  if (rs6000_tune_index >= 0)
    {
      const char *name = processor_target_table[rs6000_tune_index].name;
      HOST_WIDE_INT flags
	= processor_target_table[rs6000_tune_index].target_enable;

      sprintf (flags_buffer, "-mtune=%s flags", name);
      rs6000_print_isa_options (stderr, 0, flags_buffer, flags);
    }
  else
    fprintf (stderr, DEBUG_FMT_S, "tune", "<none>");

  cl_target_option_save (&cl_opts, &global_options);
  rs6000_print_isa_options (stderr, 0, "rs6000_isa_flags",
			    rs6000_isa_flags);

  rs6000_print_isa_options (stderr, 0, "rs6000_isa_flags_explicit",
			    rs6000_isa_flags_explicit);

  rs6000_print_builtin_options (stderr, 0, "rs6000_builtin_mask",
				rs6000_builtin_mask);

  rs6000_print_isa_options (stderr, 0, "TARGET_DEFAULT", TARGET_DEFAULT);

  fprintf (stderr, DEBUG_FMT_S, "--with-cpu default",
	   OPTION_TARGET_CPU_DEFAULT ? OPTION_TARGET_CPU_DEFAULT : "<none>");

  switch (rs6000_sched_costly_dep)
    {
    case max_dep_latency:
      costly_str = "max_dep_latency";
      break;

    case no_dep_costly:
      costly_str = "no_dep_costly";
      break;

    case all_deps_costly:
      costly_str = "all_deps_costly";
      break;

    case true_store_to_load_dep_costly:
      costly_str = "true_store_to_load_dep_costly";
      break;

    case store_to_load_dep_costly:
      costly_str = "store_to_load_dep_costly";
      break;

    default:
      costly_str = costly_num;
      sprintf (costly_num, "%d", (int)rs6000_sched_costly_dep);
      break;
    }

  fprintf (stderr, DEBUG_FMT_S, "sched_costly_dep", costly_str);

  switch (rs6000_sched_insert_nops)
    {
    case sched_finish_regroup_exact:
      nop_str = "sched_finish_regroup_exact";
      break;

    case sched_finish_pad_groups:
      nop_str = "sched_finish_pad_groups";
      break;

    case sched_finish_none:
      nop_str = "sched_finish_none";
      break;

    default:
      nop_str = nop_num;
      sprintf (nop_num, "%d", (int)rs6000_sched_insert_nops);
      break;
    }

  fprintf (stderr, DEBUG_FMT_S, "sched_insert_nops", nop_str);

  switch (rs6000_sdata)
    {
    default:
    case SDATA_NONE:
      break;

    case SDATA_DATA:
      fprintf (stderr, DEBUG_FMT_S, "sdata", "data");
      break;

    case SDATA_SYSV:
      fprintf (stderr, DEBUG_FMT_S, "sdata", "sysv");
      break;

    case SDATA_EABI:
      fprintf (stderr, DEBUG_FMT_S, "sdata", "eabi");
      break;

    }

  switch (rs6000_traceback)
    {
    case traceback_default:	trace_str = "default";	break;
    case traceback_none:	trace_str = "none";	break;
    case traceback_part:	trace_str = "part";	break;
    case traceback_full:	trace_str = "full";	break;
    default:			trace_str = "unknown";	break;
    }

  fprintf (stderr, DEBUG_FMT_S, "traceback", trace_str);

  switch (rs6000_current_cmodel)
    {
    case CMODEL_SMALL:	cmodel_str = "small";	break;
    case CMODEL_MEDIUM:	cmodel_str = "medium";	break;
    case CMODEL_LARGE:	cmodel_str = "large";	break;
    default:		cmodel_str = "unknown";	break;
    }

  fprintf (stderr, DEBUG_FMT_S, "cmodel", cmodel_str);

  switch (rs6000_current_abi)
    {
    case ABI_NONE:	abi_str = "none";	break;
    case ABI_AIX:	abi_str = "aix";	break;
    case ABI_ELFv2:	abi_str = "ELFv2";	break;
    case ABI_V4:	abi_str = "V4";		break;
    case ABI_DARWIN:	abi_str = "darwin";	break;
    default:		abi_str = "unknown";	break;
    }

  fprintf (stderr, DEBUG_FMT_S, "abi", abi_str);

  if (rs6000_altivec_abi)
    fprintf (stderr, DEBUG_FMT_S, "altivec_abi", "true");

  if (rs6000_darwin64_abi)
    fprintf (stderr, DEBUG_FMT_S, "darwin64_abi", "true");

  fprintf (stderr, DEBUG_FMT_S, "soft_float",
	   (TARGET_SOFT_FLOAT ? "true" : "false"));

  if (TARGET_LINK_STACK)
    fprintf (stderr, DEBUG_FMT_S, "link_stack", "true");

  if (TARGET_P8_FUSION)
    {
      char options[80];

      strcpy (options, "power8");
      if (TARGET_P8_FUSION_SIGN)
	strcat (options, ", sign");

      fprintf (stderr, DEBUG_FMT_S, "fusion", options);
    }

  fprintf (stderr, DEBUG_FMT_S, "plt-format",
	   TARGET_SECURE_PLT ? "secure" : "bss");
  fprintf (stderr, DEBUG_FMT_S, "struct-return",
	   aix_struct_return ? "aix" : "sysv");
  fprintf (stderr, DEBUG_FMT_S, "always_hint", tf[!!rs6000_always_hint]);
  fprintf (stderr, DEBUG_FMT_S, "sched_groups", tf[!!rs6000_sched_groups]);
  fprintf (stderr, DEBUG_FMT_S, "align_branch",
	   tf[!!rs6000_align_branch_targets]);
  fprintf (stderr, DEBUG_FMT_D, "tls_size", rs6000_tls_size);
  fprintf (stderr, DEBUG_FMT_D, "long_double_size",
	   rs6000_long_double_type_size);
  if (rs6000_long_double_type_size > 64)
    {
      fprintf (stderr, DEBUG_FMT_S, "long double type",
	       TARGET_IEEEQUAD ? "IEEE" : "IBM");
      fprintf (stderr, DEBUG_FMT_S, "default long double type",
	       TARGET_IEEEQUAD_DEFAULT ? "IEEE" : "IBM");
    }
  fprintf (stderr, DEBUG_FMT_D, "sched_restricted_insns_priority",
	   (int)rs6000_sched_restricted_insns_priority);
  fprintf (stderr, DEBUG_FMT_D, "Number of standard builtins",
	   (int)END_BUILTINS);
  fprintf (stderr, DEBUG_FMT_D, "Number of rs6000 builtins",
	   (int)RS6000_BUILTIN_COUNT);

  fprintf (stderr, DEBUG_FMT_D, "Enable float128 on VSX",
	   (int)TARGET_FLOAT128_ENABLE_TYPE);

  if (TARGET_VSX)
    fprintf (stderr, DEBUG_FMT_D, "VSX easy 64-bit scalar element",
	     (int)VECTOR_ELEMENT_SCALAR_64BIT);

  if (TARGET_DIRECT_MOVE_128)
    fprintf (stderr, DEBUG_FMT_D, "VSX easy 64-bit mfvsrld element",
	     (int)VECTOR_ELEMENT_MFVSRLD_64BIT);
}


/* Update the addr mask bits in reg_addr to help secondary reload and go if
   legitimate address support to figure out the appropriate addressing to
   use.  */

static void
rs6000_setup_reg_addr_masks (void)
{
  ssize_t rc, reg, m, nregs;
  addr_mask_type any_addr_mask, addr_mask;

  for (m = 0; m < NUM_MACHINE_MODES; ++m)
    {
      machine_mode m2 = (machine_mode) m;
      bool complex_p = false;
      bool small_int_p = (m2 == QImode || m2 == HImode || m2 == SImode);
      size_t msize;

      if (COMPLEX_MODE_P (m2))
	{
	  complex_p = true;
	  m2 = GET_MODE_INNER (m2);
	}

      msize = GET_MODE_SIZE (m2);

      /* SDmode is special in that we want to access it only via REG+REG
	 addressing on power7 and above, since we want to use the LFIWZX and
	 STFIWZX instructions to load it.  */
      bool indexed_only_p = (m == SDmode && TARGET_NO_SDMODE_STACK);

      any_addr_mask = 0;
      for (rc = FIRST_RELOAD_REG_CLASS; rc <= LAST_RELOAD_REG_CLASS; rc++)
	{
	  addr_mask = 0;
	  reg = reload_reg_map[rc].reg;

	  /* Can mode values go in the GPR/FPR/Altivec registers?  */
	  if (reg >= 0 && rs6000_hard_regno_mode_ok_p[m][reg])
	    {
	      bool small_int_vsx_p = (small_int_p
				      && (rc == RELOAD_REG_FPR
					  || rc == RELOAD_REG_VMX));

	      nregs = rs6000_hard_regno_nregs[m][reg];
	      addr_mask |= RELOAD_REG_VALID;

	      /* Indicate if the mode takes more than 1 physical register.  If
		 it takes a single register, indicate it can do REG+REG
		 addressing.  Small integers in VSX registers can only do
		 REG+REG addressing.  */
	      if (small_int_vsx_p)
		addr_mask |= RELOAD_REG_INDEXED;
	      else if (nregs > 1 || m == BLKmode || complex_p)
		addr_mask |= RELOAD_REG_MULTIPLE;
	      else
		addr_mask |= RELOAD_REG_INDEXED;

	      /* Figure out if we can do PRE_INC, PRE_DEC, or PRE_MODIFY
		 addressing.  If we allow scalars into Altivec registers,
		 don't allow PRE_INC, PRE_DEC, or PRE_MODIFY.

		 For VSX systems, we don't allow update addressing for
		 DFmode/SFmode if those registers can go in both the
		 traditional floating point registers and Altivec registers.
		 The load/store instructions for the Altivec registers do not
		 have update forms.  If we allowed update addressing, it seems
		 to break IV-OPT code using floating point if the index type is
		 int instead of long (PR target/81550 and target/84042).  */

	      if (TARGET_UPDATE
		  && (rc == RELOAD_REG_GPR || rc == RELOAD_REG_FPR)
		  && msize <= 8
		  && !VECTOR_MODE_P (m2)
		  && !FLOAT128_VECTOR_P (m2)
		  && !complex_p
		  && (m != E_DFmode || !TARGET_VSX)
		  && (m != E_SFmode || !TARGET_P8_VECTOR)
		  && !small_int_vsx_p)
		{
		  addr_mask |= RELOAD_REG_PRE_INCDEC;

		  /* PRE_MODIFY is more restricted than PRE_INC/PRE_DEC in that
		     we don't allow PRE_MODIFY for some multi-register
		     operations.  */
		  switch (m)
		    {
		    default:
		      addr_mask |= RELOAD_REG_PRE_MODIFY;
		      break;

		    case E_DImode:
		      if (TARGET_POWERPC64)
			addr_mask |= RELOAD_REG_PRE_MODIFY;
		      break;

		    case E_DFmode:
		    case E_DDmode:
		      if (TARGET_HARD_FLOAT)
			addr_mask |= RELOAD_REG_PRE_MODIFY;
		      break;
		    }
		}
	    }

	  /* GPR and FPR registers can do REG+OFFSET addressing, except
	     possibly for SDmode.  ISA 3.0 (i.e. power9) adds D-form addressing
	     for 64-bit scalars and 32-bit SFmode to altivec registers.  */
	  if ((addr_mask != 0) && !indexed_only_p
	      && msize <= 8
	      && (rc == RELOAD_REG_GPR
		  || ((msize == 8 || m2 == SFmode)
		      && (rc == RELOAD_REG_FPR
			  || (rc == RELOAD_REG_VMX && TARGET_P9_VECTOR)))))
	    addr_mask |= RELOAD_REG_OFFSET;

	  /* VSX registers can do REG+OFFSET addresssing if ISA 3.0
	     instructions are enabled.  The offset for 128-bit VSX registers is
	     only 12-bits.  While GPRs can handle the full offset range, VSX
	     registers can only handle the restricted range.  */
	  else if ((addr_mask != 0) && !indexed_only_p
		   && msize == 16 && TARGET_P9_VECTOR
		   && (ALTIVEC_OR_VSX_VECTOR_MODE (m2)
		       || (m2 == TImode && TARGET_VSX)))
	    {
	      addr_mask |= RELOAD_REG_OFFSET;
	      if (rc == RELOAD_REG_FPR || rc == RELOAD_REG_VMX)
		addr_mask |= RELOAD_REG_QUAD_OFFSET;
	    }

	  /* VMX registers can do (REG & -16) and ((REG+REG) & -16)
	     addressing on 128-bit types.  */
	  if (rc == RELOAD_REG_VMX && msize == 16
	      && (addr_mask & RELOAD_REG_VALID) != 0)
	    addr_mask |= RELOAD_REG_AND_M16;

	  reg_addr[m].addr_mask[rc] = addr_mask;
	  any_addr_mask |= addr_mask;
	}

      reg_addr[m].addr_mask[RELOAD_REG_ANY] = any_addr_mask;
    }
}


/* Initialize the various global tables that are based on register size.  */
static void
rs6000_init_hard_regno_mode_ok (bool global_init_p)
{
  ssize_t r, m, c;
  int align64;
  int align32;

  /* Precalculate REGNO_REG_CLASS.  */
  rs6000_regno_regclass[0] = GENERAL_REGS;
  for (r = 1; r < 32; ++r)
    rs6000_regno_regclass[r] = BASE_REGS;

  for (r = 32; r < 64; ++r)
    rs6000_regno_regclass[r] = FLOAT_REGS;

  for (r = 64; HARD_REGISTER_NUM_P (r); ++r)
    rs6000_regno_regclass[r] = NO_REGS;

  for (r = FIRST_ALTIVEC_REGNO; r <= LAST_ALTIVEC_REGNO; ++r)
    rs6000_regno_regclass[r] = ALTIVEC_REGS;

  rs6000_regno_regclass[CR0_REGNO] = CR0_REGS;
  for (r = CR1_REGNO; r <= CR7_REGNO; ++r)
    rs6000_regno_regclass[r] = CR_REGS;

  rs6000_regno_regclass[LR_REGNO] = LINK_REGS;
  rs6000_regno_regclass[CTR_REGNO] = CTR_REGS;
  rs6000_regno_regclass[CA_REGNO] = NO_REGS;
  rs6000_regno_regclass[VRSAVE_REGNO] = VRSAVE_REGS;
  rs6000_regno_regclass[VSCR_REGNO] = VRSAVE_REGS;
  rs6000_regno_regclass[ARG_POINTER_REGNUM] = BASE_REGS;
  rs6000_regno_regclass[FRAME_POINTER_REGNUM] = BASE_REGS;

  /* Precalculate register class to simpler reload register class.  We don't
     need all of the register classes that are combinations of different
     classes, just the simple ones that have constraint letters.  */
  for (c = 0; c < N_REG_CLASSES; c++)
    reg_class_to_reg_type[c] = NO_REG_TYPE;

  reg_class_to_reg_type[(int)GENERAL_REGS] = GPR_REG_TYPE;
  reg_class_to_reg_type[(int)BASE_REGS] = GPR_REG_TYPE;
  reg_class_to_reg_type[(int)VSX_REGS] = VSX_REG_TYPE;
  reg_class_to_reg_type[(int)VRSAVE_REGS] = SPR_REG_TYPE;
  reg_class_to_reg_type[(int)VSCR_REGS] = SPR_REG_TYPE;
  reg_class_to_reg_type[(int)LINK_REGS] = SPR_REG_TYPE;
  reg_class_to_reg_type[(int)CTR_REGS] = SPR_REG_TYPE;
  reg_class_to_reg_type[(int)LINK_OR_CTR_REGS] = SPR_REG_TYPE;
  reg_class_to_reg_type[(int)CR_REGS] = CR_REG_TYPE;
  reg_class_to_reg_type[(int)CR0_REGS] = CR_REG_TYPE;

  if (TARGET_VSX)
    {
      reg_class_to_reg_type[(int)FLOAT_REGS] = VSX_REG_TYPE;
      reg_class_to_reg_type[(int)ALTIVEC_REGS] = VSX_REG_TYPE;
    }
  else
    {
      reg_class_to_reg_type[(int)FLOAT_REGS] = FPR_REG_TYPE;
      reg_class_to_reg_type[(int)ALTIVEC_REGS] = ALTIVEC_REG_TYPE;
    }

  /* Precalculate the valid memory formats as well as the vector information,
     this must be set up before the rs6000_hard_regno_nregs_internal calls
     below.  */
  gcc_assert ((int)VECTOR_NONE == 0);
  memset ((void *) &rs6000_vector_unit[0], '\0', sizeof (rs6000_vector_unit));
  memset ((void *) &rs6000_vector_mem[0], '\0', sizeof (rs6000_vector_mem));

  gcc_assert ((int)CODE_FOR_nothing == 0);
  memset ((void *) &reg_addr[0], '\0', sizeof (reg_addr));

  gcc_assert ((int)NO_REGS == 0);
  memset ((void *) &rs6000_constraints[0], '\0', sizeof (rs6000_constraints));

  /* The VSX hardware allows native alignment for vectors, but control whether the compiler
     believes it can use native alignment or still uses 128-bit alignment.  */
  if (TARGET_VSX && !TARGET_VSX_ALIGN_128)
    {
      align64 = 64;
      align32 = 32;
    }
  else
    {
      align64 = 128;
      align32 = 128;
    }

  /* KF mode (IEEE 128-bit in VSX registers).  We do not have arithmetic, so
     only set the memory modes.  Include TFmode if -mabi=ieeelongdouble.  */
  if (TARGET_FLOAT128_TYPE)
    {
      rs6000_vector_mem[KFmode] = VECTOR_VSX;
      rs6000_vector_align[KFmode] = 128;

      if (FLOAT128_IEEE_P (TFmode))
	{
	  rs6000_vector_mem[TFmode] = VECTOR_VSX;
	  rs6000_vector_align[TFmode] = 128;
	}
    }

  /* V2DF mode, VSX only.  */
  if (TARGET_VSX)
    {
      rs6000_vector_unit[V2DFmode] = VECTOR_VSX;
      rs6000_vector_mem[V2DFmode] = VECTOR_VSX;
      rs6000_vector_align[V2DFmode] = align64;
    }

  /* V4SF mode, either VSX or Altivec.  */
  if (TARGET_VSX)
    {
      rs6000_vector_unit[V4SFmode] = VECTOR_VSX;
      rs6000_vector_mem[V4SFmode] = VECTOR_VSX;
      rs6000_vector_align[V4SFmode] = align32;
    }
  else if (TARGET_ALTIVEC)
    {
      rs6000_vector_unit[V4SFmode] = VECTOR_ALTIVEC;
      rs6000_vector_mem[V4SFmode] = VECTOR_ALTIVEC;
      rs6000_vector_align[V4SFmode] = align32;
    }

  /* V16QImode, V8HImode, V4SImode are Altivec only, but possibly do VSX loads
     and stores. */
  if (TARGET_ALTIVEC)
    {
      rs6000_vector_unit[V4SImode] = VECTOR_ALTIVEC;
      rs6000_vector_unit[V8HImode] = VECTOR_ALTIVEC;
      rs6000_vector_unit[V16QImode] = VECTOR_ALTIVEC;
      rs6000_vector_align[V4SImode] = align32;
      rs6000_vector_align[V8HImode] = align32;
      rs6000_vector_align[V16QImode] = align32;

      if (TARGET_VSX)
	{
	  rs6000_vector_mem[V4SImode] = VECTOR_VSX;
	  rs6000_vector_mem[V8HImode] = VECTOR_VSX;
	  rs6000_vector_mem[V16QImode] = VECTOR_VSX;
	}
      else
	{
	  rs6000_vector_mem[V4SImode] = VECTOR_ALTIVEC;
	  rs6000_vector_mem[V8HImode] = VECTOR_ALTIVEC;
	  rs6000_vector_mem[V16QImode] = VECTOR_ALTIVEC;
	}
    }

  /* V2DImode, full mode depends on ISA 2.07 vector mode.  Allow under VSX to
     do insert/splat/extract.  Altivec doesn't have 64-bit integer support.  */
  if (TARGET_VSX)
    {
      rs6000_vector_mem[V2DImode] = VECTOR_VSX;
      rs6000_vector_unit[V2DImode]
	= (TARGET_P8_VECTOR) ? VECTOR_P8_VECTOR : VECTOR_NONE;
      rs6000_vector_align[V2DImode] = align64;

      rs6000_vector_mem[V1TImode] = VECTOR_VSX;
      rs6000_vector_unit[V1TImode]
	= (TARGET_P8_VECTOR) ? VECTOR_P8_VECTOR : VECTOR_NONE;
      rs6000_vector_align[V1TImode] = 128;
    }

  /* DFmode, see if we want to use the VSX unit.  Memory is handled
     differently, so don't set rs6000_vector_mem.  */
  if (TARGET_VSX)
    {
      rs6000_vector_unit[DFmode] = VECTOR_VSX;
      rs6000_vector_align[DFmode] = 64;
    }

  /* SFmode, see if we want to use the VSX unit.  */
  if (TARGET_P8_VECTOR)
    {
      rs6000_vector_unit[SFmode] = VECTOR_VSX;
      rs6000_vector_align[SFmode] = 32;
    }

  /* Allow TImode in VSX register and set the VSX memory macros.  */
  if (TARGET_VSX)
    {
      rs6000_vector_mem[TImode] = VECTOR_VSX;
      rs6000_vector_align[TImode] = align64;
    }

  /* Register class constraints for the constraints that depend on compile
     switches. When the VSX code was added, different constraints were added
     based on the type (DFmode, V2DFmode, V4SFmode).  For the vector types, all
     of the VSX registers are used.  The register classes for scalar floating
     point types is set, based on whether we allow that type into the upper
     (Altivec) registers.  GCC has register classes to target the Altivec
     registers for load/store operations, to select using a VSX memory
     operation instead of the traditional floating point operation.  The
     constraints are:

	d  - Register class to use with traditional DFmode instructions.
	f  - Register class to use with traditional SFmode instructions.
	v  - Altivec register.
	wa - Any VSX register.
	wc - Reserved to represent individual CR bits (used in LLVM).
	wn - always NO_REGS.
	wr - GPR if 64-bit mode is permitted.
	wx - Float register if we can do 32-bit int stores.  */

  if (TARGET_HARD_FLOAT)
    {
      rs6000_constraints[RS6000_CONSTRAINT_f] = FLOAT_REGS;	/* SFmode  */
      rs6000_constraints[RS6000_CONSTRAINT_d] = FLOAT_REGS;	/* DFmode  */
    }

  if (TARGET_VSX)
    rs6000_constraints[RS6000_CONSTRAINT_wa] = VSX_REGS;

  /* Add conditional constraints based on various options, to allow us to
     collapse multiple insn patterns.  */
  if (TARGET_ALTIVEC)
    rs6000_constraints[RS6000_CONSTRAINT_v] = ALTIVEC_REGS;

  if (TARGET_POWERPC64)
    {
      rs6000_constraints[RS6000_CONSTRAINT_wr] = GENERAL_REGS;
      rs6000_constraints[RS6000_CONSTRAINT_wA] = BASE_REGS;
    }

  if (TARGET_STFIWX)
    rs6000_constraints[RS6000_CONSTRAINT_wx] = FLOAT_REGS;	/* DImode  */

  /* Support for new direct moves (ISA 3.0 + 64bit).  */
  if (TARGET_DIRECT_MOVE_128)
    rs6000_constraints[RS6000_CONSTRAINT_we] = VSX_REGS;

  /* Set up the reload helper and direct move functions.  */
  if (TARGET_VSX || TARGET_ALTIVEC)
    {
      if (TARGET_64BIT)
	{
	  reg_addr[V16QImode].reload_store = CODE_FOR_reload_v16qi_di_store;
	  reg_addr[V16QImode].reload_load  = CODE_FOR_reload_v16qi_di_load;
	  reg_addr[V8HImode].reload_store  = CODE_FOR_reload_v8hi_di_store;
	  reg_addr[V8HImode].reload_load   = CODE_FOR_reload_v8hi_di_load;
	  reg_addr[V4SImode].reload_store  = CODE_FOR_reload_v4si_di_store;
	  reg_addr[V4SImode].reload_load   = CODE_FOR_reload_v4si_di_load;
	  reg_addr[V2DImode].reload_store  = CODE_FOR_reload_v2di_di_store;
	  reg_addr[V2DImode].reload_load   = CODE_FOR_reload_v2di_di_load;
	  reg_addr[V1TImode].reload_store  = CODE_FOR_reload_v1ti_di_store;
	  reg_addr[V1TImode].reload_load   = CODE_FOR_reload_v1ti_di_load;
	  reg_addr[V4SFmode].reload_store  = CODE_FOR_reload_v4sf_di_store;
	  reg_addr[V4SFmode].reload_load   = CODE_FOR_reload_v4sf_di_load;
	  reg_addr[V2DFmode].reload_store  = CODE_FOR_reload_v2df_di_store;
	  reg_addr[V2DFmode].reload_load   = CODE_FOR_reload_v2df_di_load;
	  reg_addr[DFmode].reload_store    = CODE_FOR_reload_df_di_store;
	  reg_addr[DFmode].reload_load     = CODE_FOR_reload_df_di_load;
	  reg_addr[DDmode].reload_store    = CODE_FOR_reload_dd_di_store;
	  reg_addr[DDmode].reload_load     = CODE_FOR_reload_dd_di_load;
	  reg_addr[SFmode].reload_store    = CODE_FOR_reload_sf_di_store;
	  reg_addr[SFmode].reload_load     = CODE_FOR_reload_sf_di_load;

	  if (FLOAT128_VECTOR_P (KFmode))
	    {
	      reg_addr[KFmode].reload_store = CODE_FOR_reload_kf_di_store;
	      reg_addr[KFmode].reload_load  = CODE_FOR_reload_kf_di_load;
	    }

	  if (FLOAT128_VECTOR_P (TFmode))
	    {
	      reg_addr[TFmode].reload_store = CODE_FOR_reload_tf_di_store;
	      reg_addr[TFmode].reload_load  = CODE_FOR_reload_tf_di_load;
	    }

	  /* Only provide a reload handler for SDmode if lfiwzx/stfiwx are
	     available.  */
	  if (TARGET_NO_SDMODE_STACK)
	    {
	      reg_addr[SDmode].reload_store = CODE_FOR_reload_sd_di_store;
	      reg_addr[SDmode].reload_load  = CODE_FOR_reload_sd_di_load;
	    }

	  if (TARGET_VSX)
	    {
	      reg_addr[TImode].reload_store  = CODE_FOR_reload_ti_di_store;
	      reg_addr[TImode].reload_load   = CODE_FOR_reload_ti_di_load;
	    }

	  if (TARGET_DIRECT_MOVE && !TARGET_DIRECT_MOVE_128)
	    {
	      reg_addr[TImode].reload_gpr_vsx    = CODE_FOR_reload_gpr_from_vsxti;
	      reg_addr[V1TImode].reload_gpr_vsx  = CODE_FOR_reload_gpr_from_vsxv1ti;
	      reg_addr[V2DFmode].reload_gpr_vsx  = CODE_FOR_reload_gpr_from_vsxv2df;
	      reg_addr[V2DImode].reload_gpr_vsx  = CODE_FOR_reload_gpr_from_vsxv2di;
	      reg_addr[V4SFmode].reload_gpr_vsx  = CODE_FOR_reload_gpr_from_vsxv4sf;
	      reg_addr[V4SImode].reload_gpr_vsx  = CODE_FOR_reload_gpr_from_vsxv4si;
	      reg_addr[V8HImode].reload_gpr_vsx  = CODE_FOR_reload_gpr_from_vsxv8hi;
	      reg_addr[V16QImode].reload_gpr_vsx = CODE_FOR_reload_gpr_from_vsxv16qi;
	      reg_addr[SFmode].reload_gpr_vsx    = CODE_FOR_reload_gpr_from_vsxsf;

	      reg_addr[TImode].reload_vsx_gpr    = CODE_FOR_reload_vsx_from_gprti;
	      reg_addr[V1TImode].reload_vsx_gpr  = CODE_FOR_reload_vsx_from_gprv1ti;
	      reg_addr[V2DFmode].reload_vsx_gpr  = CODE_FOR_reload_vsx_from_gprv2df;
	      reg_addr[V2DImode].reload_vsx_gpr  = CODE_FOR_reload_vsx_from_gprv2di;
	      reg_addr[V4SFmode].reload_vsx_gpr  = CODE_FOR_reload_vsx_from_gprv4sf;
	      reg_addr[V4SImode].reload_vsx_gpr  = CODE_FOR_reload_vsx_from_gprv4si;
	      reg_addr[V8HImode].reload_vsx_gpr  = CODE_FOR_reload_vsx_from_gprv8hi;
	      reg_addr[V16QImode].reload_vsx_gpr = CODE_FOR_reload_vsx_from_gprv16qi;
	      reg_addr[SFmode].reload_vsx_gpr    = CODE_FOR_reload_vsx_from_gprsf;

	      if (FLOAT128_VECTOR_P (KFmode))
		{
		  reg_addr[KFmode].reload_gpr_vsx = CODE_FOR_reload_gpr_from_vsxkf;
		  reg_addr[KFmode].reload_vsx_gpr = CODE_FOR_reload_vsx_from_gprkf;
		}

	      if (FLOAT128_VECTOR_P (TFmode))
		{
		  reg_addr[TFmode].reload_gpr_vsx = CODE_FOR_reload_gpr_from_vsxtf;
		  reg_addr[TFmode].reload_vsx_gpr = CODE_FOR_reload_vsx_from_gprtf;
		}
	    }
	}
      else
	{
	  reg_addr[V16QImode].reload_store = CODE_FOR_reload_v16qi_si_store;
	  reg_addr[V16QImode].reload_load  = CODE_FOR_reload_v16qi_si_load;
	  reg_addr[V8HImode].reload_store  = CODE_FOR_reload_v8hi_si_store;
	  reg_addr[V8HImode].reload_load   = CODE_FOR_reload_v8hi_si_load;
	  reg_addr[V4SImode].reload_store  = CODE_FOR_reload_v4si_si_store;
	  reg_addr[V4SImode].reload_load   = CODE_FOR_reload_v4si_si_load;
	  reg_addr[V2DImode].reload_store  = CODE_FOR_reload_v2di_si_store;
	  reg_addr[V2DImode].reload_load   = CODE_FOR_reload_v2di_si_load;
	  reg_addr[V1TImode].reload_store  = CODE_FOR_reload_v1ti_si_store;
	  reg_addr[V1TImode].reload_load   = CODE_FOR_reload_v1ti_si_load;
	  reg_addr[V4SFmode].reload_store  = CODE_FOR_reload_v4sf_si_store;
	  reg_addr[V4SFmode].reload_load   = CODE_FOR_reload_v4sf_si_load;
	  reg_addr[V2DFmode].reload_store  = CODE_FOR_reload_v2df_si_store;
	  reg_addr[V2DFmode].reload_load   = CODE_FOR_reload_v2df_si_load;
	  reg_addr[DFmode].reload_store    = CODE_FOR_reload_df_si_store;
	  reg_addr[DFmode].reload_load     = CODE_FOR_reload_df_si_load;
	  reg_addr[DDmode].reload_store    = CODE_FOR_reload_dd_si_store;
	  reg_addr[DDmode].reload_load     = CODE_FOR_reload_dd_si_load;
	  reg_addr[SFmode].reload_store    = CODE_FOR_reload_sf_si_store;
	  reg_addr[SFmode].reload_load     = CODE_FOR_reload_sf_si_load;

	  if (FLOAT128_VECTOR_P (KFmode))
	    {
	      reg_addr[KFmode].reload_store = CODE_FOR_reload_kf_si_store;
	      reg_addr[KFmode].reload_load  = CODE_FOR_reload_kf_si_load;
	    }

	  if (FLOAT128_IEEE_P (TFmode))
	    {
	      reg_addr[TFmode].reload_store = CODE_FOR_reload_tf_si_store;
	      reg_addr[TFmode].reload_load  = CODE_FOR_reload_tf_si_load;
	    }

	  /* Only provide a reload handler for SDmode if lfiwzx/stfiwx are
	     available.  */
	  if (TARGET_NO_SDMODE_STACK)
	    {
	      reg_addr[SDmode].reload_store = CODE_FOR_reload_sd_si_store;
	      reg_addr[SDmode].reload_load  = CODE_FOR_reload_sd_si_load;
	    }

	  if (TARGET_VSX)
	    {
	      reg_addr[TImode].reload_store  = CODE_FOR_reload_ti_si_store;
	      reg_addr[TImode].reload_load   = CODE_FOR_reload_ti_si_load;
	    }

	  if (TARGET_DIRECT_MOVE)
	    {
	      reg_addr[DImode].reload_fpr_gpr = CODE_FOR_reload_fpr_from_gprdi;
	      reg_addr[DDmode].reload_fpr_gpr = CODE_FOR_reload_fpr_from_gprdd;
	      reg_addr[DFmode].reload_fpr_gpr = CODE_FOR_reload_fpr_from_gprdf;
	    }
	}

      reg_addr[DFmode].scalar_in_vmx_p = true;
      reg_addr[DImode].scalar_in_vmx_p = true;

      if (TARGET_P8_VECTOR)
	{
	  reg_addr[SFmode].scalar_in_vmx_p = true;
	  reg_addr[SImode].scalar_in_vmx_p = true;

	  if (TARGET_P9_VECTOR)
	    {
	      reg_addr[HImode].scalar_in_vmx_p = true;
	      reg_addr[QImode].scalar_in_vmx_p = true;
	    }
	}
    }

  /* Precalculate HARD_REGNO_NREGS.  */
  for (r = 0; HARD_REGISTER_NUM_P (r); ++r)
    for (m = 0; m < NUM_MACHINE_MODES; ++m)
      rs6000_hard_regno_nregs[m][r]
	= rs6000_hard_regno_nregs_internal (r, (machine_mode) m);

  /* Precalculate TARGET_HARD_REGNO_MODE_OK.  */
  for (r = 0; HARD_REGISTER_NUM_P (r); ++r)
    for (m = 0; m < NUM_MACHINE_MODES; ++m)
      rs6000_hard_regno_mode_ok_p[m][r]
	= rs6000_hard_regno_mode_ok_uncached (r, (machine_mode) m);

  /* Precalculate CLASS_MAX_NREGS sizes.  */
  for (c = 0; c < LIM_REG_CLASSES; ++c)
    {
      int reg_size;

      if (TARGET_VSX && VSX_REG_CLASS_P (c))
	reg_size = UNITS_PER_VSX_WORD;

      else if (c == ALTIVEC_REGS)
	reg_size = UNITS_PER_ALTIVEC_WORD;

      else if (c == FLOAT_REGS)
	reg_size = UNITS_PER_FP_WORD;

      else
	reg_size = UNITS_PER_WORD;

      for (m = 0; m < NUM_MACHINE_MODES; ++m)
	{
	  machine_mode m2 = (machine_mode)m;
	  int reg_size2 = reg_size;

	  /* TDmode & IBM 128-bit floating point always takes 2 registers, even
	     in VSX.  */
	  if (TARGET_VSX && VSX_REG_CLASS_P (c) && FLOAT128_2REG_P (m))
	    reg_size2 = UNITS_PER_FP_WORD;

	  rs6000_class_max_nregs[m][c]
	    = (GET_MODE_SIZE (m2) + reg_size2 - 1) / reg_size2;
	}
    }

  /* Calculate which modes to automatically generate code to use a the
     reciprocal divide and square root instructions.  In the future, possibly
     automatically generate the instructions even if the user did not specify
     -mrecip.  The older machines double precision reciprocal sqrt estimate is
     not accurate enough.  */
  memset (rs6000_recip_bits, 0, sizeof (rs6000_recip_bits));
  if (TARGET_FRES)
    rs6000_recip_bits[SFmode] = RS6000_RECIP_MASK_HAVE_RE;
  if (TARGET_FRE)
    rs6000_recip_bits[DFmode] = RS6000_RECIP_MASK_HAVE_RE;
  if (VECTOR_UNIT_ALTIVEC_OR_VSX_P (V4SFmode))
    rs6000_recip_bits[V4SFmode] = RS6000_RECIP_MASK_HAVE_RE;
  if (VECTOR_UNIT_VSX_P (V2DFmode))
    rs6000_recip_bits[V2DFmode] = RS6000_RECIP_MASK_HAVE_RE;

  if (TARGET_FRSQRTES)
    rs6000_recip_bits[SFmode] |= RS6000_RECIP_MASK_HAVE_RSQRTE;
  if (TARGET_FRSQRTE)
    rs6000_recip_bits[DFmode] |= RS6000_RECIP_MASK_HAVE_RSQRTE;
  if (VECTOR_UNIT_ALTIVEC_OR_VSX_P (V4SFmode))
    rs6000_recip_bits[V4SFmode] |= RS6000_RECIP_MASK_HAVE_RSQRTE;
  if (VECTOR_UNIT_VSX_P (V2DFmode))
    rs6000_recip_bits[V2DFmode] |= RS6000_RECIP_MASK_HAVE_RSQRTE;

  if (rs6000_recip_control)
    {
      if (!flag_finite_math_only)
	warning (0, "%qs requires %qs or %qs", "-mrecip", "-ffinite-math",
		 "-ffast-math");
      if (flag_trapping_math)
	warning (0, "%qs requires %qs or %qs", "-mrecip",
		 "-fno-trapping-math", "-ffast-math");
      if (!flag_reciprocal_math)
	warning (0, "%qs requires %qs or %qs", "-mrecip", "-freciprocal-math",
		 "-ffast-math");
      if (flag_finite_math_only && !flag_trapping_math && flag_reciprocal_math)
	{
	  if (RS6000_RECIP_HAVE_RE_P (SFmode)
	      && (rs6000_recip_control & RECIP_SF_DIV) != 0)
	    rs6000_recip_bits[SFmode] |= RS6000_RECIP_MASK_AUTO_RE;

	  if (RS6000_RECIP_HAVE_RE_P (DFmode)
	      && (rs6000_recip_control & RECIP_DF_DIV) != 0)
	    rs6000_recip_bits[DFmode] |= RS6000_RECIP_MASK_AUTO_RE;

	  if (RS6000_RECIP_HAVE_RE_P (V4SFmode)
	      && (rs6000_recip_control & RECIP_V4SF_DIV) != 0)
	    rs6000_recip_bits[V4SFmode] |= RS6000_RECIP_MASK_AUTO_RE;

	  if (RS6000_RECIP_HAVE_RE_P (V2DFmode)
	      && (rs6000_recip_control & RECIP_V2DF_DIV) != 0)
	    rs6000_recip_bits[V2DFmode] |= RS6000_RECIP_MASK_AUTO_RE;

	  if (RS6000_RECIP_HAVE_RSQRTE_P (SFmode)
	      && (rs6000_recip_control & RECIP_SF_RSQRT) != 0)
	    rs6000_recip_bits[SFmode] |= RS6000_RECIP_MASK_AUTO_RSQRTE;

	  if (RS6000_RECIP_HAVE_RSQRTE_P (DFmode)
	      && (rs6000_recip_control & RECIP_DF_RSQRT) != 0)
	    rs6000_recip_bits[DFmode] |= RS6000_RECIP_MASK_AUTO_RSQRTE;

	  if (RS6000_RECIP_HAVE_RSQRTE_P (V4SFmode)
	      && (rs6000_recip_control & RECIP_V4SF_RSQRT) != 0)
	    rs6000_recip_bits[V4SFmode] |= RS6000_RECIP_MASK_AUTO_RSQRTE;

	  if (RS6000_RECIP_HAVE_RSQRTE_P (V2DFmode)
	      && (rs6000_recip_control & RECIP_V2DF_RSQRT) != 0)
	    rs6000_recip_bits[V2DFmode] |= RS6000_RECIP_MASK_AUTO_RSQRTE;
	}
    }

  /* Update the addr mask bits in reg_addr to help secondary reload and go if
     legitimate address support to figure out the appropriate addressing to
     use.  */
  rs6000_setup_reg_addr_masks ();

  if (global_init_p || TARGET_DEBUG_TARGET)
    {
      if (TARGET_DEBUG_REG)
	rs6000_debug_reg_global ();

      if (TARGET_DEBUG_COST || TARGET_DEBUG_REG)
	fprintf (stderr,
		 "SImode variable mult cost       = %d\n"
		 "SImode constant mult cost       = %d\n"
		 "SImode short constant mult cost = %d\n"
		 "DImode multipliciation cost     = %d\n"
		 "SImode division cost            = %d\n"
		 "DImode division cost            = %d\n"
		 "Simple fp operation cost        = %d\n"
		 "DFmode multiplication cost      = %d\n"
		 "SFmode division cost            = %d\n"
		 "DFmode division cost            = %d\n"
		 "cache line size                 = %d\n"
		 "l1 cache size                   = %d\n"
		 "l2 cache size                   = %d\n"
		 "simultaneous prefetches         = %d\n"
		 "\n",
		 rs6000_cost->mulsi,
		 rs6000_cost->mulsi_const,
		 rs6000_cost->mulsi_const9,
		 rs6000_cost->muldi,
		 rs6000_cost->divsi,
		 rs6000_cost->divdi,
		 rs6000_cost->fp,
		 rs6000_cost->dmul,
		 rs6000_cost->sdiv,
		 rs6000_cost->ddiv,
		 rs6000_cost->cache_line_size,
		 rs6000_cost->l1_cache_size,
		 rs6000_cost->l2_cache_size,
		 rs6000_cost->simultaneous_prefetches);
    }
}

#if TARGET_MACHO
/* The Darwin version of SUBTARGET_OVERRIDE_OPTIONS.  */

static void
darwin_rs6000_override_options (void)
{
  /* The Darwin ABI always includes AltiVec, can't be (validly) turned
     off.  */
  rs6000_altivec_abi = 1;
  TARGET_ALTIVEC_VRSAVE = 1;
  rs6000_current_abi = ABI_DARWIN;

  if (DEFAULT_ABI == ABI_DARWIN
      && TARGET_64BIT)
      darwin_one_byte_bool = 1;

  if (TARGET_64BIT && ! TARGET_POWERPC64)
    {
      rs6000_isa_flags |= OPTION_MASK_POWERPC64;
      warning (0, "%qs requires PowerPC64 architecture, enabling", "-m64");
    }
  if (flag_mkernel)
    {
      rs6000_default_long_calls = 1;
      rs6000_isa_flags |= OPTION_MASK_SOFT_FLOAT;
    }

  /* Make -m64 imply -maltivec.  Darwin's 64-bit ABI includes
     Altivec.  */
  if (!flag_mkernel && !flag_apple_kext
      && TARGET_64BIT
      && ! (rs6000_isa_flags_explicit & OPTION_MASK_ALTIVEC))
    rs6000_isa_flags |= OPTION_MASK_ALTIVEC;

  /* Unless the user (not the configurer) has explicitly overridden
     it with -mcpu=G3 or -mno-altivec, then 10.5+ targets default to
     G4 unless targeting the kernel.  */
  if (!flag_mkernel
      && !flag_apple_kext
      && strverscmp (darwin_macosx_version_min, "10.5") >= 0
      && ! (rs6000_isa_flags_explicit & OPTION_MASK_ALTIVEC)
      && ! global_options_set.x_rs6000_cpu_index)
    {
      rs6000_isa_flags |= OPTION_MASK_ALTIVEC;
    }
}
#endif

/* If not otherwise specified by a target, make 'long double' equivalent to
   'double'.  */

#ifndef RS6000_DEFAULT_LONG_DOUBLE_SIZE
#define RS6000_DEFAULT_LONG_DOUBLE_SIZE 64
#endif

/* Return the builtin mask of the various options used that could affect which
   builtins were used.  In the past we used target_flags, but we've run out of
   bits, and some options are no longer in target_flags.  */

HOST_WIDE_INT
rs6000_builtin_mask_calculate (void)
{
  return (((TARGET_ALTIVEC)		    ? RS6000_BTM_ALTIVEC   : 0)
	  | ((TARGET_CMPB)		    ? RS6000_BTM_CMPB	   : 0)
	  | ((TARGET_VSX)		    ? RS6000_BTM_VSX	   : 0)
	  | ((TARGET_FRE)		    ? RS6000_BTM_FRE	   : 0)
	  | ((TARGET_FRES)		    ? RS6000_BTM_FRES	   : 0)
	  | ((TARGET_FRSQRTE)		    ? RS6000_BTM_FRSQRTE   : 0)
	  | ((TARGET_FRSQRTES)		    ? RS6000_BTM_FRSQRTES  : 0)
	  | ((TARGET_POPCNTD)		    ? RS6000_BTM_POPCNTD   : 0)
	  | ((rs6000_cpu == PROCESSOR_CELL) ? RS6000_BTM_CELL      : 0)
	  | ((TARGET_P8_VECTOR)		    ? RS6000_BTM_P8_VECTOR : 0)
	  | ((TARGET_P9_VECTOR)		    ? RS6000_BTM_P9_VECTOR : 0)
	  | ((TARGET_P9_MISC)		    ? RS6000_BTM_P9_MISC   : 0)
	  | ((TARGET_MODULO)		    ? RS6000_BTM_MODULO    : 0)
	  | ((TARGET_64BIT)		    ? RS6000_BTM_64BIT     : 0)
	  | ((TARGET_POWERPC64)		    ? RS6000_BTM_POWERPC64 : 0)
	  | ((TARGET_CRYPTO)		    ? RS6000_BTM_CRYPTO	   : 0)
	  | ((TARGET_HTM)		    ? RS6000_BTM_HTM	   : 0)
	  | ((TARGET_DFP)		    ? RS6000_BTM_DFP	   : 0)
	  | ((TARGET_HARD_FLOAT)	    ? RS6000_BTM_HARD_FLOAT : 0)
	  | ((TARGET_LONG_DOUBLE_128
	      && TARGET_HARD_FLOAT
	      && !TARGET_IEEEQUAD)	    ? RS6000_BTM_LDBL128   : 0)
	  | ((TARGET_FLOAT128_TYPE)	    ? RS6000_BTM_FLOAT128  : 0)
	  | ((TARGET_FLOAT128_HW)	    ? RS6000_BTM_FLOAT128_HW : 0));
}

/* Implement TARGET_MD_ASM_ADJUST.  All asm statements are considered
   to clobber the XER[CA] bit because clobbering that bit without telling
   the compiler worked just fine with versions of GCC before GCC 5, and
   breaking a lot of older code in ways that are hard to track down is
   not such a great idea.  */

static rtx_insn *
rs6000_md_asm_adjust (vec<rtx> &/*outputs*/, vec<rtx> &/*inputs*/,
		      vec<const char *> &/*constraints*/,
		      vec<rtx> &clobbers, HARD_REG_SET &clobbered_regs)
{
  clobbers.safe_push (gen_rtx_REG (SImode, CA_REGNO));
  SET_HARD_REG_BIT (clobbered_regs, CA_REGNO);
  return NULL;
}

/* Override command line options.

   Combine build-specific configuration information with options
   specified on the command line to set various state variables which
   influence code generation, optimization, and expansion of built-in
   functions.  Assure that command-line configuration preferences are
   compatible with each other and with the build configuration; issue
   warnings while adjusting configuration or error messages while
   rejecting configuration.

   Upon entry to this function:

     This function is called once at the beginning of
     compilation, and then again at the start and end of compiling
     each section of code that has a different configuration, as
     indicated, for example, by adding the

       __attribute__((__target__("cpu=power9")))

     qualifier to a function definition or, for example, by bracketing
     code between

       #pragma GCC target("altivec")

     and

       #pragma GCC reset_options

     directives.  Parameter global_init_p is true for the initial
     invocation, which initializes global variables, and false for all
     subsequent invocations.


     Various global state information is assumed to be valid.  This
     includes OPTION_TARGET_CPU_DEFAULT, representing the name of the
     default CPU specified at build configure time, TARGET_DEFAULT,
     representing the default set of option flags for the default
     target, and global_options_set.x_rs6000_isa_flags, representing
     which options were requested on the command line.

   Upon return from this function:

     rs6000_isa_flags_explicit has a non-zero bit for each flag that
     was set by name on the command line.  Additionally, if certain
     attributes are automatically enabled or disabled by this function
     in order to assure compatibility between options and
     configuration, the flags associated with those attributes are
     also set.  By setting these "explicit bits", we avoid the risk
     that other code might accidentally overwrite these particular
     attributes with "default values".

     The various bits of rs6000_isa_flags are set to indicate the
     target options that have been selected for the most current
     compilation efforts.  This has the effect of also turning on the
     associated TARGET_XXX values since these are macros which are
     generally defined to test the corresponding bit of the
     rs6000_isa_flags variable.

     The variable rs6000_builtin_mask is set to represent the target
     options for the most current compilation efforts, consistent with
     the current contents of rs6000_isa_flags.  This variable controls
     expansion of built-in functions.

     Various other global variables and fields of global structures
     (over 50 in all) are initialized to reflect the desired options
     for the most current compilation efforts.  */

static bool
rs6000_option_override_internal (bool global_init_p)
{
  bool ret = true;

  HOST_WIDE_INT set_masks;
  HOST_WIDE_INT ignore_masks;
  int cpu_index = -1;
  int tune_index;
  struct cl_target_option *main_target_opt
    = ((global_init_p || target_option_default_node == NULL)
       ? NULL : TREE_TARGET_OPTION (target_option_default_node));

  /* Print defaults.  */
  if ((TARGET_DEBUG_REG || TARGET_DEBUG_TARGET) && global_init_p)
    rs6000_print_isa_options (stderr, 0, "TARGET_DEFAULT", TARGET_DEFAULT);

  /* Remember the explicit arguments.  */
  if (global_init_p)
    rs6000_isa_flags_explicit = global_options_set.x_rs6000_isa_flags;

  /* On 64-bit Darwin, power alignment is ABI-incompatible with some C
     library functions, so warn about it. The flag may be useful for
     performance studies from time to time though, so don't disable it
     entirely.  */
  if (global_options_set.x_rs6000_alignment_flags
      && rs6000_alignment_flags == MASK_ALIGN_POWER
      && DEFAULT_ABI == ABI_DARWIN
      && TARGET_64BIT)
    warning (0, "%qs is not supported for 64-bit Darwin;"
	     " it is incompatible with the installed C and C++ libraries",
	     "-malign-power");

  /* Numerous experiment shows that IRA based loop pressure
     calculation works better for RTL loop invariant motion on targets
     with enough (>= 32) registers.  It is an expensive optimization.
     So it is on only for peak performance.  */
  if (optimize >= 3 && global_init_p
      && !global_options_set.x_flag_ira_loop_pressure)
    flag_ira_loop_pressure = 1;

  /* -fsanitize=address needs to turn on -fasynchronous-unwind-tables in order
     for tracebacks to be complete but not if any -fasynchronous-unwind-tables
     options were already specified.  */
  if (flag_sanitize & SANITIZE_USER_ADDRESS
      && !global_options_set.x_flag_asynchronous_unwind_tables)
    flag_asynchronous_unwind_tables = 1;

  /* Set the pointer size.  */
  if (TARGET_64BIT)
    {
      rs6000_pmode = DImode;
      rs6000_pointer_size = 64;
    }
  else
    {
      rs6000_pmode = SImode;
      rs6000_pointer_size = 32;
    }

  /* Some OSs don't support saving the high part of 64-bit registers on context
     switch.  Other OSs don't support saving Altivec registers.  On those OSs,
     we don't touch the OPTION_MASK_POWERPC64 or OPTION_MASK_ALTIVEC settings;
     if the user wants either, the user must explicitly specify them and we
     won't interfere with the user's specification.  */

  set_masks = POWERPC_MASKS;
#ifdef OS_MISSING_POWERPC64
  if (OS_MISSING_POWERPC64)
    set_masks &= ~OPTION_MASK_POWERPC64;
#endif
#ifdef OS_MISSING_ALTIVEC
  if (OS_MISSING_ALTIVEC)
    set_masks &= ~(OPTION_MASK_ALTIVEC | OPTION_MASK_VSX
		   | OTHER_VSX_VECTOR_MASKS);
#endif

  /* Don't override by the processor default if given explicitly.  */
  set_masks &= ~rs6000_isa_flags_explicit;

  if (global_init_p && rs6000_dejagnu_cpu_index >= 0)
    rs6000_cpu_index = rs6000_dejagnu_cpu_index;

  /* Process the -mcpu=<xxx> and -mtune=<xxx> argument.  If the user changed
     the cpu in a target attribute or pragma, but did not specify a tuning
     option, use the cpu for the tuning option rather than the option specified
     with -mtune on the command line.  Process a '--with-cpu' configuration
     request as an implicit --cpu.  */
  if (rs6000_cpu_index >= 0)
    cpu_index = rs6000_cpu_index;
  else if (main_target_opt != NULL && main_target_opt->x_rs6000_cpu_index >= 0)
    cpu_index = main_target_opt->x_rs6000_cpu_index;
  else if (OPTION_TARGET_CPU_DEFAULT)
    cpu_index = rs6000_cpu_name_lookup (OPTION_TARGET_CPU_DEFAULT);

  /* If we have a cpu, either through an explicit -mcpu=<xxx> or if the
     compiler was configured with --with-cpu=<xxx>, replace all of the ISA bits
     with those from the cpu, except for options that were explicitly set.  If
     we don't have a cpu, do not override the target bits set in
     TARGET_DEFAULT.  */
  if (cpu_index >= 0)
    {
      rs6000_cpu_index = cpu_index;
      rs6000_isa_flags &= ~set_masks;
      rs6000_isa_flags |= (processor_target_table[cpu_index].target_enable
			   & set_masks);
    }
  else
    {
      /* If no -mcpu=<xxx>, inherit any default options that were cleared via
	 POWERPC_MASKS.  Originally, TARGET_DEFAULT was used to initialize
	 target_flags via the TARGET_DEFAULT_TARGET_FLAGS hook.  When we switched
	 to using rs6000_isa_flags, we need to do the initialization here.

	 If there is a TARGET_DEFAULT, use that.  Otherwise fall back to using
	 -mcpu=powerpc, -mcpu=powerpc64, or -mcpu=powerpc64le defaults.  */
      HOST_WIDE_INT flags;
      if (TARGET_DEFAULT)
	flags = TARGET_DEFAULT;
      else
	{
	  /* PowerPC 64-bit LE requires at least ISA 2.07.  */
	  const char *default_cpu = (!TARGET_POWERPC64
				     ? "powerpc"
				     : (BYTES_BIG_ENDIAN
					? "powerpc64"
					: "powerpc64le"));
	  int default_cpu_index = rs6000_cpu_name_lookup (default_cpu);
	  flags = processor_target_table[default_cpu_index].target_enable;
	}
      rs6000_isa_flags |= (flags & ~rs6000_isa_flags_explicit);
    }

  if (rs6000_tune_index >= 0)
    tune_index = rs6000_tune_index;
  else if (cpu_index >= 0)
    rs6000_tune_index = tune_index = cpu_index;
  else
    {
      size_t i;
      enum processor_type tune_proc
	= (TARGET_POWERPC64 ? PROCESSOR_DEFAULT64 : PROCESSOR_DEFAULT);

      tune_index = -1;
      for (i = 0; i < ARRAY_SIZE (processor_target_table); i++)
	if (processor_target_table[i].processor == tune_proc)
	  {
	    tune_index = i;
	    break;
	  }
    }

  if (cpu_index >= 0)
    rs6000_cpu = processor_target_table[cpu_index].processor;
  else
    rs6000_cpu = TARGET_POWERPC64 ? PROCESSOR_DEFAULT64 : PROCESSOR_DEFAULT;

  gcc_assert (tune_index >= 0);
  rs6000_tune = processor_target_table[tune_index].processor;

  if (rs6000_cpu == PROCESSOR_PPCE300C2 || rs6000_cpu == PROCESSOR_PPCE300C3
      || rs6000_cpu == PROCESSOR_PPCE500MC || rs6000_cpu == PROCESSOR_PPCE500MC64
      || rs6000_cpu == PROCESSOR_PPCE5500)
    {
      if (TARGET_ALTIVEC)
	error ("AltiVec not supported in this target");
    }

  /* If we are optimizing big endian systems for space, use the load/store
     multiple instructions.  */
  if (BYTES_BIG_ENDIAN && optimize_size)
    rs6000_isa_flags |= ~rs6000_isa_flags_explicit & OPTION_MASK_MULTIPLE;

  /* Don't allow -mmultiple on little endian systems unless the cpu is a 750,
     because the hardware doesn't support the instructions used in little
     endian mode, and causes an alignment trap.  The 750 does not cause an
     alignment trap (except when the target is unaligned).  */

  if (!BYTES_BIG_ENDIAN && rs6000_cpu != PROCESSOR_PPC750 && TARGET_MULTIPLE)
    {
      rs6000_isa_flags &= ~OPTION_MASK_MULTIPLE;
      if ((rs6000_isa_flags_explicit & OPTION_MASK_MULTIPLE) != 0)
	warning (0, "%qs is not supported on little endian systems",
		 "-mmultiple");
    }

  /* If little-endian, default to -mstrict-align on older processors.
     Testing for htm matches power8 and later.  */
  if (!BYTES_BIG_ENDIAN
      && !(processor_target_table[tune_index].target_enable & OPTION_MASK_HTM))
    rs6000_isa_flags |= ~rs6000_isa_flags_explicit & OPTION_MASK_STRICT_ALIGN;

  if (!rs6000_fold_gimple)
     fprintf (stderr,
	      "gimple folding of rs6000 builtins has been disabled.\n");

  /* Add some warnings for VSX.  */
  if (TARGET_VSX)
    {
      const char *msg = NULL;
      if (!TARGET_HARD_FLOAT)
	{
	  if (rs6000_isa_flags_explicit & OPTION_MASK_VSX)
	    msg = N_("%<-mvsx%> requires hardware floating point");
	  else
	    {
	      rs6000_isa_flags &= ~ OPTION_MASK_VSX;
	      rs6000_isa_flags_explicit |= OPTION_MASK_VSX;
	    }
	}
      else if (TARGET_AVOID_XFORM > 0)
	msg = N_("%<-mvsx%> needs indexed addressing");
      else if (!TARGET_ALTIVEC && (rs6000_isa_flags_explicit
				   & OPTION_MASK_ALTIVEC))
        {
	  if (rs6000_isa_flags_explicit & OPTION_MASK_VSX)
	    msg = N_("%<-mvsx%> and %<-mno-altivec%> are incompatible");
	  else
	    msg = N_("%<-mno-altivec%> disables vsx");
        }

      if (msg)
	{
	  warning (0, msg);
	  rs6000_isa_flags &= ~ OPTION_MASK_VSX;
	  rs6000_isa_flags_explicit |= OPTION_MASK_VSX;
	}
    }

  /* If hard-float/altivec/vsx were explicitly turned off then don't allow
     the -mcpu setting to enable options that conflict. */
  if ((!TARGET_HARD_FLOAT || !TARGET_ALTIVEC || !TARGET_VSX)
      && (rs6000_isa_flags_explicit & (OPTION_MASK_SOFT_FLOAT
				       | OPTION_MASK_ALTIVEC
				       | OPTION_MASK_VSX)) != 0)
    rs6000_isa_flags &= ~((OPTION_MASK_P8_VECTOR | OPTION_MASK_CRYPTO
			   | OPTION_MASK_DIRECT_MOVE)
		         & ~rs6000_isa_flags_explicit);

  if (TARGET_DEBUG_REG || TARGET_DEBUG_TARGET)
    rs6000_print_isa_options (stderr, 0, "before defaults", rs6000_isa_flags);

  /* Handle explicit -mno-{altivec,vsx,power8-vector,power9-vector} and turn
     off all of the options that depend on those flags.  */
  ignore_masks = rs6000_disable_incompatible_switches ();

  /* For the newer switches (vsx, dfp, etc.) set some of the older options,
     unless the user explicitly used the -mno-<option> to disable the code.  */
  if (TARGET_P9_VECTOR || TARGET_MODULO || TARGET_P9_MISC)
    rs6000_isa_flags |= (ISA_3_0_MASKS_SERVER & ~ignore_masks);
  else if (TARGET_P9_MINMAX)
    {
      if (cpu_index >= 0)
	{
	  if (cpu_index == PROCESSOR_POWER9)
	    {
	      /* legacy behavior: allow -mcpu=power9 with certain
		 capabilities explicitly disabled.  */
	      rs6000_isa_flags |= (ISA_3_0_MASKS_SERVER & ~ignore_masks);
	    }
	  else
	    error ("power9 target option is incompatible with %<%s=<xxx>%> "
		   "for <xxx> less than power9", "-mcpu");
	}
      else if ((ISA_3_0_MASKS_SERVER & rs6000_isa_flags_explicit)
	       != (ISA_3_0_MASKS_SERVER & rs6000_isa_flags
		   & rs6000_isa_flags_explicit))
	/* Enforce that none of the ISA_3_0_MASKS_SERVER flags
	   were explicitly cleared.  */
	error ("%qs incompatible with explicitly disabled options",
	       "-mpower9-minmax");
      else
	rs6000_isa_flags |= ISA_3_0_MASKS_SERVER;
    }
  else if (TARGET_P8_VECTOR || TARGET_DIRECT_MOVE || TARGET_CRYPTO)
    rs6000_isa_flags |= (ISA_2_7_MASKS_SERVER & ~ignore_masks);
  else if (TARGET_VSX)
    rs6000_isa_flags |= (ISA_2_6_MASKS_SERVER & ~ignore_masks);
  else if (TARGET_POPCNTD)
    rs6000_isa_flags |= (ISA_2_6_MASKS_EMBEDDED & ~ignore_masks);
  else if (TARGET_DFP)
    rs6000_isa_flags |= (ISA_2_5_MASKS_SERVER & ~ignore_masks);
  else if (TARGET_CMPB)
    rs6000_isa_flags |= (ISA_2_5_MASKS_EMBEDDED & ~ignore_masks);
  else if (TARGET_FPRND)
    rs6000_isa_flags |= (ISA_2_4_MASKS & ~ignore_masks);
  else if (TARGET_POPCNTB)
    rs6000_isa_flags |= (ISA_2_2_MASKS & ~ignore_masks);
  else if (TARGET_ALTIVEC)
    rs6000_isa_flags |= (OPTION_MASK_PPC_GFXOPT & ~ignore_masks);

  if (TARGET_CRYPTO && !TARGET_ALTIVEC)
    {
      if (rs6000_isa_flags_explicit & OPTION_MASK_CRYPTO)
	error ("%qs requires %qs", "-mcrypto", "-maltivec");
      rs6000_isa_flags &= ~OPTION_MASK_CRYPTO;
    }

  if (TARGET_DIRECT_MOVE && !TARGET_VSX)
    {
      if (rs6000_isa_flags_explicit & OPTION_MASK_DIRECT_MOVE)
	error ("%qs requires %qs", "-mdirect-move", "-mvsx");
      rs6000_isa_flags &= ~OPTION_MASK_DIRECT_MOVE;
    }

  if (TARGET_P8_VECTOR && !TARGET_ALTIVEC)
    {
      if (rs6000_isa_flags_explicit & OPTION_MASK_P8_VECTOR)
	error ("%qs requires %qs", "-mpower8-vector", "-maltivec");
      rs6000_isa_flags &= ~OPTION_MASK_P8_VECTOR;
    }

  if (TARGET_P8_VECTOR && !TARGET_VSX)
    {
      if ((rs6000_isa_flags_explicit & OPTION_MASK_P8_VECTOR)
	  && (rs6000_isa_flags_explicit & OPTION_MASK_VSX))
	error ("%qs requires %qs", "-mpower8-vector", "-mvsx");
      else if ((rs6000_isa_flags_explicit & OPTION_MASK_P8_VECTOR) == 0)
	{
	  rs6000_isa_flags &= ~OPTION_MASK_P8_VECTOR;
	  if (rs6000_isa_flags_explicit & OPTION_MASK_VSX)
	    rs6000_isa_flags_explicit |= OPTION_MASK_P8_VECTOR;
	}
      else
	{
	  /* OPTION_MASK_P8_VECTOR is explicit, and OPTION_MASK_VSX is
	     not explicit.  */
	  rs6000_isa_flags |= OPTION_MASK_VSX;
	  rs6000_isa_flags_explicit |= OPTION_MASK_VSX;
	}
    }

  if (TARGET_DFP && !TARGET_HARD_FLOAT)
    {
      if (rs6000_isa_flags_explicit & OPTION_MASK_DFP)
	error ("%qs requires %qs", "-mhard-dfp", "-mhard-float");
      rs6000_isa_flags &= ~OPTION_MASK_DFP;
    }

  /* The quad memory instructions only works in 64-bit mode. In 32-bit mode,
     silently turn off quad memory mode.  */
  if ((TARGET_QUAD_MEMORY || TARGET_QUAD_MEMORY_ATOMIC) && !TARGET_POWERPC64)
    {
      if ((rs6000_isa_flags_explicit & OPTION_MASK_QUAD_MEMORY) != 0)
	warning (0, N_("%<-mquad-memory%> requires 64-bit mode"));

      if ((rs6000_isa_flags_explicit & OPTION_MASK_QUAD_MEMORY_ATOMIC) != 0)
	warning (0, N_("%<-mquad-memory-atomic%> requires 64-bit mode"));

      rs6000_isa_flags &= ~(OPTION_MASK_QUAD_MEMORY
			    | OPTION_MASK_QUAD_MEMORY_ATOMIC);
    }

  /* Non-atomic quad memory load/store are disabled for little endian, since
     the words are reversed, but atomic operations can still be done by
     swapping the words.  */
  if (TARGET_QUAD_MEMORY && !WORDS_BIG_ENDIAN)
    {
      if ((rs6000_isa_flags_explicit & OPTION_MASK_QUAD_MEMORY) != 0)
	warning (0, N_("%<-mquad-memory%> is not available in little endian "
		       "mode"));

      rs6000_isa_flags &= ~OPTION_MASK_QUAD_MEMORY;
    }

  /* Assume if the user asked for normal quad memory instructions, they want
     the atomic versions as well, unless they explicity told us not to use quad
     word atomic instructions.  */
  if (TARGET_QUAD_MEMORY
      && !TARGET_QUAD_MEMORY_ATOMIC
      && ((rs6000_isa_flags_explicit & OPTION_MASK_QUAD_MEMORY_ATOMIC) == 0))
    rs6000_isa_flags |= OPTION_MASK_QUAD_MEMORY_ATOMIC;

  /* If we can shrink-wrap the TOC register save separately, then use
     -msave-toc-indirect unless explicitly disabled.  */
  if ((rs6000_isa_flags_explicit & OPTION_MASK_SAVE_TOC_INDIRECT) == 0
      && flag_shrink_wrap_separate
      && optimize_function_for_speed_p (cfun))
    rs6000_isa_flags |= OPTION_MASK_SAVE_TOC_INDIRECT;

  /* Enable power8 fusion if we are tuning for power8, even if we aren't
     generating power8 instructions.  Power9 does not optimize power8 fusion
     cases.  */
  if (!(rs6000_isa_flags_explicit & OPTION_MASK_P8_FUSION))
    {
      if (processor_target_table[tune_index].processor == PROCESSOR_POWER8)
	rs6000_isa_flags |= OPTION_MASK_P8_FUSION;
      else
	rs6000_isa_flags &= ~OPTION_MASK_P8_FUSION;
    }

  /* Setting additional fusion flags turns on base fusion.  */
  if (!TARGET_P8_FUSION && TARGET_P8_FUSION_SIGN)
    {
      if (rs6000_isa_flags_explicit & OPTION_MASK_P8_FUSION)
	{
	  if (TARGET_P8_FUSION_SIGN)
	    error ("%qs requires %qs", "-mpower8-fusion-sign",
		   "-mpower8-fusion");

	  rs6000_isa_flags &= ~OPTION_MASK_P8_FUSION;
	}
      else
	rs6000_isa_flags |= OPTION_MASK_P8_FUSION;
    }

  /* Power8 does not fuse sign extended loads with the addis.  If we are
     optimizing at high levels for speed, convert a sign extended load into a
     zero extending load, and an explicit sign extension.  */
  if (TARGET_P8_FUSION
      && !(rs6000_isa_flags_explicit & OPTION_MASK_P8_FUSION_SIGN)
      && optimize_function_for_speed_p (cfun)
      && optimize >= 3)
    rs6000_isa_flags |= OPTION_MASK_P8_FUSION_SIGN;

  /* ISA 3.0 vector instructions include ISA 2.07.  */
  if (TARGET_P9_VECTOR && !TARGET_P8_VECTOR)
    {
      /* We prefer to not mention undocumented options in
	 error messages.  However, if users have managed to select
	 power9-vector without selecting power8-vector, they
	 already know about undocumented flags.  */
      if ((rs6000_isa_flags_explicit & OPTION_MASK_P9_VECTOR) &&
	  (rs6000_isa_flags_explicit & OPTION_MASK_P8_VECTOR))
	error ("%qs requires %qs", "-mpower9-vector", "-mpower8-vector");
      else if ((rs6000_isa_flags_explicit & OPTION_MASK_P9_VECTOR) == 0)
	{
	  rs6000_isa_flags &= ~OPTION_MASK_P9_VECTOR;
	  if (rs6000_isa_flags_explicit & OPTION_MASK_P8_VECTOR)
	    rs6000_isa_flags_explicit |= OPTION_MASK_P9_VECTOR;
	}
      else
	{
	  /* OPTION_MASK_P9_VECTOR is explicit and
	     OPTION_MASK_P8_VECTOR is not explicit.  */
	  rs6000_isa_flags |= OPTION_MASK_P8_VECTOR;
	  rs6000_isa_flags_explicit |= OPTION_MASK_P8_VECTOR;
	}
    }

  /* Set -mallow-movmisalign to explicitly on if we have full ISA 2.07
     support. If we only have ISA 2.06 support, and the user did not specify
     the switch, leave it set to -1 so the movmisalign patterns are enabled,
     but we don't enable the full vectorization support  */
  if (TARGET_ALLOW_MOVMISALIGN == -1 && TARGET_P8_VECTOR && TARGET_DIRECT_MOVE)
    TARGET_ALLOW_MOVMISALIGN = 1;

  else if (TARGET_ALLOW_MOVMISALIGN && !TARGET_VSX)
    {
      if (TARGET_ALLOW_MOVMISALIGN > 0
	  && global_options_set.x_TARGET_ALLOW_MOVMISALIGN)
	error ("%qs requires %qs", "-mallow-movmisalign", "-mvsx");

      TARGET_ALLOW_MOVMISALIGN = 0;
    }

  /* Determine when unaligned vector accesses are permitted, and when
     they are preferred over masked Altivec loads.  Note that if
     TARGET_ALLOW_MOVMISALIGN has been disabled by the user, then
     TARGET_EFFICIENT_UNALIGNED_VSX must be as well.  The converse is
     not true.  */
  if (TARGET_EFFICIENT_UNALIGNED_VSX)
    {
      if (!TARGET_VSX)
	{
	  if (rs6000_isa_flags_explicit & OPTION_MASK_EFFICIENT_UNALIGNED_VSX)
	    error ("%qs requires %qs", "-mefficient-unaligned-vsx", "-mvsx");

	  rs6000_isa_flags &= ~OPTION_MASK_EFFICIENT_UNALIGNED_VSX;
	}

      else if (!TARGET_ALLOW_MOVMISALIGN)
	{
	  if (rs6000_isa_flags_explicit & OPTION_MASK_EFFICIENT_UNALIGNED_VSX)
	    error ("%qs requires %qs", "-munefficient-unaligned-vsx",
		   "-mallow-movmisalign");

	  rs6000_isa_flags &= ~OPTION_MASK_EFFICIENT_UNALIGNED_VSX;
	}
    }

  /* Use long double size to select the appropriate long double.  We use
     TYPE_PRECISION to differentiate the 3 different long double types.  We map
     128 into the precision used for TFmode.  */
  int default_long_double_size = (RS6000_DEFAULT_LONG_DOUBLE_SIZE == 64
				  ? 64
				  : FLOAT_PRECISION_TFmode);

  /* Set long double size before the IEEE 128-bit tests.  */
  if (!global_options_set.x_rs6000_long_double_type_size)
    {
      if (main_target_opt != NULL
	  && (main_target_opt->x_rs6000_long_double_type_size
	      != default_long_double_size))
	error ("target attribute or pragma changes %<long double%> size");
      else
	rs6000_long_double_type_size = default_long_double_size;
    }
  else if (rs6000_long_double_type_size == 128)
    rs6000_long_double_type_size = FLOAT_PRECISION_TFmode;
  else if (global_options_set.x_rs6000_ieeequad)
    {
      if (global_options.x_rs6000_ieeequad)
	error ("%qs requires %qs", "-mabi=ieeelongdouble", "-mlong-double-128");
      else
	error ("%qs requires %qs", "-mabi=ibmlongdouble", "-mlong-double-128");
    }

  /* Set -mabi=ieeelongdouble on some old targets.  In the future, power server
     systems will also set long double to be IEEE 128-bit.  AIX and Darwin
     explicitly redefine TARGET_IEEEQUAD and TARGET_IEEEQUAD_DEFAULT to 0, so
     those systems will not pick up this default.  Warn if the user changes the
     default unless -Wno-psabi.  */
  if (!global_options_set.x_rs6000_ieeequad)
    rs6000_ieeequad = TARGET_IEEEQUAD_DEFAULT;

  else
    {
      if (global_options.x_rs6000_ieeequad
	  && (!TARGET_POPCNTD || !TARGET_VSX))
	error ("%qs requires full ISA 2.06 support", "-mabi=ieeelongdouble");

      if (rs6000_ieeequad != TARGET_IEEEQUAD_DEFAULT && TARGET_LONG_DOUBLE_128)
	{
	  static bool warned_change_long_double;
	  if (!warned_change_long_double)
	    {
	      warned_change_long_double = true;
	      if (TARGET_IEEEQUAD)
		warning (OPT_Wpsabi, "Using IEEE extended precision "
			 "%<long double%>");
	      else
		warning (OPT_Wpsabi, "Using IBM extended precision "
			 "%<long double%>");
	    }
	}
    }

  /* Enable the default support for IEEE 128-bit floating point on Linux VSX
     sytems.  In GCC 7, we would enable the the IEEE 128-bit floating point
     infrastructure (-mfloat128-type) but not enable the actual __float128 type
     unless the user used the explicit -mfloat128.  In GCC 8, we enable both
     the keyword as well as the type.  */
  TARGET_FLOAT128_TYPE = TARGET_FLOAT128_ENABLE_TYPE && TARGET_VSX;

  /* IEEE 128-bit floating point requires VSX support.  */
  if (TARGET_FLOAT128_KEYWORD)
    {
      if (!TARGET_VSX)
	{
	  if ((rs6000_isa_flags_explicit & OPTION_MASK_FLOAT128_KEYWORD) != 0)
	    error ("%qs requires VSX support", "%<-mfloat128%>");

	  TARGET_FLOAT128_TYPE = 0;
	  rs6000_isa_flags &= ~(OPTION_MASK_FLOAT128_KEYWORD
				| OPTION_MASK_FLOAT128_HW);
	}
      else if (!TARGET_FLOAT128_TYPE)
	{
	  TARGET_FLOAT128_TYPE = 1;
	  warning (0, "The %<-mfloat128%> option may not be fully supported");
	}
    }

  /* Enable the __float128 keyword under Linux by default.  */
  if (TARGET_FLOAT128_TYPE && !TARGET_FLOAT128_KEYWORD
      && (rs6000_isa_flags_explicit & OPTION_MASK_FLOAT128_KEYWORD) == 0)
    rs6000_isa_flags |= OPTION_MASK_FLOAT128_KEYWORD;

  /* If we have are supporting the float128 type and full ISA 3.0 support,
     enable -mfloat128-hardware by default.  However, don't enable the
     __float128 keyword if it was explicitly turned off.  64-bit mode is needed
     because sometimes the compiler wants to put things in an integer
     container, and if we don't have __int128 support, it is impossible.  */
  if (TARGET_FLOAT128_TYPE && !TARGET_FLOAT128_HW && TARGET_64BIT
      && (rs6000_isa_flags & ISA_3_0_MASKS_IEEE) == ISA_3_0_MASKS_IEEE
      && !(rs6000_isa_flags_explicit & OPTION_MASK_FLOAT128_HW))
    rs6000_isa_flags |= OPTION_MASK_FLOAT128_HW;

  if (TARGET_FLOAT128_HW
      && (rs6000_isa_flags & ISA_3_0_MASKS_IEEE) != ISA_3_0_MASKS_IEEE)
    {
      if ((rs6000_isa_flags_explicit & OPTION_MASK_FLOAT128_HW) != 0)
	error ("%qs requires full ISA 3.0 support", "%<-mfloat128-hardware%>");

      rs6000_isa_flags &= ~OPTION_MASK_FLOAT128_HW;
    }

  if (TARGET_FLOAT128_HW && !TARGET_64BIT)
    {
      if ((rs6000_isa_flags_explicit & OPTION_MASK_FLOAT128_HW) != 0)
	error ("%qs requires %qs", "%<-mfloat128-hardware%>", "-m64");

      rs6000_isa_flags &= ~OPTION_MASK_FLOAT128_HW;
    }

  /* -mprefixed-addr (and hence -mpcrel) requires -mcpu=future.  */
  if (TARGET_PREFIXED_ADDR && !TARGET_FUTURE)
    {
      if ((rs6000_isa_flags_explicit & OPTION_MASK_PCREL) != 0)
	error ("%qs requires %qs", "-mpcrel", "-mcpu=future");
      else if ((rs6000_isa_flags_explicit & OPTION_MASK_PREFIXED_ADDR) != 0)
	error ("%qs requires %qs", "-mprefixed-addr", "-mcpu=future");

      rs6000_isa_flags &= ~(OPTION_MASK_PCREL | OPTION_MASK_PREFIXED_ADDR);
    }

  /* -mpcrel requires prefixed load/store addressing.  */
  if (TARGET_PCREL && !TARGET_PREFIXED_ADDR)
    {
      if ((rs6000_isa_flags_explicit & OPTION_MASK_PCREL) != 0)
	error ("%qs requires %qs", "-mpcrel", "-mprefixed-addr");

      rs6000_isa_flags &= ~OPTION_MASK_PCREL;
    }

  /* Print the options after updating the defaults.  */
  if (TARGET_DEBUG_REG || TARGET_DEBUG_TARGET)
    rs6000_print_isa_options (stderr, 0, "after defaults", rs6000_isa_flags);

  /* E500mc does "better" if we inline more aggressively.  Respect the
     user's opinion, though.  */
  if (rs6000_block_move_inline_limit == 0
      && (rs6000_tune == PROCESSOR_PPCE500MC
	  || rs6000_tune == PROCESSOR_PPCE500MC64
	  || rs6000_tune == PROCESSOR_PPCE5500
	  || rs6000_tune == PROCESSOR_PPCE6500))
    rs6000_block_move_inline_limit = 128;

  /* store_one_arg depends on expand_block_move to handle at least the
     size of reg_parm_stack_space.  */
  if (rs6000_block_move_inline_limit < (TARGET_POWERPC64 ? 64 : 32))
    rs6000_block_move_inline_limit = (TARGET_POWERPC64 ? 64 : 32);

  if (global_init_p)
    {
      /* If the appropriate debug option is enabled, replace the target hooks
	 with debug versions that call the real version and then prints
	 debugging information.  */
      if (TARGET_DEBUG_COST)
	{
	  targetm.rtx_costs = rs6000_debug_rtx_costs;
	  targetm.address_cost = rs6000_debug_address_cost;
	  targetm.sched.adjust_cost = rs6000_debug_adjust_cost;
	}

      if (TARGET_DEBUG_ADDR)
	{
	  targetm.legitimate_address_p = rs6000_debug_legitimate_address_p;
	  targetm.legitimize_address = rs6000_debug_legitimize_address;
	  rs6000_secondary_reload_class_ptr
	    = rs6000_debug_secondary_reload_class;
	  targetm.secondary_memory_needed
	    = rs6000_debug_secondary_memory_needed;
	  targetm.can_change_mode_class
	    = rs6000_debug_can_change_mode_class;
	  rs6000_preferred_reload_class_ptr
	    = rs6000_debug_preferred_reload_class;
	  rs6000_mode_dependent_address_ptr
	    = rs6000_debug_mode_dependent_address;
	}

      if (rs6000_veclibabi_name)
	{
	  if (strcmp (rs6000_veclibabi_name, "mass") == 0)
	    rs6000_veclib_handler = rs6000_builtin_vectorized_libmass;
	  else
	    {
	      error ("unknown vectorization library ABI type (%qs) for "
		     "%qs switch", rs6000_veclibabi_name, "-mveclibabi=");
	      ret = false;
	    }
	}
    }

  /* Disable VSX and Altivec silently if the user switched cpus to power7 in a
     target attribute or pragma which automatically enables both options,
     unless the altivec ABI was set.  This is set by default for 64-bit, but
     not for 32-bit.  */
  if (main_target_opt != NULL && !main_target_opt->x_rs6000_altivec_abi)
    {
      TARGET_FLOAT128_TYPE = 0;
      rs6000_isa_flags &= ~((OPTION_MASK_VSX | OPTION_MASK_ALTIVEC
			     | OPTION_MASK_FLOAT128_KEYWORD)
			    & ~rs6000_isa_flags_explicit);
    }

  /* Enable Altivec ABI for AIX -maltivec.  */
  if (TARGET_XCOFF && (TARGET_ALTIVEC || TARGET_VSX))
    {
      if (main_target_opt != NULL && !main_target_opt->x_rs6000_altivec_abi)
	error ("target attribute or pragma changes AltiVec ABI");
      else
	rs6000_altivec_abi = 1;
    }

  /* The AltiVec ABI is the default for PowerPC-64 GNU/Linux.  For
     PowerPC-32 GNU/Linux, -maltivec implies the AltiVec ABI.  It can
     be explicitly overridden in either case.  */
  if (TARGET_ELF)
    {
      if (!global_options_set.x_rs6000_altivec_abi
	  && (TARGET_64BIT || TARGET_ALTIVEC || TARGET_VSX))
	{
	  if (main_target_opt != NULL &&
	      !main_target_opt->x_rs6000_altivec_abi)
	    error ("target attribute or pragma changes AltiVec ABI");
	  else
	    rs6000_altivec_abi = 1;
	}
    }

  /* Set the Darwin64 ABI as default for 64-bit Darwin.  
     So far, the only darwin64 targets are also MACH-O.  */
  if (TARGET_MACHO
      && DEFAULT_ABI == ABI_DARWIN 
      && TARGET_64BIT)
    {
      if (main_target_opt != NULL && !main_target_opt->x_rs6000_darwin64_abi)
	error ("target attribute or pragma changes darwin64 ABI");
      else
	{
	  rs6000_darwin64_abi = 1;
	  /* Default to natural alignment, for better performance.  */
	  rs6000_alignment_flags = MASK_ALIGN_NATURAL;
	}
    }

  /* Place FP constants in the constant pool instead of TOC
     if section anchors enabled.  */
  if (flag_section_anchors
      && !global_options_set.x_TARGET_NO_FP_IN_TOC)
    TARGET_NO_FP_IN_TOC = 1;

  if (TARGET_DEBUG_REG || TARGET_DEBUG_TARGET)
    rs6000_print_isa_options (stderr, 0, "before subtarget", rs6000_isa_flags);

#ifdef SUBTARGET_OVERRIDE_OPTIONS
  SUBTARGET_OVERRIDE_OPTIONS;
#endif
#ifdef SUBSUBTARGET_OVERRIDE_OPTIONS
  SUBSUBTARGET_OVERRIDE_OPTIONS;
#endif
#ifdef SUB3TARGET_OVERRIDE_OPTIONS
  SUB3TARGET_OVERRIDE_OPTIONS;
#endif

  if (TARGET_DEBUG_REG || TARGET_DEBUG_TARGET)
    rs6000_print_isa_options (stderr, 0, "after subtarget", rs6000_isa_flags);

  rs6000_always_hint = (rs6000_tune != PROCESSOR_POWER4
			&& rs6000_tune != PROCESSOR_POWER5
			&& rs6000_tune != PROCESSOR_POWER6
			&& rs6000_tune != PROCESSOR_POWER7
			&& rs6000_tune != PROCESSOR_POWER8
			&& rs6000_tune != PROCESSOR_POWER9
			&& rs6000_tune != PROCESSOR_FUTURE
			&& rs6000_tune != PROCESSOR_PPCA2
			&& rs6000_tune != PROCESSOR_CELL
			&& rs6000_tune != PROCESSOR_PPC476);
  rs6000_sched_groups = (rs6000_tune == PROCESSOR_POWER4
			 || rs6000_tune == PROCESSOR_POWER5
			 || rs6000_tune == PROCESSOR_POWER7
			 || rs6000_tune == PROCESSOR_POWER8);
  rs6000_align_branch_targets = (rs6000_tune == PROCESSOR_POWER4
				 || rs6000_tune == PROCESSOR_POWER5
				 || rs6000_tune == PROCESSOR_POWER6
				 || rs6000_tune == PROCESSOR_POWER7
				 || rs6000_tune == PROCESSOR_POWER8
				 || rs6000_tune == PROCESSOR_POWER9
				 || rs6000_tune == PROCESSOR_FUTURE
				 || rs6000_tune == PROCESSOR_PPCE500MC
				 || rs6000_tune == PROCESSOR_PPCE500MC64
				 || rs6000_tune == PROCESSOR_PPCE5500
				 || rs6000_tune == PROCESSOR_PPCE6500);

  /* Allow debug switches to override the above settings.  These are set to -1
     in rs6000.opt to indicate the user hasn't directly set the switch.  */
  if (TARGET_ALWAYS_HINT >= 0)
    rs6000_always_hint = TARGET_ALWAYS_HINT;

  if (TARGET_SCHED_GROUPS >= 0)
    rs6000_sched_groups = TARGET_SCHED_GROUPS;

  if (TARGET_ALIGN_BRANCH_TARGETS >= 0)
    rs6000_align_branch_targets = TARGET_ALIGN_BRANCH_TARGETS;

  rs6000_sched_restricted_insns_priority
    = (rs6000_sched_groups ? 1 : 0);

  /* Handle -msched-costly-dep option.  */
  rs6000_sched_costly_dep
    = (rs6000_sched_groups ? true_store_to_load_dep_costly : no_dep_costly);

  if (rs6000_sched_costly_dep_str)
    {
      if (! strcmp (rs6000_sched_costly_dep_str, "no"))
	rs6000_sched_costly_dep = no_dep_costly;
      else if (! strcmp (rs6000_sched_costly_dep_str, "all"))
	rs6000_sched_costly_dep = all_deps_costly;
      else if (! strcmp (rs6000_sched_costly_dep_str, "true_store_to_load"))
	rs6000_sched_costly_dep = true_store_to_load_dep_costly;
      else if (! strcmp (rs6000_sched_costly_dep_str, "store_to_load"))
	rs6000_sched_costly_dep = store_to_load_dep_costly;
      else
	rs6000_sched_costly_dep = ((enum rs6000_dependence_cost)
				   atoi (rs6000_sched_costly_dep_str));
    }

  /* Handle -minsert-sched-nops option.  */
  rs6000_sched_insert_nops
    = (rs6000_sched_groups ? sched_finish_regroup_exact : sched_finish_none);

  if (rs6000_sched_insert_nops_str)
    {
      if (! strcmp (rs6000_sched_insert_nops_str, "no"))
	rs6000_sched_insert_nops = sched_finish_none;
      else if (! strcmp (rs6000_sched_insert_nops_str, "pad"))
	rs6000_sched_insert_nops = sched_finish_pad_groups;
      else if (! strcmp (rs6000_sched_insert_nops_str, "regroup_exact"))
	rs6000_sched_insert_nops = sched_finish_regroup_exact;
      else
	rs6000_sched_insert_nops = ((enum rs6000_nop_insertion)
				    atoi (rs6000_sched_insert_nops_str));
    }

  /* Handle stack protector */
  if (!global_options_set.x_rs6000_stack_protector_guard)
#ifdef TARGET_THREAD_SSP_OFFSET
    rs6000_stack_protector_guard = SSP_TLS;
#else
    rs6000_stack_protector_guard = SSP_GLOBAL;
#endif

#ifdef TARGET_THREAD_SSP_OFFSET
  rs6000_stack_protector_guard_offset = TARGET_THREAD_SSP_OFFSET;
  rs6000_stack_protector_guard_reg = TARGET_64BIT ? 13 : 2;
#endif

  if (global_options_set.x_rs6000_stack_protector_guard_offset_str)
    {
      char *endp;
      const char *str = rs6000_stack_protector_guard_offset_str;

      errno = 0;
      long offset = strtol (str, &endp, 0);
      if (!*str || *endp || errno)
	error ("%qs is not a valid number in %qs", str,
	       "-mstack-protector-guard-offset=");

      if (!IN_RANGE (offset, -0x8000, 0x7fff)
	  || (TARGET_64BIT && (offset & 3)))
	error ("%qs is not a valid offset in %qs", str,
	       "-mstack-protector-guard-offset=");

      rs6000_stack_protector_guard_offset = offset;
    }

  if (global_options_set.x_rs6000_stack_protector_guard_reg_str)
    {
      const char *str = rs6000_stack_protector_guard_reg_str;
      int reg = decode_reg_name (str);

      if (!IN_RANGE (reg, 1, 31))
	error ("%qs is not a valid base register in %qs", str,
	       "-mstack-protector-guard-reg=");

      rs6000_stack_protector_guard_reg = reg;
    }

  if (rs6000_stack_protector_guard == SSP_TLS
      && !IN_RANGE (rs6000_stack_protector_guard_reg, 1, 31))
    error ("%qs needs a valid base register", "-mstack-protector-guard=tls");

  if (global_init_p)
    {
#ifdef TARGET_REGNAMES
      /* If the user desires alternate register names, copy in the
	 alternate names now.  */
      if (TARGET_REGNAMES)
	memcpy (rs6000_reg_names, alt_reg_names, sizeof (rs6000_reg_names));
#endif

      /* Set aix_struct_return last, after the ABI is determined.
	 If -maix-struct-return or -msvr4-struct-return was explicitly
	 used, don't override with the ABI default.  */
      if (!global_options_set.x_aix_struct_return)
	aix_struct_return = (DEFAULT_ABI != ABI_V4 || DRAFT_V4_STRUCT_RET);

#if 0
      /* IBM XL compiler defaults to unsigned bitfields.  */
      if (TARGET_XL_COMPAT)
	flag_signed_bitfields = 0;
#endif

      if (TARGET_LONG_DOUBLE_128 && !TARGET_IEEEQUAD)
	REAL_MODE_FORMAT (TFmode) = &ibm_extended_format;

      ASM_GENERATE_INTERNAL_LABEL (toc_label_name, "LCTOC", 1);

      /* We can only guarantee the availability of DI pseudo-ops when
	 assembling for 64-bit targets.  */
      if (!TARGET_64BIT)
	{
	  targetm.asm_out.aligned_op.di = NULL;
	  targetm.asm_out.unaligned_op.di = NULL;
	}


      /* Set branch target alignment, if not optimizing for size.  */
      if (!optimize_size)
	{
	  /* Cell wants to be aligned 8byte for dual issue.  Titan wants to be
	     aligned 8byte to avoid misprediction by the branch predictor.  */
	  if (rs6000_tune == PROCESSOR_TITAN
	      || rs6000_tune == PROCESSOR_CELL)
	    {
	      if (flag_align_functions && !str_align_functions)
		str_align_functions = "8";
	      if (flag_align_jumps && !str_align_jumps)
		str_align_jumps = "8";
	      if (flag_align_loops && !str_align_loops)
		str_align_loops = "8";
	    }
	  if (rs6000_align_branch_targets)
	    {
	      if (flag_align_functions && !str_align_functions)
		str_align_functions = "16";
	      if (flag_align_jumps && !str_align_jumps)
		str_align_jumps = "16";
	      if (flag_align_loops && !str_align_loops)
		{
		  can_override_loop_align = 1;
		  str_align_loops = "16";
		}
	    }

	  if (flag_align_jumps && !str_align_jumps)
	    str_align_jumps = "16";
	  if (flag_align_loops && !str_align_loops)
	    str_align_loops = "16";
	}

      /* Arrange to save and restore machine status around nested functions.  */
      init_machine_status = rs6000_init_machine_status;

      /* We should always be splitting complex arguments, but we can't break
	 Linux and Darwin ABIs at the moment.  For now, only AIX is fixed.  */
      if (DEFAULT_ABI == ABI_V4 || DEFAULT_ABI == ABI_DARWIN)
	targetm.calls.split_complex_arg = NULL;

      /* The AIX and ELFv1 ABIs define standard function descriptors.  */
      if (DEFAULT_ABI == ABI_AIX)
	targetm.calls.custom_function_descriptors = 0;
    }

  /* Initialize rs6000_cost with the appropriate target costs.  */
  if (optimize_size)
    rs6000_cost = TARGET_POWERPC64 ? &size64_cost : &size32_cost;
  else
    switch (rs6000_tune)
      {
      case PROCESSOR_RS64A:
	rs6000_cost = &rs64a_cost;
	break;

      case PROCESSOR_MPCCORE:
	rs6000_cost = &mpccore_cost;
	break;

      case PROCESSOR_PPC403:
	rs6000_cost = &ppc403_cost;
	break;

      case PROCESSOR_PPC405:
	rs6000_cost = &ppc405_cost;
	break;

      case PROCESSOR_PPC440:
	rs6000_cost = &ppc440_cost;
	break;

      case PROCESSOR_PPC476:
	rs6000_cost = &ppc476_cost;
	break;

      case PROCESSOR_PPC601:
	rs6000_cost = &ppc601_cost;
	break;

      case PROCESSOR_PPC603:
	rs6000_cost = &ppc603_cost;
	break;

      case PROCESSOR_PPC604:
	rs6000_cost = &ppc604_cost;
	break;

      case PROCESSOR_PPC604e:
	rs6000_cost = &ppc604e_cost;
	break;

      case PROCESSOR_PPC620:
	rs6000_cost = &ppc620_cost;
	break;

      case PROCESSOR_PPC630:
	rs6000_cost = &ppc630_cost;
	break;

      case PROCESSOR_CELL:
	rs6000_cost = &ppccell_cost;
	break;

      case PROCESSOR_PPC750:
      case PROCESSOR_PPC7400:
	rs6000_cost = &ppc750_cost;
	break;

      case PROCESSOR_PPC7450:
	rs6000_cost = &ppc7450_cost;
	break;

      case PROCESSOR_PPC8540:
      case PROCESSOR_PPC8548:
	rs6000_cost = &ppc8540_cost;
	break;

      case PROCESSOR_PPCE300C2:
      case PROCESSOR_PPCE300C3:
	rs6000_cost = &ppce300c2c3_cost;
	break;

      case PROCESSOR_PPCE500MC:
	rs6000_cost = &ppce500mc_cost;
	break;

      case PROCESSOR_PPCE500MC64:
	rs6000_cost = &ppce500mc64_cost;
	break;

      case PROCESSOR_PPCE5500:
	rs6000_cost = &ppce5500_cost;
	break;

      case PROCESSOR_PPCE6500:
	rs6000_cost = &ppce6500_cost;
	break;

      case PROCESSOR_TITAN:
	rs6000_cost = &titan_cost;
	break;

      case PROCESSOR_POWER4:
      case PROCESSOR_POWER5:
	rs6000_cost = &power4_cost;
	break;

      case PROCESSOR_POWER6:
	rs6000_cost = &power6_cost;
	break;

      case PROCESSOR_POWER7:
	rs6000_cost = &power7_cost;
	break;

      case PROCESSOR_POWER8:
	rs6000_cost = &power8_cost;
	break;

      case PROCESSOR_POWER9:
      case PROCESSOR_FUTURE:
	rs6000_cost = &power9_cost;
	break;

      case PROCESSOR_PPCA2:
	rs6000_cost = &ppca2_cost;
	break;

      default:
	gcc_unreachable ();
      }

  if (global_init_p)
    {
      maybe_set_param_value (PARAM_SIMULTANEOUS_PREFETCHES,
			     rs6000_cost->simultaneous_prefetches,
			     global_options.x_param_values,
			     global_options_set.x_param_values);
      maybe_set_param_value (PARAM_L1_CACHE_SIZE, rs6000_cost->l1_cache_size,
			     global_options.x_param_values,
			     global_options_set.x_param_values);
      maybe_set_param_value (PARAM_L1_CACHE_LINE_SIZE,
			     rs6000_cost->cache_line_size,
			     global_options.x_param_values,
			     global_options_set.x_param_values);
      maybe_set_param_value (PARAM_L2_CACHE_SIZE, rs6000_cost->l2_cache_size,
			     global_options.x_param_values,
			     global_options_set.x_param_values);

      /* Increase loop peeling limits based on performance analysis. */
      maybe_set_param_value (PARAM_MAX_PEELED_INSNS, 400,
			     global_options.x_param_values,
			     global_options_set.x_param_values);
      maybe_set_param_value (PARAM_MAX_COMPLETELY_PEELED_INSNS, 400,
			     global_options.x_param_values,
			     global_options_set.x_param_values);

      /* Use the 'model' -fsched-pressure algorithm by default.  */
      maybe_set_param_value (PARAM_SCHED_PRESSURE_ALGORITHM,
			     SCHED_PRESSURE_MODEL,
			     global_options.x_param_values,
			     global_options_set.x_param_values);

      /* If using typedef char *va_list, signal that
	 __builtin_va_start (&ap, 0) can be optimized to
	 ap = __builtin_next_arg (0).  */
      if (DEFAULT_ABI != ABI_V4)
	targetm.expand_builtin_va_start = NULL;
    }

  /* If not explicitly specified via option, decide whether to generate indexed
     load/store instructions.  A value of -1 indicates that the
     initial value of this variable has not been overwritten. During
     compilation, TARGET_AVOID_XFORM is either 0 or 1. */
  if (TARGET_AVOID_XFORM == -1)
    /* Avoid indexed addressing when targeting Power6 in order to avoid the
     DERAT mispredict penalty.  However the LVE and STVE altivec instructions
     need indexed accesses and the type used is the scalar type of the element
     being loaded or stored.  */
    TARGET_AVOID_XFORM = (rs6000_tune == PROCESSOR_POWER6 && TARGET_CMPB
			  && !TARGET_ALTIVEC);

  /* Set the -mrecip options.  */
  if (rs6000_recip_name)
    {
      char *p = ASTRDUP (rs6000_recip_name);
      char *q;
      unsigned int mask, i;
      bool invert;

      while ((q = strtok (p, ",")) != NULL)
	{
	  p = NULL;
	  if (*q == '!')
	    {
	      invert = true;
	      q++;
	    }
	  else
	    invert = false;

	  if (!strcmp (q, "default"))
	    mask = ((TARGET_RECIP_PRECISION)
		    ? RECIP_HIGH_PRECISION : RECIP_LOW_PRECISION);
	  else
	    {
	      for (i = 0; i < ARRAY_SIZE (recip_options); i++)
		if (!strcmp (q, recip_options[i].string))
		  {
		    mask = recip_options[i].mask;
		    break;
		  }

	      if (i == ARRAY_SIZE (recip_options))
		{
		  error ("unknown option for %<%s=%s%>", "-mrecip", q);
		  invert = false;
		  mask = 0;
		  ret = false;
		}
	    }

	  if (invert)
	    rs6000_recip_control &= ~mask;
	  else
	    rs6000_recip_control |= mask;
	}
    }

  /* Set the builtin mask of the various options used that could affect which
     builtins were used.  In the past we used target_flags, but we've run out
     of bits, and some options are no longer in target_flags.  */
  rs6000_builtin_mask = rs6000_builtin_mask_calculate ();
  if (TARGET_DEBUG_BUILTIN || TARGET_DEBUG_TARGET)
    rs6000_print_builtin_options (stderr, 0, "builtin mask",
				  rs6000_builtin_mask);

  /* Initialize all of the registers.  */
  rs6000_init_hard_regno_mode_ok (global_init_p);

  /* Save the initial options in case the user does function specific options */
  if (global_init_p)
    target_option_default_node = target_option_current_node
      = build_target_option_node (&global_options);

  /* If not explicitly specified via option, decide whether to generate the
     extra blr's required to preserve the link stack on some cpus (eg, 476).  */
  if (TARGET_LINK_STACK == -1)
    SET_TARGET_LINK_STACK (rs6000_tune == PROCESSOR_PPC476 && flag_pic);

  /* Deprecate use of -mno-speculate-indirect-jumps.  */
  if (!rs6000_speculate_indirect_jumps)
    warning (0, "%qs is deprecated and not recommended in any circumstances",
	     "-mno-speculate-indirect-jumps");

  return ret;
}

/* Implement TARGET_OPTION_OVERRIDE.  On the RS/6000 this is used to
   define the target cpu type.  */

static void
rs6000_option_override (void)
{
  (void) rs6000_option_override_internal (true);
}


/* Implement targetm.vectorize.builtin_mask_for_load.  */
static tree
rs6000_builtin_mask_for_load (void)
{
  /* Don't use lvsl/vperm for P8 and similarly efficient machines.  */
  if ((TARGET_ALTIVEC && !TARGET_VSX)
      || (TARGET_VSX && !TARGET_EFFICIENT_UNALIGNED_VSX))
    return altivec_builtin_mask_for_load;
  else
    return 0;
}

/* Implement LOOP_ALIGN. */
align_flags
rs6000_loop_align (rtx label)
{
  basic_block bb;
  int ninsns;

  /* Don't override loop alignment if -falign-loops was specified. */
  if (!can_override_loop_align)
    return align_loops;

  bb = BLOCK_FOR_INSN (label);
  ninsns = num_loop_insns(bb->loop_father);

  /* Align small loops to 32 bytes to fit in an icache sector, otherwise return default. */
  if (ninsns > 4 && ninsns <= 8
      && (rs6000_tune == PROCESSOR_POWER4
	  || rs6000_tune == PROCESSOR_POWER5
	  || rs6000_tune == PROCESSOR_POWER6
	  || rs6000_tune == PROCESSOR_POWER7
	  || rs6000_tune == PROCESSOR_POWER8))
    return align_flags (5);
  else
    return align_loops;
}

/* Return true iff, data reference of TYPE can reach vector alignment (16)
   after applying N number of iterations.  This routine does not determine
   how may iterations are required to reach desired alignment.  */

static bool
rs6000_vector_alignment_reachable (const_tree type ATTRIBUTE_UNUSED, bool is_packed)
{
  if (is_packed)
    return false;

  if (TARGET_32BIT)
    {
      if (rs6000_alignment_flags == MASK_ALIGN_NATURAL)
        return true;

      if (rs6000_alignment_flags ==  MASK_ALIGN_POWER)
        return true;

      return false;
    }
  else
    {
      if (TARGET_MACHO)
        return false;

      /* Assuming that all other types are naturally aligned. CHECKME!  */
      return true;
    }
}

/* Return true if the vector misalignment factor is supported by the
   target.  */ 
static bool
rs6000_builtin_support_vector_misalignment (machine_mode mode,
					    const_tree type,
					    int misalignment,
					    bool is_packed)
{
  if (TARGET_VSX)
    {
      if (TARGET_EFFICIENT_UNALIGNED_VSX)
	return true;

      /* Return if movmisalign pattern is not supported for this mode.  */
      if (optab_handler (movmisalign_optab, mode) == CODE_FOR_nothing)
        return false;

      if (misalignment == -1)
	{
	  /* Misalignment factor is unknown at compile time but we know
	     it's word aligned.  */
	  if (rs6000_vector_alignment_reachable (type, is_packed))
            {
              int element_size = TREE_INT_CST_LOW (TYPE_SIZE (type));

              if (element_size == 64 || element_size == 32)
               return true;
            }

	  return false;
	}

      /* VSX supports word-aligned vector.  */
      if (misalignment % 4 == 0)
	return true;
    }
  return false;
}

/* Implement targetm.vectorize.builtin_vectorization_cost.  */
static int
rs6000_builtin_vectorization_cost (enum vect_cost_for_stmt type_of_cost,
                                   tree vectype, int misalign)
{
  unsigned elements;
  tree elem_type;

  switch (type_of_cost)
    {
      case scalar_stmt:
      case scalar_load:
      case scalar_store:
      case vector_stmt:
      case vector_load:
      case vector_store:
      case vec_to_scalar:
      case scalar_to_vec:
      case cond_branch_not_taken:
        return 1;

      case vec_perm:
	if (TARGET_VSX)
	  return 3;
	else
	  return 1;

      case vec_promote_demote:
        if (TARGET_VSX)
          return 4;
        else
          return 1;

      case cond_branch_taken:
        return 3;

      case unaligned_load:
      case vector_gather_load:
	if (TARGET_EFFICIENT_UNALIGNED_VSX)
	  return 1;

        if (TARGET_VSX && TARGET_ALLOW_MOVMISALIGN)
          {
            elements = TYPE_VECTOR_SUBPARTS (vectype);
            if (elements == 2)
              /* Double word aligned.  */
              return 2;

            if (elements == 4)
              {
                switch (misalign)
                  {
                    case 8:
                      /* Double word aligned.  */
                      return 2;

                    case -1:
                      /* Unknown misalignment.  */
                    case 4:
                    case 12:
                      /* Word aligned.  */
                      return 22;

                    default:
                      gcc_unreachable ();
                  }
              }
          }

        if (TARGET_ALTIVEC)
          /* Misaligned loads are not supported.  */
          gcc_unreachable ();

        return 2;

      case unaligned_store:
      case vector_scatter_store:
	if (TARGET_EFFICIENT_UNALIGNED_VSX)
	  return 1;

        if (TARGET_VSX && TARGET_ALLOW_MOVMISALIGN)
          {
            elements = TYPE_VECTOR_SUBPARTS (vectype);
            if (elements == 2)
              /* Double word aligned.  */
              return 2;

            if (elements == 4)
              {
                switch (misalign)
                  {
                    case 8:
                      /* Double word aligned.  */
                      return 2;

                    case -1:
                      /* Unknown misalignment.  */
                    case 4:
                    case 12:
                      /* Word aligned.  */
                      return 23;

                    default:
                      gcc_unreachable ();
                  }
              }
          }

        if (TARGET_ALTIVEC)
          /* Misaligned stores are not supported.  */
          gcc_unreachable ();

        return 2;

      case vec_construct:
	/* This is a rough approximation assuming non-constant elements
	   constructed into a vector via element insertion.  FIXME:
	   vec_construct is not granular enough for uniformly good
	   decisions.  If the initialization is a splat, this is
	   cheaper than we estimate.  Improve this someday.  */
	elem_type = TREE_TYPE (vectype);
	/* 32-bit vectors loaded into registers are stored as double
	   precision, so we need 2 permutes, 2 converts, and 1 merge
	   to construct a vector of short floats from them.  */
	if (SCALAR_FLOAT_TYPE_P (elem_type)
	    && TYPE_PRECISION (elem_type) == 32)
	  return 5;
	/* On POWER9, integer vector types are built up in GPRs and then
	   use a direct move (2 cycles).  For POWER8 this is even worse,
	   as we need two direct moves and a merge, and the direct moves
	   are five cycles.  */
	else if (INTEGRAL_TYPE_P (elem_type))
	  {
	    if (TARGET_P9_VECTOR)
	      return TYPE_VECTOR_SUBPARTS (vectype) - 1 + 2;
	    else
	      return TYPE_VECTOR_SUBPARTS (vectype) - 1 + 5;
	  }
	else
	  /* V2DFmode doesn't need a direct move.  */
	  return 2;

      default:
        gcc_unreachable ();
    }
}

/* Implement targetm.vectorize.preferred_simd_mode.  */

static machine_mode
rs6000_preferred_simd_mode (scalar_mode mode)
{
  if (TARGET_VSX)
    switch (mode)
      {
      case E_DFmode:
	return V2DFmode;
      default:;
      }
  if (TARGET_ALTIVEC || TARGET_VSX)
    switch (mode)
      {
      case E_SFmode:
	return V4SFmode;
      case E_TImode:
	return V1TImode;
      case E_DImode:
	return V2DImode;
      case E_SImode:
	return V4SImode;
      case E_HImode:
	return V8HImode;
      case E_QImode:
	return V16QImode;
      default:;
      }
  return word_mode;
}

typedef struct _rs6000_cost_data
{
  struct loop *loop_info;
  unsigned cost[3];
} rs6000_cost_data;

/* Test for likely overcommitment of vector hardware resources.  If a
   loop iteration is relatively large, and too large a percentage of
   instructions in the loop are vectorized, the cost model may not
   adequately reflect delays from unavailable vector resources.
   Penalize the loop body cost for this case.  */

static void
rs6000_density_test (rs6000_cost_data *data)
{
  const int DENSITY_PCT_THRESHOLD = 85;
  const int DENSITY_SIZE_THRESHOLD = 70;
  const int DENSITY_PENALTY = 10;
  struct loop *loop = data->loop_info;
  basic_block *bbs = get_loop_body (loop);
  int nbbs = loop->num_nodes;
  loop_vec_info loop_vinfo = loop_vec_info_for_loop (data->loop_info);
  int vec_cost = data->cost[vect_body], not_vec_cost = 0;
  int i, density_pct;

  for (i = 0; i < nbbs; i++)
    {
      basic_block bb = bbs[i];
      gimple_stmt_iterator gsi;

      for (gsi = gsi_start_bb (bb); !gsi_end_p (gsi); gsi_next (&gsi))
	{
	  gimple *stmt = gsi_stmt (gsi);
	  stmt_vec_info stmt_info = loop_vinfo->lookup_stmt (stmt);

	  if (!STMT_VINFO_RELEVANT_P (stmt_info)
	      && !STMT_VINFO_IN_PATTERN_P (stmt_info))
	    not_vec_cost++;
	}
    }

  free (bbs);
  density_pct = (vec_cost * 100) / (vec_cost + not_vec_cost);

  if (density_pct > DENSITY_PCT_THRESHOLD
      && vec_cost + not_vec_cost > DENSITY_SIZE_THRESHOLD)
    {
      data->cost[vect_body] = vec_cost * (100 + DENSITY_PENALTY) / 100;
      if (dump_enabled_p ())
	dump_printf_loc (MSG_NOTE, vect_location,
			 "density %d%%, cost %d exceeds threshold, penalizing "
			 "loop body cost by %d%%", density_pct,
			 vec_cost + not_vec_cost, DENSITY_PENALTY);
    }
}

/* Implement targetm.vectorize.init_cost.  */

/* For each vectorized loop, this var holds TRUE iff a non-memory vector
   instruction is needed by the vectorization.  */
static bool rs6000_vect_nonmem;

static void *
rs6000_init_cost (struct loop *loop_info)
{
  rs6000_cost_data *data = XNEW (struct _rs6000_cost_data);
  data->loop_info = loop_info;
  data->cost[vect_prologue] = 0;
  data->cost[vect_body]     = 0;
  data->cost[vect_epilogue] = 0;
  rs6000_vect_nonmem = false;
  return data;
}

/* Implement targetm.vectorize.add_stmt_cost.  */

static unsigned
rs6000_add_stmt_cost (void *data, int count, enum vect_cost_for_stmt kind,
		      struct _stmt_vec_info *stmt_info, int misalign,
		      enum vect_cost_model_location where)
{
  rs6000_cost_data *cost_data = (rs6000_cost_data*) data;
  unsigned retval = 0;

  if (flag_vect_cost_model)
    {
      tree vectype = stmt_info ? stmt_vectype (stmt_info) : NULL_TREE;
      int stmt_cost = rs6000_builtin_vectorization_cost (kind, vectype,
							 misalign);
      /* Statements in an inner loop relative to the loop being
	 vectorized are weighted more heavily.  The value here is
	 arbitrary and could potentially be improved with analysis.  */
      if (where == vect_body && stmt_info && stmt_in_inner_loop_p (stmt_info))
	count *= 50;  /* FIXME.  */

      retval = (unsigned) (count * stmt_cost);
      cost_data->cost[where] += retval;

      /* Check whether we're doing something other than just a copy loop.
	 Not all such loops may be profitably vectorized; see
	 rs6000_finish_cost.  */
      if ((kind == vec_to_scalar || kind == vec_perm
	   || kind == vec_promote_demote || kind == vec_construct
	   || kind == scalar_to_vec)
	  || (where == vect_body && kind == vector_stmt))
	rs6000_vect_nonmem = true;
    }

  return retval;
}

/* Implement targetm.vectorize.finish_cost.  */

static void
rs6000_finish_cost (void *data, unsigned *prologue_cost,
		    unsigned *body_cost, unsigned *epilogue_cost)
{
  rs6000_cost_data *cost_data = (rs6000_cost_data*) data;

  if (cost_data->loop_info)
    rs6000_density_test (cost_data);

  /* Don't vectorize minimum-vectorization-factor, simple copy loops
     that require versioning for any reason.  The vectorization is at
     best a wash inside the loop, and the versioning checks make
     profitability highly unlikely and potentially quite harmful.  */
  if (cost_data->loop_info)
    {
      loop_vec_info vec_info = loop_vec_info_for_loop (cost_data->loop_info);
      if (!rs6000_vect_nonmem
	  && LOOP_VINFO_VECT_FACTOR (vec_info) == 2
	  && LOOP_REQUIRES_VERSIONING (vec_info))
	cost_data->cost[vect_body] += 10000;
    }

  *prologue_cost = cost_data->cost[vect_prologue];
  *body_cost     = cost_data->cost[vect_body];
  *epilogue_cost = cost_data->cost[vect_epilogue];
}

/* Implement targetm.vectorize.destroy_cost_data.  */

static void
rs6000_destroy_cost_data (void *data)
{
  free (data);
}

/* Handler for the Mathematical Acceleration Subsystem (mass) interface to a
   library with vectorized intrinsics.  */

static tree
rs6000_builtin_vectorized_libmass (combined_fn fn, tree type_out,
				   tree type_in)
{
  char name[32];
  const char *suffix = NULL;
  tree fntype, new_fndecl, bdecl = NULL_TREE;
  int n_args = 1;
  const char *bname;
  machine_mode el_mode, in_mode;
  int n, in_n;

  /* Libmass is suitable for unsafe math only as it does not correctly support
     parts of IEEE with the required precision such as denormals.  Only support
     it if we have VSX to use the simd d2 or f4 functions.
     XXX: Add variable length support.  */
  if (!flag_unsafe_math_optimizations || !TARGET_VSX)
    return NULL_TREE;

  el_mode = TYPE_MODE (TREE_TYPE (type_out));
  n = TYPE_VECTOR_SUBPARTS (type_out);
  in_mode = TYPE_MODE (TREE_TYPE (type_in));
  in_n = TYPE_VECTOR_SUBPARTS (type_in);
  if (el_mode != in_mode
      || n != in_n)
    return NULL_TREE;

  switch (fn)
    {
    CASE_CFN_ATAN2:
    CASE_CFN_HYPOT:
    CASE_CFN_POW:
      n_args = 2;
      gcc_fallthrough ();

    CASE_CFN_ACOS:
    CASE_CFN_ACOSH:
    CASE_CFN_ASIN:
    CASE_CFN_ASINH:
    CASE_CFN_ATAN:
    CASE_CFN_ATANH:
    CASE_CFN_CBRT:
    CASE_CFN_COS:
    CASE_CFN_COSH:
    CASE_CFN_ERF:
    CASE_CFN_ERFC:
    CASE_CFN_EXP2:
    CASE_CFN_EXP:
    CASE_CFN_EXPM1:
    CASE_CFN_LGAMMA:
    CASE_CFN_LOG10:
    CASE_CFN_LOG1P:
    CASE_CFN_LOG2:
    CASE_CFN_LOG:
    CASE_CFN_SIN:
    CASE_CFN_SINH:
    CASE_CFN_SQRT:
    CASE_CFN_TAN:
    CASE_CFN_TANH:
      if (el_mode == DFmode && n == 2)
	{
	  bdecl = mathfn_built_in (double_type_node, fn);
	  suffix = "d2";				/* pow -> powd2 */
	}
      else if (el_mode == SFmode && n == 4)
	{
	  bdecl = mathfn_built_in (float_type_node, fn);
	  suffix = "4";					/* powf -> powf4 */
	}
      else
	return NULL_TREE;
      if (!bdecl)
	return NULL_TREE;
      break;

    default:
      return NULL_TREE;
    }

  gcc_assert (suffix != NULL);
  bname = IDENTIFIER_POINTER (DECL_NAME (bdecl));
  if (!bname)
    return NULL_TREE;

  strcpy (name, bname + sizeof ("__builtin_") - 1);
  strcat (name, suffix);

  if (n_args == 1)
    fntype = build_function_type_list (type_out, type_in, NULL);
  else if (n_args == 2)
    fntype = build_function_type_list (type_out, type_in, type_in, NULL);
  else
    gcc_unreachable ();

  /* Build a function declaration for the vectorized function.  */
  new_fndecl = build_decl (BUILTINS_LOCATION,
			   FUNCTION_DECL, get_identifier (name), fntype);
  TREE_PUBLIC (new_fndecl) = 1;
  DECL_EXTERNAL (new_fndecl) = 1;
  DECL_IS_NOVOPS (new_fndecl) = 1;
  TREE_READONLY (new_fndecl) = 1;

  return new_fndecl;
}

/* Returns a function decl for a vectorized version of the builtin function
   with builtin function code FN and the result vector type TYPE, or NULL_TREE
   if it is not available.  */

static tree
rs6000_builtin_vectorized_function (unsigned int fn, tree type_out,
				    tree type_in)
{
  machine_mode in_mode, out_mode;
  int in_n, out_n;

  if (TARGET_DEBUG_BUILTIN)
    fprintf (stderr, "rs6000_builtin_vectorized_function (%s, %s, %s)\n",
	     combined_fn_name (combined_fn (fn)),
	     GET_MODE_NAME (TYPE_MODE (type_out)),
	     GET_MODE_NAME (TYPE_MODE (type_in)));

  if (TREE_CODE (type_out) != VECTOR_TYPE
      || TREE_CODE (type_in) != VECTOR_TYPE)
    return NULL_TREE;

  out_mode = TYPE_MODE (TREE_TYPE (type_out));
  out_n = TYPE_VECTOR_SUBPARTS (type_out);
  in_mode = TYPE_MODE (TREE_TYPE (type_in));
  in_n = TYPE_VECTOR_SUBPARTS (type_in);

  switch (fn)
    {
    CASE_CFN_COPYSIGN:
      if (VECTOR_UNIT_VSX_P (V2DFmode)
	  && out_mode == DFmode && out_n == 2
	  && in_mode == DFmode && in_n == 2)
	return rs6000_builtin_decls[VSX_BUILTIN_CPSGNDP];
      if (VECTOR_UNIT_VSX_P (V4SFmode)
	  && out_mode == SFmode && out_n == 4
	  && in_mode == SFmode && in_n == 4)
	return rs6000_builtin_decls[VSX_BUILTIN_CPSGNSP];
      if (VECTOR_UNIT_ALTIVEC_P (V4SFmode)
	  && out_mode == SFmode && out_n == 4
	  && in_mode == SFmode && in_n == 4)
	return rs6000_builtin_decls[ALTIVEC_BUILTIN_COPYSIGN_V4SF];
      break;
    CASE_CFN_CEIL:
      if (VECTOR_UNIT_VSX_P (V2DFmode)
	  && out_mode == DFmode && out_n == 2
	  && in_mode == DFmode && in_n == 2)
	return rs6000_builtin_decls[VSX_BUILTIN_XVRDPIP];
      if (VECTOR_UNIT_VSX_P (V4SFmode)
	  && out_mode == SFmode && out_n == 4
	  && in_mode == SFmode && in_n == 4)
	return rs6000_builtin_decls[VSX_BUILTIN_XVRSPIP];
      if (VECTOR_UNIT_ALTIVEC_P (V4SFmode)
	  && out_mode == SFmode && out_n == 4
	  && in_mode == SFmode && in_n == 4)
	return rs6000_builtin_decls[ALTIVEC_BUILTIN_VRFIP];
      break;
    CASE_CFN_FLOOR:
      if (VECTOR_UNIT_VSX_P (V2DFmode)
	  && out_mode == DFmode && out_n == 2
	  && in_mode == DFmode && in_n == 2)
	return rs6000_builtin_decls[VSX_BUILTIN_XVRDPIM];
      if (VECTOR_UNIT_VSX_P (V4SFmode)
	  && out_mode == SFmode && out_n == 4
	  && in_mode == SFmode && in_n == 4)
	return rs6000_builtin_decls[VSX_BUILTIN_XVRSPIM];
      if (VECTOR_UNIT_ALTIVEC_P (V4SFmode)
	  && out_mode == SFmode && out_n == 4
	  && in_mode == SFmode && in_n == 4)
	return rs6000_builtin_decls[ALTIVEC_BUILTIN_VRFIM];
      break;
    CASE_CFN_FMA:
      if (VECTOR_UNIT_VSX_P (V2DFmode)
	  && out_mode == DFmode && out_n == 2
	  && in_mode == DFmode && in_n == 2)
	return rs6000_builtin_decls[VSX_BUILTIN_XVMADDDP];
      if (VECTOR_UNIT_VSX_P (V4SFmode)
	  && out_mode == SFmode && out_n == 4
	  && in_mode == SFmode && in_n == 4)
	return rs6000_builtin_decls[VSX_BUILTIN_XVMADDSP];
      if (VECTOR_UNIT_ALTIVEC_P (V4SFmode)
	  && out_mode == SFmode && out_n == 4
	  && in_mode == SFmode && in_n == 4)
	return rs6000_builtin_decls[ALTIVEC_BUILTIN_VMADDFP];
      break;
    CASE_CFN_TRUNC:
      if (VECTOR_UNIT_VSX_P (V2DFmode)
	  && out_mode == DFmode && out_n == 2
	  && in_mode == DFmode && in_n == 2)
	return rs6000_builtin_decls[VSX_BUILTIN_XVRDPIZ];
      if (VECTOR_UNIT_VSX_P (V4SFmode)
	  && out_mode == SFmode && out_n == 4
	  && in_mode == SFmode && in_n == 4)
	return rs6000_builtin_decls[VSX_BUILTIN_XVRSPIZ];
      if (VECTOR_UNIT_ALTIVEC_P (V4SFmode)
	  && out_mode == SFmode && out_n == 4
	  && in_mode == SFmode && in_n == 4)
	return rs6000_builtin_decls[ALTIVEC_BUILTIN_VRFIZ];
      break;
    CASE_CFN_NEARBYINT:
      if (VECTOR_UNIT_VSX_P (V2DFmode)
	  && flag_unsafe_math_optimizations
	  && out_mode == DFmode && out_n == 2
	  && in_mode == DFmode && in_n == 2)
	return rs6000_builtin_decls[VSX_BUILTIN_XVRDPI];
      if (VECTOR_UNIT_VSX_P (V4SFmode)
	  && flag_unsafe_math_optimizations
	  && out_mode == SFmode && out_n == 4
	  && in_mode == SFmode && in_n == 4)
	return rs6000_builtin_decls[VSX_BUILTIN_XVRSPI];
      break;
    CASE_CFN_RINT:
      if (VECTOR_UNIT_VSX_P (V2DFmode)
	  && !flag_trapping_math
	  && out_mode == DFmode && out_n == 2
	  && in_mode == DFmode && in_n == 2)
	return rs6000_builtin_decls[VSX_BUILTIN_XVRDPIC];
      if (VECTOR_UNIT_VSX_P (V4SFmode)
	  && !flag_trapping_math
	  && out_mode == SFmode && out_n == 4
	  && in_mode == SFmode && in_n == 4)
	return rs6000_builtin_decls[VSX_BUILTIN_XVRSPIC];
      break;
    default:
      break;
    }

  /* Generate calls to libmass if appropriate.  */
  if (rs6000_veclib_handler)
    return rs6000_veclib_handler (combined_fn (fn), type_out, type_in);

  return NULL_TREE;
}

/* Implement TARGET_VECTORIZE_BUILTIN_MD_VECTORIZED_FUNCTION.  */

static tree
rs6000_builtin_md_vectorized_function (tree fndecl, tree type_out,
				       tree type_in)
{
  machine_mode in_mode, out_mode;
  int in_n, out_n;

  if (TARGET_DEBUG_BUILTIN)
    fprintf (stderr, "rs6000_builtin_md_vectorized_function (%s, %s, %s)\n",
	     IDENTIFIER_POINTER (DECL_NAME (fndecl)),
	     GET_MODE_NAME (TYPE_MODE (type_out)),
	     GET_MODE_NAME (TYPE_MODE (type_in)));

  if (TREE_CODE (type_out) != VECTOR_TYPE
      || TREE_CODE (type_in) != VECTOR_TYPE)
    return NULL_TREE;

  out_mode = TYPE_MODE (TREE_TYPE (type_out));
  out_n = TYPE_VECTOR_SUBPARTS (type_out);
  in_mode = TYPE_MODE (TREE_TYPE (type_in));
  in_n = TYPE_VECTOR_SUBPARTS (type_in);

  enum rs6000_builtins fn
    = (enum rs6000_builtins) DECL_FUNCTION_CODE (fndecl);
  switch (fn)
    {
    case RS6000_BUILTIN_RSQRTF:
      if (VECTOR_UNIT_ALTIVEC_OR_VSX_P (V4SFmode)
	  && out_mode == SFmode && out_n == 4
	  && in_mode == SFmode && in_n == 4)
	return rs6000_builtin_decls[ALTIVEC_BUILTIN_VRSQRTFP];
      break;
    case RS6000_BUILTIN_RSQRT:
      if (VECTOR_UNIT_VSX_P (V2DFmode)
	  && out_mode == DFmode && out_n == 2
	  && in_mode == DFmode && in_n == 2)
	return rs6000_builtin_decls[VSX_BUILTIN_RSQRT_2DF];
      break;
    case RS6000_BUILTIN_RECIPF:
      if (VECTOR_UNIT_ALTIVEC_OR_VSX_P (V4SFmode)
	  && out_mode == SFmode && out_n == 4
	  && in_mode == SFmode && in_n == 4)
	return rs6000_builtin_decls[ALTIVEC_BUILTIN_VRECIPFP];
      break;
    case RS6000_BUILTIN_RECIP:
      if (VECTOR_UNIT_VSX_P (V2DFmode)
	  && out_mode == DFmode && out_n == 2
	  && in_mode == DFmode && in_n == 2)
	return rs6000_builtin_decls[VSX_BUILTIN_RECIP_V2DF];
      break;
    default:
      break;
    }
  return NULL_TREE;
}

/* Default CPU string for rs6000*_file_start functions.  */
static const char *rs6000_default_cpu;

#ifdef USING_ELFOS_H
static const char *rs6000_machine;

static const char *
rs6000_machine_from_flags (void)
{
  if ((rs6000_isa_flags & (ISA_FUTURE_MASKS_SERVER & ~ISA_3_0_MASKS_SERVER))
      != 0)
    return "future";
  if ((rs6000_isa_flags & (ISA_3_0_MASKS_SERVER & ~ISA_2_7_MASKS_SERVER)) != 0)
    return "power9";
  if ((rs6000_isa_flags & (ISA_2_7_MASKS_SERVER & ~ISA_2_6_MASKS_SERVER)) != 0)
    return "power8";
  if ((rs6000_isa_flags & (ISA_2_6_MASKS_SERVER & ~ISA_2_5_MASKS_SERVER)) != 0)
    return "power7";
  if ((rs6000_isa_flags & (ISA_2_5_MASKS_SERVER & ~ISA_2_4_MASKS)) != 0)
    return "power6";
  if ((rs6000_isa_flags & (ISA_2_4_MASKS & ~ISA_2_1_MASKS)) != 0)
    return "power5";
  if ((rs6000_isa_flags & ISA_2_1_MASKS) != 0)
    return "power4";
  if ((rs6000_isa_flags & OPTION_MASK_POWERPC64) != 0)
    return "ppc64";
  return "ppc";
}

static void
emit_asm_machine (void)
{
  fprintf (asm_out_file, "\t.machine %s\n", rs6000_machine);
}
#endif

/* Do anything needed at the start of the asm file.  */

static void
rs6000_file_start (void)
{
  char buffer[80];
  const char *start = buffer;
  FILE *file = asm_out_file;

  rs6000_default_cpu = TARGET_CPU_DEFAULT;

  default_file_start ();

  if (flag_verbose_asm)
    {
      sprintf (buffer, "\n%s rs6000/powerpc options:", ASM_COMMENT_START);

      if (rs6000_default_cpu != 0 && rs6000_default_cpu[0] != '\0')
	{
	  fprintf (file, "%s --with-cpu=%s", start, rs6000_default_cpu);
	  start = "";
	}

      if (global_options_set.x_rs6000_cpu_index)
	{
	  fprintf (file, "%s -mcpu=%s", start,
		   processor_target_table[rs6000_cpu_index].name);
	  start = "";
	}

      if (global_options_set.x_rs6000_tune_index)
	{
	  fprintf (file, "%s -mtune=%s", start,
		   processor_target_table[rs6000_tune_index].name);
	  start = "";
	}

      if (PPC405_ERRATUM77)
	{
	  fprintf (file, "%s PPC405CR_ERRATUM77", start);
	  start = "";
	}

#ifdef USING_ELFOS_H
      switch (rs6000_sdata)
	{
	case SDATA_NONE: fprintf (file, "%s -msdata=none", start); start = ""; break;
	case SDATA_DATA: fprintf (file, "%s -msdata=data", start); start = ""; break;
	case SDATA_SYSV: fprintf (file, "%s -msdata=sysv", start); start = ""; break;
	case SDATA_EABI: fprintf (file, "%s -msdata=eabi", start); start = ""; break;
	}

      if (rs6000_sdata && g_switch_value)
	{
	  fprintf (file, "%s -G %d", start,
		   g_switch_value);
	  start = "";
	}
#endif

      if (*start == '\0')
	putc ('\n', file);
    }

#ifdef USING_ELFOS_H
  rs6000_machine = rs6000_machine_from_flags ();
  if (!(rs6000_default_cpu && rs6000_default_cpu[0])
      && !global_options_set.x_rs6000_cpu_index)
    emit_asm_machine ();
#endif

  if (DEFAULT_ABI == ABI_ELFv2)
    fprintf (file, "\t.abiversion 2\n");
}


/* Return nonzero if this function is known to have a null epilogue.  */

int
direct_return (void)
{
  if (reload_completed)
    {
      rs6000_stack_t *info = rs6000_stack_info ();

      if (info->first_gp_reg_save == 32
	  && info->first_fp_reg_save == 64
	  && info->first_altivec_reg_save == LAST_ALTIVEC_REGNO + 1
	  && ! info->lr_save_p
	  && ! info->cr_save_p
	  && info->vrsave_size == 0
	  && ! info->push_p)
	return 1;
    }

  return 0;
}

/* Helper for num_insns_constant.  Calculate number of instructions to
   load VALUE to a single gpr using combinations of addi, addis, ori,
   oris and sldi instructions.  */

static int
num_insns_constant_gpr (HOST_WIDE_INT value)
{
  /* signed constant loadable with addi */
  if (((unsigned HOST_WIDE_INT) value + 0x8000) < 0x10000)
    return 1;

  /* constant loadable with addis */
  else if ((value & 0xffff) == 0
	   && (value >> 31 == -1 || value >> 31 == 0))
    return 1;

  else if (TARGET_POWERPC64)
    {
      HOST_WIDE_INT low  = ((value & 0xffffffff) ^ 0x80000000) - 0x80000000;
      HOST_WIDE_INT high = value >> 31;

      if (high == 0 || high == -1)
	return 2;

      high >>= 1;

      if (low == 0)
	return num_insns_constant_gpr (high) + 1;
      else if (high == 0)
	return num_insns_constant_gpr (low) + 1;
      else
	return (num_insns_constant_gpr (high)
		+ num_insns_constant_gpr (low) + 1);
    }

  else
    return 2;
}

/* Helper for num_insns_constant.  Allow constants formed by the
   num_insns_constant_gpr sequences, plus li -1, rldicl/rldicr/rlwinm,
   and handle modes that require multiple gprs.  */

static int
num_insns_constant_multi (HOST_WIDE_INT value, machine_mode mode)
{
  int nregs = (GET_MODE_SIZE (mode) + UNITS_PER_WORD - 1) / UNITS_PER_WORD;
  int total = 0;
  while (nregs-- > 0)
    {
      HOST_WIDE_INT low = sext_hwi (value, BITS_PER_WORD);
      int insns = num_insns_constant_gpr (low);
      if (insns > 2
	  /* We won't get more than 2 from num_insns_constant_gpr
	     except when TARGET_POWERPC64 and mode is DImode or
	     wider, so the register mode must be DImode.  */
	  && rs6000_is_valid_and_mask (GEN_INT (low), DImode))
	insns = 2;
      total += insns;
      value >>= BITS_PER_WORD;
    }
  return total;
}

/* Return the number of instructions it takes to form a constant in as
   many gprs are needed for MODE.  */

int
num_insns_constant (rtx op, machine_mode mode)
{
  HOST_WIDE_INT val;

  switch (GET_CODE (op))
    {
    case CONST_INT:
      val = INTVAL (op);
      break;

    case CONST_WIDE_INT:
      {
	int insns = 0;
	for (int i = 0; i < CONST_WIDE_INT_NUNITS (op); i++)
	  insns += num_insns_constant_multi (CONST_WIDE_INT_ELT (op, i),
					     DImode);
	return insns;
      }

    case CONST_DOUBLE:
      {
	const struct real_value *rv = CONST_DOUBLE_REAL_VALUE (op);

	if (mode == SFmode || mode == SDmode)
	  {
	    long l;

	    if (mode == SDmode)
	      REAL_VALUE_TO_TARGET_DECIMAL32 (*rv, l);
	    else
	      REAL_VALUE_TO_TARGET_SINGLE (*rv, l);
	    /* See the first define_split in rs6000.md handling a
	       const_double_operand.  */
	    val = l;
	    mode = SImode;
	  }
	else if (mode == DFmode || mode == DDmode)
	  {
	    long l[2];

	    if (mode == DDmode)
	      REAL_VALUE_TO_TARGET_DECIMAL64 (*rv, l);
	    else
	      REAL_VALUE_TO_TARGET_DOUBLE (*rv, l);

	    /* See the second (32-bit) and third (64-bit) define_split
	       in rs6000.md handling a const_double_operand.  */
	    val = (unsigned HOST_WIDE_INT) l[WORDS_BIG_ENDIAN ? 0 : 1] << 32;
	    val |= l[WORDS_BIG_ENDIAN ? 1 : 0] & 0xffffffffUL;
	    mode = DImode;
	  }
	else if (mode == TFmode || mode == TDmode
		 || mode == KFmode || mode == IFmode)
	  {
	    long l[4];
	    int insns;

	    if (mode == TDmode)
	      REAL_VALUE_TO_TARGET_DECIMAL128 (*rv, l);
	    else
	      REAL_VALUE_TO_TARGET_LONG_DOUBLE (*rv, l);

	    val = (unsigned HOST_WIDE_INT) l[WORDS_BIG_ENDIAN ? 0 : 3] << 32;
	    val |= l[WORDS_BIG_ENDIAN ? 1 : 2] & 0xffffffffUL;
	    insns = num_insns_constant_multi (val, DImode);
	    val = (unsigned HOST_WIDE_INT) l[WORDS_BIG_ENDIAN ? 2 : 1] << 32;
	    val |= l[WORDS_BIG_ENDIAN ? 3 : 0] & 0xffffffffUL;
	    insns += num_insns_constant_multi (val, DImode);
	    return insns;
	  }
	else
	  gcc_unreachable ();
      }
      break;

    default:
      gcc_unreachable ();
    }

  return num_insns_constant_multi (val, mode);
}

/* Interpret element ELT of the CONST_VECTOR OP as an integer value.
   If the mode of OP is MODE_VECTOR_INT, this simply returns the
   corresponding element of the vector, but for V4SFmode, the
   corresponding "float" is interpreted as an SImode integer.  */

HOST_WIDE_INT
const_vector_elt_as_int (rtx op, unsigned int elt)
{
  rtx tmp;

  /* We can't handle V2DImode and V2DFmode vector constants here yet.  */
  gcc_assert (GET_MODE (op) != V2DImode
	      && GET_MODE (op) != V2DFmode);

  tmp = CONST_VECTOR_ELT (op, elt);
  if (GET_MODE (op) == V4SFmode)
    tmp = gen_lowpart (SImode, tmp);
  return INTVAL (tmp);
}

/* Return true if OP can be synthesized with a particular vspltisb, vspltish
   or vspltisw instruction.  OP is a CONST_VECTOR.  Which instruction is used
   depends on STEP and COPIES, one of which will be 1.  If COPIES > 1,
   all items are set to the same value and contain COPIES replicas of the
   vsplt's operand; if STEP > 1, one in STEP elements is set to the vsplt's
   operand and the others are set to the value of the operand's msb.  */

static bool
vspltis_constant (rtx op, unsigned step, unsigned copies)
{
  machine_mode mode = GET_MODE (op);
  machine_mode inner = GET_MODE_INNER (mode);

  unsigned i;
  unsigned nunits;
  unsigned bitsize;
  unsigned mask;

  HOST_WIDE_INT val;
  HOST_WIDE_INT splat_val;
  HOST_WIDE_INT msb_val;

  if (mode == V2DImode || mode == V2DFmode || mode == V1TImode)
    return false;

  nunits = GET_MODE_NUNITS (mode);
  bitsize = GET_MODE_BITSIZE (inner);
  mask = GET_MODE_MASK (inner);

  val = const_vector_elt_as_int (op, BYTES_BIG_ENDIAN ? nunits - 1 : 0);
  splat_val = val;
  msb_val = val >= 0 ? 0 : -1;

  /* Construct the value to be splatted, if possible.  If not, return 0.  */
  for (i = 2; i <= copies; i *= 2)
    {
      HOST_WIDE_INT small_val;
      bitsize /= 2;
      small_val = splat_val >> bitsize;
      mask >>= bitsize;
      if (splat_val != ((HOST_WIDE_INT)
          ((unsigned HOST_WIDE_INT) small_val << bitsize)
          | (small_val & mask)))
	return false;
      splat_val = small_val;
    }

  /* Check if SPLAT_VAL can really be the operand of a vspltis[bhw].  */
  if (EASY_VECTOR_15 (splat_val))
    ;

  /* Also check if we can splat, and then add the result to itself.  Do so if
     the value is positive, of if the splat instruction is using OP's mode;
     for splat_val < 0, the splat and the add should use the same mode.  */
  else if (EASY_VECTOR_15_ADD_SELF (splat_val)
           && (splat_val >= 0 || (step == 1 && copies == 1)))
    ;

  /* Also check if are loading up the most significant bit which can be done by
     loading up -1 and shifting the value left by -1.  */
  else if (EASY_VECTOR_MSB (splat_val, inner))
    ;

  else
    return false;

  /* Check if VAL is present in every STEP-th element, and the
     other elements are filled with its most significant bit.  */
  for (i = 1; i < nunits; ++i)
    {
      HOST_WIDE_INT desired_val;
      unsigned elt = BYTES_BIG_ENDIAN ? nunits - 1 - i : i;
      if ((i & (step - 1)) == 0)
	desired_val = val;
      else
	desired_val = msb_val;

      if (desired_val != const_vector_elt_as_int (op, elt))
	return false;
    }

  return true;
}

/* Like vsplitis_constant, but allow the value to be shifted left with a VSLDOI
   instruction, filling in the bottom elements with 0 or -1.

   Return 0 if the constant cannot be generated with VSLDOI.  Return positive
   for the number of zeroes to shift in, or negative for the number of 0xff
   bytes to shift in.

   OP is a CONST_VECTOR.  */

int
vspltis_shifted (rtx op)
{
  machine_mode mode = GET_MODE (op);
  machine_mode inner = GET_MODE_INNER (mode);

  unsigned i, j;
  unsigned nunits;
  unsigned mask;

  HOST_WIDE_INT val;

  if (mode != V16QImode && mode != V8HImode && mode != V4SImode)
    return false;

  /* We need to create pseudo registers to do the shift, so don't recognize
     shift vector constants after reload.  */
  if (!can_create_pseudo_p ())
    return false;

  nunits = GET_MODE_NUNITS (mode);
  mask = GET_MODE_MASK (inner);

  val = const_vector_elt_as_int (op, BYTES_BIG_ENDIAN ? 0 : nunits - 1);

  /* Check if the value can really be the operand of a vspltis[bhw].  */
  if (EASY_VECTOR_15 (val))
    ;

  /* Also check if we are loading up the most significant bit which can be done
     by loading up -1 and shifting the value left by -1.  */
  else if (EASY_VECTOR_MSB (val, inner))
    ;

  else
    return 0;

  /* Check if VAL is present in every STEP-th element until we find elements
     that are 0 or all 1 bits.  */
  for (i = 1; i < nunits; ++i)
    {
      unsigned elt = BYTES_BIG_ENDIAN ? i : nunits - 1 - i;
      HOST_WIDE_INT elt_val = const_vector_elt_as_int (op, elt);

      /* If the value isn't the splat value, check for the remaining elements
	 being 0/-1.  */
      if (val != elt_val)
	{
	  if (elt_val == 0)
	    {
	      for (j = i+1; j < nunits; ++j)
		{
		  unsigned elt2 = BYTES_BIG_ENDIAN ? j : nunits - 1 - j;
		  if (const_vector_elt_as_int (op, elt2) != 0)
		    return 0;
		}

	      return (nunits - i) * GET_MODE_SIZE (inner);
	    }

	  else if ((elt_val & mask) == mask)
	    {
	      for (j = i+1; j < nunits; ++j)
		{
		  unsigned elt2 = BYTES_BIG_ENDIAN ? j : nunits - 1 - j;
		  if ((const_vector_elt_as_int (op, elt2) & mask) != mask)
		    return 0;
		}

	      return -((nunits - i) * GET_MODE_SIZE (inner));
	    }

	  else
	    return 0;
	}
    }

  /* If all elements are equal, we don't need to do VLSDOI.  */
  return 0;
}


/* Return true if OP is of the given MODE and can be synthesized
   with a vspltisb, vspltish or vspltisw.  */

bool
easy_altivec_constant (rtx op, machine_mode mode)
{
  unsigned step, copies;

  if (mode == VOIDmode)
    mode = GET_MODE (op);
  else if (mode != GET_MODE (op))
    return false;

  /* V2DI/V2DF was added with VSX.  Only allow 0 and all 1's as easy
     constants.  */
  if (mode == V2DFmode)
    return zero_constant (op, mode);

  else if (mode == V2DImode)
    {
      if (!CONST_INT_P (CONST_VECTOR_ELT (op, 0))
	  || !CONST_INT_P (CONST_VECTOR_ELT (op, 1)))
	return false;

      if (zero_constant (op, mode))
	return true;

      if (INTVAL (CONST_VECTOR_ELT (op, 0)) == -1
	  && INTVAL (CONST_VECTOR_ELT (op, 1)) == -1)
	return true;

      return false;
    }

  /* V1TImode is a special container for TImode.  Ignore for now.  */
  else if (mode == V1TImode)
    return false;

  /* Start with a vspltisw.  */
  step = GET_MODE_NUNITS (mode) / 4;
  copies = 1;

  if (vspltis_constant (op, step, copies))
    return true;

  /* Then try with a vspltish.  */
  if (step == 1)
    copies <<= 1;
  else
    step >>= 1;

  if (vspltis_constant (op, step, copies))
    return true;

  /* And finally a vspltisb.  */
  if (step == 1)
    copies <<= 1;
  else
    step >>= 1;

  if (vspltis_constant (op, step, copies))
    return true;

  if (vspltis_shifted (op) != 0)
    return true;

  return false;
}

/* Generate a VEC_DUPLICATE representing a vspltis[bhw] instruction whose
   result is OP.  Abort if it is not possible.  */

rtx
gen_easy_altivec_constant (rtx op)
{
  machine_mode mode = GET_MODE (op);
  int nunits = GET_MODE_NUNITS (mode);
  rtx val = CONST_VECTOR_ELT (op, BYTES_BIG_ENDIAN ? nunits - 1 : 0);
  unsigned step = nunits / 4;
  unsigned copies = 1;

  /* Start with a vspltisw.  */
  if (vspltis_constant (op, step, copies))
    return gen_rtx_VEC_DUPLICATE (V4SImode, gen_lowpart (SImode, val));

  /* Then try with a vspltish.  */
  if (step == 1)
    copies <<= 1;
  else
    step >>= 1;

  if (vspltis_constant (op, step, copies))
    return gen_rtx_VEC_DUPLICATE (V8HImode, gen_lowpart (HImode, val));

  /* And finally a vspltisb.  */
  if (step == 1)
    copies <<= 1;
  else
    step >>= 1;

  if (vspltis_constant (op, step, copies))
    return gen_rtx_VEC_DUPLICATE (V16QImode, gen_lowpart (QImode, val));

  gcc_unreachable ();
}

/* Return true if OP is of the given MODE and can be synthesized with ISA 3.0
   instructions (xxspltib, vupkhsb/vextsb2w/vextb2d).

   Return the number of instructions needed (1 or 2) into the address pointed
   via NUM_INSNS_PTR.

   Return the constant that is being split via CONSTANT_PTR.  */

bool
xxspltib_constant_p (rtx op,
		     machine_mode mode,
		     int *num_insns_ptr,
		     int *constant_ptr)
{
  size_t nunits = GET_MODE_NUNITS (mode);
  size_t i;
  HOST_WIDE_INT value;
  rtx element;

  /* Set the returned values to out of bound values.  */
  *num_insns_ptr = -1;
  *constant_ptr = 256;

  if (!TARGET_P9_VECTOR)
    return false;

  if (mode == VOIDmode)
    mode = GET_MODE (op);

  else if (mode != GET_MODE (op) && GET_MODE (op) != VOIDmode)
    return false;

  /* Handle (vec_duplicate <constant>).  */
  if (GET_CODE (op) == VEC_DUPLICATE)
    {
      if (mode != V16QImode && mode != V8HImode && mode != V4SImode
	  && mode != V2DImode)
	return false;

      element = XEXP (op, 0);
      if (!CONST_INT_P (element))
	return false;

      value = INTVAL (element);
      if (!IN_RANGE (value, -128, 127))
	return false;
    }

  /* Handle (const_vector [...]).  */
  else if (GET_CODE (op) == CONST_VECTOR)
    {
      if (mode != V16QImode && mode != V8HImode && mode != V4SImode
	  && mode != V2DImode)
	return false;

      element = CONST_VECTOR_ELT (op, 0);
      if (!CONST_INT_P (element))
	return false;

      value = INTVAL (element);
      if (!IN_RANGE (value, -128, 127))
	return false;

      for (i = 1; i < nunits; i++)
	{
	  element = CONST_VECTOR_ELT (op, i);
	  if (!CONST_INT_P (element))
	    return false;

	  if (value != INTVAL (element))
	    return false;
	}
    }

  /* Handle integer constants being loaded into the upper part of the VSX
     register as a scalar.  If the value isn't 0/-1, only allow it if the mode
     can go in Altivec registers.  Prefer VSPLTISW/VUPKHSW over XXSPLITIB.  */
  else if (CONST_INT_P (op))
    {
      if (!SCALAR_INT_MODE_P (mode))
	return false;

      value = INTVAL (op);
      if (!IN_RANGE (value, -128, 127))
	return false;

      if (!IN_RANGE (value, -1, 0))
	{
	  if (!(reg_addr[mode].addr_mask[RELOAD_REG_VMX] & RELOAD_REG_VALID))
	    return false;

	  if (EASY_VECTOR_15 (value))
	    return false;
	}
    }

  else
    return false;

  /* See if we could generate vspltisw/vspltish directly instead of xxspltib +
     sign extend.  Special case 0/-1 to allow getting any VSX register instead
     of an Altivec register.  */
  if ((mode == V4SImode || mode == V8HImode) && !IN_RANGE (value, -1, 0)
      && EASY_VECTOR_15 (value))
    return false;

  /* Return # of instructions and the constant byte for XXSPLTIB.  */
  if (mode == V16QImode)
    *num_insns_ptr = 1;

  else if (IN_RANGE (value, -1, 0))
    *num_insns_ptr = 1;

  else
    *num_insns_ptr = 2;

  *constant_ptr = (int) value;
  return true;
}

const char *
output_vec_const_move (rtx *operands)
{
  int shift;
  machine_mode mode;
  rtx dest, vec;

  dest = operands[0];
  vec = operands[1];
  mode = GET_MODE (dest);

  if (TARGET_VSX)
    {
      bool dest_vmx_p = ALTIVEC_REGNO_P (REGNO (dest));
      int xxspltib_value = 256;
      int num_insns = -1;

      if (zero_constant (vec, mode))
	{
	  if (TARGET_P9_VECTOR)
	    return "xxspltib %x0,0";

	  else if (dest_vmx_p)
	    return "vspltisw %0,0";

	  else
	    return "xxlxor %x0,%x0,%x0";
	}

      if (all_ones_constant (vec, mode))
	{
	  if (TARGET_P9_VECTOR)
	    return "xxspltib %x0,255";

	  else if (dest_vmx_p)
	    return "vspltisw %0,-1";

	  else if (TARGET_P8_VECTOR)
	    return "xxlorc %x0,%x0,%x0";

	  else
	    gcc_unreachable ();
	}

      if (TARGET_P9_VECTOR
	  && xxspltib_constant_p (vec, mode, &num_insns, &xxspltib_value))
	{
	  if (num_insns == 1)
	    {
	      operands[2] = GEN_INT (xxspltib_value & 0xff);
	      return "xxspltib %x0,%2";
	    }

	  return "#";
	}
    }

  if (TARGET_ALTIVEC)
    {
      rtx splat_vec;

      gcc_assert (ALTIVEC_REGNO_P (REGNO (dest)));
      if (zero_constant (vec, mode))
	return "vspltisw %0,0";

      if (all_ones_constant (vec, mode))
	return "vspltisw %0,-1";

      /* Do we need to construct a value using VSLDOI?  */
      shift = vspltis_shifted (vec);
      if (shift != 0)
	return "#";

      splat_vec = gen_easy_altivec_constant (vec);
      gcc_assert (GET_CODE (splat_vec) == VEC_DUPLICATE);
      operands[1] = XEXP (splat_vec, 0);
      if (!EASY_VECTOR_15 (INTVAL (operands[1])))
	return "#";

      switch (GET_MODE (splat_vec))
	{
	case E_V4SImode:
	  return "vspltisw %0,%1";

	case E_V8HImode:
	  return "vspltish %0,%1";

	case E_V16QImode:
	  return "vspltisb %0,%1";

	default:
	  gcc_unreachable ();
	}
    }

  gcc_unreachable ();
}

/* Initialize vector TARGET to VALS.  */

void
rs6000_expand_vector_init (rtx target, rtx vals)
{
  machine_mode mode = GET_MODE (target);
  machine_mode inner_mode = GET_MODE_INNER (mode);
  int n_elts = GET_MODE_NUNITS (mode);
  int n_var = 0, one_var = -1;
  bool all_same = true, all_const_zero = true;
  rtx x, mem;
  int i;

  for (i = 0; i < n_elts; ++i)
    {
      x = XVECEXP (vals, 0, i);
      if (!(CONST_SCALAR_INT_P (x) || CONST_DOUBLE_P (x) || CONST_FIXED_P (x)))
	++n_var, one_var = i;
      else if (x != CONST0_RTX (inner_mode))
	all_const_zero = false;

      if (i > 0 && !rtx_equal_p (x, XVECEXP (vals, 0, 0)))
	all_same = false;
    }

  if (n_var == 0)
    {
      rtx const_vec = gen_rtx_CONST_VECTOR (mode, XVEC (vals, 0));
      bool int_vector_p = (GET_MODE_CLASS (mode) == MODE_VECTOR_INT);
      if ((int_vector_p || TARGET_VSX) && all_const_zero)
	{
	  /* Zero register.  */
	  emit_move_insn (target, CONST0_RTX (mode));
	  return;
	}
      else if (int_vector_p && easy_vector_constant (const_vec, mode))
	{
	  /* Splat immediate.  */
	  emit_insn (gen_rtx_SET (target, const_vec));
	  return;
	}
      else
	{
	  /* Load from constant pool.  */
	  emit_move_insn (target, const_vec);
	  return;
	}
    }

  /* Double word values on VSX can use xxpermdi or lxvdsx.  */
  if (VECTOR_MEM_VSX_P (mode) && (mode == V2DFmode || mode == V2DImode))
    {
      rtx op[2];
      size_t i;
      size_t num_elements = all_same ? 1 : 2;
      for (i = 0; i < num_elements; i++)
	{
	  op[i] = XVECEXP (vals, 0, i);
	  /* Just in case there is a SUBREG with a smaller mode, do a
	     conversion.  */
	  if (GET_MODE (op[i]) != inner_mode)
	    {
	      rtx tmp = gen_reg_rtx (inner_mode);
	      convert_move (tmp, op[i], 0);
	      op[i] = tmp;
	    }
	  /* Allow load with splat double word.  */
	  else if (MEM_P (op[i]))
	    {
	      if (!all_same)
		op[i] = force_reg (inner_mode, op[i]);
	    }
	  else if (!REG_P (op[i]))
	    op[i] = force_reg (inner_mode, op[i]);
	}

      if (all_same)
	{
	  if (mode == V2DFmode)
	    emit_insn (gen_vsx_splat_v2df (target, op[0]));
	  else
	    emit_insn (gen_vsx_splat_v2di (target, op[0]));
	}
      else
	{
	  if (mode == V2DFmode)
	    emit_insn (gen_vsx_concat_v2df (target, op[0], op[1]));
	  else
	    emit_insn (gen_vsx_concat_v2di (target, op[0], op[1]));
	}
      return;
    }

  /* Special case initializing vector int if we are on 64-bit systems with
     direct move or we have the ISA 3.0 instructions.  */
  if (mode == V4SImode  && VECTOR_MEM_VSX_P (V4SImode)
      && TARGET_DIRECT_MOVE_64BIT)
    {
      if (all_same)
	{
	  rtx element0 = XVECEXP (vals, 0, 0);
	  if (MEM_P (element0))
	    element0 = rs6000_force_indexed_or_indirect_mem (element0);
	  else
	    element0 = force_reg (SImode, element0);

	  if (TARGET_P9_VECTOR)
	    emit_insn (gen_vsx_splat_v4si (target, element0));
	  else
	    {
	      rtx tmp = gen_reg_rtx (DImode);
	      emit_insn (gen_zero_extendsidi2 (tmp, element0));
	      emit_insn (gen_vsx_splat_v4si_di (target, tmp));
	    }
	  return;
	}
      else
	{
	  rtx elements[4];
	  size_t i;

	  for (i = 0; i < 4; i++)
	    elements[i] = force_reg (SImode, XVECEXP (vals, 0, i));

	  emit_insn (gen_vsx_init_v4si (target, elements[0], elements[1],
					elements[2], elements[3]));
	  return;
	}
    }

  /* With single precision floating point on VSX, know that internally single
     precision is actually represented as a double, and either make 2 V2DF
     vectors, and convert these vectors to single precision, or do one
     conversion, and splat the result to the other elements.  */
  if (mode == V4SFmode && VECTOR_MEM_VSX_P (V4SFmode))
    {
      if (all_same)
	{
	  rtx element0 = XVECEXP (vals, 0, 0);

	  if (TARGET_P9_VECTOR)
	    {
	      if (MEM_P (element0))
		element0 = rs6000_force_indexed_or_indirect_mem (element0);

	      emit_insn (gen_vsx_splat_v4sf (target, element0));
	    }

	  else
	    {
	      rtx freg = gen_reg_rtx (V4SFmode);
	      rtx sreg = force_reg (SFmode, element0);
	      rtx cvt  = (TARGET_XSCVDPSPN
			  ? gen_vsx_xscvdpspn_scalar (freg, sreg)
			  : gen_vsx_xscvdpsp_scalar (freg, sreg));

	      emit_insn (cvt);
	      emit_insn (gen_vsx_xxspltw_v4sf_direct (target, freg,
						      const0_rtx));
	    }
	}
      else
	{
	  rtx dbl_even = gen_reg_rtx (V2DFmode);
	  rtx dbl_odd  = gen_reg_rtx (V2DFmode);
	  rtx flt_even = gen_reg_rtx (V4SFmode);
	  rtx flt_odd  = gen_reg_rtx (V4SFmode);
	  rtx op0 = force_reg (SFmode, XVECEXP (vals, 0, 0));
	  rtx op1 = force_reg (SFmode, XVECEXP (vals, 0, 1));
	  rtx op2 = force_reg (SFmode, XVECEXP (vals, 0, 2));
	  rtx op3 = force_reg (SFmode, XVECEXP (vals, 0, 3));

	  /* Use VMRGEW if we can instead of doing a permute.  */
	  if (TARGET_P8_VECTOR)
	    {
	      emit_insn (gen_vsx_concat_v2sf (dbl_even, op0, op2));
	      emit_insn (gen_vsx_concat_v2sf (dbl_odd, op1, op3));
	      emit_insn (gen_vsx_xvcvdpsp (flt_even, dbl_even));
	      emit_insn (gen_vsx_xvcvdpsp (flt_odd, dbl_odd));
	      if (BYTES_BIG_ENDIAN)
		emit_insn (gen_p8_vmrgew_v4sf_direct (target, flt_even, flt_odd));
	      else
		emit_insn (gen_p8_vmrgew_v4sf_direct (target, flt_odd, flt_even));
	    }
	  else
	    {
	      emit_insn (gen_vsx_concat_v2sf (dbl_even, op0, op1));
	      emit_insn (gen_vsx_concat_v2sf (dbl_odd, op2, op3));
	      emit_insn (gen_vsx_xvcvdpsp (flt_even, dbl_even));
	      emit_insn (gen_vsx_xvcvdpsp (flt_odd, dbl_odd));
	      rs6000_expand_extract_even (target, flt_even, flt_odd);
	    }
	}
      return;
    }

  /* Special case initializing vector short/char that are splats if we are on
     64-bit systems with direct move.  */
  if (all_same && TARGET_DIRECT_MOVE_64BIT
      && (mode == V16QImode || mode == V8HImode))
    {
      rtx op0 = XVECEXP (vals, 0, 0);
      rtx di_tmp = gen_reg_rtx (DImode);

      if (!REG_P (op0))
	op0 = force_reg (GET_MODE_INNER (mode), op0);

      if (mode == V16QImode)
	{
	  emit_insn (gen_zero_extendqidi2 (di_tmp, op0));
	  emit_insn (gen_vsx_vspltb_di (target, di_tmp));
	  return;
	}

      if (mode == V8HImode)
	{
	  emit_insn (gen_zero_extendhidi2 (di_tmp, op0));
	  emit_insn (gen_vsx_vsplth_di (target, di_tmp));
	  return;
	}
    }

  /* Store value to stack temp.  Load vector element.  Splat.  However, splat
     of 64-bit items is not supported on Altivec.  */
  if (all_same && GET_MODE_SIZE (inner_mode) <= 4)
    {
      mem = assign_stack_temp (mode, GET_MODE_SIZE (inner_mode));
      emit_move_insn (adjust_address_nv (mem, inner_mode, 0),
		      XVECEXP (vals, 0, 0));
      x = gen_rtx_UNSPEC (VOIDmode,
			  gen_rtvec (1, const0_rtx), UNSPEC_LVE);
      emit_insn (gen_rtx_PARALLEL (VOIDmode,
				   gen_rtvec (2,
					      gen_rtx_SET (target, mem),
					      x)));
      x = gen_rtx_VEC_SELECT (inner_mode, target,
			      gen_rtx_PARALLEL (VOIDmode,
						gen_rtvec (1, const0_rtx)));
      emit_insn (gen_rtx_SET (target, gen_rtx_VEC_DUPLICATE (mode, x)));
      return;
    }

  /* One field is non-constant.  Load constant then overwrite
     varying field.  */
  if (n_var == 1)
    {
      rtx copy = copy_rtx (vals);

      /* Load constant part of vector, substitute neighboring value for
	 varying element.  */
      XVECEXP (copy, 0, one_var) = XVECEXP (vals, 0, (one_var + 1) % n_elts);
      rs6000_expand_vector_init (target, copy);

      /* Insert variable.  */
      rs6000_expand_vector_set (target, XVECEXP (vals, 0, one_var), one_var);
      return;
    }

  /* Construct the vector in memory one field at a time
     and load the whole vector.  */
  mem = assign_stack_temp (mode, GET_MODE_SIZE (mode));
  for (i = 0; i < n_elts; i++)
    emit_move_insn (adjust_address_nv (mem, inner_mode,
				    i * GET_MODE_SIZE (inner_mode)),
		    XVECEXP (vals, 0, i));
  emit_move_insn (target, mem);
}

/* Set field ELT of TARGET to VAL.  */

void
rs6000_expand_vector_set (rtx target, rtx val, int elt)
{
  machine_mode mode = GET_MODE (target);
  machine_mode inner_mode = GET_MODE_INNER (mode);
  rtx reg = gen_reg_rtx (mode);
  rtx mask, mem, x;
  int width = GET_MODE_SIZE (inner_mode);
  int i;

  val = force_reg (GET_MODE (val), val);

  if (VECTOR_MEM_VSX_P (mode))
    {
      rtx insn = NULL_RTX;
      rtx elt_rtx = GEN_INT (elt);

      if (mode == V2DFmode)
	insn = gen_vsx_set_v2df (target, target, val, elt_rtx);

      else if (mode == V2DImode)
	insn = gen_vsx_set_v2di (target, target, val, elt_rtx);

      else if (TARGET_P9_VECTOR && TARGET_POWERPC64)
	{
	  if (mode == V4SImode)
	    insn = gen_vsx_set_v4si_p9 (target, target, val, elt_rtx);
	  else if (mode == V8HImode)
	    insn = gen_vsx_set_v8hi_p9 (target, target, val, elt_rtx);
	  else if (mode == V16QImode)
	    insn = gen_vsx_set_v16qi_p9 (target, target, val, elt_rtx);
	  else if (mode == V4SFmode)
	    insn = gen_vsx_set_v4sf_p9 (target, target, val, elt_rtx);
	}

      if (insn)
	{
	  emit_insn (insn);
	  return;
	}
    }

  /* Simplify setting single element vectors like V1TImode.  */
  if (GET_MODE_SIZE (mode) == GET_MODE_SIZE (inner_mode) && elt == 0)
    {
      emit_move_insn (target, gen_lowpart (mode, val));
      return;
    }

  /* Load single variable value.  */
  mem = assign_stack_temp (mode, GET_MODE_SIZE (inner_mode));
  emit_move_insn (adjust_address_nv (mem, inner_mode, 0), val);
  x = gen_rtx_UNSPEC (VOIDmode,
		      gen_rtvec (1, const0_rtx), UNSPEC_LVE);
  emit_insn (gen_rtx_PARALLEL (VOIDmode,
			       gen_rtvec (2,
					  gen_rtx_SET (reg, mem),
					  x)));

  /* Linear sequence.  */
  mask = gen_rtx_PARALLEL (V16QImode, rtvec_alloc (16));
  for (i = 0; i < 16; ++i)
    XVECEXP (mask, 0, i) = GEN_INT (i);

  /* Set permute mask to insert element into target.  */
  for (i = 0; i < width; ++i)
    XVECEXP (mask, 0, elt*width + i)
      = GEN_INT (i + 0x10);
  x = gen_rtx_CONST_VECTOR (V16QImode, XVEC (mask, 0));

  if (BYTES_BIG_ENDIAN)
    x = gen_rtx_UNSPEC (mode,
			gen_rtvec (3, target, reg,
				   force_reg (V16QImode, x)),
			UNSPEC_VPERM);
  else
    {
      if (TARGET_P9_VECTOR)
	x = gen_rtx_UNSPEC (mode,
			    gen_rtvec (3, reg, target,
				       force_reg (V16QImode, x)),
			    UNSPEC_VPERMR);
      else
	{
	  /* Invert selector.  We prefer to generate VNAND on P8 so
	     that future fusion opportunities can kick in, but must
	     generate VNOR elsewhere.  */
	  rtx notx = gen_rtx_NOT (V16QImode, force_reg (V16QImode, x));
	  rtx iorx = (TARGET_P8_VECTOR
		      ? gen_rtx_IOR (V16QImode, notx, notx)
		      : gen_rtx_AND (V16QImode, notx, notx));
	  rtx tmp = gen_reg_rtx (V16QImode);
	  emit_insn (gen_rtx_SET (tmp, iorx));

	  /* Permute with operands reversed and adjusted selector.  */
	  x = gen_rtx_UNSPEC (mode, gen_rtvec (3, reg, target, tmp),
			      UNSPEC_VPERM);
	}
    }

  emit_insn (gen_rtx_SET (target, x));
}

/* Extract field ELT from VEC into TARGET.  */

void
rs6000_expand_vector_extract (rtx target, rtx vec, rtx elt)
{
  machine_mode mode = GET_MODE (vec);
  machine_mode inner_mode = GET_MODE_INNER (mode);
  rtx mem;

  if (VECTOR_MEM_VSX_P (mode) && CONST_INT_P (elt))
    {
      switch (mode)
	{
	default:
	  break;
	case E_V1TImode:
	  emit_move_insn (target, gen_lowpart (TImode, vec));
	  break;
	case E_V2DFmode:
	  emit_insn (gen_vsx_extract_v2df (target, vec, elt));
	  return;
	case E_V2DImode:
	  emit_insn (gen_vsx_extract_v2di (target, vec, elt));
	  return;
	case E_V4SFmode:
	  emit_insn (gen_vsx_extract_v4sf (target, vec, elt));
	  return;
	case E_V16QImode:
	  if (TARGET_DIRECT_MOVE_64BIT)
	    {
	      emit_insn (gen_vsx_extract_v16qi (target, vec, elt));
	      return;
	    }
	  else
	    break;
	case E_V8HImode:
	  if (TARGET_DIRECT_MOVE_64BIT)
	    {
	      emit_insn (gen_vsx_extract_v8hi (target, vec, elt));
	      return;
	    }
	  else
	    break;
	case E_V4SImode:
	  if (TARGET_DIRECT_MOVE_64BIT)
	    {
	      emit_insn (gen_vsx_extract_v4si (target, vec, elt));
	      return;
	    }
	  break;
	}
    }
  else if (VECTOR_MEM_VSX_P (mode) && !CONST_INT_P (elt)
	   && TARGET_DIRECT_MOVE_64BIT)
    {
      if (GET_MODE (elt) != DImode)
	{
	  rtx tmp = gen_reg_rtx (DImode);
	  convert_move (tmp, elt, 0);
	  elt = tmp;
	}
      else if (!REG_P (elt))
	elt = force_reg (DImode, elt);

      switch (mode)
	{
	case E_V1TImode:
	  emit_move_insn (target, gen_lowpart (TImode, vec));
	  return;

	case E_V2DFmode:
	  emit_insn (gen_vsx_extract_v2df_var (target, vec, elt));
	  return;

	case E_V2DImode:
	  emit_insn (gen_vsx_extract_v2di_var (target, vec, elt));
	  return;

	case E_V4SFmode:
	  emit_insn (gen_vsx_extract_v4sf_var (target, vec, elt));
	  return;

	case E_V4SImode:
	  emit_insn (gen_vsx_extract_v4si_var (target, vec, elt));
	  return;

	case E_V8HImode:
	  emit_insn (gen_vsx_extract_v8hi_var (target, vec, elt));
	  return;

	case E_V16QImode:
	  emit_insn (gen_vsx_extract_v16qi_var (target, vec, elt));
	  return;

	default:
	  gcc_unreachable ();
	}
    }

  /* Allocate mode-sized buffer.  */
  mem = assign_stack_temp (mode, GET_MODE_SIZE (mode));

  emit_move_insn (mem, vec);
  if (CONST_INT_P (elt))
    {
      int modulo_elt = INTVAL (elt) % GET_MODE_NUNITS (mode);

      /* Add offset to field within buffer matching vector element.  */
      mem = adjust_address_nv (mem, inner_mode,
			       modulo_elt * GET_MODE_SIZE (inner_mode));
      emit_move_insn (target, adjust_address_nv (mem, inner_mode, 0));
    }
  else
    {
      unsigned int ele_size = GET_MODE_SIZE (inner_mode);
      rtx num_ele_m1 = GEN_INT (GET_MODE_NUNITS (mode) - 1);
      rtx new_addr = gen_reg_rtx (Pmode);

      elt = gen_rtx_AND (Pmode, elt, num_ele_m1);
      if (ele_size > 1)
	elt = gen_rtx_MULT (Pmode, elt, GEN_INT (ele_size));
      new_addr = gen_rtx_PLUS (Pmode, XEXP (mem, 0), elt);
      new_addr = change_address (mem, inner_mode, new_addr);
      emit_move_insn (target, new_addr);
    }
}

/* Adjust a memory address (MEM) of a vector type to point to a scalar field
   within the vector (ELEMENT) with a mode (SCALAR_MODE).  Use a base register
   temporary (BASE_TMP) to fixup the address.  Return the new memory address
   that is valid for reads or writes to a given register (SCALAR_REG).  */

rtx
rs6000_adjust_vec_address (rtx scalar_reg,
			   rtx mem,
			   rtx element,
			   rtx base_tmp,
			   machine_mode scalar_mode)
{
  unsigned scalar_size = GET_MODE_SIZE (scalar_mode);
  rtx addr = XEXP (mem, 0);
  rtx element_offset;
  rtx new_addr;
  bool valid_addr_p;

  /* Vector addresses should not have PRE_INC, PRE_DEC, or PRE_MODIFY.  */
  gcc_assert (GET_RTX_CLASS (GET_CODE (addr)) != RTX_AUTOINC);

  /* Calculate what we need to add to the address to get the element
     address.  */
  if (CONST_INT_P (element))
    element_offset = GEN_INT (INTVAL (element) * scalar_size);
  else
    {
      int byte_shift = exact_log2 (scalar_size);
      gcc_assert (byte_shift >= 0);

      if (byte_shift == 0)
	element_offset = element;

      else
	{
	  if (TARGET_POWERPC64)
	    emit_insn (gen_ashldi3 (base_tmp, element, GEN_INT (byte_shift)));
	  else
	    emit_insn (gen_ashlsi3 (base_tmp, element, GEN_INT (byte_shift)));

	  element_offset = base_tmp;
	}
    }

  /* Create the new address pointing to the element within the vector.  If we
     are adding 0, we don't have to change the address.  */
  if (element_offset == const0_rtx)
    new_addr = addr;

  /* A simple indirect address can be converted into a reg + offset
     address.  */
  else if (REG_P (addr) || SUBREG_P (addr))
    new_addr = gen_rtx_PLUS (Pmode, addr, element_offset);

  /* Optimize D-FORM addresses with constant offset with a constant element, to
     include the element offset in the address directly.  */
  else if (GET_CODE (addr) == PLUS)
    {
      rtx op0 = XEXP (addr, 0);
      rtx op1 = XEXP (addr, 1);
      rtx insn;

      gcc_assert (REG_P (op0) || SUBREG_P (op0));
      if (CONST_INT_P (op1) && CONST_INT_P (element_offset))
	{
	  HOST_WIDE_INT offset = INTVAL (op1) + INTVAL (element_offset);
	  rtx offset_rtx = GEN_INT (offset);

	  if (IN_RANGE (offset, -32768, 32767)
	      && (scalar_size < 8 || (offset & 0x3) == 0))
	    new_addr = gen_rtx_PLUS (Pmode, op0, offset_rtx);
	  else
	    {
	      emit_move_insn (base_tmp, offset_rtx);
	      new_addr = gen_rtx_PLUS (Pmode, op0, base_tmp);
	    }
	}
      else
	{
	  bool op1_reg_p = (REG_P (op1) || SUBREG_P (op1));
	  bool ele_reg_p = (REG_P (element_offset) || SUBREG_P (element_offset));

	  /* Note, ADDI requires the register being added to be a base
	     register.  If the register was R0, load it up into the temporary
	     and do the add.  */
	  if (op1_reg_p
	      && (ele_reg_p || reg_or_subregno (op1) != FIRST_GPR_REGNO))
	    {
	      insn = gen_add3_insn (base_tmp, op1, element_offset);
	      gcc_assert (insn != NULL_RTX);
	      emit_insn (insn);
	    }

	  else if (ele_reg_p
		   && reg_or_subregno (element_offset) != FIRST_GPR_REGNO)
	    {
	      insn = gen_add3_insn (base_tmp, element_offset, op1);
	      gcc_assert (insn != NULL_RTX);
	      emit_insn (insn);
	    }

	  else
	    {
	      emit_move_insn (base_tmp, op1);
	      emit_insn (gen_add2_insn (base_tmp, element_offset));
	    }

	  new_addr = gen_rtx_PLUS (Pmode, op0, base_tmp);
	}
    }

  else
    {
      emit_move_insn (base_tmp, addr);
      new_addr = gen_rtx_PLUS (Pmode, base_tmp, element_offset);
    }

  /* If we have a PLUS, we need to see whether the particular register class
     allows for D-FORM or X-FORM addressing.  */
  if (GET_CODE (new_addr) == PLUS)
    {
      rtx op1 = XEXP (new_addr, 1);
      addr_mask_type addr_mask;
      unsigned int scalar_regno = reg_or_subregno (scalar_reg);

      gcc_assert (HARD_REGISTER_NUM_P (scalar_regno));
      if (INT_REGNO_P (scalar_regno))
	addr_mask = reg_addr[scalar_mode].addr_mask[RELOAD_REG_GPR];

      else if (FP_REGNO_P (scalar_regno))
	addr_mask = reg_addr[scalar_mode].addr_mask[RELOAD_REG_FPR];

      else if (ALTIVEC_REGNO_P (scalar_regno))
	addr_mask = reg_addr[scalar_mode].addr_mask[RELOAD_REG_VMX];

      else
	gcc_unreachable ();

      if (REG_P (op1) || SUBREG_P (op1))
	valid_addr_p = (addr_mask & RELOAD_REG_INDEXED) != 0;
      else
	valid_addr_p = (addr_mask & RELOAD_REG_OFFSET) != 0;
    }

  else if (REG_P (new_addr) || SUBREG_P (new_addr))
    valid_addr_p = true;

  else
    valid_addr_p = false;

  if (!valid_addr_p)
    {
      emit_move_insn (base_tmp, new_addr);
      new_addr = base_tmp;
    }

  return change_address (mem, scalar_mode, new_addr);
}

/* Split a variable vec_extract operation into the component instructions.  */

void
rs6000_split_vec_extract_var (rtx dest, rtx src, rtx element, rtx tmp_gpr,
			      rtx tmp_altivec)
{
  machine_mode mode = GET_MODE (src);
  machine_mode scalar_mode = GET_MODE_INNER (GET_MODE (src));
  unsigned scalar_size = GET_MODE_SIZE (scalar_mode);
  int byte_shift = exact_log2 (scalar_size);

  gcc_assert (byte_shift >= 0);

  /* If we are given a memory address, optimize to load just the element.  We
     don't have to adjust the vector element number on little endian
     systems.  */
  if (MEM_P (src))
    {
      int num_elements = GET_MODE_NUNITS (mode);
      rtx num_ele_m1 = GEN_INT (num_elements - 1);

      emit_insn (gen_anddi3 (element, element, num_ele_m1));
      gcc_assert (REG_P (tmp_gpr));
      emit_move_insn (dest, rs6000_adjust_vec_address (dest, src, element,
						       tmp_gpr, scalar_mode));
      return;
    }

  else if (REG_P (src) || SUBREG_P (src))
    {
      int num_elements = GET_MODE_NUNITS (mode);
      int bits_in_element = mode_to_bits (GET_MODE_INNER (mode));
      int bit_shift = 7 - exact_log2 (num_elements);
      rtx element2;
      unsigned int dest_regno = reg_or_subregno (dest);
      unsigned int src_regno = reg_or_subregno (src);
      unsigned int element_regno = reg_or_subregno (element);

      gcc_assert (REG_P (tmp_gpr));

      /* See if we want to generate VEXTU{B,H,W}{L,R}X if the destination is in
	 a general purpose register.  */
      if (TARGET_P9_VECTOR
	  && (mode == V16QImode || mode == V8HImode || mode == V4SImode)
	  && INT_REGNO_P (dest_regno)
	  && ALTIVEC_REGNO_P (src_regno)
	  && INT_REGNO_P (element_regno))
	{
	  rtx dest_si = gen_rtx_REG (SImode, dest_regno);
	  rtx element_si = gen_rtx_REG (SImode, element_regno);

	  if (mode == V16QImode)
	    emit_insn (BYTES_BIG_ENDIAN
		       ? gen_vextublx (dest_si, element_si, src)
		       : gen_vextubrx (dest_si, element_si, src));

	  else if (mode == V8HImode)
	    {
	      rtx tmp_gpr_si = gen_rtx_REG (SImode, REGNO (tmp_gpr));
	      emit_insn (gen_ashlsi3 (tmp_gpr_si, element_si, const1_rtx));
	      emit_insn (BYTES_BIG_ENDIAN
			 ? gen_vextuhlx (dest_si, tmp_gpr_si, src)
			 : gen_vextuhrx (dest_si, tmp_gpr_si, src));
	    }


	  else
	    {
	      rtx tmp_gpr_si = gen_rtx_REG (SImode, REGNO (tmp_gpr));
	      emit_insn (gen_ashlsi3 (tmp_gpr_si, element_si, const2_rtx));
	      emit_insn (BYTES_BIG_ENDIAN
			 ? gen_vextuwlx (dest_si, tmp_gpr_si, src)
			 : gen_vextuwrx (dest_si, tmp_gpr_si, src));
	    }

	  return;
	}


      gcc_assert (REG_P (tmp_altivec));

      /* For little endian, adjust element ordering.  For V2DI/V2DF, we can use
	 an XOR, otherwise we need to subtract.  The shift amount is so VSLO
	 will shift the element into the upper position (adding 3 to convert a
	 byte shift into a bit shift).  */
      if (scalar_size == 8)
	{
	  if (!BYTES_BIG_ENDIAN)
	    {
	      emit_insn (gen_xordi3 (tmp_gpr, element, const1_rtx));
	      element2 = tmp_gpr;
	    }
	  else
	    element2 = element;

	  /* Generate RLDIC directly to shift left 6 bits and retrieve 1
	     bit.  */
	  emit_insn (gen_rtx_SET (tmp_gpr,
				  gen_rtx_AND (DImode,
					       gen_rtx_ASHIFT (DImode,
							       element2,
							       GEN_INT (6)),
					       GEN_INT (64))));
	}
      else
	{
	  if (!BYTES_BIG_ENDIAN)
	    {
	      rtx num_ele_m1 = GEN_INT (num_elements - 1);

	      emit_insn (gen_anddi3 (tmp_gpr, element, num_ele_m1));
	      emit_insn (gen_subdi3 (tmp_gpr, num_ele_m1, tmp_gpr));
	      element2 = tmp_gpr;
	    }
	  else
	    element2 = element;

	  emit_insn (gen_ashldi3 (tmp_gpr, element2, GEN_INT (bit_shift)));
	}

      /* Get the value into the lower byte of the Altivec register where VSLO
	 expects it.  */
      if (TARGET_P9_VECTOR)
	emit_insn (gen_vsx_splat_v2di (tmp_altivec, tmp_gpr));
      else if (can_create_pseudo_p ())
	emit_insn (gen_vsx_concat_v2di (tmp_altivec, tmp_gpr, tmp_gpr));
      else
	{
	  rtx tmp_di = gen_rtx_REG (DImode, REGNO (tmp_altivec));
	  emit_move_insn (tmp_di, tmp_gpr);
	  emit_insn (gen_vsx_concat_v2di (tmp_altivec, tmp_di, tmp_di));
	}

      /* Do the VSLO to get the value into the final location.  */
      switch (mode)
	{
	case E_V2DFmode:
	  emit_insn (gen_vsx_vslo_v2df (dest, src, tmp_altivec));
	  return;

	case E_V2DImode:
	  emit_insn (gen_vsx_vslo_v2di (dest, src, tmp_altivec));
	  return;

	case E_V4SFmode:
	  {
	    rtx tmp_altivec_di = gen_rtx_REG (DImode, REGNO (tmp_altivec));
	    rtx tmp_altivec_v4sf = gen_rtx_REG (V4SFmode, REGNO (tmp_altivec));
	    rtx src_v2di = gen_rtx_REG (V2DImode, REGNO (src));
	    emit_insn (gen_vsx_vslo_v2di (tmp_altivec_di, src_v2di,
					  tmp_altivec));

	    emit_insn (gen_vsx_xscvspdp_scalar2 (dest, tmp_altivec_v4sf));
	    return;
	  }

	case E_V4SImode:
	case E_V8HImode:
	case E_V16QImode:
	  {
	    rtx tmp_altivec_di = gen_rtx_REG (DImode, REGNO (tmp_altivec));
	    rtx src_v2di = gen_rtx_REG (V2DImode, REGNO (src));
	    rtx tmp_gpr_di = gen_rtx_REG (DImode, REGNO (dest));
	    emit_insn (gen_vsx_vslo_v2di (tmp_altivec_di, src_v2di,
					  tmp_altivec));
	    emit_move_insn (tmp_gpr_di, tmp_altivec_di);
	    emit_insn (gen_lshrdi3 (tmp_gpr_di, tmp_gpr_di,
				    GEN_INT (64 - bits_in_element)));
	    return;
	  }

	default:
	  gcc_unreachable ();
	}

      return;
    }
  else
    gcc_unreachable ();
 }

/* Return alignment of TYPE.  Existing alignment is ALIGN.  HOW
   selects whether the alignment is abi mandated, optional, or
   both abi and optional alignment.  */
   
unsigned int
rs6000_data_alignment (tree type, unsigned int align, enum data_align how)
{
  if (how != align_opt)
    {
      if (TREE_CODE (type) == VECTOR_TYPE && align < 128)
	align = 128;
    }

  if (how != align_abi)
    {
      if (TREE_CODE (type) == ARRAY_TYPE
	  && TYPE_MODE (TREE_TYPE (type)) == QImode)
	{
	  if (align < BITS_PER_WORD)
	    align = BITS_PER_WORD;
	}
    }

  return align;
}

/* Implement TARGET_SLOW_UNALIGNED_ACCESS.  Altivec vector memory
   instructions simply ignore the low bits; VSX memory instructions
   are aligned to 4 or 8 bytes.  */

static bool
rs6000_slow_unaligned_access (machine_mode mode, unsigned int align)
{
  return (STRICT_ALIGNMENT
	  || (!TARGET_EFFICIENT_UNALIGNED_VSX
	      && ((SCALAR_FLOAT_MODE_NOT_VECTOR_P (mode) && align < 32)
		  || ((VECTOR_MODE_P (mode) || FLOAT128_VECTOR_P (mode))
		      && (int) align < VECTOR_ALIGN (mode)))));
}

/* Previous GCC releases forced all vector types to have 16-byte alignment.  */

bool
rs6000_special_adjust_field_align_p (tree type, unsigned int computed)
{
  if (TARGET_ALTIVEC && TREE_CODE (type) == VECTOR_TYPE)
    {
      if (computed != 128)
	{
	  static bool warned;
	  if (!warned && warn_psabi)
	    {
	      warned = true;
	      inform (input_location,
		      "the layout of aggregates containing vectors with"
		      " %d-byte alignment has changed in GCC 5",
		      computed / BITS_PER_UNIT);
	    }
	}
      /* In current GCC there is no special case.  */
      return false;
    }

  return false;
}

/* AIX increases natural record alignment to doubleword if the first
   field is an FP double while the FP fields remain word aligned.  */

unsigned int
rs6000_special_round_type_align (tree type, unsigned int computed,
				 unsigned int specified)
{
  unsigned int align = MAX (computed, specified);
  tree field = TYPE_FIELDS (type);

  /* Skip all non field decls */
  while (field != NULL && TREE_CODE (field) != FIELD_DECL)
    field = DECL_CHAIN (field);

  if (field != NULL && field != type)
    {
      type = TREE_TYPE (field);
      while (TREE_CODE (type) == ARRAY_TYPE)
	type = TREE_TYPE (type);

      if (type != error_mark_node && TYPE_MODE (type) == DFmode)
	align = MAX (align, 64);
    }

  return align;
}

/* Darwin increases record alignment to the natural alignment of
   the first field.  */

unsigned int
darwin_rs6000_special_round_type_align (tree type, unsigned int computed,
					unsigned int specified)
{
  unsigned int align = MAX (computed, specified);

  if (TYPE_PACKED (type))
    return align;

  /* Find the first field, looking down into aggregates.  */
  do {
    tree field = TYPE_FIELDS (type);
    /* Skip all non field decls */
    while (field != NULL && TREE_CODE (field) != FIELD_DECL)
      field = DECL_CHAIN (field);
    if (! field)
      break;
    /* A packed field does not contribute any extra alignment.  */
    if (DECL_PACKED (field))
      return align;
    type = TREE_TYPE (field);
    while (TREE_CODE (type) == ARRAY_TYPE)
      type = TREE_TYPE (type);
  } while (AGGREGATE_TYPE_P (type));

  if (! AGGREGATE_TYPE_P (type) && type != error_mark_node)
    align = MAX (align, TYPE_ALIGN (type));

  return align;
}

/* Return 1 for an operand in small memory on V.4/eabi.  */

int
small_data_operand (rtx op ATTRIBUTE_UNUSED,
		    machine_mode mode ATTRIBUTE_UNUSED)
{
#if TARGET_ELF
  rtx sym_ref;

  if (rs6000_sdata == SDATA_NONE || rs6000_sdata == SDATA_DATA)
    return 0;

  if (DEFAULT_ABI != ABI_V4)
    return 0;

  if (SYMBOL_REF_P (op))
    sym_ref = op;

  else if (GET_CODE (op) != CONST
	   || GET_CODE (XEXP (op, 0)) != PLUS
	   || !SYMBOL_REF_P (XEXP (XEXP (op, 0), 0))
	   || !CONST_INT_P (XEXP (XEXP (op, 0), 1)))
    return 0;

  else
    {
      rtx sum = XEXP (op, 0);
      HOST_WIDE_INT summand;

      /* We have to be careful here, because it is the referenced address
	 that must be 32k from _SDA_BASE_, not just the symbol.  */
      summand = INTVAL (XEXP (sum, 1));
      if (summand < 0 || summand > g_switch_value)
	return 0;

      sym_ref = XEXP (sum, 0);
    }

  return SYMBOL_REF_SMALL_P (sym_ref);
#else
  return 0;
#endif
}

/* Return true if either operand is a general purpose register.  */

bool
gpr_or_gpr_p (rtx op0, rtx op1)
{
  return ((REG_P (op0) && INT_REGNO_P (REGNO (op0)))
	  || (REG_P (op1) && INT_REGNO_P (REGNO (op1))));
}

/* Return true if this is a move direct operation between GPR registers and
   floating point/VSX registers.  */

bool
direct_move_p (rtx op0, rtx op1)
{
  if (!REG_P (op0) || !REG_P (op1))
    return false;

  if (!TARGET_DIRECT_MOVE)
    return false;

  int regno0 = REGNO (op0);
  int regno1 = REGNO (op1);
  if (!HARD_REGISTER_NUM_P (regno0) || !HARD_REGISTER_NUM_P (regno1))
    return false;

  if (INT_REGNO_P (regno0) && VSX_REGNO_P (regno1))
    return true;

  if (VSX_REGNO_P (regno0) && INT_REGNO_P (regno1))
    return true;

  return false;
}

/* Return true if the OFFSET is valid for the quad address instructions that
   use d-form (register + offset) addressing.  */

static inline bool
quad_address_offset_p (HOST_WIDE_INT offset)
{
  return (IN_RANGE (offset, -32768, 32767) && ((offset) & 0xf) == 0);
}

/* Return true if the ADDR is an acceptable address for a quad memory
   operation of mode MODE (either LQ/STQ for general purpose registers, or
   LXV/STXV for vector registers under ISA 3.0.  GPR_P is true if this address
   is intended for LQ/STQ.  If it is false, the address is intended for the ISA
   3.0 LXV/STXV instruction.  */

bool
quad_address_p (rtx addr, machine_mode mode, bool strict)
{
  rtx op0, op1;

  if (GET_MODE_SIZE (mode) != 16)
    return false;

  if (legitimate_indirect_address_p (addr, strict))
    return true;

  if (VECTOR_MODE_P (mode) && !mode_supports_dq_form (mode))
    return false;

  if (GET_CODE (addr) != PLUS)
    return false;

  op0 = XEXP (addr, 0);
  if (!REG_P (op0) || !INT_REG_OK_FOR_BASE_P (op0, strict))
    return false;

  op1 = XEXP (addr, 1);
  if (!CONST_INT_P (op1))
    return false;

  return quad_address_offset_p (INTVAL (op1));
}

/* Return true if this is a load or store quad operation.  This function does
   not handle the atomic quad memory instructions.  */

bool
quad_load_store_p (rtx op0, rtx op1)
{
  bool ret;

  if (!TARGET_QUAD_MEMORY)
    ret = false;

  else if (REG_P (op0) && MEM_P (op1))
    ret = (quad_int_reg_operand (op0, GET_MODE (op0))
	   && quad_memory_operand (op1, GET_MODE (op1))
	   && !reg_overlap_mentioned_p (op0, op1));

  else if (MEM_P (op0) && REG_P (op1))
    ret = (quad_memory_operand (op0, GET_MODE (op0))
	   && quad_int_reg_operand (op1, GET_MODE (op1)));

  else
    ret = false;

  if (TARGET_DEBUG_ADDR)
    {
      fprintf (stderr, "\n========== quad_load_store, return %s\n",
	       ret ? "true" : "false");
      debug_rtx (gen_rtx_SET (op0, op1));
    }

  return ret;
}

/* Given an address, return a constant offset term if one exists.  */

static rtx
address_offset (rtx op)
{
  if (GET_CODE (op) == PRE_INC
      || GET_CODE (op) == PRE_DEC)
    op = XEXP (op, 0);
  else if (GET_CODE (op) == PRE_MODIFY
	   || GET_CODE (op) == LO_SUM)
    op = XEXP (op, 1);

  if (GET_CODE (op) == CONST)
    op = XEXP (op, 0);

  if (GET_CODE (op) == PLUS)
    op = XEXP (op, 1);

  if (CONST_INT_P (op))
    return op;

  return NULL_RTX;
}

/* Return true if the MEM operand is a memory operand suitable for use
   with a (full width, possibly multiple) gpr load/store.  On
   powerpc64 this means the offset must be divisible by 4.
   Implements 'Y' constraint.

   Accept direct, indexed, offset, lo_sum and tocref.  Since this is
   a constraint function we know the operand has satisfied a suitable
   memory predicate.

   Offsetting a lo_sum should not be allowed, except where we know by
   alignment that a 32k boundary is not crossed.  Note that by
   "offsetting" here we mean a further offset to access parts of the
   MEM.  It's fine to have a lo_sum where the inner address is offset
   from a sym, since the same sym+offset will appear in the high part
   of the address calculation.  */

bool
mem_operand_gpr (rtx op, machine_mode mode)
{
  unsigned HOST_WIDE_INT offset;
  int extra;
  rtx addr = XEXP (op, 0);

  /* PR85755: Allow PRE_INC and PRE_DEC addresses.  */
  if (TARGET_UPDATE
      && (GET_CODE (addr) == PRE_INC || GET_CODE (addr) == PRE_DEC)
      && mode_supports_pre_incdec_p (mode)
      && legitimate_indirect_address_p (XEXP (addr, 0), false))
    return true;

  /* Don't allow non-offsettable addresses.  See PRs 83969 and 84279.  */
  if (!rs6000_offsettable_memref_p (op, mode, false))
    return false;

  op = address_offset (addr);
  if (op == NULL_RTX)
    return true;

  offset = INTVAL (op);
  if (TARGET_POWERPC64 && (offset & 3) != 0)
    return false;

  extra = GET_MODE_SIZE (mode) - UNITS_PER_WORD;
  if (extra < 0)
    extra = 0;

  if (GET_CODE (addr) == LO_SUM)
    /* For lo_sum addresses, we must allow any offset except one that
       causes a wrap, so test only the low 16 bits.  */
    offset = ((offset & 0xffff) ^ 0x8000) - 0x8000;

  return offset + 0x8000 < 0x10000u - extra;
}

/* As above, but for DS-FORM VSX insns.  Unlike mem_operand_gpr,
   enforce an offset divisible by 4 even for 32-bit.  */

bool
mem_operand_ds_form (rtx op, machine_mode mode)
{
  unsigned HOST_WIDE_INT offset;
  int extra;
  rtx addr = XEXP (op, 0);

  if (!offsettable_address_p (false, mode, addr))
    return false;

  op = address_offset (addr);
  if (op == NULL_RTX)
    return true;

  offset = INTVAL (op);
  if ((offset & 3) != 0)
    return false;

  extra = GET_MODE_SIZE (mode) - UNITS_PER_WORD;
  if (extra < 0)
    extra = 0;

  if (GET_CODE (addr) == LO_SUM)
    /* For lo_sum addresses, we must allow any offset except one that
       causes a wrap, so test only the low 16 bits.  */
    offset = ((offset & 0xffff) ^ 0x8000) - 0x8000;

  return offset + 0x8000 < 0x10000u - extra;
}

/* Subroutines of rs6000_legitimize_address and rs6000_legitimate_address_p.  */

static bool
reg_offset_addressing_ok_p (machine_mode mode)
{
  switch (mode)
    {
    case E_V16QImode:
    case E_V8HImode:
    case E_V4SFmode:
    case E_V4SImode:
    case E_V2DFmode:
    case E_V2DImode:
    case E_V1TImode:
    case E_TImode:
    case E_TFmode:
    case E_KFmode:
      /* AltiVec/VSX vector modes.  Only reg+reg addressing was valid until the
	 ISA 3.0 vector d-form addressing mode was added.  While TImode is not
	 a vector mode, if we want to use the VSX registers to move it around,
	 we need to restrict ourselves to reg+reg addressing.  Similarly for
	 IEEE 128-bit floating point that is passed in a single vector
	 register.  */
      if (VECTOR_MEM_ALTIVEC_OR_VSX_P (mode))
	return mode_supports_dq_form (mode);
      break;

    case E_SDmode:
      /* If we can do direct load/stores of SDmode, restrict it to reg+reg
	 addressing for the LFIWZX and STFIWX instructions.  */
      if (TARGET_NO_SDMODE_STACK)
	return false;
      break;

    default:
      break;
    }

  return true;
}

static bool
virtual_stack_registers_memory_p (rtx op)
{
  int regnum;

  if (REG_P (op))
    regnum = REGNO (op);

  else if (GET_CODE (op) == PLUS
	   && REG_P (XEXP (op, 0))
	   && CONST_INT_P (XEXP (op, 1)))
    regnum = REGNO (XEXP (op, 0));

  else
    return false;

  return (regnum >= FIRST_VIRTUAL_REGISTER
	  && regnum <= LAST_VIRTUAL_POINTER_REGISTER);
}

/* Return true if a MODE sized memory accesses to OP plus OFFSET
   is known to not straddle a 32k boundary.  This function is used
   to determine whether -mcmodel=medium code can use TOC pointer
   relative addressing for OP.  This means the alignment of the TOC
   pointer must also be taken into account, and unfortunately that is
   only 8 bytes.  */ 

#ifndef POWERPC64_TOC_POINTER_ALIGNMENT
#define POWERPC64_TOC_POINTER_ALIGNMENT 8
#endif

static bool
offsettable_ok_by_alignment (rtx op, HOST_WIDE_INT offset,
			     machine_mode mode)
{
  tree decl;
  unsigned HOST_WIDE_INT dsize, dalign, lsb, mask;

  if (!SYMBOL_REF_P (op))
    return false;

  /* ISA 3.0 vector d-form addressing is restricted, don't allow
     SYMBOL_REF.  */
  if (mode_supports_dq_form (mode))
    return false;

  dsize = GET_MODE_SIZE (mode);
  decl = SYMBOL_REF_DECL (op);
  if (!decl)
    {
      if (dsize == 0)
	return false;

      /* -fsection-anchors loses the original SYMBOL_REF_DECL when
	 replacing memory addresses with an anchor plus offset.  We
	 could find the decl by rummaging around in the block->objects
	 VEC for the given offset but that seems like too much work.  */
      dalign = BITS_PER_UNIT;
      if (SYMBOL_REF_HAS_BLOCK_INFO_P (op)
	  && SYMBOL_REF_ANCHOR_P (op)
	  && SYMBOL_REF_BLOCK (op) != NULL)
	{
	  struct object_block *block = SYMBOL_REF_BLOCK (op);

	  dalign = block->alignment;
	  offset += SYMBOL_REF_BLOCK_OFFSET (op);
	}
      else if (CONSTANT_POOL_ADDRESS_P (op))
	{
	  /* It would be nice to have get_pool_align()..  */
	  machine_mode cmode = get_pool_mode (op);

	  dalign = GET_MODE_ALIGNMENT (cmode);
	}
    }
  else if (DECL_P (decl))
    {
      dalign = DECL_ALIGN (decl);

      if (dsize == 0)
	{
	  /* Allow BLKmode when the entire object is known to not
	     cross a 32k boundary.  */
	  if (!DECL_SIZE_UNIT (decl))
	    return false;

	  if (!tree_fits_uhwi_p (DECL_SIZE_UNIT (decl)))
	    return false;

	  dsize = tree_to_uhwi (DECL_SIZE_UNIT (decl));
	  if (dsize > 32768)
	    return false;

	  dalign /= BITS_PER_UNIT;
	  if (dalign > POWERPC64_TOC_POINTER_ALIGNMENT)
	    dalign = POWERPC64_TOC_POINTER_ALIGNMENT;
	  return dalign >= dsize;
	}
    }
  else
    gcc_unreachable ();

  /* Find how many bits of the alignment we know for this access.  */
  dalign /= BITS_PER_UNIT;
  if (dalign > POWERPC64_TOC_POINTER_ALIGNMENT)
    dalign = POWERPC64_TOC_POINTER_ALIGNMENT;
  mask = dalign - 1;
  lsb = offset & -offset;
  mask &= lsb - 1;
  dalign = mask + 1;

  return dalign >= dsize;
}

static bool
constant_pool_expr_p (rtx op)
{
  rtx base, offset;

  split_const (op, &base, &offset);
  return (SYMBOL_REF_P (base)
	  && CONSTANT_POOL_ADDRESS_P (base)
	  && ASM_OUTPUT_SPECIAL_POOL_ENTRY_P (get_pool_constant (base), Pmode));
}

/* These are only used to pass through from print_operand/print_operand_address
   to rs6000_output_addr_const_extra over the intervening function
   output_addr_const which is not target code.  */
static const_rtx tocrel_base_oac, tocrel_offset_oac;

/* Return true if OP is a toc pointer relative address (the output
   of create_TOC_reference).  If STRICT, do not match non-split
   -mcmodel=large/medium toc pointer relative addresses.  If the pointers 
   are non-NULL, place base and offset pieces in TOCREL_BASE_RET and 
   TOCREL_OFFSET_RET respectively.  */

bool
toc_relative_expr_p (const_rtx op, bool strict, const_rtx *tocrel_base_ret,
		     const_rtx *tocrel_offset_ret)
{
  if (!TARGET_TOC)
    return false;

  if (TARGET_CMODEL != CMODEL_SMALL)
    {
      /* When strict ensure we have everything tidy.  */
      if (strict
	  && !(GET_CODE (op) == LO_SUM
	       && REG_P (XEXP (op, 0))
	       && INT_REG_OK_FOR_BASE_P (XEXP (op, 0), strict)))
	return false;

      /* When not strict, allow non-split TOC addresses and also allow
	 (lo_sum (high ..)) TOC addresses created during reload.  */
      if (GET_CODE (op) == LO_SUM)
	op = XEXP (op, 1);
    }

  const_rtx tocrel_base = op;
  const_rtx tocrel_offset = const0_rtx;

  if (GET_CODE (op) == PLUS && add_cint_operand (XEXP (op, 1), GET_MODE (op)))
    {
      tocrel_base = XEXP (op, 0);
      tocrel_offset = XEXP (op, 1);
    }

  if (tocrel_base_ret)
    *tocrel_base_ret = tocrel_base;
  if (tocrel_offset_ret)
    *tocrel_offset_ret = tocrel_offset;

  return (GET_CODE (tocrel_base) == UNSPEC
	  && XINT (tocrel_base, 1) == UNSPEC_TOCREL
	  && REG_P (XVECEXP (tocrel_base, 0, 1))
	  && REGNO (XVECEXP (tocrel_base, 0, 1)) == TOC_REGISTER);
}

/* Return true if X is a constant pool address, and also for cmodel=medium
   if X is a toc-relative address known to be offsettable within MODE.  */

bool
legitimate_constant_pool_address_p (const_rtx x, machine_mode mode,
				    bool strict)
{
  const_rtx tocrel_base, tocrel_offset;
  return (toc_relative_expr_p (x, strict, &tocrel_base, &tocrel_offset)
	  && (TARGET_CMODEL != CMODEL_MEDIUM
	      || constant_pool_expr_p (XVECEXP (tocrel_base, 0, 0))
	      || mode == QImode
	      || offsettable_ok_by_alignment (XVECEXP (tocrel_base, 0, 0),
					      INTVAL (tocrel_offset), mode)));
}

static bool
legitimate_small_data_p (machine_mode mode, rtx x)
{
  return (DEFAULT_ABI == ABI_V4
	  && !flag_pic && !TARGET_TOC
	  && (SYMBOL_REF_P (x) || GET_CODE (x) == CONST)
	  && small_data_operand (x, mode));
}

bool
rs6000_legitimate_offset_address_p (machine_mode mode, rtx x,
				    bool strict, bool worst_case)
{
  unsigned HOST_WIDE_INT offset;
  unsigned int extra;

  if (GET_CODE (x) != PLUS)
    return false;
  if (!REG_P (XEXP (x, 0)))
    return false;
  if (!INT_REG_OK_FOR_BASE_P (XEXP (x, 0), strict))
    return false;
  if (mode_supports_dq_form (mode))
    return quad_address_p (x, mode, strict);
  if (!reg_offset_addressing_ok_p (mode))
    return virtual_stack_registers_memory_p (x);
  if (legitimate_constant_pool_address_p (x, mode, strict || lra_in_progress))
    return true;
  if (!CONST_INT_P (XEXP (x, 1)))
    return false;

  offset = INTVAL (XEXP (x, 1));
  extra = 0;
  switch (mode)
    {
    case E_DFmode:
    case E_DDmode:
    case E_DImode:
      /* If we are using VSX scalar loads, restrict ourselves to reg+reg
	 addressing.  */
      if (VECTOR_MEM_VSX_P (mode))
	return false;

      if (!worst_case)
	break;
      if (!TARGET_POWERPC64)
	extra = 4;
      else if (offset & 3)
	return false;
      break;

    case E_TFmode:
    case E_IFmode:
    case E_KFmode:
    case E_TDmode:
    case E_TImode:
    case E_PTImode:
      extra = 8;
      if (!worst_case)
	break;
      if (!TARGET_POWERPC64)
	extra = 12;
      else if (offset & 3)
	return false;
      break;

    default:
      break;
    }

  offset += 0x8000;
  return offset < 0x10000 - extra;
}

bool
legitimate_indexed_address_p (rtx x, int strict)
{
  rtx op0, op1;

  if (GET_CODE (x) != PLUS)
    return false;

  op0 = XEXP (x, 0);
  op1 = XEXP (x, 1);

  return (REG_P (op0) && REG_P (op1)
	  && ((INT_REG_OK_FOR_BASE_P (op0, strict)
	       && INT_REG_OK_FOR_INDEX_P (op1, strict))
	      || (INT_REG_OK_FOR_BASE_P (op1, strict)
		  && INT_REG_OK_FOR_INDEX_P (op0, strict))));
}

bool
avoiding_indexed_address_p (machine_mode mode)
{
  /* Avoid indexed addressing for modes that have non-indexed
     load/store instruction forms.  */
  return (TARGET_AVOID_XFORM && VECTOR_MEM_NONE_P (mode));
}

bool
legitimate_indirect_address_p (rtx x, int strict)
{
  return REG_P (x) && INT_REG_OK_FOR_BASE_P (x, strict);
}

bool
macho_lo_sum_memory_operand (rtx x, machine_mode mode)
{
  if (!TARGET_MACHO || !flag_pic
      || mode != SImode || !MEM_P (x))
    return false;
  x = XEXP (x, 0);

  if (GET_CODE (x) != LO_SUM)
    return false;
  if (!REG_P (XEXP (x, 0)))
    return false;
  if (!INT_REG_OK_FOR_BASE_P (XEXP (x, 0), 0))
    return false;
  x = XEXP (x, 1);

  return CONSTANT_P (x);
}

static bool
legitimate_lo_sum_address_p (machine_mode mode, rtx x, int strict)
{
  if (GET_CODE (x) != LO_SUM)
    return false;
  if (!REG_P (XEXP (x, 0)))
    return false;
  if (!INT_REG_OK_FOR_BASE_P (XEXP (x, 0), strict))
    return false;
  /* quad word addresses are restricted, and we can't use LO_SUM.  */
  if (mode_supports_dq_form (mode))
    return false;
  x = XEXP (x, 1);

  if (TARGET_ELF || TARGET_MACHO)
    {
      bool large_toc_ok;

      if (DEFAULT_ABI == ABI_V4 && flag_pic)
	return false;
      /* LRA doesn't use LEGITIMIZE_RELOAD_ADDRESS as it usually calls
	 push_reload from reload pass code.  LEGITIMIZE_RELOAD_ADDRESS
	 recognizes some LO_SUM addresses as valid although this
	 function says opposite.  In most cases, LRA through different
	 transformations can generate correct code for address reloads.
	 It cannot manage only some LO_SUM cases.  So we need to add
	 code here saying that some addresses are still valid.  */
      large_toc_ok = (lra_in_progress && TARGET_CMODEL != CMODEL_SMALL
		      && small_toc_ref (x, VOIDmode));
      if (TARGET_TOC && ! large_toc_ok)
	return false;
      if (GET_MODE_NUNITS (mode) != 1)
	return false;
      if (GET_MODE_SIZE (mode) > UNITS_PER_WORD
	  && !(/* ??? Assume floating point reg based on mode?  */
	       TARGET_HARD_FLOAT && (mode == DFmode || mode == DDmode)))
	return false;

      return CONSTANT_P (x) || large_toc_ok;
    }

  return false;
}


/* Try machine-dependent ways of modifying an illegitimate address
   to be legitimate.  If we find one, return the new, valid address.
   This is used from only one place: `memory_address' in explow.c.

   OLDX is the address as it was before break_out_memory_refs was
   called.  In some cases it is useful to look at this to decide what
   needs to be done.

   It is always safe for this function to do nothing.  It exists to
   recognize opportunities to optimize the output.

   On RS/6000, first check for the sum of a register with a constant
   integer that is out of range.  If so, generate code to add the
   constant with the low-order 16 bits masked to the register and force
   this result into another register (this can be done with `cau').
   Then generate an address of REG+(CONST&0xffff), allowing for the
   possibility of bit 16 being a one.

   Then check for the sum of a register and something not constant, try to
   load the other things into a register and return the sum.  */

static rtx
rs6000_legitimize_address (rtx x, rtx oldx ATTRIBUTE_UNUSED,
			   machine_mode mode)
{
  unsigned int extra;

  if (!reg_offset_addressing_ok_p (mode)
      || mode_supports_dq_form (mode))
    {
      if (virtual_stack_registers_memory_p (x))
	return x;

      /* In theory we should not be seeing addresses of the form reg+0,
	 but just in case it is generated, optimize it away.  */
      if (GET_CODE (x) == PLUS && XEXP (x, 1) == const0_rtx)
	return force_reg (Pmode, XEXP (x, 0));

      /* For TImode with load/store quad, restrict addresses to just a single
	 pointer, so it works with both GPRs and VSX registers.  */
      /* Make sure both operands are registers.  */
      else if (GET_CODE (x) == PLUS
	       && (mode != TImode || !TARGET_VSX))
	return gen_rtx_PLUS (Pmode,
			     force_reg (Pmode, XEXP (x, 0)),
			     force_reg (Pmode, XEXP (x, 1)));
      else
	return force_reg (Pmode, x);
    }
  if (SYMBOL_REF_P (x))
    {
      enum tls_model model = SYMBOL_REF_TLS_MODEL (x);
      if (model != 0)
	return rs6000_legitimize_tls_address (x, model);
    }

  extra = 0;
  switch (mode)
    {
    case E_TFmode:
    case E_TDmode:
    case E_TImode:
    case E_PTImode:
    case E_IFmode:
    case E_KFmode:
      /* As in legitimate_offset_address_p we do not assume
	 worst-case.  The mode here is just a hint as to the registers
	 used.  A TImode is usually in gprs, but may actually be in
	 fprs.  Leave worst-case scenario for reload to handle via
	 insn constraints.  PTImode is only GPRs.  */
      extra = 8;
      break;
    default:
      break;
    }

  if (GET_CODE (x) == PLUS
      && REG_P (XEXP (x, 0))
      && CONST_INT_P (XEXP (x, 1))
      && ((unsigned HOST_WIDE_INT) (INTVAL (XEXP (x, 1)) + 0x8000)
	  >= 0x10000 - extra))
    {
      HOST_WIDE_INT high_int, low_int;
      rtx sum;
      low_int = ((INTVAL (XEXP (x, 1)) & 0xffff) ^ 0x8000) - 0x8000;
      if (low_int >= 0x8000 - extra)
	low_int = 0;
      high_int = INTVAL (XEXP (x, 1)) - low_int;
      sum = force_operand (gen_rtx_PLUS (Pmode, XEXP (x, 0),
					 GEN_INT (high_int)), 0);
      return plus_constant (Pmode, sum, low_int);
    }
  else if (GET_CODE (x) == PLUS
	   && REG_P (XEXP (x, 0))
	   && !CONST_INT_P (XEXP (x, 1))
	   && GET_MODE_NUNITS (mode) == 1
	   && (GET_MODE_SIZE (mode) <= UNITS_PER_WORD
	       || (/* ??? Assume floating point reg based on mode?  */
		   TARGET_HARD_FLOAT && (mode == DFmode || mode == DDmode)))
	   && !avoiding_indexed_address_p (mode))
    {
      return gen_rtx_PLUS (Pmode, XEXP (x, 0),
			   force_reg (Pmode, force_operand (XEXP (x, 1), 0)));
    }
  else if ((TARGET_ELF
#if TARGET_MACHO
	    || !MACHO_DYNAMIC_NO_PIC_P
#endif
	    )
	   && TARGET_32BIT
	   && TARGET_NO_TOC
	   && !flag_pic
	   && !CONST_INT_P (x)
	   && !CONST_WIDE_INT_P (x)
	   && !CONST_DOUBLE_P (x)
	   && CONSTANT_P (x)
	   && GET_MODE_NUNITS (mode) == 1
	   && (GET_MODE_SIZE (mode) <= UNITS_PER_WORD
	       || (/* ??? Assume floating point reg based on mode?  */
		   TARGET_HARD_FLOAT && (mode == DFmode || mode == DDmode))))
    {
      rtx reg = gen_reg_rtx (Pmode);
      if (TARGET_ELF)
	emit_insn (gen_elf_high (reg, x));
      else
	emit_insn (gen_macho_high (reg, x));
      return gen_rtx_LO_SUM (Pmode, reg, x);
    }
  else if (TARGET_TOC
	   && SYMBOL_REF_P (x)
	   && constant_pool_expr_p (x)
	   && ASM_OUTPUT_SPECIAL_POOL_ENTRY_P (get_pool_constant (x), Pmode))
    return create_TOC_reference (x, NULL_RTX);
  else
    return x;
}

/* Debug version of rs6000_legitimize_address.  */
static rtx
rs6000_debug_legitimize_address (rtx x, rtx oldx, machine_mode mode)
{
  rtx ret;
  rtx_insn *insns;

  start_sequence ();
  ret = rs6000_legitimize_address (x, oldx, mode);
  insns = get_insns ();
  end_sequence ();

  if (ret != x)
    {
      fprintf (stderr,
	       "\nrs6000_legitimize_address: mode %s, old code %s, "
	       "new code %s, modified\n",
	       GET_MODE_NAME (mode), GET_RTX_NAME (GET_CODE (x)),
	       GET_RTX_NAME (GET_CODE (ret)));

      fprintf (stderr, "Original address:\n");
      debug_rtx (x);

      fprintf (stderr, "oldx:\n");
      debug_rtx (oldx);

      fprintf (stderr, "New address:\n");
      debug_rtx (ret);

      if (insns)
	{
	  fprintf (stderr, "Insns added:\n");
	  debug_rtx_list (insns, 20);
	}
    }
  else
    {
      fprintf (stderr,
	       "\nrs6000_legitimize_address: mode %s, code %s, no change:\n",
	       GET_MODE_NAME (mode), GET_RTX_NAME (GET_CODE (x)));

      debug_rtx (x);
    }

  if (insns)
    emit_insn (insns);

  return ret;
}

/* This is called from dwarf2out.c via TARGET_ASM_OUTPUT_DWARF_DTPREL.
   We need to emit DTP-relative relocations.  */

static void rs6000_output_dwarf_dtprel (FILE *, int, rtx) ATTRIBUTE_UNUSED;
static void
rs6000_output_dwarf_dtprel (FILE *file, int size, rtx x)
{
  switch (size)
    {
    case 4:
      fputs ("\t.long\t", file);
      break;
    case 8:
      fputs (DOUBLE_INT_ASM_OP, file);
      break;
    default:
      gcc_unreachable ();
    }
  output_addr_const (file, x);
  if (TARGET_ELF)
    fputs ("@dtprel+0x8000", file);
  else if (TARGET_XCOFF && SYMBOL_REF_P (x))
    {
      switch (SYMBOL_REF_TLS_MODEL (x))
	{
	case 0:
	  break;
	case TLS_MODEL_LOCAL_EXEC:
	  fputs ("@le", file);
	  break;
	case TLS_MODEL_INITIAL_EXEC:
	  fputs ("@ie", file);
	  break;
	case TLS_MODEL_GLOBAL_DYNAMIC:
	case TLS_MODEL_LOCAL_DYNAMIC:
	  fputs ("@m", file);
	  break;
	default:
	  gcc_unreachable ();
	}
    }
}

/* Return true if X is a symbol that refers to real (rather than emulated)
   TLS.  */

static bool
rs6000_real_tls_symbol_ref_p (rtx x)
{
  return (SYMBOL_REF_P (x)
	  && SYMBOL_REF_TLS_MODEL (x) >= TLS_MODEL_REAL);
}

/* In the name of slightly smaller debug output, and to cater to
   general assembler lossage, recognize various UNSPEC sequences
   and turn them back into a direct symbol reference.  */

static rtx
rs6000_delegitimize_address (rtx orig_x)
{
  rtx x, y, offset;

  if (GET_CODE (orig_x) == UNSPEC && XINT (orig_x, 1) == UNSPEC_FUSION_GPR)
    orig_x = XVECEXP (orig_x, 0, 0);

  orig_x = delegitimize_mem_from_attrs (orig_x);

  x = orig_x;
  if (MEM_P (x))
    x = XEXP (x, 0);

  y = x;
  if (TARGET_CMODEL != CMODEL_SMALL && GET_CODE (y) == LO_SUM)
    y = XEXP (y, 1);

  offset = NULL_RTX;
  if (GET_CODE (y) == PLUS
      && GET_MODE (y) == Pmode
      && CONST_INT_P (XEXP (y, 1)))
    {
      offset = XEXP (y, 1);
      y = XEXP (y, 0);
    }

  if (GET_CODE (y) == UNSPEC && XINT (y, 1) == UNSPEC_TOCREL)
    {
      y = XVECEXP (y, 0, 0);

#ifdef HAVE_AS_TLS
      /* Do not associate thread-local symbols with the original
	 constant pool symbol.  */
      if (TARGET_XCOFF
	  && SYMBOL_REF_P (y)
	  && CONSTANT_POOL_ADDRESS_P (y)
	  && rs6000_real_tls_symbol_ref_p (get_pool_constant (y)))
	return orig_x;
#endif

      if (offset != NULL_RTX)
	y = gen_rtx_PLUS (Pmode, y, offset);
      if (!MEM_P (orig_x))
	return y;
      else
	return replace_equiv_address_nv (orig_x, y);
    }

  if (TARGET_MACHO
      && GET_CODE (orig_x) == LO_SUM
      && GET_CODE (XEXP (orig_x, 1)) == CONST)
    {
      y = XEXP (XEXP (orig_x, 1), 0);
      if (GET_CODE (y) == UNSPEC && XINT (y, 1) == UNSPEC_MACHOPIC_OFFSET)
	return XVECEXP (y, 0, 0);
    }

  return orig_x;
}

/* Return true if X shouldn't be emitted into the debug info.
   The linker doesn't like .toc section references from
   .debug_* sections, so reject .toc section symbols.  */

static bool
rs6000_const_not_ok_for_debug_p (rtx x)
{
  if (GET_CODE (x) == UNSPEC)
    return true;
  if (SYMBOL_REF_P (x)
      && CONSTANT_POOL_ADDRESS_P (x))
    {
      rtx c = get_pool_constant (x);
      machine_mode cmode = get_pool_mode (x);
      if (ASM_OUTPUT_SPECIAL_POOL_ENTRY_P (c, cmode))
	return true;
    }

  return false;
}

/* Implement the TARGET_LEGITIMATE_COMBINED_INSN hook.  */

static bool
rs6000_legitimate_combined_insn (rtx_insn *insn)
{
  int icode = INSN_CODE (insn);

  /* Reject creating doloop insns.  Combine should not be allowed
     to create these for a number of reasons:
     1) In a nested loop, if combine creates one of these in an
     outer loop and the register allocator happens to allocate ctr
     to the outer loop insn, then the inner loop can't use ctr.
     Inner loops ought to be more highly optimized.
     2) Combine often wants to create one of these from what was
     originally a three insn sequence, first combining the three
     insns to two, then to ctrsi/ctrdi.  When ctrsi/ctrdi is not
     allocated ctr, the splitter takes use back to the three insn
     sequence.  It's better to stop combine at the two insn
     sequence.
     3) Faced with not being able to allocate ctr for ctrsi/crtdi
     insns, the register allocator sometimes uses floating point
     or vector registers for the pseudo.  Since ctrsi/ctrdi is a
     jump insn and output reloads are not implemented for jumps,
     the ctrsi/ctrdi splitters need to handle all possible cases.
     That's a pain, and it gets to be seriously difficult when a
     splitter that runs after reload needs memory to transfer from
     a gpr to fpr.  See PR70098 and PR71763 which are not fixed
     for the difficult case.  It's better to not create problems
     in the first place.  */
  if (icode != CODE_FOR_nothing
      && (icode == CODE_FOR_bdz_si
	  || icode == CODE_FOR_bdz_di
	  || icode == CODE_FOR_bdnz_si
	  || icode == CODE_FOR_bdnz_di
	  || icode == CODE_FOR_bdztf_si
	  || icode == CODE_FOR_bdztf_di
	  || icode == CODE_FOR_bdnztf_si
	  || icode == CODE_FOR_bdnztf_di))
    return false;

  return true;
}

/* Construct the SYMBOL_REF for the tls_get_addr function.  */

static GTY(()) rtx rs6000_tls_symbol;
static rtx
rs6000_tls_get_addr (void)
{
  if (!rs6000_tls_symbol)
    rs6000_tls_symbol = init_one_libfunc ("__tls_get_addr");

  return rs6000_tls_symbol;
}

/* Construct the SYMBOL_REF for TLS GOT references.  */

static GTY(()) rtx rs6000_got_symbol;
static rtx
rs6000_got_sym (void)
{
  if (!rs6000_got_symbol)
    {
      rs6000_got_symbol = gen_rtx_SYMBOL_REF (Pmode, "_GLOBAL_OFFSET_TABLE_");
      SYMBOL_REF_FLAGS (rs6000_got_symbol) |= SYMBOL_FLAG_LOCAL;
      SYMBOL_REF_FLAGS (rs6000_got_symbol) |= SYMBOL_FLAG_EXTERNAL;
    }

  return rs6000_got_symbol;
}

/* AIX Thread-Local Address support.  */

static rtx
rs6000_legitimize_tls_address_aix (rtx addr, enum tls_model model)
{
  rtx sym, mem, tocref, tlsreg, tmpreg, dest, tlsaddr;
  const char *name;
  char *tlsname;

  name = XSTR (addr, 0);
  /* Append TLS CSECT qualifier, unless the symbol already is qualified
     or the symbol will be in TLS private data section.  */
  if (name[strlen (name) - 1] != ']'
      && (TREE_PUBLIC (SYMBOL_REF_DECL (addr))
	  || bss_initializer_p (SYMBOL_REF_DECL (addr))))
    {
      tlsname = XALLOCAVEC (char, strlen (name) + 4);
      strcpy (tlsname, name);
      strcat (tlsname,
	      bss_initializer_p (SYMBOL_REF_DECL (addr)) ? "[UL]" : "[TL]");
      tlsaddr = copy_rtx (addr);
      XSTR (tlsaddr, 0) = ggc_strdup (tlsname);
    }
  else
    tlsaddr = addr;

  /* Place addr into TOC constant pool.  */
  sym = force_const_mem (GET_MODE (tlsaddr), tlsaddr);

  /* Output the TOC entry and create the MEM referencing the value.  */
  if (constant_pool_expr_p (XEXP (sym, 0))
      && ASM_OUTPUT_SPECIAL_POOL_ENTRY_P (get_pool_constant (XEXP (sym, 0)), Pmode))
    {
      tocref = create_TOC_reference (XEXP (sym, 0), NULL_RTX);
      mem = gen_const_mem (Pmode, tocref);
      set_mem_alias_set (mem, get_TOC_alias_set ());
    }
  else
    return sym;

  /* Use global-dynamic for local-dynamic.  */
  if (model == TLS_MODEL_GLOBAL_DYNAMIC
      || model == TLS_MODEL_LOCAL_DYNAMIC)
    {
      /* Create new TOC reference for @m symbol.  */
      name = XSTR (XVECEXP (XEXP (mem, 0), 0, 0), 0);
      tlsname = XALLOCAVEC (char, strlen (name) + 1);
      strcpy (tlsname, "*LCM");
      strcat (tlsname, name + 3);
      rtx modaddr = gen_rtx_SYMBOL_REF (Pmode, ggc_strdup (tlsname));
      SYMBOL_REF_FLAGS (modaddr) |= SYMBOL_FLAG_LOCAL;
      tocref = create_TOC_reference (modaddr, NULL_RTX);
      rtx modmem = gen_const_mem (Pmode, tocref);
      set_mem_alias_set (modmem, get_TOC_alias_set ());
      
      rtx modreg = gen_reg_rtx (Pmode);
      emit_insn (gen_rtx_SET (modreg, modmem));

      tmpreg = gen_reg_rtx (Pmode);
      emit_insn (gen_rtx_SET (tmpreg, mem));

      dest = gen_reg_rtx (Pmode);
      if (TARGET_32BIT)
	emit_insn (gen_tls_get_addrsi (dest, modreg, tmpreg));
      else
	emit_insn (gen_tls_get_addrdi (dest, modreg, tmpreg));
      return dest;
    }
  /* Obtain TLS pointer: 32 bit call or 64 bit GPR 13.  */
  else if (TARGET_32BIT)
    {
      tlsreg = gen_reg_rtx (SImode);
      emit_insn (gen_tls_get_tpointer (tlsreg));
    }
  else
    tlsreg = gen_rtx_REG (DImode, 13);

  /* Load the TOC value into temporary register.  */
  tmpreg = gen_reg_rtx (Pmode);
  emit_insn (gen_rtx_SET (tmpreg, mem));
  set_unique_reg_note (get_last_insn (), REG_EQUAL,
		       gen_rtx_MINUS (Pmode, addr, tlsreg));

  /* Add TOC symbol value to TLS pointer.  */
  dest = force_reg (Pmode, gen_rtx_PLUS (Pmode, tmpreg, tlsreg));

  return dest;
}

/* Output arg setup instructions for a !TARGET_TLS_MARKERS
   __tls_get_addr call.  */

void
rs6000_output_tlsargs (rtx *operands)
{
  /* Set up operands for output_asm_insn, without modifying OPERANDS.  */
  rtx op[3];

  /* The set dest of the call, ie. r3, which is also the first arg reg.  */
  op[0] = operands[0];
  /* The TLS symbol from global_tlsarg stashed as CALL operand 2.  */
  op[1] = XVECEXP (operands[2], 0, 0);
  if (XINT (operands[2], 1) == UNSPEC_TLSGD)
    {
      /* The GOT register.  */
      op[2] = XVECEXP (operands[2], 0, 1);
      if (TARGET_CMODEL != CMODEL_SMALL)
	output_asm_insn ("addis %0,%2,%1@got@tlsgd@ha\n\t"
			 "addi %0,%0,%1@got@tlsgd@l", op);
      else
	output_asm_insn ("addi %0,%2,%1@got@tlsgd", op);
    }
  else if (XINT (operands[2], 1) == UNSPEC_TLSLD)
    {
      if (TARGET_CMODEL != CMODEL_SMALL)
	output_asm_insn ("addis %0,%1,%&@got@tlsld@ha\n\t"
			 "addi %0,%0,%&@got@tlsld@l", op);
      else
	output_asm_insn ("addi %0,%1,%&@got@tlsld", op);
    }
  else
    gcc_unreachable ();
}

/* Passes the tls arg value for global dynamic and local dynamic
   emit_library_call_value in rs6000_legitimize_tls_address to
   rs6000_call_aix and rs6000_call_sysv.  This is used to emit the
   marker relocs put on __tls_get_addr calls.  */
static rtx global_tlsarg;

/* ADDR contains a thread-local SYMBOL_REF.  Generate code to compute
   this (thread-local) address.  */

static rtx
rs6000_legitimize_tls_address (rtx addr, enum tls_model model)
{
  rtx dest, insn;

  if (TARGET_XCOFF)
    return rs6000_legitimize_tls_address_aix (addr, model);

  dest = gen_reg_rtx (Pmode);
  if (model == TLS_MODEL_LOCAL_EXEC && rs6000_tls_size == 16)
    {
      rtx tlsreg;

      if (TARGET_64BIT)
	{
	  tlsreg = gen_rtx_REG (Pmode, 13);
	  insn = gen_tls_tprel_64 (dest, tlsreg, addr);
	}
      else
	{
	  tlsreg = gen_rtx_REG (Pmode, 2);
	  insn = gen_tls_tprel_32 (dest, tlsreg, addr);
	}
      emit_insn (insn);
    }
  else if (model == TLS_MODEL_LOCAL_EXEC && rs6000_tls_size == 32)
    {
      rtx tlsreg, tmp;

      tmp = gen_reg_rtx (Pmode);
      if (TARGET_64BIT)
	{
	  tlsreg = gen_rtx_REG (Pmode, 13);
	  insn = gen_tls_tprel_ha_64 (tmp, tlsreg, addr);
	}
      else
	{
	  tlsreg = gen_rtx_REG (Pmode, 2);
	  insn = gen_tls_tprel_ha_32 (tmp, tlsreg, addr);
	}
      emit_insn (insn);
      if (TARGET_64BIT)
	insn = gen_tls_tprel_lo_64 (dest, tmp, addr);
      else
	insn = gen_tls_tprel_lo_32 (dest, tmp, addr);
      emit_insn (insn);
    }
  else
    {
      rtx got, tga, tmp1, tmp2;

      /* We currently use relocations like @got@tlsgd for tls, which
	 means the linker will handle allocation of tls entries, placing
	 them in the .got section.  So use a pointer to the .got section,
	 not one to secondary TOC sections used by 64-bit -mminimal-toc,
	 or to secondary GOT sections used by 32-bit -fPIC.  */
      if (TARGET_64BIT)
	got = gen_rtx_REG (Pmode, 2);
      else
	{
	  if (flag_pic == 1)
	    got = gen_rtx_REG (Pmode, RS6000_PIC_OFFSET_TABLE_REGNUM);
	  else
	    {
	      rtx gsym = rs6000_got_sym ();
	      got = gen_reg_rtx (Pmode);
	      if (flag_pic == 0)
		rs6000_emit_move (got, gsym, Pmode);
	      else
		{
		  rtx mem, lab;

		  tmp1 = gen_reg_rtx (Pmode);
		  tmp2 = gen_reg_rtx (Pmode);
		  mem = gen_const_mem (Pmode, tmp1);
		  lab = gen_label_rtx ();
		  emit_insn (gen_load_toc_v4_PIC_1b (gsym, lab));
		  emit_move_insn (tmp1, gen_rtx_REG (Pmode, LR_REGNO));
		  if (TARGET_LINK_STACK)
		    emit_insn (gen_addsi3 (tmp1, tmp1, GEN_INT (4)));
		  emit_move_insn (tmp2, mem);
		  rtx_insn *last = emit_insn (gen_addsi3 (got, tmp1, tmp2));
		  set_unique_reg_note (last, REG_EQUAL, gsym);
		}
	    }
	}

      if (model == TLS_MODEL_GLOBAL_DYNAMIC)
	{
	  rtx arg = gen_rtx_UNSPEC (Pmode, gen_rtvec (2, addr, got),
				    UNSPEC_TLSGD);
	  tga = rs6000_tls_get_addr ();
	  global_tlsarg = arg;
	  if (TARGET_TLS_MARKERS)
	    {
	      rtx argreg = gen_rtx_REG (Pmode, 3);
	      emit_insn (gen_rtx_SET (argreg, arg));
	      emit_library_call_value (tga, dest, LCT_CONST, Pmode,
				       argreg, Pmode);
	    }
	  else
	    emit_library_call_value (tga, dest, LCT_CONST, Pmode);
	  global_tlsarg = NULL_RTX;

	  /* Make a note so that the result of this call can be CSEd.  */
	  rtvec vec = gen_rtvec (1, copy_rtx (arg));
	  rtx uns = gen_rtx_UNSPEC (Pmode, vec, UNSPEC_TLS_GET_ADDR);
	  set_unique_reg_note (get_last_insn (), REG_EQUAL, uns);
	}
      else if (model == TLS_MODEL_LOCAL_DYNAMIC)
	{
	  rtx arg = gen_rtx_UNSPEC (Pmode, gen_rtvec (1, got), UNSPEC_TLSLD);
	  tga = rs6000_tls_get_addr ();
	  tmp1 = gen_reg_rtx (Pmode);
	  global_tlsarg = arg;
	  if (TARGET_TLS_MARKERS)
	    {
	      rtx argreg = gen_rtx_REG (Pmode, 3);
	      emit_insn (gen_rtx_SET (argreg, arg));
	      emit_library_call_value (tga, tmp1, LCT_CONST, Pmode,
				       argreg, Pmode);
	    }
	  else
	    emit_library_call_value (tga, tmp1, LCT_CONST, Pmode);
	  global_tlsarg = NULL_RTX;

	  /* Make a note so that the result of this call can be CSEd.  */
	  rtvec vec = gen_rtvec (1, copy_rtx (arg));
	  rtx uns = gen_rtx_UNSPEC (Pmode, vec, UNSPEC_TLS_GET_ADDR);
	  set_unique_reg_note (get_last_insn (), REG_EQUAL, uns);

	  if (rs6000_tls_size == 16)
	    {
	      if (TARGET_64BIT)
		insn = gen_tls_dtprel_64 (dest, tmp1, addr);
	      else
		insn = gen_tls_dtprel_32 (dest, tmp1, addr);
	    }
	  else if (rs6000_tls_size == 32)
	    {
	      tmp2 = gen_reg_rtx (Pmode);
	      if (TARGET_64BIT)
		insn = gen_tls_dtprel_ha_64 (tmp2, tmp1, addr);
	      else
		insn = gen_tls_dtprel_ha_32 (tmp2, tmp1, addr);
	      emit_insn (insn);
	      if (TARGET_64BIT)
		insn = gen_tls_dtprel_lo_64 (dest, tmp2, addr);
	      else
		insn = gen_tls_dtprel_lo_32 (dest, tmp2, addr);
	    }
	  else
	    {
	      tmp2 = gen_reg_rtx (Pmode);
	      if (TARGET_64BIT)
		insn = gen_tls_got_dtprel_64 (tmp2, got, addr);
	      else
		insn = gen_tls_got_dtprel_32 (tmp2, got, addr);
	      emit_insn (insn);
	      insn = gen_rtx_SET (dest, gen_rtx_PLUS (Pmode, tmp2, tmp1));
	    }
	  emit_insn (insn);
	}
      else
	{
	  /* IE, or 64-bit offset LE.  */
	  tmp2 = gen_reg_rtx (Pmode);
	  if (TARGET_64BIT)
	    insn = gen_tls_got_tprel_64 (tmp2, got, addr);
	  else
	    insn = gen_tls_got_tprel_32 (tmp2, got, addr);
	  emit_insn (insn);
	  if (TARGET_64BIT)
	    insn = gen_tls_tls_64 (dest, tmp2, addr);
	  else
	    insn = gen_tls_tls_32 (dest, tmp2, addr);
	  emit_insn (insn);
	}
    }

  return dest;
}

/* Only create the global variable for the stack protect guard if we are using
   the global flavor of that guard.  */
static tree
rs6000_init_stack_protect_guard (void)
{
  if (rs6000_stack_protector_guard == SSP_GLOBAL)
    return default_stack_protect_guard ();

  return NULL_TREE;
}

/* Implement TARGET_CANNOT_FORCE_CONST_MEM.  */

static bool
rs6000_cannot_force_const_mem (machine_mode mode ATTRIBUTE_UNUSED, rtx x)
{
  if (GET_CODE (x) == HIGH
      && GET_CODE (XEXP (x, 0)) == UNSPEC)
    return true;

  /* A TLS symbol in the TOC cannot contain a sum.  */
  if (GET_CODE (x) == CONST
      && GET_CODE (XEXP (x, 0)) == PLUS
      && SYMBOL_REF_P (XEXP (XEXP (x, 0), 0))
      && SYMBOL_REF_TLS_MODEL (XEXP (XEXP (x, 0), 0)) != 0)
    return true;

  /* Do not place an ELF TLS symbol in the constant pool.  */
  return TARGET_ELF && tls_referenced_p (x);
}

/* Return true iff the given SYMBOL_REF refers to a constant pool entry
   that we have put in the TOC, or for cmodel=medium, if the SYMBOL_REF
   can be addressed relative to the toc pointer.  */

static bool
use_toc_relative_ref (rtx sym, machine_mode mode)
{
  return ((constant_pool_expr_p (sym)
	   && ASM_OUTPUT_SPECIAL_POOL_ENTRY_P (get_pool_constant (sym),
					       get_pool_mode (sym)))
	  || (TARGET_CMODEL == CMODEL_MEDIUM
	      && SYMBOL_REF_LOCAL_P (sym)
	      && GET_MODE_SIZE (mode) <= POWERPC64_TOC_POINTER_ALIGNMENT));
}

/* TARGET_LEGITIMATE_ADDRESS_P recognizes an RTL expression
   that is a valid memory address for an instruction.
   The MODE argument is the machine mode for the MEM expression
   that wants to use this address.

   On the RS/6000, there are four valid address: a SYMBOL_REF that
   refers to a constant pool entry of an address (or the sum of it
   plus a constant), a short (16-bit signed) constant plus a register,
   the sum of two registers, or a register indirect, possibly with an
   auto-increment.  For DFmode, DDmode and DImode with a constant plus
   register, we must ensure that both words are addressable or PowerPC64
   with offset word aligned.

   For modes spanning multiple registers (DFmode and DDmode in 32-bit GPRs,
   32-bit DImode, TImode, TFmode, TDmode), indexed addressing cannot be used
   because adjacent memory cells are accessed by adding word-sized offsets
   during assembly output.  */
static bool
rs6000_legitimate_address_p (machine_mode mode, rtx x, bool reg_ok_strict)
{
  bool reg_offset_p = reg_offset_addressing_ok_p (mode);
  bool quad_offset_p = mode_supports_dq_form (mode);

  /* If this is an unaligned stvx/ldvx type address, discard the outer AND.  */
  if (VECTOR_MEM_ALTIVEC_P (mode)
      && GET_CODE (x) == AND
      && CONST_INT_P (XEXP (x, 1))
      && INTVAL (XEXP (x, 1)) == -16)
    x = XEXP (x, 0);

  if (TARGET_ELF && RS6000_SYMBOL_REF_TLS_P (x))
    return 0;
  if (legitimate_indirect_address_p (x, reg_ok_strict))
    return 1;
  if (TARGET_UPDATE
      && (GET_CODE (x) == PRE_INC || GET_CODE (x) == PRE_DEC)
      && mode_supports_pre_incdec_p (mode)
      && legitimate_indirect_address_p (XEXP (x, 0), reg_ok_strict))
    return 1;
  /* Handle restricted vector d-form offsets in ISA 3.0.  */
  if (quad_offset_p)
    {
      if (quad_address_p (x, mode, reg_ok_strict))
	return 1;
    }
  else if (virtual_stack_registers_memory_p (x))
    return 1;

  else if (reg_offset_p)
    {
      if (legitimate_small_data_p (mode, x))
	return 1;
      if (legitimate_constant_pool_address_p (x, mode,
					     reg_ok_strict || lra_in_progress))
	return 1;
    }

  /* For TImode, if we have TImode in VSX registers, only allow register
     indirect addresses.  This will allow the values to go in either GPRs
     or VSX registers without reloading.  The vector types would tend to
     go into VSX registers, so we allow REG+REG, while TImode seems
     somewhat split, in that some uses are GPR based, and some VSX based.  */
  /* FIXME: We could loosen this by changing the following to
       if (mode == TImode && TARGET_QUAD_MEMORY && TARGET_VSX)
     but currently we cannot allow REG+REG addressing for TImode.  See
     PR72827 for complete details on how this ends up hoodwinking DSE.  */
  if (mode == TImode && TARGET_VSX)
    return 0;
  /* If not REG_OK_STRICT (before reload) let pass any stack offset.  */
  if (! reg_ok_strict
      && reg_offset_p
      && GET_CODE (x) == PLUS
      && REG_P (XEXP (x, 0))
      && (XEXP (x, 0) == virtual_stack_vars_rtx
	  || XEXP (x, 0) == arg_pointer_rtx)
      && CONST_INT_P (XEXP (x, 1)))
    return 1;
  if (rs6000_legitimate_offset_address_p (mode, x, reg_ok_strict, false))
    return 1;
  if (!FLOAT128_2REG_P (mode)
      && (TARGET_HARD_FLOAT
	  || TARGET_POWERPC64
	  || (mode != DFmode && mode != DDmode))
      && (TARGET_POWERPC64 || mode != DImode)
      && (mode != TImode || VECTOR_MEM_VSX_P (TImode))
      && mode != PTImode
      && !avoiding_indexed_address_p (mode)
      && legitimate_indexed_address_p (x, reg_ok_strict))
    return 1;
  if (TARGET_UPDATE && GET_CODE (x) == PRE_MODIFY
      && mode_supports_pre_modify_p (mode)
      && legitimate_indirect_address_p (XEXP (x, 0), reg_ok_strict)
      && (rs6000_legitimate_offset_address_p (mode, XEXP (x, 1),
					      reg_ok_strict, false)
	  || (!avoiding_indexed_address_p (mode)
	      && legitimate_indexed_address_p (XEXP (x, 1), reg_ok_strict)))
      && rtx_equal_p (XEXP (XEXP (x, 1), 0), XEXP (x, 0)))
    return 1;
  if (reg_offset_p && !quad_offset_p
      && legitimate_lo_sum_address_p (mode, x, reg_ok_strict))
    return 1;
  return 0;
}

/* Debug version of rs6000_legitimate_address_p.  */
static bool
rs6000_debug_legitimate_address_p (machine_mode mode, rtx x,
				   bool reg_ok_strict)
{
  bool ret = rs6000_legitimate_address_p (mode, x, reg_ok_strict);
  fprintf (stderr,
	   "\nrs6000_legitimate_address_p: return = %s, mode = %s, "
	   "strict = %d, reload = %s, code = %s\n",
	   ret ? "true" : "false",
	   GET_MODE_NAME (mode),
	   reg_ok_strict,
	   (reload_completed ? "after" : "before"),
	   GET_RTX_NAME (GET_CODE (x)));
  debug_rtx (x);

  return ret;
}

/* Implement TARGET_MODE_DEPENDENT_ADDRESS_P.  */

static bool
rs6000_mode_dependent_address_p (const_rtx addr,
				 addr_space_t as ATTRIBUTE_UNUSED)
{
  return rs6000_mode_dependent_address_ptr (addr);
}

/* Go to LABEL if ADDR (a legitimate address expression)
   has an effect that depends on the machine mode it is used for.

   On the RS/6000 this is true of all integral offsets (since AltiVec
   and VSX modes don't allow them) or is a pre-increment or decrement.

   ??? Except that due to conceptual problems in offsettable_address_p
   we can't really report the problems of integral offsets.  So leave
   this assuming that the adjustable offset must be valid for the
   sub-words of a TFmode operand, which is what we had before.  */

static bool
rs6000_mode_dependent_address (const_rtx addr)
{
  switch (GET_CODE (addr))
    {
    case PLUS:
      /* Any offset from virtual_stack_vars_rtx and arg_pointer_rtx
	 is considered a legitimate address before reload, so there
	 are no offset restrictions in that case.  Note that this
	 condition is safe in strict mode because any address involving
	 virtual_stack_vars_rtx or arg_pointer_rtx would already have
	 been rejected as illegitimate.  */
      if (XEXP (addr, 0) != virtual_stack_vars_rtx
	  && XEXP (addr, 0) != arg_pointer_rtx
	  && CONST_INT_P (XEXP (addr, 1)))
	{
	  unsigned HOST_WIDE_INT val = INTVAL (XEXP (addr, 1));
	  return val + 0x8000 >= 0x10000 - (TARGET_POWERPC64 ? 8 : 12);
	}
      break;

    case LO_SUM:
      /* Anything in the constant pool is sufficiently aligned that
	 all bytes have the same high part address.  */
      return !legitimate_constant_pool_address_p (addr, QImode, false);

    /* Auto-increment cases are now treated generically in recog.c.  */
    case PRE_MODIFY:
      return TARGET_UPDATE;

    /* AND is only allowed in Altivec loads.  */
    case AND:
      return true;

    default:
      break;
    }

  return false;
}

/* Debug version of rs6000_mode_dependent_address.  */
static bool
rs6000_debug_mode_dependent_address (const_rtx addr)
{
  bool ret = rs6000_mode_dependent_address (addr);

  fprintf (stderr, "\nrs6000_mode_dependent_address: ret = %s\n",
	   ret ? "true" : "false");
  debug_rtx (addr);

  return ret;
}

/* Implement FIND_BASE_TERM.  */

rtx
rs6000_find_base_term (rtx op)
{
  rtx base;

  base = op;
  if (GET_CODE (base) == CONST)
    base = XEXP (base, 0);
  if (GET_CODE (base) == PLUS)
    base = XEXP (base, 0);
  if (GET_CODE (base) == UNSPEC)
    switch (XINT (base, 1))
      {
      case UNSPEC_TOCREL:
      case UNSPEC_MACHOPIC_OFFSET:
	/* OP represents SYM [+ OFFSET] - ANCHOR.  SYM is the base term
	   for aliasing purposes.  */
	return XVECEXP (base, 0, 0);
      }

  return op;
}

/* More elaborate version of recog's offsettable_memref_p predicate
   that works around the ??? note of rs6000_mode_dependent_address.
   In particular it accepts

     (mem:DI (plus:SI (reg/f:SI 31 31) (const_int 32760 [0x7ff8])))

   in 32-bit mode, that the recog predicate rejects.  */

static bool
rs6000_offsettable_memref_p (rtx op, machine_mode reg_mode, bool strict)
{
  bool worst_case;

  if (!MEM_P (op))
    return false;

  /* First mimic offsettable_memref_p.  */
  if (offsettable_address_p (strict, GET_MODE (op), XEXP (op, 0)))
    return true;

  /* offsettable_address_p invokes rs6000_mode_dependent_address, but
     the latter predicate knows nothing about the mode of the memory
     reference and, therefore, assumes that it is the largest supported
     mode (TFmode).  As a consequence, legitimate offsettable memory
     references are rejected.  rs6000_legitimate_offset_address_p contains
     the correct logic for the PLUS case of rs6000_mode_dependent_address,
     at least with a little bit of help here given that we know the
     actual registers used.  */
  worst_case = ((TARGET_POWERPC64 && GET_MODE_CLASS (reg_mode) == MODE_INT)
		|| GET_MODE_SIZE (reg_mode) == 4);
  return rs6000_legitimate_offset_address_p (GET_MODE (op), XEXP (op, 0),
					     strict, worst_case);
}

/* Determine the reassociation width to be used in reassociate_bb.
   This takes into account how many parallel operations we
   can actually do of a given type, and also the latency.
   P8:
     int add/sub 6/cycle     
         mul 2/cycle
     vect add/sub/mul 2/cycle
     fp   add/sub/mul 2/cycle
     dfp  1/cycle
*/
 
static int
rs6000_reassociation_width (unsigned int opc ATTRIBUTE_UNUSED,
                            machine_mode mode)
{
  switch (rs6000_tune)
    {
    case PROCESSOR_POWER8:
    case PROCESSOR_POWER9:
    case PROCESSOR_FUTURE:
      if (DECIMAL_FLOAT_MODE_P (mode))
	return 1;
      if (VECTOR_MODE_P (mode))
	return 4;
      if (INTEGRAL_MODE_P (mode)) 
	return 1;
      if (FLOAT_MODE_P (mode))
	return 4;
      break;
    default:
      break;
    }
  return 1;
}

/* Change register usage conditional on target flags.  */
static void
rs6000_conditional_register_usage (void)
{
  int i;

  if (TARGET_DEBUG_TARGET)
    fprintf (stderr, "rs6000_conditional_register_usage called\n");

  /* 64-bit AIX and Linux reserve GPR13 for thread-private data.  */
  if (TARGET_64BIT)
    fixed_regs[13] = call_used_regs[13]
      = call_really_used_regs[13] = 1;

  /* Conditionally disable FPRs.  */
  if (TARGET_SOFT_FLOAT)
    for (i = 32; i < 64; i++)
      fixed_regs[i] = call_used_regs[i]
	= call_really_used_regs[i] = 1;

  /* The TOC register is not killed across calls in a way that is
     visible to the compiler.  */
  if (DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2)
    call_really_used_regs[2] = 0;

  if (DEFAULT_ABI == ABI_V4 && flag_pic == 2)
    fixed_regs[RS6000_PIC_OFFSET_TABLE_REGNUM] = 1;

  if (DEFAULT_ABI == ABI_V4 && flag_pic == 1)
    fixed_regs[RS6000_PIC_OFFSET_TABLE_REGNUM]
      = call_used_regs[RS6000_PIC_OFFSET_TABLE_REGNUM]
      = call_really_used_regs[RS6000_PIC_OFFSET_TABLE_REGNUM] = 1;

  if (DEFAULT_ABI == ABI_DARWIN && flag_pic)
    fixed_regs[RS6000_PIC_OFFSET_TABLE_REGNUM]
      = call_used_regs[RS6000_PIC_OFFSET_TABLE_REGNUM]
      = call_really_used_regs[RS6000_PIC_OFFSET_TABLE_REGNUM] = 1;

  if (TARGET_TOC && TARGET_MINIMAL_TOC)
    fixed_regs[RS6000_PIC_OFFSET_TABLE_REGNUM]
      = call_used_regs[RS6000_PIC_OFFSET_TABLE_REGNUM] = 1;

  if (!TARGET_ALTIVEC && !TARGET_VSX)
    {
      for (i = FIRST_ALTIVEC_REGNO; i <= LAST_ALTIVEC_REGNO; ++i)
	fixed_regs[i] = call_used_regs[i] = call_really_used_regs[i] = 1;
      call_really_used_regs[VRSAVE_REGNO] = 1;
    }

  if (TARGET_ALTIVEC || TARGET_VSX)
    global_regs[VSCR_REGNO] = 1;

  if (TARGET_ALTIVEC_ABI)
    {
      for (i = FIRST_ALTIVEC_REGNO; i < FIRST_ALTIVEC_REGNO + 20; ++i)
	call_used_regs[i] = call_really_used_regs[i] = 1;

      /* AIX reserves VR20:31 in non-extended ABI mode.  */
      if (TARGET_XCOFF)
	for (i = FIRST_ALTIVEC_REGNO + 20; i < FIRST_ALTIVEC_REGNO + 32; ++i)
	  fixed_regs[i] = call_used_regs[i] = call_really_used_regs[i] = 1;
    }
}


/* Output insns to set DEST equal to the constant SOURCE as a series of
   lis, ori and shl instructions and return TRUE.  */

bool
rs6000_emit_set_const (rtx dest, rtx source)
{
  machine_mode mode = GET_MODE (dest);
  rtx temp, set;
  rtx_insn *insn;
  HOST_WIDE_INT c;

  gcc_checking_assert (CONST_INT_P (source));
  c = INTVAL (source);
  switch (mode)
    {
    case E_QImode:
    case E_HImode:
      emit_insn (gen_rtx_SET (dest, source));
      return true;

    case E_SImode:
      temp = !can_create_pseudo_p () ? dest : gen_reg_rtx (SImode);

      emit_insn (gen_rtx_SET (copy_rtx (temp),
			      GEN_INT (c & ~(HOST_WIDE_INT) 0xffff)));
      emit_insn (gen_rtx_SET (dest,
			      gen_rtx_IOR (SImode, copy_rtx (temp),
					   GEN_INT (c & 0xffff))));
      break;

    case E_DImode:
      if (!TARGET_POWERPC64)
	{
	  rtx hi, lo;

	  hi = operand_subword_force (copy_rtx (dest), WORDS_BIG_ENDIAN == 0,
				      DImode);
	  lo = operand_subword_force (dest, WORDS_BIG_ENDIAN != 0,
				      DImode);
	  emit_move_insn (hi, GEN_INT (c >> 32));
	  c = ((c & 0xffffffff) ^ 0x80000000) - 0x80000000;
	  emit_move_insn (lo, GEN_INT (c));
	}
      else
	rs6000_emit_set_long_const (dest, c);
      break;

    default:
      gcc_unreachable ();
    }

  insn = get_last_insn ();
  set = single_set (insn);
  if (! CONSTANT_P (SET_SRC (set)))
    set_unique_reg_note (insn, REG_EQUAL, GEN_INT (c));

  return true;
}

/* Subroutine of rs6000_emit_set_const, handling PowerPC64 DImode.
   Output insns to set DEST equal to the constant C as a series of
   lis, ori and shl instructions.  */

static void
rs6000_emit_set_long_const (rtx dest, HOST_WIDE_INT c)
{
  rtx temp;
  HOST_WIDE_INT ud1, ud2, ud3, ud4;

  ud1 = c & 0xffff;
  c = c >> 16;
  ud2 = c & 0xffff;
  c = c >> 16;
  ud3 = c & 0xffff;
  c = c >> 16;
  ud4 = c & 0xffff;

  if ((ud4 == 0xffff && ud3 == 0xffff && ud2 == 0xffff && (ud1 & 0x8000))
      || (ud4 == 0 && ud3 == 0 && ud2 == 0 && ! (ud1 & 0x8000)))
    emit_move_insn (dest, GEN_INT ((ud1 ^ 0x8000) - 0x8000));

  else if ((ud4 == 0xffff && ud3 == 0xffff && (ud2 & 0x8000))
	   || (ud4 == 0 && ud3 == 0 && ! (ud2 & 0x8000)))
    {
      temp = !can_create_pseudo_p () ? dest : gen_reg_rtx (DImode);

      emit_move_insn (ud1 != 0 ? copy_rtx (temp) : dest,
		      GEN_INT (((ud2 << 16) ^ 0x80000000) - 0x80000000));
      if (ud1 != 0)
	emit_move_insn (dest,
			gen_rtx_IOR (DImode, copy_rtx (temp),
				     GEN_INT (ud1)));
    }
  else if (ud3 == 0 && ud4 == 0)
    {
      temp = !can_create_pseudo_p () ? dest : gen_reg_rtx (DImode);

      gcc_assert (ud2 & 0x8000);
      emit_move_insn (copy_rtx (temp),
		      GEN_INT (((ud2 << 16) ^ 0x80000000) - 0x80000000));
      if (ud1 != 0)
	emit_move_insn (copy_rtx (temp),
			gen_rtx_IOR (DImode, copy_rtx (temp),
				     GEN_INT (ud1)));
      emit_move_insn (dest,
		      gen_rtx_ZERO_EXTEND (DImode,
					   gen_lowpart (SImode,
							copy_rtx (temp))));
    }
  else if ((ud4 == 0xffff && (ud3 & 0x8000))
	   || (ud4 == 0 && ! (ud3 & 0x8000)))
    {
      temp = !can_create_pseudo_p () ? dest : gen_reg_rtx (DImode);

      emit_move_insn (copy_rtx (temp),
		      GEN_INT (((ud3 << 16) ^ 0x80000000) - 0x80000000));
      if (ud2 != 0)
	emit_move_insn (copy_rtx (temp),
			gen_rtx_IOR (DImode, copy_rtx (temp),
				     GEN_INT (ud2)));
      emit_move_insn (ud1 != 0 ? copy_rtx (temp) : dest,
		      gen_rtx_ASHIFT (DImode, copy_rtx (temp),
				      GEN_INT (16)));
      if (ud1 != 0)
	emit_move_insn (dest,
			gen_rtx_IOR (DImode, copy_rtx (temp),
				     GEN_INT (ud1)));
    }
  else
    {
      temp = !can_create_pseudo_p () ? dest : gen_reg_rtx (DImode);

      emit_move_insn (copy_rtx (temp),
		      GEN_INT (((ud4 << 16) ^ 0x80000000) - 0x80000000));
      if (ud3 != 0)
	emit_move_insn (copy_rtx (temp),
			gen_rtx_IOR (DImode, copy_rtx (temp),
				     GEN_INT (ud3)));

      emit_move_insn (ud2 != 0 || ud1 != 0 ? copy_rtx (temp) : dest,
		      gen_rtx_ASHIFT (DImode, copy_rtx (temp),
				      GEN_INT (32)));
      if (ud2 != 0)
	emit_move_insn (ud1 != 0 ? copy_rtx (temp) : dest,
			gen_rtx_IOR (DImode, copy_rtx (temp),
				     GEN_INT (ud2 << 16)));
      if (ud1 != 0)
	emit_move_insn (dest,
			gen_rtx_IOR (DImode, copy_rtx (temp),
				     GEN_INT (ud1)));
    }
}

/* Helper for the following.  Get rid of [r+r] memory refs
   in cases where it won't work (TImode, TFmode, TDmode, PTImode).  */

static void
rs6000_eliminate_indexed_memrefs (rtx operands[2])
{
  if (MEM_P (operands[0])
      && !REG_P (XEXP (operands[0], 0))
      && ! legitimate_constant_pool_address_p (XEXP (operands[0], 0),
					       GET_MODE (operands[0]), false))
    operands[0]
      = replace_equiv_address (operands[0],
			       copy_addr_to_reg (XEXP (operands[0], 0)));

  if (MEM_P (operands[1])
      && !REG_P (XEXP (operands[1], 0))
      && ! legitimate_constant_pool_address_p (XEXP (operands[1], 0),
					       GET_MODE (operands[1]), false))
    operands[1]
      = replace_equiv_address (operands[1],
			       copy_addr_to_reg (XEXP (operands[1], 0)));
}

/* Generate a vector of constants to permute MODE for a little-endian
   storage operation by swapping the two halves of a vector.  */
static rtvec
rs6000_const_vec (machine_mode mode)
{
  int i, subparts;
  rtvec v;

  switch (mode)
    {
    case E_V1TImode:
      subparts = 1;
      break;
    case E_V2DFmode:
    case E_V2DImode:
      subparts = 2;
      break;
    case E_V4SFmode:
    case E_V4SImode:
      subparts = 4;
      break;
    case E_V8HImode:
      subparts = 8;
      break;
    case E_V16QImode:
      subparts = 16;
      break;
    default:
      gcc_unreachable();
    }

  v = rtvec_alloc (subparts);

  for (i = 0; i < subparts / 2; ++i)
    RTVEC_ELT (v, i) = gen_rtx_CONST_INT (DImode, i + subparts / 2);
  for (i = subparts / 2; i < subparts; ++i)
    RTVEC_ELT (v, i) = gen_rtx_CONST_INT (DImode, i - subparts / 2);

  return v;
}

/* Emit an lxvd2x, stxvd2x, or xxpermdi instruction for a VSX load or
   store operation.  */
void
rs6000_emit_le_vsx_permute (rtx dest, rtx source, machine_mode mode)
{
  /* Scalar permutations are easier to express in integer modes rather than
     floating-point modes, so cast them here.  We use V1TImode instead
     of TImode to ensure that the values don't go through GPRs.  */
  if (FLOAT128_VECTOR_P (mode))
    {
      dest = gen_lowpart (V1TImode, dest);
      source = gen_lowpart (V1TImode, source);
      mode = V1TImode;
    }

  /* Use ROTATE instead of VEC_SELECT if the mode contains only a single
     scalar.  */
  if (mode == TImode || mode == V1TImode)
    emit_insn (gen_rtx_SET (dest, gen_rtx_ROTATE (mode, source,
						  GEN_INT (64))));
  else
    {
      rtx par = gen_rtx_PARALLEL (VOIDmode, rs6000_const_vec (mode));
      emit_insn (gen_rtx_SET (dest, gen_rtx_VEC_SELECT (mode, source, par)));
    }
}

/* Emit a little-endian load from vector memory location SOURCE to VSX
   register DEST in mode MODE.  The load is done with two permuting
   insn's that represent an lxvd2x and xxpermdi.  */
void
rs6000_emit_le_vsx_load (rtx dest, rtx source, machine_mode mode)
{
  /* Use V2DImode to do swaps of types with 128-bit scalare parts (TImode,
     V1TImode).  */
  if (mode == TImode || mode == V1TImode)
    {
      mode = V2DImode;
      dest = gen_lowpart (V2DImode, dest);
      source = adjust_address (source, V2DImode, 0);
    }

  rtx tmp = can_create_pseudo_p () ? gen_reg_rtx_and_attrs (dest) : dest;
  rs6000_emit_le_vsx_permute (tmp, source, mode);
  rs6000_emit_le_vsx_permute (dest, tmp, mode);
}

/* Emit a little-endian store to vector memory location DEST from VSX
   register SOURCE in mode MODE.  The store is done with two permuting
   insn's that represent an xxpermdi and an stxvd2x.  */
void
rs6000_emit_le_vsx_store (rtx dest, rtx source, machine_mode mode)
{
  /* This should never be called during or after LRA, because it does
     not re-permute the source register.  It is intended only for use
     during expand.  */
  gcc_assert (!lra_in_progress && !reload_completed);

  /* Use V2DImode to do swaps of types with 128-bit scalar parts (TImode,
     V1TImode).  */
  if (mode == TImode || mode == V1TImode)
    {
      mode = V2DImode;
      dest = adjust_address (dest, V2DImode, 0);
      source = gen_lowpart (V2DImode, source);
    }

  rtx tmp = can_create_pseudo_p () ? gen_reg_rtx_and_attrs (source) : source;
  rs6000_emit_le_vsx_permute (tmp, source, mode);
  rs6000_emit_le_vsx_permute (dest, tmp, mode);
}

/* Emit a sequence representing a little-endian VSX load or store,
   moving data from SOURCE to DEST in mode MODE.  This is done
   separately from rs6000_emit_move to ensure it is called only
   during expand.  LE VSX loads and stores introduced later are
   handled with a split.  The expand-time RTL generation allows
   us to optimize away redundant pairs of register-permutes.  */
void
rs6000_emit_le_vsx_move (rtx dest, rtx source, machine_mode mode)
{
  gcc_assert (!BYTES_BIG_ENDIAN
	      && VECTOR_MEM_VSX_P (mode)
	      && !TARGET_P9_VECTOR
	      && !gpr_or_gpr_p (dest, source)
	      && (MEM_P (source) ^ MEM_P (dest)));

  if (MEM_P (source))
    {
      gcc_assert (REG_P (dest) || SUBREG_P (dest));
      rs6000_emit_le_vsx_load (dest, source, mode);
    }
  else
    {
      if (!REG_P (source))
	source = force_reg (mode, source);
      rs6000_emit_le_vsx_store (dest, source, mode);
    }
}

/* Return whether a SFmode or SImode move can be done without converting one
   mode to another.  This arrises when we have:

	(SUBREG:SF (REG:SI ...))
	(SUBREG:SI (REG:SF ...))

   and one of the values is in a floating point/vector register, where SFmode
   scalars are stored in DFmode format.  */

bool
valid_sf_si_move (rtx dest, rtx src, machine_mode mode)
{
  if (TARGET_ALLOW_SF_SUBREG)
    return true;

  if (mode != SFmode && GET_MODE_CLASS (mode) != MODE_INT)
    return true;

  if (!SUBREG_P (src) || !sf_subreg_operand (src, mode))
    return true;

  /*.  Allow (set (SUBREG:SI (REG:SF)) (SUBREG:SI (REG:SF))).  */
  if (SUBREG_P (dest))
    {
      rtx dest_subreg = SUBREG_REG (dest);
      rtx src_subreg = SUBREG_REG (src);
      return GET_MODE (dest_subreg) == GET_MODE (src_subreg);
    }

  return false;
}


/* Helper function to change moves with:

	(SUBREG:SF (REG:SI)) and
	(SUBREG:SI (REG:SF))

   into separate UNSPEC insns.  In the PowerPC architecture, scalar SFmode
   values are stored as DFmode values in the VSX registers.  We need to convert
   the bits before we can use a direct move or operate on the bits in the
   vector register as an integer type.

   Skip things like (set (SUBREG:SI (...) (SUBREG:SI (...)).  */

static bool
rs6000_emit_move_si_sf_subreg (rtx dest, rtx source, machine_mode mode)
{
  if (TARGET_DIRECT_MOVE_64BIT && !reload_completed
      && (!SUBREG_P (dest) || !sf_subreg_operand (dest, mode))
      && SUBREG_P (source) && sf_subreg_operand (source, mode))
    {
      rtx inner_source = SUBREG_REG (source);
      machine_mode inner_mode = GET_MODE (inner_source);

      if (mode == SImode && inner_mode == SFmode)
	{
	  emit_insn (gen_movsi_from_sf (dest, inner_source));
	  return true;
	}

      if (mode == SFmode && inner_mode == SImode)
	{
	  emit_insn (gen_movsf_from_si (dest, inner_source));
	  return true;
	}
    }

  return false;
}

/* Emit a move from SOURCE to DEST in mode MODE.  */
void
rs6000_emit_move (rtx dest, rtx source, machine_mode mode)
{
  rtx operands[2];
  operands[0] = dest;
  operands[1] = source;

  if (TARGET_DEBUG_ADDR)
    {
      fprintf (stderr,
	       "\nrs6000_emit_move: mode = %s, lra_in_progress = %d, "
	       "reload_completed = %d, can_create_pseudos = %d.\ndest:\n",
	       GET_MODE_NAME (mode),
	       lra_in_progress,
	       reload_completed,
	       can_create_pseudo_p ());
      debug_rtx (dest);
      fprintf (stderr, "source:\n");
      debug_rtx (source);
    }

  /* Check that we get CONST_WIDE_INT only when we should.  */
  if (CONST_WIDE_INT_P (operands[1])
      && GET_MODE_BITSIZE (mode) <= HOST_BITS_PER_WIDE_INT)
    gcc_unreachable ();

#ifdef HAVE_AS_GNU_ATTRIBUTE
  /* If we use a long double type, set the flags in .gnu_attribute that say
     what the long double type is.  This is to allow the linker's warning
     message for the wrong long double to be useful, even if the function does
     not do a call (for example, doing a 128-bit add on power9 if the long
     double type is IEEE 128-bit.  Do not set this if __ibm128 or __floa128 are
     used if they aren't the default long dobule type.  */
  if (rs6000_gnu_attr && (HAVE_LD_PPC_GNU_ATTR_LONG_DOUBLE || TARGET_64BIT))
    {
      if (TARGET_LONG_DOUBLE_128 && (mode == TFmode || mode == TCmode))
	rs6000_passes_float = rs6000_passes_long_double = true;

      else if (!TARGET_LONG_DOUBLE_128 && (mode == DFmode || mode == DCmode))
	rs6000_passes_float = rs6000_passes_long_double = true;
    }
#endif

  /* See if we need to special case SImode/SFmode SUBREG moves.  */
  if ((mode == SImode || mode == SFmode) && SUBREG_P (source)
      && rs6000_emit_move_si_sf_subreg (dest, source, mode))
    return;

  /* Check if GCC is setting up a block move that will end up using FP
     registers as temporaries.  We must make sure this is acceptable.  */
  if (MEM_P (operands[0])
      && MEM_P (operands[1])
      && mode == DImode
      && (rs6000_slow_unaligned_access (DImode, MEM_ALIGN (operands[0]))
	  || rs6000_slow_unaligned_access (DImode, MEM_ALIGN (operands[1])))
      && ! (rs6000_slow_unaligned_access (SImode,
					  (MEM_ALIGN (operands[0]) > 32
					   ? 32 : MEM_ALIGN (operands[0])))
	    || rs6000_slow_unaligned_access (SImode,
					     (MEM_ALIGN (operands[1]) > 32
					      ? 32 : MEM_ALIGN (operands[1]))))
      && ! MEM_VOLATILE_P (operands [0])
      && ! MEM_VOLATILE_P (operands [1]))
    {
      emit_move_insn (adjust_address (operands[0], SImode, 0),
		      adjust_address (operands[1], SImode, 0));
      emit_move_insn (adjust_address (copy_rtx (operands[0]), SImode, 4),
		      adjust_address (copy_rtx (operands[1]), SImode, 4));
      return;
    }

  if (can_create_pseudo_p () && MEM_P (operands[0])
      && !gpc_reg_operand (operands[1], mode))
    operands[1] = force_reg (mode, operands[1]);

  /* Recognize the case where operand[1] is a reference to thread-local
     data and load its address to a register.  */
  if (tls_referenced_p (operands[1]))
    {
      enum tls_model model;
      rtx tmp = operands[1];
      rtx addend = NULL;

      if (GET_CODE (tmp) == CONST && GET_CODE (XEXP (tmp, 0)) == PLUS)
	{
          addend = XEXP (XEXP (tmp, 0), 1);
	  tmp = XEXP (XEXP (tmp, 0), 0);
	}

      gcc_assert (SYMBOL_REF_P (tmp));
      model = SYMBOL_REF_TLS_MODEL (tmp);
      gcc_assert (model != 0);

      tmp = rs6000_legitimize_tls_address (tmp, model);
      if (addend)
	{
	  tmp = gen_rtx_PLUS (mode, tmp, addend);
	  tmp = force_operand (tmp, operands[0]);
	}
      operands[1] = tmp;
    }

  /* 128-bit constant floating-point values on Darwin should really be loaded
     as two parts.  However, this premature splitting is a problem when DFmode
     values can go into Altivec registers.  */
  if (TARGET_MACHO && CONST_DOUBLE_P (operands[1]) && FLOAT128_IBM_P (mode)
      && !reg_addr[DFmode].scalar_in_vmx_p)
    {
      rs6000_emit_move (simplify_gen_subreg (DFmode, operands[0], mode, 0),
			simplify_gen_subreg (DFmode, operands[1], mode, 0),
			DFmode);
      rs6000_emit_move (simplify_gen_subreg (DFmode, operands[0], mode,
					     GET_MODE_SIZE (DFmode)),
			simplify_gen_subreg (DFmode, operands[1], mode,
					     GET_MODE_SIZE (DFmode)),
			DFmode);
      return;
    }

  /* Transform (p0:DD, (SUBREG:DD p1:SD)) to ((SUBREG:SD p0:DD),
     p1:SD) if p1 is not of floating point class and p0 is spilled as
     we can have no analogous movsd_store for this.  */
  if (lra_in_progress && mode == DDmode
      && REG_P (operands[0]) && !HARD_REGISTER_P (operands[0])
      && reg_preferred_class (REGNO (operands[0])) == NO_REGS
      && SUBREG_P (operands[1]) && REG_P (SUBREG_REG (operands[1]))
      && GET_MODE (SUBREG_REG (operands[1])) == SDmode)
    {
      enum reg_class cl;
      int regno = REGNO (SUBREG_REG (operands[1]));

      if (!HARD_REGISTER_NUM_P (regno))
	{
	  cl = reg_preferred_class (regno);
	  regno = reg_renumber[regno];
	  if (regno < 0)
	    regno = cl == NO_REGS ? -1 : ira_class_hard_regs[cl][1];
	}
      if (regno >= 0 && ! FP_REGNO_P (regno))
	{
	  mode = SDmode;
	  operands[0] = gen_lowpart_SUBREG (SDmode, operands[0]);
	  operands[1] = SUBREG_REG (operands[1]);
	}
    }
  if (lra_in_progress
      && mode == SDmode
      && REG_P (operands[0]) && !HARD_REGISTER_P (operands[0])
      && reg_preferred_class (REGNO (operands[0])) == NO_REGS
      && (REG_P (operands[1])
	  || (SUBREG_P (operands[1]) && REG_P (SUBREG_REG (operands[1])))))
    {
      int regno = reg_or_subregno (operands[1]);
      enum reg_class cl;

      if (!HARD_REGISTER_NUM_P (regno))
	{
	  cl = reg_preferred_class (regno);
	  gcc_assert (cl != NO_REGS);
	  regno = reg_renumber[regno];
	  if (regno < 0)
	    regno = ira_class_hard_regs[cl][0];
	}
      if (FP_REGNO_P (regno))
	{
	  if (GET_MODE (operands[0]) != DDmode)
	    operands[0] = gen_rtx_SUBREG (DDmode, operands[0], 0);
	  emit_insn (gen_movsd_store (operands[0], operands[1]));
	}
      else if (INT_REGNO_P (regno))
	emit_insn (gen_movsd_hardfloat (operands[0], operands[1]));
      else
	gcc_unreachable();
      return;
    }
  /* Transform ((SUBREG:DD p0:SD), p1:DD) to (p0:SD, (SUBREG:SD
     p:DD)) if p0 is not of floating point class and p1 is spilled as
     we can have no analogous movsd_load for this.  */
  if (lra_in_progress && mode == DDmode
      && SUBREG_P (operands[0]) && REG_P (SUBREG_REG (operands[0]))
      && GET_MODE (SUBREG_REG (operands[0])) == SDmode
      && REG_P (operands[1]) && !HARD_REGISTER_P (operands[1])
      && reg_preferred_class (REGNO (operands[1])) == NO_REGS)
    {
      enum reg_class cl;
      int regno = REGNO (SUBREG_REG (operands[0]));

      if (!HARD_REGISTER_NUM_P (regno))
	{
	  cl = reg_preferred_class (regno);
	  regno = reg_renumber[regno];
	  if (regno < 0)
	    regno = cl == NO_REGS ? -1 : ira_class_hard_regs[cl][0];
	}
      if (regno >= 0 && ! FP_REGNO_P (regno))
	{
	  mode = SDmode;
	  operands[0] = SUBREG_REG (operands[0]);
	  operands[1] = gen_lowpart_SUBREG (SDmode, operands[1]);
	}
    }
  if (lra_in_progress
      && mode == SDmode
      && (REG_P (operands[0])
	  || (SUBREG_P (operands[0]) && REG_P (SUBREG_REG (operands[0]))))
      && REG_P (operands[1]) && !HARD_REGISTER_P (operands[1])
      && reg_preferred_class (REGNO (operands[1])) == NO_REGS)
    {
      int regno = reg_or_subregno (operands[0]);
      enum reg_class cl;

      if (!HARD_REGISTER_NUM_P (regno))
	{
	  cl = reg_preferred_class (regno);
	  gcc_assert (cl != NO_REGS);
	  regno = reg_renumber[regno];
	  if (regno < 0)
	    regno = ira_class_hard_regs[cl][0];
	}
      if (FP_REGNO_P (regno))
	{
	  if (GET_MODE (operands[1]) != DDmode)
	    operands[1] = gen_rtx_SUBREG (DDmode, operands[1], 0);
	  emit_insn (gen_movsd_load (operands[0], operands[1]));
	}
      else if (INT_REGNO_P (regno))
	emit_insn (gen_movsd_hardfloat (operands[0], operands[1]));
      else
	gcc_unreachable();
      return;
    }

  /* FIXME:  In the long term, this switch statement should go away
     and be replaced by a sequence of tests based on things like
     mode == Pmode.  */
  switch (mode)
    {
    case E_HImode:
    case E_QImode:
      if (CONSTANT_P (operands[1])
	  && !CONST_INT_P (operands[1]))
	operands[1] = force_const_mem (mode, operands[1]);
      break;

    case E_TFmode:
    case E_TDmode:
    case E_IFmode:
    case E_KFmode:
      if (FLOAT128_2REG_P (mode))
	rs6000_eliminate_indexed_memrefs (operands);
      /* fall through */

    case E_DFmode:
    case E_DDmode:
    case E_SFmode:
    case E_SDmode:
      if (CONSTANT_P (operands[1])
	  && ! easy_fp_constant (operands[1], mode))
	operands[1] = force_const_mem (mode, operands[1]);
      break;

    case E_V16QImode:
    case E_V8HImode:
    case E_V4SFmode:
    case E_V4SImode:
    case E_V2DFmode:
    case E_V2DImode:
    case E_V1TImode:
      if (CONSTANT_P (operands[1])
	  && !easy_vector_constant (operands[1], mode))
	operands[1] = force_const_mem (mode, operands[1]);
      break;

    case E_SImode:
    case E_DImode:
      /* Use default pattern for address of ELF small data */
      if (TARGET_ELF
	  && mode == Pmode
	  && DEFAULT_ABI == ABI_V4
	  && (SYMBOL_REF_P (operands[1])
	      || GET_CODE (operands[1]) == CONST)
	  && small_data_operand (operands[1], mode))
	{
	  emit_insn (gen_rtx_SET (operands[0], operands[1]));
	  return;
	}

      if (DEFAULT_ABI == ABI_V4
	  && mode == Pmode && mode == SImode
	  && flag_pic == 1 && got_operand (operands[1], mode))
	{
	  emit_insn (gen_movsi_got (operands[0], operands[1]));
	  return;
	}

      if ((TARGET_ELF || DEFAULT_ABI == ABI_DARWIN)
	  && TARGET_NO_TOC
	  && ! flag_pic
	  && mode == Pmode
	  && CONSTANT_P (operands[1])
	  && GET_CODE (operands[1]) != HIGH
	  && !CONST_INT_P (operands[1]))
	{
	  rtx target = (!can_create_pseudo_p ()
			? operands[0]
			: gen_reg_rtx (mode));

	  /* If this is a function address on -mcall-aixdesc,
	     convert it to the address of the descriptor.  */
	  if (DEFAULT_ABI == ABI_AIX
	      && SYMBOL_REF_P (operands[1])
	      && XSTR (operands[1], 0)[0] == '.')
	    {
	      const char *name = XSTR (operands[1], 0);
	      rtx new_ref;
	      while (*name == '.')
		name++;
	      new_ref = gen_rtx_SYMBOL_REF (Pmode, name);
	      CONSTANT_POOL_ADDRESS_P (new_ref)
		= CONSTANT_POOL_ADDRESS_P (operands[1]);
	      SYMBOL_REF_FLAGS (new_ref) = SYMBOL_REF_FLAGS (operands[1]);
	      SYMBOL_REF_USED (new_ref) = SYMBOL_REF_USED (operands[1]);
	      SYMBOL_REF_DATA (new_ref) = SYMBOL_REF_DATA (operands[1]);
	      operands[1] = new_ref;
	    }

	  if (DEFAULT_ABI == ABI_DARWIN)
	    {
#if TARGET_MACHO
	      if (MACHO_DYNAMIC_NO_PIC_P)
		{
		  /* Take care of any required data indirection.  */
		  operands[1] = rs6000_machopic_legitimize_pic_address (
				  operands[1], mode, operands[0]);
		  if (operands[0] != operands[1])
		    emit_insn (gen_rtx_SET (operands[0], operands[1]));
		  return;
		}
#endif
	      emit_insn (gen_macho_high (target, operands[1]));
	      emit_insn (gen_macho_low (operands[0], target, operands[1]));
	      return;
	    }

	  emit_insn (gen_elf_high (target, operands[1]));
	  emit_insn (gen_elf_low (operands[0], target, operands[1]));
	  return;
	}

      /* If this is a SYMBOL_REF that refers to a constant pool entry,
	 and we have put it in the TOC, we just need to make a TOC-relative
	 reference to it.  */
      if (TARGET_TOC
	  && SYMBOL_REF_P (operands[1])
	  && use_toc_relative_ref (operands[1], mode))
	operands[1] = create_TOC_reference (operands[1], operands[0]);
      else if (mode == Pmode
	       && CONSTANT_P (operands[1])
	       && GET_CODE (operands[1]) != HIGH
	       && ((REG_P (operands[0])
		    && FP_REGNO_P (REGNO (operands[0])))
		   || !CONST_INT_P (operands[1])
		   || (num_insns_constant (operands[1], mode)
		       > (TARGET_CMODEL != CMODEL_SMALL ? 3 : 2)))
	       && !toc_relative_expr_p (operands[1], false, NULL, NULL)
	       && (TARGET_CMODEL == CMODEL_SMALL
		   || can_create_pseudo_p ()
		   || (REG_P (operands[0])
		       && INT_REG_OK_FOR_BASE_P (operands[0], true))))
	{

#if TARGET_MACHO
	  /* Darwin uses a special PIC legitimizer.  */
	  if (DEFAULT_ABI == ABI_DARWIN && MACHOPIC_INDIRECT)
	    {
	      operands[1] =
		rs6000_machopic_legitimize_pic_address (operands[1], mode,
							operands[0]);
	      if (operands[0] != operands[1])
		emit_insn (gen_rtx_SET (operands[0], operands[1]));
	      return;
	    }
#endif

	  /* If we are to limit the number of things we put in the TOC and
	     this is a symbol plus a constant we can add in one insn,
	     just put the symbol in the TOC and add the constant.  */
	  if (GET_CODE (operands[1]) == CONST
	      && TARGET_NO_SUM_IN_TOC
	      && GET_CODE (XEXP (operands[1], 0)) == PLUS
	      && add_operand (XEXP (XEXP (operands[1], 0), 1), mode)
	      && (GET_CODE (XEXP (XEXP (operands[1], 0), 0)) == LABEL_REF
		  || SYMBOL_REF_P (XEXP (XEXP (operands[1], 0), 0)))
	      && ! side_effects_p (operands[0]))
	    {
	      rtx sym =
		force_const_mem (mode, XEXP (XEXP (operands[1], 0), 0));
	      rtx other = XEXP (XEXP (operands[1], 0), 1);

	      sym = force_reg (mode, sym);
	      emit_insn (gen_add3_insn (operands[0], sym, other));
	      return;
	    }

	  operands[1] = force_const_mem (mode, operands[1]);

	  if (TARGET_TOC
	      && SYMBOL_REF_P (XEXP (operands[1], 0))
	      && use_toc_relative_ref (XEXP (operands[1], 0), mode))
	    {
	      rtx tocref = create_TOC_reference (XEXP (operands[1], 0),
						 operands[0]);
	      operands[1] = gen_const_mem (mode, tocref);
	      set_mem_alias_set (operands[1], get_TOC_alias_set ());
	    }
	}
      break;

    case E_TImode:
      if (!VECTOR_MEM_VSX_P (TImode))
	rs6000_eliminate_indexed_memrefs (operands);
      break;

    case E_PTImode:
      rs6000_eliminate_indexed_memrefs (operands);
      break;

    default:
      fatal_insn ("bad move", gen_rtx_SET (dest, source));
    }

  /* Above, we may have called force_const_mem which may have returned
     an invalid address.  If we can, fix this up; otherwise, reload will
     have to deal with it.  */
  if (MEM_P (operands[1]))
    operands[1] = validize_mem (operands[1]);

  emit_insn (gen_rtx_SET (operands[0], operands[1]));
}

/* Nonzero if we can use a floating-point register to pass this arg.  */
#define USE_FP_FOR_ARG_P(CUM,MODE)		\
  (SCALAR_FLOAT_MODE_NOT_VECTOR_P (MODE)		\
   && (CUM)->fregno <= FP_ARG_MAX_REG		\
   && TARGET_HARD_FLOAT)

/* Nonzero if we can use an AltiVec register to pass this arg.  */
#define USE_ALTIVEC_FOR_ARG_P(CUM,MODE,NAMED)			\
  (ALTIVEC_OR_VSX_VECTOR_MODE (MODE)				\
   && (CUM)->vregno <= ALTIVEC_ARG_MAX_REG			\
   && TARGET_ALTIVEC_ABI					\
   && (NAMED))

/* Walk down the type tree of TYPE counting consecutive base elements.
   If *MODEP is VOIDmode, then set it to the first valid floating point
   or vector type.  If a non-floating point or vector type is found, or
   if a floating point or vector type that doesn't match a non-VOIDmode
   *MODEP is found, then return -1, otherwise return the count in the
   sub-tree.  */

static int
rs6000_aggregate_candidate (const_tree type, machine_mode *modep)
{
  machine_mode mode;
  HOST_WIDE_INT size;

  switch (TREE_CODE (type))
    {
    case REAL_TYPE:
      mode = TYPE_MODE (type);
      if (!SCALAR_FLOAT_MODE_P (mode))
	return -1;

      if (*modep == VOIDmode)
	*modep = mode;

      if (*modep == mode)
	return 1;

      break;

    case COMPLEX_TYPE:
      mode = TYPE_MODE (TREE_TYPE (type));
      if (!SCALAR_FLOAT_MODE_P (mode))
	return -1;

      if (*modep == VOIDmode)
	*modep = mode;

      if (*modep == mode)
	return 2;

      break;

    case VECTOR_TYPE:
      if (!TARGET_ALTIVEC_ABI || !TARGET_ALTIVEC)
	return -1;

      /* Use V4SImode as representative of all 128-bit vector types.  */
      size = int_size_in_bytes (type);
      switch (size)
	{
	case 16:
	  mode = V4SImode;
	  break;
	default:
	  return -1;
	}

      if (*modep == VOIDmode)
	*modep = mode;

      /* Vector modes are considered to be opaque: two vectors are
	 equivalent for the purposes of being homogeneous aggregates
	 if they are the same size.  */
      if (*modep == mode)
	return 1;

      break;

    case ARRAY_TYPE:
      {
	int count;
	tree index = TYPE_DOMAIN (type);

	/* Can't handle incomplete types nor sizes that are not
	   fixed.  */
	if (!COMPLETE_TYPE_P (type)
	    || TREE_CODE (TYPE_SIZE (type)) != INTEGER_CST)
	  return -1;

	count = rs6000_aggregate_candidate (TREE_TYPE (type), modep);
	if (count == -1
	    || !index
	    || !TYPE_MAX_VALUE (index)
	    || !tree_fits_uhwi_p (TYPE_MAX_VALUE (index))
	    || !TYPE_MIN_VALUE (index)
	    || !tree_fits_uhwi_p (TYPE_MIN_VALUE (index))
	    || count < 0)
	  return -1;

	count *= (1 + tree_to_uhwi (TYPE_MAX_VALUE (index))
		      - tree_to_uhwi (TYPE_MIN_VALUE (index)));

	/* There must be no padding.  */
	if (wi::to_wide (TYPE_SIZE (type))
	    != count * GET_MODE_BITSIZE (*modep))
	  return -1;

	return count;
      }

    case RECORD_TYPE:
      {
	int count = 0;
	int sub_count;
	tree field;

	/* Can't handle incomplete types nor sizes that are not
	   fixed.  */
	if (!COMPLETE_TYPE_P (type)
	    || TREE_CODE (TYPE_SIZE (type)) != INTEGER_CST)
	  return -1;

	for (field = TYPE_FIELDS (type); field; field = TREE_CHAIN (field))
	  {
	    if (TREE_CODE (field) != FIELD_DECL)
	      continue;

	    sub_count = rs6000_aggregate_candidate (TREE_TYPE (field), modep);
	    if (sub_count < 0)
	      return -1;
	    count += sub_count;
	  }

	/* There must be no padding.  */
	if (wi::to_wide (TYPE_SIZE (type))
	    != count * GET_MODE_BITSIZE (*modep))
	  return -1;

	return count;
      }

    case UNION_TYPE:
    case QUAL_UNION_TYPE:
      {
	/* These aren't very interesting except in a degenerate case.  */
	int count = 0;
	int sub_count;
	tree field;

	/* Can't handle incomplete types nor sizes that are not
	   fixed.  */
	if (!COMPLETE_TYPE_P (type)
	    || TREE_CODE (TYPE_SIZE (type)) != INTEGER_CST)
	  return -1;

	for (field = TYPE_FIELDS (type); field; field = TREE_CHAIN (field))
	  {
	    if (TREE_CODE (field) != FIELD_DECL)
	      continue;

	    sub_count = rs6000_aggregate_candidate (TREE_TYPE (field), modep);
	    if (sub_count < 0)
	      return -1;
	    count = count > sub_count ? count : sub_count;
	  }

	/* There must be no padding.  */
	if (wi::to_wide (TYPE_SIZE (type))
	    != count * GET_MODE_BITSIZE (*modep))
	  return -1;

	return count;
      }

    default:
      break;
    }

  return -1;
}

/* If an argument, whose type is described by TYPE and MODE, is a homogeneous
   float or vector aggregate that shall be passed in FP/vector registers
   according to the ELFv2 ABI, return the homogeneous element mode in
   *ELT_MODE and the number of elements in *N_ELTS, and return TRUE.

   Otherwise, set *ELT_MODE to MODE and *N_ELTS to 1, and return FALSE.  */

static bool
rs6000_discover_homogeneous_aggregate (machine_mode mode, const_tree type,
				       machine_mode *elt_mode,
				       int *n_elts)
{
  /* Note that we do not accept complex types at the top level as
     homogeneous aggregates; these types are handled via the
     targetm.calls.split_complex_arg mechanism.  Complex types
     can be elements of homogeneous aggregates, however.  */
  if (TARGET_HARD_FLOAT && DEFAULT_ABI == ABI_ELFv2 && type
      && AGGREGATE_TYPE_P (type))
    {
      machine_mode field_mode = VOIDmode;
      int field_count = rs6000_aggregate_candidate (type, &field_mode);

      if (field_count > 0)
	{
	  int reg_size = ALTIVEC_OR_VSX_VECTOR_MODE (field_mode) ? 16 : 8;
	  int field_size = ROUND_UP (GET_MODE_SIZE (field_mode), reg_size);

	  /* The ELFv2 ABI allows homogeneous aggregates to occupy
	     up to AGGR_ARG_NUM_REG registers.  */
	  if (field_count * field_size <= AGGR_ARG_NUM_REG * reg_size)
	    {
	      if (elt_mode)
		*elt_mode = field_mode;
	      if (n_elts)
		*n_elts = field_count;
	      return true;
	    }
	}
    }

  if (elt_mode)
    *elt_mode = mode;
  if (n_elts)
    *n_elts = 1;
  return false;
}

/* Return a nonzero value to say to return the function value in
   memory, just as large structures are always returned.  TYPE will be
   the data type of the value, and FNTYPE will be the type of the
   function doing the returning, or @code{NULL} for libcalls.

   The AIX ABI for the RS/6000 specifies that all structures are
   returned in memory.  The Darwin ABI does the same.
   
   For the Darwin 64 Bit ABI, a function result can be returned in
   registers or in memory, depending on the size of the return data
   type.  If it is returned in registers, the value occupies the same
   registers as it would if it were the first and only function
   argument.  Otherwise, the function places its result in memory at
   the location pointed to by GPR3.
   
   The SVR4 ABI specifies that structures <= 8 bytes are returned in r3/r4, 
   but a draft put them in memory, and GCC used to implement the draft
   instead of the final standard.  Therefore, aix_struct_return
   controls this instead of DEFAULT_ABI; V.4 targets needing backward
   compatibility can change DRAFT_V4_STRUCT_RET to override the
   default, and -m switches get the final word.  See
   rs6000_option_override_internal for more details.

   The PPC32 SVR4 ABI uses IEEE double extended for long double, if 128-bit
   long double support is enabled.  These values are returned in memory.

   int_size_in_bytes returns -1 for variable size objects, which go in
   memory always.  The cast to unsigned makes -1 > 8.  */

static bool
rs6000_return_in_memory (const_tree type, const_tree fntype ATTRIBUTE_UNUSED)
{
  /* For the Darwin64 ABI, test if we can fit the return value in regs.  */
  if (TARGET_MACHO
      && rs6000_darwin64_abi
      && TREE_CODE (type) == RECORD_TYPE
      && int_size_in_bytes (type) > 0)
    {
      CUMULATIVE_ARGS valcum;
      rtx valret;

      valcum.words = 0;
      valcum.fregno = FP_ARG_MIN_REG;
      valcum.vregno = ALTIVEC_ARG_MIN_REG;
      /* Do a trial code generation as if this were going to be passed
	 as an argument; if any part goes in memory, we return NULL.  */
      valret = rs6000_darwin64_record_arg (&valcum, type, true, true);
      if (valret)
	return false;
      /* Otherwise fall through to more conventional ABI rules.  */
    }

  /* The ELFv2 ABI returns homogeneous VFP aggregates in registers */
  if (rs6000_discover_homogeneous_aggregate (TYPE_MODE (type), type,
					     NULL, NULL))
    return false;

  /* The ELFv2 ABI returns aggregates up to 16B in registers */
  if (DEFAULT_ABI == ABI_ELFv2 && AGGREGATE_TYPE_P (type)
      && (unsigned HOST_WIDE_INT) int_size_in_bytes (type) <= 16)
    return false;

  if (AGGREGATE_TYPE_P (type)
      && (aix_struct_return
	  || (unsigned HOST_WIDE_INT) int_size_in_bytes (type) > 8))
    return true;

  /* Allow -maltivec -mabi=no-altivec without warning.  Altivec vector
     modes only exist for GCC vector types if -maltivec.  */
  if (TARGET_32BIT && !TARGET_ALTIVEC_ABI
      && ALTIVEC_VECTOR_MODE (TYPE_MODE (type)))
    return false;

  /* Return synthetic vectors in memory.  */
  if (TREE_CODE (type) == VECTOR_TYPE
      && int_size_in_bytes (type) > (TARGET_ALTIVEC_ABI ? 16 : 8))
    {
      static bool warned_for_return_big_vectors = false;
      if (!warned_for_return_big_vectors)
	{
	  warning (OPT_Wpsabi, "GCC vector returned by reference: "
		   "non-standard ABI extension with no compatibility "
		   "guarantee");
	  warned_for_return_big_vectors = true;
	}
      return true;
    }

  if (DEFAULT_ABI == ABI_V4 && TARGET_IEEEQUAD
      && FLOAT128_IEEE_P (TYPE_MODE (type)))
    return true;

  return false;
}

/* Specify whether values returned in registers should be at the most
   significant end of a register.  We want aggregates returned by
   value to match the way aggregates are passed to functions.  */

static bool
rs6000_return_in_msb (const_tree valtype)
{
  return (DEFAULT_ABI == ABI_ELFv2
	  && BYTES_BIG_ENDIAN
	  && AGGREGATE_TYPE_P (valtype)
	  && (rs6000_function_arg_padding (TYPE_MODE (valtype), valtype)
	      == PAD_UPWARD));
}

#ifdef HAVE_AS_GNU_ATTRIBUTE
/* Return TRUE if a call to function FNDECL may be one that
   potentially affects the function calling ABI of the object file.  */

static bool
call_ABI_of_interest (tree fndecl)
{
  if (rs6000_gnu_attr && symtab->state == EXPANSION)
    {
      struct cgraph_node *c_node;

      /* Libcalls are always interesting.  */
      if (fndecl == NULL_TREE)
	return true;

      /* Any call to an external function is interesting.  */
      if (DECL_EXTERNAL (fndecl))
	return true;

      /* Interesting functions that we are emitting in this object file.  */
      c_node = cgraph_node::get (fndecl);
      c_node = c_node->ultimate_alias_target ();
      return !c_node->only_called_directly_p ();
    }
  return false;
}
#endif

/* Initialize a variable CUM of type CUMULATIVE_ARGS
   for a call to a function whose data type is FNTYPE.
   For a library call, FNTYPE is 0 and RETURN_MODE the return value mode.

   For incoming args we set the number of arguments in the prototype large
   so we never return a PARALLEL.  */

void
init_cumulative_args (CUMULATIVE_ARGS *cum, tree fntype,
		      rtx libname ATTRIBUTE_UNUSED, int incoming,
		      int libcall, int n_named_args,
		      tree fndecl,
		      machine_mode return_mode ATTRIBUTE_UNUSED)
{
  static CUMULATIVE_ARGS zero_cumulative;

  *cum = zero_cumulative;
  cum->words = 0;
  cum->fregno = FP_ARG_MIN_REG;
  cum->vregno = ALTIVEC_ARG_MIN_REG;
  cum->prototype = (fntype && prototype_p (fntype));
  cum->call_cookie = ((DEFAULT_ABI == ABI_V4 && libcall)
		      ? CALL_LIBCALL : CALL_NORMAL);
  cum->sysv_gregno = GP_ARG_MIN_REG;
  cum->stdarg = stdarg_p (fntype);
  cum->libcall = libcall;

  cum->nargs_prototype = 0;
  if (incoming || cum->prototype)
    cum->nargs_prototype = n_named_args;

  /* Check for a longcall attribute.  */
  if ((!fntype && rs6000_default_long_calls)
      || (fntype
	  && lookup_attribute ("longcall", TYPE_ATTRIBUTES (fntype))
	  && !lookup_attribute ("shortcall", TYPE_ATTRIBUTES (fntype))))
    cum->call_cookie |= CALL_LONG;
  else if (DEFAULT_ABI != ABI_DARWIN)
    {
      bool is_local = (fndecl
		       && !DECL_EXTERNAL (fndecl)
		       && !DECL_WEAK (fndecl)
		       && (*targetm.binds_local_p) (fndecl));
      if (is_local)
	;
      else if (flag_plt)
	{
	  if (fntype
	      && lookup_attribute ("noplt", TYPE_ATTRIBUTES (fntype)))
	    cum->call_cookie |= CALL_LONG;
	}
      else
	{
	  if (!(fntype
		&& lookup_attribute ("plt", TYPE_ATTRIBUTES (fntype))))
	    cum->call_cookie |= CALL_LONG;
	}
    }

  if (TARGET_DEBUG_ARG)
    {
      fprintf (stderr, "\ninit_cumulative_args:");
      if (fntype)
	{
	  tree ret_type = TREE_TYPE (fntype);
	  fprintf (stderr, " ret code = %s,",
		   get_tree_code_name (TREE_CODE (ret_type)));
	}

      if (cum->call_cookie & CALL_LONG)
	fprintf (stderr, " longcall,");

      fprintf (stderr, " proto = %d, nargs = %d\n",
	       cum->prototype, cum->nargs_prototype);
    }

#ifdef HAVE_AS_GNU_ATTRIBUTE
  if (TARGET_ELF && (TARGET_64BIT || DEFAULT_ABI == ABI_V4))
    {
      cum->escapes = call_ABI_of_interest (fndecl);
      if (cum->escapes)
	{
	  tree return_type;

	  if (fntype)
	    {
	      return_type = TREE_TYPE (fntype);
	      return_mode = TYPE_MODE (return_type);
	    }
	  else
	    return_type = lang_hooks.types.type_for_mode (return_mode, 0);

	  if (return_type != NULL)
	    {
	      if (TREE_CODE (return_type) == RECORD_TYPE
		  && TYPE_TRANSPARENT_AGGR (return_type))
		{
		  return_type = TREE_TYPE (first_field (return_type));
		  return_mode = TYPE_MODE (return_type);
		}
	      if (AGGREGATE_TYPE_P (return_type)
		  && ((unsigned HOST_WIDE_INT) int_size_in_bytes (return_type)
		      <= 8))
		rs6000_returns_struct = true;
	    }
	  if (SCALAR_FLOAT_MODE_P (return_mode))
	    {
	      rs6000_passes_float = true;
	      if ((HAVE_LD_PPC_GNU_ATTR_LONG_DOUBLE || TARGET_64BIT)
		  && (FLOAT128_IBM_P (return_mode)
		      || FLOAT128_IEEE_P (return_mode)
		      || (return_type != NULL
			  && (TYPE_MAIN_VARIANT (return_type)
			      == long_double_type_node))))
		rs6000_passes_long_double = true;

	      /* Note if we passed or return a IEEE 128-bit type.  We changed
		 the mangling for these types, and we may need to make an alias
		 with the old mangling.  */
	      if (FLOAT128_IEEE_P (return_mode))
		rs6000_passes_ieee128 = true;
	    }
	  if (ALTIVEC_OR_VSX_VECTOR_MODE (return_mode))
	    rs6000_passes_vector = true;
	}
    }
#endif

  if (fntype
      && !TARGET_ALTIVEC
      && TARGET_ALTIVEC_ABI
      && ALTIVEC_VECTOR_MODE (TYPE_MODE (TREE_TYPE (fntype))))
    {
      error ("cannot return value in vector register because"
	     " altivec instructions are disabled, use %qs"
	     " to enable them", "-maltivec");
    }
}

/* The mode the ABI uses for a word.  This is not the same as word_mode
   for -m32 -mpowerpc64.  This is used to implement various target hooks.  */

static scalar_int_mode
rs6000_abi_word_mode (void)
{
  return TARGET_32BIT ? SImode : DImode;
}

/* Implement the TARGET_OFFLOAD_OPTIONS hook.  */
static char *
rs6000_offload_options (void)
{
  if (TARGET_64BIT)
    return xstrdup ("-foffload-abi=lp64");
  else
    return xstrdup ("-foffload-abi=ilp32");
}

/* On rs6000, function arguments are promoted, as are function return
   values.  */

static machine_mode
rs6000_promote_function_mode (const_tree type ATTRIBUTE_UNUSED,
			      machine_mode mode,
			      int *punsignedp ATTRIBUTE_UNUSED,
			      const_tree, int)
{
  PROMOTE_MODE (mode, *punsignedp, type);

  return mode;
}

/* Return true if TYPE must be passed on the stack and not in registers.  */

static bool
rs6000_must_pass_in_stack (machine_mode mode, const_tree type)
{
  if (DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2 || TARGET_64BIT)
    return must_pass_in_stack_var_size (mode, type);
  else
    return must_pass_in_stack_var_size_or_pad (mode, type);
}

static inline bool
is_complex_IBM_long_double (machine_mode mode)
{
  return mode == ICmode || (mode == TCmode && FLOAT128_IBM_P (TCmode));
}

/* Whether ABI_V4 passes MODE args to a function in floating point
   registers.  */

static bool
abi_v4_pass_in_fpr (machine_mode mode, bool named)
{
  if (!TARGET_HARD_FLOAT)
    return false;
  if (mode == DFmode)
    return true;
  if (mode == SFmode && named)
    return true;
  /* ABI_V4 passes complex IBM long double in 8 gprs.
     Stupid, but we can't change the ABI now.  */
  if (is_complex_IBM_long_double (mode))
    return false;
  if (FLOAT128_2REG_P (mode))
    return true;
  if (DECIMAL_FLOAT_MODE_P (mode))
    return true;
  return false;
}

/* Implement TARGET_FUNCTION_ARG_PADDING.

   For the AIX ABI structs are always stored left shifted in their
   argument slot.  */

static pad_direction
rs6000_function_arg_padding (machine_mode mode, const_tree type)
{
#ifndef AGGREGATE_PADDING_FIXED
#define AGGREGATE_PADDING_FIXED 0
#endif
#ifndef AGGREGATES_PAD_UPWARD_ALWAYS
#define AGGREGATES_PAD_UPWARD_ALWAYS 0
#endif

  if (!AGGREGATE_PADDING_FIXED)
    {
      /* GCC used to pass structures of the same size as integer types as
	 if they were in fact integers, ignoring TARGET_FUNCTION_ARG_PADDING.
	 i.e. Structures of size 1 or 2 (or 4 when TARGET_64BIT) were
	 passed padded downward, except that -mstrict-align further
	 muddied the water in that multi-component structures of 2 and 4
	 bytes in size were passed padded upward.

	 The following arranges for best compatibility with previous
	 versions of gcc, but removes the -mstrict-align dependency.  */
      if (BYTES_BIG_ENDIAN)
	{
	  HOST_WIDE_INT size = 0;

	  if (mode == BLKmode)
	    {
	      if (type && TREE_CODE (TYPE_SIZE (type)) == INTEGER_CST)
		size = int_size_in_bytes (type);
	    }
	  else
	    size = GET_MODE_SIZE (mode);

	  if (size == 1 || size == 2 || size == 4)
	    return PAD_DOWNWARD;
	}
      return PAD_UPWARD;
    }

  if (AGGREGATES_PAD_UPWARD_ALWAYS)
    {
      if (type != 0 && AGGREGATE_TYPE_P (type))
	return PAD_UPWARD;
    }

  /* Fall back to the default.  */
  return default_function_arg_padding (mode, type);
}

/* If defined, a C expression that gives the alignment boundary, in bits,
   of an argument with the specified mode and type.  If it is not defined,
   PARM_BOUNDARY is used for all arguments.

   V.4 wants long longs and doubles to be double word aligned.  Just
   testing the mode size is a boneheaded way to do this as it means
   that other types such as complex int are also double word aligned.
   However, we're stuck with this because changing the ABI might break
   existing library interfaces.

   Quadword align Altivec/VSX vectors.
   Quadword align large synthetic vector types.   */

static unsigned int
rs6000_function_arg_boundary (machine_mode mode, const_tree type)
{
  machine_mode elt_mode;
  int n_elts;

  rs6000_discover_homogeneous_aggregate (mode, type, &elt_mode, &n_elts);

  if (DEFAULT_ABI == ABI_V4
      && (GET_MODE_SIZE (mode) == 8
	  || (TARGET_HARD_FLOAT
	      && !is_complex_IBM_long_double (mode)
	      && FLOAT128_2REG_P (mode))))
    return 64;
  else if (FLOAT128_VECTOR_P (mode))
    return 128;
  else if (type && TREE_CODE (type) == VECTOR_TYPE
	   && int_size_in_bytes (type) >= 8
	   && int_size_in_bytes (type) < 16)
    return 64;
  else if (ALTIVEC_OR_VSX_VECTOR_MODE (elt_mode)
	   || (type && TREE_CODE (type) == VECTOR_TYPE
	       && int_size_in_bytes (type) >= 16))
    return 128;

  /* Aggregate types that need > 8 byte alignment are quadword-aligned
     in the parameter area in the ELFv2 ABI, and in the AIX ABI unless
     -mcompat-align-parm is used.  */
  if (((DEFAULT_ABI == ABI_AIX && !rs6000_compat_align_parm)
       || DEFAULT_ABI == ABI_ELFv2)
      && type && TYPE_ALIGN (type) > 64)
    {
      /* "Aggregate" means any AGGREGATE_TYPE except for single-element
         or homogeneous float/vector aggregates here.  We already handled
         vector aggregates above, but still need to check for float here. */
      bool aggregate_p = (AGGREGATE_TYPE_P (type)
			  && !SCALAR_FLOAT_MODE_P (elt_mode));

      /* We used to check for BLKmode instead of the above aggregate type
	 check.  Warn when this results in any difference to the ABI.  */
      if (aggregate_p != (mode == BLKmode))
	{
	  static bool warned;
	  if (!warned && warn_psabi)
	    {
	      warned = true;
	      inform (input_location,
		      "the ABI of passing aggregates with %d-byte alignment"
		      " has changed in GCC 5",
		      (int) TYPE_ALIGN (type) / BITS_PER_UNIT);
	    }
	}

      if (aggregate_p)
	return 128;
    }

  /* Similar for the Darwin64 ABI.  Note that for historical reasons we
     implement the "aggregate type" check as a BLKmode check here; this
     means certain aggregate types are in fact not aligned.  */
  if (TARGET_MACHO && rs6000_darwin64_abi
      && mode == BLKmode
      && type && TYPE_ALIGN (type) > 64)
    return 128;

  return PARM_BOUNDARY;
}

/* The offset in words to the start of the parameter save area.  */

static unsigned int
rs6000_parm_offset (void)
{
  return (DEFAULT_ABI == ABI_V4 ? 2
	  : DEFAULT_ABI == ABI_ELFv2 ? 4
	  : 6);
}

/* For a function parm of MODE and TYPE, return the starting word in
   the parameter area.  NWORDS of the parameter area are already used.  */

static unsigned int
rs6000_parm_start (machine_mode mode, const_tree type,
		   unsigned int nwords)
{
  unsigned int align;

  align = rs6000_function_arg_boundary (mode, type) / PARM_BOUNDARY - 1;
  return nwords + (-(rs6000_parm_offset () + nwords) & align);
}

/* Compute the size (in words) of a function argument.  */

static unsigned long
rs6000_arg_size (machine_mode mode, const_tree type)
{
  unsigned long size;

  if (mode != BLKmode)
    size = GET_MODE_SIZE (mode);
  else
    size = int_size_in_bytes (type);

  if (TARGET_32BIT)
    return (size + 3) >> 2;
  else
    return (size + 7) >> 3;
}

/* Use this to flush pending int fields.  */

static void
rs6000_darwin64_record_arg_advance_flush (CUMULATIVE_ARGS *cum,
					  HOST_WIDE_INT bitpos, int final)
{
  unsigned int startbit, endbit;
  int intregs, intoffset;

  /* Handle the situations where a float is taking up the first half
     of the GPR, and the other half is empty (typically due to
     alignment restrictions). We can detect this by a 8-byte-aligned
     int field, or by seeing that this is the final flush for this
     argument. Count the word and continue on.  */
  if (cum->floats_in_gpr == 1
      && (cum->intoffset % 64 == 0
	  || (cum->intoffset == -1 && final)))
    {
      cum->words++;
      cum->floats_in_gpr = 0;
    }

  if (cum->intoffset == -1)
    return;

  intoffset = cum->intoffset;
  cum->intoffset = -1;
  cum->floats_in_gpr = 0;

  if (intoffset % BITS_PER_WORD != 0)
    {
      unsigned int bits = BITS_PER_WORD - intoffset % BITS_PER_WORD;
      if (!int_mode_for_size (bits, 0).exists ())
	{
	  /* We couldn't find an appropriate mode, which happens,
	     e.g., in packed structs when there are 3 bytes to load.
	     Back intoffset back to the beginning of the word in this
	     case.  */
	  intoffset = ROUND_DOWN (intoffset, BITS_PER_WORD);
	}
    }

  startbit = ROUND_DOWN (intoffset, BITS_PER_WORD);
  endbit = ROUND_UP (bitpos, BITS_PER_WORD);
  intregs = (endbit - startbit) / BITS_PER_WORD;
  cum->words += intregs;
  /* words should be unsigned. */
  if ((unsigned)cum->words < (endbit/BITS_PER_WORD))
    {
      int pad = (endbit/BITS_PER_WORD) - cum->words;
      cum->words += pad;
    }
}

/* The darwin64 ABI calls for us to recurse down through structs,
   looking for elements passed in registers.  Unfortunately, we have
   to track int register count here also because of misalignments
   in powerpc alignment mode.  */

static void
rs6000_darwin64_record_arg_advance_recurse (CUMULATIVE_ARGS *cum,
					    const_tree type,
					    HOST_WIDE_INT startbitpos)
{
  tree f;

  for (f = TYPE_FIELDS (type); f ; f = DECL_CHAIN (f))
    if (TREE_CODE (f) == FIELD_DECL)
      {
	HOST_WIDE_INT bitpos = startbitpos;
	tree ftype = TREE_TYPE (f);
	machine_mode mode;
	if (ftype == error_mark_node)
	  continue;
	mode = TYPE_MODE (ftype);

	if (DECL_SIZE (f) != 0
	    && tree_fits_uhwi_p (bit_position (f)))
	  bitpos += int_bit_position (f);

	/* ??? FIXME: else assume zero offset.  */

	if (TREE_CODE (ftype) == RECORD_TYPE)
	  rs6000_darwin64_record_arg_advance_recurse (cum, ftype, bitpos);
	else if (USE_FP_FOR_ARG_P (cum, mode))
	  {
	    unsigned n_fpregs = (GET_MODE_SIZE (mode) + 7) >> 3;
	    rs6000_darwin64_record_arg_advance_flush (cum, bitpos, 0);
	    cum->fregno += n_fpregs;
	    /* Single-precision floats present a special problem for
	       us, because they are smaller than an 8-byte GPR, and so
	       the structure-packing rules combined with the standard
	       varargs behavior mean that we want to pack float/float
	       and float/int combinations into a single register's
	       space. This is complicated by the arg advance flushing,
	       which works on arbitrarily large groups of int-type
	       fields.  */
	    if (mode == SFmode)
	      {
		if (cum->floats_in_gpr == 1)
		  {
		    /* Two floats in a word; count the word and reset
		       the float count.  */
		    cum->words++;
		    cum->floats_in_gpr = 0;
		  }
		else if (bitpos % 64 == 0)
		  {
		    /* A float at the beginning of an 8-byte word;
		       count it and put off adjusting cum->words until
		       we see if a arg advance flush is going to do it
		       for us.  */
		    cum->floats_in_gpr++;
		  }
		else
		  {
		    /* The float is at the end of a word, preceded
		       by integer fields, so the arg advance flush
		       just above has already set cum->words and
		       everything is taken care of.  */
		  }
	      }
	    else
	      cum->words += n_fpregs;
	  }
	else if (USE_ALTIVEC_FOR_ARG_P (cum, mode, 1))
	  {
	    rs6000_darwin64_record_arg_advance_flush (cum, bitpos, 0);
	    cum->vregno++;
	    cum->words += 2;
	  }
	else if (cum->intoffset == -1)
	  cum->intoffset = bitpos;
      }
}

/* Check for an item that needs to be considered specially under the darwin 64
   bit ABI.  These are record types where the mode is BLK or the structure is
   8 bytes in size.  */
static int
rs6000_darwin64_struct_check_p (machine_mode mode, const_tree type)
{
  return rs6000_darwin64_abi
	 && ((mode == BLKmode 
	      && TREE_CODE (type) == RECORD_TYPE 
	      && int_size_in_bytes (type) > 0)
	  || (type && TREE_CODE (type) == RECORD_TYPE 
	      && int_size_in_bytes (type) == 8)) ? 1 : 0;
}

/* Update the data in CUM to advance over an argument
   of mode MODE and data type TYPE.
   (TYPE is null for libcalls where that information may not be available.)

   Note that for args passed by reference, function_arg will be called
   with MODE and TYPE set to that of the pointer to the arg, not the arg
   itself.  */

static void
rs6000_function_arg_advance_1 (CUMULATIVE_ARGS *cum, machine_mode mode,
			       const_tree type, bool named, int depth)
{
  machine_mode elt_mode;
  int n_elts;

  rs6000_discover_homogeneous_aggregate (mode, type, &elt_mode, &n_elts);

  /* Only tick off an argument if we're not recursing.  */
  if (depth == 0)
    cum->nargs_prototype--;

#ifdef HAVE_AS_GNU_ATTRIBUTE
  if (TARGET_ELF && (TARGET_64BIT || DEFAULT_ABI == ABI_V4)
      && cum->escapes)
    {
      if (SCALAR_FLOAT_MODE_P (mode))
	{
	  rs6000_passes_float = true;
	  if ((HAVE_LD_PPC_GNU_ATTR_LONG_DOUBLE || TARGET_64BIT)
	      && (FLOAT128_IBM_P (mode)
		  || FLOAT128_IEEE_P (mode)
		  || (type != NULL
		      && TYPE_MAIN_VARIANT (type) == long_double_type_node)))
	    rs6000_passes_long_double = true;

	  /* Note if we passed or return a IEEE 128-bit type.  We changed the
	     mangling for these types, and we may need to make an alias with
	     the old mangling.  */
	  if (FLOAT128_IEEE_P (mode))
	    rs6000_passes_ieee128 = true;
	}
      if (named && ALTIVEC_OR_VSX_VECTOR_MODE (mode))
	rs6000_passes_vector = true;
    }
#endif

  if (TARGET_ALTIVEC_ABI
      && (ALTIVEC_OR_VSX_VECTOR_MODE (elt_mode)
	  || (type && TREE_CODE (type) == VECTOR_TYPE
	      && int_size_in_bytes (type) == 16)))
    {
      bool stack = false;

      if (USE_ALTIVEC_FOR_ARG_P (cum, elt_mode, named))
	{
	  cum->vregno += n_elts;

	  if (!TARGET_ALTIVEC)
	    error ("cannot pass argument in vector register because"
		   " altivec instructions are disabled, use %qs"
		   " to enable them", "-maltivec");

	  /* PowerPC64 Linux and AIX allocate GPRs for a vector argument
	     even if it is going to be passed in a vector register.
	     Darwin does the same for variable-argument functions.  */
	  if (((DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2)
	       && TARGET_64BIT)
	      || (cum->stdarg && DEFAULT_ABI != ABI_V4))
	    stack = true;
	}
      else
	stack = true;

      if (stack)
	{
	  int align;

	  /* Vector parameters must be 16-byte aligned.  In 32-bit
	     mode this means we need to take into account the offset
	     to the parameter save area.  In 64-bit mode, they just
	     have to start on an even word, since the parameter save
	     area is 16-byte aligned.  */
	  if (TARGET_32BIT)
	    align = -(rs6000_parm_offset () + cum->words) & 3;
	  else
	    align = cum->words & 1;
	  cum->words += align + rs6000_arg_size (mode, type);

	  if (TARGET_DEBUG_ARG)
	    {
	      fprintf (stderr, "function_adv: words = %2d, align=%d, ",
		       cum->words, align);
	      fprintf (stderr, "nargs = %4d, proto = %d, mode = %4s\n",
		       cum->nargs_prototype, cum->prototype,
		       GET_MODE_NAME (mode));
	    }
	}
    }
  else if (TARGET_MACHO && rs6000_darwin64_struct_check_p (mode, type))
    {
      int size = int_size_in_bytes (type);
      /* Variable sized types have size == -1 and are
	 treated as if consisting entirely of ints.
	 Pad to 16 byte boundary if needed.  */
      if (TYPE_ALIGN (type) >= 2 * BITS_PER_WORD
	  && (cum->words % 2) != 0)
	cum->words++;
      /* For varargs, we can just go up by the size of the struct. */
      if (!named)
	cum->words += (size + 7) / 8;
      else
	{
	  /* It is tempting to say int register count just goes up by
	     sizeof(type)/8, but this is wrong in a case such as
	     { int; double; int; } [powerpc alignment].  We have to
	     grovel through the fields for these too.  */
	  cum->intoffset = 0;
	  cum->floats_in_gpr = 0;
	  rs6000_darwin64_record_arg_advance_recurse (cum, type, 0);
	  rs6000_darwin64_record_arg_advance_flush (cum,
						    size * BITS_PER_UNIT, 1);
	}
	  if (TARGET_DEBUG_ARG)
	    {
	      fprintf (stderr, "function_adv: words = %2d, align=%d, size=%d",
		       cum->words, TYPE_ALIGN (type), size);
	      fprintf (stderr, 
	           "nargs = %4d, proto = %d, mode = %4s (darwin64 abi)\n",
		       cum->nargs_prototype, cum->prototype,
		       GET_MODE_NAME (mode));
	    }
    }
  else if (DEFAULT_ABI == ABI_V4)
    {
      if (abi_v4_pass_in_fpr (mode, named))
	{
	  /* _Decimal128 must use an even/odd register pair.  This assumes
	     that the register number is odd when fregno is odd.  */
	  if (mode == TDmode && (cum->fregno % 2) == 1)
	    cum->fregno++;

	  if (cum->fregno + (FLOAT128_2REG_P (mode) ? 1 : 0)
	      <= FP_ARG_V4_MAX_REG)
	    cum->fregno += (GET_MODE_SIZE (mode) + 7) >> 3;
	  else
	    {
	      cum->fregno = FP_ARG_V4_MAX_REG + 1;
	      if (mode == DFmode || FLOAT128_IBM_P (mode)
		  || mode == DDmode || mode == TDmode)
		cum->words += cum->words & 1;
	      cum->words += rs6000_arg_size (mode, type);
	    }
	}
      else
	{
	  int n_words = rs6000_arg_size (mode, type);
	  int gregno = cum->sysv_gregno;

	  /* Long long is put in (r3,r4), (r5,r6), (r7,r8) or (r9,r10).
	     As does any other 2 word item such as complex int due to a
	     historical mistake.  */
	  if (n_words == 2)
	    gregno += (1 - gregno) & 1;

	  /* Multi-reg args are not split between registers and stack.  */
	  if (gregno + n_words - 1 > GP_ARG_MAX_REG)
	    {
	      /* Long long is aligned on the stack.  So are other 2 word
		 items such as complex int due to a historical mistake.  */
	      if (n_words == 2)
		cum->words += cum->words & 1;
	      cum->words += n_words;
	    }

	  /* Note: continuing to accumulate gregno past when we've started
	     spilling to the stack indicates the fact that we've started
	     spilling to the stack to expand_builtin_saveregs.  */
	  cum->sysv_gregno = gregno + n_words;
	}

      if (TARGET_DEBUG_ARG)
	{
	  fprintf (stderr, "function_adv: words = %2d, fregno = %2d, ",
		   cum->words, cum->fregno);
	  fprintf (stderr, "gregno = %2d, nargs = %4d, proto = %d, ",
		   cum->sysv_gregno, cum->nargs_prototype, cum->prototype);
	  fprintf (stderr, "mode = %4s, named = %d\n",
		   GET_MODE_NAME (mode), named);
	}
    }
  else
    {
      int n_words = rs6000_arg_size (mode, type);
      int start_words = cum->words;
      int align_words = rs6000_parm_start (mode, type, start_words);

      cum->words = align_words + n_words;

      if (SCALAR_FLOAT_MODE_P (elt_mode) && TARGET_HARD_FLOAT)
	{
	  /* _Decimal128 must be passed in an even/odd float register pair.
	     This assumes that the register number is odd when fregno is
	     odd.  */
	  if (elt_mode == TDmode && (cum->fregno % 2) == 1)
	    cum->fregno++;
	  cum->fregno += n_elts * ((GET_MODE_SIZE (elt_mode) + 7) >> 3);
	}

      if (TARGET_DEBUG_ARG)
	{
	  fprintf (stderr, "function_adv: words = %2d, fregno = %2d, ",
		   cum->words, cum->fregno);
	  fprintf (stderr, "nargs = %4d, proto = %d, mode = %4s, ",
		   cum->nargs_prototype, cum->prototype, GET_MODE_NAME (mode));
	  fprintf (stderr, "named = %d, align = %d, depth = %d\n",
		   named, align_words - start_words, depth);
	}
    }
}

static void
rs6000_function_arg_advance (cumulative_args_t cum, machine_mode mode,
			     const_tree type, bool named)
{
  rs6000_function_arg_advance_1 (get_cumulative_args (cum), mode, type, named,
				 0);
}

/* A subroutine of rs6000_darwin64_record_arg.  Assign the bits of the
   structure between cum->intoffset and bitpos to integer registers.  */

static void
rs6000_darwin64_record_arg_flush (CUMULATIVE_ARGS *cum,
				  HOST_WIDE_INT bitpos, rtx rvec[], int *k)
{
  machine_mode mode;
  unsigned int regno;
  unsigned int startbit, endbit;
  int this_regno, intregs, intoffset;
  rtx reg;

  if (cum->intoffset == -1)
    return;

  intoffset = cum->intoffset;
  cum->intoffset = -1;

  /* If this is the trailing part of a word, try to only load that
     much into the register.  Otherwise load the whole register.  Note
     that in the latter case we may pick up unwanted bits.  It's not a
     problem at the moment but may wish to revisit.  */

  if (intoffset % BITS_PER_WORD != 0)
    {
      unsigned int bits = BITS_PER_WORD - intoffset % BITS_PER_WORD;
      if (!int_mode_for_size (bits, 0).exists (&mode))
	{
	  /* We couldn't find an appropriate mode, which happens,
	     e.g., in packed structs when there are 3 bytes to load.
	     Back intoffset back to the beginning of the word in this
	     case.  */
	  intoffset = ROUND_DOWN (intoffset, BITS_PER_WORD);
	  mode = word_mode;
	}
    }
  else
    mode = word_mode;

  startbit = ROUND_DOWN (intoffset, BITS_PER_WORD);
  endbit = ROUND_UP (bitpos, BITS_PER_WORD);
  intregs = (endbit - startbit) / BITS_PER_WORD;
  this_regno = cum->words + intoffset / BITS_PER_WORD;

  if (intregs > 0 && intregs > GP_ARG_NUM_REG - this_regno)
    cum->use_stack = 1;

  intregs = MIN (intregs, GP_ARG_NUM_REG - this_regno);
  if (intregs <= 0)
    return;

  intoffset /= BITS_PER_UNIT;
  do
    {
      regno = GP_ARG_MIN_REG + this_regno;
      reg = gen_rtx_REG (mode, regno);
      rvec[(*k)++] =
	gen_rtx_EXPR_LIST (VOIDmode, reg, GEN_INT (intoffset));

      this_regno += 1;
      intoffset = (intoffset | (UNITS_PER_WORD-1)) + 1;
      mode = word_mode;
      intregs -= 1;
    }
  while (intregs > 0);
}

/* Recursive workhorse for the following.  */

static void
rs6000_darwin64_record_arg_recurse (CUMULATIVE_ARGS *cum, const_tree type,
				    HOST_WIDE_INT startbitpos, rtx rvec[],
				    int *k)
{
  tree f;

  for (f = TYPE_FIELDS (type); f ; f = DECL_CHAIN (f))
    if (TREE_CODE (f) == FIELD_DECL)
      {
	HOST_WIDE_INT bitpos = startbitpos;
	tree ftype = TREE_TYPE (f);
	machine_mode mode;
	if (ftype == error_mark_node)
	  continue;
	mode = TYPE_MODE (ftype);

	if (DECL_SIZE (f) != 0
	    && tree_fits_uhwi_p (bit_position (f)))
	  bitpos += int_bit_position (f);

	/* ??? FIXME: else assume zero offset.  */

	if (TREE_CODE (ftype) == RECORD_TYPE)
	  rs6000_darwin64_record_arg_recurse (cum, ftype, bitpos, rvec, k);
	else if (cum->named && USE_FP_FOR_ARG_P (cum, mode))
	  {
	    unsigned n_fpreg = (GET_MODE_SIZE (mode) + 7) >> 3;
#if 0
	    switch (mode)
	      {
	      case E_SCmode: mode = SFmode; break;
	      case E_DCmode: mode = DFmode; break;
	      case E_TCmode: mode = TFmode; break;
	      default: break;
	      }
#endif
	    rs6000_darwin64_record_arg_flush (cum, bitpos, rvec, k);
	    if (cum->fregno + n_fpreg > FP_ARG_MAX_REG + 1)
	      {
		gcc_assert (cum->fregno == FP_ARG_MAX_REG
			    && (mode == TFmode || mode == TDmode));
		/* Long double or _Decimal128 split over regs and memory.  */
		mode = DECIMAL_FLOAT_MODE_P (mode) ? DDmode : DFmode;
		cum->use_stack=1;
	      }
	    rvec[(*k)++]
	      = gen_rtx_EXPR_LIST (VOIDmode,
				   gen_rtx_REG (mode, cum->fregno++),
				   GEN_INT (bitpos / BITS_PER_UNIT));
	    if (FLOAT128_2REG_P (mode))
	      cum->fregno++;
	  }
	else if (cum->named && USE_ALTIVEC_FOR_ARG_P (cum, mode, 1))
	  {
	    rs6000_darwin64_record_arg_flush (cum, bitpos, rvec, k);
	    rvec[(*k)++]
	      = gen_rtx_EXPR_LIST (VOIDmode,
				   gen_rtx_REG (mode, cum->vregno++),
				   GEN_INT (bitpos / BITS_PER_UNIT));
	  }
	else if (cum->intoffset == -1)
	  cum->intoffset = bitpos;
      }
}

/* For the darwin64 ABI, we want to construct a PARALLEL consisting of
   the register(s) to be used for each field and subfield of a struct
   being passed by value, along with the offset of where the
   register's value may be found in the block.  FP fields go in FP
   register, vector fields go in vector registers, and everything
   else goes in int registers, packed as in memory.

   This code is also used for function return values.  RETVAL indicates
   whether this is the case.

   Much of this is taken from the SPARC V9 port, which has a similar
   calling convention.  */

static rtx
rs6000_darwin64_record_arg (CUMULATIVE_ARGS *orig_cum, const_tree type,
			    bool named, bool retval)
{
  rtx rvec[FIRST_PSEUDO_REGISTER];
  int k = 1, kbase = 1;
  HOST_WIDE_INT typesize = int_size_in_bytes (type);
  /* This is a copy; modifications are not visible to our caller.  */
  CUMULATIVE_ARGS copy_cum = *orig_cum;
  CUMULATIVE_ARGS *cum = &copy_cum;

  /* Pad to 16 byte boundary if needed.  */
  if (!retval && TYPE_ALIGN (type) >= 2 * BITS_PER_WORD
      && (cum->words % 2) != 0)
    cum->words++;

  cum->intoffset = 0;
  cum->use_stack = 0;
  cum->named = named;

  /* Put entries into rvec[] for individual FP and vector fields, and
     for the chunks of memory that go in int regs.  Note we start at
     element 1; 0 is reserved for an indication of using memory, and
     may or may not be filled in below. */
  rs6000_darwin64_record_arg_recurse (cum, type, /* startbit pos= */ 0, rvec, &k);
  rs6000_darwin64_record_arg_flush (cum, typesize * BITS_PER_UNIT, rvec, &k);

  /* If any part of the struct went on the stack put all of it there.
     This hack is because the generic code for
     FUNCTION_ARG_PARTIAL_NREGS cannot handle cases where the register
     parts of the struct are not at the beginning.  */
  if (cum->use_stack)
    {
      if (retval)
	return NULL_RTX;    /* doesn't go in registers at all */
      kbase = 0;
      rvec[0] = gen_rtx_EXPR_LIST (VOIDmode, NULL_RTX, const0_rtx);
    }
  if (k > 1 || cum->use_stack)
    return gen_rtx_PARALLEL (BLKmode, gen_rtvec_v (k - kbase, &rvec[kbase]));
  else
    return NULL_RTX;
}

/* Determine where to place an argument in 64-bit mode with 32-bit ABI.  */

static rtx
rs6000_mixed_function_arg (machine_mode mode, const_tree type,
			   int align_words)
{
  int n_units;
  int i, k;
  rtx rvec[GP_ARG_NUM_REG + 1];

  if (align_words >= GP_ARG_NUM_REG)
    return NULL_RTX;

  n_units = rs6000_arg_size (mode, type);

  /* Optimize the simple case where the arg fits in one gpr, except in
     the case of BLKmode due to assign_parms assuming that registers are
     BITS_PER_WORD wide.  */
  if (n_units == 0
      || (n_units == 1 && mode != BLKmode))
    return gen_rtx_REG (mode, GP_ARG_MIN_REG + align_words);

  k = 0;
  if (align_words + n_units > GP_ARG_NUM_REG)
    /* Not all of the arg fits in gprs.  Say that it goes in memory too,
       using a magic NULL_RTX component.
       This is not strictly correct.  Only some of the arg belongs in
       memory, not all of it.  However, the normal scheme using
       function_arg_partial_nregs can result in unusual subregs, eg.
       (subreg:SI (reg:DF) 4), which are not handled well.  The code to
       store the whole arg to memory is often more efficient than code
       to store pieces, and we know that space is available in the right
       place for the whole arg.  */
    rvec[k++] = gen_rtx_EXPR_LIST (VOIDmode, NULL_RTX, const0_rtx);

  i = 0;
  do
    {
      rtx r = gen_rtx_REG (SImode, GP_ARG_MIN_REG + align_words);
      rtx off = GEN_INT (i++ * 4);
      rvec[k++] = gen_rtx_EXPR_LIST (VOIDmode, r, off);
    }
  while (++align_words < GP_ARG_NUM_REG && --n_units != 0);

  return gen_rtx_PARALLEL (mode, gen_rtvec_v (k, rvec));
}

/* We have an argument of MODE and TYPE that goes into FPRs or VRs,
   but must also be copied into the parameter save area starting at
   offset ALIGN_WORDS.  Fill in RVEC with the elements corresponding
   to the GPRs and/or memory.  Return the number of elements used.  */

static int
rs6000_psave_function_arg (machine_mode mode, const_tree type,
			   int align_words, rtx *rvec)
{
  int k = 0;

  if (align_words < GP_ARG_NUM_REG)
    {
      int n_words = rs6000_arg_size (mode, type);

      if (align_words + n_words > GP_ARG_NUM_REG
	  || mode == BLKmode
	  || (TARGET_32BIT && TARGET_POWERPC64))
	{
	  /* If this is partially on the stack, then we only
	     include the portion actually in registers here.  */
	  machine_mode rmode = TARGET_32BIT ? SImode : DImode;
	  int i = 0;

	  if (align_words + n_words > GP_ARG_NUM_REG)
	    {
	      /* Not all of the arg fits in gprs.  Say that it goes in memory
		 too, using a magic NULL_RTX component.  Also see comment in
		 rs6000_mixed_function_arg for why the normal
		 function_arg_partial_nregs scheme doesn't work in this case. */
	      rvec[k++] = gen_rtx_EXPR_LIST (VOIDmode, NULL_RTX, const0_rtx);
	    }

	  do
	    {
	      rtx r = gen_rtx_REG (rmode, GP_ARG_MIN_REG + align_words);
	      rtx off = GEN_INT (i++ * GET_MODE_SIZE (rmode));
	      rvec[k++] = gen_rtx_EXPR_LIST (VOIDmode, r, off);
	    }
	  while (++align_words < GP_ARG_NUM_REG && --n_words != 0);
	}
      else
	{
	  /* The whole arg fits in gprs.  */
	  rtx r = gen_rtx_REG (mode, GP_ARG_MIN_REG + align_words);
	  rvec[k++] = gen_rtx_EXPR_LIST (VOIDmode, r, const0_rtx);
	}
    }
  else
    {
      /* It's entirely in memory.  */
      rvec[k++] = gen_rtx_EXPR_LIST (VOIDmode, NULL_RTX, const0_rtx);
    }

  return k;
}

/* RVEC is a vector of K components of an argument of mode MODE.
   Construct the final function_arg return value from it.  */

static rtx
rs6000_finish_function_arg (machine_mode mode, rtx *rvec, int k)
{
  gcc_assert (k >= 1);

  /* Avoid returning a PARALLEL in the trivial cases.  */
  if (k == 1)
    {
      if (XEXP (rvec[0], 0) == NULL_RTX)
	return NULL_RTX;

      if (GET_MODE (XEXP (rvec[0], 0)) == mode)
	return XEXP (rvec[0], 0);
    }

  return gen_rtx_PARALLEL (mode, gen_rtvec_v (k, rvec));
}

/* Determine where to put an argument to a function.
   Value is zero to push the argument on the stack,
   or a hard register in which to store the argument.

   MODE is the argument's machine mode.
   TYPE is the data type of the argument (as a tree).
    This is null for libcalls where that information may
    not be available.
   CUM is a variable of type CUMULATIVE_ARGS which gives info about
    the preceding args and about the function being called.  It is
    not modified in this routine.
   NAMED is nonzero if this argument is a named parameter
    (otherwise it is an extra parameter matching an ellipsis).

   On RS/6000 the first eight words of non-FP are normally in registers
   and the rest are pushed.  Under AIX, the first 13 FP args are in registers.
   Under V.4, the first 8 FP args are in registers.

   If this is floating-point and no prototype is specified, we use
   both an FP and integer register (or possibly FP reg and stack).  Library
   functions (when CALL_LIBCALL is set) always have the proper types for args,
   so we can pass the FP value just in one register.  emit_library_function
   doesn't support PARALLEL anyway.

   Note that for args passed by reference, function_arg will be called
   with MODE and TYPE set to that of the pointer to the arg, not the arg
   itself.  */

static rtx
rs6000_function_arg (cumulative_args_t cum_v, machine_mode mode,
		     const_tree type, bool named)
{
  CUMULATIVE_ARGS *cum = get_cumulative_args (cum_v);
  enum rs6000_abi abi = DEFAULT_ABI;
  machine_mode elt_mode;
  int n_elts;

  /* Return a marker to indicate whether CR1 needs to set or clear the
     bit that V.4 uses to say fp args were passed in registers.
     Assume that we don't need the marker for software floating point,
     or compiler generated library calls.  */
  if (mode == VOIDmode)
    {
      if (abi == ABI_V4
	  && (cum->call_cookie & CALL_LIBCALL) == 0
	  && (cum->stdarg
	      || (cum->nargs_prototype < 0
		  && (cum->prototype || TARGET_NO_PROTOTYPE)))
	  && TARGET_HARD_FLOAT)
	return GEN_INT (cum->call_cookie
			| ((cum->fregno == FP_ARG_MIN_REG)
			   ? CALL_V4_SET_FP_ARGS
			   : CALL_V4_CLEAR_FP_ARGS));

      return GEN_INT (cum->call_cookie & ~CALL_LIBCALL);
    }

  rs6000_discover_homogeneous_aggregate (mode, type, &elt_mode, &n_elts);

  if (TARGET_MACHO && rs6000_darwin64_struct_check_p (mode, type))
    {
      rtx rslt = rs6000_darwin64_record_arg (cum, type, named, /*retval= */false);
      if (rslt != NULL_RTX)
	return rslt;
      /* Else fall through to usual handling.  */
    }

  if (USE_ALTIVEC_FOR_ARG_P (cum, elt_mode, named))
    {
      rtx rvec[GP_ARG_NUM_REG + AGGR_ARG_NUM_REG + 1];
      rtx r, off;
      int i, k = 0;

      /* Do we also need to pass this argument in the parameter save area?
	 Library support functions for IEEE 128-bit are assumed to not need the
	 value passed both in GPRs and in vector registers.  */
      if (TARGET_64BIT && !cum->prototype
	  && (!cum->libcall || !FLOAT128_VECTOR_P (elt_mode)))
	{
	  int align_words = ROUND_UP (cum->words, 2);
	  k = rs6000_psave_function_arg (mode, type, align_words, rvec);
	}

      /* Describe where this argument goes in the vector registers.  */
      for (i = 0; i < n_elts && cum->vregno + i <= ALTIVEC_ARG_MAX_REG; i++)
	{
	  r = gen_rtx_REG (elt_mode, cum->vregno + i);
	  off = GEN_INT (i * GET_MODE_SIZE (elt_mode));
	  rvec[k++] =  gen_rtx_EXPR_LIST (VOIDmode, r, off);
	}

      return rs6000_finish_function_arg (mode, rvec, k);
    }
  else if (TARGET_ALTIVEC_ABI
	   && (ALTIVEC_OR_VSX_VECTOR_MODE (mode)
	       || (type && TREE_CODE (type) == VECTOR_TYPE
		   && int_size_in_bytes (type) == 16)))
    {
      if (named || abi == ABI_V4)
	return NULL_RTX;
      else
	{
	  /* Vector parameters to varargs functions under AIX or Darwin
	     get passed in memory and possibly also in GPRs.  */
	  int align, align_words, n_words;
	  machine_mode part_mode;

	  /* Vector parameters must be 16-byte aligned.  In 32-bit
	     mode this means we need to take into account the offset
	     to the parameter save area.  In 64-bit mode, they just
	     have to start on an even word, since the parameter save
	     area is 16-byte aligned.  */
	  if (TARGET_32BIT)
	    align = -(rs6000_parm_offset () + cum->words) & 3;
	  else
	    align = cum->words & 1;
	  align_words = cum->words + align;

	  /* Out of registers?  Memory, then.  */
	  if (align_words >= GP_ARG_NUM_REG)
	    return NULL_RTX;

	  if (TARGET_32BIT && TARGET_POWERPC64)
	    return rs6000_mixed_function_arg (mode, type, align_words);

	  /* The vector value goes in GPRs.  Only the part of the
	     value in GPRs is reported here.  */
	  part_mode = mode;
	  n_words = rs6000_arg_size (mode, type);
	  if (align_words + n_words > GP_ARG_NUM_REG)
	    /* Fortunately, there are only two possibilities, the value
	       is either wholly in GPRs or half in GPRs and half not.  */
	    part_mode = DImode;

	  return gen_rtx_REG (part_mode, GP_ARG_MIN_REG + align_words);
	}
    }

  else if (abi == ABI_V4)
    {
      if (abi_v4_pass_in_fpr (mode, named))
	{
	  /* _Decimal128 must use an even/odd register pair.  This assumes
	     that the register number is odd when fregno is odd.  */
	  if (mode == TDmode && (cum->fregno % 2) == 1)
	    cum->fregno++;

	  if (cum->fregno + (FLOAT128_2REG_P (mode) ? 1 : 0)
	      <= FP_ARG_V4_MAX_REG)
	    return gen_rtx_REG (mode, cum->fregno);
	  else
	    return NULL_RTX;
	}
      else
	{
	  int n_words = rs6000_arg_size (mode, type);
	  int gregno = cum->sysv_gregno;

	  /* Long long is put in (r3,r4), (r5,r6), (r7,r8) or (r9,r10).
	     As does any other 2 word item such as complex int due to a
	     historical mistake.  */
	  if (n_words == 2)
	    gregno += (1 - gregno) & 1;

	  /* Multi-reg args are not split between registers and stack.  */
	  if (gregno + n_words - 1 > GP_ARG_MAX_REG)
	    return NULL_RTX;

	  if (TARGET_32BIT && TARGET_POWERPC64)
	    return rs6000_mixed_function_arg (mode, type,
					      gregno - GP_ARG_MIN_REG);
	  return gen_rtx_REG (mode, gregno);
	}
    }
  else
    {
      int align_words = rs6000_parm_start (mode, type, cum->words);

      /* _Decimal128 must be passed in an even/odd float register pair.
	 This assumes that the register number is odd when fregno is odd.  */
      if (elt_mode == TDmode && (cum->fregno % 2) == 1)
	cum->fregno++;

      if (USE_FP_FOR_ARG_P (cum, elt_mode)
	  && !(TARGET_AIX && !TARGET_ELF
	       && type != NULL && AGGREGATE_TYPE_P (type)))
	{
	  rtx rvec[GP_ARG_NUM_REG + AGGR_ARG_NUM_REG + 1];
	  rtx r, off;
	  int i, k = 0;
	  unsigned long n_fpreg = (GET_MODE_SIZE (elt_mode) + 7) >> 3;
	  int fpr_words;

	  /* Do we also need to pass this argument in the parameter
	     save area?  */
	  if (type && (cum->nargs_prototype <= 0
		       || ((DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2)
			   && TARGET_XL_COMPAT
			   && align_words >= GP_ARG_NUM_REG)))
	    k = rs6000_psave_function_arg (mode, type, align_words, rvec);

	  /* Describe where this argument goes in the fprs.  */
	  for (i = 0; i < n_elts
		      && cum->fregno + i * n_fpreg <= FP_ARG_MAX_REG; i++)
	    {
	      /* Check if the argument is split over registers and memory.
		 This can only ever happen for long double or _Decimal128;
		 complex types are handled via split_complex_arg.  */
	      machine_mode fmode = elt_mode;
	      if (cum->fregno + (i + 1) * n_fpreg > FP_ARG_MAX_REG + 1)
		{
		  gcc_assert (FLOAT128_2REG_P (fmode));
		  fmode = DECIMAL_FLOAT_MODE_P (fmode) ? DDmode : DFmode;
		}

	      r = gen_rtx_REG (fmode, cum->fregno + i * n_fpreg);
	      off = GEN_INT (i * GET_MODE_SIZE (elt_mode));
	      rvec[k++] = gen_rtx_EXPR_LIST (VOIDmode, r, off);
	    }

	  /* If there were not enough FPRs to hold the argument, the rest
	     usually goes into memory.  However, if the current position
	     is still within the register parameter area, a portion may
	     actually have to go into GPRs.

	     Note that it may happen that the portion of the argument
	     passed in the first "half" of the first GPR was already
	     passed in the last FPR as well.

	     For unnamed arguments, we already set up GPRs to cover the
	     whole argument in rs6000_psave_function_arg, so there is
	     nothing further to do at this point.  */
	  fpr_words = (i * GET_MODE_SIZE (elt_mode)) / (TARGET_32BIT ? 4 : 8);
	  if (i < n_elts && align_words + fpr_words < GP_ARG_NUM_REG
	      && cum->nargs_prototype > 0)
            {
	      static bool warned;

	      machine_mode rmode = TARGET_32BIT ? SImode : DImode;
	      int n_words = rs6000_arg_size (mode, type);

	      align_words += fpr_words;
	      n_words -= fpr_words;

	      do
		{
		  r = gen_rtx_REG (rmode, GP_ARG_MIN_REG + align_words);
		  off = GEN_INT (fpr_words++ * GET_MODE_SIZE (rmode));
		  rvec[k++] = gen_rtx_EXPR_LIST (VOIDmode, r, off);
		}
	      while (++align_words < GP_ARG_NUM_REG && --n_words != 0);

	      if (!warned && warn_psabi)
		{
		  warned = true;
		  inform (input_location,
			  "the ABI of passing homogeneous %<float%> aggregates"
			  " has changed in GCC 5");
		}
	    }

	  return rs6000_finish_function_arg (mode, rvec, k);
	}
      else if (align_words < GP_ARG_NUM_REG)
	{
	  if (TARGET_32BIT && TARGET_POWERPC64)
	    return rs6000_mixed_function_arg (mode, type, align_words);

	  return gen_rtx_REG (mode, GP_ARG_MIN_REG + align_words);
	}
      else
	return NULL_RTX;
    }
}

/* For an arg passed partly in registers and partly in memory, this is
   the number of bytes passed in registers.  For args passed entirely in
   registers or entirely in memory, zero.  When an arg is described by a
   PARALLEL, perhaps using more than one register type, this function
   returns the number of bytes used by the first element of the PARALLEL.  */

static int
rs6000_arg_partial_bytes (cumulative_args_t cum_v, machine_mode mode,
			  tree type, bool named)
{
  CUMULATIVE_ARGS *cum = get_cumulative_args (cum_v);
  bool passed_in_gprs = true;
  int ret = 0;
  int align_words;
  machine_mode elt_mode;
  int n_elts;

  rs6000_discover_homogeneous_aggregate (mode, type, &elt_mode, &n_elts);

  if (DEFAULT_ABI == ABI_V4)
    return 0;

  if (USE_ALTIVEC_FOR_ARG_P (cum, elt_mode, named))
    {
      /* If we are passing this arg in the fixed parameter save area (gprs or
         memory) as well as VRs, we do not use the partial bytes mechanism;
         instead, rs6000_function_arg will return a PARALLEL including a memory
         element as necessary.  Library support functions for IEEE 128-bit are
         assumed to not need the value passed both in GPRs and in vector
         registers.  */
      if (TARGET_64BIT && !cum->prototype
	  && (!cum->libcall || !FLOAT128_VECTOR_P (elt_mode)))
	return 0;

      /* Otherwise, we pass in VRs only.  Check for partial copies.  */
      passed_in_gprs = false;
      if (cum->vregno + n_elts > ALTIVEC_ARG_MAX_REG + 1)
	ret = (ALTIVEC_ARG_MAX_REG + 1 - cum->vregno) * 16;
    }

  /* In this complicated case we just disable the partial_nregs code.  */
  if (TARGET_MACHO && rs6000_darwin64_struct_check_p (mode, type))
    return 0;

  align_words = rs6000_parm_start (mode, type, cum->words);

  if (USE_FP_FOR_ARG_P (cum, elt_mode)
      && !(TARGET_AIX && !TARGET_ELF
	   && type != NULL && AGGREGATE_TYPE_P (type)))
    {
      unsigned long n_fpreg = (GET_MODE_SIZE (elt_mode) + 7) >> 3;

      /* If we are passing this arg in the fixed parameter save area
         (gprs or memory) as well as FPRs, we do not use the partial
	 bytes mechanism; instead, rs6000_function_arg will return a
	 PARALLEL including a memory element as necessary.  */
      if (type
	  && (cum->nargs_prototype <= 0
	      || ((DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2)
		  && TARGET_XL_COMPAT
		  && align_words >= GP_ARG_NUM_REG)))
	return 0;

      /* Otherwise, we pass in FPRs only.  Check for partial copies.  */
      passed_in_gprs = false;
      if (cum->fregno + n_elts * n_fpreg > FP_ARG_MAX_REG + 1)
	{
	  /* Compute number of bytes / words passed in FPRs.  If there
	     is still space available in the register parameter area
	     *after* that amount, a part of the argument will be passed
	     in GPRs.  In that case, the total amount passed in any
	     registers is equal to the amount that would have been passed
	     in GPRs if everything were passed there, so we fall back to
	     the GPR code below to compute the appropriate value.  */
	  int fpr = ((FP_ARG_MAX_REG + 1 - cum->fregno)
		     * MIN (8, GET_MODE_SIZE (elt_mode)));
	  int fpr_words = fpr / (TARGET_32BIT ? 4 : 8);

	  if (align_words + fpr_words < GP_ARG_NUM_REG)
	    passed_in_gprs = true;
	  else
	    ret = fpr;
	}
    }

  if (passed_in_gprs
      && align_words < GP_ARG_NUM_REG
      && GP_ARG_NUM_REG < align_words + rs6000_arg_size (mode, type))
    ret = (GP_ARG_NUM_REG - align_words) * (TARGET_32BIT ? 4 : 8);

  if (ret != 0 && TARGET_DEBUG_ARG)
    fprintf (stderr, "rs6000_arg_partial_bytes: %d\n", ret);

  return ret;
}

/* A C expression that indicates when an argument must be passed by
   reference.  If nonzero for an argument, a copy of that argument is
   made in memory and a pointer to the argument is passed instead of
   the argument itself.  The pointer is passed in whatever way is
   appropriate for passing a pointer to that type.

   Under V.4, aggregates and long double are passed by reference.

   As an extension to all 32-bit ABIs, AltiVec vectors are passed by
   reference unless the AltiVec vector extension ABI is in force.

   As an extension to all ABIs, variable sized types are passed by
   reference.  */

static bool
rs6000_pass_by_reference (cumulative_args_t cum ATTRIBUTE_UNUSED,
			  machine_mode mode, const_tree type,
			  bool named ATTRIBUTE_UNUSED)
{
  if (!type)
    return 0;

  if (DEFAULT_ABI == ABI_V4 && TARGET_IEEEQUAD
      && FLOAT128_IEEE_P (TYPE_MODE (type)))
    {
      if (TARGET_DEBUG_ARG)
	fprintf (stderr, "function_arg_pass_by_reference: V4 IEEE 128-bit\n");
      return 1;
    }

  if (DEFAULT_ABI == ABI_V4 && AGGREGATE_TYPE_P (type))
    {
      if (TARGET_DEBUG_ARG)
	fprintf (stderr, "function_arg_pass_by_reference: V4 aggregate\n");
      return 1;
    }

  if (int_size_in_bytes (type) < 0)
    {
      if (TARGET_DEBUG_ARG)
	fprintf (stderr, "function_arg_pass_by_reference: variable size\n");
      return 1;
    }

  /* Allow -maltivec -mabi=no-altivec without warning.  Altivec vector
     modes only exist for GCC vector types if -maltivec.  */
  if (TARGET_32BIT && !TARGET_ALTIVEC_ABI && ALTIVEC_VECTOR_MODE (mode))
    {
      if (TARGET_DEBUG_ARG)
	fprintf (stderr, "function_arg_pass_by_reference: AltiVec\n");
      return 1;
    }

  /* Pass synthetic vectors in memory.  */
  if (TREE_CODE (type) == VECTOR_TYPE
      && int_size_in_bytes (type) > (TARGET_ALTIVEC_ABI ? 16 : 8))
    {
      static bool warned_for_pass_big_vectors = false;
      if (TARGET_DEBUG_ARG)
	fprintf (stderr, "function_arg_pass_by_reference: synthetic vector\n");
      if (!warned_for_pass_big_vectors)
	{
	  warning (OPT_Wpsabi, "GCC vector passed by reference: "
		   "non-standard ABI extension with no compatibility "
		   "guarantee");
	  warned_for_pass_big_vectors = true;
	}
      return 1;
    }

  return 0;
}

/* Process parameter of type TYPE after ARGS_SO_FAR parameters were
   already processes.  Return true if the parameter must be passed
   (fully or partially) on the stack.  */

static bool
rs6000_parm_needs_stack (cumulative_args_t args_so_far, tree type)
{
  machine_mode mode;
  int unsignedp;
  rtx entry_parm;

  /* Catch errors.  */
  if (type == NULL || type == error_mark_node)
    return true;

  /* Handle types with no storage requirement.  */
  if (TYPE_MODE (type) == VOIDmode)
    return false;

  /* Handle complex types.  */
  if (TREE_CODE (type) == COMPLEX_TYPE)
    return (rs6000_parm_needs_stack (args_so_far, TREE_TYPE (type))
	    || rs6000_parm_needs_stack (args_so_far, TREE_TYPE (type)));

  /* Handle transparent aggregates.  */
  if ((TREE_CODE (type) == UNION_TYPE || TREE_CODE (type) == RECORD_TYPE)
      && TYPE_TRANSPARENT_AGGR (type))
    type = TREE_TYPE (first_field (type));

  /* See if this arg was passed by invisible reference.  */
  if (pass_by_reference (get_cumulative_args (args_so_far),
			 TYPE_MODE (type), type, true))
    type = build_pointer_type (type);

  /* Find mode as it is passed by the ABI.  */
  unsignedp = TYPE_UNSIGNED (type);
  mode = promote_mode (type, TYPE_MODE (type), &unsignedp);

  /* If we must pass in stack, we need a stack.  */
  if (rs6000_must_pass_in_stack (mode, type))
    return true;

  /* If there is no incoming register, we need a stack.  */
  entry_parm = rs6000_function_arg (args_so_far, mode, type, true);
  if (entry_parm == NULL)
    return true;

  /* Likewise if we need to pass both in registers and on the stack.  */
  if (GET_CODE (entry_parm) == PARALLEL
      && XEXP (XVECEXP (entry_parm, 0, 0), 0) == NULL_RTX)
    return true;

  /* Also true if we're partially in registers and partially not.  */
  if (rs6000_arg_partial_bytes (args_so_far, mode, type, true) != 0)
    return true;

  /* Update info on where next arg arrives in registers.  */
  rs6000_function_arg_advance (args_so_far, mode, type, true);
  return false;
}

/* Return true if FUN has no prototype, has a variable argument
   list, or passes any parameter in memory.  */

static bool
rs6000_function_parms_need_stack (tree fun, bool incoming)
{
  tree fntype, result;
  CUMULATIVE_ARGS args_so_far_v;
  cumulative_args_t args_so_far;

  if (!fun)
    /* Must be a libcall, all of which only use reg parms.  */
    return false;

  fntype = fun;
  if (!TYPE_P (fun))
    fntype = TREE_TYPE (fun);

  /* Varargs functions need the parameter save area.  */
  if ((!incoming && !prototype_p (fntype)) || stdarg_p (fntype))
    return true;

  INIT_CUMULATIVE_INCOMING_ARGS (args_so_far_v, fntype, NULL_RTX);
  args_so_far = pack_cumulative_args (&args_so_far_v);

  /* When incoming, we will have been passed the function decl.
     It is necessary to use the decl to handle K&R style functions,
     where TYPE_ARG_TYPES may not be available.  */
  if (incoming)
    {
      gcc_assert (DECL_P (fun));
      result = DECL_RESULT (fun);
    }
  else
    result = TREE_TYPE (fntype);

  if (result && aggregate_value_p (result, fntype))
    {
      if (!TYPE_P (result))
	result = TREE_TYPE (result);
      result = build_pointer_type (result);
      rs6000_parm_needs_stack (args_so_far, result);
    }

  if (incoming)
    {
      tree parm;

      for (parm = DECL_ARGUMENTS (fun);
	   parm && parm != void_list_node;
	   parm = TREE_CHAIN (parm))
	if (rs6000_parm_needs_stack (args_so_far, TREE_TYPE (parm)))
	  return true;
    }
  else
    {
      function_args_iterator args_iter;
      tree arg_type;

      FOREACH_FUNCTION_ARGS (fntype, arg_type, args_iter)
	if (rs6000_parm_needs_stack (args_so_far, arg_type))
	  return true;
    }

  return false;
}

/* Return the size of the REG_PARM_STACK_SPACE are for FUN.  This is
   usually a constant depending on the ABI.  However, in the ELFv2 ABI
   the register parameter area is optional when calling a function that
   has a prototype is scope, has no variable argument list, and passes
   all parameters in registers.  */

int
rs6000_reg_parm_stack_space (tree fun, bool incoming)
{
  int reg_parm_stack_space;

  switch (DEFAULT_ABI)
    {
    default:
      reg_parm_stack_space = 0;
      break;

    case ABI_AIX:
    case ABI_DARWIN:
      reg_parm_stack_space = TARGET_64BIT ? 64 : 32;
      break;

    case ABI_ELFv2:
      /* ??? Recomputing this every time is a bit expensive.  Is there
	 a place to cache this information?  */
      if (rs6000_function_parms_need_stack (fun, incoming))
	reg_parm_stack_space = TARGET_64BIT ? 64 : 32;
      else
	reg_parm_stack_space = 0;
      break;
    }

  return reg_parm_stack_space;
}

static void
rs6000_move_block_from_reg (int regno, rtx x, int nregs)
{
  int i;
  machine_mode reg_mode = TARGET_32BIT ? SImode : DImode;

  if (nregs == 0)
    return;

  for (i = 0; i < nregs; i++)
    {
      rtx tem = adjust_address_nv (x, reg_mode, i * GET_MODE_SIZE (reg_mode));
      if (reload_completed)
	{
	  if (! strict_memory_address_p (reg_mode, XEXP (tem, 0)))
	    tem = NULL_RTX;
	  else
	    tem = simplify_gen_subreg (reg_mode, x, BLKmode,
				       i * GET_MODE_SIZE (reg_mode));
	}
      else
	tem = replace_equiv_address (tem, XEXP (tem, 0));

      gcc_assert (tem);

      emit_move_insn (tem, gen_rtx_REG (reg_mode, regno + i));
    }
}

/* Perform any needed actions needed for a function that is receiving a
   variable number of arguments.

   CUM is as above.

   MODE and TYPE are the mode and type of the current parameter.

   PRETEND_SIZE is a variable that should be set to the amount of stack
   that must be pushed by the prolog to pretend that our caller pushed
   it.

   Normally, this macro will push all remaining incoming registers on the
   stack and set PRETEND_SIZE to the length of the registers pushed.  */

static void
setup_incoming_varargs (cumulative_args_t cum, machine_mode mode,
			tree type, int *pretend_size ATTRIBUTE_UNUSED,
			int no_rtl)
{
  CUMULATIVE_ARGS next_cum;
  int reg_size = TARGET_32BIT ? 4 : 8;
  rtx save_area = NULL_RTX, mem;
  int first_reg_offset;
  alias_set_type set;

  /* Skip the last named argument.  */
  next_cum = *get_cumulative_args (cum);
  rs6000_function_arg_advance_1 (&next_cum, mode, type, true, 0);

  if (DEFAULT_ABI == ABI_V4)
    {
      first_reg_offset = next_cum.sysv_gregno - GP_ARG_MIN_REG;

      if (! no_rtl)
	{
	  int gpr_reg_num = 0, gpr_size = 0, fpr_size = 0;
	  HOST_WIDE_INT offset = 0;

	  /* Try to optimize the size of the varargs save area.
	     The ABI requires that ap.reg_save_area is doubleword
	     aligned, but we don't need to allocate space for all
	     the bytes, only those to which we actually will save
	     anything.  */
	  if (cfun->va_list_gpr_size && first_reg_offset < GP_ARG_NUM_REG)
	    gpr_reg_num = GP_ARG_NUM_REG - first_reg_offset;
	  if (TARGET_HARD_FLOAT
	      && next_cum.fregno <= FP_ARG_V4_MAX_REG
	      && cfun->va_list_fpr_size)
	    {
	      if (gpr_reg_num)
		fpr_size = (next_cum.fregno - FP_ARG_MIN_REG)
			   * UNITS_PER_FP_WORD;
	      if (cfun->va_list_fpr_size
		  < FP_ARG_V4_MAX_REG + 1 - next_cum.fregno)
		fpr_size += cfun->va_list_fpr_size * UNITS_PER_FP_WORD;
	      else
		fpr_size += (FP_ARG_V4_MAX_REG + 1 - next_cum.fregno)
			    * UNITS_PER_FP_WORD;
	    }
	  if (gpr_reg_num)
	    {
	      offset = -((first_reg_offset * reg_size) & ~7);
	      if (!fpr_size && gpr_reg_num > cfun->va_list_gpr_size)
		{
		  gpr_reg_num = cfun->va_list_gpr_size;
		  if (reg_size == 4 && (first_reg_offset & 1))
		    gpr_reg_num++;
		}
	      gpr_size = (gpr_reg_num * reg_size + 7) & ~7;
	    }
	  else if (fpr_size)
	    offset = - (int) (next_cum.fregno - FP_ARG_MIN_REG)
		       * UNITS_PER_FP_WORD
		     - (int) (GP_ARG_NUM_REG * reg_size);

	  if (gpr_size + fpr_size)
	    {
	      rtx reg_save_area
		= assign_stack_local (BLKmode, gpr_size + fpr_size, 64);
	      gcc_assert (MEM_P (reg_save_area));
	      reg_save_area = XEXP (reg_save_area, 0);
	      if (GET_CODE (reg_save_area) == PLUS)
		{
		  gcc_assert (XEXP (reg_save_area, 0)
			      == virtual_stack_vars_rtx);
		  gcc_assert (CONST_INT_P (XEXP (reg_save_area, 1)));
		  offset += INTVAL (XEXP (reg_save_area, 1));
		}
	      else
		gcc_assert (reg_save_area == virtual_stack_vars_rtx);
	    }

	  cfun->machine->varargs_save_offset = offset;
	  save_area = plus_constant (Pmode, virtual_stack_vars_rtx, offset);
	}
    }
  else
    {
      first_reg_offset = next_cum.words;
      save_area = crtl->args.internal_arg_pointer;

      if (targetm.calls.must_pass_in_stack (mode, type))
	first_reg_offset += rs6000_arg_size (TYPE_MODE (type), type);
    }

  set = get_varargs_alias_set ();
  if (! no_rtl && first_reg_offset < GP_ARG_NUM_REG
      && cfun->va_list_gpr_size)
    {
      int n_gpr, nregs = GP_ARG_NUM_REG - first_reg_offset;

      if (va_list_gpr_counter_field)
	/* V4 va_list_gpr_size counts number of registers needed.  */
	n_gpr = cfun->va_list_gpr_size;
      else
	/* char * va_list instead counts number of bytes needed.  */
	n_gpr = (cfun->va_list_gpr_size + reg_size - 1) / reg_size;

      if (nregs > n_gpr)
	nregs = n_gpr;

      mem = gen_rtx_MEM (BLKmode,
			 plus_constant (Pmode, save_area,
					first_reg_offset * reg_size));
      MEM_NOTRAP_P (mem) = 1;
      set_mem_alias_set (mem, set);
      set_mem_align (mem, BITS_PER_WORD);

      rs6000_move_block_from_reg (GP_ARG_MIN_REG + first_reg_offset, mem,
				  nregs);
    }

  /* Save FP registers if needed.  */
  if (DEFAULT_ABI == ABI_V4
      && TARGET_HARD_FLOAT
      && ! no_rtl
      && next_cum.fregno <= FP_ARG_V4_MAX_REG
      && cfun->va_list_fpr_size)
    {
      int fregno = next_cum.fregno, nregs;
      rtx cr1 = gen_rtx_REG (CCmode, CR1_REGNO);
      rtx lab = gen_label_rtx ();
      int off = (GP_ARG_NUM_REG * reg_size) + ((fregno - FP_ARG_MIN_REG)
					       * UNITS_PER_FP_WORD);

      emit_jump_insn
	(gen_rtx_SET (pc_rtx,
		      gen_rtx_IF_THEN_ELSE (VOIDmode,
					    gen_rtx_NE (VOIDmode, cr1,
							const0_rtx),
					    gen_rtx_LABEL_REF (VOIDmode, lab),
					    pc_rtx)));

      for (nregs = 0;
	   fregno <= FP_ARG_V4_MAX_REG && nregs < cfun->va_list_fpr_size;
	   fregno++, off += UNITS_PER_FP_WORD, nregs++)
	{
	  mem = gen_rtx_MEM (TARGET_HARD_FLOAT ? DFmode : SFmode,
                             plus_constant (Pmode, save_area, off));
  	  MEM_NOTRAP_P (mem) = 1;
  	  set_mem_alias_set (mem, set);
	  set_mem_align (mem, GET_MODE_ALIGNMENT (
			 TARGET_HARD_FLOAT ? DFmode : SFmode));
	  emit_move_insn (mem, gen_rtx_REG (
                          TARGET_HARD_FLOAT ? DFmode : SFmode, fregno));
	}

      emit_label (lab);
    }
}

/* Create the va_list data type.  */

static tree
rs6000_build_builtin_va_list (void)
{
  tree f_gpr, f_fpr, f_res, f_ovf, f_sav, record, type_decl;

  /* For AIX, prefer 'char *' because that's what the system
     header files like.  */
  if (DEFAULT_ABI != ABI_V4)
    return build_pointer_type (char_type_node);

  record = (*lang_hooks.types.make_type) (RECORD_TYPE);
  type_decl = build_decl (BUILTINS_LOCATION, TYPE_DECL,
      			  get_identifier ("__va_list_tag"), record);

  f_gpr = build_decl (BUILTINS_LOCATION, FIELD_DECL, get_identifier ("gpr"),
		      unsigned_char_type_node);
  f_fpr = build_decl (BUILTINS_LOCATION, FIELD_DECL, get_identifier ("fpr"),
		      unsigned_char_type_node);
  /* Give the two bytes of padding a name, so that -Wpadded won't warn on
     every user file.  */
  f_res = build_decl (BUILTINS_LOCATION, FIELD_DECL,
      		      get_identifier ("reserved"), short_unsigned_type_node);
  f_ovf = build_decl (BUILTINS_LOCATION, FIELD_DECL,
      		      get_identifier ("overflow_arg_area"),
		      ptr_type_node);
  f_sav = build_decl (BUILTINS_LOCATION, FIELD_DECL,
      		      get_identifier ("reg_save_area"),
		      ptr_type_node);

  va_list_gpr_counter_field = f_gpr;
  va_list_fpr_counter_field = f_fpr;

  DECL_FIELD_CONTEXT (f_gpr) = record;
  DECL_FIELD_CONTEXT (f_fpr) = record;
  DECL_FIELD_CONTEXT (f_res) = record;
  DECL_FIELD_CONTEXT (f_ovf) = record;
  DECL_FIELD_CONTEXT (f_sav) = record;

  TYPE_STUB_DECL (record) = type_decl;
  TYPE_NAME (record) = type_decl;
  TYPE_FIELDS (record) = f_gpr;
  DECL_CHAIN (f_gpr) = f_fpr;
  DECL_CHAIN (f_fpr) = f_res;
  DECL_CHAIN (f_res) = f_ovf;
  DECL_CHAIN (f_ovf) = f_sav;

  layout_type (record);

  /* The correct type is an array type of one element.  */
  return build_array_type (record, build_index_type (size_zero_node));
}

/* Implement va_start.  */

static void
rs6000_va_start (tree valist, rtx nextarg)
{
  HOST_WIDE_INT words, n_gpr, n_fpr;
  tree f_gpr, f_fpr, f_res, f_ovf, f_sav;
  tree gpr, fpr, ovf, sav, t;

  /* Only SVR4 needs something special.  */
  if (DEFAULT_ABI != ABI_V4)
    {
      std_expand_builtin_va_start (valist, nextarg);
      return;
    }

  f_gpr = TYPE_FIELDS (TREE_TYPE (va_list_type_node));
  f_fpr = DECL_CHAIN (f_gpr);
  f_res = DECL_CHAIN (f_fpr);
  f_ovf = DECL_CHAIN (f_res);
  f_sav = DECL_CHAIN (f_ovf);

  valist = build_simple_mem_ref (valist);
  gpr = build3 (COMPONENT_REF, TREE_TYPE (f_gpr), valist, f_gpr, NULL_TREE);
  fpr = build3 (COMPONENT_REF, TREE_TYPE (f_fpr), unshare_expr (valist),
		f_fpr, NULL_TREE);
  ovf = build3 (COMPONENT_REF, TREE_TYPE (f_ovf), unshare_expr (valist),
		f_ovf, NULL_TREE);
  sav = build3 (COMPONENT_REF, TREE_TYPE (f_sav), unshare_expr (valist),
		f_sav, NULL_TREE);

  /* Count number of gp and fp argument registers used.  */
  words = crtl->args.info.words;
  n_gpr = MIN (crtl->args.info.sysv_gregno - GP_ARG_MIN_REG,
	       GP_ARG_NUM_REG);
  n_fpr = MIN (crtl->args.info.fregno - FP_ARG_MIN_REG,
	       FP_ARG_NUM_REG);

  if (TARGET_DEBUG_ARG)
    fprintf (stderr, "va_start: words = " HOST_WIDE_INT_PRINT_DEC", n_gpr = "
	     HOST_WIDE_INT_PRINT_DEC", n_fpr = " HOST_WIDE_INT_PRINT_DEC"\n",
	     words, n_gpr, n_fpr);

  if (cfun->va_list_gpr_size)
    {
      t = build2 (MODIFY_EXPR, TREE_TYPE (gpr), gpr,
		  build_int_cst (NULL_TREE, n_gpr));
      TREE_SIDE_EFFECTS (t) = 1;
      expand_expr (t, const0_rtx, VOIDmode, EXPAND_NORMAL);
    }

  if (cfun->va_list_fpr_size)
    {
      t = build2 (MODIFY_EXPR, TREE_TYPE (fpr), fpr,
		  build_int_cst (NULL_TREE, n_fpr));
      TREE_SIDE_EFFECTS (t) = 1;
      expand_expr (t, const0_rtx, VOIDmode, EXPAND_NORMAL);

#ifdef HAVE_AS_GNU_ATTRIBUTE
      if (call_ABI_of_interest (cfun->decl))
	rs6000_passes_float = true;
#endif
    }

  /* Find the overflow area.  */
  t = make_tree (TREE_TYPE (ovf), crtl->args.internal_arg_pointer);
  if (words != 0)
    t = fold_build_pointer_plus_hwi (t, words * MIN_UNITS_PER_WORD);
  t = build2 (MODIFY_EXPR, TREE_TYPE (ovf), ovf, t);
  TREE_SIDE_EFFECTS (t) = 1;
  expand_expr (t, const0_rtx, VOIDmode, EXPAND_NORMAL);

  /* If there were no va_arg invocations, don't set up the register
     save area.  */
  if (!cfun->va_list_gpr_size
      && !cfun->va_list_fpr_size
      && n_gpr < GP_ARG_NUM_REG
      && n_fpr < FP_ARG_V4_MAX_REG)
    return;

  /* Find the register save area.  */
  t = make_tree (TREE_TYPE (sav), virtual_stack_vars_rtx);
  if (cfun->machine->varargs_save_offset)
    t = fold_build_pointer_plus_hwi (t, cfun->machine->varargs_save_offset);
  t = build2 (MODIFY_EXPR, TREE_TYPE (sav), sav, t);
  TREE_SIDE_EFFECTS (t) = 1;
  expand_expr (t, const0_rtx, VOIDmode, EXPAND_NORMAL);
}

/* Implement va_arg.  */

static tree
rs6000_gimplify_va_arg (tree valist, tree type, gimple_seq *pre_p,
			gimple_seq *post_p)
{
  tree f_gpr, f_fpr, f_res, f_ovf, f_sav;
  tree gpr, fpr, ovf, sav, reg, t, u;
  int size, rsize, n_reg, sav_ofs, sav_scale;
  tree lab_false, lab_over, addr;
  int align;
  tree ptrtype = build_pointer_type_for_mode (type, ptr_mode, true);
  int regalign = 0;
  gimple *stmt;

  if (pass_by_reference (NULL, TYPE_MODE (type), type, false))
    {
      t = rs6000_gimplify_va_arg (valist, ptrtype, pre_p, post_p);
      return build_va_arg_indirect_ref (t);
    }

  /* We need to deal with the fact that the darwin ppc64 ABI is defined by an
     earlier version of gcc, with the property that it always applied alignment
     adjustments to the va-args (even for zero-sized types).  The cheapest way
     to deal with this is to replicate the effect of the part of 
     std_gimplify_va_arg_expr that carries out the align adjust, for the case 
     of relevance.  
     We don't need to check for pass-by-reference because of the test above.
     We can return a simplifed answer, since we know there's no offset to add.  */

  if (((TARGET_MACHO
        && rs6000_darwin64_abi)
       || DEFAULT_ABI == ABI_ELFv2
       || (DEFAULT_ABI == ABI_AIX && !rs6000_compat_align_parm))
      && integer_zerop (TYPE_SIZE (type)))
    {
      unsigned HOST_WIDE_INT align, boundary;
      tree valist_tmp = get_initialized_tmp_var (valist, pre_p, NULL);
      align = PARM_BOUNDARY / BITS_PER_UNIT;
      boundary = rs6000_function_arg_boundary (TYPE_MODE (type), type);
      if (boundary > MAX_SUPPORTED_STACK_ALIGNMENT)
	boundary = MAX_SUPPORTED_STACK_ALIGNMENT;
      boundary /= BITS_PER_UNIT;
      if (boundary > align)
	{
	  tree t ;
	  /* This updates arg ptr by the amount that would be necessary
	     to align the zero-sized (but not zero-alignment) item.  */
	  t = build2 (MODIFY_EXPR, TREE_TYPE (valist), valist_tmp,
		      fold_build_pointer_plus_hwi (valist_tmp, boundary - 1));
	  gimplify_and_add (t, pre_p);

	  t = fold_convert (sizetype, valist_tmp);
	  t = build2 (MODIFY_EXPR, TREE_TYPE (valist), valist_tmp,
		  fold_convert (TREE_TYPE (valist),
				fold_build2 (BIT_AND_EXPR, sizetype, t,
					     size_int (-boundary))));
	  t = build2 (MODIFY_EXPR, TREE_TYPE (valist), valist, t);
	  gimplify_and_add (t, pre_p);
	}
      /* Since it is zero-sized there's no increment for the item itself. */
      valist_tmp = fold_convert (build_pointer_type (type), valist_tmp);
      return build_va_arg_indirect_ref (valist_tmp);
    }

  if (DEFAULT_ABI != ABI_V4)
    {
      if (targetm.calls.split_complex_arg && TREE_CODE (type) == COMPLEX_TYPE)
	{
	  tree elem_type = TREE_TYPE (type);
	  machine_mode elem_mode = TYPE_MODE (elem_type);
	  int elem_size = GET_MODE_SIZE (elem_mode);

	  if (elem_size < UNITS_PER_WORD)
	    {
	      tree real_part, imag_part;
	      gimple_seq post = NULL;

	      real_part = rs6000_gimplify_va_arg (valist, elem_type, pre_p,
						  &post);
	      /* Copy the value into a temporary, lest the formal temporary
		 be reused out from under us.  */
	      real_part = get_initialized_tmp_var (real_part, pre_p, &post);
	      gimple_seq_add_seq (pre_p, post);

	      imag_part = rs6000_gimplify_va_arg (valist, elem_type, pre_p,
						  post_p);

	      return build2 (COMPLEX_EXPR, type, real_part, imag_part);
	    }
	}

      return std_gimplify_va_arg_expr (valist, type, pre_p, post_p);
    }

  f_gpr = TYPE_FIELDS (TREE_TYPE (va_list_type_node));
  f_fpr = DECL_CHAIN (f_gpr);
  f_res = DECL_CHAIN (f_fpr);
  f_ovf = DECL_CHAIN (f_res);
  f_sav = DECL_CHAIN (f_ovf);

  gpr = build3 (COMPONENT_REF, TREE_TYPE (f_gpr), valist, f_gpr, NULL_TREE);
  fpr = build3 (COMPONENT_REF, TREE_TYPE (f_fpr), unshare_expr (valist),
		f_fpr, NULL_TREE);
  ovf = build3 (COMPONENT_REF, TREE_TYPE (f_ovf), unshare_expr (valist),
		f_ovf, NULL_TREE);
  sav = build3 (COMPONENT_REF, TREE_TYPE (f_sav), unshare_expr (valist),
		f_sav, NULL_TREE);

  size = int_size_in_bytes (type);
  rsize = (size + 3) / 4;
  int pad = 4 * rsize - size;
  align = 1;

  machine_mode mode = TYPE_MODE (type);
  if (abi_v4_pass_in_fpr (mode, false))
    {
      /* FP args go in FP registers, if present.  */
      reg = fpr;
      n_reg = (size + 7) / 8;
      sav_ofs = (TARGET_HARD_FLOAT ? 8 : 4) * 4;
      sav_scale = (TARGET_HARD_FLOAT ? 8 : 4);
      if (mode != SFmode && mode != SDmode)
	align = 8;
    }
  else
    {
      /* Otherwise into GP registers.  */
      reg = gpr;
      n_reg = rsize;
      sav_ofs = 0;
      sav_scale = 4;
      if (n_reg == 2)
	align = 8;
    }

  /* Pull the value out of the saved registers....  */

  lab_over = NULL;
  addr = create_tmp_var (ptr_type_node, "addr");

  /*  AltiVec vectors never go in registers when -mabi=altivec.  */
  if (TARGET_ALTIVEC_ABI && ALTIVEC_VECTOR_MODE (mode))
    align = 16;
  else
    {
      lab_false = create_artificial_label (input_location);
      lab_over = create_artificial_label (input_location);

      /* Long long is aligned in the registers.  As are any other 2 gpr
	 item such as complex int due to a historical mistake.  */
      u = reg;
      if (n_reg == 2 && reg == gpr)
	{
	  regalign = 1;
	  u = build2 (BIT_AND_EXPR, TREE_TYPE (reg), unshare_expr (reg),
		     build_int_cst (TREE_TYPE (reg), n_reg - 1));
	  u = build2 (POSTINCREMENT_EXPR, TREE_TYPE (reg),
		      unshare_expr (reg), u);
	}
      /* _Decimal128 is passed in even/odd fpr pairs; the stored
	 reg number is 0 for f1, so we want to make it odd.  */
      else if (reg == fpr && mode == TDmode)
	{
	  t = build2 (BIT_IOR_EXPR, TREE_TYPE (reg), unshare_expr (reg),
		      build_int_cst (TREE_TYPE (reg), 1));
	  u = build2 (MODIFY_EXPR, void_type_node, unshare_expr (reg), t);
	}

      t = fold_convert (TREE_TYPE (reg), size_int (8 - n_reg + 1));
      t = build2 (GE_EXPR, boolean_type_node, u, t);
      u = build1 (GOTO_EXPR, void_type_node, lab_false);
      t = build3 (COND_EXPR, void_type_node, t, u, NULL_TREE);
      gimplify_and_add (t, pre_p);

      t = sav;
      if (sav_ofs)
	t = fold_build_pointer_plus_hwi (sav, sav_ofs);

      u = build2 (POSTINCREMENT_EXPR, TREE_TYPE (reg), unshare_expr (reg),
		  build_int_cst (TREE_TYPE (reg), n_reg));
      u = fold_convert (sizetype, u);
      u = build2 (MULT_EXPR, sizetype, u, size_int (sav_scale));
      t = fold_build_pointer_plus (t, u);

      /* _Decimal32 varargs are located in the second word of the 64-bit
	 FP register for 32-bit binaries.  */
      if (TARGET_32BIT && TARGET_HARD_FLOAT && mode == SDmode)
	t = fold_build_pointer_plus_hwi (t, size);

      /* Args are passed right-aligned.  */
      if (BYTES_BIG_ENDIAN)
	t = fold_build_pointer_plus_hwi (t, pad);

      gimplify_assign (addr, t, pre_p);

      gimple_seq_add_stmt (pre_p, gimple_build_goto (lab_over));

      stmt = gimple_build_label (lab_false);
      gimple_seq_add_stmt (pre_p, stmt);

      if ((n_reg == 2 && !regalign) || n_reg > 2)
	{
	  /* Ensure that we don't find any more args in regs.
	     Alignment has taken care of for special cases.  */
	  gimplify_assign (reg, build_int_cst (TREE_TYPE (reg), 8), pre_p);
	}
    }

  /* ... otherwise out of the overflow area.  */

  /* Care for on-stack alignment if needed.  */
  t = ovf;
  if (align != 1)
    {
      t = fold_build_pointer_plus_hwi (t, align - 1);
      t = build2 (BIT_AND_EXPR, TREE_TYPE (t), t,
		  build_int_cst (TREE_TYPE (t), -align));
    }

  /* Args are passed right-aligned.  */
  if (BYTES_BIG_ENDIAN)
    t = fold_build_pointer_plus_hwi (t, pad);

  gimplify_expr (&t, pre_p, NULL, is_gimple_val, fb_rvalue);

  gimplify_assign (unshare_expr (addr), t, pre_p);

  t = fold_build_pointer_plus_hwi (t, size);
  gimplify_assign (unshare_expr (ovf), t, pre_p);

  if (lab_over)
    {
      stmt = gimple_build_label (lab_over);
      gimple_seq_add_stmt (pre_p, stmt);
    }

  if (STRICT_ALIGNMENT
      && (TYPE_ALIGN (type)
	  > (unsigned) BITS_PER_UNIT * (align < 4 ? 4 : align)))
    {
      /* The value (of type complex double, for example) may not be
	 aligned in memory in the saved registers, so copy via a
	 temporary.  (This is the same code as used for SPARC.)  */
      tree tmp = create_tmp_var (type, "va_arg_tmp");
      tree dest_addr = build_fold_addr_expr (tmp);

      tree copy = build_call_expr (builtin_decl_implicit (BUILT_IN_MEMCPY),
				   3, dest_addr, addr, size_int (rsize * 4));
      TREE_ADDRESSABLE (tmp) = 1;

      gimplify_and_add (copy, pre_p);
      addr = dest_addr;
    }

  addr = fold_convert (ptrtype, addr);
  return build_va_arg_indirect_ref (addr);
}

/* Builtins.  */

static void
def_builtin (const char *name, tree type, enum rs6000_builtins code)
{
  tree t;
  unsigned classify = rs6000_builtin_info[(int)code].attr;
  const char *attr_string = "";

  gcc_assert (name != NULL);
  gcc_assert (IN_RANGE ((int)code, 0, (int)RS6000_BUILTIN_COUNT));

  if (rs6000_builtin_decls[(int)code])
    fatal_error (input_location,
		 "internal error: builtin function %qs already processed",
		 name);

  rs6000_builtin_decls[(int)code] = t =
    add_builtin_function (name, type, (int)code, BUILT_IN_MD, NULL, NULL_TREE);

  /* Set any special attributes.  */
  if ((classify & RS6000_BTC_CONST) != 0)
    {
      /* const function, function only depends on the inputs.  */
      TREE_READONLY (t) = 1;
      TREE_NOTHROW (t) = 1;
      attr_string = ", const";
    }
  else if ((classify & RS6000_BTC_PURE) != 0)
    {
      /* pure function, function can read global memory, but does not set any
	 external state.  */
      DECL_PURE_P (t) = 1;
      TREE_NOTHROW (t) = 1;
      attr_string = ", pure";
    }
  else if ((classify & RS6000_BTC_FP) != 0)
    {
      /* Function is a math function.  If rounding mode is on, then treat the
	 function as not reading global memory, but it can have arbitrary side
	 effects.  If it is off, then assume the function is a const function.
	 This mimics the ATTR_MATHFN_FPROUNDING attribute in
	 builtin-attribute.def that is used for the math functions. */
      TREE_NOTHROW (t) = 1;
      if (flag_rounding_math)
	{
	  DECL_PURE_P (t) = 1;
	  DECL_IS_NOVOPS (t) = 1;
	  attr_string = ", fp, pure";
	}
      else
	{
	  TREE_READONLY (t) = 1;
	  attr_string = ", fp, const";
	}
    }
  else if ((classify & RS6000_BTC_ATTR_MASK) != 0)
    gcc_unreachable ();

  if (TARGET_DEBUG_BUILTIN)
    fprintf (stderr, "rs6000_builtin, code = %4d, %s%s\n",
	     (int)code, name, attr_string);
}

/* Simple ternary operations: VECd = foo (VECa, VECb, VECc).  */

#undef RS6000_BUILTIN_0
#undef RS6000_BUILTIN_1
#undef RS6000_BUILTIN_2
#undef RS6000_BUILTIN_3
#undef RS6000_BUILTIN_A
#undef RS6000_BUILTIN_D
#undef RS6000_BUILTIN_H
#undef RS6000_BUILTIN_P
#undef RS6000_BUILTIN_X

#define RS6000_BUILTIN_0(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_1(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_2(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_3(ENUM, NAME, MASK, ATTR, ICODE) \
  { MASK, ICODE, NAME, ENUM },

#define RS6000_BUILTIN_A(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_D(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_H(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_P(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_X(ENUM, NAME, MASK, ATTR, ICODE)

static const struct builtin_description bdesc_3arg[] =
{
#include "rs6000-builtin.def"
};

/* DST operations: void foo (void *, const int, const char).  */

#undef RS6000_BUILTIN_0
#undef RS6000_BUILTIN_1
#undef RS6000_BUILTIN_2
#undef RS6000_BUILTIN_3
#undef RS6000_BUILTIN_A
#undef RS6000_BUILTIN_D
#undef RS6000_BUILTIN_H
#undef RS6000_BUILTIN_P
#undef RS6000_BUILTIN_X

#define RS6000_BUILTIN_0(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_1(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_2(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_3(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_A(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_D(ENUM, NAME, MASK, ATTR, ICODE) \
  { MASK, ICODE, NAME, ENUM },

#define RS6000_BUILTIN_H(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_P(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_X(ENUM, NAME, MASK, ATTR, ICODE)

static const struct builtin_description bdesc_dst[] =
{
#include "rs6000-builtin.def"
};

/* Simple binary operations: VECc = foo (VECa, VECb).  */

#undef RS6000_BUILTIN_0
#undef RS6000_BUILTIN_1
#undef RS6000_BUILTIN_2
#undef RS6000_BUILTIN_3
#undef RS6000_BUILTIN_A
#undef RS6000_BUILTIN_D
#undef RS6000_BUILTIN_H
#undef RS6000_BUILTIN_P
#undef RS6000_BUILTIN_X

#define RS6000_BUILTIN_0(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_1(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_2(ENUM, NAME, MASK, ATTR, ICODE) \
  { MASK, ICODE, NAME, ENUM },

#define RS6000_BUILTIN_3(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_A(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_D(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_H(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_P(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_X(ENUM, NAME, MASK, ATTR, ICODE)

static const struct builtin_description bdesc_2arg[] =
{
#include "rs6000-builtin.def"
};

#undef RS6000_BUILTIN_0
#undef RS6000_BUILTIN_1
#undef RS6000_BUILTIN_2
#undef RS6000_BUILTIN_3
#undef RS6000_BUILTIN_A
#undef RS6000_BUILTIN_D
#undef RS6000_BUILTIN_H
#undef RS6000_BUILTIN_P
#undef RS6000_BUILTIN_X

#define RS6000_BUILTIN_0(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_1(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_2(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_3(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_A(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_D(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_H(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_P(ENUM, NAME, MASK, ATTR, ICODE) \
  { MASK, ICODE, NAME, ENUM },

#define RS6000_BUILTIN_X(ENUM, NAME, MASK, ATTR, ICODE)

/* AltiVec predicates.  */

static const struct builtin_description bdesc_altivec_preds[] =
{
#include "rs6000-builtin.def"
};

/* ABS* operations.  */

#undef RS6000_BUILTIN_0
#undef RS6000_BUILTIN_1
#undef RS6000_BUILTIN_2
#undef RS6000_BUILTIN_3
#undef RS6000_BUILTIN_A
#undef RS6000_BUILTIN_D
#undef RS6000_BUILTIN_H
#undef RS6000_BUILTIN_P
#undef RS6000_BUILTIN_X

#define RS6000_BUILTIN_0(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_1(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_2(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_3(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_A(ENUM, NAME, MASK, ATTR, ICODE) \
  { MASK, ICODE, NAME, ENUM },

#define RS6000_BUILTIN_D(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_H(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_P(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_X(ENUM, NAME, MASK, ATTR, ICODE)

static const struct builtin_description bdesc_abs[] =
{
#include "rs6000-builtin.def"
};

/* Simple unary operations: VECb = foo (unsigned literal) or VECb =
   foo (VECa).  */

#undef RS6000_BUILTIN_0
#undef RS6000_BUILTIN_1
#undef RS6000_BUILTIN_2
#undef RS6000_BUILTIN_3
#undef RS6000_BUILTIN_A
#undef RS6000_BUILTIN_D
#undef RS6000_BUILTIN_H
#undef RS6000_BUILTIN_P
#undef RS6000_BUILTIN_X

#define RS6000_BUILTIN_0(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_1(ENUM, NAME, MASK, ATTR, ICODE) \
  { MASK, ICODE, NAME, ENUM },

#define RS6000_BUILTIN_2(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_3(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_A(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_D(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_H(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_P(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_X(ENUM, NAME, MASK, ATTR, ICODE)

static const struct builtin_description bdesc_1arg[] =
{
#include "rs6000-builtin.def"
};

/* Simple no-argument operations: result = __builtin_darn_32 () */

#undef RS6000_BUILTIN_0
#undef RS6000_BUILTIN_1
#undef RS6000_BUILTIN_2
#undef RS6000_BUILTIN_3
#undef RS6000_BUILTIN_A
#undef RS6000_BUILTIN_D
#undef RS6000_BUILTIN_H
#undef RS6000_BUILTIN_P
#undef RS6000_BUILTIN_X

#define RS6000_BUILTIN_0(ENUM, NAME, MASK, ATTR, ICODE) \
  { MASK, ICODE, NAME, ENUM },

#define RS6000_BUILTIN_1(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_2(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_3(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_A(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_D(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_H(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_P(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_X(ENUM, NAME, MASK, ATTR, ICODE)

static const struct builtin_description bdesc_0arg[] =
{
#include "rs6000-builtin.def"
};

/* HTM builtins.  */
#undef RS6000_BUILTIN_0
#undef RS6000_BUILTIN_1
#undef RS6000_BUILTIN_2
#undef RS6000_BUILTIN_3
#undef RS6000_BUILTIN_A
#undef RS6000_BUILTIN_D
#undef RS6000_BUILTIN_H
#undef RS6000_BUILTIN_P
#undef RS6000_BUILTIN_X

#define RS6000_BUILTIN_0(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_1(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_2(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_3(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_A(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_D(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_H(ENUM, NAME, MASK, ATTR, ICODE) \
  { MASK, ICODE, NAME, ENUM },

#define RS6000_BUILTIN_P(ENUM, NAME, MASK, ATTR, ICODE)
#define RS6000_BUILTIN_X(ENUM, NAME, MASK, ATTR, ICODE)

static const struct builtin_description bdesc_htm[] =
{
#include "rs6000-builtin.def"
};

#undef RS6000_BUILTIN_0
#undef RS6000_BUILTIN_1
#undef RS6000_BUILTIN_2
#undef RS6000_BUILTIN_3
#undef RS6000_BUILTIN_A
#undef RS6000_BUILTIN_D
#undef RS6000_BUILTIN_H
#undef RS6000_BUILTIN_P

/* Return true if a builtin function is overloaded.  */
bool
rs6000_overloaded_builtin_p (enum rs6000_builtins fncode)
{
  return (rs6000_builtin_info[(int)fncode].attr & RS6000_BTC_OVERLOADED) != 0;
}

const char *
rs6000_overloaded_builtin_name (enum rs6000_builtins fncode)
{
  return rs6000_builtin_info[(int)fncode].name;
}

/* Expand an expression EXP that calls a builtin without arguments.  */
static rtx
rs6000_expand_zeroop_builtin (enum insn_code icode, rtx target)
{
  rtx pat;
  machine_mode tmode = insn_data[icode].operand[0].mode;

  if (icode == CODE_FOR_nothing)
    /* Builtin not supported on this processor.  */
    return 0;

  if (icode == CODE_FOR_rs6000_mffsl
      && rs6000_isa_flags & OPTION_MASK_SOFT_FLOAT)
    {
      error ("%<__builtin_mffsl%> not supported with %<-msoft-float%>");
      return const0_rtx;
    }

  if (target == 0
      || GET_MODE (target) != tmode
      || ! (*insn_data[icode].operand[0].predicate) (target, tmode))
    target = gen_reg_rtx (tmode);

  pat = GEN_FCN (icode) (target);
  if (! pat)
    return 0;
  emit_insn (pat);

  return target;
}


static rtx
rs6000_expand_mtfsf_builtin (enum insn_code icode, tree exp)
{
  rtx pat;
  tree arg0 = CALL_EXPR_ARG (exp, 0);
  tree arg1 = CALL_EXPR_ARG (exp, 1);
  rtx op0 = expand_normal (arg0);
  rtx op1 = expand_normal (arg1);
  machine_mode mode0 = insn_data[icode].operand[0].mode;
  machine_mode mode1 = insn_data[icode].operand[1].mode;

  if (icode == CODE_FOR_nothing)
    /* Builtin not supported on this processor.  */
    return 0;

  /* If we got invalid arguments bail out before generating bad rtl.  */
  if (arg0 == error_mark_node || arg1 == error_mark_node)
    return const0_rtx;

  if (!CONST_INT_P (op0)
      || INTVAL (op0) > 255
      || INTVAL (op0) < 0)
    {
      error ("argument 1 must be an 8-bit field value");
      return const0_rtx;
    }

  if (! (*insn_data[icode].operand[0].predicate) (op0, mode0))
    op0 = copy_to_mode_reg (mode0, op0);

  if (! (*insn_data[icode].operand[1].predicate) (op1, mode1))
    op1 = copy_to_mode_reg (mode1, op1);

  pat = GEN_FCN (icode) (op0, op1);
  if (!pat)
    return const0_rtx;
  emit_insn (pat);

  return NULL_RTX;
}

static rtx
rs6000_expand_mtfsb_builtin (enum insn_code icode, tree exp)
{
  rtx pat;
  tree arg0 = CALL_EXPR_ARG (exp, 0);
  rtx op0 = expand_normal (arg0);

  if (icode == CODE_FOR_nothing)
    /* Builtin not supported on this processor.  */
    return 0;

  if (rs6000_isa_flags & OPTION_MASK_SOFT_FLOAT)
    {
      error ("%<__builtin_mtfsb0%> and %<__builtin_mtfsb1%> not supported with "
	     "%<-msoft-float%>");
      return const0_rtx;
    }

  /* If we got invalid arguments bail out before generating bad rtl.  */
  if (arg0 == error_mark_node)
    return const0_rtx;

  /* Only allow bit numbers 0 to 31.  */
  if (!u5bit_cint_operand (op0, VOIDmode))
    {
       error ("Argument must be a constant between 0 and 31.");
       return const0_rtx;
     }

  pat = GEN_FCN (icode) (op0);
  if (!pat)
    return const0_rtx;
  emit_insn (pat);

  return NULL_RTX;
}

static rtx
rs6000_expand_set_fpscr_rn_builtin (enum insn_code icode, tree exp)
{
  rtx pat;
  tree arg0 = CALL_EXPR_ARG (exp, 0);
  rtx op0 = expand_normal (arg0);
  machine_mode mode0 = insn_data[icode].operand[0].mode;

  if (icode == CODE_FOR_nothing)
    /* Builtin not supported on this processor.  */
    return 0;

  if (rs6000_isa_flags & OPTION_MASK_SOFT_FLOAT)
    {
      error ("%<__builtin_set_fpscr_rn%> not supported with %<-msoft-float%>");
      return const0_rtx;
    }

  /* If we got invalid arguments bail out before generating bad rtl.  */
  if (arg0 == error_mark_node)
    return const0_rtx;

  /* If the argument is a constant, check the range. Argument can only be a
     2-bit value.  Unfortunately, can't check the range of the value at
     compile time if the argument is a variable.  The least significant two
     bits of the argument, regardless of type, are used to set the rounding
     mode.  All other bits are ignored.  */
  if (CONST_INT_P (op0) && !const_0_to_3_operand(op0, VOIDmode))
    {
      error ("Argument must be a value between 0 and 3.");
      return const0_rtx;
    }

  if (! (*insn_data[icode].operand[0].predicate) (op0, mode0))
    op0 = copy_to_mode_reg (mode0, op0);

  pat = GEN_FCN (icode) (op0);
  if (!pat)
    return const0_rtx;
  emit_insn (pat);

  return NULL_RTX;
}
static rtx
rs6000_expand_set_fpscr_drn_builtin (enum insn_code icode, tree exp)
{
  rtx pat;
  tree arg0 = CALL_EXPR_ARG (exp, 0);
  rtx op0 = expand_normal (arg0);
  machine_mode mode0 = insn_data[icode].operand[0].mode;

  if (TARGET_32BIT)
    /* Builtin not supported in 32-bit mode.  */
    fatal_error (input_location,
		 "%<__builtin_set_fpscr_drn%> is not supported "
		 "in 32-bit mode");

  if (rs6000_isa_flags & OPTION_MASK_SOFT_FLOAT)
    {
      error ("%<__builtin_set_fpscr_drn%> not supported with %<-msoft-float%>");
      return const0_rtx;
    }

  if (icode == CODE_FOR_nothing)
    /* Builtin not supported on this processor.  */
    return 0;

  /* If we got invalid arguments bail out before generating bad rtl.  */
  if (arg0 == error_mark_node)
    return const0_rtx;

  /* If the argument is a constant, check the range. Agrument can only be a
     3-bit value.  Unfortunately, can't check the range of the value at
     compile time if the argument is a variable. The least significant two
     bits of the argument, regardless of type, are used to set the rounding
     mode.  All other bits are ignored.  */
  if (CONST_INT_P (op0) && !const_0_to_7_operand(op0, VOIDmode))
   {
      error ("Argument must be a value between 0 and 7.");
      return const0_rtx;
    }

  if (! (*insn_data[icode].operand[0].predicate) (op0, mode0))
    op0 = copy_to_mode_reg (mode0, op0);

  pat = GEN_FCN (icode) (op0);
  if (! pat)
    return const0_rtx;
  emit_insn (pat);

  return NULL_RTX;
}

static rtx
rs6000_expand_unop_builtin (enum insn_code icode, tree exp, rtx target)
{
  rtx pat;
  tree arg0 = CALL_EXPR_ARG (exp, 0);
  rtx op0 = expand_normal (arg0);
  machine_mode tmode = insn_data[icode].operand[0].mode;
  machine_mode mode0 = insn_data[icode].operand[1].mode;

  if (icode == CODE_FOR_nothing)
    /* Builtin not supported on this processor.  */
    return 0;

  /* If we got invalid arguments bail out before generating bad rtl.  */
  if (arg0 == error_mark_node)
    return const0_rtx;

  if (icode == CODE_FOR_altivec_vspltisb
      || icode == CODE_FOR_altivec_vspltish
      || icode == CODE_FOR_altivec_vspltisw)
    {
      /* Only allow 5-bit *signed* literals.  */
      if (!CONST_INT_P (op0)
	  || INTVAL (op0) > 15
	  || INTVAL (op0) < -16)
	{
	  error ("argument 1 must be a 5-bit signed literal");
	  return CONST0_RTX (tmode);
	}
    }

  if (target == 0
      || GET_MODE (target) != tmode
      || ! (*insn_data[icode].operand[0].predicate) (target, tmode))
    target = gen_reg_rtx (tmode);

  if (! (*insn_data[icode].operand[1].predicate) (op0, mode0))
    op0 = copy_to_mode_reg (mode0, op0);

  pat = GEN_FCN (icode) (target, op0);
  if (! pat)
    return 0;
  emit_insn (pat);

  return target;
}

static rtx
altivec_expand_abs_builtin (enum insn_code icode, tree exp, rtx target)
{
  rtx pat, scratch1, scratch2;
  tree arg0 = CALL_EXPR_ARG (exp, 0);
  rtx op0 = expand_normal (arg0);
  machine_mode tmode = insn_data[icode].operand[0].mode;
  machine_mode mode0 = insn_data[icode].operand[1].mode;

  /* If we have invalid arguments, bail out before generating bad rtl.  */
  if (arg0 == error_mark_node)
    return const0_rtx;

  if (target == 0
      || GET_MODE (target) != tmode
      || ! (*insn_data[icode].operand[0].predicate) (target, tmode))
    target = gen_reg_rtx (tmode);

  if (! (*insn_data[icode].operand[1].predicate) (op0, mode0))
    op0 = copy_to_mode_reg (mode0, op0);

  scratch1 = gen_reg_rtx (mode0);
  scratch2 = gen_reg_rtx (mode0);

  pat = GEN_FCN (icode) (target, op0, scratch1, scratch2);
  if (! pat)
    return 0;
  emit_insn (pat);

  return target;
}

static rtx
rs6000_expand_binop_builtin (enum insn_code icode, tree exp, rtx target)
{
  rtx pat;
  tree arg0 = CALL_EXPR_ARG (exp, 0);
  tree arg1 = CALL_EXPR_ARG (exp, 1);
  rtx op0 = expand_normal (arg0);
  rtx op1 = expand_normal (arg1);
  machine_mode tmode = insn_data[icode].operand[0].mode;
  machine_mode mode0 = insn_data[icode].operand[1].mode;
  machine_mode mode1 = insn_data[icode].operand[2].mode;

  if (icode == CODE_FOR_nothing)
    /* Builtin not supported on this processor.  */
    return 0;

  /* If we got invalid arguments bail out before generating bad rtl.  */
  if (arg0 == error_mark_node || arg1 == error_mark_node)
    return const0_rtx;

  if (icode == CODE_FOR_unpackv1ti
	   || icode == CODE_FOR_unpackkf
	   || icode == CODE_FOR_unpacktf
	   || icode == CODE_FOR_unpackif
	   || icode == CODE_FOR_unpacktd)
    {
      /* Only allow 1-bit unsigned literals. */
      STRIP_NOPS (arg1);
      if (TREE_CODE (arg1) != INTEGER_CST
	  || !IN_RANGE (TREE_INT_CST_LOW (arg1), 0, 1))
	{
	  error ("argument 2 must be a 1-bit unsigned literal");
	  return CONST0_RTX (tmode);
	}
    }
  else if (icode == CODE_FOR_altivec_vspltw)
    {
      /* Only allow 2-bit unsigned literals.  */
      STRIP_NOPS (arg1);
      if (TREE_CODE (arg1) != INTEGER_CST
	  || TREE_INT_CST_LOW (arg1) & ~3)
	{
	  error ("argument 2 must be a 2-bit unsigned literal");
	  return CONST0_RTX (tmode);
	}
    }
  else if (icode == CODE_FOR_altivec_vsplth)
    {
      /* Only allow 3-bit unsigned literals.  */
      STRIP_NOPS (arg1);
      if (TREE_CODE (arg1) != INTEGER_CST
	  || TREE_INT_CST_LOW (arg1) & ~7)
	{
	  error ("argument 2 must be a 3-bit unsigned literal");
	  return CONST0_RTX (tmode);
	}
    }
  else if (icode == CODE_FOR_altivec_vspltb)
    {
      /* Only allow 4-bit unsigned literals.  */
      STRIP_NOPS (arg1);
      if (TREE_CODE (arg1) != INTEGER_CST
	  || TREE_INT_CST_LOW (arg1) & ~15)
	{
	  error ("argument 2 must be a 4-bit unsigned literal");
	  return CONST0_RTX (tmode);
	}
    }
  else if (icode == CODE_FOR_altivec_vcfux
      || icode == CODE_FOR_altivec_vcfsx
      || icode == CODE_FOR_altivec_vctsxs
      || icode == CODE_FOR_altivec_vctuxs)
    {
      /* Only allow 5-bit unsigned literals.  */
      STRIP_NOPS (arg1);
      if (TREE_CODE (arg1) != INTEGER_CST
	  || TREE_INT_CST_LOW (arg1) & ~0x1f)
	{
	  error ("argument 2 must be a 5-bit unsigned literal");
	  return CONST0_RTX (tmode);
	}
    }
  else if (icode == CODE_FOR_dfptstsfi_eq_dd
      || icode == CODE_FOR_dfptstsfi_lt_dd
      || icode == CODE_FOR_dfptstsfi_gt_dd
      || icode == CODE_FOR_dfptstsfi_unordered_dd
      || icode == CODE_FOR_dfptstsfi_eq_td
      || icode == CODE_FOR_dfptstsfi_lt_td
      || icode == CODE_FOR_dfptstsfi_gt_td
      || icode == CODE_FOR_dfptstsfi_unordered_td)
    {
      /* Only allow 6-bit unsigned literals.  */
      STRIP_NOPS (arg0);
      if (TREE_CODE (arg0) != INTEGER_CST
	  || !IN_RANGE (TREE_INT_CST_LOW (arg0), 0, 63))
	{
	  error ("argument 1 must be a 6-bit unsigned literal");
	  return CONST0_RTX (tmode);
	}
    }
  else if (icode == CODE_FOR_xststdcqp_kf
	   || icode == CODE_FOR_xststdcqp_tf
	   || icode == CODE_FOR_xststdcdp
	   || icode == CODE_FOR_xststdcsp
	   || icode == CODE_FOR_xvtstdcdp
	   || icode == CODE_FOR_xvtstdcsp)
    {
      /* Only allow 7-bit unsigned literals. */
      STRIP_NOPS (arg1);
      if (TREE_CODE (arg1) != INTEGER_CST
	  || !IN_RANGE (TREE_INT_CST_LOW (arg1), 0, 127))
	{
	  error ("argument 2 must be a 7-bit unsigned literal");
	  return CONST0_RTX (tmode);
	}
    }

  if (target == 0
      || GET_MODE (target) != tmode
      || ! (*insn_data[icode].operand[0].predicate) (target, tmode))
    target = gen_reg_rtx (tmode);

  if (! (*insn_data[icode].operand[1].predicate) (op0, mode0))
    op0 = copy_to_mode_reg (mode0, op0);
  if (! (*insn_data[icode].operand[2].predicate) (op1, mode1))
    op1 = copy_to_mode_reg (mode1, op1);

  pat = GEN_FCN (icode) (target, op0, op1);
  if (! pat)
    return 0;
  emit_insn (pat);

  return target;
}

static rtx
altivec_expand_predicate_builtin (enum insn_code icode, tree exp, rtx target)
{
  rtx pat, scratch;
  tree cr6_form = CALL_EXPR_ARG (exp, 0);
  tree arg0 = CALL_EXPR_ARG (exp, 1);
  tree arg1 = CALL_EXPR_ARG (exp, 2);
  rtx op0 = expand_normal (arg0);
  rtx op1 = expand_normal (arg1);
  machine_mode tmode = SImode;
  machine_mode mode0 = insn_data[icode].operand[1].mode;
  machine_mode mode1 = insn_data[icode].operand[2].mode;
  int cr6_form_int;

  if (TREE_CODE (cr6_form) != INTEGER_CST)
    {
      error ("argument 1 of %qs must be a constant",
	     "__builtin_altivec_predicate");
      return const0_rtx;
    }
  else
    cr6_form_int = TREE_INT_CST_LOW (cr6_form);

  gcc_assert (mode0 == mode1);

  /* If we have invalid arguments, bail out before generating bad rtl.  */
  if (arg0 == error_mark_node || arg1 == error_mark_node)
    return const0_rtx;

  if (target == 0
      || GET_MODE (target) != tmode
      || ! (*insn_data[icode].operand[0].predicate) (target, tmode))
    target = gen_reg_rtx (tmode);

  if (! (*insn_data[icode].operand[1].predicate) (op0, mode0))
    op0 = copy_to_mode_reg (mode0, op0);
  if (! (*insn_data[icode].operand[2].predicate) (op1, mode1))
    op1 = copy_to_mode_reg (mode1, op1);

  /* Note that for many of the relevant operations (e.g. cmpne or
     cmpeq) with float or double operands, it makes more sense for the
     mode of the allocated scratch register to select a vector of
     integer.  But the choice to copy the mode of operand 0 was made
     long ago and there are no plans to change it.  */
  scratch = gen_reg_rtx (mode0);

  pat = GEN_FCN (icode) (scratch, op0, op1);
  if (! pat)
    return 0;
  emit_insn (pat);

  /* The vec_any* and vec_all* predicates use the same opcodes for two
     different operations, but the bits in CR6 will be different
     depending on what information we want.  So we have to play tricks
     with CR6 to get the right bits out.

     If you think this is disgusting, look at the specs for the
     AltiVec predicates.  */

  switch (cr6_form_int)
    {
    case 0:
      emit_insn (gen_cr6_test_for_zero (target));
      break;
    case 1:
      emit_insn (gen_cr6_test_for_zero_reverse (target));
      break;
    case 2:
      emit_insn (gen_cr6_test_for_lt (target));
      break;
    case 3:
      emit_insn (gen_cr6_test_for_lt_reverse (target));
      break;
    default:
      error ("argument 1 of %qs is out of range",
	     "__builtin_altivec_predicate");
      break;
    }

  return target;
}

rtx
swap_endian_selector_for_mode (machine_mode mode)
{
  unsigned int swap1[16] = {15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0};
  unsigned int swap2[16] = {7,6,5,4,3,2,1,0,15,14,13,12,11,10,9,8};
  unsigned int swap4[16] = {3,2,1,0,7,6,5,4,11,10,9,8,15,14,13,12};
  unsigned int swap8[16] = {1,0,3,2,5,4,7,6,9,8,11,10,13,12,15,14};

  unsigned int *swaparray, i;
  rtx perm[16];

  switch (mode)
    {
    case E_V1TImode:
      swaparray = swap1;
      break;
    case E_V2DFmode:
    case E_V2DImode:
      swaparray = swap2;
      break;
    case E_V4SFmode:
    case E_V4SImode:
      swaparray = swap4;
      break;
    case E_V8HImode:
      swaparray = swap8;
      break;
    default:
      gcc_unreachable ();
    }

  for (i = 0; i < 16; ++i)
    perm[i] = GEN_INT (swaparray[i]);

  return force_reg (V16QImode, gen_rtx_CONST_VECTOR (V16QImode,
						     gen_rtvec_v (16, perm)));
}

static rtx
altivec_expand_lv_builtin (enum insn_code icode, tree exp, rtx target, bool blk)
{
  rtx pat, addr;
  tree arg0 = CALL_EXPR_ARG (exp, 0);
  tree arg1 = CALL_EXPR_ARG (exp, 1);
  machine_mode tmode = insn_data[icode].operand[0].mode;
  machine_mode mode0 = Pmode;
  machine_mode mode1 = Pmode;
  rtx op0 = expand_normal (arg0);
  rtx op1 = expand_normal (arg1);

  if (icode == CODE_FOR_nothing)
    /* Builtin not supported on this processor.  */
    return 0;

  /* If we got invalid arguments bail out before generating bad rtl.  */
  if (arg0 == error_mark_node || arg1 == error_mark_node)
    return const0_rtx;

  if (target == 0
      || GET_MODE (target) != tmode
      || ! (*insn_data[icode].operand[0].predicate) (target, tmode))
    target = gen_reg_rtx (tmode);

  op1 = copy_to_mode_reg (mode1, op1);

  /* For LVX, express the RTL accurately by ANDing the address with -16.
     LVXL and LVE*X expand to use UNSPECs to hide their special behavior,
     so the raw address is fine.  */
  if (icode == CODE_FOR_altivec_lvx_v1ti
      || icode == CODE_FOR_altivec_lvx_v2df
      || icode == CODE_FOR_altivec_lvx_v2di
      || icode == CODE_FOR_altivec_lvx_v4sf
      || icode == CODE_FOR_altivec_lvx_v4si
      || icode == CODE_FOR_altivec_lvx_v8hi
      || icode == CODE_FOR_altivec_lvx_v16qi)
    {
      rtx rawaddr;
      if (op0 == const0_rtx)
	rawaddr = op1;
      else
	{
	  op0 = copy_to_mode_reg (mode0, op0);
	  rawaddr = gen_rtx_PLUS (Pmode, op1, op0);
	}
      addr = gen_rtx_AND (Pmode, rawaddr, gen_rtx_CONST_INT (Pmode, -16));
      addr = gen_rtx_MEM (blk ? BLKmode : tmode, addr);

      emit_insn (gen_rtx_SET (target, addr));
    }
  else
    {
      if (op0 == const0_rtx)
	addr = gen_rtx_MEM (blk ? BLKmode : tmode, op1);
      else
	{
	  op0 = copy_to_mode_reg (mode0, op0);
	  addr = gen_rtx_MEM (blk ? BLKmode : tmode,
			      gen_rtx_PLUS (Pmode, op1, op0));
	}

      pat = GEN_FCN (icode) (target, addr);
      if (! pat)
	return 0;
      emit_insn (pat);
    }

  return target;
}

static rtx
altivec_expand_stxvl_builtin (enum insn_code icode, tree exp)
{
  rtx pat;
  tree arg0 = CALL_EXPR_ARG (exp, 0);
  tree arg1 = CALL_EXPR_ARG (exp, 1);
  tree arg2 = CALL_EXPR_ARG (exp, 2);
  rtx op0 = expand_normal (arg0);
  rtx op1 = expand_normal (arg1);
  rtx op2 = expand_normal (arg2);
  machine_mode mode0 = insn_data[icode].operand[0].mode;
  machine_mode mode1 = insn_data[icode].operand[1].mode;
  machine_mode mode2 = insn_data[icode].operand[2].mode;

  if (icode == CODE_FOR_nothing)
    /* Builtin not supported on this processor.  */
    return NULL_RTX;

  /* If we got invalid arguments bail out before generating bad rtl.  */
  if (arg0 == error_mark_node
      || arg1 == error_mark_node
      || arg2 == error_mark_node)
    return NULL_RTX;

  if (! (*insn_data[icode].operand[1].predicate) (op0, mode0))
    op0 = copy_to_mode_reg (mode0, op0);
  if (! (*insn_data[icode].operand[2].predicate) (op1, mode1))
    op1 = copy_to_mode_reg (mode1, op1);
  if (! (*insn_data[icode].operand[3].predicate) (op2, mode2))
    op2 = copy_to_mode_reg (mode2, op2);

  pat = GEN_FCN (icode) (op0, op1, op2);
  if (pat)
    emit_insn (pat);

  return NULL_RTX;
}

static rtx
altivec_expand_stv_builtin (enum insn_code icode, tree exp)
{
  tree arg0 = CALL_EXPR_ARG (exp, 0);
  tree arg1 = CALL_EXPR_ARG (exp, 1);
  tree arg2 = CALL_EXPR_ARG (exp, 2);
  rtx op0 = expand_normal (arg0);
  rtx op1 = expand_normal (arg1);
  rtx op2 = expand_normal (arg2);
  rtx pat, addr, rawaddr;
  machine_mode tmode = insn_data[icode].operand[0].mode;
  machine_mode smode = insn_data[icode].operand[1].mode;
  machine_mode mode1 = Pmode;
  machine_mode mode2 = Pmode;

  /* Invalid arguments.  Bail before doing anything stoopid!  */
  if (arg0 == error_mark_node
      || arg1 == error_mark_node
      || arg2 == error_mark_node)
    return const0_rtx;

  op2 = copy_to_mode_reg (mode2, op2);

  /* For STVX, express the RTL accurately by ANDing the address with -16.
     STVXL and STVE*X expand to use UNSPECs to hide their special behavior,
     so the raw address is fine.  */
  if (icode == CODE_FOR_altivec_stvx_v2df
      || icode == CODE_FOR_altivec_stvx_v2di
      || icode == CODE_FOR_altivec_stvx_v4sf
      || icode == CODE_FOR_altivec_stvx_v4si
      || icode == CODE_FOR_altivec_stvx_v8hi
      || icode == CODE_FOR_altivec_stvx_v16qi)
    {
      if (op1 == const0_rtx)
	rawaddr = op2;
      else
	{
	  op1 = copy_to_mode_reg (mode1, op1);
	  rawaddr = gen_rtx_PLUS (Pmode, op2, op1);
	}

      addr = gen_rtx_AND (Pmode, rawaddr, gen_rtx_CONST_INT (Pmode, -16));
      addr = gen_rtx_MEM (tmode, addr);

      op0 = copy_to_mode_reg (tmode, op0);

      emit_insn (gen_rtx_SET (addr, op0));
    }
  else
    {
      if (! (*insn_data[icode].operand[1].predicate) (op0, smode))
	op0 = copy_to_mode_reg (smode, op0);

      if (op1 == const0_rtx)
	addr = gen_rtx_MEM (tmode, op2);
      else
	{
	  op1 = copy_to_mode_reg (mode1, op1);
	  addr = gen_rtx_MEM (tmode, gen_rtx_PLUS (Pmode, op2, op1));
	}

      pat = GEN_FCN (icode) (addr, op0);
      if (pat)
	emit_insn (pat);
    }

  return NULL_RTX;
}

/* Return the appropriate SPR number associated with the given builtin.  */
static inline HOST_WIDE_INT
htm_spr_num (enum rs6000_builtins code)
{
  if (code == HTM_BUILTIN_GET_TFHAR
      || code == HTM_BUILTIN_SET_TFHAR)
    return TFHAR_SPR;
  else if (code == HTM_BUILTIN_GET_TFIAR
	   || code == HTM_BUILTIN_SET_TFIAR)
    return TFIAR_SPR;
  else if (code == HTM_BUILTIN_GET_TEXASR
	   || code == HTM_BUILTIN_SET_TEXASR)
    return TEXASR_SPR;
  gcc_assert (code == HTM_BUILTIN_GET_TEXASRU
	      || code == HTM_BUILTIN_SET_TEXASRU);
  return TEXASRU_SPR;
}

/* Return the correct ICODE value depending on whether we are
   setting or reading the HTM SPRs.  */
static inline enum insn_code
rs6000_htm_spr_icode (bool nonvoid)
{
  if (nonvoid)
    return (TARGET_POWERPC64) ? CODE_FOR_htm_mfspr_di : CODE_FOR_htm_mfspr_si;
  else
    return (TARGET_POWERPC64) ? CODE_FOR_htm_mtspr_di : CODE_FOR_htm_mtspr_si;
}

/* Expand the HTM builtin in EXP and store the result in TARGET.
   Store true in *EXPANDEDP if we found a builtin to expand.  */
static rtx
htm_expand_builtin (tree exp, rtx target, bool * expandedp)
{
  tree fndecl = TREE_OPERAND (CALL_EXPR_FN (exp), 0);
  bool nonvoid = TREE_TYPE (TREE_TYPE (fndecl)) != void_type_node;
  enum rs6000_builtins fcode = (enum rs6000_builtins) DECL_FUNCTION_CODE (fndecl);
  const struct builtin_description *d;
  size_t i;

  *expandedp = true;

  if (!TARGET_POWERPC64
      && (fcode == HTM_BUILTIN_TABORTDC
	  || fcode == HTM_BUILTIN_TABORTDCI))
    {
      size_t uns_fcode = (size_t)fcode;
      const char *name = rs6000_builtin_info[uns_fcode].name;
      error ("builtin %qs is only valid in 64-bit mode", name);
      return const0_rtx;
    }

  /* Expand the HTM builtins.  */
  d = bdesc_htm;
  for (i = 0; i < ARRAY_SIZE (bdesc_htm); i++, d++)
    if (d->code == fcode)
      {
	rtx op[MAX_HTM_OPERANDS], pat;
	int nopnds = 0;
	tree arg;
	call_expr_arg_iterator iter;
	unsigned attr = rs6000_builtin_info[fcode].attr;
	enum insn_code icode = d->icode;
	const struct insn_operand_data *insn_op;
	bool uses_spr = (attr & RS6000_BTC_SPR);
	rtx cr = NULL_RTX;

	if (uses_spr)
	  icode = rs6000_htm_spr_icode (nonvoid);
	insn_op = &insn_data[icode].operand[0];

	if (nonvoid)
	  {
	    machine_mode tmode = (uses_spr) ? insn_op->mode : E_SImode;
	    if (!target
		|| GET_MODE (target) != tmode
		|| (uses_spr && !(*insn_op->predicate) (target, tmode)))
	      target = gen_reg_rtx (tmode);
	    if (uses_spr)
	      op[nopnds++] = target;
	  }

	FOR_EACH_CALL_EXPR_ARG (arg, iter, exp)
	{
	  if (arg == error_mark_node || nopnds >= MAX_HTM_OPERANDS)
	    return const0_rtx;

	  insn_op = &insn_data[icode].operand[nopnds];

	  op[nopnds] = expand_normal (arg);

	  if (!(*insn_op->predicate) (op[nopnds], insn_op->mode))
	    {
	      if (!strcmp (insn_op->constraint, "n"))
		{
		  int arg_num = (nonvoid) ? nopnds : nopnds + 1;
		  if (!CONST_INT_P (op[nopnds]))
		    error ("argument %d must be an unsigned literal", arg_num);
		  else
		    error ("argument %d is an unsigned literal that is "
			   "out of range", arg_num);
		  return const0_rtx;
		}
	      op[nopnds] = copy_to_mode_reg (insn_op->mode, op[nopnds]);
	    }

	  nopnds++;
	}

	/* Handle the builtins for extended mnemonics.  These accept
	   no arguments, but map to builtins that take arguments.  */
	switch (fcode)
	  {
	  case HTM_BUILTIN_TENDALL:  /* Alias for: tend. 1  */
	  case HTM_BUILTIN_TRESUME:  /* Alias for: tsr. 1  */
	    op[nopnds++] = GEN_INT (1);
	    if (flag_checking)
	      attr |= RS6000_BTC_UNARY;
	    break;
	  case HTM_BUILTIN_TSUSPEND: /* Alias for: tsr. 0  */
	    op[nopnds++] = GEN_INT (0);
	    if (flag_checking)
	      attr |= RS6000_BTC_UNARY;
	    break;
	  default:
	    break;
	  }

	/* If this builtin accesses SPRs, then pass in the appropriate
	   SPR number and SPR regno as the last two operands.  */
	if (uses_spr)
	  {
	    machine_mode mode = (TARGET_POWERPC64) ? DImode : SImode;
	    op[nopnds++] = gen_rtx_CONST_INT (mode, htm_spr_num (fcode));
	  }
	/* If this builtin accesses a CR, then pass in a scratch
	   CR as the last operand.  */
	else if (attr & RS6000_BTC_CR)
	  { cr = gen_reg_rtx (CCmode);
	    op[nopnds++] = cr;
	  }

	if (flag_checking)
	  {
	    int expected_nopnds = 0;
	    if ((attr & RS6000_BTC_TYPE_MASK) == RS6000_BTC_UNARY)
	      expected_nopnds = 1;
	    else if ((attr & RS6000_BTC_TYPE_MASK) == RS6000_BTC_BINARY)
	      expected_nopnds = 2;
	    else if ((attr & RS6000_BTC_TYPE_MASK) == RS6000_BTC_TERNARY)
	      expected_nopnds = 3;
	    if (!(attr & RS6000_BTC_VOID))
	      expected_nopnds += 1;
	    if (uses_spr)
	      expected_nopnds += 1;

	    gcc_assert (nopnds == expected_nopnds
			&& nopnds <= MAX_HTM_OPERANDS);
	  }

	switch (nopnds)
	  {
	  case 1:
	    pat = GEN_FCN (icode) (op[0]);
	    break;
	  case 2:
	    pat = GEN_FCN (icode) (op[0], op[1]);
	    break;
	  case 3:
	    pat = GEN_FCN (icode) (op[0], op[1], op[2]);
	    break;
	  case 4:
	    pat = GEN_FCN (icode) (op[0], op[1], op[2], op[3]);
	    break;
	  default:
	    gcc_unreachable ();
	  }
	if (!pat)
	  return NULL_RTX;
	emit_insn (pat);

	if (attr & RS6000_BTC_CR)
	  {
	    if (fcode == HTM_BUILTIN_TBEGIN)
	      {
		/* Emit code to set TARGET to true or false depending on
		   whether the tbegin. instruction successfully or failed
		   to start a transaction.  We do this by placing the 1's
		   complement of CR's EQ bit into TARGET.  */
		rtx scratch = gen_reg_rtx (SImode);
		emit_insn (gen_rtx_SET (scratch,
					gen_rtx_EQ (SImode, cr,
						     const0_rtx)));
		emit_insn (gen_rtx_SET (target,
					gen_rtx_XOR (SImode, scratch,
						     GEN_INT (1))));
	      }
	    else
	      {
		/* Emit code to copy the 4-bit condition register field
		   CR into the least significant end of register TARGET.  */
		rtx scratch1 = gen_reg_rtx (SImode);
		rtx scratch2 = gen_reg_rtx (SImode);
		rtx subreg = simplify_gen_subreg (CCmode, scratch1, SImode, 0);
		emit_insn (gen_movcc (subreg, cr));
		emit_insn (gen_lshrsi3 (scratch2, scratch1, GEN_INT (28)));
		emit_insn (gen_andsi3 (target, scratch2, GEN_INT (0xf)));
	      }
	  }

	if (nonvoid)
	  return target;
	return const0_rtx;
      }

  *expandedp = false;
  return NULL_RTX;
}

/* Expand the CPU builtin in FCODE and store the result in TARGET.  */

static rtx
cpu_expand_builtin (enum rs6000_builtins fcode, tree exp ATTRIBUTE_UNUSED,
		    rtx target)
{
  /* __builtin_cpu_init () is a nop, so expand to nothing.  */
  if (fcode == RS6000_BUILTIN_CPU_INIT)
    return const0_rtx;

  if (target == 0 || GET_MODE (target) != SImode)
    target = gen_reg_rtx (SImode);

#ifdef TARGET_LIBC_PROVIDES_HWCAP_IN_TCB
  tree arg = TREE_OPERAND (CALL_EXPR_ARG (exp, 0), 0);
  /* Target clones creates an ARRAY_REF instead of STRING_CST, convert it back
     to a STRING_CST.  */
  if (TREE_CODE (arg) == ARRAY_REF
      && TREE_CODE (TREE_OPERAND (arg, 0)) == STRING_CST
      && TREE_CODE (TREE_OPERAND (arg, 1)) == INTEGER_CST
      && compare_tree_int (TREE_OPERAND (arg, 1), 0) == 0)
    arg = TREE_OPERAND (arg, 0);

  if (TREE_CODE (arg) != STRING_CST)
    {
      error ("builtin %qs only accepts a string argument",
	     rs6000_builtin_info[(size_t) fcode].name);
      return const0_rtx;
    }

  if (fcode == RS6000_BUILTIN_CPU_IS)
    {
      const char *cpu = TREE_STRING_POINTER (arg);
      rtx cpuid = NULL_RTX;
      for (size_t i = 0; i < ARRAY_SIZE (cpu_is_info); i++)
	if (strcmp (cpu, cpu_is_info[i].cpu) == 0)
	  {
	    /* The CPUID value in the TCB is offset by _DL_FIRST_PLATFORM.  */
	    cpuid = GEN_INT (cpu_is_info[i].cpuid + _DL_FIRST_PLATFORM);
	    break;
	  }
      if (cpuid == NULL_RTX)
	{
	  /* Invalid CPU argument.  */
	  error ("cpu %qs is an invalid argument to builtin %qs",
		 cpu, rs6000_builtin_info[(size_t) fcode].name);
	  return const0_rtx;
	}

      rtx platform = gen_reg_rtx (SImode);
      rtx tcbmem = gen_const_mem (SImode,
				  gen_rtx_PLUS (Pmode,
						gen_rtx_REG (Pmode, TLS_REGNUM),
						GEN_INT (TCB_PLATFORM_OFFSET)));
      emit_move_insn (platform, tcbmem);
      emit_insn (gen_eqsi3 (target, platform, cpuid));
    }
  else if (fcode == RS6000_BUILTIN_CPU_SUPPORTS)
    {
      const char *hwcap = TREE_STRING_POINTER (arg);
      rtx mask = NULL_RTX;
      int hwcap_offset;
      for (size_t i = 0; i < ARRAY_SIZE (cpu_supports_info); i++)
	if (strcmp (hwcap, cpu_supports_info[i].hwcap) == 0)
	  {
	    mask = GEN_INT (cpu_supports_info[i].mask);
	    hwcap_offset = TCB_HWCAP_OFFSET (cpu_supports_info[i].id);
	    break;
	  }
      if (mask == NULL_RTX)
	{
	  /* Invalid HWCAP argument.  */
	  error ("%s %qs is an invalid argument to builtin %qs",
		 "hwcap", hwcap, rs6000_builtin_info[(size_t) fcode].name);
	  return const0_rtx;
	}

      rtx tcb_hwcap = gen_reg_rtx (SImode);
      rtx tcbmem = gen_const_mem (SImode,
				  gen_rtx_PLUS (Pmode,
						gen_rtx_REG (Pmode, TLS_REGNUM),
						GEN_INT (hwcap_offset)));
      emit_move_insn (tcb_hwcap, tcbmem);
      rtx scratch1 = gen_reg_rtx (SImode);
      emit_insn (gen_rtx_SET (scratch1, gen_rtx_AND (SImode, tcb_hwcap, mask)));
      rtx scratch2 = gen_reg_rtx (SImode);
      emit_insn (gen_eqsi3 (scratch2, scratch1, const0_rtx));
      emit_insn (gen_rtx_SET (target, gen_rtx_XOR (SImode, scratch2, const1_rtx)));
    }
  else
    gcc_unreachable ();

  /* Record that we have expanded a CPU builtin, so that we can later
     emit a reference to the special symbol exported by LIBC to ensure we
     do not link against an old LIBC that doesn't support this feature.  */
  cpu_builtin_p = true;

#else
  warning (0, "builtin %qs needs GLIBC (2.23 and newer) that exports hardware "
	   "capability bits", rs6000_builtin_info[(size_t) fcode].name);
  
  /* For old LIBCs, always return FALSE.  */
  emit_move_insn (target, GEN_INT (0));
#endif /* TARGET_LIBC_PROVIDES_HWCAP_IN_TCB */

  return target;
}

static rtx
rs6000_expand_ternop_builtin (enum insn_code icode, tree exp, rtx target)
{
  rtx pat;
  tree arg0 = CALL_EXPR_ARG (exp, 0);
  tree arg1 = CALL_EXPR_ARG (exp, 1);
  tree arg2 = CALL_EXPR_ARG (exp, 2);
  rtx op0 = expand_normal (arg0);
  rtx op1 = expand_normal (arg1);
  rtx op2 = expand_normal (arg2);
  machine_mode tmode = insn_data[icode].operand[0].mode;
  machine_mode mode0 = insn_data[icode].operand[1].mode;
  machine_mode mode1 = insn_data[icode].operand[2].mode;
  machine_mode mode2 = insn_data[icode].operand[3].mode;

  if (icode == CODE_FOR_nothing)
    /* Builtin not supported on this processor.  */
    return 0;

  /* If we got invalid arguments bail out before generating bad rtl.  */
  if (arg0 == error_mark_node
      || arg1 == error_mark_node
      || arg2 == error_mark_node)
    return const0_rtx;

  /* Check and prepare argument depending on the instruction code.

     Note that a switch statement instead of the sequence of tests
     would be incorrect as many of the CODE_FOR values could be
     CODE_FOR_nothing and that would yield multiple alternatives
     with identical values.  We'd never reach here at runtime in
     this case.  */
  if (icode == CODE_FOR_altivec_vsldoi_v4sf
      || icode == CODE_FOR_altivec_vsldoi_v2df
      || icode == CODE_FOR_altivec_vsldoi_v4si
      || icode == CODE_FOR_altivec_vsldoi_v8hi
      || icode == CODE_FOR_altivec_vsldoi_v16qi)
    {
      /* Only allow 4-bit unsigned literals.  */
      STRIP_NOPS (arg2);
      if (TREE_CODE (arg2) != INTEGER_CST
	  || TREE_INT_CST_LOW (arg2) & ~0xf)
	{
	  error ("argument 3 must be a 4-bit unsigned literal");
	  return CONST0_RTX (tmode);
	}
    }
  else if (icode == CODE_FOR_vsx_xxpermdi_v2df
           || icode == CODE_FOR_vsx_xxpermdi_v2di
           || icode == CODE_FOR_vsx_xxpermdi_v2df_be
           || icode == CODE_FOR_vsx_xxpermdi_v2di_be
           || icode == CODE_FOR_vsx_xxpermdi_v1ti
           || icode == CODE_FOR_vsx_xxpermdi_v4sf
           || icode == CODE_FOR_vsx_xxpermdi_v4si
           || icode == CODE_FOR_vsx_xxpermdi_v8hi
           || icode == CODE_FOR_vsx_xxpermdi_v16qi
           || icode == CODE_FOR_vsx_xxsldwi_v16qi
           || icode == CODE_FOR_vsx_xxsldwi_v8hi
           || icode == CODE_FOR_vsx_xxsldwi_v4si
           || icode == CODE_FOR_vsx_xxsldwi_v4sf
           || icode == CODE_FOR_vsx_xxsldwi_v2di
           || icode == CODE_FOR_vsx_xxsldwi_v2df)
    {
      /* Only allow 2-bit unsigned literals.  */
      STRIP_NOPS (arg2);
      if (TREE_CODE (arg2) != INTEGER_CST
	  || TREE_INT_CST_LOW (arg2) & ~0x3)
	{
	  error ("argument 3 must be a 2-bit unsigned literal");
	  return CONST0_RTX (tmode);
	}
    }
  else if (icode == CODE_FOR_vsx_set_v2df
           || icode == CODE_FOR_vsx_set_v2di
	   || icode == CODE_FOR_bcdadd
	   || icode == CODE_FOR_bcdadd_lt
	   || icode == CODE_FOR_bcdadd_eq
	   || icode == CODE_FOR_bcdadd_gt
	   || icode == CODE_FOR_bcdsub
	   || icode == CODE_FOR_bcdsub_lt
	   || icode == CODE_FOR_bcdsub_eq
	   || icode == CODE_FOR_bcdsub_gt)
    {
      /* Only allow 1-bit unsigned literals.  */
      STRIP_NOPS (arg2);
      if (TREE_CODE (arg2) != INTEGER_CST
	  || TREE_INT_CST_LOW (arg2) & ~0x1)
	{
	  error ("argument 3 must be a 1-bit unsigned literal");
	  return CONST0_RTX (tmode);
	}
    }
  else if (icode == CODE_FOR_dfp_ddedpd_dd
           || icode == CODE_FOR_dfp_ddedpd_td)
    {
      /* Only allow 2-bit unsigned literals where the value is 0 or 2.  */
      STRIP_NOPS (arg0);
      if (TREE_CODE (arg0) != INTEGER_CST
	  || TREE_INT_CST_LOW (arg2) & ~0x3)
	{
	  error ("argument 1 must be 0 or 2");
	  return CONST0_RTX (tmode);
	}
    }
  else if (icode == CODE_FOR_dfp_denbcd_dd
	   || icode == CODE_FOR_dfp_denbcd_td)
    {
      /* Only allow 1-bit unsigned literals.  */
      STRIP_NOPS (arg0);
      if (TREE_CODE (arg0) != INTEGER_CST
	  || TREE_INT_CST_LOW (arg0) & ~0x1)
	{
	  error ("argument 1 must be a 1-bit unsigned literal");
	  return CONST0_RTX (tmode);
	}
    }
  else if (icode == CODE_FOR_dfp_dscli_dd
           || icode == CODE_FOR_dfp_dscli_td
	   || icode == CODE_FOR_dfp_dscri_dd
	   || icode == CODE_FOR_dfp_dscri_td)
    {
      /* Only allow 6-bit unsigned literals.  */
      STRIP_NOPS (arg1);
      if (TREE_CODE (arg1) != INTEGER_CST
	  || TREE_INT_CST_LOW (arg1) & ~0x3f)
	{
	  error ("argument 2 must be a 6-bit unsigned literal");
	  return CONST0_RTX (tmode);
	}
    }
  else if (icode == CODE_FOR_crypto_vshasigmaw
	   || icode == CODE_FOR_crypto_vshasigmad)
    {
      /* Check whether the 2nd and 3rd arguments are integer constants and in
	 range and prepare arguments.  */
      STRIP_NOPS (arg1);
      if (TREE_CODE (arg1) != INTEGER_CST || wi::geu_p (wi::to_wide (arg1), 2))
	{
	  error ("argument 2 must be 0 or 1");
	  return CONST0_RTX (tmode);
	}

      STRIP_NOPS (arg2);
      if (TREE_CODE (arg2) != INTEGER_CST
	  || wi::geu_p (wi::to_wide (arg2), 16))
	{
	  error ("argument 3 must be in the range [0, 15]");
	  return CONST0_RTX (tmode);
	}
    }

  if (target == 0
      || GET_MODE (target) != tmode
      || ! (*insn_data[icode].operand[0].predicate) (target, tmode))
    target = gen_reg_rtx (tmode);

  if (! (*insn_data[icode].operand[1].predicate) (op0, mode0))
    op0 = copy_to_mode_reg (mode0, op0);
  if (! (*insn_data[icode].operand[2].predicate) (op1, mode1))
    op1 = copy_to_mode_reg (mode1, op1);
  if (! (*insn_data[icode].operand[3].predicate) (op2, mode2))
    op2 = copy_to_mode_reg (mode2, op2);

  pat = GEN_FCN (icode) (target, op0, op1, op2);
  if (! pat)
    return 0;
  emit_insn (pat);

  return target;
}


/* Expand the dst builtins.  */
static rtx
altivec_expand_dst_builtin (tree exp, rtx target ATTRIBUTE_UNUSED,
			    bool *expandedp)
{
  tree fndecl = TREE_OPERAND (CALL_EXPR_FN (exp), 0);
  enum rs6000_builtins fcode = (enum rs6000_builtins) DECL_FUNCTION_CODE (fndecl);
  tree arg0, arg1, arg2;
  machine_mode mode0, mode1;
  rtx pat, op0, op1, op2;
  const struct builtin_description *d;
  size_t i;

  *expandedp = false;

  /* Handle DST variants.  */
  d = bdesc_dst;
  for (i = 0; i < ARRAY_SIZE (bdesc_dst); i++, d++)
    if (d->code == fcode)
      {
	arg0 = CALL_EXPR_ARG (exp, 0);
	arg1 = CALL_EXPR_ARG (exp, 1);
	arg2 = CALL_EXPR_ARG (exp, 2);
	op0 = expand_normal (arg0);
	op1 = expand_normal (arg1);
	op2 = expand_normal (arg2);
	mode0 = insn_data[d->icode].operand[0].mode;
	mode1 = insn_data[d->icode].operand[1].mode;

	/* Invalid arguments, bail out before generating bad rtl.  */
	if (arg0 == error_mark_node
	    || arg1 == error_mark_node
	    || arg2 == error_mark_node)
	  return const0_rtx;

	*expandedp = true;
	STRIP_NOPS (arg2);
	if (TREE_CODE (arg2) != INTEGER_CST
	    || TREE_INT_CST_LOW (arg2) & ~0x3)
	  {
	    error ("argument to %qs must be a 2-bit unsigned literal", d->name);
	    return const0_rtx;
	  }

	if (! (*insn_data[d->icode].operand[0].predicate) (op0, mode0))
	  op0 = copy_to_mode_reg (Pmode, op0);
	if (! (*insn_data[d->icode].operand[1].predicate) (op1, mode1))
	  op1 = copy_to_mode_reg (mode1, op1);

	pat = GEN_FCN (d->icode) (op0, op1, op2);
	if (pat != 0)
	  emit_insn (pat);

	return NULL_RTX;
      }

  return NULL_RTX;
}

/* Expand vec_init builtin.  */
static rtx
altivec_expand_vec_init_builtin (tree type, tree exp, rtx target)
{
  machine_mode tmode = TYPE_MODE (type);
  machine_mode inner_mode = GET_MODE_INNER (tmode);
  int i, n_elt = GET_MODE_NUNITS (tmode);

  gcc_assert (VECTOR_MODE_P (tmode));
  gcc_assert (n_elt == call_expr_nargs (exp));

  if (!target || !register_operand (target, tmode))
    target = gen_reg_rtx (tmode);

  /* If we have a vector compromised of a single element, such as V1TImode, do
     the initialization directly.  */
  if (n_elt == 1 && GET_MODE_SIZE (tmode) == GET_MODE_SIZE (inner_mode))
    {
      rtx x = expand_normal (CALL_EXPR_ARG (exp, 0));
      emit_move_insn (target, gen_lowpart (tmode, x));
    }
  else
    {
      rtvec v = rtvec_alloc (n_elt);

      for (i = 0; i < n_elt; ++i)
	{
	  rtx x = expand_normal (CALL_EXPR_ARG (exp, i));
	  RTVEC_ELT (v, i) = gen_lowpart (inner_mode, x);
	}

      rs6000_expand_vector_init (target, gen_rtx_PARALLEL (tmode, v));
    }

  return target;
}

/* Return the integer constant in ARG.  Constrain it to be in the range
   of the subparts of VEC_TYPE; issue an error if not.  */

static int
get_element_number (tree vec_type, tree arg)
{
  unsigned HOST_WIDE_INT elt, max = TYPE_VECTOR_SUBPARTS (vec_type) - 1;

  if (!tree_fits_uhwi_p (arg)
      || (elt = tree_to_uhwi (arg), elt > max))
    {
      error ("selector must be an integer constant in the range [0, %wi]", max);
      return 0;
    }

  return elt;
}

/* Expand vec_set builtin.  */
static rtx
altivec_expand_vec_set_builtin (tree exp)
{
  machine_mode tmode, mode1;
  tree arg0, arg1, arg2;
  int elt;
  rtx op0, op1;

  arg0 = CALL_EXPR_ARG (exp, 0);
  arg1 = CALL_EXPR_ARG (exp, 1);
  arg2 = CALL_EXPR_ARG (exp, 2);

  tmode = TYPE_MODE (TREE_TYPE (arg0));
  mode1 = TYPE_MODE (TREE_TYPE (TREE_TYPE (arg0)));
  gcc_assert (VECTOR_MODE_P (tmode));

  op0 = expand_expr (arg0, NULL_RTX, tmode, EXPAND_NORMAL);
  op1 = expand_expr (arg1, NULL_RTX, mode1, EXPAND_NORMAL);
  elt = get_element_number (TREE_TYPE (arg0), arg2);

  if (GET_MODE (op1) != mode1 && GET_MODE (op1) != VOIDmode)
    op1 = convert_modes (mode1, GET_MODE (op1), op1, true);

  op0 = force_reg (tmode, op0);
  op1 = force_reg (mode1, op1);

  rs6000_expand_vector_set (op0, op1, elt);

  return op0;
}

/* Expand vec_ext builtin.  */
static rtx
altivec_expand_vec_ext_builtin (tree exp, rtx target)
{
  machine_mode tmode, mode0;
  tree arg0, arg1;
  rtx op0;
  rtx op1;

  arg0 = CALL_EXPR_ARG (exp, 0);
  arg1 = CALL_EXPR_ARG (exp, 1);

  op0 = expand_normal (arg0);
  op1 = expand_normal (arg1);

  if (TREE_CODE (arg1) == INTEGER_CST)
    {
      unsigned HOST_WIDE_INT elt;
      unsigned HOST_WIDE_INT size = TYPE_VECTOR_SUBPARTS (TREE_TYPE (arg0));
      unsigned int truncated_selector;
      /* Even if !tree_fits_uhwi_p (arg1)), TREE_INT_CST_LOW (arg0)
	 returns low-order bits of INTEGER_CST for modulo indexing.  */
      elt = TREE_INT_CST_LOW (arg1);
      truncated_selector = elt % size;
      op1 = GEN_INT (truncated_selector);
    }

  tmode = TYPE_MODE (TREE_TYPE (TREE_TYPE (arg0)));
  mode0 = TYPE_MODE (TREE_TYPE (arg0));
  gcc_assert (VECTOR_MODE_P (mode0));

  op0 = force_reg (mode0, op0);

  if (optimize || !target || !register_operand (target, tmode))
    target = gen_reg_rtx (tmode);

  rs6000_expand_vector_extract (target, op0, op1);

  return target;
}

/* Expand the builtin in EXP and store the result in TARGET.  Store
   true in *EXPANDEDP if we found a builtin to expand.  */
static rtx
altivec_expand_builtin (tree exp, rtx target, bool *expandedp)
{
  const struct builtin_description *d;
  size_t i;
  enum insn_code icode;
  tree fndecl = TREE_OPERAND (CALL_EXPR_FN (exp), 0);
  tree arg0, arg1, arg2;
  rtx op0, pat;
  machine_mode tmode, mode0;
  enum rs6000_builtins fcode
    = (enum rs6000_builtins) DECL_FUNCTION_CODE (fndecl);

  if (rs6000_overloaded_builtin_p (fcode))
    {
      *expandedp = true;
      error ("unresolved overload for Altivec builtin %qF", fndecl);

      /* Given it is invalid, just generate a normal call.  */
      return expand_call (exp, target, false);
    }

  target = altivec_expand_dst_builtin (exp, target, expandedp);
  if (*expandedp)
    return target;

  *expandedp = true;

  switch (fcode)
    {
    case ALTIVEC_BUILTIN_STVX_V2DF:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvx_v2df, exp);
    case ALTIVEC_BUILTIN_STVX_V2DI:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvx_v2di, exp);
    case ALTIVEC_BUILTIN_STVX_V4SF:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvx_v4sf, exp);
    case ALTIVEC_BUILTIN_STVX:
    case ALTIVEC_BUILTIN_STVX_V4SI:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvx_v4si, exp);
    case ALTIVEC_BUILTIN_STVX_V8HI:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvx_v8hi, exp);
    case ALTIVEC_BUILTIN_STVX_V16QI:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvx_v16qi, exp);
    case ALTIVEC_BUILTIN_STVEBX:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvebx, exp);
    case ALTIVEC_BUILTIN_STVEHX:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvehx, exp);
    case ALTIVEC_BUILTIN_STVEWX:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvewx, exp);
    case ALTIVEC_BUILTIN_STVXL_V2DF:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvxl_v2df, exp);
    case ALTIVEC_BUILTIN_STVXL_V2DI:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvxl_v2di, exp);
    case ALTIVEC_BUILTIN_STVXL_V4SF:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvxl_v4sf, exp);
    case ALTIVEC_BUILTIN_STVXL:
    case ALTIVEC_BUILTIN_STVXL_V4SI:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvxl_v4si, exp);
    case ALTIVEC_BUILTIN_STVXL_V8HI:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvxl_v8hi, exp);
    case ALTIVEC_BUILTIN_STVXL_V16QI:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvxl_v16qi, exp);

    case ALTIVEC_BUILTIN_STVLX:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvlx, exp);
    case ALTIVEC_BUILTIN_STVLXL:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvlxl, exp);
    case ALTIVEC_BUILTIN_STVRX:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvrx, exp);
    case ALTIVEC_BUILTIN_STVRXL:
      return altivec_expand_stv_builtin (CODE_FOR_altivec_stvrxl, exp);

    case P9V_BUILTIN_STXVL:
      return altivec_expand_stxvl_builtin (CODE_FOR_stxvl, exp);

    case P9V_BUILTIN_XST_LEN_R:
      return altivec_expand_stxvl_builtin (CODE_FOR_xst_len_r, exp);

    case VSX_BUILTIN_STXVD2X_V1TI:
      return altivec_expand_stv_builtin (CODE_FOR_vsx_store_v1ti, exp);
    case VSX_BUILTIN_STXVD2X_V2DF:
      return altivec_expand_stv_builtin (CODE_FOR_vsx_store_v2df, exp);
    case VSX_BUILTIN_STXVD2X_V2DI:
      return altivec_expand_stv_builtin (CODE_FOR_vsx_store_v2di, exp);
    case VSX_BUILTIN_STXVW4X_V4SF:
      return altivec_expand_stv_builtin (CODE_FOR_vsx_store_v4sf, exp);
    case VSX_BUILTIN_STXVW4X_V4SI:
      return altivec_expand_stv_builtin (CODE_FOR_vsx_store_v4si, exp);
    case VSX_BUILTIN_STXVW4X_V8HI:
      return altivec_expand_stv_builtin (CODE_FOR_vsx_store_v8hi, exp);
    case VSX_BUILTIN_STXVW4X_V16QI:
      return altivec_expand_stv_builtin (CODE_FOR_vsx_store_v16qi, exp);

    /* For the following on big endian, it's ok to use any appropriate
       unaligned-supporting store, so use a generic expander.  For
       little-endian, the exact element-reversing instruction must
       be used.  */
   case VSX_BUILTIN_ST_ELEMREV_V1TI:
     {
        enum insn_code code = (BYTES_BIG_ENDIAN ? CODE_FOR_vsx_store_v1ti
			       : CODE_FOR_vsx_st_elemrev_v1ti);
        return altivec_expand_stv_builtin (code, exp);
      }
    case VSX_BUILTIN_ST_ELEMREV_V2DF:
      {
	enum insn_code code = (BYTES_BIG_ENDIAN ? CODE_FOR_vsx_store_v2df
			       : CODE_FOR_vsx_st_elemrev_v2df);
	return altivec_expand_stv_builtin (code, exp);
      }
    case VSX_BUILTIN_ST_ELEMREV_V2DI:
      {
	enum insn_code code = (BYTES_BIG_ENDIAN ? CODE_FOR_vsx_store_v2di
			       : CODE_FOR_vsx_st_elemrev_v2di);
	return altivec_expand_stv_builtin (code, exp);
      }
    case VSX_BUILTIN_ST_ELEMREV_V4SF:
      {
	enum insn_code code = (BYTES_BIG_ENDIAN ? CODE_FOR_vsx_store_v4sf
			       : CODE_FOR_vsx_st_elemrev_v4sf);
	return altivec_expand_stv_builtin (code, exp);
      }
    case VSX_BUILTIN_ST_ELEMREV_V4SI:
      {
	enum insn_code code = (BYTES_BIG_ENDIAN ? CODE_FOR_vsx_store_v4si
			       : CODE_FOR_vsx_st_elemrev_v4si);
	return altivec_expand_stv_builtin (code, exp);
      }
    case VSX_BUILTIN_ST_ELEMREV_V8HI:
      {
	enum insn_code code = (BYTES_BIG_ENDIAN ? CODE_FOR_vsx_store_v8hi
			       : CODE_FOR_vsx_st_elemrev_v8hi);
	return altivec_expand_stv_builtin (code, exp);
      }
    case VSX_BUILTIN_ST_ELEMREV_V16QI:
      {
	enum insn_code code = (BYTES_BIG_ENDIAN ? CODE_FOR_vsx_store_v16qi
			       : CODE_FOR_vsx_st_elemrev_v16qi);
	return altivec_expand_stv_builtin (code, exp);
      }

    case ALTIVEC_BUILTIN_MFVSCR:
      icode = CODE_FOR_altivec_mfvscr;
      tmode = insn_data[icode].operand[0].mode;

      if (target == 0
	  || GET_MODE (target) != tmode
	  || ! (*insn_data[icode].operand[0].predicate) (target, tmode))
	target = gen_reg_rtx (tmode);

      pat = GEN_FCN (icode) (target);
      if (! pat)
	return 0;
      emit_insn (pat);
      return target;

    case ALTIVEC_BUILTIN_MTVSCR:
      icode = CODE_FOR_altivec_mtvscr;
      arg0 = CALL_EXPR_ARG (exp, 0);
      op0 = expand_normal (arg0);
      mode0 = insn_data[icode].operand[0].mode;

      /* If we got invalid arguments bail out before generating bad rtl.  */
      if (arg0 == error_mark_node)
	return const0_rtx;

      if (! (*insn_data[icode].operand[0].predicate) (op0, mode0))
	op0 = copy_to_mode_reg (mode0, op0);

      pat = GEN_FCN (icode) (op0);
      if (pat)
	emit_insn (pat);
      return NULL_RTX;

    case ALTIVEC_BUILTIN_DSSALL:
      emit_insn (gen_altivec_dssall ());
      return NULL_RTX;

    case ALTIVEC_BUILTIN_DSS:
      icode = CODE_FOR_altivec_dss;
      arg0 = CALL_EXPR_ARG (exp, 0);
      STRIP_NOPS (arg0);
      op0 = expand_normal (arg0);
      mode0 = insn_data[icode].operand[0].mode;

      /* If we got invalid arguments bail out before generating bad rtl.  */
      if (arg0 == error_mark_node)
	return const0_rtx;

      if (TREE_CODE (arg0) != INTEGER_CST
	  || TREE_INT_CST_LOW (arg0) & ~0x3)
	{
	  error ("argument to %qs must be a 2-bit unsigned literal", "dss");
	  return const0_rtx;
	}

      if (! (*insn_data[icode].operand[0].predicate) (op0, mode0))
	op0 = copy_to_mode_reg (mode0, op0);

      emit_insn (gen_altivec_dss (op0));
      return NULL_RTX;

    case ALTIVEC_BUILTIN_VEC_INIT_V4SI:
    case ALTIVEC_BUILTIN_VEC_INIT_V8HI:
    case ALTIVEC_BUILTIN_VEC_INIT_V16QI:
    case ALTIVEC_BUILTIN_VEC_INIT_V4SF:
    case VSX_BUILTIN_VEC_INIT_V2DF:
    case VSX_BUILTIN_VEC_INIT_V2DI:
    case VSX_BUILTIN_VEC_INIT_V1TI:
      return altivec_expand_vec_init_builtin (TREE_TYPE (exp), exp, target);

    case ALTIVEC_BUILTIN_VEC_SET_V4SI:
    case ALTIVEC_BUILTIN_VEC_SET_V8HI:
    case ALTIVEC_BUILTIN_VEC_SET_V16QI:
    case ALTIVEC_BUILTIN_VEC_SET_V4SF:
    case VSX_BUILTIN_VEC_SET_V2DF:
    case VSX_BUILTIN_VEC_SET_V2DI:
    case VSX_BUILTIN_VEC_SET_V1TI:
      return altivec_expand_vec_set_builtin (exp);

    case ALTIVEC_BUILTIN_VEC_EXT_V4SI:
    case ALTIVEC_BUILTIN_VEC_EXT_V8HI:
    case ALTIVEC_BUILTIN_VEC_EXT_V16QI:
    case ALTIVEC_BUILTIN_VEC_EXT_V4SF:
    case VSX_BUILTIN_VEC_EXT_V2DF:
    case VSX_BUILTIN_VEC_EXT_V2DI:
    case VSX_BUILTIN_VEC_EXT_V1TI:
      return altivec_expand_vec_ext_builtin (exp, target);

    case P9V_BUILTIN_VEC_EXTRACT4B:
      arg1 = CALL_EXPR_ARG (exp, 1);
      STRIP_NOPS (arg1);

      /* Generate a normal call if it is invalid.  */
      if (arg1 == error_mark_node)
	return expand_call (exp, target, false);

      if (TREE_CODE (arg1) != INTEGER_CST || TREE_INT_CST_LOW (arg1) > 12)
	{
	  error ("second argument to %qs must be [0, 12]", "vec_vextract4b");
	  return expand_call (exp, target, false);
	}
      break;

    case P9V_BUILTIN_VEC_INSERT4B:
      arg2 = CALL_EXPR_ARG (exp, 2);
      STRIP_NOPS (arg2);

      /* Generate a normal call if it is invalid.  */
      if (arg2 == error_mark_node)
	return expand_call (exp, target, false);

      if (TREE_CODE (arg2) != INTEGER_CST || TREE_INT_CST_LOW (arg2) > 12)
	{
	  error ("third argument to %qs must be [0, 12]", "vec_vinsert4b");
	  return expand_call (exp, target, false);
	}
      break;

    default:
      break;
      /* Fall through.  */
    }

  /* Expand abs* operations.  */
  d = bdesc_abs;
  for (i = 0; i < ARRAY_SIZE (bdesc_abs); i++, d++)
    if (d->code == fcode)
      return altivec_expand_abs_builtin (d->icode, exp, target);

  /* Expand the AltiVec predicates.  */
  d = bdesc_altivec_preds;
  for (i = 0; i < ARRAY_SIZE (bdesc_altivec_preds); i++, d++)
    if (d->code == fcode)
      return altivec_expand_predicate_builtin (d->icode, exp, target);

  /* LV* are funky.  We initialized them differently.  */
  switch (fcode)
    {
    case ALTIVEC_BUILTIN_LVSL:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvsl,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVSR:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvsr,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVEBX:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvebx,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVEHX:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvehx,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVEWX:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvewx,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVXL_V2DF:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvxl_v2df,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVXL_V2DI:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvxl_v2di,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVXL_V4SF:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvxl_v4sf,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVXL:
    case ALTIVEC_BUILTIN_LVXL_V4SI:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvxl_v4si,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVXL_V8HI:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvxl_v8hi,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVXL_V16QI:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvxl_v16qi,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVX_V1TI:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvx_v1ti,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVX_V2DF:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvx_v2df,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVX_V2DI:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvx_v2di,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVX_V4SF:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvx_v4sf,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVX:
    case ALTIVEC_BUILTIN_LVX_V4SI:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvx_v4si,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVX_V8HI:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvx_v8hi,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVX_V16QI:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvx_v16qi,
					exp, target, false);
    case ALTIVEC_BUILTIN_LVLX:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvlx,
					exp, target, true);
    case ALTIVEC_BUILTIN_LVLXL:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvlxl,
					exp, target, true);
    case ALTIVEC_BUILTIN_LVRX:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvrx,
					exp, target, true);
    case ALTIVEC_BUILTIN_LVRXL:
      return altivec_expand_lv_builtin (CODE_FOR_altivec_lvrxl,
					exp, target, true);
    case VSX_BUILTIN_LXVD2X_V1TI:
      return altivec_expand_lv_builtin (CODE_FOR_vsx_load_v1ti,
					exp, target, false);
    case VSX_BUILTIN_LXVD2X_V2DF:
      return altivec_expand_lv_builtin (CODE_FOR_vsx_load_v2df,
					exp, target, false);
    case VSX_BUILTIN_LXVD2X_V2DI:
      return altivec_expand_lv_builtin (CODE_FOR_vsx_load_v2di,
					exp, target, false);
    case VSX_BUILTIN_LXVW4X_V4SF:
      return altivec_expand_lv_builtin (CODE_FOR_vsx_load_v4sf,
					exp, target, false);
    case VSX_BUILTIN_LXVW4X_V4SI:
      return altivec_expand_lv_builtin (CODE_FOR_vsx_load_v4si,
					exp, target, false);
    case VSX_BUILTIN_LXVW4X_V8HI:
      return altivec_expand_lv_builtin (CODE_FOR_vsx_load_v8hi,
					exp, target, false);
    case VSX_BUILTIN_LXVW4X_V16QI:
      return altivec_expand_lv_builtin (CODE_FOR_vsx_load_v16qi,
					exp, target, false);
    /* For the following on big endian, it's ok to use any appropriate
       unaligned-supporting load, so use a generic expander.  For
       little-endian, the exact element-reversing instruction must
       be used.  */
    case VSX_BUILTIN_LD_ELEMREV_V2DF:
      {
	enum insn_code code = (BYTES_BIG_ENDIAN ? CODE_FOR_vsx_load_v2df
			       : CODE_FOR_vsx_ld_elemrev_v2df);
	return altivec_expand_lv_builtin (code, exp, target, false);
      }
    case VSX_BUILTIN_LD_ELEMREV_V1TI:
      {
	enum insn_code code = (BYTES_BIG_ENDIAN ? CODE_FOR_vsx_load_v1ti
			       : CODE_FOR_vsx_ld_elemrev_v1ti);
	return altivec_expand_lv_builtin (code, exp, target, false);
      }
    case VSX_BUILTIN_LD_ELEMREV_V2DI:
      {
	enum insn_code code = (BYTES_BIG_ENDIAN ? CODE_FOR_vsx_load_v2di
			       : CODE_FOR_vsx_ld_elemrev_v2di);
	return altivec_expand_lv_builtin (code, exp, target, false);
      }
    case VSX_BUILTIN_LD_ELEMREV_V4SF:
      {
	enum insn_code code = (BYTES_BIG_ENDIAN ? CODE_FOR_vsx_load_v4sf
			       : CODE_FOR_vsx_ld_elemrev_v4sf);
	return altivec_expand_lv_builtin (code, exp, target, false);
      }
    case VSX_BUILTIN_LD_ELEMREV_V4SI:
      {
	enum insn_code code = (BYTES_BIG_ENDIAN ? CODE_FOR_vsx_load_v4si
			       : CODE_FOR_vsx_ld_elemrev_v4si);
	return altivec_expand_lv_builtin (code, exp, target, false);
      }
    case VSX_BUILTIN_LD_ELEMREV_V8HI:
      {
	enum insn_code code = (BYTES_BIG_ENDIAN ? CODE_FOR_vsx_load_v8hi
			       : CODE_FOR_vsx_ld_elemrev_v8hi);
	return altivec_expand_lv_builtin (code, exp, target, false);
      }
    case VSX_BUILTIN_LD_ELEMREV_V16QI:
      {
	enum insn_code code = (BYTES_BIG_ENDIAN ? CODE_FOR_vsx_load_v16qi
			       : CODE_FOR_vsx_ld_elemrev_v16qi);
	return altivec_expand_lv_builtin (code, exp, target, false);
      }
      break;
    default:
      break;
      /* Fall through.  */
    }

  *expandedp = false;
  return NULL_RTX;
}

/* Check whether a builtin function is supported in this target
   configuration.  */
bool
rs6000_builtin_is_supported_p (enum rs6000_builtins fncode)
{
  HOST_WIDE_INT fnmask = rs6000_builtin_info[fncode].mask;
  if ((fnmask & rs6000_builtin_mask) != fnmask)
    return false;
  else
    return true;
}

/* Raise an error message for a builtin function that is called without the
   appropriate target options being set.  */

static void
rs6000_invalid_builtin (enum rs6000_builtins fncode)
{
  size_t uns_fncode = (size_t) fncode;
  const char *name = rs6000_builtin_info[uns_fncode].name;
  HOST_WIDE_INT fnmask = rs6000_builtin_info[uns_fncode].mask;

  gcc_assert (name != NULL);
  if ((fnmask & RS6000_BTM_CELL) != 0)
    error ("builtin function %qs is only valid for the cell processor", name);
  else if ((fnmask & RS6000_BTM_VSX) != 0)
    error ("builtin function %qs requires the %qs option", name, "-mvsx");
  else if ((fnmask & RS6000_BTM_HTM) != 0)
    error ("builtin function %qs requires the %qs option", name, "-mhtm");
  else if ((fnmask & RS6000_BTM_ALTIVEC) != 0)
    error ("builtin function %qs requires the %qs option", name, "-maltivec");
  else if ((fnmask & (RS6000_BTM_DFP | RS6000_BTM_P8_VECTOR))
	   == (RS6000_BTM_DFP | RS6000_BTM_P8_VECTOR))
    error ("builtin function %qs requires the %qs and %qs options",
	   name, "-mhard-dfp", "-mpower8-vector");
  else if ((fnmask & RS6000_BTM_DFP) != 0)
    error ("builtin function %qs requires the %qs option", name, "-mhard-dfp");
  else if ((fnmask & RS6000_BTM_P8_VECTOR) != 0)
    error ("builtin function %qs requires the %qs option", name,
	   "-mpower8-vector");
  else if ((fnmask & (RS6000_BTM_P9_VECTOR | RS6000_BTM_64BIT))
	   == (RS6000_BTM_P9_VECTOR | RS6000_BTM_64BIT))
    error ("builtin function %qs requires the %qs and %qs options",
	   name, "-mcpu=power9", "-m64");
  else if ((fnmask & RS6000_BTM_P9_VECTOR) != 0)
    error ("builtin function %qs requires the %qs option", name,
	   "-mcpu=power9");
  else if ((fnmask & (RS6000_BTM_P9_MISC | RS6000_BTM_64BIT))
	   == (RS6000_BTM_P9_MISC | RS6000_BTM_64BIT))
    error ("builtin function %qs requires the %qs and %qs options",
	   name, "-mcpu=power9", "-m64");
  else if ((fnmask & RS6000_BTM_P9_MISC) == RS6000_BTM_P9_MISC)
    error ("builtin function %qs requires the %qs option", name,
	   "-mcpu=power9");
  else if ((fnmask & RS6000_BTM_LDBL128) == RS6000_BTM_LDBL128)
    {
      if (!TARGET_HARD_FLOAT)
	error ("builtin function %qs requires the %qs option", name,
	       "-mhard-float");
      else
	error ("builtin function %qs requires the %qs option", name,
	       TARGET_IEEEQUAD ? "-mabi=ibmlongdouble" : "-mlong-double-128");
    }
  else if ((fnmask & RS6000_BTM_HARD_FLOAT) != 0)
    error ("builtin function %qs requires the %qs option", name,
	   "-mhard-float");
  else if ((fnmask & RS6000_BTM_FLOAT128_HW) != 0)
    error ("builtin function %qs requires ISA 3.0 IEEE 128-bit floating point",
	   name);
  else if ((fnmask & RS6000_BTM_FLOAT128) != 0)
    error ("builtin function %qs requires the %qs option", name,
	   "%<-mfloat128%>");
  else if ((fnmask & (RS6000_BTM_POPCNTD | RS6000_BTM_POWERPC64))
	   == (RS6000_BTM_POPCNTD | RS6000_BTM_POWERPC64))
    error ("builtin function %qs requires the %qs (or newer), and "
	   "%qs or %qs options",
	   name, "-mcpu=power7", "-m64", "-mpowerpc64");
  else
    error ("builtin function %qs is not supported with the current options",
	   name);
}

/* Target hook for early folding of built-ins, shamelessly stolen
   from ia64.c.  */

static tree
rs6000_fold_builtin (tree fndecl ATTRIBUTE_UNUSED,
		     int n_args ATTRIBUTE_UNUSED,
		     tree *args ATTRIBUTE_UNUSED,
		     bool ignore ATTRIBUTE_UNUSED)
{
#ifdef SUBTARGET_FOLD_BUILTIN
  return SUBTARGET_FOLD_BUILTIN (fndecl, n_args, args, ignore);
#else
  return NULL_TREE;
#endif
}

/*  Helper function to sort out which built-ins may be valid without having
    a LHS.  */
static bool
rs6000_builtin_valid_without_lhs (enum rs6000_builtins fn_code)
{
  switch (fn_code)
    {
    case ALTIVEC_BUILTIN_STVX_V16QI:
    case ALTIVEC_BUILTIN_STVX_V8HI:
    case ALTIVEC_BUILTIN_STVX_V4SI:
    case ALTIVEC_BUILTIN_STVX_V4SF:
    case ALTIVEC_BUILTIN_STVX_V2DI:
    case ALTIVEC_BUILTIN_STVX_V2DF:
    case VSX_BUILTIN_STXVW4X_V16QI:
    case VSX_BUILTIN_STXVW4X_V8HI:
    case VSX_BUILTIN_STXVW4X_V4SF:
    case VSX_BUILTIN_STXVW4X_V4SI:
    case VSX_BUILTIN_STXVD2X_V2DF:
    case VSX_BUILTIN_STXVD2X_V2DI:
      return true;
    default:
      return false;
    }
}

/* Helper function to handle the gimple folding of a vector compare
   operation.  This sets up true/false vectors, and uses the
   VEC_COND_EXPR operation.
   CODE indicates which comparison is to be made. (EQ, GT, ...).
   TYPE indicates the type of the result.  */
static tree
fold_build_vec_cmp (tree_code code, tree type,
		    tree arg0, tree arg1)
{
  tree cmp_type = build_same_sized_truth_vector_type (type);
  tree zero_vec = build_zero_cst (type);
  tree minus_one_vec = build_minus_one_cst (type);
  tree cmp = fold_build2 (code, cmp_type, arg0, arg1);
  return fold_build3 (VEC_COND_EXPR, type, cmp, minus_one_vec, zero_vec);
}

/* Helper function to handle the in-between steps for the
   vector compare built-ins.  */
static void
fold_compare_helper (gimple_stmt_iterator *gsi, tree_code code, gimple *stmt)
{
  tree arg0 = gimple_call_arg (stmt, 0);
  tree arg1 = gimple_call_arg (stmt, 1);
  tree lhs = gimple_call_lhs (stmt);
  tree cmp = fold_build_vec_cmp (code, TREE_TYPE (lhs), arg0, arg1);
  gimple *g = gimple_build_assign (lhs, cmp);
  gimple_set_location (g, gimple_location (stmt));
  gsi_replace (gsi, g, true);
}

/* Helper function to map V2DF and V4SF types to their
 integral equivalents (V2DI and V4SI).  */
tree map_to_integral_tree_type (tree input_tree_type)
{
  if (INTEGRAL_TYPE_P (TREE_TYPE (input_tree_type)))
    return input_tree_type;
  else
    {
      if (types_compatible_p (TREE_TYPE (input_tree_type),
			      TREE_TYPE (V2DF_type_node)))
	return V2DI_type_node;
      else if (types_compatible_p (TREE_TYPE (input_tree_type),
				   TREE_TYPE (V4SF_type_node)))
	return V4SI_type_node;
      else
	gcc_unreachable ();
    }
}

/* Helper function to handle the vector merge[hl] built-ins.  The
   implementation difference between h and l versions for this code are in
   the values used when building of the permute vector for high word versus
   low word merge.  The variance is keyed off the use_high parameter.  */
static void
fold_mergehl_helper (gimple_stmt_iterator *gsi, gimple *stmt, int use_high)
{
  tree arg0 = gimple_call_arg (stmt, 0);
  tree arg1 = gimple_call_arg (stmt, 1);
  tree lhs = gimple_call_lhs (stmt);
  tree lhs_type = TREE_TYPE (lhs);
  int n_elts = TYPE_VECTOR_SUBPARTS (lhs_type);
  int midpoint = n_elts / 2;
  int offset = 0;

  if (use_high == 1)
    offset = midpoint;

  /* The permute_type will match the lhs for integral types.  For double and
     float types, the permute type needs to map to the V2 or V4 type that
     matches size.  */
  tree permute_type;
  permute_type = map_to_integral_tree_type (lhs_type);
  tree_vector_builder elts (permute_type, VECTOR_CST_NELTS (arg0), 1);

  for (int i = 0; i < midpoint; i++)
    {
      elts.safe_push (build_int_cst (TREE_TYPE (permute_type),
				     offset + i));
      elts.safe_push (build_int_cst (TREE_TYPE (permute_type),
				     offset + n_elts + i));
    }

  tree permute = elts.build ();

  gimple *g = gimple_build_assign (lhs, VEC_PERM_EXPR, arg0, arg1, permute);
  gimple_set_location (g, gimple_location (stmt));
  gsi_replace (gsi, g, true);
}

/* Helper function to handle the vector merge[eo] built-ins.  */
static void
fold_mergeeo_helper (gimple_stmt_iterator *gsi, gimple *stmt, int use_odd)
{
  tree arg0 = gimple_call_arg (stmt, 0);
  tree arg1 = gimple_call_arg (stmt, 1);
  tree lhs = gimple_call_lhs (stmt);
  tree lhs_type = TREE_TYPE (lhs);
  int n_elts = TYPE_VECTOR_SUBPARTS (lhs_type);

  /* The permute_type will match the lhs for integral types.  For double and
     float types, the permute type needs to map to the V2 or V4 type that
     matches size.  */
  tree permute_type;
  permute_type = map_to_integral_tree_type (lhs_type);

  tree_vector_builder elts (permute_type, VECTOR_CST_NELTS (arg0), 1);

 /* Build the permute vector.  */
  for (int i = 0; i < n_elts / 2; i++)
    {
      elts.safe_push (build_int_cst (TREE_TYPE (permute_type),
				     2*i + use_odd));
      elts.safe_push (build_int_cst (TREE_TYPE (permute_type),
				     2*i + use_odd + n_elts));
    }

  tree permute = elts.build ();

  gimple *g = gimple_build_assign (lhs, VEC_PERM_EXPR, arg0, arg1, permute);
  gimple_set_location (g, gimple_location (stmt));
  gsi_replace (gsi, g, true);
}

/* Fold a machine-dependent built-in in GIMPLE.  (For folding into
   a constant, use rs6000_fold_builtin.)  */

bool
rs6000_gimple_fold_builtin (gimple_stmt_iterator *gsi)
{
  gimple *stmt = gsi_stmt (*gsi);
  tree fndecl = gimple_call_fndecl (stmt);
  gcc_checking_assert (fndecl && DECL_BUILT_IN_CLASS (fndecl) == BUILT_IN_MD);
  enum rs6000_builtins fn_code
    = (enum rs6000_builtins) DECL_FUNCTION_CODE (fndecl);
  tree arg0, arg1, lhs, temp;
  enum tree_code bcode;
  gimple *g;

  size_t uns_fncode = (size_t) fn_code;
  enum insn_code icode = rs6000_builtin_info[uns_fncode].icode;
  const char *fn_name1 = rs6000_builtin_info[uns_fncode].name;
  const char *fn_name2 = (icode != CODE_FOR_nothing)
			  ? get_insn_name ((int) icode)
			  : "nothing";

  if (TARGET_DEBUG_BUILTIN)
      fprintf (stderr, "rs6000_gimple_fold_builtin %d %s %s\n",
	       fn_code, fn_name1, fn_name2);

  if (!rs6000_fold_gimple)
    return false;

  /* Prevent gimple folding for code that does not have a LHS, unless it is
     allowed per the rs6000_builtin_valid_without_lhs helper function.  */
  if (!gimple_call_lhs (stmt) && !rs6000_builtin_valid_without_lhs (fn_code))
    return false;

  /* Don't fold invalid builtins, let rs6000_expand_builtin diagnose it.  */
  HOST_WIDE_INT mask = rs6000_builtin_info[uns_fncode].mask;
  bool func_valid_p = (rs6000_builtin_mask & mask) == mask;
  if (!func_valid_p)
    return false;

  switch (fn_code)
    {
    /* Flavors of vec_add.  We deliberately don't expand
       P8V_BUILTIN_VADDUQM as it gets lowered from V1TImode to
       TImode, resulting in much poorer code generation.  */
    case ALTIVEC_BUILTIN_VADDUBM:
    case ALTIVEC_BUILTIN_VADDUHM:
    case ALTIVEC_BUILTIN_VADDUWM:
    case P8V_BUILTIN_VADDUDM:
    case ALTIVEC_BUILTIN_VADDFP:
    case VSX_BUILTIN_XVADDDP:
      bcode = PLUS_EXPR;
    do_binary:
      arg0 = gimple_call_arg (stmt, 0);
      arg1 = gimple_call_arg (stmt, 1);
      lhs = gimple_call_lhs (stmt);
      if (INTEGRAL_TYPE_P (TREE_TYPE (TREE_TYPE (lhs)))
	  && !TYPE_OVERFLOW_WRAPS (TREE_TYPE (TREE_TYPE (lhs))))
	{
	  /* Ensure the binary operation is performed in a type
	     that wraps if it is integral type.  */
	  gimple_seq stmts = NULL;
	  tree type = unsigned_type_for (TREE_TYPE (lhs));
	  tree uarg0 = gimple_build (&stmts, VIEW_CONVERT_EXPR,
				     type, arg0);
	  tree uarg1 = gimple_build (&stmts, VIEW_CONVERT_EXPR,
				     type, arg1);
	  tree res = gimple_build (&stmts, gimple_location (stmt), bcode,
				   type, uarg0, uarg1);
	  gsi_insert_seq_before (gsi, stmts, GSI_SAME_STMT);
	  g = gimple_build_assign (lhs, VIEW_CONVERT_EXPR,
				   build1 (VIEW_CONVERT_EXPR,
					   TREE_TYPE (lhs), res));
	  gsi_replace (gsi, g, true);
	  return true;
	}
      g = gimple_build_assign (lhs, bcode, arg0, arg1);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
    /* Flavors of vec_sub.  We deliberately don't expand
       P8V_BUILTIN_VSUBUQM. */
    case ALTIVEC_BUILTIN_VSUBUBM:
    case ALTIVEC_BUILTIN_VSUBUHM:
    case ALTIVEC_BUILTIN_VSUBUWM:
    case P8V_BUILTIN_VSUBUDM:
    case ALTIVEC_BUILTIN_VSUBFP:
    case VSX_BUILTIN_XVSUBDP:
      bcode = MINUS_EXPR;
      goto do_binary;
    case VSX_BUILTIN_XVMULSP:
    case VSX_BUILTIN_XVMULDP:
      arg0 = gimple_call_arg (stmt, 0);
      arg1 = gimple_call_arg (stmt, 1);
      lhs = gimple_call_lhs (stmt);
      g = gimple_build_assign (lhs, MULT_EXPR, arg0, arg1);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
    /* Even element flavors of vec_mul (signed). */
    case ALTIVEC_BUILTIN_VMULESB:
    case ALTIVEC_BUILTIN_VMULESH:
    case P8V_BUILTIN_VMULESW:
    /* Even element flavors of vec_mul (unsigned).  */
    case ALTIVEC_BUILTIN_VMULEUB:
    case ALTIVEC_BUILTIN_VMULEUH:
    case P8V_BUILTIN_VMULEUW:
      arg0 = gimple_call_arg (stmt, 0);
      arg1 = gimple_call_arg (stmt, 1);
      lhs = gimple_call_lhs (stmt);
      g = gimple_build_assign (lhs, VEC_WIDEN_MULT_EVEN_EXPR, arg0, arg1);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
    /* Odd element flavors of vec_mul (signed).  */
    case ALTIVEC_BUILTIN_VMULOSB:
    case ALTIVEC_BUILTIN_VMULOSH:
    case P8V_BUILTIN_VMULOSW:
    /* Odd element flavors of vec_mul (unsigned). */
    case ALTIVEC_BUILTIN_VMULOUB:
    case ALTIVEC_BUILTIN_VMULOUH:
    case P8V_BUILTIN_VMULOUW:
      arg0 = gimple_call_arg (stmt, 0);
      arg1 = gimple_call_arg (stmt, 1);
      lhs = gimple_call_lhs (stmt);
      g = gimple_build_assign (lhs, VEC_WIDEN_MULT_ODD_EXPR, arg0, arg1);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
    /* Flavors of vec_div (Integer).  */
    case VSX_BUILTIN_DIV_V2DI:
    case VSX_BUILTIN_UDIV_V2DI:
      arg0 = gimple_call_arg (stmt, 0);
      arg1 = gimple_call_arg (stmt, 1);
      lhs = gimple_call_lhs (stmt);
      g = gimple_build_assign (lhs, TRUNC_DIV_EXPR, arg0, arg1);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
    /* Flavors of vec_div (Float).  */
    case VSX_BUILTIN_XVDIVSP:
    case VSX_BUILTIN_XVDIVDP:
      arg0 = gimple_call_arg (stmt, 0);
      arg1 = gimple_call_arg (stmt, 1);
      lhs = gimple_call_lhs (stmt);
      g = gimple_build_assign (lhs, RDIV_EXPR, arg0, arg1);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
    /* Flavors of vec_and.  */
    case ALTIVEC_BUILTIN_VAND:
      arg0 = gimple_call_arg (stmt, 0);
      arg1 = gimple_call_arg (stmt, 1);
      lhs = gimple_call_lhs (stmt);
      g = gimple_build_assign (lhs, BIT_AND_EXPR, arg0, arg1);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
    /* Flavors of vec_andc.  */
    case ALTIVEC_BUILTIN_VANDC:
      arg0 = gimple_call_arg (stmt, 0);
      arg1 = gimple_call_arg (stmt, 1);
      lhs = gimple_call_lhs (stmt);
      temp = create_tmp_reg_or_ssa_name (TREE_TYPE (arg1));
      g = gimple_build_assign (temp, BIT_NOT_EXPR, arg1);
      gimple_set_location (g, gimple_location (stmt));
      gsi_insert_before (gsi, g, GSI_SAME_STMT);
      g = gimple_build_assign (lhs, BIT_AND_EXPR, arg0, temp);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
    /* Flavors of vec_nand.  */
    case P8V_BUILTIN_VEC_NAND:
    case P8V_BUILTIN_NAND_V16QI:
    case P8V_BUILTIN_NAND_V8HI:
    case P8V_BUILTIN_NAND_V4SI:
    case P8V_BUILTIN_NAND_V4SF:
    case P8V_BUILTIN_NAND_V2DF:
    case P8V_BUILTIN_NAND_V2DI:
      arg0 = gimple_call_arg (stmt, 0);
      arg1 = gimple_call_arg (stmt, 1);
      lhs = gimple_call_lhs (stmt);
      temp = create_tmp_reg_or_ssa_name (TREE_TYPE (arg1));
      g = gimple_build_assign (temp, BIT_AND_EXPR, arg0, arg1);
      gimple_set_location (g, gimple_location (stmt));
      gsi_insert_before (gsi, g, GSI_SAME_STMT);
      g = gimple_build_assign (lhs, BIT_NOT_EXPR, temp);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
    /* Flavors of vec_or.  */
    case ALTIVEC_BUILTIN_VOR:
      arg0 = gimple_call_arg (stmt, 0);
      arg1 = gimple_call_arg (stmt, 1);
      lhs = gimple_call_lhs (stmt);
      g = gimple_build_assign (lhs, BIT_IOR_EXPR, arg0, arg1);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
    /* flavors of vec_orc.  */
    case P8V_BUILTIN_ORC_V16QI:
    case P8V_BUILTIN_ORC_V8HI:
    case P8V_BUILTIN_ORC_V4SI:
    case P8V_BUILTIN_ORC_V4SF:
    case P8V_BUILTIN_ORC_V2DF:
    case P8V_BUILTIN_ORC_V2DI:
      arg0 = gimple_call_arg (stmt, 0);
      arg1 = gimple_call_arg (stmt, 1);
      lhs = gimple_call_lhs (stmt);
      temp = create_tmp_reg_or_ssa_name (TREE_TYPE (arg1));
      g = gimple_build_assign (temp, BIT_NOT_EXPR, arg1);
      gimple_set_location (g, gimple_location (stmt));
      gsi_insert_before (gsi, g, GSI_SAME_STMT);
      g = gimple_build_assign (lhs, BIT_IOR_EXPR, arg0, temp);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
    /* Flavors of vec_xor.  */
    case ALTIVEC_BUILTIN_VXOR:
      arg0 = gimple_call_arg (stmt, 0);
      arg1 = gimple_call_arg (stmt, 1);
      lhs = gimple_call_lhs (stmt);
      g = gimple_build_assign (lhs, BIT_XOR_EXPR, arg0, arg1);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
    /* Flavors of vec_nor.  */
    case ALTIVEC_BUILTIN_VNOR:
      arg0 = gimple_call_arg (stmt, 0);
      arg1 = gimple_call_arg (stmt, 1);
      lhs = gimple_call_lhs (stmt);
      temp = create_tmp_reg_or_ssa_name (TREE_TYPE (arg1));
      g = gimple_build_assign (temp, BIT_IOR_EXPR, arg0, arg1);
      gimple_set_location (g, gimple_location (stmt));
      gsi_insert_before (gsi, g, GSI_SAME_STMT);
      g = gimple_build_assign (lhs, BIT_NOT_EXPR, temp);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
    /* flavors of vec_abs.  */
    case ALTIVEC_BUILTIN_ABS_V16QI:
    case ALTIVEC_BUILTIN_ABS_V8HI:
    case ALTIVEC_BUILTIN_ABS_V4SI:
    case ALTIVEC_BUILTIN_ABS_V4SF:
    case P8V_BUILTIN_ABS_V2DI:
    case VSX_BUILTIN_XVABSDP:
      arg0 = gimple_call_arg (stmt, 0);
      if (INTEGRAL_TYPE_P (TREE_TYPE (TREE_TYPE (arg0)))
	  && !TYPE_OVERFLOW_WRAPS (TREE_TYPE (TREE_TYPE (arg0))))
	return false;
      lhs = gimple_call_lhs (stmt);
      g = gimple_build_assign (lhs, ABS_EXPR, arg0);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
    /* flavors of vec_min.  */
    case VSX_BUILTIN_XVMINDP:
    case P8V_BUILTIN_VMINSD:
    case P8V_BUILTIN_VMINUD:
    case ALTIVEC_BUILTIN_VMINSB:
    case ALTIVEC_BUILTIN_VMINSH:
    case ALTIVEC_BUILTIN_VMINSW:
    case ALTIVEC_BUILTIN_VMINUB:
    case ALTIVEC_BUILTIN_VMINUH:
    case ALTIVEC_BUILTIN_VMINUW:
    case ALTIVEC_BUILTIN_VMINFP:
      arg0 = gimple_call_arg (stmt, 0);
      arg1 = gimple_call_arg (stmt, 1);
      lhs = gimple_call_lhs (stmt);
      g = gimple_build_assign (lhs, MIN_EXPR, arg0, arg1);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
    /* flavors of vec_max.  */
    case VSX_BUILTIN_XVMAXDP:
    case P8V_BUILTIN_VMAXSD:
    case P8V_BUILTIN_VMAXUD:
    case ALTIVEC_BUILTIN_VMAXSB:
    case ALTIVEC_BUILTIN_VMAXSH:
    case ALTIVEC_BUILTIN_VMAXSW:
    case ALTIVEC_BUILTIN_VMAXUB:
    case ALTIVEC_BUILTIN_VMAXUH:
    case ALTIVEC_BUILTIN_VMAXUW:
    case ALTIVEC_BUILTIN_VMAXFP:
      arg0 = gimple_call_arg (stmt, 0);
      arg1 = gimple_call_arg (stmt, 1);
      lhs = gimple_call_lhs (stmt);
      g = gimple_build_assign (lhs, MAX_EXPR, arg0, arg1);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
    /* Flavors of vec_eqv.  */
    case P8V_BUILTIN_EQV_V16QI:
    case P8V_BUILTIN_EQV_V8HI:
    case P8V_BUILTIN_EQV_V4SI:
    case P8V_BUILTIN_EQV_V4SF:
    case P8V_BUILTIN_EQV_V2DF:
    case P8V_BUILTIN_EQV_V2DI:
      arg0 = gimple_call_arg (stmt, 0);
      arg1 = gimple_call_arg (stmt, 1);
      lhs = gimple_call_lhs (stmt);
      temp = create_tmp_reg_or_ssa_name (TREE_TYPE (arg1));
      g = gimple_build_assign (temp, BIT_XOR_EXPR, arg0, arg1);
      gimple_set_location (g, gimple_location (stmt));
      gsi_insert_before (gsi, g, GSI_SAME_STMT);
      g = gimple_build_assign (lhs, BIT_NOT_EXPR, temp);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
    /* Flavors of vec_rotate_left.  */
    case ALTIVEC_BUILTIN_VRLB:
    case ALTIVEC_BUILTIN_VRLH:
    case ALTIVEC_BUILTIN_VRLW:
    case P8V_BUILTIN_VRLD:
      arg0 = gimple_call_arg (stmt, 0);
      arg1 = gimple_call_arg (stmt, 1);
      lhs = gimple_call_lhs (stmt);
      g = gimple_build_assign (lhs, LROTATE_EXPR, arg0, arg1);
      gimple_set_location (g, gimple_location (stmt));
      gsi_replace (gsi, g, true);
      return true;
  /* Flavors of vector shift right algebraic.
     vec_sra{b,h,w} -> vsra{b,h,w}.  */
    case ALTIVEC_BUILTIN_VSRAB:
    case ALTIVEC_BUILTIN_VSRAH:
    case ALTIVEC_BUILTIN_VSRAW:
    case P8V_BUILTIN_VSRAD:
      {
	arg0 = gimple_call_arg (stmt, 0);
	arg1 = gimple_call_arg (stmt, 1);
	lhs = gimple_call_lhs (stmt);
	tree arg1_type = TREE_TYPE (arg1);
	tree unsigned_arg1_type = unsigned_type_for (TREE_TYPE (arg1));
	tree unsigned_element_type = unsigned_type_for (TREE_TYPE (arg1_type));
	location_t loc = gimple_location (stmt);
	/* Force arg1 into the range valid matching the arg0 type.  */
	/* Build a vector consisting of the max valid bit-size values.  */
	int n_elts = VECTOR_CST_NELTS (arg1);
	tree element_size = build_int_cst (unsigned_element_type,
					   128 / n_elts);
	tree_vector_builder elts (unsigned_arg1_type, n_elts, 1);
	for (int i = 0; i < n_elts; i++)
	  elts.safe_push (element_size);
	tree modulo_tree = elts.build ();
	/* Modulo the provided shift value against that vector.  */
	gimple_seq stmts = NULL;
	tree unsigned_arg1 = gimple_build (&stmts, VIEW_CONVERT_EXPR,
					   unsigned_arg1_type, arg1);
	tree new_arg1 = gimple_build (&stmts, loc, TRUNC_MOD_EXPR,
				      unsigned_arg1_type, unsigned_arg1,
				      modulo_tree);
	gsi_insert_seq_before (gsi, stmts, GSI_SAME_STMT);
	/* And finally, do the shift.  */
	g = gimple_build_assign (lhs, RSHIFT_EXPR, arg0, new_arg1);
	gimple_set_location (g, loc);
	gsi_replace (gsi, g, true);
	return true;
      }
   /* Flavors of vector shift left.
      builtin_altivec_vsl{b,h,w} -> vsl{b,h,w}.  */
    case ALTIVEC_BUILTIN_VSLB:
    case ALTIVEC_BUILTIN_VSLH:
    case ALTIVEC_BUILTIN_VSLW:
    case P8V_BUILTIN_VSLD:
      {
	location_t loc;
	gimple_seq stmts = NULL;
	arg0 = gimple_call_arg (stmt, 0);
	tree arg0_type = TREE_TYPE (arg0);
	if (INTEGRAL_TYPE_P (TREE_TYPE (arg0_type))
	    && !TYPE_OVERFLOW_WRAPS (TREE_TYPE (arg0_type)))
	  return false;
	arg1 = gimple_call_arg (stmt, 1);
	tree arg1_type = TREE_TYPE (arg1);
	tree unsigned_arg1_type = unsigned_type_for (TREE_TYPE (arg1));
	tree unsigned_element_type = unsigned_type_for (TREE_TYPE (arg1_type));
	loc = gimple_location (stmt);
	lhs = gimple_call_lhs (stmt);
	/* Force arg1 into the range valid matching the arg0 type.  */
	/* Build a vector consisting of the max valid bit-size values.  */
	int n_elts = VECTOR_CST_NELTS (arg1);
	int tree_size_in_bits = TREE_INT_CST_LOW (size_in_bytes (arg1_type))
				* BITS_PER_UNIT;
	tree element_size = build_int_cst (unsigned_element_type,
					   tree_size_in_bits / n_elts);
	tree_vector_builder elts (unsigned_type_for (arg1_type), n_elts, 1);
	for (int i = 0; i < n_elts; i++)
	  elts.safe_push (element_size);
	tree modulo_tree = elts.build ();
	/* Modulo the provided shift value against that vector.  */
	tree unsigned_arg1 = gimple_build (&stmts, VIEW_CONVERT_EXPR,
					   unsigned_arg1_type, arg1);
	tree new_arg1 = gimple_build (&stmts, loc, TRUNC_MOD_EXPR,
				      unsigned_arg1_type, unsigned_arg1,
				      modulo_tree);
	gsi_insert_seq_before (gsi, stmts, GSI_SAME_STMT);
	/* And finally, do the shift.  */
	g = gimple_build_assign (lhs, LSHIFT_EXPR, arg0, new_arg1);
	gimple_set_location (g, gimple_location (stmt));
	gsi_replace (gsi, g, true);
	return true;
      }
    /* Flavors of vector shift right.  */
    case ALTIVEC_BUILTIN_VSRB:
    case ALTIVEC_BUILTIN_VSRH:
    case ALTIVEC_BUILTIN_VSRW:
    case P8V_BUILTIN_VSRD:
      {
	arg0 = gimple_call_arg (stmt, 0);
	arg1 = gimple_call_arg (stmt, 1);
	lhs = gimple_call_lhs (stmt);
	tree arg1_type = TREE_TYPE (arg1);
	tree unsigned_arg1_type = unsigned_type_for (TREE_TYPE (arg1));
	tree unsigned_element_type = unsigned_type_for (TREE_TYPE (arg1_type));
	location_t loc = gimple_location (stmt);
	gimple_seq stmts = NULL;
	/* Convert arg0 to unsigned.  */
	tree arg0_unsigned
	  = gimple_build (&stmts, VIEW_CONVERT_EXPR,
			  unsigned_type_for (TREE_TYPE (arg0)), arg0);
	/* Force arg1 into the range valid matching the arg0 type.  */
	/* Build a vector consisting of the max valid bit-size values.  */
	int n_elts = VECTOR_CST_NELTS (arg1);
	tree element_size = build_int_cst (unsigned_element_type,
					   128 / n_elts);
	tree_vector_builder elts (unsigned_arg1_type, n_elts, 1);
	for (int i = 0; i < n_elts; i++)
	  elts.safe_push (element_size);
	tree modulo_tree = elts.build ();
	/* Modulo the provided shift value against that vector.  */
	tree unsigned_arg1 = gimple_build (&stmts, VIEW_CONVERT_EXPR,
					   unsigned_arg1_type, arg1);
	tree new_arg1 = gimple_build (&stmts, loc, TRUNC_MOD_EXPR,
				      unsigned_arg1_type, unsigned_arg1,
				      modulo_tree);
	/* Do the shift.  */
	tree res
	  = gimple_build (&stmts, RSHIFT_EXPR,
			  TREE_TYPE (arg0_unsigned), arg0_unsigned, new_arg1);
	/* Convert result back to the lhs type.  */
	res = gimple_build (&stmts, VIEW_CONVERT_EXPR, TREE_TYPE (lhs), res);
	gsi_insert_seq_before (gsi, stmts, GSI_SAME_STMT);
	update_call_from_tree (gsi, res);
	return true;
      }
    /* Vector loads.  */
    case ALTIVEC_BUILTIN_LVX_V16QI:
    case ALTIVEC_BUILTIN_LVX_V8HI:
    case ALTIVEC_BUILTIN_LVX_V4SI:
    case ALTIVEC_BUILTIN_LVX_V4SF:
    case ALTIVEC_BUILTIN_LVX_V2DI:
    case ALTIVEC_BUILTIN_LVX_V2DF:
    case ALTIVEC_BUILTIN_LVX_V1TI:
      {
	arg0 = gimple_call_arg (stmt, 0);  // offset
	arg1 = gimple_call_arg (stmt, 1);  // address
	lhs = gimple_call_lhs (stmt);
	location_t loc = gimple_location (stmt);
	/* Since arg1 may be cast to a different type, just use ptr_type_node
	   here instead of trying to enforce TBAA on pointer types.  */
	tree arg1_type = ptr_type_node;
	tree lhs_type = TREE_TYPE (lhs);
	/* POINTER_PLUS_EXPR wants the offset to be of type 'sizetype'.  Create
	   the tree using the value from arg0.  The resulting type will match
	   the type of arg1.  */
	gimple_seq stmts = NULL;
	tree temp_offset = gimple_convert (&stmts, loc, sizetype, arg0);
	tree temp_addr = gimple_build (&stmts, loc, POINTER_PLUS_EXPR,
				       arg1_type, arg1, temp_offset);
	/* Mask off any lower bits from the address.  */
	tree aligned_addr = gimple_build (&stmts, loc, BIT_AND_EXPR,
					  arg1_type, temp_addr,
					  build_int_cst (arg1_type, -16));
	gsi_insert_seq_before (gsi, stmts, GSI_SAME_STMT);
	if (!is_gimple_mem_ref_addr (aligned_addr))
	  {
	    tree t = make_ssa_name (TREE_TYPE (aligned_addr));
	    gimple *g = gimple_build_assign (t, aligned_addr);
	    gsi_insert_before (gsi, g, GSI_SAME_STMT);
	    aligned_addr = t;
	  }
	/* Use the build2 helper to set up the mem_ref.  The MEM_REF could also
	   take an offset, but since we've already incorporated the offset
	   above, here we just pass in a zero.  */
	gimple *g
	  = gimple_build_assign (lhs, build2 (MEM_REF, lhs_type, aligned_addr,
					      build_int_cst (arg1_type, 0)));
	gimple_set_location (g, loc);
	gsi_replace (gsi, g, true);
	return true;
      }
    /* Vector stores.  */
    case ALTIVEC_BUILTIN_STVX_V16QI:
    case ALTIVEC_BUILTIN_STVX_V8HI:
    case ALTIVEC_BUILTIN_STVX_V4SI:
    case ALTIVEC_BUILTIN_STVX_V4SF:
    case ALTIVEC_BUILTIN_STVX_V2DI:
    case ALTIVEC_BUILTIN_STVX_V2DF:
      {
	arg0 = gimple_call_arg (stmt, 0); /* Value to be stored.  */
	arg1 = gimple_call_arg (stmt, 1); /* Offset.  */
	tree arg2 = gimple_call_arg (stmt, 2); /* Store-to address.  */
	location_t loc = gimple_location (stmt);
	tree arg0_type = TREE_TYPE (arg0);
	/* Use ptr_type_node (no TBAA) for the arg2_type.
	   FIXME: (Richard)  "A proper fix would be to transition this type as
	   seen from the frontend to GIMPLE, for example in a similar way we
	   do for MEM_REFs by piggy-backing that on an extra argument, a
	   constant zero pointer of the alias pointer type to use (which would
	   also serve as a type indicator of the store itself).  I'd use a
	   target specific internal function for this (not sure if we can have
	   those target specific, but I guess if it's folded away then that's
	   fine) and get away with the overload set."  */
	tree arg2_type = ptr_type_node;
	/* POINTER_PLUS_EXPR wants the offset to be of type 'sizetype'.  Create
	   the tree using the value from arg0.  The resulting type will match
	   the type of arg2.  */
	gimple_seq stmts = NULL;
	tree temp_offset = gimple_convert (&stmts, loc, sizetype, arg1);
	tree temp_addr = gimple_build (&stmts, loc, POINTER_PLUS_EXPR,
				       arg2_type, arg2, temp_offset);
	/* Mask off any lower bits from the address.  */
	tree aligned_addr = gimple_build (&stmts, loc, BIT_AND_EXPR,
					  arg2_type, temp_addr,
					  build_int_cst (arg2_type, -16));
	gsi_insert_seq_before (gsi, stmts, GSI_SAME_STMT);
	if (!is_gimple_mem_ref_addr (aligned_addr))
	  {
	    tree t = make_ssa_name (TREE_TYPE (aligned_addr));
	    gimple *g = gimple_build_assign (t, aligned_addr);
	    gsi_insert_before (gsi, g, GSI_SAME_STMT);
	    aligned_addr = t;
	  }
	/* The desired gimple result should be similar to:
	   MEM[(__vector floatD.1407 *)_1] = vf1D.2697;  */
	gimple *g
	  = gimple_build_assign (build2 (MEM_REF, arg0_type, aligned_addr,
					 build_int_cst (arg2_type, 0)), arg0);
	gimple_set_location (g, loc);
	gsi_replace (gsi, g, true);
	return true;
      }

    /* unaligned Vector loads.  */
    case VSX_BUILTIN_LXVW4X_V16QI:
    case VSX_BUILTIN_LXVW4X_V8HI:
    case VSX_BUILTIN_LXVW4X_V4SF:
    case VSX_BUILTIN_LXVW4X_V4SI:
    case VSX_BUILTIN_LXVD2X_V2DF:
    case VSX_BUILTIN_LXVD2X_V2DI:
      {
	arg0 = gimple_call_arg (stmt, 0);  // offset
	arg1 = gimple_call_arg (stmt, 1);  // address
	lhs = gimple_call_lhs (stmt);
	location_t loc = gimple_location (stmt);
	/* Since arg1 may be cast to a different type, just use ptr_type_node
	   here instead of trying to enforce TBAA on pointer types.  */
	tree arg1_type = ptr_type_node;
	tree lhs_type = TREE_TYPE (lhs);
	/* In GIMPLE the type of the MEM_REF specifies the alignment.  The
	  required alignment (power) is 4 bytes regardless of data type.  */
	tree align_ltype = build_aligned_type (lhs_type, 4);
	/* POINTER_PLUS_EXPR wants the offset to be of type 'sizetype'.  Create
	   the tree using the value from arg0.  The resulting type will match
	   the type of arg1.  */
	gimple_seq stmts = NULL;
	tree temp_offset = gimple_convert (&stmts, loc, sizetype, arg0);
	tree temp_addr = gimple_build (&stmts, loc, POINTER_PLUS_EXPR,
				       arg1_type, arg1, temp_offset);
	gsi_insert_seq_before (gsi, stmts, GSI_SAME_STMT);
	if (!is_gimple_mem_ref_addr (temp_addr))
	  {
	    tree t = make_ssa_name (TREE_TYPE (temp_addr));
	    gimple *g = gimple_build_assign (t, temp_addr);
	    gsi_insert_before (gsi, g, GSI_SAME_STMT);
	    temp_addr = t;
	  }
	/* Use the build2 helper to set up the mem_ref.  The MEM_REF could also
	   take an offset, but since we've already incorporated the offset
	   above, here we just pass in a zero.  */
	gimple *g;
	g = gimple_build_assign (lhs, build2 (MEM_REF, align_ltype, temp_addr,
					      build_int_cst (arg1_type, 0)));
	gimple_set_location (g, loc);
	gsi_replace (gsi, g, true);
	return true;
      }

    /* unaligned Vector stores.  */
    case VSX_BUILTIN_STXVW4X_V16QI:
    case VSX_BUILTIN_STXVW4X_V8HI:
    case VSX_BUILTIN_STXVW4X_V4SF:
    case VSX_BUILTIN_STXVW4X_V4SI:
    case VSX_BUILTIN_STXVD2X_V2DF:
    case VSX_BUILTIN_STXVD2X_V2DI:
      {
	arg0 = gimple_call_arg (stmt, 0); /* Value to be stored.  */
	arg1 = gimple_call_arg (stmt, 1); /* Offset.  */
	tree arg2 = gimple_call_arg (stmt, 2); /* Store-to address.  */
	location_t loc = gimple_location (stmt);
	tree arg0_type = TREE_TYPE (arg0);
	/* Use ptr_type_node (no TBAA) for the arg2_type.  */
	tree arg2_type = ptr_type_node;
	/* In GIMPLE the type of the MEM_REF specifies the alignment.  The
	   required alignment (power) is 4 bytes regardless of data type.  */
	tree align_stype = build_aligned_type (arg0_type, 4);
	/* POINTER_PLUS_EXPR wants the offset to be of type 'sizetype'.  Create
	   the tree using the value from arg1.  */
	gimple_seq stmts = NULL;
	tree temp_offset = gimple_convert (&stmts, loc, sizetype, arg1);
	tree temp_addr = gimple_build (&stmts, loc, POINTER_PLUS_EXPR,
				       arg2_type, arg2, temp_offset);
	gsi_insert_seq_before (gsi, stmts, GSI_SAME_STMT);
	if (!is_gimple_mem_ref_addr (temp_addr))
	  {
	    tree t = make_ssa_name (TREE_TYPE (temp_addr));
	    gimple *g = gimple_build_assign (t, temp_addr);
	    gsi_insert_before (gsi, g, GSI_SAME_STMT);
	    temp_addr = t;
	  }
	gimple *g;
	g = gimple_build_assign (build2 (MEM_REF, align_stype, temp_addr,
					 build_int_cst (arg2_type, 0)), arg0);
	gimple_set_location (g, loc);
	gsi_replace (gsi, g, true);
	return true;
      }

    /* Vector Fused multiply-add (fma).  */
    case ALTIVEC_BUILTIN_VMADDFP:
    case VSX_BUILTIN_XVMADDDP:
    case ALTIVEC_BUILTIN_VMLADDUHM:
      {
	arg0 = gimple_call_arg (stmt, 0);
	arg1 = gimple_call_arg (stmt, 1);
	tree arg2 = gimple_call_arg (stmt, 2);
	lhs = gimple_call_lhs (stmt);
	gcall *g = gimple_build_call_internal (IFN_FMA, 3, arg0, arg1, arg2);
	gimple_call_set_lhs (g, lhs);
	gimple_call_set_nothrow (g, true);
	gimple_set_location (g, gimple_location (stmt));
	gsi_replace (gsi, g, true);
	return true;
      }

    /* Vector compares; EQ, NE, GE, GT, LE.  */
    case ALTIVEC_BUILTIN_VCMPEQUB:
    case ALTIVEC_BUILTIN_VCMPEQUH:
    case ALTIVEC_BUILTIN_VCMPEQUW:
    case P8V_BUILTIN_VCMPEQUD:
      fold_compare_helper (gsi, EQ_EXPR, stmt);
      return true;

    case P9V_BUILTIN_CMPNEB:
    case P9V_BUILTIN_CMPNEH:
    case P9V_BUILTIN_CMPNEW:
      fold_compare_helper (gsi, NE_EXPR, stmt);
      return true;

    case VSX_BUILTIN_CMPGE_16QI:
    case VSX_BUILTIN_CMPGE_U16QI:
    case VSX_BUILTIN_CMPGE_8HI:
    case VSX_BUILTIN_CMPGE_U8HI:
    case VSX_BUILTIN_CMPGE_4SI:
    case VSX_BUILTIN_CMPGE_U4SI:
    case VSX_BUILTIN_CMPGE_2DI:
    case VSX_BUILTIN_CMPGE_U2DI:
      fold_compare_helper (gsi, GE_EXPR, stmt);
      return true;

    case ALTIVEC_BUILTIN_VCMPGTSB:
    case ALTIVEC_BUILTIN_VCMPGTUB:
    case ALTIVEC_BUILTIN_VCMPGTSH:
    case ALTIVEC_BUILTIN_VCMPGTUH:
    case ALTIVEC_BUILTIN_VCMPGTSW:
    case ALTIVEC_BUILTIN_VCMPGTUW:
    case P8V_BUILTIN_VCMPGTUD:
    case P8V_BUILTIN_VCMPGTSD:
      fold_compare_helper (gsi, GT_EXPR, stmt);
      return true;

    case VSX_BUILTIN_CMPLE_16QI:
    case VSX_BUILTIN_CMPLE_U16QI:
    case VSX_BUILTIN_CMPLE_8HI:
    case VSX_BUILTIN_CMPLE_U8HI:
    case VSX_BUILTIN_CMPLE_4SI:
    case VSX_BUILTIN_CMPLE_U4SI:
    case VSX_BUILTIN_CMPLE_2DI:
    case VSX_BUILTIN_CMPLE_U2DI:
      fold_compare_helper (gsi, LE_EXPR, stmt);
      return true;

    /* flavors of vec_splat_[us]{8,16,32}.  */
    case ALTIVEC_BUILTIN_VSPLTISB:
    case ALTIVEC_BUILTIN_VSPLTISH:
    case ALTIVEC_BUILTIN_VSPLTISW:
      {
	arg0 = gimple_call_arg (stmt, 0);
	lhs = gimple_call_lhs (stmt);

	/* Only fold the vec_splat_*() if the lower bits of arg 0 is a
	   5-bit signed constant in range -16 to +15.  */
	if (TREE_CODE (arg0) != INTEGER_CST
	    || !IN_RANGE (TREE_INT_CST_LOW (arg0), -16, 15))
	  return false;
	gimple_seq stmts = NULL;
	location_t loc = gimple_location (stmt);
	tree splat_value = gimple_convert (&stmts, loc,
					   TREE_TYPE (TREE_TYPE (lhs)), arg0);
	gsi_insert_seq_before (gsi, stmts, GSI_SAME_STMT);
	tree splat_tree = build_vector_from_val (TREE_TYPE (lhs), splat_value);
	g = gimple_build_assign (lhs, splat_tree);
	gimple_set_location (g, gimple_location (stmt));
	gsi_replace (gsi, g, true);
	return true;
      }

    /* Flavors of vec_splat.  */
    /* a = vec_splat (b, 0x3) becomes a = { b[3],b[3],b[3],...};  */
    case ALTIVEC_BUILTIN_VSPLTB:
    case ALTIVEC_BUILTIN_VSPLTH:
    case ALTIVEC_BUILTIN_VSPLTW:
    case VSX_BUILTIN_XXSPLTD_V2DI:
    case VSX_BUILTIN_XXSPLTD_V2DF:
      {
	arg0 = gimple_call_arg (stmt, 0); /* input vector.  */
	arg1 = gimple_call_arg (stmt, 1); /* index into arg0.  */
	/* Only fold the vec_splat_*() if arg1 is both a constant value and
	   is a valid index into the arg0 vector.  */
	unsigned int n_elts = VECTOR_CST_NELTS (arg0);
	if (TREE_CODE (arg1) != INTEGER_CST
	    || TREE_INT_CST_LOW (arg1) > (n_elts -1))
	  return false;
	lhs = gimple_call_lhs (stmt);
	tree lhs_type = TREE_TYPE (lhs);
	tree arg0_type = TREE_TYPE (arg0);
	tree splat;
	if (TREE_CODE (arg0) == VECTOR_CST)
	  splat = VECTOR_CST_ELT (arg0, TREE_INT_CST_LOW (arg1));
	else
	  {
	    /* Determine (in bits) the length and start location of the
	       splat value for a call to the tree_vec_extract helper.  */
	    int splat_elem_size = TREE_INT_CST_LOW (size_in_bytes (arg0_type))
				  * BITS_PER_UNIT / n_elts;
	    int splat_start_bit = TREE_INT_CST_LOW (arg1) * splat_elem_size;
	    tree len = build_int_cst (bitsizetype, splat_elem_size);
	    tree start = build_int_cst (bitsizetype, splat_start_bit);
	    splat = tree_vec_extract (gsi, TREE_TYPE (lhs_type), arg0,
				      len, start);
	  }
	/* And finally, build the new vector.  */
	tree splat_tree = build_vector_from_val (lhs_type, splat);
	g = gimple_build_assign (lhs, splat_tree);
	gimple_set_location (g, gimple_location (stmt));
	gsi_replace (gsi, g, true);
	return true;
      }

    /* vec_mergel (integrals).  */
    case ALTIVEC_BUILTIN_VMRGLH:
    case ALTIVEC_BUILTIN_VMRGLW:
    case VSX_BUILTIN_XXMRGLW_4SI:
    case ALTIVEC_BUILTIN_VMRGLB:
    case VSX_BUILTIN_VEC_MERGEL_V2DI:
    case VSX_BUILTIN_XXMRGLW_4SF:
    case VSX_BUILTIN_VEC_MERGEL_V2DF:
      fold_mergehl_helper (gsi, stmt, 1);
      return true;
    /* vec_mergeh (integrals).  */
    case ALTIVEC_BUILTIN_VMRGHH:
    case ALTIVEC_BUILTIN_VMRGHW:
    case VSX_BUILTIN_XXMRGHW_4SI:
    case ALTIVEC_BUILTIN_VMRGHB:
    case VSX_BUILTIN_VEC_MERGEH_V2DI:
    case VSX_BUILTIN_XXMRGHW_4SF:
    case VSX_BUILTIN_VEC_MERGEH_V2DF:
      fold_mergehl_helper (gsi, stmt, 0);
      return true;

    /* Flavors of vec_mergee.  */
    case P8V_BUILTIN_VMRGEW_V4SI:
    case P8V_BUILTIN_VMRGEW_V2DI:
    case P8V_BUILTIN_VMRGEW_V4SF:
    case P8V_BUILTIN_VMRGEW_V2DF:
      fold_mergeeo_helper (gsi, stmt, 0);
      return true;
    /* Flavors of vec_mergeo.  */
    case P8V_BUILTIN_VMRGOW_V4SI:
    case P8V_BUILTIN_VMRGOW_V2DI:
    case P8V_BUILTIN_VMRGOW_V4SF:
    case P8V_BUILTIN_VMRGOW_V2DF:
      fold_mergeeo_helper (gsi, stmt, 1);
      return true;

    /* d = vec_pack (a, b) */
    case P8V_BUILTIN_VPKUDUM:
    case ALTIVEC_BUILTIN_VPKUHUM:
    case ALTIVEC_BUILTIN_VPKUWUM:
      {
	arg0 = gimple_call_arg (stmt, 0);
	arg1 = gimple_call_arg (stmt, 1);
	lhs = gimple_call_lhs (stmt);
	gimple *g = gimple_build_assign (lhs, VEC_PACK_TRUNC_EXPR, arg0, arg1);
	gimple_set_location (g, gimple_location (stmt));
	gsi_replace (gsi, g, true);
	return true;
      }

    /* d = vec_unpackh (a) */
    /* Note that the UNPACK_{HI,LO}_EXPR used in the gimple_build_assign call
       in this code is sensitive to endian-ness, and needs to be inverted to
       handle both LE and BE targets.  */
    case ALTIVEC_BUILTIN_VUPKHSB:
    case ALTIVEC_BUILTIN_VUPKHSH:
    case P8V_BUILTIN_VUPKHSW:
      {
	arg0 = gimple_call_arg (stmt, 0);
	lhs = gimple_call_lhs (stmt);
	if (BYTES_BIG_ENDIAN)
	  g = gimple_build_assign (lhs, VEC_UNPACK_HI_EXPR, arg0);
	else
	  g = gimple_build_assign (lhs, VEC_UNPACK_LO_EXPR, arg0);
	gimple_set_location (g, gimple_location (stmt));
	gsi_replace (gsi, g, true);
	return true;
      }
    /* d = vec_unpackl (a) */
    case ALTIVEC_BUILTIN_VUPKLSB:
    case ALTIVEC_BUILTIN_VUPKLSH:
    case P8V_BUILTIN_VUPKLSW:
      {
	arg0 = gimple_call_arg (stmt, 0);
	lhs = gimple_call_lhs (stmt);
	if (BYTES_BIG_ENDIAN)
	  g = gimple_build_assign (lhs, VEC_UNPACK_LO_EXPR, arg0);
	else
	  g = gimple_build_assign (lhs, VEC_UNPACK_HI_EXPR, arg0);
	gimple_set_location (g, gimple_location (stmt));
	gsi_replace (gsi, g, true);
	return true;
      }
    /* There is no gimple type corresponding with pixel, so just return.  */
    case ALTIVEC_BUILTIN_VUPKHPX:
    case ALTIVEC_BUILTIN_VUPKLPX:
      return false;

    /* vec_perm.  */
    case ALTIVEC_BUILTIN_VPERM_16QI:
    case ALTIVEC_BUILTIN_VPERM_8HI:
    case ALTIVEC_BUILTIN_VPERM_4SI:
    case ALTIVEC_BUILTIN_VPERM_2DI:
    case ALTIVEC_BUILTIN_VPERM_4SF:
    case ALTIVEC_BUILTIN_VPERM_2DF:
      {
	arg0 = gimple_call_arg (stmt, 0);
	arg1 = gimple_call_arg (stmt, 1);
	tree permute = gimple_call_arg (stmt, 2);
	lhs = gimple_call_lhs (stmt);
	location_t loc = gimple_location (stmt);
	gimple_seq stmts = NULL;
	// convert arg0 and arg1 to match the type of the permute
	// for the VEC_PERM_EXPR operation.
	tree permute_type = (TREE_TYPE (permute));
	tree arg0_ptype = gimple_convert (&stmts, loc, permute_type, arg0);
	tree arg1_ptype = gimple_convert (&stmts, loc, permute_type, arg1);
	tree lhs_ptype = gimple_build (&stmts, loc, VEC_PERM_EXPR,
				      permute_type, arg0_ptype, arg1_ptype,
				      permute);
	// Convert the result back to the desired lhs type upon completion.
	tree temp = gimple_convert (&stmts, loc, TREE_TYPE (lhs), lhs_ptype);
	gsi_insert_seq_before (gsi, stmts, GSI_SAME_STMT);
	g = gimple_build_assign (lhs, temp);
	gimple_set_location (g, loc);
	gsi_replace (gsi, g, true);
	return true;
      }

    default:
      if (TARGET_DEBUG_BUILTIN)
	fprintf (stderr, "gimple builtin intrinsic not matched:%d %s %s\n",
		 fn_code, fn_name1, fn_name2);
      break;
    }

  return false;
}

/* Expand an expression EXP that calls a built-in function,
   with result going to TARGET if that's convenient
   (and in mode MODE if that's convenient).
   SUBTARGET may be used as the target for computing one of EXP's operands.
   IGNORE is nonzero if the value is to be ignored.  */

static rtx
rs6000_expand_builtin (tree exp, rtx target, rtx subtarget ATTRIBUTE_UNUSED,
		       machine_mode mode ATTRIBUTE_UNUSED,
		       int ignore ATTRIBUTE_UNUSED)
{
  tree fndecl = TREE_OPERAND (CALL_EXPR_FN (exp), 0);
  enum rs6000_builtins fcode
    = (enum rs6000_builtins)DECL_FUNCTION_CODE (fndecl);
  size_t uns_fcode = (size_t)fcode;
  const struct builtin_description *d;
  size_t i;
  rtx ret;
  bool success;
  HOST_WIDE_INT mask = rs6000_builtin_info[uns_fcode].mask;
  bool func_valid_p = ((rs6000_builtin_mask & mask) == mask);
  enum insn_code icode = rs6000_builtin_info[uns_fcode].icode;

  /* We have two different modes (KFmode, TFmode) that are the IEEE 128-bit
     floating point type, depending on whether long double is the IBM extended
     double (KFmode) or long double is IEEE 128-bit (TFmode).  It is simpler if
     we only define one variant of the built-in function, and switch the code
     when defining it, rather than defining two built-ins and using the
     overload table in rs6000-c.c to switch between the two.  If we don't have
     the proper assembler, don't do this switch because CODE_FOR_*kf* and
     CODE_FOR_*tf* will be CODE_FOR_nothing.  */
  if (FLOAT128_IEEE_P (TFmode))
    switch (icode)
      {
      default:
	break;

      case CODE_FOR_sqrtkf2_odd:	icode = CODE_FOR_sqrttf2_odd;	break;
      case CODE_FOR_trunckfdf2_odd:	icode = CODE_FOR_trunctfdf2_odd; break;
      case CODE_FOR_addkf3_odd:		icode = CODE_FOR_addtf3_odd;	break;
      case CODE_FOR_subkf3_odd:		icode = CODE_FOR_subtf3_odd;	break;
      case CODE_FOR_mulkf3_odd:		icode = CODE_FOR_multf3_odd;	break;
      case CODE_FOR_divkf3_odd:		icode = CODE_FOR_divtf3_odd;	break;
      case CODE_FOR_fmakf4_odd:		icode = CODE_FOR_fmatf4_odd;	break;
      case CODE_FOR_xsxexpqp_kf:	icode = CODE_FOR_xsxexpqp_tf;	break;
      case CODE_FOR_xsxsigqp_kf:	icode = CODE_FOR_xsxsigqp_tf;	break;
      case CODE_FOR_xststdcnegqp_kf:	icode = CODE_FOR_xststdcnegqp_tf; break;
      case CODE_FOR_xsiexpqp_kf:	icode = CODE_FOR_xsiexpqp_tf;	break;
      case CODE_FOR_xsiexpqpf_kf:	icode = CODE_FOR_xsiexpqpf_tf;	break;
      case CODE_FOR_xststdcqp_kf:	icode = CODE_FOR_xststdcqp_tf;	break;
      }

  if (TARGET_DEBUG_BUILTIN)
    {
      const char *name1 = rs6000_builtin_info[uns_fcode].name;
      const char *name2 = (icode != CODE_FOR_nothing)
			   ? get_insn_name ((int) icode)
			   : "nothing";
      const char *name3;

      switch (rs6000_builtin_info[uns_fcode].attr & RS6000_BTC_TYPE_MASK)
	{
	default:		   name3 = "unknown";	break;
	case RS6000_BTC_SPECIAL:   name3 = "special";	break;
	case RS6000_BTC_UNARY:	   name3 = "unary";	break;
	case RS6000_BTC_BINARY:	   name3 = "binary";	break;
	case RS6000_BTC_TERNARY:   name3 = "ternary";	break;
	case RS6000_BTC_PREDICATE: name3 = "predicate";	break;
	case RS6000_BTC_ABS:	   name3 = "abs";	break;
	case RS6000_BTC_DST:	   name3 = "dst";	break;
	}


      fprintf (stderr,
	       "rs6000_expand_builtin, %s (%d), insn = %s (%d), type=%s%s\n",
	       (name1) ? name1 : "---", fcode,
	       (name2) ? name2 : "---", (int) icode,
	       name3,
	       func_valid_p ? "" : ", not valid");
    }	     

  if (!func_valid_p)
    {
      rs6000_invalid_builtin (fcode);

      /* Given it is invalid, just generate a normal call.  */
      return expand_call (exp, target, ignore);
    }

  switch (fcode)
    {
    case RS6000_BUILTIN_RECIP:
      return rs6000_expand_binop_builtin (CODE_FOR_recipdf3, exp, target);

    case RS6000_BUILTIN_RECIPF:
      return rs6000_expand_binop_builtin (CODE_FOR_recipsf3, exp, target);

    case RS6000_BUILTIN_RSQRTF:
      return rs6000_expand_unop_builtin (CODE_FOR_rsqrtsf2, exp, target);

    case RS6000_BUILTIN_RSQRT:
      return rs6000_expand_unop_builtin (CODE_FOR_rsqrtdf2, exp, target);

    case POWER7_BUILTIN_BPERMD:
      return rs6000_expand_binop_builtin (((TARGET_64BIT)
					   ? CODE_FOR_bpermd_di
					   : CODE_FOR_bpermd_si), exp, target);

    case RS6000_BUILTIN_GET_TB:
      return rs6000_expand_zeroop_builtin (CODE_FOR_rs6000_get_timebase,
					   target);

    case RS6000_BUILTIN_MFTB:
      return rs6000_expand_zeroop_builtin (((TARGET_64BIT)
					    ? CODE_FOR_rs6000_mftb_di
					    : CODE_FOR_rs6000_mftb_si),
					   target);

    case RS6000_BUILTIN_MFFS:
      return rs6000_expand_zeroop_builtin (CODE_FOR_rs6000_mffs, target);

    case RS6000_BUILTIN_MTFSB0:
      return rs6000_expand_mtfsb_builtin (CODE_FOR_rs6000_mtfsb0, exp);

    case RS6000_BUILTIN_MTFSB1:
      return rs6000_expand_mtfsb_builtin (CODE_FOR_rs6000_mtfsb1, exp);

    case RS6000_BUILTIN_SET_FPSCR_RN:
      return rs6000_expand_set_fpscr_rn_builtin (CODE_FOR_rs6000_set_fpscr_rn,
						 exp);

    case RS6000_BUILTIN_SET_FPSCR_DRN:
      return
        rs6000_expand_set_fpscr_drn_builtin (CODE_FOR_rs6000_set_fpscr_drn,
					     exp);

    case RS6000_BUILTIN_MFFSL:
      return rs6000_expand_zeroop_builtin (CODE_FOR_rs6000_mffsl, target);

    case RS6000_BUILTIN_MTFSF:
      return rs6000_expand_mtfsf_builtin (CODE_FOR_rs6000_mtfsf, exp);

    case RS6000_BUILTIN_CPU_INIT:
    case RS6000_BUILTIN_CPU_IS:
    case RS6000_BUILTIN_CPU_SUPPORTS:
      return cpu_expand_builtin (fcode, exp, target);

    case MISC_BUILTIN_SPEC_BARRIER:
      {
	emit_insn (gen_speculation_barrier ());
	return NULL_RTX;
      }

    case ALTIVEC_BUILTIN_MASK_FOR_LOAD:
    case ALTIVEC_BUILTIN_MASK_FOR_STORE:
      {
	int icode2 = (BYTES_BIG_ENDIAN ? (int) CODE_FOR_altivec_lvsr_direct
		     : (int) CODE_FOR_altivec_lvsl_direct);
	machine_mode tmode = insn_data[icode2].operand[0].mode;
	machine_mode mode = insn_data[icode2].operand[1].mode;
	tree arg;
	rtx op, addr, pat;

	gcc_assert (TARGET_ALTIVEC);

	arg = CALL_EXPR_ARG (exp, 0);
	gcc_assert (POINTER_TYPE_P (TREE_TYPE (arg)));
	op = expand_expr (arg, NULL_RTX, Pmode, EXPAND_NORMAL);
	addr = memory_address (mode, op);
	if (fcode == ALTIVEC_BUILTIN_MASK_FOR_STORE)
	  op = addr;
	else
	  {
	    /* For the load case need to negate the address.  */
	    op = gen_reg_rtx (GET_MODE (addr));
	    emit_insn (gen_rtx_SET (op, gen_rtx_NEG (GET_MODE (addr), addr)));
	  }
	op = gen_rtx_MEM (mode, op);

	if (target == 0
	    || GET_MODE (target) != tmode
	    || ! (*insn_data[icode2].operand[0].predicate) (target, tmode))
	  target = gen_reg_rtx (tmode);

	pat = GEN_FCN (icode2) (target, op);
	if (!pat)
	  return 0;
	emit_insn (pat);

	return target;
      }

    case ALTIVEC_BUILTIN_VCFUX:
    case ALTIVEC_BUILTIN_VCFSX:
    case ALTIVEC_BUILTIN_VCTUXS:
    case ALTIVEC_BUILTIN_VCTSXS:
  /* FIXME: There's got to be a nicer way to handle this case than
     constructing a new CALL_EXPR.  */
      if (call_expr_nargs (exp) == 1)
	{
	  exp = build_call_nary (TREE_TYPE (exp), CALL_EXPR_FN (exp),
				 2, CALL_EXPR_ARG (exp, 0), integer_zero_node);
	}
      break;

      /* For the pack and unpack int128 routines, fix up the builtin so it
	 uses the correct IBM128 type.  */
    case MISC_BUILTIN_PACK_IF:
      if (TARGET_LONG_DOUBLE_128 && !TARGET_IEEEQUAD)
	{
	  icode = CODE_FOR_packtf;
	  fcode = MISC_BUILTIN_PACK_TF;
	  uns_fcode = (size_t)fcode;
	}
      break;

    case MISC_BUILTIN_UNPACK_IF:
      if (TARGET_LONG_DOUBLE_128 && !TARGET_IEEEQUAD)
	{
	  icode = CODE_FOR_unpacktf;
	  fcode = MISC_BUILTIN_UNPACK_TF;
	  uns_fcode = (size_t)fcode;
	}
      break;

    default:
      break;
    }

  if (TARGET_ALTIVEC)
    {
      ret = altivec_expand_builtin (exp, target, &success);

      if (success)
	return ret;
    }
  if (TARGET_HTM)
    {
      ret = htm_expand_builtin (exp, target, &success);

      if (success)
	return ret;
    }  

  unsigned attr = rs6000_builtin_info[uns_fcode].attr & RS6000_BTC_TYPE_MASK;
  /* RS6000_BTC_SPECIAL represents no-operand operators.  */
  gcc_assert (attr == RS6000_BTC_UNARY
	      || attr == RS6000_BTC_BINARY
	      || attr == RS6000_BTC_TERNARY
	      || attr == RS6000_BTC_SPECIAL);
  
  /* Handle simple unary operations.  */
  d = bdesc_1arg;
  for (i = 0; i < ARRAY_SIZE (bdesc_1arg); i++, d++)
    if (d->code == fcode)
      return rs6000_expand_unop_builtin (icode, exp, target);

  /* Handle simple binary operations.  */
  d = bdesc_2arg;
  for (i = 0; i < ARRAY_SIZE (bdesc_2arg); i++, d++)
    if (d->code == fcode)
      return rs6000_expand_binop_builtin (icode, exp, target);

  /* Handle simple ternary operations.  */
  d = bdesc_3arg;
  for (i = 0; i < ARRAY_SIZE  (bdesc_3arg); i++, d++)
    if (d->code == fcode)
      return rs6000_expand_ternop_builtin (icode, exp, target);

  /* Handle simple no-argument operations. */
  d = bdesc_0arg;
  for (i = 0; i < ARRAY_SIZE (bdesc_0arg); i++, d++)
    if (d->code == fcode)
      return rs6000_expand_zeroop_builtin (icode, target);

  gcc_unreachable ();
}

/* Create a builtin vector type with a name.  Taking care not to give
   the canonical type a name.  */

static tree
rs6000_vector_type (const char *name, tree elt_type, unsigned num_elts)
{
  tree result = build_vector_type (elt_type, num_elts);

  /* Copy so we don't give the canonical type a name.  */
  result = build_variant_type_copy (result);

  add_builtin_type (name, result);

  return result;
}

static void
rs6000_init_builtins (void)
{
  tree tdecl;
  tree ftype;
  machine_mode mode;

  if (TARGET_DEBUG_BUILTIN)
    fprintf (stderr, "rs6000_init_builtins%s%s\n",
	     (TARGET_ALTIVEC)	   ? ", altivec" : "",
	     (TARGET_VSX)	   ? ", vsx"	 : "");

  V2DI_type_node = rs6000_vector_type (TARGET_POWERPC64 ? "__vector long"
				       : "__vector long long",
				       intDI_type_node, 2);
  V2DF_type_node = rs6000_vector_type ("__vector double", double_type_node, 2);
  V4SI_type_node = rs6000_vector_type ("__vector signed int",
				       intSI_type_node, 4);
  V4SF_type_node = rs6000_vector_type ("__vector float", float_type_node, 4);
  V8HI_type_node = rs6000_vector_type ("__vector signed short",
				       intHI_type_node, 8);
  V16QI_type_node = rs6000_vector_type ("__vector signed char",
					intQI_type_node, 16);

  unsigned_V16QI_type_node = rs6000_vector_type ("__vector unsigned char",
					unsigned_intQI_type_node, 16);
  unsigned_V8HI_type_node = rs6000_vector_type ("__vector unsigned short",
				       unsigned_intHI_type_node, 8);
  unsigned_V4SI_type_node = rs6000_vector_type ("__vector unsigned int",
				       unsigned_intSI_type_node, 4);
  unsigned_V2DI_type_node = rs6000_vector_type (TARGET_POWERPC64
				       ? "__vector unsigned long"
				       : "__vector unsigned long long",
				       unsigned_intDI_type_node, 2);

  opaque_V4SI_type_node = build_opaque_vector_type (intSI_type_node, 4);

  const_str_type_node
    = build_pointer_type (build_qualified_type (char_type_node,
						TYPE_QUAL_CONST));

  /* We use V1TI mode as a special container to hold __int128_t items that
     must live in VSX registers.  */
  if (intTI_type_node)
    {
      V1TI_type_node = rs6000_vector_type ("__vector __int128",
					   intTI_type_node, 1);
      unsigned_V1TI_type_node
	= rs6000_vector_type ("__vector unsigned __int128",
			      unsigned_intTI_type_node, 1);
    }

  /* The 'vector bool ...' types must be kept distinct from 'vector unsigned ...'
     types, especially in C++ land.  Similarly, 'vector pixel' is distinct from
     'vector unsigned short'.  */

  bool_char_type_node = build_distinct_type_copy (unsigned_intQI_type_node);
  bool_short_type_node = build_distinct_type_copy (unsigned_intHI_type_node);
  bool_int_type_node = build_distinct_type_copy (unsigned_intSI_type_node);
  bool_long_long_type_node = build_distinct_type_copy (unsigned_intDI_type_node);
  pixel_type_node = build_distinct_type_copy (unsigned_intHI_type_node);

  long_integer_type_internal_node = long_integer_type_node;
  long_unsigned_type_internal_node = long_unsigned_type_node;
  long_long_integer_type_internal_node = long_long_integer_type_node;
  long_long_unsigned_type_internal_node = long_long_unsigned_type_node;
  intQI_type_internal_node = intQI_type_node;
  uintQI_type_internal_node = unsigned_intQI_type_node;
  intHI_type_internal_node = intHI_type_node;
  uintHI_type_internal_node = unsigned_intHI_type_node;
  intSI_type_internal_node = intSI_type_node;
  uintSI_type_internal_node = unsigned_intSI_type_node;
  intDI_type_internal_node = intDI_type_node;
  uintDI_type_internal_node = unsigned_intDI_type_node;
  intTI_type_internal_node = intTI_type_node;
  uintTI_type_internal_node = unsigned_intTI_type_node;
  float_type_internal_node = float_type_node;
  double_type_internal_node = double_type_node;
  long_double_type_internal_node = long_double_type_node;
  dfloat64_type_internal_node = dfloat64_type_node;
  dfloat128_type_internal_node = dfloat128_type_node;
  void_type_internal_node = void_type_node;

  /* 128-bit floating point support.  KFmode is IEEE 128-bit floating point.
     IFmode is the IBM extended 128-bit format that is a pair of doubles.
     TFmode will be either IEEE 128-bit floating point or the IBM double-double
     format that uses a pair of doubles, depending on the switches and
     defaults.

     If we don't support for either 128-bit IBM double double or IEEE 128-bit
     floating point, we need make sure the type is non-zero or else self-test
     fails during bootstrap.

     Always create __ibm128 as a separate type, even if the current long double
     format is IBM extended double.

     For IEEE 128-bit floating point, always create the type __ieee128.  If the
     user used -mfloat128, rs6000-c.c will create a define from __float128 to
     __ieee128.  */
  if (TARGET_FLOAT128_TYPE)
    {
      if (!TARGET_IEEEQUAD && TARGET_LONG_DOUBLE_128)
	ibm128_float_type_node = long_double_type_node;
      else
	{
	  ibm128_float_type_node = make_node (REAL_TYPE);
	  TYPE_PRECISION (ibm128_float_type_node) = 128;
	  SET_TYPE_MODE (ibm128_float_type_node, IFmode);
	  layout_type (ibm128_float_type_node);
	}

      lang_hooks.types.register_builtin_type (ibm128_float_type_node,
					      "__ibm128");

      if (TARGET_IEEEQUAD && TARGET_LONG_DOUBLE_128)
	ieee128_float_type_node = long_double_type_node;
      else
	ieee128_float_type_node = float128_type_node;

      lang_hooks.types.register_builtin_type (ieee128_float_type_node,
					      "__ieee128");
    }

  else
    ieee128_float_type_node = ibm128_float_type_node = long_double_type_node;

  /* Initialize the modes for builtin_function_type, mapping a machine mode to
     tree type node.  */
  builtin_mode_to_type[QImode][0] = integer_type_node;
  builtin_mode_to_type[HImode][0] = integer_type_node;
  builtin_mode_to_type[SImode][0] = intSI_type_node;
  builtin_mode_to_type[SImode][1] = unsigned_intSI_type_node;
  builtin_mode_to_type[DImode][0] = intDI_type_node;
  builtin_mode_to_type[DImode][1] = unsigned_intDI_type_node;
  builtin_mode_to_type[TImode][0] = intTI_type_node;
  builtin_mode_to_type[TImode][1] = unsigned_intTI_type_node;
  builtin_mode_to_type[SFmode][0] = float_type_node;
  builtin_mode_to_type[DFmode][0] = double_type_node;
  builtin_mode_to_type[IFmode][0] = ibm128_float_type_node;
  builtin_mode_to_type[KFmode][0] = ieee128_float_type_node;
  builtin_mode_to_type[TFmode][0] = long_double_type_node;
  builtin_mode_to_type[DDmode][0] = dfloat64_type_node;
  builtin_mode_to_type[TDmode][0] = dfloat128_type_node;
  builtin_mode_to_type[V1TImode][0] = V1TI_type_node;
  builtin_mode_to_type[V1TImode][1] = unsigned_V1TI_type_node;
  builtin_mode_to_type[V2DImode][0] = V2DI_type_node;
  builtin_mode_to_type[V2DImode][1] = unsigned_V2DI_type_node;
  builtin_mode_to_type[V2DFmode][0] = V2DF_type_node;
  builtin_mode_to_type[V4SImode][0] = V4SI_type_node;
  builtin_mode_to_type[V4SImode][1] = unsigned_V4SI_type_node;
  builtin_mode_to_type[V4SFmode][0] = V4SF_type_node;
  builtin_mode_to_type[V8HImode][0] = V8HI_type_node;
  builtin_mode_to_type[V8HImode][1] = unsigned_V8HI_type_node;
  builtin_mode_to_type[V16QImode][0] = V16QI_type_node;
  builtin_mode_to_type[V16QImode][1] = unsigned_V16QI_type_node;

  tdecl = add_builtin_type ("__bool char", bool_char_type_node);
  TYPE_NAME (bool_char_type_node) = tdecl;

  tdecl = add_builtin_type ("__bool short", bool_short_type_node);
  TYPE_NAME (bool_short_type_node) = tdecl;

  tdecl = add_builtin_type ("__bool int", bool_int_type_node);
  TYPE_NAME (bool_int_type_node) = tdecl;

  tdecl = add_builtin_type ("__pixel", pixel_type_node);
  TYPE_NAME (pixel_type_node) = tdecl;

  bool_V16QI_type_node = rs6000_vector_type ("__vector __bool char",
					     bool_char_type_node, 16);
  bool_V8HI_type_node = rs6000_vector_type ("__vector __bool short",
					    bool_short_type_node, 8);
  bool_V4SI_type_node = rs6000_vector_type ("__vector __bool int",
					    bool_int_type_node, 4);
  bool_V2DI_type_node = rs6000_vector_type (TARGET_POWERPC64
					    ? "__vector __bool long"
					    : "__vector __bool long long",
					    bool_long_long_type_node, 2);
  pixel_V8HI_type_node = rs6000_vector_type ("__vector __pixel",
					     pixel_type_node, 8);

  /* Create Altivec and VSX builtins on machines with at least the
     general purpose extensions (970 and newer) to allow the use of
     the target attribute.  */
  if (TARGET_EXTRA_BUILTINS)
    altivec_init_builtins ();
  if (TARGET_HTM)
    htm_init_builtins ();

  if (TARGET_EXTRA_BUILTINS)
    rs6000_common_init_builtins ();

  ftype = builtin_function_type (DFmode, DFmode, DFmode, VOIDmode,
				 RS6000_BUILTIN_RECIP, "__builtin_recipdiv");
  def_builtin ("__builtin_recipdiv", ftype, RS6000_BUILTIN_RECIP);

  ftype = builtin_function_type (SFmode, SFmode, SFmode, VOIDmode,
				 RS6000_BUILTIN_RECIPF, "__builtin_recipdivf");
  def_builtin ("__builtin_recipdivf", ftype, RS6000_BUILTIN_RECIPF);

  ftype = builtin_function_type (DFmode, DFmode, VOIDmode, VOIDmode,
				 RS6000_BUILTIN_RSQRT, "__builtin_rsqrt");
  def_builtin ("__builtin_rsqrt", ftype, RS6000_BUILTIN_RSQRT);

  ftype = builtin_function_type (SFmode, SFmode, VOIDmode, VOIDmode,
				 RS6000_BUILTIN_RSQRTF, "__builtin_rsqrtf");
  def_builtin ("__builtin_rsqrtf", ftype, RS6000_BUILTIN_RSQRTF);

  mode = (TARGET_64BIT) ? DImode : SImode;
  ftype = builtin_function_type (mode, mode, mode, VOIDmode,
				 POWER7_BUILTIN_BPERMD, "__builtin_bpermd");
  def_builtin ("__builtin_bpermd", ftype, POWER7_BUILTIN_BPERMD);

  ftype = build_function_type_list (unsigned_intDI_type_node,
				    NULL_TREE);
  def_builtin ("__builtin_ppc_get_timebase", ftype, RS6000_BUILTIN_GET_TB);

  if (TARGET_64BIT)
    ftype = build_function_type_list (unsigned_intDI_type_node,
				      NULL_TREE);
  else
    ftype = build_function_type_list (unsigned_intSI_type_node,
				      NULL_TREE);
  def_builtin ("__builtin_ppc_mftb", ftype, RS6000_BUILTIN_MFTB);

  ftype = build_function_type_list (double_type_node, NULL_TREE);
  def_builtin ("__builtin_mffs", ftype, RS6000_BUILTIN_MFFS);

  ftype = build_function_type_list (double_type_node, NULL_TREE);
  def_builtin ("__builtin_mffsl", ftype, RS6000_BUILTIN_MFFSL);

  ftype = build_function_type_list (void_type_node,
				    intSI_type_node,
				    NULL_TREE);
  def_builtin ("__builtin_mtfsb0", ftype, RS6000_BUILTIN_MTFSB0);

  ftype = build_function_type_list (void_type_node,
				    intSI_type_node,
				    NULL_TREE);
  def_builtin ("__builtin_mtfsb1", ftype, RS6000_BUILTIN_MTFSB1);

  ftype = build_function_type_list (void_type_node,
				    intDI_type_node,
				    NULL_TREE);
  def_builtin ("__builtin_set_fpscr_rn", ftype, RS6000_BUILTIN_SET_FPSCR_RN);

  ftype = build_function_type_list (void_type_node,
				    intDI_type_node,
				    NULL_TREE);
  def_builtin ("__builtin_set_fpscr_drn", ftype, RS6000_BUILTIN_SET_FPSCR_DRN);

  ftype = build_function_type_list (void_type_node,
				    intSI_type_node, double_type_node,
				    NULL_TREE);
  def_builtin ("__builtin_mtfsf", ftype, RS6000_BUILTIN_MTFSF);

  ftype = build_function_type_list (void_type_node, NULL_TREE);
  def_builtin ("__builtin_cpu_init", ftype, RS6000_BUILTIN_CPU_INIT);
  def_builtin ("__builtin_ppc_speculation_barrier", ftype,
	       MISC_BUILTIN_SPEC_BARRIER);

  ftype = build_function_type_list (bool_int_type_node, const_ptr_type_node,
				    NULL_TREE);
  def_builtin ("__builtin_cpu_is", ftype, RS6000_BUILTIN_CPU_IS);
  def_builtin ("__builtin_cpu_supports", ftype, RS6000_BUILTIN_CPU_SUPPORTS);

  /* AIX libm provides clog as __clog.  */
  if (TARGET_XCOFF &&
      (tdecl = builtin_decl_explicit (BUILT_IN_CLOG)) != NULL_TREE)
    set_user_assembler_name (tdecl, "__clog");

#ifdef SUBTARGET_INIT_BUILTINS
  SUBTARGET_INIT_BUILTINS;
#endif
}

/* Returns the rs6000 builtin decl for CODE.  */

static tree
rs6000_builtin_decl (unsigned code, bool initialize_p ATTRIBUTE_UNUSED)
{
  HOST_WIDE_INT fnmask;

  if (code >= RS6000_BUILTIN_COUNT)
    return error_mark_node;

  fnmask = rs6000_builtin_info[code].mask;
  if ((fnmask & rs6000_builtin_mask) != fnmask)
    {
      rs6000_invalid_builtin ((enum rs6000_builtins)code);
      return error_mark_node;
    }

  return rs6000_builtin_decls[code];
}

static void
altivec_init_builtins (void)
{
  const struct builtin_description *d;
  size_t i;
  tree ftype;
  tree decl;
  HOST_WIDE_INT builtin_mask = rs6000_builtin_mask;

  tree pvoid_type_node = build_pointer_type (void_type_node);

  tree pcvoid_type_node
    = build_pointer_type (build_qualified_type (void_type_node,
						TYPE_QUAL_CONST));

  tree int_ftype_opaque
    = build_function_type_list (integer_type_node,
				opaque_V4SI_type_node, NULL_TREE);
  tree opaque_ftype_opaque
    = build_function_type_list (integer_type_node, NULL_TREE);
  tree opaque_ftype_opaque_int
    = build_function_type_list (opaque_V4SI_type_node,
				opaque_V4SI_type_node, integer_type_node, NULL_TREE);
  tree opaque_ftype_opaque_opaque_int
    = build_function_type_list (opaque_V4SI_type_node,
				opaque_V4SI_type_node, opaque_V4SI_type_node,
				integer_type_node, NULL_TREE);
  tree opaque_ftype_opaque_opaque_opaque
    = build_function_type_list (opaque_V4SI_type_node,
				opaque_V4SI_type_node, opaque_V4SI_type_node,
				opaque_V4SI_type_node, NULL_TREE);
  tree opaque_ftype_opaque_opaque
    = build_function_type_list (opaque_V4SI_type_node,
				opaque_V4SI_type_node, opaque_V4SI_type_node,
				NULL_TREE);
  tree int_ftype_int_opaque_opaque
    = build_function_type_list (integer_type_node,
                                integer_type_node, opaque_V4SI_type_node,
                                opaque_V4SI_type_node, NULL_TREE);
  tree int_ftype_int_v4si_v4si
    = build_function_type_list (integer_type_node,
				integer_type_node, V4SI_type_node,
				V4SI_type_node, NULL_TREE);
  tree int_ftype_int_v2di_v2di
    = build_function_type_list (integer_type_node,
				integer_type_node, V2DI_type_node,
				V2DI_type_node, NULL_TREE);
  tree void_ftype_v4si
    = build_function_type_list (void_type_node, V4SI_type_node, NULL_TREE);
  tree v8hi_ftype_void
    = build_function_type_list (V8HI_type_node, NULL_TREE);
  tree void_ftype_void
    = build_function_type_list (void_type_node, NULL_TREE);
  tree void_ftype_int
    = build_function_type_list (void_type_node, integer_type_node, NULL_TREE);

  tree opaque_ftype_long_pcvoid
    = build_function_type_list (opaque_V4SI_type_node,
				long_integer_type_node, pcvoid_type_node,
				NULL_TREE);
  tree v16qi_ftype_long_pcvoid
    = build_function_type_list (V16QI_type_node,
				long_integer_type_node, pcvoid_type_node,
				NULL_TREE);
  tree v8hi_ftype_long_pcvoid
    = build_function_type_list (V8HI_type_node,
				long_integer_type_node, pcvoid_type_node,
				NULL_TREE);
  tree v4si_ftype_long_pcvoid
    = build_function_type_list (V4SI_type_node,
				long_integer_type_node, pcvoid_type_node,
				NULL_TREE);
  tree v4sf_ftype_long_pcvoid
    = build_function_type_list (V4SF_type_node,
				long_integer_type_node, pcvoid_type_node,
				NULL_TREE);
  tree v2df_ftype_long_pcvoid
    = build_function_type_list (V2DF_type_node,
				long_integer_type_node, pcvoid_type_node,
				NULL_TREE);
  tree v2di_ftype_long_pcvoid
    = build_function_type_list (V2DI_type_node,
				long_integer_type_node, pcvoid_type_node,
				NULL_TREE);
  tree v1ti_ftype_long_pcvoid
    = build_function_type_list (V1TI_type_node,
				long_integer_type_node, pcvoid_type_node,
				NULL_TREE);

  tree void_ftype_opaque_long_pvoid
    = build_function_type_list (void_type_node,
				opaque_V4SI_type_node, long_integer_type_node,
				pvoid_type_node, NULL_TREE);
  tree void_ftype_v4si_long_pvoid
    = build_function_type_list (void_type_node,
				V4SI_type_node, long_integer_type_node,
				pvoid_type_node, NULL_TREE);
  tree void_ftype_v16qi_long_pvoid
    = build_function_type_list (void_type_node,
				V16QI_type_node, long_integer_type_node,
				pvoid_type_node, NULL_TREE);

  tree void_ftype_v16qi_pvoid_long
    = build_function_type_list (void_type_node,
				V16QI_type_node, pvoid_type_node,
				long_integer_type_node, NULL_TREE);

  tree void_ftype_v8hi_long_pvoid
    = build_function_type_list (void_type_node,
				V8HI_type_node, long_integer_type_node,
				pvoid_type_node, NULL_TREE);
  tree void_ftype_v4sf_long_pvoid
    = build_function_type_list (void_type_node,
				V4SF_type_node, long_integer_type_node,
				pvoid_type_node, NULL_TREE);
  tree void_ftype_v2df_long_pvoid
    = build_function_type_list (void_type_node,
				V2DF_type_node, long_integer_type_node,
				pvoid_type_node, NULL_TREE);
  tree void_ftype_v1ti_long_pvoid
    = build_function_type_list (void_type_node,
				V1TI_type_node, long_integer_type_node,
				pvoid_type_node, NULL_TREE);
  tree void_ftype_v2di_long_pvoid
    = build_function_type_list (void_type_node,
				V2DI_type_node, long_integer_type_node,
				pvoid_type_node, NULL_TREE);
  tree int_ftype_int_v8hi_v8hi
    = build_function_type_list (integer_type_node,
				integer_type_node, V8HI_type_node,
				V8HI_type_node, NULL_TREE);
  tree int_ftype_int_v16qi_v16qi
    = build_function_type_list (integer_type_node,
				integer_type_node, V16QI_type_node,
				V16QI_type_node, NULL_TREE);
  tree int_ftype_int_v4sf_v4sf
    = build_function_type_list (integer_type_node,
				integer_type_node, V4SF_type_node,
				V4SF_type_node, NULL_TREE);
  tree int_ftype_int_v2df_v2df
    = build_function_type_list (integer_type_node,
				integer_type_node, V2DF_type_node,
				V2DF_type_node, NULL_TREE);
  tree v2di_ftype_v2di
    = build_function_type_list (V2DI_type_node, V2DI_type_node, NULL_TREE);
  tree v4si_ftype_v4si
    = build_function_type_list (V4SI_type_node, V4SI_type_node, NULL_TREE);
  tree v8hi_ftype_v8hi
    = build_function_type_list (V8HI_type_node, V8HI_type_node, NULL_TREE);
  tree v16qi_ftype_v16qi
    = build_function_type_list (V16QI_type_node, V16QI_type_node, NULL_TREE);
  tree v4sf_ftype_v4sf
    = build_function_type_list (V4SF_type_node, V4SF_type_node, NULL_TREE);
  tree v2df_ftype_v2df
    = build_function_type_list (V2DF_type_node, V2DF_type_node, NULL_TREE);
  tree void_ftype_pcvoid_int_int
    = build_function_type_list (void_type_node,
				pcvoid_type_node, integer_type_node,
				integer_type_node, NULL_TREE);

  def_builtin ("__builtin_altivec_mtvscr", void_ftype_v4si, ALTIVEC_BUILTIN_MTVSCR);
  def_builtin ("__builtin_altivec_mfvscr", v8hi_ftype_void, ALTIVEC_BUILTIN_MFVSCR);
  def_builtin ("__builtin_altivec_dssall", void_ftype_void, ALTIVEC_BUILTIN_DSSALL);
  def_builtin ("__builtin_altivec_dss", void_ftype_int, ALTIVEC_BUILTIN_DSS);
  def_builtin ("__builtin_altivec_lvsl", v16qi_ftype_long_pcvoid, ALTIVEC_BUILTIN_LVSL);
  def_builtin ("__builtin_altivec_lvsr", v16qi_ftype_long_pcvoid, ALTIVEC_BUILTIN_LVSR);
  def_builtin ("__builtin_altivec_lvebx", v16qi_ftype_long_pcvoid, ALTIVEC_BUILTIN_LVEBX);
  def_builtin ("__builtin_altivec_lvehx", v8hi_ftype_long_pcvoid, ALTIVEC_BUILTIN_LVEHX);
  def_builtin ("__builtin_altivec_lvewx", v4si_ftype_long_pcvoid, ALTIVEC_BUILTIN_LVEWX);
  def_builtin ("__builtin_altivec_lvxl", v4si_ftype_long_pcvoid, ALTIVEC_BUILTIN_LVXL);
  def_builtin ("__builtin_altivec_lvxl_v2df", v2df_ftype_long_pcvoid,
	       ALTIVEC_BUILTIN_LVXL_V2DF);
  def_builtin ("__builtin_altivec_lvxl_v2di", v2di_ftype_long_pcvoid,
	       ALTIVEC_BUILTIN_LVXL_V2DI);
  def_builtin ("__builtin_altivec_lvxl_v4sf", v4sf_ftype_long_pcvoid,
	       ALTIVEC_BUILTIN_LVXL_V4SF);
  def_builtin ("__builtin_altivec_lvxl_v4si", v4si_ftype_long_pcvoid,
	       ALTIVEC_BUILTIN_LVXL_V4SI);
  def_builtin ("__builtin_altivec_lvxl_v8hi", v8hi_ftype_long_pcvoid,
	       ALTIVEC_BUILTIN_LVXL_V8HI);
  def_builtin ("__builtin_altivec_lvxl_v16qi", v16qi_ftype_long_pcvoid,
	       ALTIVEC_BUILTIN_LVXL_V16QI);
  def_builtin ("__builtin_altivec_lvx", v4si_ftype_long_pcvoid, ALTIVEC_BUILTIN_LVX);
  def_builtin ("__builtin_altivec_lvx_v1ti", v1ti_ftype_long_pcvoid,
	       ALTIVEC_BUILTIN_LVX_V1TI);
  def_builtin ("__builtin_altivec_lvx_v2df", v2df_ftype_long_pcvoid,
	       ALTIVEC_BUILTIN_LVX_V2DF);
  def_builtin ("__builtin_altivec_lvx_v2di", v2di_ftype_long_pcvoid,
	       ALTIVEC_BUILTIN_LVX_V2DI);
  def_builtin ("__builtin_altivec_lvx_v4sf", v4sf_ftype_long_pcvoid,
	       ALTIVEC_BUILTIN_LVX_V4SF);
  def_builtin ("__builtin_altivec_lvx_v4si", v4si_ftype_long_pcvoid,
	       ALTIVEC_BUILTIN_LVX_V4SI);
  def_builtin ("__builtin_altivec_lvx_v8hi", v8hi_ftype_long_pcvoid,
	       ALTIVEC_BUILTIN_LVX_V8HI);
  def_builtin ("__builtin_altivec_lvx_v16qi", v16qi_ftype_long_pcvoid,
	       ALTIVEC_BUILTIN_LVX_V16QI);
  def_builtin ("__builtin_altivec_stvx", void_ftype_v4si_long_pvoid, ALTIVEC_BUILTIN_STVX);
  def_builtin ("__builtin_altivec_stvx_v2df", void_ftype_v2df_long_pvoid,
	       ALTIVEC_BUILTIN_STVX_V2DF);
  def_builtin ("__builtin_altivec_stvx_v2di", void_ftype_v2di_long_pvoid,
	       ALTIVEC_BUILTIN_STVX_V2DI);
  def_builtin ("__builtin_altivec_stvx_v4sf", void_ftype_v4sf_long_pvoid,
	       ALTIVEC_BUILTIN_STVX_V4SF);
  def_builtin ("__builtin_altivec_stvx_v4si", void_ftype_v4si_long_pvoid,
	       ALTIVEC_BUILTIN_STVX_V4SI);
  def_builtin ("__builtin_altivec_stvx_v8hi", void_ftype_v8hi_long_pvoid,
	       ALTIVEC_BUILTIN_STVX_V8HI);
  def_builtin ("__builtin_altivec_stvx_v16qi", void_ftype_v16qi_long_pvoid,
	       ALTIVEC_BUILTIN_STVX_V16QI);
  def_builtin ("__builtin_altivec_stvewx", void_ftype_v4si_long_pvoid, ALTIVEC_BUILTIN_STVEWX);
  def_builtin ("__builtin_altivec_stvxl", void_ftype_v4si_long_pvoid, ALTIVEC_BUILTIN_STVXL);
  def_builtin ("__builtin_altivec_stvxl_v2df", void_ftype_v2df_long_pvoid,
	       ALTIVEC_BUILTIN_STVXL_V2DF);
  def_builtin ("__builtin_altivec_stvxl_v2di", void_ftype_v2di_long_pvoid,
	       ALTIVEC_BUILTIN_STVXL_V2DI);
  def_builtin ("__builtin_altivec_stvxl_v4sf", void_ftype_v4sf_long_pvoid,
	       ALTIVEC_BUILTIN_STVXL_V4SF);
  def_builtin ("__builtin_altivec_stvxl_v4si", void_ftype_v4si_long_pvoid,
	       ALTIVEC_BUILTIN_STVXL_V4SI);
  def_builtin ("__builtin_altivec_stvxl_v8hi", void_ftype_v8hi_long_pvoid,
	       ALTIVEC_BUILTIN_STVXL_V8HI);
  def_builtin ("__builtin_altivec_stvxl_v16qi", void_ftype_v16qi_long_pvoid,
	       ALTIVEC_BUILTIN_STVXL_V16QI);
  def_builtin ("__builtin_altivec_stvebx", void_ftype_v16qi_long_pvoid, ALTIVEC_BUILTIN_STVEBX);
  def_builtin ("__builtin_altivec_stvehx", void_ftype_v8hi_long_pvoid, ALTIVEC_BUILTIN_STVEHX);
  def_builtin ("__builtin_vec_ld", opaque_ftype_long_pcvoid, ALTIVEC_BUILTIN_VEC_LD);
  def_builtin ("__builtin_vec_lde", opaque_ftype_long_pcvoid, ALTIVEC_BUILTIN_VEC_LDE);
  def_builtin ("__builtin_vec_ldl", opaque_ftype_long_pcvoid, ALTIVEC_BUILTIN_VEC_LDL);
  def_builtin ("__builtin_vec_lvsl", v16qi_ftype_long_pcvoid, ALTIVEC_BUILTIN_VEC_LVSL);
  def_builtin ("__builtin_vec_lvsr", v16qi_ftype_long_pcvoid, ALTIVEC_BUILTIN_VEC_LVSR);
  def_builtin ("__builtin_vec_lvebx", v16qi_ftype_long_pcvoid, ALTIVEC_BUILTIN_VEC_LVEBX);
  def_builtin ("__builtin_vec_lvehx", v8hi_ftype_long_pcvoid, ALTIVEC_BUILTIN_VEC_LVEHX);
  def_builtin ("__builtin_vec_lvewx", v4si_ftype_long_pcvoid, ALTIVEC_BUILTIN_VEC_LVEWX);
  def_builtin ("__builtin_vec_st", void_ftype_opaque_long_pvoid, ALTIVEC_BUILTIN_VEC_ST);
  def_builtin ("__builtin_vec_ste", void_ftype_opaque_long_pvoid, ALTIVEC_BUILTIN_VEC_STE);
  def_builtin ("__builtin_vec_stl", void_ftype_opaque_long_pvoid, ALTIVEC_BUILTIN_VEC_STL);
  def_builtin ("__builtin_vec_stvewx", void_ftype_opaque_long_pvoid, ALTIVEC_BUILTIN_VEC_STVEWX);
  def_builtin ("__builtin_vec_stvebx", void_ftype_opaque_long_pvoid, ALTIVEC_BUILTIN_VEC_STVEBX);
  def_builtin ("__builtin_vec_stvehx", void_ftype_opaque_long_pvoid, ALTIVEC_BUILTIN_VEC_STVEHX);

  def_builtin ("__builtin_vsx_lxvd2x_v2df", v2df_ftype_long_pcvoid,
	       VSX_BUILTIN_LXVD2X_V2DF);
  def_builtin ("__builtin_vsx_lxvd2x_v2di", v2di_ftype_long_pcvoid,
	       VSX_BUILTIN_LXVD2X_V2DI);
  def_builtin ("__builtin_vsx_lxvw4x_v4sf", v4sf_ftype_long_pcvoid,
	       VSX_BUILTIN_LXVW4X_V4SF);
  def_builtin ("__builtin_vsx_lxvw4x_v4si", v4si_ftype_long_pcvoid,
	       VSX_BUILTIN_LXVW4X_V4SI);
  def_builtin ("__builtin_vsx_lxvw4x_v8hi", v8hi_ftype_long_pcvoid,
	       VSX_BUILTIN_LXVW4X_V8HI);
  def_builtin ("__builtin_vsx_lxvw4x_v16qi", v16qi_ftype_long_pcvoid,
	       VSX_BUILTIN_LXVW4X_V16QI);
  def_builtin ("__builtin_vsx_stxvd2x_v2df", void_ftype_v2df_long_pvoid,
	       VSX_BUILTIN_STXVD2X_V2DF);
  def_builtin ("__builtin_vsx_stxvd2x_v2di", void_ftype_v2di_long_pvoid,
	       VSX_BUILTIN_STXVD2X_V2DI);
  def_builtin ("__builtin_vsx_stxvw4x_v4sf", void_ftype_v4sf_long_pvoid,
	       VSX_BUILTIN_STXVW4X_V4SF);
  def_builtin ("__builtin_vsx_stxvw4x_v4si", void_ftype_v4si_long_pvoid,
	       VSX_BUILTIN_STXVW4X_V4SI);
  def_builtin ("__builtin_vsx_stxvw4x_v8hi", void_ftype_v8hi_long_pvoid,
	       VSX_BUILTIN_STXVW4X_V8HI);
  def_builtin ("__builtin_vsx_stxvw4x_v16qi", void_ftype_v16qi_long_pvoid,
	       VSX_BUILTIN_STXVW4X_V16QI);

  def_builtin ("__builtin_vsx_ld_elemrev_v2df", v2df_ftype_long_pcvoid,
	       VSX_BUILTIN_LD_ELEMREV_V2DF);
  def_builtin ("__builtin_vsx_ld_elemrev_v2di", v2di_ftype_long_pcvoid,
	       VSX_BUILTIN_LD_ELEMREV_V2DI);
  def_builtin ("__builtin_vsx_ld_elemrev_v4sf", v4sf_ftype_long_pcvoid,
	       VSX_BUILTIN_LD_ELEMREV_V4SF);
  def_builtin ("__builtin_vsx_ld_elemrev_v4si", v4si_ftype_long_pcvoid,
	       VSX_BUILTIN_LD_ELEMREV_V4SI);
  def_builtin ("__builtin_vsx_ld_elemrev_v8hi", v8hi_ftype_long_pcvoid,
	       VSX_BUILTIN_LD_ELEMREV_V8HI);
  def_builtin ("__builtin_vsx_ld_elemrev_v16qi", v16qi_ftype_long_pcvoid,
	       VSX_BUILTIN_LD_ELEMREV_V16QI);
  def_builtin ("__builtin_vsx_st_elemrev_v2df", void_ftype_v2df_long_pvoid,
	       VSX_BUILTIN_ST_ELEMREV_V2DF);
  def_builtin ("__builtin_vsx_st_elemrev_v1ti", void_ftype_v1ti_long_pvoid,
	       VSX_BUILTIN_ST_ELEMREV_V1TI);
  def_builtin ("__builtin_vsx_st_elemrev_v2di", void_ftype_v2di_long_pvoid,
	       VSX_BUILTIN_ST_ELEMREV_V2DI);
  def_builtin ("__builtin_vsx_st_elemrev_v4sf", void_ftype_v4sf_long_pvoid,
	       VSX_BUILTIN_ST_ELEMREV_V4SF);
  def_builtin ("__builtin_vsx_st_elemrev_v4si", void_ftype_v4si_long_pvoid,
	       VSX_BUILTIN_ST_ELEMREV_V4SI);
  def_builtin ("__builtin_vsx_st_elemrev_v8hi", void_ftype_v8hi_long_pvoid,
	       VSX_BUILTIN_ST_ELEMREV_V8HI);
  def_builtin ("__builtin_vsx_st_elemrev_v16qi", void_ftype_v16qi_long_pvoid,
	       VSX_BUILTIN_ST_ELEMREV_V16QI);

  def_builtin ("__builtin_vec_vsx_ld", opaque_ftype_long_pcvoid,
	       VSX_BUILTIN_VEC_LD);
  def_builtin ("__builtin_vec_vsx_st", void_ftype_opaque_long_pvoid,
	       VSX_BUILTIN_VEC_ST);
  def_builtin ("__builtin_vec_xl", opaque_ftype_long_pcvoid,
	       VSX_BUILTIN_VEC_XL);
  def_builtin ("__builtin_vec_xl_be", opaque_ftype_long_pcvoid,
	       VSX_BUILTIN_VEC_XL_BE);
  def_builtin ("__builtin_vec_xst", void_ftype_opaque_long_pvoid,
	       VSX_BUILTIN_VEC_XST);
  def_builtin ("__builtin_vec_xst_be", void_ftype_opaque_long_pvoid,
	       VSX_BUILTIN_VEC_XST_BE);

  def_builtin ("__builtin_vec_step", int_ftype_opaque, ALTIVEC_BUILTIN_VEC_STEP);
  def_builtin ("__builtin_vec_splats", opaque_ftype_opaque, ALTIVEC_BUILTIN_VEC_SPLATS);
  def_builtin ("__builtin_vec_promote", opaque_ftype_opaque, ALTIVEC_BUILTIN_VEC_PROMOTE);

  def_builtin ("__builtin_vec_sld", opaque_ftype_opaque_opaque_int, ALTIVEC_BUILTIN_VEC_SLD);
  def_builtin ("__builtin_vec_splat", opaque_ftype_opaque_int, ALTIVEC_BUILTIN_VEC_SPLAT);
  def_builtin ("__builtin_vec_extract", opaque_ftype_opaque_int, ALTIVEC_BUILTIN_VEC_EXTRACT);
  def_builtin ("__builtin_vec_insert", opaque_ftype_opaque_opaque_int, ALTIVEC_BUILTIN_VEC_INSERT);
  def_builtin ("__builtin_vec_vspltw", opaque_ftype_opaque_int, ALTIVEC_BUILTIN_VEC_VSPLTW);
  def_builtin ("__builtin_vec_vsplth", opaque_ftype_opaque_int, ALTIVEC_BUILTIN_VEC_VSPLTH);
  def_builtin ("__builtin_vec_vspltb", opaque_ftype_opaque_int, ALTIVEC_BUILTIN_VEC_VSPLTB);
  def_builtin ("__builtin_vec_ctf", opaque_ftype_opaque_int, ALTIVEC_BUILTIN_VEC_CTF);
  def_builtin ("__builtin_vec_vcfsx", opaque_ftype_opaque_int, ALTIVEC_BUILTIN_VEC_VCFSX);
  def_builtin ("__builtin_vec_vcfux", opaque_ftype_opaque_int, ALTIVEC_BUILTIN_VEC_VCFUX);
  def_builtin ("__builtin_vec_cts", opaque_ftype_opaque_int, ALTIVEC_BUILTIN_VEC_CTS);
  def_builtin ("__builtin_vec_ctu", opaque_ftype_opaque_int, ALTIVEC_BUILTIN_VEC_CTU);

  def_builtin ("__builtin_vec_adde", opaque_ftype_opaque_opaque_opaque,
		ALTIVEC_BUILTIN_VEC_ADDE);
  def_builtin ("__builtin_vec_addec", opaque_ftype_opaque_opaque_opaque,
		ALTIVEC_BUILTIN_VEC_ADDEC);
  def_builtin ("__builtin_vec_cmpne", opaque_ftype_opaque_opaque,
		ALTIVEC_BUILTIN_VEC_CMPNE);
  def_builtin ("__builtin_vec_mul", opaque_ftype_opaque_opaque,
		ALTIVEC_BUILTIN_VEC_MUL);
  def_builtin ("__builtin_vec_sube", opaque_ftype_opaque_opaque_opaque,
		ALTIVEC_BUILTIN_VEC_SUBE);
  def_builtin ("__builtin_vec_subec", opaque_ftype_opaque_opaque_opaque,
		ALTIVEC_BUILTIN_VEC_SUBEC);

  /* Cell builtins.  */
  def_builtin ("__builtin_altivec_lvlx",  v16qi_ftype_long_pcvoid, ALTIVEC_BUILTIN_LVLX);
  def_builtin ("__builtin_altivec_lvlxl", v16qi_ftype_long_pcvoid, ALTIVEC_BUILTIN_LVLXL);
  def_builtin ("__builtin_altivec_lvrx",  v16qi_ftype_long_pcvoid, ALTIVEC_BUILTIN_LVRX);
  def_builtin ("__builtin_altivec_lvrxl", v16qi_ftype_long_pcvoid, ALTIVEC_BUILTIN_LVRXL);

  def_builtin ("__builtin_vec_lvlx",  v16qi_ftype_long_pcvoid, ALTIVEC_BUILTIN_VEC_LVLX);
  def_builtin ("__builtin_vec_lvlxl", v16qi_ftype_long_pcvoid, ALTIVEC_BUILTIN_VEC_LVLXL);
  def_builtin ("__builtin_vec_lvrx",  v16qi_ftype_long_pcvoid, ALTIVEC_BUILTIN_VEC_LVRX);
  def_builtin ("__builtin_vec_lvrxl", v16qi_ftype_long_pcvoid, ALTIVEC_BUILTIN_VEC_LVRXL);

  def_builtin ("__builtin_altivec_stvlx",  void_ftype_v16qi_long_pvoid, ALTIVEC_BUILTIN_STVLX);
  def_builtin ("__builtin_altivec_stvlxl", void_ftype_v16qi_long_pvoid, ALTIVEC_BUILTIN_STVLXL);
  def_builtin ("__builtin_altivec_stvrx",  void_ftype_v16qi_long_pvoid, ALTIVEC_BUILTIN_STVRX);
  def_builtin ("__builtin_altivec_stvrxl", void_ftype_v16qi_long_pvoid, ALTIVEC_BUILTIN_STVRXL);

  def_builtin ("__builtin_vec_stvlx",  void_ftype_v16qi_long_pvoid, ALTIVEC_BUILTIN_VEC_STVLX);
  def_builtin ("__builtin_vec_stvlxl", void_ftype_v16qi_long_pvoid, ALTIVEC_BUILTIN_VEC_STVLXL);
  def_builtin ("__builtin_vec_stvrx",  void_ftype_v16qi_long_pvoid, ALTIVEC_BUILTIN_VEC_STVRX);
  def_builtin ("__builtin_vec_stvrxl", void_ftype_v16qi_long_pvoid, ALTIVEC_BUILTIN_VEC_STVRXL);

  if (TARGET_P9_VECTOR)
    {
      def_builtin ("__builtin_altivec_stxvl", void_ftype_v16qi_pvoid_long,
		   P9V_BUILTIN_STXVL);
      def_builtin ("__builtin_xst_len_r", void_ftype_v16qi_pvoid_long,
		   P9V_BUILTIN_XST_LEN_R);
    }

  /* Add the DST variants.  */
  d = bdesc_dst;
  for (i = 0; i < ARRAY_SIZE (bdesc_dst); i++, d++)
    {
      HOST_WIDE_INT mask = d->mask;

      /* It is expected that these dst built-in functions may have
	 d->icode equal to CODE_FOR_nothing.  */
      if ((mask & builtin_mask) != mask)
	{
	  if (TARGET_DEBUG_BUILTIN)
	    fprintf (stderr, "altivec_init_builtins, skip dst %s\n",
		     d->name);
	  continue;
	}
      def_builtin (d->name, void_ftype_pcvoid_int_int, d->code);
    }

  /* Initialize the predicates.  */
  d = bdesc_altivec_preds;
  for (i = 0; i < ARRAY_SIZE (bdesc_altivec_preds); i++, d++)
    {
      machine_mode mode1;
      tree type;
      HOST_WIDE_INT mask = d->mask;

      if ((mask & builtin_mask) != mask)
	{
	  if (TARGET_DEBUG_BUILTIN)
	    fprintf (stderr, "altivec_init_builtins, skip predicate %s\n",
		     d->name);
	  continue;
	}

      if (rs6000_overloaded_builtin_p (d->code))
	mode1 = VOIDmode;
      else
	{
	  /* Cannot define builtin if the instruction is disabled.  */
	  gcc_assert (d->icode != CODE_FOR_nothing);
	  mode1 = insn_data[d->icode].operand[1].mode;
	}

      switch (mode1)
	{
	case E_VOIDmode:
	  type = int_ftype_int_opaque_opaque;
	  break;
	case E_V2DImode:
	  type = int_ftype_int_v2di_v2di;
	  break;
	case E_V4SImode:
	  type = int_ftype_int_v4si_v4si;
	  break;
	case E_V8HImode:
	  type = int_ftype_int_v8hi_v8hi;
	  break;
	case E_V16QImode:
	  type = int_ftype_int_v16qi_v16qi;
	  break;
	case E_V4SFmode:
	  type = int_ftype_int_v4sf_v4sf;
	  break;
	case E_V2DFmode:
	  type = int_ftype_int_v2df_v2df;
	  break;
	default:
	  gcc_unreachable ();
	}

      def_builtin (d->name, type, d->code);
    }

  /* Initialize the abs* operators.  */
  d = bdesc_abs;
  for (i = 0; i < ARRAY_SIZE (bdesc_abs); i++, d++)
    {
      machine_mode mode0;
      tree type;
      HOST_WIDE_INT mask = d->mask;

      if ((mask & builtin_mask) != mask)
	{
	  if (TARGET_DEBUG_BUILTIN)
	    fprintf (stderr, "altivec_init_builtins, skip abs %s\n",
		     d->name);
	  continue;
	}

      /* Cannot define builtin if the instruction is disabled.  */
      gcc_assert (d->icode != CODE_FOR_nothing);
      mode0 = insn_data[d->icode].operand[0].mode;

      switch (mode0)
	{
	case E_V2DImode:
	  type = v2di_ftype_v2di;
	  break;
	case E_V4SImode:
	  type = v4si_ftype_v4si;
	  break;
	case E_V8HImode:
	  type = v8hi_ftype_v8hi;
	  break;
	case E_V16QImode:
	  type = v16qi_ftype_v16qi;
	  break;
	case E_V4SFmode:
	  type = v4sf_ftype_v4sf;
	  break;
	case E_V2DFmode:
	  type = v2df_ftype_v2df;
	  break;
	default:
	  gcc_unreachable ();
	}

      def_builtin (d->name, type, d->code);
    }

  /* Initialize target builtin that implements
     targetm.vectorize.builtin_mask_for_load.  */

  decl = add_builtin_function ("__builtin_altivec_mask_for_load",
			       v16qi_ftype_long_pcvoid,
			       ALTIVEC_BUILTIN_MASK_FOR_LOAD,
			       BUILT_IN_MD, NULL, NULL_TREE);
  TREE_READONLY (decl) = 1;
  /* Record the decl. Will be used by rs6000_builtin_mask_for_load.  */
  altivec_builtin_mask_for_load = decl;

  /* Access to the vec_init patterns.  */
  ftype = build_function_type_list (V4SI_type_node, integer_type_node,
				    integer_type_node, integer_type_node,
				    integer_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_init_v4si", ftype, ALTIVEC_BUILTIN_VEC_INIT_V4SI);

  ftype = build_function_type_list (V8HI_type_node, short_integer_type_node,
				    short_integer_type_node,
				    short_integer_type_node,
				    short_integer_type_node,
				    short_integer_type_node,
				    short_integer_type_node,
				    short_integer_type_node,
				    short_integer_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_init_v8hi", ftype, ALTIVEC_BUILTIN_VEC_INIT_V8HI);

  ftype = build_function_type_list (V16QI_type_node, char_type_node,
				    char_type_node, char_type_node,
				    char_type_node, char_type_node,
				    char_type_node, char_type_node,
				    char_type_node, char_type_node,
				    char_type_node, char_type_node,
				    char_type_node, char_type_node,
				    char_type_node, char_type_node,
				    char_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_init_v16qi", ftype,
	       ALTIVEC_BUILTIN_VEC_INIT_V16QI);

  ftype = build_function_type_list (V4SF_type_node, float_type_node,
				    float_type_node, float_type_node,
				    float_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_init_v4sf", ftype, ALTIVEC_BUILTIN_VEC_INIT_V4SF);

  /* VSX builtins.  */
  ftype = build_function_type_list (V2DF_type_node, double_type_node,
				    double_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_init_v2df", ftype, VSX_BUILTIN_VEC_INIT_V2DF);

  ftype = build_function_type_list (V2DI_type_node, intDI_type_node,
				    intDI_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_init_v2di", ftype, VSX_BUILTIN_VEC_INIT_V2DI);

  /* Access to the vec_set patterns.  */
  ftype = build_function_type_list (V4SI_type_node, V4SI_type_node,
				    intSI_type_node,
				    integer_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_set_v4si", ftype, ALTIVEC_BUILTIN_VEC_SET_V4SI);

  ftype = build_function_type_list (V8HI_type_node, V8HI_type_node,
				    intHI_type_node,
				    integer_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_set_v8hi", ftype, ALTIVEC_BUILTIN_VEC_SET_V8HI);

  ftype = build_function_type_list (V16QI_type_node, V16QI_type_node,
				    intQI_type_node,
				    integer_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_set_v16qi", ftype, ALTIVEC_BUILTIN_VEC_SET_V16QI);

  ftype = build_function_type_list (V4SF_type_node, V4SF_type_node,
				    float_type_node,
				    integer_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_set_v4sf", ftype, ALTIVEC_BUILTIN_VEC_SET_V4SF);

  ftype = build_function_type_list (V2DF_type_node, V2DF_type_node,
				    double_type_node,
				    integer_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_set_v2df", ftype, VSX_BUILTIN_VEC_SET_V2DF);

  ftype = build_function_type_list (V2DI_type_node, V2DI_type_node,
				    intDI_type_node,
				    integer_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_set_v2di", ftype, VSX_BUILTIN_VEC_SET_V2DI);

  /* Access to the vec_extract patterns.  */
  ftype = build_function_type_list (intSI_type_node, V4SI_type_node,
				    integer_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_ext_v4si", ftype, ALTIVEC_BUILTIN_VEC_EXT_V4SI);

  ftype = build_function_type_list (intHI_type_node, V8HI_type_node,
				    integer_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_ext_v8hi", ftype, ALTIVEC_BUILTIN_VEC_EXT_V8HI);

  ftype = build_function_type_list (intQI_type_node, V16QI_type_node,
				    integer_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_ext_v16qi", ftype, ALTIVEC_BUILTIN_VEC_EXT_V16QI);

  ftype = build_function_type_list (float_type_node, V4SF_type_node,
				    integer_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_ext_v4sf", ftype, ALTIVEC_BUILTIN_VEC_EXT_V4SF);

  ftype = build_function_type_list (double_type_node, V2DF_type_node,
				    integer_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_ext_v2df", ftype, VSX_BUILTIN_VEC_EXT_V2DF);

  ftype = build_function_type_list (intDI_type_node, V2DI_type_node,
				    integer_type_node, NULL_TREE);
  def_builtin ("__builtin_vec_ext_v2di", ftype, VSX_BUILTIN_VEC_EXT_V2DI);


  if (V1TI_type_node)
    {
      tree v1ti_ftype_long_pcvoid
	= build_function_type_list (V1TI_type_node,
				    long_integer_type_node, pcvoid_type_node,
				    NULL_TREE);
      tree void_ftype_v1ti_long_pvoid
	= build_function_type_list (void_type_node,
				    V1TI_type_node, long_integer_type_node,
				    pvoid_type_node, NULL_TREE);
      def_builtin ("__builtin_vsx_ld_elemrev_v1ti", v1ti_ftype_long_pcvoid,
		   VSX_BUILTIN_LD_ELEMREV_V1TI);
      def_builtin ("__builtin_vsx_lxvd2x_v1ti", v1ti_ftype_long_pcvoid,
		   VSX_BUILTIN_LXVD2X_V1TI);
      def_builtin ("__builtin_vsx_stxvd2x_v1ti", void_ftype_v1ti_long_pvoid,
		   VSX_BUILTIN_STXVD2X_V1TI);
      ftype = build_function_type_list (V1TI_type_node, intTI_type_node,
					NULL_TREE, NULL_TREE);
      def_builtin ("__builtin_vec_init_v1ti", ftype, VSX_BUILTIN_VEC_INIT_V1TI);
      ftype = build_function_type_list (V1TI_type_node, V1TI_type_node,
					intTI_type_node,
					integer_type_node, NULL_TREE);
      def_builtin ("__builtin_vec_set_v1ti", ftype, VSX_BUILTIN_VEC_SET_V1TI);
      ftype = build_function_type_list (intTI_type_node, V1TI_type_node,
					integer_type_node, NULL_TREE);
      def_builtin ("__builtin_vec_ext_v1ti", ftype, VSX_BUILTIN_VEC_EXT_V1TI);
    }

}

static void
htm_init_builtins (void)
{
  HOST_WIDE_INT builtin_mask = rs6000_builtin_mask;
  const struct builtin_description *d;
  size_t i;

  d = bdesc_htm;
  for (i = 0; i < ARRAY_SIZE (bdesc_htm); i++, d++)
    {
      tree op[MAX_HTM_OPERANDS], type;
      HOST_WIDE_INT mask = d->mask;
      unsigned attr = rs6000_builtin_info[d->code].attr;
      bool void_func = (attr & RS6000_BTC_VOID);
      int attr_args = (attr & RS6000_BTC_TYPE_MASK);
      int nopnds = 0;
      tree gpr_type_node;
      tree rettype;
      tree argtype;

      /* It is expected that these htm built-in functions may have
	 d->icode equal to CODE_FOR_nothing.  */

      if (TARGET_32BIT && TARGET_POWERPC64)
	gpr_type_node = long_long_unsigned_type_node;
      else
	gpr_type_node = long_unsigned_type_node;

      if (attr & RS6000_BTC_SPR)
	{
	  rettype = gpr_type_node;
	  argtype = gpr_type_node;
	}
      else if (d->code == HTM_BUILTIN_TABORTDC
	       || d->code == HTM_BUILTIN_TABORTDCI)
	{
	  rettype = unsigned_type_node;
	  argtype = gpr_type_node;
	}
      else
	{
	  rettype = unsigned_type_node;
	  argtype = unsigned_type_node;
	}

      if ((mask & builtin_mask) != mask)
	{
	  if (TARGET_DEBUG_BUILTIN)
	    fprintf (stderr, "htm_builtin, skip binary %s\n", d->name);
	  continue;
	}

      if (d->name == 0)
	{
	  if (TARGET_DEBUG_BUILTIN)
	    fprintf (stderr, "htm_builtin, bdesc_htm[%ld] no name\n",
		     (long unsigned) i);
	  continue;
	}

      op[nopnds++] = (void_func) ? void_type_node : rettype;

      if (attr_args == RS6000_BTC_UNARY)
	op[nopnds++] = argtype;
      else if (attr_args == RS6000_BTC_BINARY)
	{
	  op[nopnds++] = argtype;
	  op[nopnds++] = argtype;
	}
      else if (attr_args == RS6000_BTC_TERNARY)
	{
	  op[nopnds++] = argtype;
	  op[nopnds++] = argtype;
	  op[nopnds++] = argtype;
	}

      switch (nopnds)
	{
	case 1:
	  type = build_function_type_list (op[0], NULL_TREE);
	  break;
	case 2:
	  type = build_function_type_list (op[0], op[1], NULL_TREE);
	  break;
	case 3:
	  type = build_function_type_list (op[0], op[1], op[2], NULL_TREE);
	  break;
	case 4:
	  type = build_function_type_list (op[0], op[1], op[2], op[3],
					   NULL_TREE);
	  break;
	default:
	  gcc_unreachable ();
	}

      def_builtin (d->name, type, d->code);
    }
}

/* Hash function for builtin functions with up to 3 arguments and a return
   type.  */
hashval_t
builtin_hasher::hash (builtin_hash_struct *bh)
{
  unsigned ret = 0;
  int i;

  for (i = 0; i < 4; i++)
    {
      ret = (ret * (unsigned)MAX_MACHINE_MODE) + ((unsigned)bh->mode[i]);
      ret = (ret * 2) + bh->uns_p[i];
    }

  return ret;
}

/* Compare builtin hash entries H1 and H2 for equivalence.  */
bool
builtin_hasher::equal (builtin_hash_struct *p1, builtin_hash_struct *p2)
{
  return ((p1->mode[0] == p2->mode[0])
	  && (p1->mode[1] == p2->mode[1])
	  && (p1->mode[2] == p2->mode[2])
	  && (p1->mode[3] == p2->mode[3])
	  && (p1->uns_p[0] == p2->uns_p[0])
	  && (p1->uns_p[1] == p2->uns_p[1])
	  && (p1->uns_p[2] == p2->uns_p[2])
	  && (p1->uns_p[3] == p2->uns_p[3]));
}

/* Map types for builtin functions with an explicit return type and up to 3
   arguments.  Functions with fewer than 3 arguments use VOIDmode as the type
   of the argument.  */
static tree
builtin_function_type (machine_mode mode_ret, machine_mode mode_arg0,
		       machine_mode mode_arg1, machine_mode mode_arg2,
		       enum rs6000_builtins builtin, const char *name)
{
  struct builtin_hash_struct h;
  struct builtin_hash_struct *h2;
  int num_args = 3;
  int i;
  tree ret_type = NULL_TREE;
  tree arg_type[3] = { NULL_TREE, NULL_TREE, NULL_TREE };

  /* Create builtin_hash_table.  */
  if (builtin_hash_table == NULL)
    builtin_hash_table = hash_table<builtin_hasher>::create_ggc (1500);

  h.type = NULL_TREE;
  h.mode[0] = mode_ret;
  h.mode[1] = mode_arg0;
  h.mode[2] = mode_arg1;
  h.mode[3] = mode_arg2;
  h.uns_p[0] = 0;
  h.uns_p[1] = 0;
  h.uns_p[2] = 0;
  h.uns_p[3] = 0;

  /* If the builtin is a type that produces unsigned results or takes unsigned
     arguments, and it is returned as a decl for the vectorizer (such as
     widening multiplies, permute), make sure the arguments and return value
     are type correct.  */
  switch (builtin)
    {
    /* unsigned 1 argument functions.  */
    case CRYPTO_BUILTIN_VSBOX:
    case CRYPTO_BUILTIN_VSBOX_BE:
    case P8V_BUILTIN_VGBBD:
    case MISC_BUILTIN_CDTBCD:
    case MISC_BUILTIN_CBCDTD:
      h.uns_p[0] = 1;
      h.uns_p[1] = 1;
      break;

    /* unsigned 2 argument functions.  */
    case ALTIVEC_BUILTIN_VMULEUB:
    case ALTIVEC_BUILTIN_VMULEUH:
    case P8V_BUILTIN_VMULEUW:
    case ALTIVEC_BUILTIN_VMULOUB:
    case ALTIVEC_BUILTIN_VMULOUH:
    case P8V_BUILTIN_VMULOUW:
    case CRYPTO_BUILTIN_VCIPHER:
    case CRYPTO_BUILTIN_VCIPHER_BE:
    case CRYPTO_BUILTIN_VCIPHERLAST:
    case CRYPTO_BUILTIN_VCIPHERLAST_BE:
    case CRYPTO_BUILTIN_VNCIPHER:
    case CRYPTO_BUILTIN_VNCIPHER_BE:
    case CRYPTO_BUILTIN_VNCIPHERLAST:
    case CRYPTO_BUILTIN_VNCIPHERLAST_BE:
    case CRYPTO_BUILTIN_VPMSUMB:
    case CRYPTO_BUILTIN_VPMSUMH:
    case CRYPTO_BUILTIN_VPMSUMW:
    case CRYPTO_BUILTIN_VPMSUMD:
    case CRYPTO_BUILTIN_VPMSUM:
    case MISC_BUILTIN_ADDG6S:
    case MISC_BUILTIN_DIVWEU:
    case MISC_BUILTIN_DIVDEU:
    case VSX_BUILTIN_UDIV_V2DI:
    case ALTIVEC_BUILTIN_VMAXUB:
    case ALTIVEC_BUILTIN_VMINUB:
    case ALTIVEC_BUILTIN_VMAXUH:
    case ALTIVEC_BUILTIN_VMINUH:
    case ALTIVEC_BUILTIN_VMAXUW:
    case ALTIVEC_BUILTIN_VMINUW:
    case P8V_BUILTIN_VMAXUD:
    case P8V_BUILTIN_VMINUD:
      h.uns_p[0] = 1;
      h.uns_p[1] = 1;
      h.uns_p[2] = 1;
      break;

    /* unsigned 3 argument functions.  */
    case ALTIVEC_BUILTIN_VPERM_16QI_UNS:
    case ALTIVEC_BUILTIN_VPERM_8HI_UNS:
    case ALTIVEC_BUILTIN_VPERM_4SI_UNS:
    case ALTIVEC_BUILTIN_VPERM_2DI_UNS:
    case ALTIVEC_BUILTIN_VSEL_16QI_UNS:
    case ALTIVEC_BUILTIN_VSEL_8HI_UNS:
    case ALTIVEC_BUILTIN_VSEL_4SI_UNS:
    case ALTIVEC_BUILTIN_VSEL_2DI_UNS:
    case VSX_BUILTIN_VPERM_16QI_UNS:
    case VSX_BUILTIN_VPERM_8HI_UNS:
    case VSX_BUILTIN_VPERM_4SI_UNS:
    case VSX_BUILTIN_VPERM_2DI_UNS:
    case VSX_BUILTIN_XXSEL_16QI_UNS:
    case VSX_BUILTIN_XXSEL_8HI_UNS:
    case VSX_BUILTIN_XXSEL_4SI_UNS:
    case VSX_BUILTIN_XXSEL_2DI_UNS:
    case CRYPTO_BUILTIN_VPERMXOR:
    case CRYPTO_BUILTIN_VPERMXOR_V2DI:
    case CRYPTO_BUILTIN_VPERMXOR_V4SI:
    case CRYPTO_BUILTIN_VPERMXOR_V8HI:
    case CRYPTO_BUILTIN_VPERMXOR_V16QI:
    case CRYPTO_BUILTIN_VSHASIGMAW:
    case CRYPTO_BUILTIN_VSHASIGMAD:
    case CRYPTO_BUILTIN_VSHASIGMA:
      h.uns_p[0] = 1;
      h.uns_p[1] = 1;
      h.uns_p[2] = 1;
      h.uns_p[3] = 1;
      break;

    /* signed permute functions with unsigned char mask.  */
    case ALTIVEC_BUILTIN_VPERM_16QI:
    case ALTIVEC_BUILTIN_VPERM_8HI:
    case ALTIVEC_BUILTIN_VPERM_4SI:
    case ALTIVEC_BUILTIN_VPERM_4SF:
    case ALTIVEC_BUILTIN_VPERM_2DI:
    case ALTIVEC_BUILTIN_VPERM_2DF:
    case VSX_BUILTIN_VPERM_16QI:
    case VSX_BUILTIN_VPERM_8HI:
    case VSX_BUILTIN_VPERM_4SI:
    case VSX_BUILTIN_VPERM_4SF:
    case VSX_BUILTIN_VPERM_2DI:
    case VSX_BUILTIN_VPERM_2DF:
      h.uns_p[3] = 1;
      break;

    /* unsigned args, signed return.  */
    case VSX_BUILTIN_XVCVUXDSP:
    case VSX_BUILTIN_XVCVUXDDP_UNS:
    case ALTIVEC_BUILTIN_UNSFLOAT_V4SI_V4SF:
      h.uns_p[1] = 1;
      break;

    /* signed args, unsigned return.  */
    case VSX_BUILTIN_XVCVDPUXDS_UNS:
    case ALTIVEC_BUILTIN_FIXUNS_V4SF_V4SI:
    case MISC_BUILTIN_UNPACK_TD:
    case MISC_BUILTIN_UNPACK_V1TI:
      h.uns_p[0] = 1;
      break;

    /* unsigned arguments, bool return (compares).  */
    case ALTIVEC_BUILTIN_VCMPEQUB:
    case ALTIVEC_BUILTIN_VCMPEQUH:
    case ALTIVEC_BUILTIN_VCMPEQUW:
    case P8V_BUILTIN_VCMPEQUD:
    case VSX_BUILTIN_CMPGE_U16QI:
    case VSX_BUILTIN_CMPGE_U8HI:
    case VSX_BUILTIN_CMPGE_U4SI:
    case VSX_BUILTIN_CMPGE_U2DI:
    case ALTIVEC_BUILTIN_VCMPGTUB:
    case ALTIVEC_BUILTIN_VCMPGTUH:
    case ALTIVEC_BUILTIN_VCMPGTUW:
    case P8V_BUILTIN_VCMPGTUD:
      h.uns_p[1] = 1;
      h.uns_p[2] = 1;
      break;

    /* unsigned arguments for 128-bit pack instructions.  */
    case MISC_BUILTIN_PACK_TD:
    case MISC_BUILTIN_PACK_V1TI:
      h.uns_p[1] = 1;
      h.uns_p[2] = 1;
      break;

    /* unsigned second arguments (vector shift right).  */
    case ALTIVEC_BUILTIN_VSRB:
    case ALTIVEC_BUILTIN_VSRH:
    case ALTIVEC_BUILTIN_VSRW:
    case P8V_BUILTIN_VSRD:
      h.uns_p[2] = 1;
      break;

    default:
      break;
    }

  /* Figure out how many args are present.  */
  while (num_args > 0 && h.mode[num_args] == VOIDmode)
    num_args--;

  ret_type = builtin_mode_to_type[h.mode[0]][h.uns_p[0]];
  if (!ret_type && h.uns_p[0])
    ret_type = builtin_mode_to_type[h.mode[0]][0];

  if (!ret_type)
    fatal_error (input_location,
		 "internal error: builtin function %qs had an unexpected "
		 "return type %qs", name, GET_MODE_NAME (h.mode[0]));

  for (i = 0; i < (int) ARRAY_SIZE (arg_type); i++)
    arg_type[i] = NULL_TREE;

  for (i = 0; i < num_args; i++)
    {
      int m = (int) h.mode[i+1];
      int uns_p = h.uns_p[i+1];

      arg_type[i] = builtin_mode_to_type[m][uns_p];
      if (!arg_type[i] && uns_p)
	arg_type[i] = builtin_mode_to_type[m][0];

      if (!arg_type[i])
	fatal_error (input_location,
		     "internal error: builtin function %qs, argument %d "
		     "had unexpected argument type %qs", name, i,
		     GET_MODE_NAME (m));
    }

  builtin_hash_struct **found = builtin_hash_table->find_slot (&h, INSERT);
  if (*found == NULL)
    {
      h2 = ggc_alloc<builtin_hash_struct> ();
      *h2 = h;
      *found = h2;

      h2->type = build_function_type_list (ret_type, arg_type[0], arg_type[1],
					   arg_type[2], NULL_TREE);
    }

  return (*found)->type;
}

static void
rs6000_common_init_builtins (void)
{
  const struct builtin_description *d;
  size_t i;

  tree opaque_ftype_opaque = NULL_TREE;
  tree opaque_ftype_opaque_opaque = NULL_TREE;
  tree opaque_ftype_opaque_opaque_opaque = NULL_TREE;
  HOST_WIDE_INT builtin_mask = rs6000_builtin_mask;

  /* Create Altivec and VSX builtins on machines with at least the
     general purpose extensions (970 and newer) to allow the use of
     the target attribute.  */

  if (TARGET_EXTRA_BUILTINS)
    builtin_mask |= RS6000_BTM_COMMON;

  /* Add the ternary operators.  */
  d = bdesc_3arg;
  for (i = 0; i < ARRAY_SIZE (bdesc_3arg); i++, d++)
    {
      tree type;
      HOST_WIDE_INT mask = d->mask;

      if ((mask & builtin_mask) != mask)
	{
	  if (TARGET_DEBUG_BUILTIN)
	    fprintf (stderr, "rs6000_builtin, skip ternary %s\n", d->name);
	  continue;
	}

      if (rs6000_overloaded_builtin_p (d->code))
	{
	  if (! (type = opaque_ftype_opaque_opaque_opaque))
	    type = opaque_ftype_opaque_opaque_opaque
	      = build_function_type_list (opaque_V4SI_type_node,
					  opaque_V4SI_type_node,
					  opaque_V4SI_type_node,
					  opaque_V4SI_type_node,
					  NULL_TREE);
	}
      else
	{
	  enum insn_code icode = d->icode;
	  if (d->name == 0)
	    {
	      if (TARGET_DEBUG_BUILTIN)
		fprintf (stderr, "rs6000_builtin, bdesc_3arg[%ld] no name\n",
			 (long unsigned)i);

	      continue;
	    }

          if (icode == CODE_FOR_nothing)
	    {
	      if (TARGET_DEBUG_BUILTIN)
		fprintf (stderr, "rs6000_builtin, skip ternary %s (no code)\n",
			 d->name);

	      continue;
	    }

	  type = builtin_function_type (insn_data[icode].operand[0].mode,
					insn_data[icode].operand[1].mode,
					insn_data[icode].operand[2].mode,
					insn_data[icode].operand[3].mode,
					d->code, d->name);
	}

      def_builtin (d->name, type, d->code);
    }

  /* Add the binary operators.  */
  d = bdesc_2arg;
  for (i = 0; i < ARRAY_SIZE (bdesc_2arg); i++, d++)
    {
      machine_mode mode0, mode1, mode2;
      tree type;
      HOST_WIDE_INT mask = d->mask;

      if ((mask & builtin_mask) != mask)
	{
	  if (TARGET_DEBUG_BUILTIN)
	    fprintf (stderr, "rs6000_builtin, skip binary %s\n", d->name);
	  continue;
	}

      if (rs6000_overloaded_builtin_p (d->code))
	{
	  if (! (type = opaque_ftype_opaque_opaque))
	    type = opaque_ftype_opaque_opaque
	      = build_function_type_list (opaque_V4SI_type_node,
					  opaque_V4SI_type_node,
					  opaque_V4SI_type_node,
					  NULL_TREE);
	}
      else
	{
	  enum insn_code icode = d->icode;
	  if (d->name == 0)
	    {
	      if (TARGET_DEBUG_BUILTIN)
		fprintf (stderr, "rs6000_builtin, bdesc_2arg[%ld] no name\n",
			 (long unsigned)i);

	      continue;
	    }

          if (icode == CODE_FOR_nothing)
	    {
	      if (TARGET_DEBUG_BUILTIN)
		fprintf (stderr, "rs6000_builtin, skip binary %s (no code)\n",
			 d->name);

	      continue;
	    }

          mode0 = insn_data[icode].operand[0].mode;
          mode1 = insn_data[icode].operand[1].mode;
          mode2 = insn_data[icode].operand[2].mode;

	  type = builtin_function_type (mode0, mode1, mode2, VOIDmode,
					d->code, d->name);
	}

      def_builtin (d->name, type, d->code);
    }

  /* Add the simple unary operators.  */
  d = bdesc_1arg;
  for (i = 0; i < ARRAY_SIZE (bdesc_1arg); i++, d++)
    {
      machine_mode mode0, mode1;
      tree type;
      HOST_WIDE_INT mask = d->mask;

      if ((mask & builtin_mask) != mask)
	{
	  if (TARGET_DEBUG_BUILTIN)
	    fprintf (stderr, "rs6000_builtin, skip unary %s\n", d->name);
	  continue;
	}

      if (rs6000_overloaded_builtin_p (d->code))
	{
	  if (! (type = opaque_ftype_opaque))
	    type = opaque_ftype_opaque
	      = build_function_type_list (opaque_V4SI_type_node,
					  opaque_V4SI_type_node,
					  NULL_TREE);
	}
      else
        {
	  enum insn_code icode = d->icode;
	  if (d->name == 0)
	    {
	      if (TARGET_DEBUG_BUILTIN)
		fprintf (stderr, "rs6000_builtin, bdesc_1arg[%ld] no name\n",
			 (long unsigned)i);

	      continue;
	    }

          if (icode == CODE_FOR_nothing)
	    {
	      if (TARGET_DEBUG_BUILTIN)
		fprintf (stderr, "rs6000_builtin, skip unary %s (no code)\n",
			 d->name);

	      continue;
	    }

          mode0 = insn_data[icode].operand[0].mode;
          mode1 = insn_data[icode].operand[1].mode;

	  type = builtin_function_type (mode0, mode1, VOIDmode, VOIDmode,
					d->code, d->name);
	}

      def_builtin (d->name, type, d->code);
    }

  /* Add the simple no-argument operators.  */
  d = bdesc_0arg;
  for (i = 0; i < ARRAY_SIZE (bdesc_0arg); i++, d++)
    {
      machine_mode mode0;
      tree type;
      HOST_WIDE_INT mask = d->mask;

      if ((mask & builtin_mask) != mask)
	{
	  if (TARGET_DEBUG_BUILTIN)
	    fprintf (stderr, "rs6000_builtin, skip no-argument %s\n", d->name);
	  continue;
	}
      if (rs6000_overloaded_builtin_p (d->code))
	{
	  if (!opaque_ftype_opaque)
	    opaque_ftype_opaque
	      = build_function_type_list (opaque_V4SI_type_node, NULL_TREE);
	  type = opaque_ftype_opaque;
	}
      else
	{
	  enum insn_code icode = d->icode;
	  if (d->name == 0)
	    {
	      if (TARGET_DEBUG_BUILTIN)
		fprintf (stderr, "rs6000_builtin, bdesc_0arg[%lu] no name\n",
			 (long unsigned) i);
	      continue;
	    }
	  if (icode == CODE_FOR_nothing)
	    {
	      if (TARGET_DEBUG_BUILTIN)
		fprintf (stderr,
			 "rs6000_builtin, skip no-argument %s (no code)\n",
			 d->name);
	      continue;
	    }
	  mode0 = insn_data[icode].operand[0].mode;
	  type = builtin_function_type (mode0, VOIDmode, VOIDmode, VOIDmode,
					d->code, d->name);
	}
      def_builtin (d->name, type, d->code);
    }
}

/* Set up AIX/Darwin/64-bit Linux quad floating point routines.  */
static void
init_float128_ibm (machine_mode mode)
{
  if (!TARGET_XL_COMPAT)
    {
      set_optab_libfunc (add_optab, mode, "__gcc_qadd");
      set_optab_libfunc (sub_optab, mode, "__gcc_qsub");
      set_optab_libfunc (smul_optab, mode, "__gcc_qmul");
      set_optab_libfunc (sdiv_optab, mode, "__gcc_qdiv");

      if (!TARGET_HARD_FLOAT)
	{
	  set_optab_libfunc (neg_optab, mode, "__gcc_qneg");
	  set_optab_libfunc (eq_optab, mode, "__gcc_qeq");
	  set_optab_libfunc (ne_optab, mode, "__gcc_qne");
	  set_optab_libfunc (gt_optab, mode, "__gcc_qgt");
	  set_optab_libfunc (ge_optab, mode, "__gcc_qge");
	  set_optab_libfunc (lt_optab, mode, "__gcc_qlt");
	  set_optab_libfunc (le_optab, mode, "__gcc_qle");
	  set_optab_libfunc (unord_optab, mode, "__gcc_qunord");

	  set_conv_libfunc (sext_optab, mode, SFmode, "__gcc_stoq");
	  set_conv_libfunc (sext_optab, mode, DFmode, "__gcc_dtoq");
	  set_conv_libfunc (trunc_optab, SFmode, mode, "__gcc_qtos");
	  set_conv_libfunc (trunc_optab, DFmode, mode, "__gcc_qtod");
	  set_conv_libfunc (sfix_optab, SImode, mode, "__gcc_qtoi");
	  set_conv_libfunc (ufix_optab, SImode, mode, "__gcc_qtou");
	  set_conv_libfunc (sfloat_optab, mode, SImode, "__gcc_itoq");
	  set_conv_libfunc (ufloat_optab, mode, SImode, "__gcc_utoq");
	}
    }
  else
    {
      set_optab_libfunc (add_optab, mode, "_xlqadd");
      set_optab_libfunc (sub_optab, mode, "_xlqsub");
      set_optab_libfunc (smul_optab, mode, "_xlqmul");
      set_optab_libfunc (sdiv_optab, mode, "_xlqdiv");
    }

  /* Add various conversions for IFmode to use the traditional TFmode
     names.  */
  if (mode == IFmode)
    {
      set_conv_libfunc (sext_optab, mode, SDmode, "__dpd_extendsdtf");
      set_conv_libfunc (sext_optab, mode, DDmode, "__dpd_extendddtf");
      set_conv_libfunc (trunc_optab, mode, TDmode, "__dpd_trunctdtf");
      set_conv_libfunc (trunc_optab, SDmode, mode, "__dpd_trunctfsd");
      set_conv_libfunc (trunc_optab, DDmode, mode, "__dpd_trunctfdd");
      set_conv_libfunc (sext_optab, TDmode, mode, "__dpd_extendtftd");

      if (TARGET_POWERPC64)
	{
	  set_conv_libfunc (sfix_optab, TImode, mode, "__fixtfti");
	  set_conv_libfunc (ufix_optab, TImode, mode, "__fixunstfti");
	  set_conv_libfunc (sfloat_optab, mode, TImode, "__floattitf");
	  set_conv_libfunc (ufloat_optab, mode, TImode, "__floatuntitf");
	}
    }
}

/* Create a decl for either complex long double multiply or complex long double
   divide when long double is IEEE 128-bit floating point.  We can't use
   __multc3 and __divtc3 because the original long double using IBM extended
   double used those names.  The complex multiply/divide functions are encoded
   as builtin functions with a complex result and 4 scalar inputs.  */

static void
create_complex_muldiv (const char *name, built_in_function fncode, tree fntype)
{
  tree fndecl = add_builtin_function (name, fntype, fncode, BUILT_IN_NORMAL,
				      name, NULL_TREE);

  set_builtin_decl (fncode, fndecl, true);

  if (TARGET_DEBUG_BUILTIN)
    fprintf (stderr, "create complex %s, fncode: %d\n", name, (int) fncode);

  return;
}

/* Set up IEEE 128-bit floating point routines.  Use different names if the
   arguments can be passed in a vector register.  The historical PowerPC
   implementation of IEEE 128-bit floating point used _q_<op> for the names, so
   continue to use that if we aren't using vector registers to pass IEEE
   128-bit floating point.  */

static void
init_float128_ieee (machine_mode mode)
{
  if (FLOAT128_VECTOR_P (mode))
    {
      static bool complex_muldiv_init_p = false;

      /* Set up to call __mulkc3 and __divkc3 under -mabi=ieeelongdouble.  If
	 we have clone or target attributes, this will be called a second
	 time.  We want to create the built-in function only once.  */
     if (mode == TFmode && TARGET_IEEEQUAD && !complex_muldiv_init_p)
       {
	 complex_muldiv_init_p = true;
	 built_in_function fncode_mul =
	   (built_in_function) (BUILT_IN_COMPLEX_MUL_MIN + TCmode
				- MIN_MODE_COMPLEX_FLOAT);
	 built_in_function fncode_div =
	   (built_in_function) (BUILT_IN_COMPLEX_DIV_MIN + TCmode
				- MIN_MODE_COMPLEX_FLOAT);

	 tree fntype = build_function_type_list (complex_long_double_type_node,
						 long_double_type_node,
						 long_double_type_node,
						 long_double_type_node,
						 long_double_type_node,
						 NULL_TREE);

	 create_complex_muldiv ("__mulkc3", fncode_mul, fntype);
	 create_complex_muldiv ("__divkc3", fncode_div, fntype);
       }

      set_optab_libfunc (add_optab, mode, "__addkf3");
      set_optab_libfunc (sub_optab, mode, "__subkf3");
      set_optab_libfunc (neg_optab, mode, "__negkf2");
      set_optab_libfunc (smul_optab, mode, "__mulkf3");
      set_optab_libfunc (sdiv_optab, mode, "__divkf3");
      set_optab_libfunc (sqrt_optab, mode, "__sqrtkf2");
      set_optab_libfunc (abs_optab, mode, "__abskf2");
      set_optab_libfunc (powi_optab, mode, "__powikf2");

      set_optab_libfunc (eq_optab, mode, "__eqkf2");
      set_optab_libfunc (ne_optab, mode, "__nekf2");
      set_optab_libfunc (gt_optab, mode, "__gtkf2");
      set_optab_libfunc (ge_optab, mode, "__gekf2");
      set_optab_libfunc (lt_optab, mode, "__ltkf2");
      set_optab_libfunc (le_optab, mode, "__lekf2");
      set_optab_libfunc (unord_optab, mode, "__unordkf2");

      set_conv_libfunc (sext_optab, mode, SFmode, "__extendsfkf2");
      set_conv_libfunc (sext_optab, mode, DFmode, "__extenddfkf2");
      set_conv_libfunc (trunc_optab, SFmode, mode, "__trunckfsf2");
      set_conv_libfunc (trunc_optab, DFmode, mode, "__trunckfdf2");

      set_conv_libfunc (sext_optab, mode, IFmode, "__trunctfkf2");
      if (mode != TFmode && FLOAT128_IBM_P (TFmode))
	set_conv_libfunc (sext_optab, mode, TFmode, "__trunctfkf2");

      set_conv_libfunc (trunc_optab, IFmode, mode, "__extendkftf2");
      if (mode != TFmode && FLOAT128_IBM_P (TFmode))
	set_conv_libfunc (trunc_optab, TFmode, mode, "__extendkftf2");

      set_conv_libfunc (sext_optab, mode, SDmode, "__dpd_extendsdkf");
      set_conv_libfunc (sext_optab, mode, DDmode, "__dpd_extendddkf");
      set_conv_libfunc (trunc_optab, mode, TDmode, "__dpd_trunctdkf");
      set_conv_libfunc (trunc_optab, SDmode, mode, "__dpd_trunckfsd");
      set_conv_libfunc (trunc_optab, DDmode, mode, "__dpd_trunckfdd");
      set_conv_libfunc (sext_optab, TDmode, mode, "__dpd_extendkftd");

      set_conv_libfunc (sfix_optab, SImode, mode, "__fixkfsi");
      set_conv_libfunc (ufix_optab, SImode, mode, "__fixunskfsi");
      set_conv_libfunc (sfix_optab, DImode, mode, "__fixkfdi");
      set_conv_libfunc (ufix_optab, DImode, mode, "__fixunskfdi");

      set_conv_libfunc (sfloat_optab, mode, SImode, "__floatsikf");
      set_conv_libfunc (ufloat_optab, mode, SImode, "__floatunsikf");
      set_conv_libfunc (sfloat_optab, mode, DImode, "__floatdikf");
      set_conv_libfunc (ufloat_optab, mode, DImode, "__floatundikf");

      if (TARGET_POWERPC64)
	{
	  set_conv_libfunc (sfix_optab, TImode, mode, "__fixkfti");
	  set_conv_libfunc (ufix_optab, TImode, mode, "__fixunskfti");
	  set_conv_libfunc (sfloat_optab, mode, TImode, "__floattikf");
	  set_conv_libfunc (ufloat_optab, mode, TImode, "__floatuntikf");
	}
    }

  else
    {
      set_optab_libfunc (add_optab, mode, "_q_add");
      set_optab_libfunc (sub_optab, mode, "_q_sub");
      set_optab_libfunc (neg_optab, mode, "_q_neg");
      set_optab_libfunc (smul_optab, mode, "_q_mul");
      set_optab_libfunc (sdiv_optab, mode, "_q_div");
      if (TARGET_PPC_GPOPT)
	set_optab_libfunc (sqrt_optab, mode, "_q_sqrt");

      set_optab_libfunc (eq_optab, mode, "_q_feq");
      set_optab_libfunc (ne_optab, mode, "_q_fne");
      set_optab_libfunc (gt_optab, mode, "_q_fgt");
      set_optab_libfunc (ge_optab, mode, "_q_fge");
      set_optab_libfunc (lt_optab, mode, "_q_flt");
      set_optab_libfunc (le_optab, mode, "_q_fle");

      set_conv_libfunc (sext_optab, mode, SFmode, "_q_stoq");
      set_conv_libfunc (sext_optab, mode, DFmode, "_q_dtoq");
      set_conv_libfunc (trunc_optab, SFmode, mode, "_q_qtos");
      set_conv_libfunc (trunc_optab, DFmode, mode, "_q_qtod");
      set_conv_libfunc (sfix_optab, SImode, mode, "_q_qtoi");
      set_conv_libfunc (ufix_optab, SImode, mode, "_q_qtou");
      set_conv_libfunc (sfloat_optab, mode, SImode, "_q_itoq");
      set_conv_libfunc (ufloat_optab, mode, SImode, "_q_utoq");
    }
}

static void
rs6000_init_libfuncs (void)
{
  /* __float128 support.  */
  if (TARGET_FLOAT128_TYPE)
    {
      init_float128_ibm (IFmode);
      init_float128_ieee (KFmode);
    }

  /* AIX/Darwin/64-bit Linux quad floating point routines.  */
  if (TARGET_LONG_DOUBLE_128)
    {
      if (!TARGET_IEEEQUAD)
	init_float128_ibm (TFmode);

      /* IEEE 128-bit including 32-bit SVR4 quad floating point routines.  */
      else
	init_float128_ieee (TFmode);
    }
}

/* Emit a potentially record-form instruction, setting DST from SRC.
   If DOT is 0, that is all; otherwise, set CCREG to the result of the
   signed comparison of DST with zero.  If DOT is 1, the generated RTL
   doesn't care about the DST result; if DOT is 2, it does.  If CCREG
   is CR0 do a single dot insn (as a PARALLEL); otherwise, do a SET and
   a separate COMPARE.  */

void
rs6000_emit_dot_insn (rtx dst, rtx src, int dot, rtx ccreg)
{
  if (dot == 0)
    {
      emit_move_insn (dst, src);
      return;
    }

  if (cc_reg_not_cr0_operand (ccreg, CCmode))
    {
      emit_move_insn (dst, src);
      emit_move_insn (ccreg, gen_rtx_COMPARE (CCmode, dst, const0_rtx));
      return;
    }

  rtx ccset = gen_rtx_SET (ccreg, gen_rtx_COMPARE (CCmode, src, const0_rtx));
  if (dot == 1)
    {
      rtx clobber = gen_rtx_CLOBBER (VOIDmode, dst);
      emit_insn (gen_rtx_PARALLEL (VOIDmode, gen_rtvec (2, ccset, clobber)));
    }
  else
    {
      rtx set = gen_rtx_SET (dst, src);
      emit_insn (gen_rtx_PARALLEL (VOIDmode, gen_rtvec (2, ccset, set)));
    }
}


/* A validation routine: say whether CODE, a condition code, and MODE
   match.  The other alternatives either don't make sense or should
   never be generated.  */

void
validate_condition_mode (enum rtx_code code, machine_mode mode)
{
  gcc_assert ((GET_RTX_CLASS (code) == RTX_COMPARE
	       || GET_RTX_CLASS (code) == RTX_COMM_COMPARE)
	      && GET_MODE_CLASS (mode) == MODE_CC);

  /* These don't make sense.  */
  gcc_assert ((code != GT && code != LT && code != GE && code != LE)
	      || mode != CCUNSmode);

  gcc_assert ((code != GTU && code != LTU && code != GEU && code != LEU)
	      || mode == CCUNSmode);

  gcc_assert (mode == CCFPmode
	      || (code != ORDERED && code != UNORDERED
		  && code != UNEQ && code != LTGT
		  && code != UNGT && code != UNLT
		  && code != UNGE && code != UNLE));

  /* These should never be generated except for
     flag_finite_math_only.  */
  gcc_assert (mode != CCFPmode
	      || flag_finite_math_only
	      || (code != LE && code != GE
		  && code != UNEQ && code != LTGT
		  && code != UNGT && code != UNLT));

  /* These are invalid; the information is not there.  */
  gcc_assert (mode != CCEQmode || code == EQ || code == NE);
}


/* Return whether MASK (a CONST_INT) is a valid mask for any rlwinm,
   rldicl, rldicr, or rldic instruction in mode MODE.  If so, if E is
   not zero, store there the bit offset (counted from the right) where
   the single stretch of 1 bits begins; and similarly for B, the bit
   offset where it ends.  */

bool
rs6000_is_valid_mask (rtx mask, int *b, int *e, machine_mode mode)
{
  unsigned HOST_WIDE_INT val = INTVAL (mask);
  unsigned HOST_WIDE_INT bit;
  int nb, ne;
  int n = GET_MODE_PRECISION (mode);

  if (mode != DImode && mode != SImode)
    return false;

  if (INTVAL (mask) >= 0)
    {
      bit = val & -val;
      ne = exact_log2 (bit);
      nb = exact_log2 (val + bit);
    }
  else if (val + 1 == 0)
    {
      nb = n;
      ne = 0;
    }
  else if (val & 1)
    {
      val = ~val;
      bit = val & -val;
      nb = exact_log2 (bit);
      ne = exact_log2 (val + bit);
    }
  else
    {
      bit = val & -val;
      ne = exact_log2 (bit);
      if (val + bit == 0)
	nb = n;
      else
	nb = 0;
    }

  nb--;

  if (nb < 0 || ne < 0 || nb >= n || ne >= n)
    return false;

  if (b)
    *b = nb;
  if (e)
    *e = ne;

  return true;
}

/* Return whether MASK (a CONST_INT) is a valid mask for any rlwinm, rldicl,
   or rldicr instruction, to implement an AND with it in mode MODE.  */

bool
rs6000_is_valid_and_mask (rtx mask, machine_mode mode)
{
  int nb, ne;

  if (!rs6000_is_valid_mask (mask, &nb, &ne, mode))
    return false;

  /* For DImode, we need a rldicl, rldicr, or a rlwinm with mask that
     does not wrap.  */
  if (mode == DImode)
    return (ne == 0 || nb == 63 || (nb < 32 && ne <= nb));

  /* For SImode, rlwinm can do everything.  */
  if (mode == SImode)
    return (nb < 32 && ne < 32);

  return false;
}

/* Return the instruction template for an AND with mask in mode MODE, with
   operands OPERANDS.  If DOT is true, make it a record-form instruction.  */

const char *
rs6000_insn_for_and_mask (machine_mode mode, rtx *operands, bool dot)
{
  int nb, ne;

  if (!rs6000_is_valid_mask (operands[2], &nb, &ne, mode))
    gcc_unreachable ();

  if (mode == DImode && ne == 0)
    {
      operands[3] = GEN_INT (63 - nb);
      if (dot)
	return "rldicl. %0,%1,0,%3";
      return "rldicl %0,%1,0,%3";
    }

  if (mode == DImode && nb == 63)
    {
      operands[3] = GEN_INT (63 - ne);
      if (dot)
	return "rldicr. %0,%1,0,%3";
      return "rldicr %0,%1,0,%3";
    }

  if (nb < 32 && ne < 32)
    {
      operands[3] = GEN_INT (31 - nb);
      operands[4] = GEN_INT (31 - ne);
      if (dot)
	return "rlwinm. %0,%1,0,%3,%4";
      return "rlwinm %0,%1,0,%3,%4";
    }

  gcc_unreachable ();
}

/* Return whether MASK (a CONST_INT) is a valid mask for any rlw[i]nm,
   rld[i]cl, rld[i]cr, or rld[i]c instruction, to implement an AND with
   shift SHIFT (a ROTATE, ASHIFT, or LSHIFTRT) in mode MODE.  */

bool
rs6000_is_valid_shift_mask (rtx mask, rtx shift, machine_mode mode)
{
  int nb, ne;

  if (!rs6000_is_valid_mask (mask, &nb, &ne, mode))
    return false;

  int n = GET_MODE_PRECISION (mode);
  int sh = -1;

  if (CONST_INT_P (XEXP (shift, 1)))
    {
      sh = INTVAL (XEXP (shift, 1));
      if (sh < 0 || sh >= n)
	return false;
    }

  rtx_code code = GET_CODE (shift);

  /* Convert any shift by 0 to a rotate, to simplify below code.  */
  if (sh == 0)
    code = ROTATE;

  /* Convert rotate to simple shift if we can, to make analysis simpler.  */
  if (code == ROTATE && sh >= 0 && nb >= ne && ne >= sh)
    code = ASHIFT;
  if (code == ROTATE && sh >= 0 && nb >= ne && nb < sh)
    {
      code = LSHIFTRT;
      sh = n - sh;
    }

  /* DImode rotates need rld*.  */
  if (mode == DImode && code == ROTATE)
    return (nb == 63 || ne == 0 || ne == sh);

  /* SImode rotates need rlw*.  */
  if (mode == SImode && code == ROTATE)
    return (nb < 32 && ne < 32 && sh < 32);

  /* Wrap-around masks are only okay for rotates.  */
  if (ne > nb)
    return false;

  /* Variable shifts are only okay for rotates.  */
  if (sh < 0)
    return false;

  /* Don't allow ASHIFT if the mask is wrong for that.  */
  if (code == ASHIFT && ne < sh)
    return false;

  /* If we can do it with an rlw*, we can do it.  Don't allow LSHIFTRT
     if the mask is wrong for that.  */
  if (nb < 32 && ne < 32 && sh < 32
      && !(code == LSHIFTRT && nb >= 32 - sh))
    return true;

  /* If we can do it with an rld*, we can do it.  Don't allow LSHIFTRT
     if the mask is wrong for that.  */
  if (code == LSHIFTRT)
    sh = 64 - sh;
  if (nb == 63 || ne == 0 || ne == sh)
    return !(code == LSHIFTRT && nb >= sh);

  return false;
}

/* Return the instruction template for a shift with mask in mode MODE, with
   operands OPERANDS.  If DOT is true, make it a record-form instruction.  */

const char *
rs6000_insn_for_shift_mask (machine_mode mode, rtx *operands, bool dot)
{
  int nb, ne;

  if (!rs6000_is_valid_mask (operands[3], &nb, &ne, mode))
    gcc_unreachable ();

  if (mode == DImode && ne == 0)
    {
      if (GET_CODE (operands[4]) == LSHIFTRT && INTVAL (operands[2]))
	operands[2] = GEN_INT (64 - INTVAL (operands[2]));
      operands[3] = GEN_INT (63 - nb);
      if (dot)
	return "rld%I2cl. %0,%1,%2,%3";
      return "rld%I2cl %0,%1,%2,%3";
    }

  if (mode == DImode && nb == 63)
    {
      operands[3] = GEN_INT (63 - ne);
      if (dot)
	return "rld%I2cr. %0,%1,%2,%3";
      return "rld%I2cr %0,%1,%2,%3";
    }

  if (mode == DImode
      && GET_CODE (operands[4]) != LSHIFTRT
      && CONST_INT_P (operands[2])
      && ne == INTVAL (operands[2]))
    {
      operands[3] = GEN_INT (63 - nb);
      if (dot)
	return "rld%I2c. %0,%1,%2,%3";
      return "rld%I2c %0,%1,%2,%3";
    }

  if (nb < 32 && ne < 32)
    {
      if (GET_CODE (operands[4]) == LSHIFTRT && INTVAL (operands[2]))
	operands[2] = GEN_INT (32 - INTVAL (operands[2]));
      operands[3] = GEN_INT (31 - nb);
      operands[4] = GEN_INT (31 - ne);
      /* This insn can also be a 64-bit rotate with mask that really makes
	 it just a shift right (with mask); the %h below are to adjust for
	 that situation (shift count is >= 32 in that case).  */
      if (dot)
	return "rlw%I2nm. %0,%1,%h2,%3,%4";
      return "rlw%I2nm %0,%1,%h2,%3,%4";
    }

  gcc_unreachable ();
}

/* Return whether MASK (a CONST_INT) is a valid mask for any rlwimi or
   rldimi instruction, to implement an insert with shift SHIFT (a ROTATE,
   ASHIFT, or LSHIFTRT) in mode MODE.  */

bool
rs6000_is_valid_insert_mask (rtx mask, rtx shift, machine_mode mode)
{
  int nb, ne;

  if (!rs6000_is_valid_mask (mask, &nb, &ne, mode))
    return false;

  int n = GET_MODE_PRECISION (mode);

  int sh = INTVAL (XEXP (shift, 1));
  if (sh < 0 || sh >= n)
    return false;

  rtx_code code = GET_CODE (shift);

  /* Convert any shift by 0 to a rotate, to simplify below code.  */
  if (sh == 0)
    code = ROTATE;

  /* Convert rotate to simple shift if we can, to make analysis simpler.  */
  if (code == ROTATE && sh >= 0 && nb >= ne && ne >= sh)
    code = ASHIFT;
  if (code == ROTATE && sh >= 0 && nb >= ne && nb < sh)
    {
      code = LSHIFTRT;
      sh = n - sh;
    }

  /* DImode rotates need rldimi.  */
  if (mode == DImode && code == ROTATE)
    return (ne == sh);

  /* SImode rotates need rlwimi.  */
  if (mode == SImode && code == ROTATE)
    return (nb < 32 && ne < 32 && sh < 32);

  /* Wrap-around masks are only okay for rotates.  */
  if (ne > nb)
    return false;

  /* Don't allow ASHIFT if the mask is wrong for that.  */
  if (code == ASHIFT && ne < sh)
    return false;

  /* If we can do it with an rlwimi, we can do it.  Don't allow LSHIFTRT
     if the mask is wrong for that.  */
  if (nb < 32 && ne < 32 && sh < 32
      && !(code == LSHIFTRT && nb >= 32 - sh))
    return true;

  /* If we can do it with an rldimi, we can do it.  Don't allow LSHIFTRT
     if the mask is wrong for that.  */
  if (code == LSHIFTRT)
    sh = 64 - sh;
  if (ne == sh)
    return !(code == LSHIFTRT && nb >= sh);

  return false;
}

/* Return the instruction template for an insert with mask in mode MODE, with
   operands OPERANDS.  If DOT is true, make it a record-form instruction.  */

const char *
rs6000_insn_for_insert_mask (machine_mode mode, rtx *operands, bool dot)
{
  int nb, ne;

  if (!rs6000_is_valid_mask (operands[3], &nb, &ne, mode))
    gcc_unreachable ();

  /* Prefer rldimi because rlwimi is cracked.  */
  if (TARGET_POWERPC64
      && (!dot || mode == DImode)
      && GET_CODE (operands[4]) != LSHIFTRT
      && ne == INTVAL (operands[2]))
    {
      operands[3] = GEN_INT (63 - nb);
      if (dot)
	return "rldimi. %0,%1,%2,%3";
      return "rldimi %0,%1,%2,%3";
    }

  if (nb < 32 && ne < 32)
    {
      if (GET_CODE (operands[4]) == LSHIFTRT && INTVAL (operands[2]))
	operands[2] = GEN_INT (32 - INTVAL (operands[2]));
      operands[3] = GEN_INT (31 - nb);
      operands[4] = GEN_INT (31 - ne);
      if (dot)
	return "rlwimi. %0,%1,%2,%3,%4";
      return "rlwimi %0,%1,%2,%3,%4";
    }

  gcc_unreachable ();
}

/* Return whether an AND with C (a CONST_INT) in mode MODE can be done
   using two machine instructions.  */

bool
rs6000_is_valid_2insn_and (rtx c, machine_mode mode)
{
  /* There are two kinds of AND we can handle with two insns:
     1) those we can do with two rl* insn;
     2) ori[s];xori[s].

     We do not handle that last case yet.  */

  /* If there is just one stretch of ones, we can do it.  */
  if (rs6000_is_valid_mask (c, NULL, NULL, mode))
    return true;

  /* Otherwise, fill in the lowest "hole"; if we can do the result with
     one insn, we can do the whole thing with two.  */
  unsigned HOST_WIDE_INT val = INTVAL (c);
  unsigned HOST_WIDE_INT bit1 = val & -val;
  unsigned HOST_WIDE_INT bit2 = (val + bit1) & ~val;
  unsigned HOST_WIDE_INT val1 = (val + bit1) & val;
  unsigned HOST_WIDE_INT bit3 = val1 & -val1;
  return rs6000_is_valid_and_mask (GEN_INT (val + bit3 - bit2), mode);
}

/* Emit the two insns to do an AND in mode MODE, with operands OPERANDS.
   If EXPAND is true, split rotate-and-mask instructions we generate to
   their constituent parts as well (this is used during expand); if DOT
   is 1, make the last insn a record-form instruction clobbering the
   destination GPR and setting the CC reg (from operands[3]); if 2, set
   that GPR as well as the CC reg.  */

void
rs6000_emit_2insn_and (machine_mode mode, rtx *operands, bool expand, int dot)
{
  gcc_assert (!(expand && dot));

  unsigned HOST_WIDE_INT val = INTVAL (operands[2]);

  /* If it is one stretch of ones, it is DImode; shift left, mask, then
     shift right.  This generates better code than doing the masks without
     shifts, or shifting first right and then left.  */
  int nb, ne;
  if (rs6000_is_valid_mask (operands[2], &nb, &ne, mode) && nb >= ne)
    {
      gcc_assert (mode == DImode);

      int shift = 63 - nb;
      if (expand)
	{
	  rtx tmp1 = gen_reg_rtx (DImode);
	  rtx tmp2 = gen_reg_rtx (DImode);
	  emit_insn (gen_ashldi3 (tmp1, operands[1], GEN_INT (shift)));
	  emit_insn (gen_anddi3 (tmp2, tmp1, GEN_INT (val << shift)));
	  emit_insn (gen_lshrdi3 (operands[0], tmp2, GEN_INT (shift)));
	}
      else
	{
	  rtx tmp = gen_rtx_ASHIFT (mode, operands[1], GEN_INT (shift));
	  tmp = gen_rtx_AND (mode, tmp, GEN_INT (val << shift));
	  emit_move_insn (operands[0], tmp);
	  tmp = gen_rtx_LSHIFTRT (mode, operands[0], GEN_INT (shift));
	  rs6000_emit_dot_insn (operands[0], tmp, dot, dot ? operands[3] : 0);
	}
      return;
    }

  /* Otherwise, make a mask2 that cuts out the lowest "hole", and a mask1
     that does the rest.  */
  unsigned HOST_WIDE_INT bit1 = val & -val;
  unsigned HOST_WIDE_INT bit2 = (val + bit1) & ~val;
  unsigned HOST_WIDE_INT val1 = (val + bit1) & val;
  unsigned HOST_WIDE_INT bit3 = val1 & -val1;

  unsigned HOST_WIDE_INT mask1 = -bit3 + bit2 - 1;
  unsigned HOST_WIDE_INT mask2 = val + bit3 - bit2;

  gcc_assert (rs6000_is_valid_and_mask (GEN_INT (mask2), mode));

  /* Two "no-rotate"-and-mask instructions, for SImode.  */
  if (rs6000_is_valid_and_mask (GEN_INT (mask1), mode))
    {
      gcc_assert (mode == SImode);

      rtx reg = expand ? gen_reg_rtx (mode) : operands[0];
      rtx tmp = gen_rtx_AND (mode, operands[1], GEN_INT (mask1));
      emit_move_insn (reg, tmp);
      tmp = gen_rtx_AND (mode, reg, GEN_INT (mask2));
      rs6000_emit_dot_insn (operands[0], tmp, dot, dot ? operands[3] : 0);
      return;
    }

  gcc_assert (mode == DImode);

  /* Two "no-rotate"-and-mask instructions, for DImode: both are rlwinm
     insns; we have to do the first in SImode, because it wraps.  */
  if (mask2 <= 0xffffffff
      && rs6000_is_valid_and_mask (GEN_INT (mask1), SImode))
    {
      rtx reg = expand ? gen_reg_rtx (mode) : operands[0];
      rtx tmp = gen_rtx_AND (SImode, gen_lowpart (SImode, operands[1]),
			     GEN_INT (mask1));
      rtx reg_low = gen_lowpart (SImode, reg);
      emit_move_insn (reg_low, tmp);
      tmp = gen_rtx_AND (mode, reg, GEN_INT (mask2));
      rs6000_emit_dot_insn (operands[0], tmp, dot, dot ? operands[3] : 0);
      return;
    }

  /* Two rld* insns: rotate, clear the hole in the middle (which now is
     at the top end), rotate back and clear the other hole.  */
  int right = exact_log2 (bit3);
  int left = 64 - right;

  /* Rotate the mask too.  */
  mask1 = (mask1 >> right) | ((bit2 - 1) << left);

  if (expand)
    {
      rtx tmp1 = gen_reg_rtx (DImode);
      rtx tmp2 = gen_reg_rtx (DImode);
      rtx tmp3 = gen_reg_rtx (DImode);
      emit_insn (gen_rotldi3 (tmp1, operands[1], GEN_INT (left)));
      emit_insn (gen_anddi3 (tmp2, tmp1, GEN_INT (mask1)));
      emit_insn (gen_rotldi3 (tmp3, tmp2, GEN_INT (right)));
      emit_insn (gen_anddi3 (operands[0], tmp3, GEN_INT (mask2)));
    }
  else
    {
      rtx tmp = gen_rtx_ROTATE (mode, operands[1], GEN_INT (left));
      tmp = gen_rtx_AND (mode, tmp, GEN_INT (mask1));
      emit_move_insn (operands[0], tmp);
      tmp = gen_rtx_ROTATE (mode, operands[0], GEN_INT (right));
      tmp = gen_rtx_AND (mode, tmp, GEN_INT (mask2));
      rs6000_emit_dot_insn (operands[0], tmp, dot, dot ? operands[3] : 0);
    }
}

/* Return 1 if REGNO (reg1) == REGNO (reg2) - 1 making them candidates
   for lfq and stfq insns iff the registers are hard registers.   */

int
registers_ok_for_quad_peep (rtx reg1, rtx reg2)
{
  /* We might have been passed a SUBREG.  */
  if (!REG_P (reg1) || !REG_P (reg2))
    return 0;

  /* We might have been passed non floating point registers.  */
  if (!FP_REGNO_P (REGNO (reg1))
      || !FP_REGNO_P (REGNO (reg2)))
    return 0;

  return (REGNO (reg1) == REGNO (reg2) - 1);
}

/* Return 1 if addr1 and addr2 are suitable for lfq or stfq insn.
   addr1 and addr2 must be in consecutive memory locations
   (addr2 == addr1 + 8).  */

int
mems_ok_for_quad_peep (rtx mem1, rtx mem2)
{
  rtx addr1, addr2;
  unsigned int reg1, reg2;
  int offset1, offset2;

  /* The mems cannot be volatile.  */
  if (MEM_VOLATILE_P (mem1) || MEM_VOLATILE_P (mem2))
    return 0;

  addr1 = XEXP (mem1, 0);
  addr2 = XEXP (mem2, 0);

  /* Extract an offset (if used) from the first addr.  */
  if (GET_CODE (addr1) == PLUS)
    {
      /* If not a REG, return zero.  */
      if (!REG_P (XEXP (addr1, 0)))
	return 0;
      else
	{
	  reg1 = REGNO (XEXP (addr1, 0));
	  /* The offset must be constant!  */
	  if (!CONST_INT_P (XEXP (addr1, 1)))
	    return 0;
	  offset1 = INTVAL (XEXP (addr1, 1));
	}
    }
  else if (!REG_P (addr1))
    return 0;
  else
    {
      reg1 = REGNO (addr1);
      /* This was a simple (mem (reg)) expression.  Offset is 0.  */
      offset1 = 0;
    }

  /* And now for the second addr.  */
  if (GET_CODE (addr2) == PLUS)
    {
      /* If not a REG, return zero.  */
      if (!REG_P (XEXP (addr2, 0)))
	return 0;
      else
	{
	  reg2 = REGNO (XEXP (addr2, 0));
	  /* The offset must be constant. */
	  if (!CONST_INT_P (XEXP (addr2, 1)))
	    return 0;
	  offset2 = INTVAL (XEXP (addr2, 1));
	}
    }
  else if (!REG_P (addr2))
    return 0;
  else
    {
      reg2 = REGNO (addr2);
      /* This was a simple (mem (reg)) expression.  Offset is 0.  */
      offset2 = 0;
    }

  /* Both of these must have the same base register.  */
  if (reg1 != reg2)
    return 0;

  /* The offset for the second addr must be 8 more than the first addr.  */
  if (offset2 != offset1 + 8)
    return 0;

  /* All the tests passed.  addr1 and addr2 are valid for lfq or stfq
     instructions.  */
  return 1;
}

/* Implement TARGET_SECONDARY_RELOAD_NEEDED_MODE.  For SDmode values we
   need to use DDmode, in all other cases we can use the same mode.  */
static machine_mode
rs6000_secondary_memory_needed_mode (machine_mode mode)
{
  if (lra_in_progress && mode == SDmode)
    return DDmode;
  return mode;
}

/* Classify a register type.  Because the FMRGOW/FMRGEW instructions only work
   on traditional floating point registers, and the VMRGOW/VMRGEW instructions
   only work on the traditional altivec registers, note if an altivec register
   was chosen.  */

static enum rs6000_reg_type
register_to_reg_type (rtx reg, bool *is_altivec)
{
  HOST_WIDE_INT regno;
  enum reg_class rclass;

  if (SUBREG_P (reg))
    reg = SUBREG_REG (reg);

  if (!REG_P (reg))
    return NO_REG_TYPE;

  regno = REGNO (reg);
  if (!HARD_REGISTER_NUM_P (regno))
    {
      if (!lra_in_progress && !reload_completed)
	return PSEUDO_REG_TYPE;

      regno = true_regnum (reg);
      if (regno < 0 || !HARD_REGISTER_NUM_P (regno))
	return PSEUDO_REG_TYPE;
    }

  gcc_assert (regno >= 0);

  if (is_altivec && ALTIVEC_REGNO_P (regno))
    *is_altivec = true;

  rclass = rs6000_regno_regclass[regno];
  return reg_class_to_reg_type[(int)rclass];
}

/* Helper function to return the cost of adding a TOC entry address.  */

static inline int
rs6000_secondary_reload_toc_costs (addr_mask_type addr_mask)
{
  int ret;

  if (TARGET_CMODEL != CMODEL_SMALL)
    ret = ((addr_mask & RELOAD_REG_OFFSET) == 0) ? 1 : 2;

  else
    ret = (TARGET_MINIMAL_TOC) ? 6 : 3;

  return ret;
}

/* Helper function for rs6000_secondary_reload to determine whether the memory
   address (ADDR) with a given register class (RCLASS) and machine mode (MODE)
   needs reloading.  Return negative if the memory is not handled by the memory
   helper functions and to try a different reload method, 0 if no additional
   instructions are need, and positive to give the extra cost for the
   memory.  */

static int
rs6000_secondary_reload_memory (rtx addr,
				enum reg_class rclass,
				machine_mode mode)
{
  int extra_cost = 0;
  rtx reg, and_arg, plus_arg0, plus_arg1;
  addr_mask_type addr_mask;
  const char *type = NULL;
  const char *fail_msg = NULL;

  if (GPR_REG_CLASS_P (rclass))
    addr_mask = reg_addr[mode].addr_mask[RELOAD_REG_GPR];

  else if (rclass == FLOAT_REGS)
    addr_mask = reg_addr[mode].addr_mask[RELOAD_REG_FPR];

  else if (rclass == ALTIVEC_REGS)
    addr_mask = reg_addr[mode].addr_mask[RELOAD_REG_VMX];

  /* For the combined VSX_REGS, turn off Altivec AND -16.  */
  else if (rclass == VSX_REGS)
    addr_mask = (reg_addr[mode].addr_mask[RELOAD_REG_VMX]
		 & ~RELOAD_REG_AND_M16);

  /* If the register allocator hasn't made up its mind yet on the register
     class to use, settle on defaults to use.  */
  else if (rclass == NO_REGS)
    {
      addr_mask = (reg_addr[mode].addr_mask[RELOAD_REG_ANY]
		   & ~RELOAD_REG_AND_M16);

      if ((addr_mask & RELOAD_REG_MULTIPLE) != 0)
	addr_mask &= ~(RELOAD_REG_INDEXED
		       | RELOAD_REG_PRE_INCDEC
		       | RELOAD_REG_PRE_MODIFY);
    }

  else
    addr_mask = 0;

  /* If the register isn't valid in this register class, just return now.  */
  if ((addr_mask & RELOAD_REG_VALID) == 0)
    {
      if (TARGET_DEBUG_ADDR)
	{
	  fprintf (stderr,
		   "rs6000_secondary_reload_memory: mode = %s, class = %s, "
		   "not valid in class\n",
		   GET_MODE_NAME (mode), reg_class_names[rclass]);
	  debug_rtx (addr);
	}

      return -1;
    }

  switch (GET_CODE (addr))
    {
      /* Does the register class supports auto update forms for this mode?  We
	 don't need a scratch register, since the powerpc only supports
	 PRE_INC, PRE_DEC, and PRE_MODIFY.  */
    case PRE_INC:
    case PRE_DEC:
      reg = XEXP (addr, 0);
      if (!base_reg_operand (addr, GET_MODE (reg)))
	{
	  fail_msg = "no base register #1";
	  extra_cost = -1;
	}

      else if ((addr_mask & RELOAD_REG_PRE_INCDEC) == 0)
	{
	  extra_cost = 1;
	  type = "update";
	}
      break;

    case PRE_MODIFY:
      reg = XEXP (addr, 0);
      plus_arg1 = XEXP (addr, 1);
      if (!base_reg_operand (reg, GET_MODE (reg))
	  || GET_CODE (plus_arg1) != PLUS
	  || !rtx_equal_p (reg, XEXP (plus_arg1, 0)))
	{
	  fail_msg = "bad PRE_MODIFY";
	  extra_cost = -1;
	}

      else if ((addr_mask & RELOAD_REG_PRE_MODIFY) == 0)
	{
	  extra_cost = 1;
	  type = "update";
	}
      break;

      /* Do we need to simulate AND -16 to clear the bottom address bits used
	 in VMX load/stores?  Only allow the AND for vector sizes.  */
    case AND:
      and_arg = XEXP (addr, 0);
      if (GET_MODE_SIZE (mode) != 16
	  || !CONST_INT_P (XEXP (addr, 1))
	  || INTVAL (XEXP (addr, 1)) != -16)
	{
	  fail_msg = "bad Altivec AND #1";
	  extra_cost = -1;
	}

      if (rclass != ALTIVEC_REGS)
	{
	  if (legitimate_indirect_address_p (and_arg, false))
	    extra_cost = 1;

	  else if (legitimate_indexed_address_p (and_arg, false))
	    extra_cost = 2;

	  else
	    {
	      fail_msg = "bad Altivec AND #2";
	      extra_cost = -1;
	    }

	  type = "and";
	}
      break;

      /* If this is an indirect address, make sure it is a base register.  */
    case REG:
    case SUBREG:
      if (!legitimate_indirect_address_p (addr, false))
	{
	  extra_cost = 1;
	  type = "move";
	}
      break;

      /* If this is an indexed address, make sure the register class can handle
	 indexed addresses for this mode.  */
    case PLUS:
      plus_arg0 = XEXP (addr, 0);
      plus_arg1 = XEXP (addr, 1);

      /* (plus (plus (reg) (constant)) (constant)) is generated during
	 push_reload processing, so handle it now.  */
      if (GET_CODE (plus_arg0) == PLUS && CONST_INT_P (plus_arg1))
	{
	  if ((addr_mask & RELOAD_REG_OFFSET) == 0)
	    {
	      extra_cost = 1;
	      type = "offset";
	    }
	}

      /* (plus (plus (reg) (constant)) (reg)) is also generated during
	 push_reload processing, so handle it now.  */
      else if (GET_CODE (plus_arg0) == PLUS && REG_P (plus_arg1))
	{
	  if ((addr_mask & RELOAD_REG_INDEXED) == 0)
	    {
	      extra_cost = 1;
	      type = "indexed #2";
	    }
	}

      else if (!base_reg_operand (plus_arg0, GET_MODE (plus_arg0)))
	{
	  fail_msg = "no base register #2";
	  extra_cost = -1;
	}

      else if (int_reg_operand (plus_arg1, GET_MODE (plus_arg1)))
	{
	  if ((addr_mask & RELOAD_REG_INDEXED) == 0
	      || !legitimate_indexed_address_p (addr, false))
	    {
	      extra_cost = 1;
	      type = "indexed";
	    }
	}

      else if ((addr_mask & RELOAD_REG_QUAD_OFFSET) != 0
	       && CONST_INT_P (plus_arg1))
	{
	  if (!quad_address_offset_p (INTVAL (plus_arg1)))
	    {
	      extra_cost = 1;
	      type = "vector d-form offset";
	    }
	}

      /* Make sure the register class can handle offset addresses.  */
      else if (rs6000_legitimate_offset_address_p (mode, addr, false, true))
	{
	  if ((addr_mask & RELOAD_REG_OFFSET) == 0)
	    {
	      extra_cost = 1;
	      type = "offset #2";
	    }
	}

      else
	{
	  fail_msg = "bad PLUS";
	  extra_cost = -1;
	}

      break;

    case LO_SUM:
      /* Quad offsets are restricted and can't handle normal addresses.  */
      if ((addr_mask & RELOAD_REG_QUAD_OFFSET) != 0)
	{
	  extra_cost = -1;
	  type = "vector d-form lo_sum";
	}

      else if (!legitimate_lo_sum_address_p (mode, addr, false))
	{
	  fail_msg = "bad LO_SUM";
	  extra_cost = -1;
	}

      if ((addr_mask & RELOAD_REG_OFFSET) == 0)
	{
	  extra_cost = 1;
	  type = "lo_sum";
	}
      break;

      /* Static addresses need to create a TOC entry.  */
    case CONST:
    case SYMBOL_REF:
    case LABEL_REF:
      if ((addr_mask & RELOAD_REG_QUAD_OFFSET) != 0)
	{
	  extra_cost = -1;
	  type = "vector d-form lo_sum #2";
	}

      else
	{
	  type = "address";
	  extra_cost = rs6000_secondary_reload_toc_costs (addr_mask);
	}
      break;

      /* TOC references look like offsetable memory.  */
    case UNSPEC:
      if (TARGET_CMODEL == CMODEL_SMALL || XINT (addr, 1) != UNSPEC_TOCREL)
	{
	  fail_msg = "bad UNSPEC";
	  extra_cost = -1;
	}

      else if ((addr_mask & RELOAD_REG_QUAD_OFFSET) != 0)
	{
	  extra_cost = -1;
	  type = "vector d-form lo_sum #3";
	}

      else if ((addr_mask & RELOAD_REG_OFFSET) == 0)
	{
	  extra_cost = 1;
	  type = "toc reference";
	}
      break;

    default:
	{
	  fail_msg = "bad address";
	  extra_cost = -1;
	}
    }

  if (TARGET_DEBUG_ADDR /* && extra_cost != 0 */)
    {
      if (extra_cost < 0)
	fprintf (stderr,
		 "rs6000_secondary_reload_memory error: mode = %s, "
		 "class = %s, addr_mask = '%s', %s\n",
		 GET_MODE_NAME (mode),
		 reg_class_names[rclass],
		 rs6000_debug_addr_mask (addr_mask, false),
		 (fail_msg != NULL) ? fail_msg : "<bad address>");

      else
	fprintf (stderr,
		 "rs6000_secondary_reload_memory: mode = %s, class = %s, "
		 "addr_mask = '%s', extra cost = %d, %s\n",
		 GET_MODE_NAME (mode),
		 reg_class_names[rclass],
		 rs6000_debug_addr_mask (addr_mask, false),
		 extra_cost,
		 (type) ? type : "<none>");

      debug_rtx (addr);
    }

  return extra_cost;
}

/* Helper function for rs6000_secondary_reload to return true if a move to a
   different register classe is really a simple move.  */

static bool
rs6000_secondary_reload_simple_move (enum rs6000_reg_type to_type,
				     enum rs6000_reg_type from_type,
				     machine_mode mode)
{
  int size = GET_MODE_SIZE (mode);

  /* Add support for various direct moves available.  In this function, we only
     look at cases where we don't need any extra registers, and one or more
     simple move insns are issued.  Originally small integers are not allowed
     in FPR/VSX registers.  Single precision binary floating is not a simple
     move because we need to convert to the single precision memory layout.
     The 4-byte SDmode can be moved.  TDmode values are disallowed since they
     need special direct move handling, which we do not support yet.  */
  if (TARGET_DIRECT_MOVE
      && ((to_type == GPR_REG_TYPE && from_type == VSX_REG_TYPE)
	  || (to_type == VSX_REG_TYPE && from_type == GPR_REG_TYPE)))
    {
      if (TARGET_POWERPC64)
	{
	  /* ISA 2.07: MTVSRD or MVFVSRD.  */
	  if (size == 8)
	    return true;

	  /* ISA 3.0: MTVSRDD or MFVSRD + MFVSRLD.  */
	  if (size == 16 && TARGET_P9_VECTOR && mode != TDmode)
	    return true;
	}

      /* ISA 2.07: MTVSRWZ or  MFVSRWZ.  */
      if (TARGET_P8_VECTOR)
	{
	  if (mode == SImode)
	    return true;

	  if (TARGET_P9_VECTOR && (mode == HImode || mode == QImode))
	    return true;
	}

      /* ISA 2.07: MTVSRWZ or  MFVSRWZ.  */
      if (mode == SDmode)
	return true;
    }

  /* Move to/from SPR.  */
  else if ((size == 4 || (TARGET_POWERPC64 && size == 8))
	   && ((to_type == GPR_REG_TYPE && from_type == SPR_REG_TYPE)
	       || (to_type == SPR_REG_TYPE && from_type == GPR_REG_TYPE)))
    return true;

  return false;
}

/* Direct move helper function for rs6000_secondary_reload, handle all of the
   special direct moves that involve allocating an extra register, return the
   insn code of the helper function if there is such a function or
   CODE_FOR_nothing if not.  */

static bool
rs6000_secondary_reload_direct_move (enum rs6000_reg_type to_type,
				     enum rs6000_reg_type from_type,
				     machine_mode mode,
				     secondary_reload_info *sri,
				     bool altivec_p)
{
  bool ret = false;
  enum insn_code icode = CODE_FOR_nothing;
  int cost = 0;
  int size = GET_MODE_SIZE (mode);

  if (TARGET_POWERPC64 && size == 16)
    {
      /* Handle moving 128-bit values from GPRs to VSX point registers on
	 ISA 2.07 (power8, power9) when running in 64-bit mode using
	 XXPERMDI to glue the two 64-bit values back together.  */
      if (to_type == VSX_REG_TYPE && from_type == GPR_REG_TYPE)
	{
	  cost = 3;			/* 2 mtvsrd's, 1 xxpermdi.  */
	  icode = reg_addr[mode].reload_vsx_gpr;
	}

      /* Handle moving 128-bit values from VSX point registers to GPRs on
	 ISA 2.07 when running in 64-bit mode using XXPERMDI to get access to the
	 bottom 64-bit value.  */
      else if (to_type == GPR_REG_TYPE && from_type == VSX_REG_TYPE)
	{
	  cost = 3;			/* 2 mfvsrd's, 1 xxpermdi.  */
	  icode = reg_addr[mode].reload_gpr_vsx;
	}
    }

  else if (TARGET_POWERPC64 && mode == SFmode)
    {
      if (to_type == GPR_REG_TYPE && from_type == VSX_REG_TYPE)
	{
	  cost = 3;			/* xscvdpspn, mfvsrd, and.  */
	  icode = reg_addr[mode].reload_gpr_vsx;
	}

      else if (to_type == VSX_REG_TYPE && from_type == GPR_REG_TYPE)
	{
	  cost = 2;			/* mtvsrz, xscvspdpn.  */
	  icode = reg_addr[mode].reload_vsx_gpr;
	}
    }

  else if (!TARGET_POWERPC64 && size == 8)
    {
      /* Handle moving 64-bit values from GPRs to floating point registers on
	 ISA 2.07 when running in 32-bit mode using FMRGOW to glue the two
	 32-bit values back together.  Altivec register classes must be handled
	 specially since a different instruction is used, and the secondary
	 reload support requires a single instruction class in the scratch
	 register constraint.  However, right now TFmode is not allowed in
	 Altivec registers, so the pattern will never match.  */
      if (to_type == VSX_REG_TYPE && from_type == GPR_REG_TYPE && !altivec_p)
	{
	  cost = 3;			/* 2 mtvsrwz's, 1 fmrgow.  */
	  icode = reg_addr[mode].reload_fpr_gpr;
	}
    }

  if (icode != CODE_FOR_nothing)
    {
      ret = true;
      if (sri)
	{
	  sri->icode = icode;
	  sri->extra_cost = cost;
	}
    }

  return ret;
}

/* Return whether a move between two register classes can be done either
   directly (simple move) or via a pattern that uses a single extra temporary
   (using ISA 2.07's direct move in this case.  */

static bool
rs6000_secondary_reload_move (enum rs6000_reg_type to_type,
			      enum rs6000_reg_type from_type,
			      machine_mode mode,
			      secondary_reload_info *sri,
			      bool altivec_p)
{
  /* Fall back to load/store reloads if either type is not a register.  */
  if (to_type == NO_REG_TYPE || from_type == NO_REG_TYPE)
    return false;

  /* If we haven't allocated registers yet, assume the move can be done for the
     standard register types.  */
  if ((to_type == PSEUDO_REG_TYPE && from_type == PSEUDO_REG_TYPE)
      || (to_type == PSEUDO_REG_TYPE && IS_STD_REG_TYPE (from_type))
      || (from_type == PSEUDO_REG_TYPE && IS_STD_REG_TYPE (to_type)))
    return true;

  /* Moves to the same set of registers is a simple move for non-specialized
     registers.  */
  if (to_type == from_type && IS_STD_REG_TYPE (to_type))
    return true;

  /* Check whether a simple move can be done directly.  */
  if (rs6000_secondary_reload_simple_move (to_type, from_type, mode))
    {
      if (sri)
	{
	  sri->icode = CODE_FOR_nothing;
	  sri->extra_cost = 0;
	}
      return true;
    }

  /* Now check if we can do it in a few steps.  */
  return rs6000_secondary_reload_direct_move (to_type, from_type, mode, sri,
					      altivec_p);
}

/* Inform reload about cases where moving X with a mode MODE to a register in
   RCLASS requires an extra scratch or immediate register.  Return the class
   needed for the immediate register.

   For VSX and Altivec, we may need a register to convert sp+offset into
   reg+sp.

   For misaligned 64-bit gpr loads and stores we need a register to
   convert an offset address to indirect.  */

static reg_class_t
rs6000_secondary_reload (bool in_p,
			 rtx x,
			 reg_class_t rclass_i,
			 machine_mode mode,
			 secondary_reload_info *sri)
{
  enum reg_class rclass = (enum reg_class) rclass_i;
  reg_class_t ret = ALL_REGS;
  enum insn_code icode;
  bool default_p = false;
  bool done_p = false;

  /* Allow subreg of memory before/during reload.  */
  bool memory_p = (MEM_P (x)
		   || (!reload_completed && SUBREG_P (x)
		       && MEM_P (SUBREG_REG (x))));

  sri->icode = CODE_FOR_nothing;
  sri->t_icode = CODE_FOR_nothing;
  sri->extra_cost = 0;
  icode = ((in_p)
	   ? reg_addr[mode].reload_load
	   : reg_addr[mode].reload_store);

  if (REG_P (x) || register_operand (x, mode))
    {
      enum rs6000_reg_type to_type = reg_class_to_reg_type[(int)rclass];
      bool altivec_p = (rclass == ALTIVEC_REGS);
      enum rs6000_reg_type from_type = register_to_reg_type (x, &altivec_p);

      if (!in_p)
	std::swap (to_type, from_type);

      /* Can we do a direct move of some sort?  */
      if (rs6000_secondary_reload_move (to_type, from_type, mode, sri,
					altivec_p))
	{
	  icode = (enum insn_code)sri->icode;
	  default_p = false;
	  done_p = true;
	  ret = NO_REGS;
	}
    }

  /* Make sure 0.0 is not reloaded or forced into memory.  */
  if (x == CONST0_RTX (mode) && VSX_REG_CLASS_P (rclass))
    {
      ret = NO_REGS;
      default_p = false;
      done_p = true;
    }

  /* If this is a scalar floating point value and we want to load it into the
     traditional Altivec registers, do it via a move via a traditional floating
     point register, unless we have D-form addressing.  Also make sure that
     non-zero constants use a FPR.  */
  if (!done_p && reg_addr[mode].scalar_in_vmx_p
      && !mode_supports_vmx_dform (mode)
      && (rclass == VSX_REGS || rclass == ALTIVEC_REGS)
      && (memory_p || CONST_DOUBLE_P (x)))
    {
      ret = FLOAT_REGS;
      default_p = false;
      done_p = true;
    }

  /* Handle reload of load/stores if we have reload helper functions.  */
  if (!done_p && icode != CODE_FOR_nothing && memory_p)
    {
      int extra_cost = rs6000_secondary_reload_memory (XEXP (x, 0), rclass,
						       mode);

      if (extra_cost >= 0)
	{
	  done_p = true;
	  ret = NO_REGS;
	  if (extra_cost > 0)
	    {
	      sri->extra_cost = extra_cost;
	      sri->icode = icode;
	    }
	}
    }

  /* Handle unaligned loads and stores of integer registers.  */
  if (!done_p && TARGET_POWERPC64
      && reg_class_to_reg_type[(int)rclass] == GPR_REG_TYPE
      && memory_p
      && GET_MODE_SIZE (GET_MODE (x)) >= UNITS_PER_WORD)
    {
      rtx addr = XEXP (x, 0);
      rtx off = address_offset (addr);

      if (off != NULL_RTX)
	{
	  unsigned int extra = GET_MODE_SIZE (GET_MODE (x)) - UNITS_PER_WORD;
	  unsigned HOST_WIDE_INT offset = INTVAL (off);

	  /* We need a secondary reload when our legitimate_address_p
	     says the address is good (as otherwise the entire address
	     will be reloaded), and the offset is not a multiple of
	     four or we have an address wrap.  Address wrap will only
	     occur for LO_SUMs since legitimate_offset_address_p
	     rejects addresses for 16-byte mems that will wrap.  */
	  if (GET_CODE (addr) == LO_SUM
	      ? (1 /* legitimate_address_p allows any offset for lo_sum */
		 && ((offset & 3) != 0
		     || ((offset & 0xffff) ^ 0x8000) >= 0x10000 - extra))
	      : (offset + 0x8000 < 0x10000 - extra /* legitimate_address_p */
		 && (offset & 3) != 0))
	    {
	      /* -m32 -mpowerpc64 needs to use a 32-bit scratch register.  */
	      if (in_p)
		sri->icode = ((TARGET_32BIT) ? CODE_FOR_reload_si_load
			      : CODE_FOR_reload_di_load);
	      else
		sri->icode = ((TARGET_32BIT) ? CODE_FOR_reload_si_store
			      : CODE_FOR_reload_di_store);
	      sri->extra_cost = 2;
	      ret = NO_REGS;
	      done_p = true;
	    }
	  else
	    default_p = true;
	}
      else
	default_p = true;
    }

  if (!done_p && !TARGET_POWERPC64
      && reg_class_to_reg_type[(int)rclass] == GPR_REG_TYPE
      && memory_p
      && GET_MODE_SIZE (GET_MODE (x)) > UNITS_PER_WORD)
    {
      rtx addr = XEXP (x, 0);
      rtx off = address_offset (addr);

      if (off != NULL_RTX)
	{
	  unsigned int extra = GET_MODE_SIZE (GET_MODE (x)) - UNITS_PER_WORD;
	  unsigned HOST_WIDE_INT offset = INTVAL (off);

	  /* We need a secondary reload when our legitimate_address_p
	     says the address is good (as otherwise the entire address
	     will be reloaded), and we have a wrap.

	     legitimate_lo_sum_address_p allows LO_SUM addresses to
	     have any offset so test for wrap in the low 16 bits.

	     legitimate_offset_address_p checks for the range
	     [-0x8000,0x7fff] for mode size of 8 and [-0x8000,0x7ff7]
	     for mode size of 16.  We wrap at [0x7ffc,0x7fff] and
	     [0x7ff4,0x7fff] respectively, so test for the
	     intersection of these ranges, [0x7ffc,0x7fff] and
	     [0x7ff4,0x7ff7] respectively.

	     Note that the address we see here may have been
	     manipulated by legitimize_reload_address.  */
	  if (GET_CODE (addr) == LO_SUM
	      ? ((offset & 0xffff) ^ 0x8000) >= 0x10000 - extra
	      : offset - (0x8000 - extra) < UNITS_PER_WORD)
	    {
	      if (in_p)
		sri->icode = CODE_FOR_reload_si_load;
	      else
		sri->icode = CODE_FOR_reload_si_store;
	      sri->extra_cost = 2;
	      ret = NO_REGS;
	      done_p = true;
	    }
	  else
	    default_p = true;
	}
      else
	default_p = true;
    }

  if (!done_p)
    default_p = true;

  if (default_p)
    ret = default_secondary_reload (in_p, x, rclass, mode, sri);

  gcc_assert (ret != ALL_REGS);

  if (TARGET_DEBUG_ADDR)
    {
      fprintf (stderr,
	       "\nrs6000_secondary_reload, return %s, in_p = %s, rclass = %s, "
	       "mode = %s",
	       reg_class_names[ret],
	       in_p ? "true" : "false",
	       reg_class_names[rclass],
	       GET_MODE_NAME (mode));

      if (reload_completed)
	fputs (", after reload", stderr);

      if (!done_p)
	fputs (", done_p not set", stderr);

      if (default_p)
	fputs (", default secondary reload", stderr);

      if (sri->icode != CODE_FOR_nothing)
	fprintf (stderr, ", reload func = %s, extra cost = %d",
		 insn_data[sri->icode].name, sri->extra_cost);

      else if (sri->extra_cost > 0)
	fprintf (stderr, ", extra cost = %d", sri->extra_cost);

      fputs ("\n", stderr);
      debug_rtx (x);
    }

  return ret;
}

/* Better tracing for rs6000_secondary_reload_inner.  */

static void
rs6000_secondary_reload_trace (int line, rtx reg, rtx mem, rtx scratch,
			       bool store_p)
{
  rtx set, clobber;

  gcc_assert (reg != NULL_RTX && mem != NULL_RTX && scratch != NULL_RTX);

  fprintf (stderr, "rs6000_secondary_reload_inner:%d, type = %s\n", line,
	   store_p ? "store" : "load");

  if (store_p)
    set = gen_rtx_SET (mem, reg);
  else
    set = gen_rtx_SET (reg, mem);

  clobber = gen_rtx_CLOBBER (VOIDmode, scratch);
  debug_rtx (gen_rtx_PARALLEL (VOIDmode, gen_rtvec (2, set, clobber)));
}

static void rs6000_secondary_reload_fail (int, rtx, rtx, rtx, bool)
  ATTRIBUTE_NORETURN;

static void
rs6000_secondary_reload_fail (int line, rtx reg, rtx mem, rtx scratch,
			      bool store_p)
{
  rs6000_secondary_reload_trace (line, reg, mem, scratch, store_p);
  gcc_unreachable ();
}

/* Fixup reload addresses for values in GPR, FPR, and VMX registers that have
   reload helper functions.  These were identified in
   rs6000_secondary_reload_memory, and if reload decided to use the secondary
   reload, it calls the insns:
	reload_<RELOAD:mode>_<P:mptrsize>_store
	reload_<RELOAD:mode>_<P:mptrsize>_load

   which in turn calls this function, to do whatever is necessary to create
   valid addresses.  */

void
rs6000_secondary_reload_inner (rtx reg, rtx mem, rtx scratch, bool store_p)
{
  int regno = true_regnum (reg);
  machine_mode mode = GET_MODE (reg);
  addr_mask_type addr_mask;
  rtx addr;
  rtx new_addr;
  rtx op_reg, op0, op1;
  rtx and_op;
  rtx cc_clobber;
  rtvec rv;

  if (regno < 0 || !HARD_REGISTER_NUM_P (regno) || !MEM_P (mem)
      || !base_reg_operand (scratch, GET_MODE (scratch)))
    rs6000_secondary_reload_fail (__LINE__, reg, mem, scratch, store_p);

  if (IN_RANGE (regno, FIRST_GPR_REGNO, LAST_GPR_REGNO))
    addr_mask = reg_addr[mode].addr_mask[RELOAD_REG_GPR];

  else if (IN_RANGE (regno, FIRST_FPR_REGNO, LAST_FPR_REGNO))
    addr_mask = reg_addr[mode].addr_mask[RELOAD_REG_FPR];

  else if (IN_RANGE (regno, FIRST_ALTIVEC_REGNO, LAST_ALTIVEC_REGNO))
    addr_mask = reg_addr[mode].addr_mask[RELOAD_REG_VMX];

  else
    rs6000_secondary_reload_fail (__LINE__, reg, mem, scratch, store_p);

  /* Make sure the mode is valid in this register class.  */
  if ((addr_mask & RELOAD_REG_VALID) == 0)
    rs6000_secondary_reload_fail (__LINE__, reg, mem, scratch, store_p);

  if (TARGET_DEBUG_ADDR)
    rs6000_secondary_reload_trace (__LINE__, reg, mem, scratch, store_p);

  new_addr = addr = XEXP (mem, 0);
  switch (GET_CODE (addr))
    {
      /* Does the register class support auto update forms for this mode?  If
	 not, do the update now.  We don't need a scratch register, since the
	 powerpc only supports PRE_INC, PRE_DEC, and PRE_MODIFY.  */
    case PRE_INC:
    case PRE_DEC:
      op_reg = XEXP (addr, 0);
      if (!base_reg_operand (op_reg, Pmode))
	rs6000_secondary_reload_fail (__LINE__, reg, mem, scratch, store_p);

      if ((addr_mask & RELOAD_REG_PRE_INCDEC) == 0)
	{
	  int delta = GET_MODE_SIZE (mode);
	  if (GET_CODE (addr) == PRE_DEC)
	    delta = -delta;
	  emit_insn (gen_add2_insn (op_reg, GEN_INT (delta)));
	  new_addr = op_reg;
	}
      break;

    case PRE_MODIFY:
      op0 = XEXP (addr, 0);
      op1 = XEXP (addr, 1);
      if (!base_reg_operand (op0, Pmode)
	  || GET_CODE (op1) != PLUS
	  || !rtx_equal_p (op0, XEXP (op1, 0)))
	rs6000_secondary_reload_fail (__LINE__, reg, mem, scratch, store_p);

      if ((addr_mask & RELOAD_REG_PRE_MODIFY) == 0)
	{
	  emit_insn (gen_rtx_SET (op0, op1));
	  new_addr = reg;
	}
      break;

      /* Do we need to simulate AND -16 to clear the bottom address bits used
	 in VMX load/stores?  */
    case AND:
      op0 = XEXP (addr, 0);
      op1 = XEXP (addr, 1);
      if ((addr_mask & RELOAD_REG_AND_M16) == 0)
	{
	  if (REG_P (op0) || SUBREG_P (op0))
	    op_reg = op0;

	  else if (GET_CODE (op1) == PLUS)
	    {
	      emit_insn (gen_rtx_SET (scratch, op1));
	      op_reg = scratch;
	    }

	  else
	    rs6000_secondary_reload_fail (__LINE__, reg, mem, scratch, store_p);

	  and_op = gen_rtx_AND (GET_MODE (scratch), op_reg, op1);
	  cc_clobber = gen_rtx_CLOBBER (VOIDmode, gen_rtx_SCRATCH (CCmode));
	  rv = gen_rtvec (2, gen_rtx_SET (scratch, and_op), cc_clobber);
	  emit_insn (gen_rtx_PARALLEL (VOIDmode, rv));
	  new_addr = scratch;
	}
      break;

      /* If this is an indirect address, make sure it is a base register.  */
    case REG:
    case SUBREG:
      if (!base_reg_operand (addr, GET_MODE (addr)))
	{
	  emit_insn (gen_rtx_SET (scratch, addr));
	  new_addr = scratch;
	}
      break;

      /* If this is an indexed address, make sure the register class can handle
	 indexed addresses for this mode.  */
    case PLUS:
      op0 = XEXP (addr, 0);
      op1 = XEXP (addr, 1);
      if (!base_reg_operand (op0, Pmode))
	rs6000_secondary_reload_fail (__LINE__, reg, mem, scratch, store_p);

      else if (int_reg_operand (op1, Pmode))
	{
	  if ((addr_mask & RELOAD_REG_INDEXED) == 0)
	    {
	      emit_insn (gen_rtx_SET (scratch, addr));
	      new_addr = scratch;
	    }
	}

      else if (mode_supports_dq_form (mode) && CONST_INT_P (op1))
	{
	  if (((addr_mask & RELOAD_REG_QUAD_OFFSET) == 0)
	      || !quad_address_p (addr, mode, false))
	    {
	      emit_insn (gen_rtx_SET (scratch, addr));
	      new_addr = scratch;
	    }
	}

      /* Make sure the register class can handle offset addresses.  */
      else if (rs6000_legitimate_offset_address_p (mode, addr, false, true))
	{
	  if ((addr_mask & RELOAD_REG_OFFSET) == 0)
	    {
	      emit_insn (gen_rtx_SET (scratch, addr));
	      new_addr = scratch;
	    }
	}

      else
	rs6000_secondary_reload_fail (__LINE__, reg, mem, scratch, store_p);

      break;

    case LO_SUM:
      op0 = XEXP (addr, 0);
      op1 = XEXP (addr, 1);
      if (!base_reg_operand (op0, Pmode))
	rs6000_secondary_reload_fail (__LINE__, reg, mem, scratch, store_p);

      else if (int_reg_operand (op1, Pmode))
	{
	  if ((addr_mask & RELOAD_REG_INDEXED) == 0)
	    {
	      emit_insn (gen_rtx_SET (scratch, addr));
	      new_addr = scratch;
	    }
	}

      /* Quad offsets are restricted and can't handle normal addresses.  */
      else if (mode_supports_dq_form (mode))
	{
	  emit_insn (gen_rtx_SET (scratch, addr));
	  new_addr = scratch;
	}

      /* Make sure the register class can handle offset addresses.  */
      else if (legitimate_lo_sum_address_p (mode, addr, false))
	{
	  if ((addr_mask & RELOAD_REG_OFFSET) == 0)
	    {
	      emit_insn (gen_rtx_SET (scratch, addr));
	      new_addr = scratch;
	    }
	}

      else
	rs6000_secondary_reload_fail (__LINE__, reg, mem, scratch, store_p);

      break;

    case SYMBOL_REF:
    case CONST:
    case LABEL_REF:
      rs6000_emit_move (scratch, addr, Pmode);
      new_addr = scratch;
      break;

    default:
      rs6000_secondary_reload_fail (__LINE__, reg, mem, scratch, store_p);
    }

  /* Adjust the address if it changed.  */
  if (addr != new_addr)
    {
      mem = replace_equiv_address_nv (mem, new_addr);
      if (TARGET_DEBUG_ADDR)
	fprintf (stderr, "\nrs6000_secondary_reload_inner, mem adjusted.\n");
    }

  /* Now create the move.  */
  if (store_p)
    emit_insn (gen_rtx_SET (mem, reg));
  else
    emit_insn (gen_rtx_SET (reg, mem));

  return;
}

/* Convert reloads involving 64-bit gprs and misaligned offset
   addressing, or multiple 32-bit gprs and offsets that are too large,
   to use indirect addressing.  */

void
rs6000_secondary_reload_gpr (rtx reg, rtx mem, rtx scratch, bool store_p)
{
  int regno = true_regnum (reg);
  enum reg_class rclass;
  rtx addr;
  rtx scratch_or_premodify = scratch;

  if (TARGET_DEBUG_ADDR)
    {
      fprintf (stderr, "\nrs6000_secondary_reload_gpr, type = %s\n",
	       store_p ? "store" : "load");
      fprintf (stderr, "reg:\n");
      debug_rtx (reg);
      fprintf (stderr, "mem:\n");
      debug_rtx (mem);
      fprintf (stderr, "scratch:\n");
      debug_rtx (scratch);
    }

  gcc_assert (regno >= 0 && HARD_REGISTER_NUM_P (regno));
  gcc_assert (MEM_P (mem));
  rclass = REGNO_REG_CLASS (regno);
  gcc_assert (rclass == GENERAL_REGS || rclass == BASE_REGS);
  addr = XEXP (mem, 0);

  if (GET_CODE (addr) == PRE_MODIFY)
    {
      gcc_assert (REG_P (XEXP (addr, 0))
		  && GET_CODE (XEXP (addr, 1)) == PLUS
		  && XEXP (XEXP (addr, 1), 0) == XEXP (addr, 0));
      scratch_or_premodify = XEXP (addr, 0);
      addr = XEXP (addr, 1);
    }
  gcc_assert (GET_CODE (addr) == PLUS || GET_CODE (addr) == LO_SUM);

  rs6000_emit_move (scratch_or_premodify, addr, Pmode);

  mem = replace_equiv_address_nv (mem, scratch_or_premodify);

  /* Now create the move.  */
  if (store_p)
    emit_insn (gen_rtx_SET (mem, reg));
  else
    emit_insn (gen_rtx_SET (reg, mem));

  return;
}

/* Given an rtx X being reloaded into a reg required to be
   in class CLASS, return the class of reg to actually use.
   In general this is just CLASS; but on some machines
   in some cases it is preferable to use a more restrictive class.

   On the RS/6000, we have to return NO_REGS when we want to reload a
   floating-point CONST_DOUBLE to force it to be copied to memory.

   We also don't want to reload integer values into floating-point
   registers if we can at all help it.  In fact, this can
   cause reload to die, if it tries to generate a reload of CTR
   into a FP register and discovers it doesn't have the memory location
   required.

   ??? Would it be a good idea to have reload do the converse, that is
   try to reload floating modes into FP registers if possible?
 */

static enum reg_class
rs6000_preferred_reload_class (rtx x, enum reg_class rclass)
{
  machine_mode mode = GET_MODE (x);
  bool is_constant = CONSTANT_P (x);

  /* If a mode can't go in FPR/ALTIVEC/VSX registers, don't return a preferred
     reload class for it.  */
  if ((rclass == ALTIVEC_REGS || rclass == VSX_REGS)
      && (reg_addr[mode].addr_mask[RELOAD_REG_VMX] & RELOAD_REG_VALID) == 0)
    return NO_REGS;

  if ((rclass == FLOAT_REGS || rclass == VSX_REGS)
      && (reg_addr[mode].addr_mask[RELOAD_REG_FPR] & RELOAD_REG_VALID) == 0)
    return NO_REGS;

  /* For VSX, see if we should prefer FLOAT_REGS or ALTIVEC_REGS.  Do not allow
     the reloading of address expressions using PLUS into floating point
     registers.  */
  if (TARGET_VSX && VSX_REG_CLASS_P (rclass) && GET_CODE (x) != PLUS)
    {
      if (is_constant)
	{
	  /* Zero is always allowed in all VSX registers.  */
	  if (x == CONST0_RTX (mode))
	    return rclass;

	  /* If this is a vector constant that can be formed with a few Altivec
	     instructions, we want altivec registers.  */
	  if (GET_CODE (x) == CONST_VECTOR && easy_vector_constant (x, mode))
	    return ALTIVEC_REGS;

	  /* If this is an integer constant that can easily be loaded into
	     vector registers, allow it.  */
	  if (CONST_INT_P (x))
	    {
	      HOST_WIDE_INT value = INTVAL (x);

	      /* ISA 2.07 can generate -1 in all registers with XXLORC.  ISA
		 2.06 can generate it in the Altivec registers with
		 VSPLTI<x>.  */
	      if (value == -1)
		{
		  if (TARGET_P8_VECTOR)
		    return rclass;
		  else if (rclass == ALTIVEC_REGS || rclass == VSX_REGS)
		    return ALTIVEC_REGS;
		  else
		    return NO_REGS;
		}

	      /* ISA 3.0 can load -128..127 using the XXSPLTIB instruction and
		 a sign extend in the Altivec registers.  */
	      if (IN_RANGE (value, -128, 127) && TARGET_P9_VECTOR
		  && (rclass == ALTIVEC_REGS || rclass == VSX_REGS))
		return ALTIVEC_REGS;
	    }

	  /* Force constant to memory.  */
	  return NO_REGS;
	}

      /* D-form addressing can easily reload the value.  */
      if (mode_supports_vmx_dform (mode)
	  || mode_supports_dq_form (mode))
	return rclass;

      /* If this is a scalar floating point value and we don't have D-form
	 addressing, prefer the traditional floating point registers so that we
	 can use D-form (register+offset) addressing.  */
      if (rclass == VSX_REGS
	  && (mode == SFmode || GET_MODE_SIZE (mode) == 8))
	return FLOAT_REGS;

      /* Prefer the Altivec registers if Altivec is handling the vector
	 operations (i.e. V16QI, V8HI, and V4SI), or if we prefer Altivec
	 loads.  */
      if (VECTOR_UNIT_ALTIVEC_P (mode) || VECTOR_MEM_ALTIVEC_P (mode)
	  || mode == V1TImode)
	return ALTIVEC_REGS;

      return rclass;
    }

  if (is_constant || GET_CODE (x) == PLUS)
    {
      if (reg_class_subset_p (GENERAL_REGS, rclass))
	return GENERAL_REGS;
      if (reg_class_subset_p (BASE_REGS, rclass))
	return BASE_REGS;
      return NO_REGS;
    }

  if (GET_MODE_CLASS (mode) == MODE_INT && rclass == GEN_OR_FLOAT_REGS)
    return GENERAL_REGS;

  return rclass;
}

/* Debug version of rs6000_preferred_reload_class.  */
static enum reg_class
rs6000_debug_preferred_reload_class (rtx x, enum reg_class rclass)
{
  enum reg_class ret = rs6000_preferred_reload_class (x, rclass);

  fprintf (stderr,
	   "\nrs6000_preferred_reload_class, return %s, rclass = %s, "
	   "mode = %s, x:\n",
	   reg_class_names[ret], reg_class_names[rclass],
	   GET_MODE_NAME (GET_MODE (x)));
  debug_rtx (x);

  return ret;
}

/* If we are copying between FP or AltiVec registers and anything else, we need
   a memory location.  The exception is when we are targeting ppc64 and the
   move to/from fpr to gpr instructions are available.  Also, under VSX, you
   can copy vector registers from the FP register set to the Altivec register
   set and vice versa.  */

static bool
rs6000_secondary_memory_needed (machine_mode mode,
				reg_class_t from_class,
				reg_class_t to_class)
{
  enum rs6000_reg_type from_type, to_type;
  bool altivec_p = ((from_class == ALTIVEC_REGS)
		    || (to_class == ALTIVEC_REGS));

  /* If a simple/direct move is available, we don't need secondary memory  */
  from_type = reg_class_to_reg_type[(int)from_class];
  to_type = reg_class_to_reg_type[(int)to_class];

  if (rs6000_secondary_reload_move (to_type, from_type, mode,
				    (secondary_reload_info *)0, altivec_p))
    return false;

  /* If we have a floating point or vector register class, we need to use
     memory to transfer the data.  */
  if (IS_FP_VECT_REG_TYPE (from_type) || IS_FP_VECT_REG_TYPE (to_type))
    return true;

  return false;
}

/* Debug version of rs6000_secondary_memory_needed.  */
static bool
rs6000_debug_secondary_memory_needed (machine_mode mode,
				      reg_class_t from_class,
				      reg_class_t to_class)
{
  bool ret = rs6000_secondary_memory_needed (mode, from_class, to_class);

  fprintf (stderr,
	   "rs6000_secondary_memory_needed, return: %s, from_class = %s, "
	   "to_class = %s, mode = %s\n",
	   ret ? "true" : "false",
	   reg_class_names[from_class],
	   reg_class_names[to_class],
	   GET_MODE_NAME (mode));

  return ret;
}

/* Return the register class of a scratch register needed to copy IN into
   or out of a register in RCLASS in MODE.  If it can be done directly,
   NO_REGS is returned.  */

static enum reg_class
rs6000_secondary_reload_class (enum reg_class rclass, machine_mode mode,
			       rtx in)
{
  int regno;

  if (TARGET_ELF || (DEFAULT_ABI == ABI_DARWIN
#if TARGET_MACHO
		     && MACHOPIC_INDIRECT
#endif
		     ))
    {
      /* We cannot copy a symbolic operand directly into anything
	 other than BASE_REGS for TARGET_ELF.  So indicate that a
	 register from BASE_REGS is needed as an intermediate
	 register.

	 On Darwin, pic addresses require a load from memory, which
	 needs a base register.  */
      if (rclass != BASE_REGS
	  && (SYMBOL_REF_P (in)
	      || GET_CODE (in) == HIGH
	      || GET_CODE (in) == LABEL_REF
	      || GET_CODE (in) == CONST))
	return BASE_REGS;
    }

  if (REG_P (in))
    {
      regno = REGNO (in);
      if (!HARD_REGISTER_NUM_P (regno))
	{
	  regno = true_regnum (in);
	  if (!HARD_REGISTER_NUM_P (regno))
	    regno = -1;
	}
    }
  else if (SUBREG_P (in))
    {
      regno = true_regnum (in);
      if (!HARD_REGISTER_NUM_P (regno))
	regno = -1;
    }
  else
    regno = -1;

  /* If we have VSX register moves, prefer moving scalar values between
     Altivec registers and GPR by going via an FPR (and then via memory)
     instead of reloading the secondary memory address for Altivec moves.  */
  if (TARGET_VSX
      && GET_MODE_SIZE (mode) < 16
      && !mode_supports_vmx_dform (mode)
      && (((rclass == GENERAL_REGS || rclass == BASE_REGS)
           && (regno >= 0 && ALTIVEC_REGNO_P (regno)))
          || ((rclass == VSX_REGS || rclass == ALTIVEC_REGS)
              && (regno >= 0 && INT_REGNO_P (regno)))))
    return FLOAT_REGS;

  /* We can place anything into GENERAL_REGS and can put GENERAL_REGS
     into anything.  */
  if (rclass == GENERAL_REGS || rclass == BASE_REGS
      || (regno >= 0 && INT_REGNO_P (regno)))
    return NO_REGS;

  /* Constants, memory, and VSX registers can go into VSX registers (both the
     traditional floating point and the altivec registers).  */
  if (rclass == VSX_REGS
      && (regno == -1 || VSX_REGNO_P (regno)))
    return NO_REGS;

  /* Constants, memory, and FP registers can go into FP registers.  */
  if ((regno == -1 || FP_REGNO_P (regno))
      && (rclass == FLOAT_REGS || rclass == GEN_OR_FLOAT_REGS))
    return (mode != SDmode || lra_in_progress) ? NO_REGS : GENERAL_REGS;

  /* Memory, and AltiVec registers can go into AltiVec registers.  */
  if ((regno == -1 || ALTIVEC_REGNO_P (regno))
      && rclass == ALTIVEC_REGS)
    return NO_REGS;

  /* We can copy among the CR registers.  */
  if ((rclass == CR_REGS || rclass == CR0_REGS)
      && regno >= 0 && CR_REGNO_P (regno))
    return NO_REGS;

  /* Otherwise, we need GENERAL_REGS.  */
  return GENERAL_REGS;
}

/* Debug version of rs6000_secondary_reload_class.  */
static enum reg_class
rs6000_debug_secondary_reload_class (enum reg_class rclass,
				     machine_mode mode, rtx in)
{
  enum reg_class ret = rs6000_secondary_reload_class (rclass, mode, in);
  fprintf (stderr,
	   "\nrs6000_secondary_reload_class, return %s, rclass = %s, "
	   "mode = %s, input rtx:\n",
	   reg_class_names[ret], reg_class_names[rclass],
	   GET_MODE_NAME (mode));
  debug_rtx (in);

  return ret;
}

/* Implement TARGET_CAN_CHANGE_MODE_CLASS.  */

static bool
rs6000_can_change_mode_class (machine_mode from,
			      machine_mode to,
			      reg_class_t rclass)
{
  unsigned from_size = GET_MODE_SIZE (from);
  unsigned to_size = GET_MODE_SIZE (to);

  if (from_size != to_size)
    {
      enum reg_class xclass = (TARGET_VSX) ? VSX_REGS : FLOAT_REGS;

      if (reg_classes_intersect_p (xclass, rclass))
	{
	  unsigned to_nregs = hard_regno_nregs (FIRST_FPR_REGNO, to);
	  unsigned from_nregs = hard_regno_nregs (FIRST_FPR_REGNO, from);
	  bool to_float128_vector_p = FLOAT128_VECTOR_P (to);
	  bool from_float128_vector_p = FLOAT128_VECTOR_P (from);

	  /* Don't allow 64-bit types to overlap with 128-bit types that take a
	     single register under VSX because the scalar part of the register
	     is in the upper 64-bits, and not the lower 64-bits.  Types like
	     TFmode/TDmode that take 2 scalar register can overlap.  128-bit
	     IEEE floating point can't overlap, and neither can small
	     values.  */

	  if (to_float128_vector_p && from_float128_vector_p)
	    return true;

	  else if (to_float128_vector_p || from_float128_vector_p)
	    return false;

	  /* TDmode in floating-mode registers must always go into a register
	     pair with the most significant word in the even-numbered register
	     to match ISA requirements.  In little-endian mode, this does not
	     match subreg numbering, so we cannot allow subregs.  */
	  if (!BYTES_BIG_ENDIAN && (to == TDmode || from == TDmode))
	    return false;

	  if (from_size < 8 || to_size < 8)
	    return false;

	  if (from_size == 8 && (8 * to_nregs) != to_size)
	    return false;

	  if (to_size == 8 && (8 * from_nregs) != from_size)
	    return false;

	  return true;
	}
      else
	return true;
    }

  /* Since the VSX register set includes traditional floating point registers
     and altivec registers, just check for the size being different instead of
     trying to check whether the modes are vector modes.  Otherwise it won't
     allow say DF and DI to change classes.  For types like TFmode and TDmode
     that take 2 64-bit registers, rather than a single 128-bit register, don't
     allow subregs of those types to other 128 bit types.  */
  if (TARGET_VSX && VSX_REG_CLASS_P (rclass))
    {
      unsigned num_regs = (from_size + 15) / 16;
      if (hard_regno_nregs (FIRST_FPR_REGNO, to) > num_regs
	  || hard_regno_nregs (FIRST_FPR_REGNO, from) > num_regs)
	return false;

      return (from_size == 8 || from_size == 16);
    }

  if (TARGET_ALTIVEC && rclass == ALTIVEC_REGS
      && (ALTIVEC_VECTOR_MODE (from) + ALTIVEC_VECTOR_MODE (to)) == 1)
    return false;

  return true;
}

/* Debug version of rs6000_can_change_mode_class.  */
static bool
rs6000_debug_can_change_mode_class (machine_mode from,
				    machine_mode to,
				    reg_class_t rclass)
{
  bool ret = rs6000_can_change_mode_class (from, to, rclass);

  fprintf (stderr,
	   "rs6000_can_change_mode_class, return %s, from = %s, "
	   "to = %s, rclass = %s\n",
	   ret ? "true" : "false",
	   GET_MODE_NAME (from), GET_MODE_NAME (to),
	   reg_class_names[rclass]);

  return ret;
}

/* Return a string to do a move operation of 128 bits of data.  */

const char *
rs6000_output_move_128bit (rtx operands[])
{
  rtx dest = operands[0];
  rtx src = operands[1];
  machine_mode mode = GET_MODE (dest);
  int dest_regno;
  int src_regno;
  bool dest_gpr_p, dest_fp_p, dest_vmx_p, dest_vsx_p;
  bool src_gpr_p, src_fp_p, src_vmx_p, src_vsx_p;

  if (REG_P (dest))
    {
      dest_regno = REGNO (dest);
      dest_gpr_p = INT_REGNO_P (dest_regno);
      dest_fp_p = FP_REGNO_P (dest_regno);
      dest_vmx_p = ALTIVEC_REGNO_P (dest_regno);
      dest_vsx_p = dest_fp_p | dest_vmx_p;
    }
  else
    {
      dest_regno = -1;
      dest_gpr_p = dest_fp_p = dest_vmx_p = dest_vsx_p = false;
    }

  if (REG_P (src))
    {
      src_regno = REGNO (src);
      src_gpr_p = INT_REGNO_P (src_regno);
      src_fp_p = FP_REGNO_P (src_regno);
      src_vmx_p = ALTIVEC_REGNO_P (src_regno);
      src_vsx_p = src_fp_p | src_vmx_p;
    }
  else
    {
      src_regno = -1;
      src_gpr_p = src_fp_p = src_vmx_p = src_vsx_p = false;
    }

  /* Register moves.  */
  if (dest_regno >= 0 && src_regno >= 0)
    {
      if (dest_gpr_p)
	{
	  if (src_gpr_p)
	    return "#";

	  if (TARGET_DIRECT_MOVE_128 && src_vsx_p)
	    return (WORDS_BIG_ENDIAN
		    ? "mfvsrd %0,%x1\n\tmfvsrld %L0,%x1"
		    : "mfvsrd %L0,%x1\n\tmfvsrld %0,%x1");

	  else if (TARGET_VSX && TARGET_DIRECT_MOVE && src_vsx_p)
	    return "#";
	}

      else if (TARGET_VSX && dest_vsx_p)
	{
	  if (src_vsx_p)
	    return "xxlor %x0,%x1,%x1";

	  else if (TARGET_DIRECT_MOVE_128 && src_gpr_p)
	    return (WORDS_BIG_ENDIAN
		    ? "mtvsrdd %x0,%1,%L1"
		    : "mtvsrdd %x0,%L1,%1");

	  else if (TARGET_DIRECT_MOVE && src_gpr_p)
	    return "#";
	}

      else if (TARGET_ALTIVEC && dest_vmx_p && src_vmx_p)
	return "vor %0,%1,%1";

      else if (dest_fp_p && src_fp_p)
	return "#";
    }

  /* Loads.  */
  else if (dest_regno >= 0 && MEM_P (src))
    {
      if (dest_gpr_p)
	{
	  if (TARGET_QUAD_MEMORY && quad_load_store_p (dest, src))
	    return "lq %0,%1";
	  else
	    return "#";
	}

      else if (TARGET_ALTIVEC && dest_vmx_p
	       && altivec_indexed_or_indirect_operand (src, mode))
	return "lvx %0,%y1";

      else if (TARGET_VSX && dest_vsx_p)
	{
	  if (mode_supports_dq_form (mode)
	      && quad_address_p (XEXP (src, 0), mode, true))
	    return "lxv %x0,%1";

	  else if (TARGET_P9_VECTOR)
	    return "lxvx %x0,%y1";

	  else if (mode == V16QImode || mode == V8HImode || mode == V4SImode)
	    return "lxvw4x %x0,%y1";

	  else
	    return "lxvd2x %x0,%y1";
	}

      else if (TARGET_ALTIVEC && dest_vmx_p)
	return "lvx %0,%y1";

      else if (dest_fp_p)
	return "#";
    }

  /* Stores.  */
  else if (src_regno >= 0 && MEM_P (dest))
    {
      if (src_gpr_p)
	{
 	  if (TARGET_QUAD_MEMORY && quad_load_store_p (dest, src))
	    return "stq %1,%0";
	  else
	    return "#";
	}

      else if (TARGET_ALTIVEC && src_vmx_p
	       && altivec_indexed_or_indirect_operand (dest, mode))
	return "stvx %1,%y0";

      else if (TARGET_VSX && src_vsx_p)
	{
	  if (mode_supports_dq_form (mode)
	      && quad_address_p (XEXP (dest, 0), mode, true))
	    return "stxv %x1,%0";

	  else if (TARGET_P9_VECTOR)
	    return "stxvx %x1,%y0";

	  else if (mode == V16QImode || mode == V8HImode || mode == V4SImode)
	    return "stxvw4x %x1,%y0";

	  else
	    return "stxvd2x %x1,%y0";
	}

      else if (TARGET_ALTIVEC && src_vmx_p)
	return "stvx %1,%y0";

      else if (src_fp_p)
	return "#";
    }

  /* Constants.  */
  else if (dest_regno >= 0
	   && (CONST_INT_P (src)
	       || CONST_WIDE_INT_P (src)
	       || CONST_DOUBLE_P (src)
	       || GET_CODE (src) == CONST_VECTOR))
    {
      if (dest_gpr_p)
	return "#";

      else if ((dest_vmx_p && TARGET_ALTIVEC)
	       || (dest_vsx_p && TARGET_VSX))
	return output_vec_const_move (operands);
    }

  fatal_insn ("Bad 128-bit move", gen_rtx_SET (dest, src));
}

/* Validate a 128-bit move.  */
bool
rs6000_move_128bit_ok_p (rtx operands[])
{
  machine_mode mode = GET_MODE (operands[0]);
  return (gpc_reg_operand (operands[0], mode)
	  || gpc_reg_operand (operands[1], mode));
}

/* Return true if a 128-bit move needs to be split.  */
bool
rs6000_split_128bit_ok_p (rtx operands[])
{
  if (!reload_completed)
    return false;

  if (!gpr_or_gpr_p (operands[0], operands[1]))
    return false;

  if (quad_load_store_p (operands[0], operands[1]))
    return false;

  return true;
}


/* Given a comparison operation, return the bit number in CCR to test.  We
   know this is a valid comparison.

   SCC_P is 1 if this is for an scc.  That means that %D will have been
   used instead of %C, so the bits will be in different places.

   Return -1 if OP isn't a valid comparison for some reason.  */

int
ccr_bit (rtx op, int scc_p)
{
  enum rtx_code code = GET_CODE (op);
  machine_mode cc_mode;
  int cc_regnum;
  int base_bit;
  rtx reg;

  if (!COMPARISON_P (op))
    return -1;

  reg = XEXP (op, 0);

  if (!REG_P (reg) || !CR_REGNO_P (REGNO (reg)))
    return -1;

  cc_mode = GET_MODE (reg);
  cc_regnum = REGNO (reg);
  base_bit = 4 * (cc_regnum - CR0_REGNO);

  validate_condition_mode (code, cc_mode);

  /* When generating a sCOND operation, only positive conditions are
     allowed.  */
  if (scc_p)
    switch (code)
      {
      case EQ:
      case GT:
      case LT:
      case UNORDERED:
      case GTU:
      case LTU:
	break;
      default:
	return -1;
      }

  switch (code)
    {
    case NE:
      return scc_p ? base_bit + 3 : base_bit + 2;
    case EQ:
      return base_bit + 2;
    case GT:  case GTU:  case UNLE:
      return base_bit + 1;
    case LT:  case LTU:  case UNGE:
      return base_bit;
    case ORDERED:  case UNORDERED:
      return base_bit + 3;

    case GE:  case GEU:
      /* If scc, we will have done a cror to put the bit in the
	 unordered position.  So test that bit.  For integer, this is ! LT
	 unless this is an scc insn.  */
      return scc_p ? base_bit + 3 : base_bit;

    case LE:  case LEU:
      return scc_p ? base_bit + 3 : base_bit + 1;

    default:
      return -1;
    }
}

/* Return the GOT register.  */

rtx
rs6000_got_register (rtx value ATTRIBUTE_UNUSED)
{
  /* The second flow pass currently (June 1999) can't update
     regs_ever_live without disturbing other parts of the compiler, so
     update it here to make the prolog/epilogue code happy.  */
  if (!can_create_pseudo_p ()
      && !df_regs_ever_live_p (RS6000_PIC_OFFSET_TABLE_REGNUM))
    df_set_regs_ever_live (RS6000_PIC_OFFSET_TABLE_REGNUM, true);

  crtl->uses_pic_offset_table = 1;

  return pic_offset_table_rtx;
}

static rs6000_stack_t stack_info;

/* Function to init struct machine_function.
   This will be called, via a pointer variable,
   from push_function_context.  */

static struct machine_function *
rs6000_init_machine_status (void)
{
  stack_info.reload_completed = 0;
  return ggc_cleared_alloc<machine_function> ();
}

#define INT_P(X) (CONST_INT_P (X) && GET_MODE (X) == VOIDmode)

/* Write out a function code label.  */

void
rs6000_output_function_entry (FILE *file, const char *fname)
{
  if (fname[0] != '.')
    {
      switch (DEFAULT_ABI)
	{
	default:
	  gcc_unreachable ();

	case ABI_AIX:
	  if (DOT_SYMBOLS)
	    putc ('.', file);
	  else
	    ASM_OUTPUT_INTERNAL_LABEL_PREFIX (file, "L.");
	  break;

	case ABI_ELFv2:
	case ABI_V4:
	case ABI_DARWIN:
	  break;
	}
    }

  RS6000_OUTPUT_BASENAME (file, fname);
}

/* Print an operand.  Recognize special options, documented below.  */

#if TARGET_ELF
/* Access to .sdata2 through r2 (see -msdata=eabi in invoke.texi) is
   only introduced by the linker, when applying the sda21
   relocation.  */
#define SMALL_DATA_RELOC ((rs6000_sdata == SDATA_EABI) ? "sda21" : "sdarel")
#define SMALL_DATA_REG ((rs6000_sdata == SDATA_EABI) ? 0 : 13)
#else
#define SMALL_DATA_RELOC "sda21"
#define SMALL_DATA_REG 0
#endif

void
print_operand (FILE *file, rtx x, int code)
{
  int i;
  unsigned HOST_WIDE_INT uval;

  switch (code)
    {
      /* %a is output_address.  */

      /* %c is output_addr_const if a CONSTANT_ADDRESS_P, otherwise
	 output_operand.  */

    case 'D':
      /* Like 'J' but get to the GT bit only.  */
      if (!REG_P (x) || !CR_REGNO_P (REGNO (x)))
	{
	  output_operand_lossage ("invalid %%D value");
	  return;
	}

      /* Bit 1 is GT bit.  */
      i = 4 * (REGNO (x) - CR0_REGNO) + 1;

      /* Add one for shift count in rlinm for scc.  */
      fprintf (file, "%d", i + 1);
      return;

    case 'e':
      /* If the low 16 bits are 0, but some other bit is set, write 's'.  */
      if (! INT_P (x))
	{
	  output_operand_lossage ("invalid %%e value");
	  return;
	}

      uval = INTVAL (x);
      if ((uval & 0xffff) == 0 && uval != 0)
	putc ('s', file);
      return;

    case 'E':
      /* X is a CR register.  Print the number of the EQ bit of the CR */
      if (!REG_P (x) || !CR_REGNO_P (REGNO (x)))
	output_operand_lossage ("invalid %%E value");
      else
	fprintf (file, "%d", 4 * (REGNO (x) - CR0_REGNO) + 2);
      return;

    case 'f':
      /* X is a CR register.  Print the shift count needed to move it
	 to the high-order four bits.  */
      if (!REG_P (x) || !CR_REGNO_P (REGNO (x)))
	output_operand_lossage ("invalid %%f value");
      else
	fprintf (file, "%d", 4 * (REGNO (x) - CR0_REGNO));
      return;

    case 'F':
      /* Similar, but print the count for the rotate in the opposite
	 direction.  */
      if (!REG_P (x) || !CR_REGNO_P (REGNO (x)))
	output_operand_lossage ("invalid %%F value");
      else
	fprintf (file, "%d", 32 - 4 * (REGNO (x) - CR0_REGNO));
      return;

    case 'G':
      /* X is a constant integer.  If it is negative, print "m",
	 otherwise print "z".  This is to make an aze or ame insn.  */
      if (!CONST_INT_P (x))
	output_operand_lossage ("invalid %%G value");
      else if (INTVAL (x) >= 0)
	putc ('z', file);
      else
	putc ('m', file);
      return;

    case 'h':
      /* If constant, output low-order five bits.  Otherwise, write
	 normally.  */
      if (INT_P (x))
	fprintf (file, HOST_WIDE_INT_PRINT_DEC, INTVAL (x) & 31);
      else
	print_operand (file, x, 0);
      return;

    case 'H':
      /* If constant, output low-order six bits.  Otherwise, write
	 normally.  */
      if (INT_P (x))
	fprintf (file, HOST_WIDE_INT_PRINT_DEC, INTVAL (x) & 63);
      else
	print_operand (file, x, 0);
      return;

    case 'I':
      /* Print `i' if this is a constant, else nothing.  */
      if (INT_P (x))
	putc ('i', file);
      return;

    case 'j':
      /* Write the bit number in CCR for jump.  */
      i = ccr_bit (x, 0);
      if (i == -1)
	output_operand_lossage ("invalid %%j code");
      else
	fprintf (file, "%d", i);
      return;

    case 'J':
      /* Similar, but add one for shift count in rlinm for scc and pass
	 scc flag to `ccr_bit'.  */
      i = ccr_bit (x, 1);
      if (i == -1)
	output_operand_lossage ("invalid %%J code");
      else
	/* If we want bit 31, write a shift count of zero, not 32.  */
	fprintf (file, "%d", i == 31 ? 0 : i + 1);
      return;

    case 'k':
      /* X must be a constant.  Write the 1's complement of the
	 constant.  */
      if (! INT_P (x))
	output_operand_lossage ("invalid %%k value");
      else
	fprintf (file, HOST_WIDE_INT_PRINT_DEC, ~ INTVAL (x));
      return;

    case 'K':
      /* X must be a symbolic constant on ELF.  Write an
	 expression suitable for an 'addi' that adds in the low 16
	 bits of the MEM.  */
      if (GET_CODE (x) == CONST)
	{
	  if (GET_CODE (XEXP (x, 0)) != PLUS
	      || (!SYMBOL_REF_P (XEXP (XEXP (x, 0), 0))
		  && GET_CODE (XEXP (XEXP (x, 0), 0)) != LABEL_REF)
	      || !CONST_INT_P (XEXP (XEXP (x, 0), 1)))
	    output_operand_lossage ("invalid %%K value");
	}
      print_operand_address (file, x);
      fputs ("@l", file);
      return;

      /* %l is output_asm_label.  */

    case 'L':
      /* Write second word of DImode or DFmode reference.  Works on register
	 or non-indexed memory only.  */
      if (REG_P (x))
	fputs (reg_names[REGNO (x) + 1], file);
      else if (MEM_P (x))
	{
	  machine_mode mode = GET_MODE (x);
	  /* Handle possible auto-increment.  Since it is pre-increment and
	     we have already done it, we can just use an offset of word.  */
	  if (GET_CODE (XEXP (x, 0)) == PRE_INC
	      || GET_CODE (XEXP (x, 0)) == PRE_DEC)
	    output_address (mode, plus_constant (Pmode, XEXP (XEXP (x, 0), 0),
						 UNITS_PER_WORD));
	  else if (GET_CODE (XEXP (x, 0)) == PRE_MODIFY)
	    output_address (mode, plus_constant (Pmode, XEXP (XEXP (x, 0), 0),
						 UNITS_PER_WORD));
	  else
	    output_address (mode, XEXP (adjust_address_nv (x, SImode,
							   UNITS_PER_WORD),
				  0));

	  if (small_data_operand (x, GET_MODE (x)))
	    fprintf (file, "@%s(%s)", SMALL_DATA_RELOC,
		     reg_names[SMALL_DATA_REG]);
	}
      return;

    case 'N': /* Unused */
      /* Write the number of elements in the vector times 4.  */
      if (GET_CODE (x) != PARALLEL)
	output_operand_lossage ("invalid %%N value");
      else
	fprintf (file, "%d", XVECLEN (x, 0) * 4);
      return;

    case 'O': /* Unused */
      /* Similar, but subtract 1 first.  */
      if (GET_CODE (x) != PARALLEL)
	output_operand_lossage ("invalid %%O value");
      else
	fprintf (file, "%d", (XVECLEN (x, 0) - 1) * 4);
      return;

    case 'p':
      /* X is a CONST_INT that is a power of two.  Output the logarithm.  */
      if (! INT_P (x)
	  || INTVAL (x) < 0
	  || (i = exact_log2 (INTVAL (x))) < 0)
	output_operand_lossage ("invalid %%p value");
      else
	fprintf (file, "%d", i);
      return;

    case 'P':
      /* The operand must be an indirect memory reference.  The result
	 is the register name.  */
      if (!MEM_P (x) || !REG_P (XEXP (x, 0))
	  || REGNO (XEXP (x, 0)) >= 32)
	output_operand_lossage ("invalid %%P value");
      else
	fputs (reg_names[REGNO (XEXP (x, 0))], file);
      return;

    case 'q':
      /* This outputs the logical code corresponding to a boolean
	 expression.  The expression may have one or both operands
	 negated (if one, only the first one).  For condition register
	 logical operations, it will also treat the negated
	 CR codes as NOTs, but not handle NOTs of them.  */
      {
	const char *const *t = 0;
	const char *s;
	enum rtx_code code = GET_CODE (x);
	static const char * const tbl[3][3] = {
	  { "and", "andc", "nor" },
	  { "or", "orc", "nand" },
	  { "xor", "eqv", "xor" } };

	if (code == AND)
	  t = tbl[0];
	else if (code == IOR)
	  t = tbl[1];
	else if (code == XOR)
	  t = tbl[2];
	else
	  output_operand_lossage ("invalid %%q value");

	if (GET_CODE (XEXP (x, 0)) != NOT)
	  s = t[0];
	else
	  {
	    if (GET_CODE (XEXP (x, 1)) == NOT)
	      s = t[2];
	    else
	      s = t[1];
	  }

	fputs (s, file);
      }
      return;

    case 'Q':
      if (! TARGET_MFCRF)
	return;
      fputc (',', file);
      /* FALLTHRU */

    case 'R':
      /* X is a CR register.  Print the mask for `mtcrf'.  */
      if (!REG_P (x) || !CR_REGNO_P (REGNO (x)))
	output_operand_lossage ("invalid %%R value");
      else
	fprintf (file, "%d", 128 >> (REGNO (x) - CR0_REGNO));
      return;

    case 's':
      /* Low 5 bits of 32 - value */
      if (! INT_P (x))
	output_operand_lossage ("invalid %%s value");
      else
	fprintf (file, HOST_WIDE_INT_PRINT_DEC, (32 - INTVAL (x)) & 31);
      return;

    case 't':
      /* Like 'J' but get to the OVERFLOW/UNORDERED bit.  */
      if (!REG_P (x) || !CR_REGNO_P (REGNO (x)))
	{
	  output_operand_lossage ("invalid %%t value");
	  return;
	}

      /* Bit 3 is OV bit.  */
      i = 4 * (REGNO (x) - CR0_REGNO) + 3;

      /* If we want bit 31, write a shift count of zero, not 32.  */
      fprintf (file, "%d", i == 31 ? 0 : i + 1);
      return;

    case 'T':
      /* Print the symbolic name of a branch target register.  */
      if (GET_CODE (x) == UNSPEC && XINT (x, 1) == UNSPEC_PLTSEQ)
	x = XVECEXP (x, 0, 0);
      if (!REG_P (x) || (REGNO (x) != LR_REGNO
			 && REGNO (x) != CTR_REGNO))
	output_operand_lossage ("invalid %%T value");
      else if (REGNO (x) == LR_REGNO)
	fputs ("lr", file);
      else
	fputs ("ctr", file);
      return;

    case 'u':
      /* High-order or low-order 16 bits of constant, whichever is non-zero,
	 for use in unsigned operand.  */
      if (! INT_P (x))
	{
	  output_operand_lossage ("invalid %%u value");
	  return;
	}

      uval = INTVAL (x);
      if ((uval & 0xffff) == 0)
	uval >>= 16;

      fprintf (file, HOST_WIDE_INT_PRINT_HEX, uval & 0xffff);
      return;

    case 'v':
      /* High-order 16 bits of constant for use in signed operand.  */
      if (! INT_P (x))
	output_operand_lossage ("invalid %%v value");
      else
	fprintf (file, HOST_WIDE_INT_PRINT_HEX,
		 (INTVAL (x) >> 16) & 0xffff);
      return;

    case 'U':
      /* Print `u' if this has an auto-increment or auto-decrement.  */
      if (MEM_P (x)
	  && (GET_CODE (XEXP (x, 0)) == PRE_INC
	      || GET_CODE (XEXP (x, 0)) == PRE_DEC
	      || GET_CODE (XEXP (x, 0)) == PRE_MODIFY))
	putc ('u', file);
      return;

    case 'V':
      /* Print the trap code for this operand.  */
      switch (GET_CODE (x))
	{
	case EQ:
	  fputs ("eq", file);   /* 4 */
	  break;
	case NE:
	  fputs ("ne", file);   /* 24 */
	  break;
	case LT:
	  fputs ("lt", file);   /* 16 */
	  break;
	case LE:
	  fputs ("le", file);   /* 20 */
	  break;
	case GT:
	  fputs ("gt", file);   /* 8 */
	  break;
	case GE:
	  fputs ("ge", file);   /* 12 */
	  break;
	case LTU:
	  fputs ("llt", file);  /* 2 */
	  break;
	case LEU:
	  fputs ("lle", file);  /* 6 */
	  break;
	case GTU:
	  fputs ("lgt", file);  /* 1 */
	  break;
	case GEU:
	  fputs ("lge", file);  /* 5 */
	  break;
	default:
	  output_operand_lossage ("invalid %%V value");
	}
      break;

    case 'w':
      /* If constant, low-order 16 bits of constant, signed.  Otherwise, write
	 normally.  */
      if (INT_P (x))
	fprintf (file, HOST_WIDE_INT_PRINT_DEC,
		 ((INTVAL (x) & 0xffff) ^ 0x8000) - 0x8000);
      else
	print_operand (file, x, 0);
      return;

    case 'x':
      /* X is a FPR or Altivec register used in a VSX context.  */
      if (!REG_P (x) || !VSX_REGNO_P (REGNO (x)))
	output_operand_lossage ("invalid %%x value");
      else
	{
	  int reg = REGNO (x);
	  int vsx_reg = (FP_REGNO_P (reg)
			 ? reg - 32
			 : reg - FIRST_ALTIVEC_REGNO + 32);

#ifdef TARGET_REGNAMES      
	  if (TARGET_REGNAMES)
	    fprintf (file, "%%vs%d", vsx_reg);
	  else
#endif
	    fprintf (file, "%d", vsx_reg);
	}
      return;

    case 'X':
      if (MEM_P (x)
	  && (legitimate_indexed_address_p (XEXP (x, 0), 0)
	      || (GET_CODE (XEXP (x, 0)) == PRE_MODIFY
		  && legitimate_indexed_address_p (XEXP (XEXP (x, 0), 1), 0))))
	putc ('x', file);
      return;

    case 'Y':
      /* Like 'L', for third word of TImode/PTImode  */
      if (REG_P (x))
	fputs (reg_names[REGNO (x) + 2], file);
      else if (MEM_P (x))
	{
	  machine_mode mode = GET_MODE (x);
	  if (GET_CODE (XEXP (x, 0)) == PRE_INC
	      || GET_CODE (XEXP (x, 0)) == PRE_DEC)
	    output_address (mode, plus_constant (Pmode,
						 XEXP (XEXP (x, 0), 0), 8));
	  else if (GET_CODE (XEXP (x, 0)) == PRE_MODIFY)
	    output_address (mode, plus_constant (Pmode,
						 XEXP (XEXP (x, 0), 0), 8));
	  else
	    output_address (mode, XEXP (adjust_address_nv (x, SImode, 8), 0));
	  if (small_data_operand (x, GET_MODE (x)))
	    fprintf (file, "@%s(%s)", SMALL_DATA_RELOC,
		     reg_names[SMALL_DATA_REG]);
	}
      return;

    case 'z':
      if (GET_CODE (x) == UNSPEC && XINT (x, 1) == UNSPEC_PLTSEQ)
	x = XVECEXP (x, 0, 1);
      /* X is a SYMBOL_REF.  Write out the name preceded by a
	 period and without any trailing data in brackets.  Used for function
	 names.  If we are configured for System V (or the embedded ABI) on
	 the PowerPC, do not emit the period, since those systems do not use
	 TOCs and the like.  */
      if (!SYMBOL_REF_P (x))
	{
	  output_operand_lossage ("invalid %%z value");
	  return;
	}

      /* For macho, check to see if we need a stub.  */
      if (TARGET_MACHO)
	{
	  const char *name = XSTR (x, 0);
#if TARGET_MACHO
	  if (darwin_picsymbol_stubs
	      && MACHOPIC_INDIRECT
	      && machopic_classify_symbol (x) == MACHOPIC_UNDEFINED_FUNCTION)
	    name = machopic_indirection_name (x, /*stub_p=*/true);
#endif
	  assemble_name (file, name);
	}
      else if (!DOT_SYMBOLS)
	assemble_name (file, XSTR (x, 0));
      else
	rs6000_output_function_entry (file, XSTR (x, 0));
      return;

    case 'Z':
      /* Like 'L', for last word of TImode/PTImode.  */
      if (REG_P (x))
	fputs (reg_names[REGNO (x) + 3], file);
      else if (MEM_P (x))
	{
	  machine_mode mode = GET_MODE (x);
	  if (GET_CODE (XEXP (x, 0)) == PRE_INC
	      || GET_CODE (XEXP (x, 0)) == PRE_DEC)
	    output_address (mode, plus_constant (Pmode,
						 XEXP (XEXP (x, 0), 0), 12));
	  else if (GET_CODE (XEXP (x, 0)) == PRE_MODIFY)
	    output_address (mode, plus_constant (Pmode,
						 XEXP (XEXP (x, 0), 0), 12));
	  else
	    output_address (mode, XEXP (adjust_address_nv (x, SImode, 12), 0));
	  if (small_data_operand (x, GET_MODE (x)))
	    fprintf (file, "@%s(%s)", SMALL_DATA_RELOC,
		     reg_names[SMALL_DATA_REG]);
	}
      return;

      /* Print AltiVec memory operand.  */
    case 'y':
      {
	rtx tmp;

	gcc_assert (MEM_P (x));

	tmp = XEXP (x, 0);

	if (VECTOR_MEM_ALTIVEC_OR_VSX_P (GET_MODE (x))
	    && GET_CODE (tmp) == AND
	    && CONST_INT_P (XEXP (tmp, 1))
	    && INTVAL (XEXP (tmp, 1)) == -16)
	  tmp = XEXP (tmp, 0);
	else if (VECTOR_MEM_VSX_P (GET_MODE (x))
		 && GET_CODE (tmp) == PRE_MODIFY)
	  tmp = XEXP (tmp, 1);
	if (REG_P (tmp))
	  fprintf (file, "0,%s", reg_names[REGNO (tmp)]);
	else
	  {
	    if (GET_CODE (tmp) != PLUS
		|| !REG_P (XEXP (tmp, 0))
		|| !REG_P (XEXP (tmp, 1)))
	      {
		output_operand_lossage ("invalid %%y value, try using the 'Z' constraint");
		break;
	      }

	    if (REGNO (XEXP (tmp, 0)) == 0)
	      fprintf (file, "%s,%s", reg_names[ REGNO (XEXP (tmp, 1)) ],
		       reg_names[ REGNO (XEXP (tmp, 0)) ]);
	    else
	      fprintf (file, "%s,%s", reg_names[ REGNO (XEXP (tmp, 0)) ],
		       reg_names[ REGNO (XEXP (tmp, 1)) ]);
	  }
	break;
      }

    case 0:
      if (REG_P (x))
	fprintf (file, "%s", reg_names[REGNO (x)]);
      else if (MEM_P (x))
	{
	  /* We need to handle PRE_INC and PRE_DEC here, since we need to
	     know the width from the mode.  */
	  if (GET_CODE (XEXP (x, 0)) == PRE_INC)
	    fprintf (file, "%d(%s)", GET_MODE_SIZE (GET_MODE (x)),
		     reg_names[REGNO (XEXP (XEXP (x, 0), 0))]);
	  else if (GET_CODE (XEXP (x, 0)) == PRE_DEC)
	    fprintf (file, "%d(%s)", - GET_MODE_SIZE (GET_MODE (x)),
		     reg_names[REGNO (XEXP (XEXP (x, 0), 0))]);
	  else if (GET_CODE (XEXP (x, 0)) == PRE_MODIFY)
	    output_address (GET_MODE (x), XEXP (XEXP (x, 0), 1));
	  else
	    output_address (GET_MODE (x), XEXP (x, 0));
	}
      else if (toc_relative_expr_p (x, false,
				    &tocrel_base_oac, &tocrel_offset_oac))
	/* This hack along with a corresponding hack in
	   rs6000_output_addr_const_extra arranges to output addends
	   where the assembler expects to find them.  eg.
	   (plus (unspec [(symbol_ref ("x")) (reg 2)] tocrel) 4)
	   without this hack would be output as "x@toc+4".  We
	   want "x+4@toc".  */
	output_addr_const (file, CONST_CAST_RTX (tocrel_base_oac));
      else if (GET_CODE (x) == UNSPEC && XINT (x, 1) == UNSPEC_TLSGD)
	output_addr_const (file, XVECEXP (x, 0, 0));
      else if (GET_CODE (x) == UNSPEC && XINT (x, 1) == UNSPEC_PLTSEQ)
	output_addr_const (file, XVECEXP (x, 0, 1));
      else
	output_addr_const (file, x);
      return;

    case '&':
      if (const char *name = get_some_local_dynamic_name ())
	assemble_name (file, name);
      else
	output_operand_lossage ("'%%&' used without any "
				"local dynamic TLS references");
      return;

    default:
      output_operand_lossage ("invalid %%xn code");
    }
}

/* Print the address of an operand.  */

void
print_operand_address (FILE *file, rtx x)
{
  if (REG_P (x))
    fprintf (file, "0(%s)", reg_names[ REGNO (x) ]);

  /* Is it a pc-relative address?  */
  else if (pcrel_address (x, Pmode))
    {
      HOST_WIDE_INT offset;

      if (GET_CODE (x) == CONST)
	x = XEXP (x, 0);

      if (GET_CODE (x) == PLUS)
	{
	  offset = INTVAL (XEXP (x, 1));
	  x = XEXP (x, 0);
	}
      else
	offset = 0;

      output_addr_const (file, x);

      if (offset)
	fprintf (file, "%+" PRId64, offset);

      fputs ("@pcrel", file);
    }
  else if (SYMBOL_REF_P (x) || GET_CODE (x) == CONST
	   || GET_CODE (x) == LABEL_REF)
    {
      output_addr_const (file, x);
      if (small_data_operand (x, GET_MODE (x)))
	fprintf (file, "@%s(%s)", SMALL_DATA_RELOC,
		 reg_names[SMALL_DATA_REG]);
      else
	gcc_assert (!TARGET_TOC);
    }
  else if (GET_CODE (x) == PLUS && REG_P (XEXP (x, 0))
	   && REG_P (XEXP (x, 1)))
    {
      if (REGNO (XEXP (x, 0)) == 0)
	fprintf (file, "%s,%s", reg_names[ REGNO (XEXP (x, 1)) ],
		 reg_names[ REGNO (XEXP (x, 0)) ]);
      else
	fprintf (file, "%s,%s", reg_names[ REGNO (XEXP (x, 0)) ],
		 reg_names[ REGNO (XEXP (x, 1)) ]);
    }
  else if (GET_CODE (x) == PLUS && REG_P (XEXP (x, 0))
	   && CONST_INT_P (XEXP (x, 1)))
    fprintf (file, HOST_WIDE_INT_PRINT_DEC "(%s)",
	     INTVAL (XEXP (x, 1)), reg_names[ REGNO (XEXP (x, 0)) ]);
#if TARGET_MACHO
  else if (GET_CODE (x) == LO_SUM && REG_P (XEXP (x, 0))
	   && CONSTANT_P (XEXP (x, 1)))
    {
      fprintf (file, "lo16(");
      output_addr_const (file, XEXP (x, 1));
      fprintf (file, ")(%s)", reg_names[ REGNO (XEXP (x, 0)) ]);
    }
#endif
#if TARGET_ELF
  else if (GET_CODE (x) == LO_SUM && REG_P (XEXP (x, 0))
	   && CONSTANT_P (XEXP (x, 1)))
    {
      output_addr_const (file, XEXP (x, 1));
      fprintf (file, "@l(%s)", reg_names[ REGNO (XEXP (x, 0)) ]);
    }
#endif
  else if (toc_relative_expr_p (x, false, &tocrel_base_oac, &tocrel_offset_oac))
    {
      /* This hack along with a corresponding hack in
	 rs6000_output_addr_const_extra arranges to output addends
	 where the assembler expects to find them.  eg.
	 (lo_sum (reg 9)
	 .       (plus (unspec [(symbol_ref ("x")) (reg 2)] tocrel) 8))
	 without this hack would be output as "x@toc+8@l(9)".  We
	 want "x+8@toc@l(9)".  */
      output_addr_const (file, CONST_CAST_RTX (tocrel_base_oac));
      if (GET_CODE (x) == LO_SUM)
	fprintf (file, "@l(%s)", reg_names[REGNO (XEXP (x, 0))]);
      else
	fprintf (file, "(%s)", reg_names[REGNO (XVECEXP (tocrel_base_oac, 0, 1))]);
    }
  else
    output_addr_const (file, x);
}

/* Implement TARGET_ASM_OUTPUT_ADDR_CONST_EXTRA.  */

static bool
rs6000_output_addr_const_extra (FILE *file, rtx x)
{
  if (GET_CODE (x) == UNSPEC)
    switch (XINT (x, 1))
      {
      case UNSPEC_TOCREL:
	gcc_checking_assert (SYMBOL_REF_P (XVECEXP (x, 0, 0))
			     && REG_P (XVECEXP (x, 0, 1))
			     && REGNO (XVECEXP (x, 0, 1)) == TOC_REGISTER);
	output_addr_const (file, XVECEXP (x, 0, 0));
	if (x == tocrel_base_oac && tocrel_offset_oac != const0_rtx)
	  {
	    if (INTVAL (tocrel_offset_oac) >= 0)
	      fprintf (file, "+");
	    output_addr_const (file, CONST_CAST_RTX (tocrel_offset_oac));
	  }
	if (!TARGET_AIX || (TARGET_ELF && TARGET_MINIMAL_TOC))
	  {
	    putc ('-', file);
	    assemble_name (file, toc_label_name);
	    need_toc_init = 1;
	  }
	else if (TARGET_ELF)
	  fputs ("@toc", file);
	return true;

#if TARGET_MACHO
      case UNSPEC_MACHOPIC_OFFSET:
	output_addr_const (file, XVECEXP (x, 0, 0));
	putc ('-', file);
	machopic_output_function_base_name (file);
	return true;
#endif
      }
  return false;
}

/* Target hook for assembling integer objects.  The PowerPC version has
   to handle fixup entries for relocatable code if RELOCATABLE_NEEDS_FIXUP
   is defined.  It also needs to handle DI-mode objects on 64-bit
   targets.  */

static bool
rs6000_assemble_integer (rtx x, unsigned int size, int aligned_p)
{
#ifdef RELOCATABLE_NEEDS_FIXUP
  /* Special handling for SI values.  */
  if (RELOCATABLE_NEEDS_FIXUP && size == 4 && aligned_p)
    {
      static int recurse = 0;

      /* For -mrelocatable, we mark all addresses that need to be fixed up in
	 the .fixup section.  Since the TOC section is already relocated, we
	 don't need to mark it here.  We used to skip the text section, but it
	 should never be valid for relocated addresses to be placed in the text
	 section.  */
      if (DEFAULT_ABI == ABI_V4
	  && (TARGET_RELOCATABLE || flag_pic > 1)
	  && in_section != toc_section
	  && !recurse
	  && !CONST_SCALAR_INT_P (x)
	  && CONSTANT_P (x))
	{
	  char buf[256];

	  recurse = 1;
	  ASM_GENERATE_INTERNAL_LABEL (buf, "LCP", fixuplabelno);
	  fixuplabelno++;
	  ASM_OUTPUT_LABEL (asm_out_file, buf);
	  fprintf (asm_out_file, "\t.long\t(");
	  output_addr_const (asm_out_file, x);
	  fprintf (asm_out_file, ")@fixup\n");
	  fprintf (asm_out_file, "\t.section\t\".fixup\",\"aw\"\n");
	  ASM_OUTPUT_ALIGN (asm_out_file, 2);
	  fprintf (asm_out_file, "\t.long\t");
	  assemble_name (asm_out_file, buf);
	  fprintf (asm_out_file, "\n\t.previous\n");
	  recurse = 0;
	  return true;
	}
      /* Remove initial .'s to turn a -mcall-aixdesc function
	 address into the address of the descriptor, not the function
	 itself.  */
      else if (SYMBOL_REF_P (x)
	       && XSTR (x, 0)[0] == '.'
	       && DEFAULT_ABI == ABI_AIX)
	{
	  const char *name = XSTR (x, 0);
	  while (*name == '.')
	    name++;

	  fprintf (asm_out_file, "\t.long\t%s\n", name);
	  return true;
	}
    }
#endif /* RELOCATABLE_NEEDS_FIXUP */
  return default_assemble_integer (x, size, aligned_p);
}

/* Return a template string for assembly to emit when making an
   external call.  FUNOP is the call mem argument operand number.  */

static const char *
rs6000_call_template_1 (rtx *operands, unsigned int funop, bool sibcall)
{
  /* -Wformat-overflow workaround, without which gcc thinks that %u
      might produce 10 digits.  */
  gcc_assert (funop <= MAX_RECOG_OPERANDS);

  char arg[12];
  arg[0] = 0;
  if (TARGET_TLS_MARKERS && GET_CODE (operands[funop + 1]) == UNSPEC)
    {
      if (XINT (operands[funop + 1], 1) == UNSPEC_TLSGD)
	sprintf (arg, "(%%%u@tlsgd)", funop + 1);
      else if (XINT (operands[funop + 1], 1) == UNSPEC_TLSLD)
	sprintf (arg, "(%%&@tlsld)");
      else
	gcc_unreachable ();
    }

  /* The magic 32768 offset here corresponds to the offset of
     r30 in .got2, as given by LCTOC1.  See sysv4.h:toc_section.  */
  char z[11];
  sprintf (z, "%%z%u%s", funop,
	   (DEFAULT_ABI == ABI_V4 && TARGET_SECURE_PLT && flag_pic == 2
	    ? "+32768" : ""));

  static char str[32];  /* 1 spare */
  if (rs6000_pcrel_p (cfun))
    sprintf (str, "b%s %s@notoc%s", sibcall ? "" : "l", z, arg);
  else if (DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2)
    sprintf (str, "b%s %s%s%s", sibcall ? "" : "l", z, arg,
	     sibcall ? "" : "\n\tnop");
  else if (DEFAULT_ABI == ABI_V4)
    sprintf (str, "b%s %s%s%s", sibcall ? "" : "l", z, arg,
	     flag_pic ? "@plt" : "");
#if TARGET_MACHO
  /* If/when we remove the mlongcall opt, we can share the AIX/ELGv2 case. */
   else if (DEFAULT_ABI == ABI_DARWIN)
    {
      /* The cookie is in operand func+2.  */
      gcc_checking_assert (GET_CODE (operands[funop + 2]) == CONST_INT);
      int cookie = INTVAL (operands[funop + 2]);
      if (cookie & CALL_LONG)
	{
	  tree funname = get_identifier (XSTR (operands[funop], 0));
	  tree labelname = get_prev_label (funname);
	  gcc_checking_assert (labelname && !sibcall);

	  /* "jbsr foo, L42" is Mach-O for "Link as 'bl foo' if a 'bl'
	     instruction will reach 'foo', otherwise link as 'bl L42'".
	     "L42" should be a 'branch island', that will do a far jump to
	     'foo'.  Branch islands are generated in
	     macho_branch_islands().  */
	  sprintf (str, "jbsr %%z%u,%.10s", funop,
		   IDENTIFIER_POINTER (labelname));
	}
      else
        /* Same as AIX or ELFv2, except to keep backwards compat, no nop
	   after the call.  */
	sprintf (str, "b%s %s%s", sibcall ? "" : "l", z, arg);
    }
#endif
  else
    gcc_unreachable ();
  return str;
}

const char *
rs6000_call_template (rtx *operands, unsigned int funop)
{
  return rs6000_call_template_1 (operands, funop, false);
}

const char *
rs6000_sibcall_template (rtx *operands, unsigned int funop)
{
  return rs6000_call_template_1 (operands, funop, true);
}

/* As above, for indirect calls.  */

static const char *
rs6000_indirect_call_template_1 (rtx *operands, unsigned int funop,
				 bool sibcall)
{
  /* -Wformat-overflow workaround, without which gcc thinks that %u
     might produce 10 digits.  Note that -Wformat-overflow will not
     currently warn here for str[], so do not rely on a warning to
     ensure str[] is correctly sized.  */
  gcc_assert (funop <= MAX_RECOG_OPERANDS);

  /* Currently, funop is either 0 or 1.  The maximum string is always
     a !speculate 64-bit __tls_get_addr call.

     ABI_ELFv2, pcrel:
     . 27	.reloc .,R_PPC64_TLSGD,%2\n\t
     . 35	.reloc .,R_PPC64_PLTSEQ_NOTOC,%z1\n\t
     .  9	crset 2\n\t
     . 27	.reloc .,R_PPC64_TLSGD,%2\n\t
     . 36	.reloc .,R_PPC64_PLTCALL_NOTOC,%z1\n\t
     .  8	beq%T1l-
     .---
     .142

     ABI_AIX:
     .  9	ld 2,%3\n\t
     . 27	.reloc .,R_PPC64_TLSGD,%2\n\t
     . 29	.reloc .,R_PPC64_PLTSEQ,%z1\n\t
     .  9	crset 2\n\t
     . 27	.reloc .,R_PPC64_TLSGD,%2\n\t
     . 30	.reloc .,R_PPC64_PLTCALL,%z1\n\t
     . 10	beq%T1l-\n\t
     . 10	ld 2,%4(1)
     .---
     .151

     ABI_ELFv2:
     . 27	.reloc .,R_PPC64_TLSGD,%2\n\t
     . 29	.reloc .,R_PPC64_PLTSEQ,%z1\n\t
     .  9	crset 2\n\t
     . 27	.reloc .,R_PPC64_TLSGD,%2\n\t
     . 30	.reloc .,R_PPC64_PLTCALL,%z1\n\t
     . 10	beq%T1l-\n\t
     . 10	ld 2,%3(1)
     .---
     .142

     ABI_V4:
     . 27	.reloc .,R_PPC64_TLSGD,%2\n\t
     . 35	.reloc .,R_PPC64_PLTSEQ,%z1+32768\n\t
     .  9	crset 2\n\t
     . 27	.reloc .,R_PPC64_TLSGD,%2\n\t
     . 36	.reloc .,R_PPC64_PLTCALL,%z1+32768\n\t
     .  8	beq%T1l-
     .---
     .141  */
  static char str[160];  /* 8 spare */
  char *s = str;
  const char *ptrload = TARGET_64BIT ? "d" : "wz";

  if (DEFAULT_ABI == ABI_AIX)
    s += sprintf (s,
		  "l%s 2,%%%u\n\t",
		  ptrload, funop + 2);

  /* We don't need the extra code to stop indirect call speculation if
     calling via LR.  */
  bool speculate = (TARGET_MACHO
		    || rs6000_speculate_indirect_jumps
		    || (REG_P (operands[funop])
			&& REGNO (operands[funop]) == LR_REGNO));

  if (TARGET_PLTSEQ && GET_CODE (operands[funop]) == UNSPEC)
    {
      const char *rel64 = TARGET_64BIT ? "64" : "";
      char tls[29];
      tls[0] = 0;
      if (TARGET_TLS_MARKERS && GET_CODE (operands[funop + 1]) == UNSPEC)
	{
	  if (XINT (operands[funop + 1], 1) == UNSPEC_TLSGD)
	    sprintf (tls, ".reloc .,R_PPC%s_TLSGD,%%%u\n\t",
		     rel64, funop + 1);
	  else if (XINT (operands[funop + 1], 1) == UNSPEC_TLSLD)
	    sprintf (tls, ".reloc .,R_PPC%s_TLSLD,%%&\n\t",
		     rel64);
	  else
	    gcc_unreachable ();
	}

      const char *notoc = rs6000_pcrel_p (cfun) ? "_NOTOC" : "";
      const char *addend = (DEFAULT_ABI == ABI_V4 && TARGET_SECURE_PLT
			    && flag_pic == 2 ? "+32768" : "");
      if (!speculate)
	{
	  s += sprintf (s,
			"%s.reloc .,R_PPC%s_PLTSEQ%s,%%z%u%s\n\t",
			tls, rel64, notoc, funop, addend);
	  s += sprintf (s, "crset 2\n\t");
	}
      s += sprintf (s,
		    "%s.reloc .,R_PPC%s_PLTCALL%s,%%z%u%s\n\t",
		    tls, rel64, notoc, funop, addend);
    }
  else if (!speculate)
    s += sprintf (s, "crset 2\n\t");

  if (rs6000_pcrel_p (cfun))
    {
      if (speculate)
	sprintf (s, "b%%T%ul", funop);
      else
	sprintf (s, "beq%%T%ul-", funop);
    }
  else if (DEFAULT_ABI == ABI_AIX)
    {
      if (speculate)
	sprintf (s,
		 "b%%T%ul\n\t"
		 "l%s 2,%%%u(1)",
		 funop, ptrload, funop + 3);
      else
	sprintf (s,
		 "beq%%T%ul-\n\t"
		 "l%s 2,%%%u(1)",
		 funop, ptrload, funop + 3);
    }
  else if (DEFAULT_ABI == ABI_ELFv2)
    {
      if (speculate)
	sprintf (s,
		 "b%%T%ul\n\t"
		 "l%s 2,%%%u(1)",
		 funop, ptrload, funop + 2);
      else
	sprintf (s,
		 "beq%%T%ul-\n\t"
		 "l%s 2,%%%u(1)",
		 funop, ptrload, funop + 2);
    }
  else
    {
      if (speculate)
	sprintf (s,
		 "b%%T%u%s",
		 funop, sibcall ? "" : "l");
      else
	sprintf (s,
		 "beq%%T%u%s-%s",
		 funop, sibcall ? "" : "l", sibcall ? "\n\tb $" : "");
    }
  return str;
}

const char *
rs6000_indirect_call_template (rtx *operands, unsigned int funop)
{
  return rs6000_indirect_call_template_1 (operands, funop, false);
}

const char *
rs6000_indirect_sibcall_template (rtx *operands, unsigned int funop)
{
  return rs6000_indirect_call_template_1 (operands, funop, true);
}

#if HAVE_AS_PLTSEQ
/* Output indirect call insns.  WHICH identifies the type of sequence.  */
const char *
rs6000_pltseq_template (rtx *operands, int which)
{
  const char *rel64 = TARGET_64BIT ? "64" : "";
  char tls[30];
  tls[0] = 0;
  if (TARGET_TLS_MARKERS && GET_CODE (operands[3]) == UNSPEC)
    {
      char off = which == RS6000_PLTSEQ_PLT_PCREL34 ? '8' : '4';
      if (XINT (operands[3], 1) == UNSPEC_TLSGD)
	sprintf (tls, ".reloc .-%c,R_PPC%s_TLSGD,%%3\n\t",
		 off, rel64);
      else if (XINT (operands[3], 1) == UNSPEC_TLSLD)
	sprintf (tls, ".reloc .-%c,R_PPC%s_TLSLD,%%&\n\t",
		 off, rel64);
      else
	gcc_unreachable ();
    }

  gcc_assert (DEFAULT_ABI == ABI_ELFv2 || DEFAULT_ABI == ABI_V4);
  static char str[96];  /* 10 spare */
  char off = WORDS_BIG_ENDIAN ? '2' : '4';
  const char *addend = (DEFAULT_ABI == ABI_V4 && TARGET_SECURE_PLT
			&& flag_pic == 2 ? "+32768" : "");
  switch (which)
    {
    case RS6000_PLTSEQ_TOCSAVE:
      sprintf (str,
	       "st%s\n\t"
	       "%s.reloc .-4,R_PPC%s_PLTSEQ,%%z2",
	       TARGET_64BIT ? "d 2,24(1)" : "w 2,12(1)",
	       tls, rel64);
      break;
    case RS6000_PLTSEQ_PLT16_HA:
      if (DEFAULT_ABI == ABI_V4 && !flag_pic)
	sprintf (str,
		 "lis %%0,0\n\t"
		 "%s.reloc .-%c,R_PPC%s_PLT16_HA,%%z2",
		 tls, off, rel64);
      else
	sprintf (str,
		 "addis %%0,%%1,0\n\t"
		 "%s.reloc .-%c,R_PPC%s_PLT16_HA,%%z2%s",
		 tls, off, rel64, addend);
      break;
    case RS6000_PLTSEQ_PLT16_LO:
      sprintf (str,
	       "l%s %%0,0(%%1)\n\t"
	       "%s.reloc .-%c,R_PPC%s_PLT16_LO%s,%%z2%s",
	       TARGET_64BIT ? "d" : "wz",
	       tls, off, rel64, TARGET_64BIT ? "_DS" : "", addend);
      break;
    case RS6000_PLTSEQ_MTCTR:
      sprintf (str,
	       "mtctr %%1\n\t"
	       "%s.reloc .-4,R_PPC%s_PLTSEQ,%%z2%s",
	       tls, rel64, addend);
      break;
    case RS6000_PLTSEQ_PLT_PCREL34:
      sprintf (str,
	       "pl%s %%0,0(0),1\n\t"
	       "%s.reloc .-8,R_PPC%s_PLT_PCREL34_NOTOC,%%z2",
	       TARGET_64BIT ? "d" : "wz",
	       tls, rel64);
      break;
    default:
      gcc_unreachable ();
    }
  return str;
}
#endif

/* Helper function to return whether a MODE can do prefixed loads/stores.
   VOIDmode is used when we are loading the pc-relative address into a base
   register, but we are not using it as part of a memory operation.  As modes
   add support for prefixed memory, they will be added here.  */

static bool
mode_supports_prefixed_address_p (machine_mode mode)
{
  return mode == VOIDmode;
}

/* Function to return true if ADDR is a valid prefixed memory address that uses
   mode MODE.  */

bool
rs6000_prefixed_address (rtx addr, machine_mode mode)
{
  if (!TARGET_PREFIXED_ADDR || !mode_supports_prefixed_address_p (mode))
    return false;

  /* Check for PC-relative addresses.  */
  if (pcrel_address (addr, Pmode))
    return true;

  /* Check for prefixed memory addresses that have a large numeric offset,
     or an offset that can't be used for a DS/DQ-form memory operation.  */
  if (GET_CODE (addr) == PLUS)
    {
      rtx op0 = XEXP (addr, 0);
      rtx op1 = XEXP (addr, 1);

      if (!base_reg_operand (op0, Pmode) || !CONST_INT_P (op1))
	return false;

      HOST_WIDE_INT value = INTVAL (op1);
      if (!SIGNED_34BIT_OFFSET_P (value, 0))
	return false;

      /* Offset larger than 16-bits?  */
      if (!SIGNED_16BIT_OFFSET_P (value, 0))
	return true;

      /* DQ instruction (bottom 4 bits must be 0) for vectors.  */
      HOST_WIDE_INT mask;
      if (GET_MODE_SIZE (mode) >= 16)
	mask = 15;

      /* DS instruction (bottom 2 bits must be 0).  For 32-bit integers, we
	 need to use DS instructions if we are sign-extending the value with
	 LWA.  For 32-bit floating point, we need DS instructions to load and
	 store values to the traditional Altivec registers.  */
      else if (GET_MODE_SIZE (mode) >= 4)
	mask = 3;

      /* QImode/HImode has no restrictions.  */
      else
	return true;

      /* Return true if we must use a prefixed instruction.  */
      return (value & mask) != 0;
    }

  return false;
}

#if defined (HAVE_GAS_HIDDEN) && !TARGET_MACHO
/* Emit an assembler directive to set symbol visibility for DECL to
   VISIBILITY_TYPE.  */

static void
rs6000_assemble_visibility (tree decl, int vis)
{
  if (TARGET_XCOFF)
    return;

  /* Functions need to have their entry point symbol visibility set as
     well as their descriptor symbol visibility.  */
  if (DEFAULT_ABI == ABI_AIX
      && DOT_SYMBOLS
      && TREE_CODE (decl) == FUNCTION_DECL)
    {
      static const char * const visibility_types[] = {
	NULL, "protected", "hidden", "internal"
      };

      const char *name, *type;

      name = ((* targetm.strip_name_encoding)
	      (IDENTIFIER_POINTER (DECL_ASSEMBLER_NAME (decl))));
      type = visibility_types[vis];

      fprintf (asm_out_file, "\t.%s\t%s\n", type, name);
      fprintf (asm_out_file, "\t.%s\t.%s\n", type, name);
    }
  else
    default_assemble_visibility (decl, vis);
}
#endif

enum rtx_code
rs6000_reverse_condition (machine_mode mode, enum rtx_code code)
{
  /* Reversal of FP compares takes care -- an ordered compare
     becomes an unordered compare and vice versa.  */
  if (mode == CCFPmode
      && (!flag_finite_math_only
	  || code == UNLT || code == UNLE || code == UNGT || code == UNGE
	  || code == UNEQ || code == LTGT))
    return reverse_condition_maybe_unordered (code);
  else
    return reverse_condition (code);
}

/* Generate a compare for CODE.  Return a brand-new rtx that
   represents the result of the compare.  */

static rtx
rs6000_generate_compare (rtx cmp, machine_mode mode)
{
  machine_mode comp_mode;
  rtx compare_result;
  enum rtx_code code = GET_CODE (cmp);
  rtx op0 = XEXP (cmp, 0);
  rtx op1 = XEXP (cmp, 1);

  if (!TARGET_FLOAT128_HW && FLOAT128_VECTOR_P (mode))
    comp_mode = CCmode;
  else if (FLOAT_MODE_P (mode))
    comp_mode = CCFPmode;
  else if (code == GTU || code == LTU
	   || code == GEU || code == LEU)
    comp_mode = CCUNSmode;
  else if ((code == EQ || code == NE)
	   && unsigned_reg_p (op0)
	   && (unsigned_reg_p (op1)
	       || (CONST_INT_P (op1) && INTVAL (op1) != 0)))
    /* These are unsigned values, perhaps there will be a later
       ordering compare that can be shared with this one.  */
    comp_mode = CCUNSmode;
  else
    comp_mode = CCmode;

  /* If we have an unsigned compare, make sure we don't have a signed value as
     an immediate.  */
  if (comp_mode == CCUNSmode && CONST_INT_P (op1)
      && INTVAL (op1) < 0)
    {
      op0 = copy_rtx_if_shared (op0);
      op1 = force_reg (GET_MODE (op0), op1);
      cmp = gen_rtx_fmt_ee (code, GET_MODE (cmp), op0, op1);
    }

  /* First, the compare.  */
  compare_result = gen_reg_rtx (comp_mode);

  /* IEEE 128-bit support in VSX registers when we do not have hardware
     support.  */
  if (!TARGET_FLOAT128_HW && FLOAT128_VECTOR_P (mode))
    {
      rtx libfunc = NULL_RTX;
      bool check_nan = false;
      rtx dest;

      switch (code)
	{
	case EQ:
	case NE:
	  libfunc = optab_libfunc (eq_optab, mode);
	  break;

	case GT:
	case GE:
	  libfunc = optab_libfunc (ge_optab, mode);
	  break;

	case LT:
	case LE:
	  libfunc = optab_libfunc (le_optab, mode);
	  break;

	case UNORDERED:
	case ORDERED:
	  libfunc = optab_libfunc (unord_optab, mode);
	  code = (code == UNORDERED) ? NE : EQ;
	  break;

	case UNGE:
	case UNGT:
	  check_nan = true;
	  libfunc = optab_libfunc (ge_optab, mode);
	  code = (code == UNGE) ? GE : GT;
	  break;

	case UNLE:
	case UNLT:
	  check_nan = true;
	  libfunc = optab_libfunc (le_optab, mode);
	  code = (code == UNLE) ? LE : LT;
	  break;

	case UNEQ:
	case LTGT:
	  check_nan = true;
	  libfunc = optab_libfunc (eq_optab, mode);
	  code = (code = UNEQ) ? EQ : NE;
	  break;

	default:
	  gcc_unreachable ();
	}

      gcc_assert (libfunc);

      if (!check_nan)
	dest = emit_library_call_value (libfunc, NULL_RTX, LCT_CONST,
					SImode, op0, mode, op1, mode);

      /* The library signals an exception for signalling NaNs, so we need to
	 handle isgreater, etc. by first checking isordered.  */
      else
	{
	  rtx ne_rtx, normal_dest, unord_dest;
	  rtx unord_func = optab_libfunc (unord_optab, mode);
	  rtx join_label = gen_label_rtx ();
	  rtx join_ref = gen_rtx_LABEL_REF (VOIDmode, join_label);
	  rtx unord_cmp = gen_reg_rtx (comp_mode);


	  /* Test for either value being a NaN.  */
	  gcc_assert (unord_func);
	  unord_dest = emit_library_call_value (unord_func, NULL_RTX, LCT_CONST,
						SImode, op0, mode, op1, mode);

	  /* Set value (0) if either value is a NaN, and jump to the join
	     label.  */
	  dest = gen_reg_rtx (SImode);
	  emit_move_insn (dest, const1_rtx);
	  emit_insn (gen_rtx_SET (unord_cmp,
				  gen_rtx_COMPARE (comp_mode, unord_dest,
						   const0_rtx)));

	  ne_rtx = gen_rtx_NE (comp_mode, unord_cmp, const0_rtx);
	  emit_jump_insn (gen_rtx_SET (pc_rtx,
				       gen_rtx_IF_THEN_ELSE (VOIDmode, ne_rtx,
							     join_ref,
							     pc_rtx)));

	  /* Do the normal comparison, knowing that the values are not
	     NaNs.  */
	  normal_dest = emit_library_call_value (libfunc, NULL_RTX, LCT_CONST,
						 SImode, op0, mode, op1, mode);

	  emit_insn (gen_cstoresi4 (dest,
				    gen_rtx_fmt_ee (code, SImode, normal_dest,
						    const0_rtx),
				    normal_dest, const0_rtx));

	  /* Join NaN and non-Nan paths.  Compare dest against 0.  */
	  emit_label (join_label);
	  code = NE;
	}

      emit_insn (gen_rtx_SET (compare_result,
			      gen_rtx_COMPARE (comp_mode, dest, const0_rtx)));
    }

  else
    {
      /* Generate XLC-compatible TFmode compare as PARALLEL with extra
	 CLOBBERs to match cmptf_internal2 pattern.  */
      if (comp_mode == CCFPmode && TARGET_XL_COMPAT
	  && FLOAT128_IBM_P (GET_MODE (op0))
	  && TARGET_HARD_FLOAT)
	emit_insn (gen_rtx_PARALLEL (VOIDmode,
	  gen_rtvec (10,
		     gen_rtx_SET (compare_result,
				  gen_rtx_COMPARE (comp_mode, op0, op1)),
		     gen_rtx_CLOBBER (VOIDmode, gen_rtx_SCRATCH (DFmode)),
		     gen_rtx_CLOBBER (VOIDmode, gen_rtx_SCRATCH (DFmode)),
		     gen_rtx_CLOBBER (VOIDmode, gen_rtx_SCRATCH (DFmode)),
		     gen_rtx_CLOBBER (VOIDmode, gen_rtx_SCRATCH (DFmode)),
		     gen_rtx_CLOBBER (VOIDmode, gen_rtx_SCRATCH (DFmode)),
		     gen_rtx_CLOBBER (VOIDmode, gen_rtx_SCRATCH (DFmode)),
		     gen_rtx_CLOBBER (VOIDmode, gen_rtx_SCRATCH (DFmode)),
		     gen_rtx_CLOBBER (VOIDmode, gen_rtx_SCRATCH (DFmode)),
		     gen_rtx_CLOBBER (VOIDmode, gen_rtx_SCRATCH (Pmode)))));
      else if (GET_CODE (op1) == UNSPEC
	       && XINT (op1, 1) == UNSPEC_SP_TEST)
	{
	  rtx op1b = XVECEXP (op1, 0, 0);
	  comp_mode = CCEQmode;
	  compare_result = gen_reg_rtx (CCEQmode);
	  if (TARGET_64BIT)
	    emit_insn (gen_stack_protect_testdi (compare_result, op0, op1b));
	  else
	    emit_insn (gen_stack_protect_testsi (compare_result, op0, op1b));
	}
      else
	emit_insn (gen_rtx_SET (compare_result,
				gen_rtx_COMPARE (comp_mode, op0, op1)));
    }

  /* Some kinds of FP comparisons need an OR operation;
     under flag_finite_math_only we don't bother.  */
  if (FLOAT_MODE_P (mode)
      && (!FLOAT128_IEEE_P (mode) || TARGET_FLOAT128_HW)
      && !flag_finite_math_only
      && (code == LE || code == GE
	  || code == UNEQ || code == LTGT
	  || code == UNGT || code == UNLT))
    {
      enum rtx_code or1, or2;
      rtx or1_rtx, or2_rtx, compare2_rtx;
      rtx or_result = gen_reg_rtx (CCEQmode);

      switch (code)
	{
	case LE: or1 = LT;  or2 = EQ;  break;
	case GE: or1 = GT;  or2 = EQ;  break;
	case UNEQ: or1 = UNORDERED;  or2 = EQ;  break;
	case LTGT: or1 = LT;  or2 = GT;  break;
	case UNGT: or1 = UNORDERED;  or2 = GT;  break;
	case UNLT: or1 = UNORDERED;  or2 = LT;  break;
	default:  gcc_unreachable ();
	}
      validate_condition_mode (or1, comp_mode);
      validate_condition_mode (or2, comp_mode);
      or1_rtx = gen_rtx_fmt_ee (or1, SImode, compare_result, const0_rtx);
      or2_rtx = gen_rtx_fmt_ee (or2, SImode, compare_result, const0_rtx);
      compare2_rtx = gen_rtx_COMPARE (CCEQmode,
				      gen_rtx_IOR (SImode, or1_rtx, or2_rtx),
				      const_true_rtx);
      emit_insn (gen_rtx_SET (or_result, compare2_rtx));

      compare_result = or_result;
      code = EQ;
    }

  validate_condition_mode (code, GET_MODE (compare_result));

  return gen_rtx_fmt_ee (code, VOIDmode, compare_result, const0_rtx);
}


/* Return the diagnostic message string if the binary operation OP is
   not permitted on TYPE1 and TYPE2, NULL otherwise.  */

static const char*
rs6000_invalid_binary_op (int op ATTRIBUTE_UNUSED,
			  const_tree type1,
			  const_tree type2)
{
  machine_mode mode1 = TYPE_MODE (type1);
  machine_mode mode2 = TYPE_MODE (type2);

  /* For complex modes, use the inner type.  */
  if (COMPLEX_MODE_P (mode1))
    mode1 = GET_MODE_INNER (mode1);

  if (COMPLEX_MODE_P (mode2))
    mode2 = GET_MODE_INNER (mode2);

  /* Don't allow IEEE 754R 128-bit binary floating point and IBM extended
     double to intermix unless -mfloat128-convert.  */
  if (mode1 == mode2)
    return NULL;

  if (!TARGET_FLOAT128_CVT)
    {
      if ((mode1 == KFmode && mode2 == IFmode)
	  || (mode1 == IFmode && mode2 == KFmode))
	return N_("__float128 and __ibm128 cannot be used in the same "
		  "expression");

      if (TARGET_IEEEQUAD
	  && ((mode1 == IFmode && mode2 == TFmode)
	      || (mode1 == TFmode && mode2 == IFmode)))
	return N_("__ibm128 and long double cannot be used in the same "
		  "expression");

      if (!TARGET_IEEEQUAD
	  && ((mode1 == KFmode && mode2 == TFmode)
	      || (mode1 == TFmode && mode2 == KFmode)))
	return N_("__float128 and long double cannot be used in the same "
		  "expression");
    }

  return NULL;
}


/* Expand floating point conversion to/from __float128 and __ibm128.  */

void
rs6000_expand_float128_convert (rtx dest, rtx src, bool unsigned_p)
{
  machine_mode dest_mode = GET_MODE (dest);
  machine_mode src_mode = GET_MODE (src);
  convert_optab cvt = unknown_optab;
  bool do_move = false;
  rtx libfunc = NULL_RTX;
  rtx dest2;
  typedef rtx (*rtx_2func_t) (rtx, rtx);
  rtx_2func_t hw_convert = (rtx_2func_t)0;
  size_t kf_or_tf;

  struct hw_conv_t {
    rtx_2func_t	from_df;
    rtx_2func_t from_sf;
    rtx_2func_t from_si_sign;
    rtx_2func_t from_si_uns;
    rtx_2func_t from_di_sign;
    rtx_2func_t from_di_uns;
    rtx_2func_t to_df;
    rtx_2func_t to_sf;
    rtx_2func_t to_si_sign;
    rtx_2func_t to_si_uns;
    rtx_2func_t to_di_sign;
    rtx_2func_t to_di_uns;
  } hw_conversions[2] = {
    /* convertions to/from KFmode */
    {
      gen_extenddfkf2_hw,		/* KFmode <- DFmode.  */
      gen_extendsfkf2_hw,		/* KFmode <- SFmode.  */
      gen_float_kfsi2_hw,		/* KFmode <- SImode (signed).  */
      gen_floatuns_kfsi2_hw,		/* KFmode <- SImode (unsigned).  */
      gen_float_kfdi2_hw,		/* KFmode <- DImode (signed).  */
      gen_floatuns_kfdi2_hw,		/* KFmode <- DImode (unsigned).  */
      gen_trunckfdf2_hw,		/* DFmode <- KFmode.  */
      gen_trunckfsf2_hw,		/* SFmode <- KFmode.  */
      gen_fix_kfsi2_hw,			/* SImode <- KFmode (signed).  */
      gen_fixuns_kfsi2_hw,		/* SImode <- KFmode (unsigned).  */
      gen_fix_kfdi2_hw,			/* DImode <- KFmode (signed).  */
      gen_fixuns_kfdi2_hw,		/* DImode <- KFmode (unsigned).  */
    },

    /* convertions to/from TFmode */
    {
      gen_extenddftf2_hw,		/* TFmode <- DFmode.  */
      gen_extendsftf2_hw,		/* TFmode <- SFmode.  */
      gen_float_tfsi2_hw,		/* TFmode <- SImode (signed).  */
      gen_floatuns_tfsi2_hw,		/* TFmode <- SImode (unsigned).  */
      gen_float_tfdi2_hw,		/* TFmode <- DImode (signed).  */
      gen_floatuns_tfdi2_hw,		/* TFmode <- DImode (unsigned).  */
      gen_trunctfdf2_hw,		/* DFmode <- TFmode.  */
      gen_trunctfsf2_hw,		/* SFmode <- TFmode.  */
      gen_fix_tfsi2_hw,			/* SImode <- TFmode (signed).  */
      gen_fixuns_tfsi2_hw,		/* SImode <- TFmode (unsigned).  */
      gen_fix_tfdi2_hw,			/* DImode <- TFmode (signed).  */
      gen_fixuns_tfdi2_hw,		/* DImode <- TFmode (unsigned).  */
    },
  };

  if (dest_mode == src_mode)
    gcc_unreachable ();

  /* Eliminate memory operations.  */
  if (MEM_P (src))
    src = force_reg (src_mode, src);

  if (MEM_P (dest))
    {
      rtx tmp = gen_reg_rtx (dest_mode);
      rs6000_expand_float128_convert (tmp, src, unsigned_p);
      rs6000_emit_move (dest, tmp, dest_mode);
      return;
    }

  /* Convert to IEEE 128-bit floating point.  */
  if (FLOAT128_IEEE_P (dest_mode))
    {
      if (dest_mode == KFmode)
	kf_or_tf = 0;
      else if (dest_mode == TFmode)
	kf_or_tf = 1;
      else
	gcc_unreachable ();

      switch (src_mode)
	{
	case E_DFmode:
	  cvt = sext_optab;
	  hw_convert = hw_conversions[kf_or_tf].from_df;
	  break;

	case E_SFmode:
	  cvt = sext_optab;
	  hw_convert = hw_conversions[kf_or_tf].from_sf;
	  break;

	case E_KFmode:
	case E_IFmode:
	case E_TFmode:
	  if (FLOAT128_IBM_P (src_mode))
	    cvt = sext_optab;
	  else
	    do_move = true;
	  break;

	case E_SImode:
	  if (unsigned_p)
	    {
	      cvt = ufloat_optab;
	      hw_convert = hw_conversions[kf_or_tf].from_si_uns;
	    }
	  else
	    {
	      cvt = sfloat_optab;
	      hw_convert = hw_conversions[kf_or_tf].from_si_sign;
	    }
	  break;

	case E_DImode:
	  if (unsigned_p)
	    {
	      cvt = ufloat_optab;
	      hw_convert = hw_conversions[kf_or_tf].from_di_uns;
	    }
	  else
	    {
	      cvt = sfloat_optab;
	      hw_convert = hw_conversions[kf_or_tf].from_di_sign;
	    }
	  break;

	default:
	  gcc_unreachable ();
	}
    }

  /* Convert from IEEE 128-bit floating point.  */
  else if (FLOAT128_IEEE_P (src_mode))
    {
      if (src_mode == KFmode)
	kf_or_tf = 0;
      else if (src_mode == TFmode)
	kf_or_tf = 1;
      else
	gcc_unreachable ();

      switch (dest_mode)
	{
	case E_DFmode:
	  cvt = trunc_optab;
	  hw_convert = hw_conversions[kf_or_tf].to_df;
	  break;

	case E_SFmode:
	  cvt = trunc_optab;
	  hw_convert = hw_conversions[kf_or_tf].to_sf;
	  break;

	case E_KFmode:
	case E_IFmode:
	case E_TFmode:
	  if (FLOAT128_IBM_P (dest_mode))
	    cvt = trunc_optab;
	  else
	    do_move = true;
	  break;

	case E_SImode:
	  if (unsigned_p)
	    {
	      cvt = ufix_optab;
	      hw_convert = hw_conversions[kf_or_tf].to_si_uns;
	    }
	  else
	    {
	      cvt = sfix_optab;
	      hw_convert = hw_conversions[kf_or_tf].to_si_sign;
	    }
	  break;

	case E_DImode:
	  if (unsigned_p)
	    {
	      cvt = ufix_optab;
	      hw_convert = hw_conversions[kf_or_tf].to_di_uns;
	    }
	  else
	    {
	      cvt = sfix_optab;
	      hw_convert = hw_conversions[kf_or_tf].to_di_sign;
	    }
	  break;

	default:
	  gcc_unreachable ();
	}
    }

  /* Both IBM format.  */
  else if (FLOAT128_IBM_P (dest_mode) && FLOAT128_IBM_P (src_mode))
    do_move = true;

  else
    gcc_unreachable ();

  /* Handle conversion between TFmode/KFmode/IFmode.  */
  if (do_move)
    emit_insn (gen_rtx_SET (dest, gen_rtx_FLOAT_EXTEND (dest_mode, src)));

  /* Handle conversion if we have hardware support.  */
  else if (TARGET_FLOAT128_HW && hw_convert)
    emit_insn ((hw_convert) (dest, src));

  /* Call an external function to do the conversion.  */
  else if (cvt != unknown_optab)
    {
      libfunc = convert_optab_libfunc (cvt, dest_mode, src_mode);
      gcc_assert (libfunc != NULL_RTX);

      dest2 = emit_library_call_value (libfunc, dest, LCT_CONST, dest_mode,
				       src, src_mode);

      gcc_assert (dest2 != NULL_RTX);
      if (!rtx_equal_p (dest, dest2))
	emit_move_insn (dest, dest2);
    }

  else
    gcc_unreachable ();

  return;
}


/* Emit RTL that sets a register to zero if OP1 and OP2 are equal.  SCRATCH
   can be used as that dest register.  Return the dest register.  */

rtx
rs6000_emit_eqne (machine_mode mode, rtx op1, rtx op2, rtx scratch)
{
  if (op2 == const0_rtx)
    return op1;

  if (GET_CODE (scratch) == SCRATCH)
    scratch = gen_reg_rtx (mode);

  if (logical_operand (op2, mode))
    emit_insn (gen_rtx_SET (scratch, gen_rtx_XOR (mode, op1, op2)));
  else
    emit_insn (gen_rtx_SET (scratch,
			    gen_rtx_PLUS (mode, op1, negate_rtx (mode, op2))));

  return scratch;
}

void
rs6000_emit_sCOND (machine_mode mode, rtx operands[])
{
  rtx condition_rtx;
  machine_mode op_mode;
  enum rtx_code cond_code;
  rtx result = operands[0];

  condition_rtx = rs6000_generate_compare (operands[1], mode);
  cond_code = GET_CODE (condition_rtx);

  if (cond_code == NE
      || cond_code == GE || cond_code == LE
      || cond_code == GEU || cond_code == LEU
      || cond_code == ORDERED || cond_code == UNGE || cond_code == UNLE)
    {
      rtx not_result = gen_reg_rtx (CCEQmode);
      rtx not_op, rev_cond_rtx;
      machine_mode cc_mode;

      cc_mode = GET_MODE (XEXP (condition_rtx, 0));

      rev_cond_rtx = gen_rtx_fmt_ee (rs6000_reverse_condition (cc_mode, cond_code),
				     SImode, XEXP (condition_rtx, 0), const0_rtx);
      not_op = gen_rtx_COMPARE (CCEQmode, rev_cond_rtx, const0_rtx);
      emit_insn (gen_rtx_SET (not_result, not_op));
      condition_rtx = gen_rtx_EQ (VOIDmode, not_result, const0_rtx);
    }

  op_mode = GET_MODE (XEXP (operands[1], 0));
  if (op_mode == VOIDmode)
    op_mode = GET_MODE (XEXP (operands[1], 1));

  if (TARGET_POWERPC64 && (op_mode == DImode || FLOAT_MODE_P (mode)))
    {
      PUT_MODE (condition_rtx, DImode);
      convert_move (result, condition_rtx, 0);
    }
  else
    {
      PUT_MODE (condition_rtx, SImode);
      emit_insn (gen_rtx_SET (result, condition_rtx));
    }
}

/* Emit a branch of kind CODE to location LOC.  */

void
rs6000_emit_cbranch (machine_mode mode, rtx operands[])
{
  rtx condition_rtx, loc_ref;

  condition_rtx = rs6000_generate_compare (operands[0], mode);
  loc_ref = gen_rtx_LABEL_REF (VOIDmode, operands[3]);
  emit_jump_insn (gen_rtx_SET (pc_rtx,
			       gen_rtx_IF_THEN_ELSE (VOIDmode, condition_rtx,
						     loc_ref, pc_rtx)));
}

/* Return the string to output a conditional branch to LABEL, which is
   the operand template of the label, or NULL if the branch is really a
   conditional return.

   OP is the conditional expression.  XEXP (OP, 0) is assumed to be a
   condition code register and its mode specifies what kind of
   comparison we made.

   REVERSED is nonzero if we should reverse the sense of the comparison.

   INSN is the insn.  */

char *
output_cbranch (rtx op, const char *label, int reversed, rtx_insn *insn)
{
  static char string[64];
  enum rtx_code code = GET_CODE (op);
  rtx cc_reg = XEXP (op, 0);
  machine_mode mode = GET_MODE (cc_reg);
  int cc_regno = REGNO (cc_reg) - CR0_REGNO;
  int need_longbranch = label != NULL && get_attr_length (insn) == 8;
  int really_reversed = reversed ^ need_longbranch;
  char *s = string;
  const char *ccode;
  const char *pred;
  rtx note;

  validate_condition_mode (code, mode);

  /* Work out which way this really branches.  We could use
     reverse_condition_maybe_unordered here always but this
     makes the resulting assembler clearer.  */
  if (really_reversed)
    {
      /* Reversal of FP compares takes care -- an ordered compare
	 becomes an unordered compare and vice versa.  */
      if (mode == CCFPmode)
	code = reverse_condition_maybe_unordered (code);
      else
	code = reverse_condition (code);
    }

  switch (code)
    {
      /* Not all of these are actually distinct opcodes, but
	 we distinguish them for clarity of the resulting assembler.  */
    case NE: case LTGT:
      ccode = "ne"; break;
    case EQ: case UNEQ:
      ccode = "eq"; break;
    case GE: case GEU:
      ccode = "ge"; break;
    case GT: case GTU: case UNGT:
      ccode = "gt"; break;
    case LE: case LEU:
      ccode = "le"; break;
    case LT: case LTU: case UNLT:
      ccode = "lt"; break;
    case UNORDERED: ccode = "un"; break;
    case ORDERED: ccode = "nu"; break;
    case UNGE: ccode = "nl"; break;
    case UNLE: ccode = "ng"; break;
    default:
      gcc_unreachable ();
    }

  /* Maybe we have a guess as to how likely the branch is.  */
  pred = "";
  note = find_reg_note (insn, REG_BR_PROB, NULL_RTX);
  if (note != NULL_RTX)
    {
      /* PROB is the difference from 50%.  */
      int prob = profile_probability::from_reg_br_prob_note (XINT (note, 0))
		   .to_reg_br_prob_base () - REG_BR_PROB_BASE / 2;

      /* Only hint for highly probable/improbable branches on newer cpus when
	 we have real profile data, as static prediction overrides processor
	 dynamic prediction.  For older cpus we may as well always hint, but
	 assume not taken for branches that are very close to 50% as a
	 mispredicted taken branch is more expensive than a
	 mispredicted not-taken branch.  */
      if (rs6000_always_hint
	  || (abs (prob) > REG_BR_PROB_BASE / 100 * 48
	      && (profile_status_for_fn (cfun) != PROFILE_GUESSED)
	      && br_prob_note_reliable_p (note)))
	{
	  if (abs (prob) > REG_BR_PROB_BASE / 20
	      && ((prob > 0) ^ need_longbranch))
	    pred = "+";
	  else
	    pred = "-";
	}
    }

  if (label == NULL)
    s += sprintf (s, "b%slr%s ", ccode, pred);
  else
    s += sprintf (s, "b%s%s ", ccode, pred);

  /* We need to escape any '%' characters in the reg_names string.
     Assume they'd only be the first character....  */
  if (reg_names[cc_regno + CR0_REGNO][0] == '%')
    *s++ = '%';
  s += sprintf (s, "%s", reg_names[cc_regno + CR0_REGNO]);

  if (label != NULL)
    {
      /* If the branch distance was too far, we may have to use an
	 unconditional branch to go the distance.  */
      if (need_longbranch)
	s += sprintf (s, ",$+8\n\tb %s", label);
      else
	s += sprintf (s, ",%s", label);
    }

  return string;
}

/* Return insn for VSX or Altivec comparisons.  */

static rtx
rs6000_emit_vector_compare_inner (enum rtx_code code, rtx op0, rtx op1)
{
  rtx mask;
  machine_mode mode = GET_MODE (op0);

  switch (code)
    {
    default:
      break;

    case GE:
      if (GET_MODE_CLASS (mode) == MODE_VECTOR_INT)
	return NULL_RTX;
      /* FALLTHRU */

    case EQ:
    case GT:
    case GTU:
    case ORDERED:
    case UNORDERED:
    case UNEQ:
    case LTGT:
      mask = gen_reg_rtx (mode);
      emit_insn (gen_rtx_SET (mask, gen_rtx_fmt_ee (code, mode, op0, op1)));
      return mask;
    }

  return NULL_RTX;
}

/* Emit vector compare for operands OP0 and OP1 using code RCODE.
   DMODE is expected destination mode. This is a recursive function.  */

static rtx
rs6000_emit_vector_compare (enum rtx_code rcode,
			    rtx op0, rtx op1,
			    machine_mode dmode)
{
  rtx mask;
  bool swap_operands = false;
  bool try_again = false;

  gcc_assert (VECTOR_UNIT_ALTIVEC_OR_VSX_P (dmode));
  gcc_assert (GET_MODE (op0) == GET_MODE (op1));

  /* See if the comparison works as is.  */
  mask = rs6000_emit_vector_compare_inner (rcode, op0, op1);
  if (mask)
    return mask;

  switch (rcode)
    {
    case LT:
      rcode = GT;
      swap_operands = true;
      try_again = true;
      break;
    case LTU:
      rcode = GTU;
      swap_operands = true;
      try_again = true;
      break;
    case NE:
    case UNLE:
    case UNLT:
    case UNGE:
    case UNGT:
      /* Invert condition and try again.
	 e.g., A != B becomes ~(A==B).  */
      {
	enum rtx_code rev_code;
	enum insn_code nor_code;
	rtx mask2;

	rev_code = reverse_condition_maybe_unordered (rcode);
	if (rev_code == UNKNOWN)
	  return NULL_RTX;

	nor_code = optab_handler (one_cmpl_optab, dmode);
	if (nor_code == CODE_FOR_nothing)
	  return NULL_RTX;

	mask2 = rs6000_emit_vector_compare (rev_code, op0, op1, dmode);
	if (!mask2)
	  return NULL_RTX;

	mask = gen_reg_rtx (dmode);
	emit_insn (GEN_FCN (nor_code) (mask, mask2));
	return mask;
      }
      break;
    case GE:
    case GEU:
    case LE:
    case LEU:
      /* Try GT/GTU/LT/LTU OR EQ */
      {
	rtx c_rtx, eq_rtx;
	enum insn_code ior_code;
	enum rtx_code new_code;

	switch (rcode)
	  {
	  case  GE:
	    new_code = GT;
	    break;

	  case GEU:
	    new_code = GTU;
	    break;

	  case LE:
	    new_code = LT;
	    break;

	  case LEU:
	    new_code = LTU;
	    break;

	  default:
	    gcc_unreachable ();
	  }

	ior_code = optab_handler (ior_optab, dmode);
	if (ior_code == CODE_FOR_nothing)
	  return NULL_RTX;

	c_rtx = rs6000_emit_vector_compare (new_code, op0, op1, dmode);
	if (!c_rtx)
	  return NULL_RTX;

	eq_rtx = rs6000_emit_vector_compare (EQ, op0, op1, dmode);
	if (!eq_rtx)
	  return NULL_RTX;

	mask = gen_reg_rtx (dmode);
	emit_insn (GEN_FCN (ior_code) (mask, c_rtx, eq_rtx));
	return mask;
      }
      break;
    default:
      return NULL_RTX;
    }

  if (try_again)
    {
      if (swap_operands)
	std::swap (op0, op1);

      mask = rs6000_emit_vector_compare_inner (rcode, op0, op1);
      if (mask)
	return mask;
    }

  /* You only get two chances.  */
  return NULL_RTX;
}

/* Emit vector conditional expression.  DEST is destination. OP_TRUE and
   OP_FALSE are two VEC_COND_EXPR operands.  CC_OP0 and CC_OP1 are the two
   operands for the relation operation COND.  */

int
rs6000_emit_vector_cond_expr (rtx dest, rtx op_true, rtx op_false,
			      rtx cond, rtx cc_op0, rtx cc_op1)
{
  machine_mode dest_mode = GET_MODE (dest);
  machine_mode mask_mode = GET_MODE (cc_op0);
  enum rtx_code rcode = GET_CODE (cond);
  machine_mode cc_mode = CCmode;
  rtx mask;
  rtx cond2;
  bool invert_move = false;

  if (VECTOR_UNIT_NONE_P (dest_mode))
    return 0;

  gcc_assert (GET_MODE_SIZE (dest_mode) == GET_MODE_SIZE (mask_mode)
	      && GET_MODE_NUNITS (dest_mode) == GET_MODE_NUNITS (mask_mode));

  switch (rcode)
    {
      /* Swap operands if we can, and fall back to doing the operation as
	 specified, and doing a NOR to invert the test.  */
    case NE:
    case UNLE:
    case UNLT:
    case UNGE:
    case UNGT:
      /* Invert condition and try again.
	 e.g., A  = (B != C) ? D : E becomes A = (B == C) ? E : D.  */
      invert_move = true;
      rcode = reverse_condition_maybe_unordered (rcode);
      if (rcode == UNKNOWN)
	return 0;
      break;

    case GE:
    case LE:
      if (GET_MODE_CLASS (mask_mode) == MODE_VECTOR_INT)
	{
	  /* Invert condition to avoid compound test.  */
	  invert_move = true;
	  rcode = reverse_condition (rcode);
	}
      break;

    case GTU:
    case GEU:
    case LTU:
    case LEU:
      /* Mark unsigned tests with CCUNSmode.  */
      cc_mode = CCUNSmode;

      /* Invert condition to avoid compound test if necessary.  */
      if (rcode == GEU || rcode == LEU)
	{
	  invert_move = true;
	  rcode = reverse_condition (rcode);
	}
      break;

    default:
      break;
    }

  /* Get the vector mask for the given relational operations.  */
  mask = rs6000_emit_vector_compare (rcode, cc_op0, cc_op1, mask_mode);

  if (!mask)
    return 0;

  if (invert_move)
    std::swap (op_true, op_false);

  /* Optimize vec1 == vec2, to know the mask generates -1/0.  */
  if (GET_MODE_CLASS (dest_mode) == MODE_VECTOR_INT
      && (GET_CODE (op_true) == CONST_VECTOR
	  || GET_CODE (op_false) == CONST_VECTOR))
    {
      rtx constant_0 = CONST0_RTX (dest_mode);
      rtx constant_m1 = CONSTM1_RTX (dest_mode);

      if (op_true == constant_m1 && op_false == constant_0)
	{
	  emit_move_insn (dest, mask);
	  return 1;
	}

      else if (op_true == constant_0 && op_false == constant_m1)
	{
	  emit_insn (gen_rtx_SET (dest, gen_rtx_NOT (dest_mode, mask)));
	  return 1;
	}

      /* If we can't use the vector comparison directly, perhaps we can use
	 the mask for the true or false fields, instead of loading up a
	 constant.  */
      if (op_true == constant_m1)
	op_true = mask;

      if (op_false == constant_0)
	op_false = mask;
    }

  if (!REG_P (op_true) && !SUBREG_P (op_true))
    op_true = force_reg (dest_mode, op_true);

  if (!REG_P (op_false) && !SUBREG_P (op_false))
    op_false = force_reg (dest_mode, op_false);

  cond2 = gen_rtx_fmt_ee (NE, cc_mode, gen_lowpart (dest_mode, mask),
			  CONST0_RTX (dest_mode));
  emit_insn (gen_rtx_SET (dest,
			  gen_rtx_IF_THEN_ELSE (dest_mode,
						cond2,
						op_true,
						op_false)));
  return 1;
}

/* ISA 3.0 (power9) minmax subcase to emit a XSMAXCDP or XSMINCDP instruction
   for SF/DF scalars.  Move TRUE_COND to DEST if OP of the operands of the last
   comparison is nonzero/true, FALSE_COND if it is zero/false.  Return 0 if the
   hardware has no such operation.  */

static int
rs6000_emit_p9_fp_minmax (rtx dest, rtx op, rtx true_cond, rtx false_cond)
{
  enum rtx_code code = GET_CODE (op);
  rtx op0 = XEXP (op, 0);
  rtx op1 = XEXP (op, 1);
  machine_mode compare_mode = GET_MODE (op0);
  machine_mode result_mode = GET_MODE (dest);
  bool max_p = false;

  if (result_mode != compare_mode)
    return 0;

  if (code == GE || code == GT)
    max_p = true;
  else if (code == LE || code == LT)
    max_p = false;
  else
    return 0;

  if (rtx_equal_p (op0, true_cond) && rtx_equal_p (op1, false_cond))
    ;

  else if (rtx_equal_p (op1, true_cond) && rtx_equal_p (op0, false_cond))
    max_p = !max_p;

  else
    return 0;

  rs6000_emit_minmax (dest, max_p ? SMAX : SMIN, op0, op1);
  return 1;
}

/* ISA 3.0 (power9) conditional move subcase to emit XSCMP{EQ,GE,GT,NE}DP and
   XXSEL instructions for SF/DF scalars.  Move TRUE_COND to DEST if OP of the
   operands of the last comparison is nonzero/true, FALSE_COND if it is
   zero/false.  Return 0 if the hardware has no such operation.  */

static int
rs6000_emit_p9_fp_cmove (rtx dest, rtx op, rtx true_cond, rtx false_cond)
{
  enum rtx_code code = GET_CODE (op);
  rtx op0 = XEXP (op, 0);
  rtx op1 = XEXP (op, 1);
  machine_mode result_mode = GET_MODE (dest);
  rtx compare_rtx;
  rtx cmove_rtx;
  rtx clobber_rtx;

  if (!can_create_pseudo_p ())
    return 0;

  switch (code)
    {
    case EQ:
    case GE:
    case GT:
      break;

    case NE:
    case LT:
    case LE:
      code = swap_condition (code);
      std::swap (op0, op1);
      break;

    default:
      return 0;
    }

  /* Generate:	[(parallel [(set (dest)
				 (if_then_else (op (cmp1) (cmp2))
					       (true)
					       (false)))
			    (clobber (scratch))])].  */

  compare_rtx = gen_rtx_fmt_ee (code, CCFPmode, op0, op1);
  cmove_rtx = gen_rtx_SET (dest,
			   gen_rtx_IF_THEN_ELSE (result_mode,
						 compare_rtx,
						 true_cond,
						 false_cond));

  clobber_rtx = gen_rtx_CLOBBER (VOIDmode, gen_rtx_SCRATCH (V2DImode));
  emit_insn (gen_rtx_PARALLEL (VOIDmode,
			       gen_rtvec (2, cmove_rtx, clobber_rtx)));

  return 1;
}

/* Emit a conditional move: move TRUE_COND to DEST if OP of the
   operands of the last comparison is nonzero/true, FALSE_COND if it
   is zero/false.  Return 0 if the hardware has no such operation.  */

int
rs6000_emit_cmove (rtx dest, rtx op, rtx true_cond, rtx false_cond)
{
  enum rtx_code code = GET_CODE (op);
  rtx op0 = XEXP (op, 0);
  rtx op1 = XEXP (op, 1);
  machine_mode compare_mode = GET_MODE (op0);
  machine_mode result_mode = GET_MODE (dest);
  rtx temp;
  bool is_against_zero;

  /* These modes should always match.  */
  if (GET_MODE (op1) != compare_mode
      /* In the isel case however, we can use a compare immediate, so
	 op1 may be a small constant.  */
      && (!TARGET_ISEL || !short_cint_operand (op1, VOIDmode)))
    return 0;
  if (GET_MODE (true_cond) != result_mode)
    return 0;
  if (GET_MODE (false_cond) != result_mode)
    return 0;

  /* See if we can use the ISA 3.0 (power9) min/max/compare functions.  */
  if (TARGET_P9_MINMAX
      && (compare_mode == SFmode || compare_mode == DFmode)
      && (result_mode == SFmode || result_mode == DFmode))
    {
      if (rs6000_emit_p9_fp_minmax (dest, op, true_cond, false_cond))
	return 1;

      if (rs6000_emit_p9_fp_cmove (dest, op, true_cond, false_cond))
	return 1;
    }

  /* Don't allow using floating point comparisons for integer results for
     now.  */
  if (FLOAT_MODE_P (compare_mode) && !FLOAT_MODE_P (result_mode))
    return 0;

  /* First, work out if the hardware can do this at all, or
     if it's too slow....  */
  if (!FLOAT_MODE_P (compare_mode))
    {
      if (TARGET_ISEL)
	return rs6000_emit_int_cmove (dest, op, true_cond, false_cond);
      return 0;
    }

  is_against_zero = op1 == CONST0_RTX (compare_mode);

  /* A floating-point subtract might overflow, underflow, or produce
     an inexact result, thus changing the floating-point flags, so it
     can't be generated if we care about that.  It's safe if one side
     of the construct is zero, since then no subtract will be
     generated.  */
  if (SCALAR_FLOAT_MODE_P (compare_mode)
      && flag_trapping_math && ! is_against_zero)
    return 0;

  /* Eliminate half of the comparisons by switching operands, this
     makes the remaining code simpler.  */
  if (code == UNLT || code == UNGT || code == UNORDERED || code == NE
      || code == LTGT || code == LT || code == UNLE)
    {
      code = reverse_condition_maybe_unordered (code);
      temp = true_cond;
      true_cond = false_cond;
      false_cond = temp;
    }

  /* UNEQ and LTGT take four instructions for a comparison with zero,
     it'll probably be faster to use a branch here too.  */
  if (code == UNEQ && HONOR_NANS (compare_mode))
    return 0;

  /* We're going to try to implement comparisons by performing
     a subtract, then comparing against zero.  Unfortunately,
     Inf - Inf is NaN which is not zero, and so if we don't
     know that the operand is finite and the comparison
     would treat EQ different to UNORDERED, we can't do it.  */
  if (HONOR_INFINITIES (compare_mode)
      && code != GT && code != UNGE
      && (!CONST_DOUBLE_P (op1)
	  || real_isinf (CONST_DOUBLE_REAL_VALUE (op1)))
      /* Constructs of the form (a OP b ? a : b) are safe.  */
      && ((! rtx_equal_p (op0, false_cond) && ! rtx_equal_p (op1, false_cond))
	  || (! rtx_equal_p (op0, true_cond)
	      && ! rtx_equal_p (op1, true_cond))))
    return 0;

  /* At this point we know we can use fsel.  */

  /* Reduce the comparison to a comparison against zero.  */
  if (! is_against_zero)
    {
      temp = gen_reg_rtx (compare_mode);
      emit_insn (gen_rtx_SET (temp, gen_rtx_MINUS (compare_mode, op0, op1)));
      op0 = temp;
      op1 = CONST0_RTX (compare_mode);
    }

  /* If we don't care about NaNs we can reduce some of the comparisons
     down to faster ones.  */
  if (! HONOR_NANS (compare_mode))
    switch (code)
      {
      case GT:
	code = LE;
	temp = true_cond;
	true_cond = false_cond;
	false_cond = temp;
	break;
      case UNGE:
	code = GE;
	break;
      case UNEQ:
	code = EQ;
	break;
      default:
	break;
      }

  /* Now, reduce everything down to a GE.  */
  switch (code)
    {
    case GE:
      break;

    case LE:
      temp = gen_reg_rtx (compare_mode);
      emit_insn (gen_rtx_SET (temp, gen_rtx_NEG (compare_mode, op0)));
      op0 = temp;
      break;

    case ORDERED:
      temp = gen_reg_rtx (compare_mode);
      emit_insn (gen_rtx_SET (temp, gen_rtx_ABS (compare_mode, op0)));
      op0 = temp;
      break;

    case EQ:
      temp = gen_reg_rtx (compare_mode);
      emit_insn (gen_rtx_SET (temp,
			      gen_rtx_NEG (compare_mode,
					   gen_rtx_ABS (compare_mode, op0))));
      op0 = temp;
      break;

    case UNGE:
      /* a UNGE 0 <-> (a GE 0 || -a UNLT 0) */
      temp = gen_reg_rtx (result_mode);
      emit_insn (gen_rtx_SET (temp,
			      gen_rtx_IF_THEN_ELSE (result_mode,
						    gen_rtx_GE (VOIDmode,
								op0, op1),
						    true_cond, false_cond)));
      false_cond = true_cond;
      true_cond = temp;

      temp = gen_reg_rtx (compare_mode);
      emit_insn (gen_rtx_SET (temp, gen_rtx_NEG (compare_mode, op0)));
      op0 = temp;
      break;

    case GT:
      /* a GT 0 <-> (a GE 0 && -a UNLT 0) */
      temp = gen_reg_rtx (result_mode);
      emit_insn (gen_rtx_SET (temp,
			      gen_rtx_IF_THEN_ELSE (result_mode,
						    gen_rtx_GE (VOIDmode,
								op0, op1),
						    true_cond, false_cond)));
      true_cond = false_cond;
      false_cond = temp;

      temp = gen_reg_rtx (compare_mode);
      emit_insn (gen_rtx_SET (temp, gen_rtx_NEG (compare_mode, op0)));
      op0 = temp;
      break;

    default:
      gcc_unreachable ();
    }

  emit_insn (gen_rtx_SET (dest,
			  gen_rtx_IF_THEN_ELSE (result_mode,
						gen_rtx_GE (VOIDmode,
							    op0, op1),
						true_cond, false_cond)));
  return 1;
}

/* Same as above, but for ints (isel).  */

int
rs6000_emit_int_cmove (rtx dest, rtx op, rtx true_cond, rtx false_cond)
{
  rtx condition_rtx, cr;
  machine_mode mode = GET_MODE (dest);
  enum rtx_code cond_code;
  rtx (*isel_func) (rtx, rtx, rtx, rtx, rtx);
  bool signedp;

  if (mode != SImode && (!TARGET_POWERPC64 || mode != DImode))
    return 0;

  /* We still have to do the compare, because isel doesn't do a
     compare, it just looks at the CRx bits set by a previous compare
     instruction.  */
  condition_rtx = rs6000_generate_compare (op, mode);
  cond_code = GET_CODE (condition_rtx);
  cr = XEXP (condition_rtx, 0);
  signedp = GET_MODE (cr) == CCmode;

  isel_func = (mode == SImode
	       ? (signedp ? gen_isel_signed_si : gen_isel_unsigned_si)
	       : (signedp ? gen_isel_signed_di : gen_isel_unsigned_di));

  switch (cond_code)
    {
    case LT: case GT: case LTU: case GTU: case EQ:
      /* isel handles these directly.  */
      break;

    default:
      /* We need to swap the sense of the comparison.  */
      {
	std::swap (false_cond, true_cond);
	PUT_CODE (condition_rtx, reverse_condition (cond_code));
      }
      break;
    }

  false_cond = force_reg (mode, false_cond);
  if (true_cond != const0_rtx)
    true_cond = force_reg (mode, true_cond);

  emit_insn (isel_func (dest, condition_rtx, true_cond, false_cond, cr));

  return 1;
}

void
rs6000_emit_minmax (rtx dest, enum rtx_code code, rtx op0, rtx op1)
{
  machine_mode mode = GET_MODE (op0);
  enum rtx_code c;
  rtx target;

  /* VSX/altivec have direct min/max insns.  */
  if ((code == SMAX || code == SMIN)
      && (VECTOR_UNIT_ALTIVEC_OR_VSX_P (mode)
	  || (mode == SFmode && VECTOR_UNIT_VSX_P (DFmode))))
    {
      emit_insn (gen_rtx_SET (dest, gen_rtx_fmt_ee (code, mode, op0, op1)));
      return;
    }

  if (code == SMAX || code == SMIN)
    c = GE;
  else
    c = GEU;

  if (code == SMAX || code == UMAX)
    target = emit_conditional_move (dest, c, op0, op1, mode,
				    op0, op1, mode, 0);
  else
    target = emit_conditional_move (dest, c, op0, op1, mode,
				    op1, op0, mode, 0);
  gcc_assert (target);
  if (target != dest)
    emit_move_insn (dest, target);
}

/* A subroutine of the atomic operation splitters.  Jump to LABEL if
   COND is true.  Mark the jump as unlikely to be taken.  */

static void
emit_unlikely_jump (rtx cond, rtx label)
{
  rtx x = gen_rtx_IF_THEN_ELSE (VOIDmode, cond, label, pc_rtx);
  rtx_insn *insn = emit_jump_insn (gen_rtx_SET (pc_rtx, x));
  add_reg_br_prob_note (insn, profile_probability::very_unlikely ());
}

/* A subroutine of the atomic operation splitters.  Emit a load-locked
   instruction in MODE.  For QI/HImode, possibly use a pattern than includes
   the zero_extend operation.  */

static void
emit_load_locked (machine_mode mode, rtx reg, rtx mem)
{
  rtx (*fn) (rtx, rtx) = NULL;

  switch (mode)
    {
    case E_QImode:
      fn = gen_load_lockedqi;
      break;
    case E_HImode:
      fn = gen_load_lockedhi;
      break;
    case E_SImode:
      if (GET_MODE (mem) == QImode)
	fn = gen_load_lockedqi_si;
      else if (GET_MODE (mem) == HImode)
	fn = gen_load_lockedhi_si;
      else
	fn = gen_load_lockedsi;
      break;
    case E_DImode:
      fn = gen_load_lockeddi;
      break;
    case E_TImode:
      fn = gen_load_lockedti;
      break;
    default:
      gcc_unreachable ();
    }
  emit_insn (fn (reg, mem));
}

/* A subroutine of the atomic operation splitters.  Emit a store-conditional
   instruction in MODE.  */

static void
emit_store_conditional (machine_mode mode, rtx res, rtx mem, rtx val)
{
  rtx (*fn) (rtx, rtx, rtx) = NULL;

  switch (mode)
    {
    case E_QImode:
      fn = gen_store_conditionalqi;
      break;
    case E_HImode:
      fn = gen_store_conditionalhi;
      break;
    case E_SImode:
      fn = gen_store_conditionalsi;
      break;
    case E_DImode:
      fn = gen_store_conditionaldi;
      break;
    case E_TImode:
      fn = gen_store_conditionalti;
      break;
    default:
      gcc_unreachable ();
    }

  /* Emit sync before stwcx. to address PPC405 Erratum.  */
  if (PPC405_ERRATUM77)
    emit_insn (gen_hwsync ());

  emit_insn (fn (res, mem, val));
}

/* Expand barriers before and after a load_locked/store_cond sequence.  */

static rtx
rs6000_pre_atomic_barrier (rtx mem, enum memmodel model)
{
  rtx addr = XEXP (mem, 0);

  if (!legitimate_indirect_address_p (addr, reload_completed)
      && !legitimate_indexed_address_p (addr, reload_completed))
    {
      addr = force_reg (Pmode, addr);
      mem = replace_equiv_address_nv (mem, addr);
    }

  switch (model)
    {
    case MEMMODEL_RELAXED:
    case MEMMODEL_CONSUME:
    case MEMMODEL_ACQUIRE:
      break;
    case MEMMODEL_RELEASE:
    case MEMMODEL_ACQ_REL:
      emit_insn (gen_lwsync ());
      break;
    case MEMMODEL_SEQ_CST:
      emit_insn (gen_hwsync ());
      break;
    default:
      gcc_unreachable ();
    }
  return mem;
}

static void
rs6000_post_atomic_barrier (enum memmodel model)
{
  switch (model)
    {
    case MEMMODEL_RELAXED:
    case MEMMODEL_CONSUME:
    case MEMMODEL_RELEASE:
      break;
    case MEMMODEL_ACQUIRE:
    case MEMMODEL_ACQ_REL:
    case MEMMODEL_SEQ_CST:
      emit_insn (gen_isync ());
      break;
    default:
      gcc_unreachable ();
    }
}

/* A subroutine of the various atomic expanders.  For sub-word operations,
   we must adjust things to operate on SImode.  Given the original MEM,
   return a new aligned memory.  Also build and return the quantities by
   which to shift and mask.  */

static rtx
rs6000_adjust_atomic_subword (rtx orig_mem, rtx *pshift, rtx *pmask)
{
  rtx addr, align, shift, mask, mem;
  HOST_WIDE_INT shift_mask;
  machine_mode mode = GET_MODE (orig_mem);

  /* For smaller modes, we have to implement this via SImode.  */
  shift_mask = (mode == QImode ? 0x18 : 0x10);

  addr = XEXP (orig_mem, 0);
  addr = force_reg (GET_MODE (addr), addr);

  /* Aligned memory containing subword.  Generate a new memory.  We
     do not want any of the existing MEM_ATTR data, as we're now
     accessing memory outside the original object.  */
  align = expand_simple_binop (Pmode, AND, addr, GEN_INT (-4),
			       NULL_RTX, 1, OPTAB_LIB_WIDEN);
  mem = gen_rtx_MEM (SImode, align);
  MEM_VOLATILE_P (mem) = MEM_VOLATILE_P (orig_mem);
  if (MEM_ALIAS_SET (orig_mem) == ALIAS_SET_MEMORY_BARRIER)
    set_mem_alias_set (mem, ALIAS_SET_MEMORY_BARRIER);

  /* Shift amount for subword relative to aligned word.  */
  shift = gen_reg_rtx (SImode);
  addr = gen_lowpart (SImode, addr);
  rtx tmp = gen_reg_rtx (SImode);
  emit_insn (gen_ashlsi3 (tmp, addr, GEN_INT (3)));
  emit_insn (gen_andsi3 (shift, tmp, GEN_INT (shift_mask)));
  if (BYTES_BIG_ENDIAN)
    shift = expand_simple_binop (SImode, XOR, shift, GEN_INT (shift_mask),
			         shift, 1, OPTAB_LIB_WIDEN);
  *pshift = shift;

  /* Mask for insertion.  */
  mask = expand_simple_binop (SImode, ASHIFT, GEN_INT (GET_MODE_MASK (mode)),
			      shift, NULL_RTX, 1, OPTAB_LIB_WIDEN);
  *pmask = mask;

  return mem;
}

/* A subroutine of the various atomic expanders.  For sub-word operands,
   combine OLDVAL and NEWVAL via MASK.  Returns a new pseduo.  */

static rtx
rs6000_mask_atomic_subword (rtx oldval, rtx newval, rtx mask)
{
  rtx x;

  x = gen_reg_rtx (SImode);
  emit_insn (gen_rtx_SET (x, gen_rtx_AND (SImode,
					  gen_rtx_NOT (SImode, mask),
					  oldval)));

  x = expand_simple_binop (SImode, IOR, newval, x, x, 1, OPTAB_LIB_WIDEN);

  return x;
}

/* A subroutine of the various atomic expanders.  For sub-word operands,
   extract WIDE to NARROW via SHIFT.  */

static void
rs6000_finish_atomic_subword (rtx narrow, rtx wide, rtx shift)
{
  wide = expand_simple_binop (SImode, LSHIFTRT, wide, shift,
			      wide, 1, OPTAB_LIB_WIDEN);
  emit_move_insn (narrow, gen_lowpart (GET_MODE (narrow), wide));
}

/* Expand an atomic compare and swap operation.  */

void
rs6000_expand_atomic_compare_and_swap (rtx operands[])
{
  rtx boolval, retval, mem, oldval, newval, cond;
  rtx label1, label2, x, mask, shift;
  machine_mode mode, orig_mode;
  enum memmodel mod_s, mod_f;
  bool is_weak;

  boolval = operands[0];
  retval = operands[1];
  mem = operands[2];
  oldval = operands[3];
  newval = operands[4];
  is_weak = (INTVAL (operands[5]) != 0);
  mod_s = memmodel_base (INTVAL (operands[6]));
  mod_f = memmodel_base (INTVAL (operands[7]));
  orig_mode = mode = GET_MODE (mem);

  mask = shift = NULL_RTX;
  if (mode == QImode || mode == HImode)
    {
      /* Before power8, we didn't have access to lbarx/lharx, so generate a
	 lwarx and shift/mask operations.  With power8, we need to do the
	 comparison in SImode, but the store is still done in QI/HImode.  */
      oldval = convert_modes (SImode, mode, oldval, 1);

      if (!TARGET_SYNC_HI_QI)
	{
	  mem = rs6000_adjust_atomic_subword (mem, &shift, &mask);

	  /* Shift and mask OLDVAL into position with the word.  */
	  oldval = expand_simple_binop (SImode, ASHIFT, oldval, shift,
					NULL_RTX, 1, OPTAB_LIB_WIDEN);

	  /* Shift and mask NEWVAL into position within the word.  */
	  newval = convert_modes (SImode, mode, newval, 1);
	  newval = expand_simple_binop (SImode, ASHIFT, newval, shift,
					NULL_RTX, 1, OPTAB_LIB_WIDEN);
	}

      /* Prepare to adjust the return value.  */
      retval = gen_reg_rtx (SImode);
      mode = SImode;
    }
  else if (reg_overlap_mentioned_p (retval, oldval))
    oldval = copy_to_reg (oldval);

  if (mode != TImode && !reg_or_short_operand (oldval, mode))
    oldval = copy_to_mode_reg (mode, oldval);

  if (reg_overlap_mentioned_p (retval, newval))
    newval = copy_to_reg (newval);

  mem = rs6000_pre_atomic_barrier (mem, mod_s);

  label1 = NULL_RTX;
  if (!is_weak)
    {
      label1 = gen_rtx_LABEL_REF (VOIDmode, gen_label_rtx ());
      emit_label (XEXP (label1, 0));
    }
  label2 = gen_rtx_LABEL_REF (VOIDmode, gen_label_rtx ());

  emit_load_locked (mode, retval, mem);

  x = retval;
  if (mask)
    x = expand_simple_binop (SImode, AND, retval, mask,
			     NULL_RTX, 1, OPTAB_LIB_WIDEN);

  cond = gen_reg_rtx (CCmode);
  /* If we have TImode, synthesize a comparison.  */
  if (mode != TImode)
    x = gen_rtx_COMPARE (CCmode, x, oldval);
  else
    {
      rtx xor1_result = gen_reg_rtx (DImode);
      rtx xor2_result = gen_reg_rtx (DImode);
      rtx or_result = gen_reg_rtx (DImode);
      rtx new_word0 = simplify_gen_subreg (DImode, x, TImode, 0);
      rtx new_word1 = simplify_gen_subreg (DImode, x, TImode, 8);
      rtx old_word0 = simplify_gen_subreg (DImode, oldval, TImode, 0);
      rtx old_word1 = simplify_gen_subreg (DImode, oldval, TImode, 8);

      emit_insn (gen_xordi3 (xor1_result, new_word0, old_word0));
      emit_insn (gen_xordi3 (xor2_result, new_word1, old_word1));
      emit_insn (gen_iordi3 (or_result, xor1_result, xor2_result));
      x = gen_rtx_COMPARE (CCmode, or_result, const0_rtx);
    }

  emit_insn (gen_rtx_SET (cond, x));

  x = gen_rtx_NE (VOIDmode, cond, const0_rtx);
  emit_unlikely_jump (x, label2);

  x = newval;
  if (mask)
    x = rs6000_mask_atomic_subword (retval, newval, mask);

  emit_store_conditional (orig_mode, cond, mem, x);

  if (!is_weak)
    {
      x = gen_rtx_NE (VOIDmode, cond, const0_rtx);
      emit_unlikely_jump (x, label1);
    }

  if (!is_mm_relaxed (mod_f))
    emit_label (XEXP (label2, 0));

  rs6000_post_atomic_barrier (mod_s);

  if (is_mm_relaxed (mod_f))
    emit_label (XEXP (label2, 0));

  if (shift)
    rs6000_finish_atomic_subword (operands[1], retval, shift);
  else if (mode != GET_MODE (operands[1]))
    convert_move (operands[1], retval, 1);

  /* In all cases, CR0 contains EQ on success, and NE on failure.  */
  x = gen_rtx_EQ (SImode, cond, const0_rtx);
  emit_insn (gen_rtx_SET (boolval, x));
}

/* Expand an atomic exchange operation.  */

void
rs6000_expand_atomic_exchange (rtx operands[])
{
  rtx retval, mem, val, cond;
  machine_mode mode;
  enum memmodel model;
  rtx label, x, mask, shift;

  retval = operands[0];
  mem = operands[1];
  val = operands[2];
  model = memmodel_base (INTVAL (operands[3]));
  mode = GET_MODE (mem);

  mask = shift = NULL_RTX;
  if (!TARGET_SYNC_HI_QI && (mode == QImode || mode == HImode))
    {
      mem = rs6000_adjust_atomic_subword (mem, &shift, &mask);

      /* Shift and mask VAL into position with the word.  */
      val = convert_modes (SImode, mode, val, 1);
      val = expand_simple_binop (SImode, ASHIFT, val, shift,
				 NULL_RTX, 1, OPTAB_LIB_WIDEN);

      /* Prepare to adjust the return value.  */
      retval = gen_reg_rtx (SImode);
      mode = SImode;
    }

  mem = rs6000_pre_atomic_barrier (mem, model);

  label = gen_rtx_LABEL_REF (VOIDmode, gen_label_rtx ());
  emit_label (XEXP (label, 0));

  emit_load_locked (mode, retval, mem);

  x = val;
  if (mask)
    x = rs6000_mask_atomic_subword (retval, val, mask);

  cond = gen_reg_rtx (CCmode);
  emit_store_conditional (mode, cond, mem, x);

  x = gen_rtx_NE (VOIDmode, cond, const0_rtx);
  emit_unlikely_jump (x, label);

  rs6000_post_atomic_barrier (model);

  if (shift)
    rs6000_finish_atomic_subword (operands[0], retval, shift);
}

/* Expand an atomic fetch-and-operate pattern.  CODE is the binary operation
   to perform.  MEM is the memory on which to operate.  VAL is the second
   operand of the binary operator.  BEFORE and AFTER are optional locations to
   return the value of MEM either before of after the operation.  MODEL_RTX
   is a CONST_INT containing the memory model to use.  */

void
rs6000_expand_atomic_op (enum rtx_code code, rtx mem, rtx val,
			 rtx orig_before, rtx orig_after, rtx model_rtx)
{
  enum memmodel model = memmodel_base (INTVAL (model_rtx));
  machine_mode mode = GET_MODE (mem);
  machine_mode store_mode = mode;
  rtx label, x, cond, mask, shift;
  rtx before = orig_before, after = orig_after;

  mask = shift = NULL_RTX;
  /* On power8, we want to use SImode for the operation.  On previous systems,
     use the operation in a subword and shift/mask to get the proper byte or
     halfword.  */
  if (mode == QImode || mode == HImode)
    {
      if (TARGET_SYNC_HI_QI)
	{
	  val = convert_modes (SImode, mode, val, 1);

	  /* Prepare to adjust the return value.  */
	  before = gen_reg_rtx (SImode);
	  if (after)
	    after = gen_reg_rtx (SImode);
	  mode = SImode;
	}
      else
	{
	  mem = rs6000_adjust_atomic_subword (mem, &shift, &mask);

	  /* Shift and mask VAL into position with the word.  */
	  val = convert_modes (SImode, mode, val, 1);
	  val = expand_simple_binop (SImode, ASHIFT, val, shift,
				     NULL_RTX, 1, OPTAB_LIB_WIDEN);

	  switch (code)
	    {
	    case IOR:
	    case XOR:
	      /* We've already zero-extended VAL.  That is sufficient to
		 make certain that it does not affect other bits.  */
	      mask = NULL;
	      break;

	    case AND:
	      /* If we make certain that all of the other bits in VAL are
		 set, that will be sufficient to not affect other bits.  */
	      x = gen_rtx_NOT (SImode, mask);
	      x = gen_rtx_IOR (SImode, x, val);
	      emit_insn (gen_rtx_SET (val, x));
	      mask = NULL;
	      break;

	    case NOT:
	    case PLUS:
	    case MINUS:
	      /* These will all affect bits outside the field and need
		 adjustment via MASK within the loop.  */
	      break;

	    default:
	      gcc_unreachable ();
	    }

	  /* Prepare to adjust the return value.  */
	  before = gen_reg_rtx (SImode);
	  if (after)
	    after = gen_reg_rtx (SImode);
	  store_mode = mode = SImode;
	}
    }

  mem = rs6000_pre_atomic_barrier (mem, model);

  label = gen_label_rtx ();
  emit_label (label);
  label = gen_rtx_LABEL_REF (VOIDmode, label);

  if (before == NULL_RTX)
    before = gen_reg_rtx (mode);

  emit_load_locked (mode, before, mem);

  if (code == NOT)
    {
      x = expand_simple_binop (mode, AND, before, val,
			       NULL_RTX, 1, OPTAB_LIB_WIDEN);
      after = expand_simple_unop (mode, NOT, x, after, 1);
    }
  else
    {
      after = expand_simple_binop (mode, code, before, val,
				   after, 1, OPTAB_LIB_WIDEN);
    }

  x = after;
  if (mask)
    {
      x = expand_simple_binop (SImode, AND, after, mask,
			       NULL_RTX, 1, OPTAB_LIB_WIDEN);
      x = rs6000_mask_atomic_subword (before, x, mask);
    }
  else if (store_mode != mode)
    x = convert_modes (store_mode, mode, x, 1);

  cond = gen_reg_rtx (CCmode);
  emit_store_conditional (store_mode, cond, mem, x);

  x = gen_rtx_NE (VOIDmode, cond, const0_rtx);
  emit_unlikely_jump (x, label);

  rs6000_post_atomic_barrier (model);

  if (shift)
    {
      /* QImode/HImode on machines without lbarx/lharx where we do a lwarx and
	 then do the calcuations in a SImode register.  */
      if (orig_before)
	rs6000_finish_atomic_subword (orig_before, before, shift);
      if (orig_after)
	rs6000_finish_atomic_subword (orig_after, after, shift);
    }
  else if (store_mode != mode)
    {
      /* QImode/HImode on machines with lbarx/lharx where we do the native
	 operation and then do the calcuations in a SImode register.  */
      if (orig_before)
	convert_move (orig_before, before, 1);
      if (orig_after)
	convert_move (orig_after, after, 1);
    }
  else if (orig_after && after != orig_after)
    emit_move_insn (orig_after, after);
}

/* Emit instructions to move SRC to DST.  Called by splitters for
   multi-register moves.  It will emit at most one instruction for
   each register that is accessed; that is, it won't emit li/lis pairs
   (or equivalent for 64-bit code).  One of SRC or DST must be a hard
   register.  */

void
rs6000_split_multireg_move (rtx dst, rtx src)
{
  /* The register number of the first register being moved.  */
  int reg;
  /* The mode that is to be moved.  */
  machine_mode mode;
  /* The mode that the move is being done in, and its size.  */
  machine_mode reg_mode;
  int reg_mode_size;
  /* The number of registers that will be moved.  */
  int nregs;

  reg = REG_P (dst) ? REGNO (dst) : REGNO (src);
  mode = GET_MODE (dst);
  nregs = hard_regno_nregs (reg, mode);
  if (FP_REGNO_P (reg))
    reg_mode = DECIMAL_FLOAT_MODE_P (mode) ? DDmode :
	(TARGET_HARD_FLOAT ? DFmode : SFmode);
  else if (ALTIVEC_REGNO_P (reg))
    reg_mode = V16QImode;
  else
    reg_mode = word_mode;
  reg_mode_size = GET_MODE_SIZE (reg_mode);

  gcc_assert (reg_mode_size * nregs == GET_MODE_SIZE (mode));

  /* TDmode residing in FP registers is special, since the ISA requires that
     the lower-numbered word of a register pair is always the most significant
     word, even in little-endian mode.  This does not match the usual subreg
     semantics, so we cannnot use simplify_gen_subreg in those cases.  Access
     the appropriate constituent registers "by hand" in little-endian mode.

     Note we do not need to check for destructive overlap here since TDmode
     can only reside in even/odd register pairs.  */
  if (FP_REGNO_P (reg) && DECIMAL_FLOAT_MODE_P (mode) && !BYTES_BIG_ENDIAN)
    {
      rtx p_src, p_dst;
      int i;

      for (i = 0; i < nregs; i++)
	{
	  if (REG_P (src) && FP_REGNO_P (REGNO (src)))
	    p_src = gen_rtx_REG (reg_mode, REGNO (src) + nregs - 1 - i);
	  else
	    p_src = simplify_gen_subreg (reg_mode, src, mode,
					 i * reg_mode_size);

	  if (REG_P (dst) && FP_REGNO_P (REGNO (dst)))
	    p_dst = gen_rtx_REG (reg_mode, REGNO (dst) + nregs - 1 - i);
	  else
	    p_dst = simplify_gen_subreg (reg_mode, dst, mode,
					 i * reg_mode_size);

	  emit_insn (gen_rtx_SET (p_dst, p_src));
	}

      return;
    }

  if (REG_P (src) && REG_P (dst) && (REGNO (src) < REGNO (dst)))
    {
      /* Move register range backwards, if we might have destructive
	 overlap.  */
      int i;
      for (i = nregs - 1; i >= 0; i--)
	emit_insn (gen_rtx_SET (simplify_gen_subreg (reg_mode, dst, mode,
						     i * reg_mode_size),
				simplify_gen_subreg (reg_mode, src, mode,
						     i * reg_mode_size)));
    }
  else
    {
      int i;
      int j = -1;
      bool used_update = false;
      rtx restore_basereg = NULL_RTX;

      if (MEM_P (src) && INT_REGNO_P (reg))
	{
	  rtx breg;

	  if (GET_CODE (XEXP (src, 0)) == PRE_INC
	      || GET_CODE (XEXP (src, 0)) == PRE_DEC)
	    {
	      rtx delta_rtx;
	      breg = XEXP (XEXP (src, 0), 0);
	      delta_rtx = (GET_CODE (XEXP (src, 0)) == PRE_INC
			   ? GEN_INT (GET_MODE_SIZE (GET_MODE (src)))
			   : GEN_INT (-GET_MODE_SIZE (GET_MODE (src))));
	      emit_insn (gen_add3_insn (breg, breg, delta_rtx));
	      src = replace_equiv_address (src, breg);
	    }
	  else if (! rs6000_offsettable_memref_p (src, reg_mode, true))
	    {
	      if (GET_CODE (XEXP (src, 0)) == PRE_MODIFY)
		{
		  rtx basereg = XEXP (XEXP (src, 0), 0);
		  if (TARGET_UPDATE)
		    {
		      rtx ndst = simplify_gen_subreg (reg_mode, dst, mode, 0);
		      emit_insn (gen_rtx_SET (ndst,
					      gen_rtx_MEM (reg_mode,
							   XEXP (src, 0))));
		      used_update = true;
		    }
		  else
		    emit_insn (gen_rtx_SET (basereg,
					    XEXP (XEXP (src, 0), 1)));
		  src = replace_equiv_address (src, basereg);
		}
	      else
		{
		  rtx basereg = gen_rtx_REG (Pmode, reg);
		  emit_insn (gen_rtx_SET (basereg, XEXP (src, 0)));
		  src = replace_equiv_address (src, basereg);
		}
	    }

	  breg = XEXP (src, 0);
	  if (GET_CODE (breg) == PLUS || GET_CODE (breg) == LO_SUM)
	    breg = XEXP (breg, 0);

	  /* If the base register we are using to address memory is
	     also a destination reg, then change that register last.  */
	  if (REG_P (breg)
	      && REGNO (breg) >= REGNO (dst)
	      && REGNO (breg) < REGNO (dst) + nregs)
	    j = REGNO (breg) - REGNO (dst);
	}
      else if (MEM_P (dst) && INT_REGNO_P (reg))
	{
	  rtx breg;

	  if (GET_CODE (XEXP (dst, 0)) == PRE_INC
	      || GET_CODE (XEXP (dst, 0)) == PRE_DEC)
	    {
	      rtx delta_rtx;
	      breg = XEXP (XEXP (dst, 0), 0);
	      delta_rtx = (GET_CODE (XEXP (dst, 0)) == PRE_INC
			   ? GEN_INT (GET_MODE_SIZE (GET_MODE (dst)))
			   : GEN_INT (-GET_MODE_SIZE (GET_MODE (dst))));

	      /* We have to update the breg before doing the store.
		 Use store with update, if available.  */

	      if (TARGET_UPDATE)
		{
		  rtx nsrc = simplify_gen_subreg (reg_mode, src, mode, 0);
		  emit_insn (TARGET_32BIT
			     ? (TARGET_POWERPC64
				? gen_movdi_si_update (breg, breg, delta_rtx, nsrc)
				: gen_movsi_si_update (breg, breg, delta_rtx, nsrc))
			     : gen_movdi_di_update (breg, breg, delta_rtx, nsrc));
		  used_update = true;
		}
	      else
		emit_insn (gen_add3_insn (breg, breg, delta_rtx));
	      dst = replace_equiv_address (dst, breg);
	    }
	  else if (!rs6000_offsettable_memref_p (dst, reg_mode, true)
		   && GET_CODE (XEXP (dst, 0)) != LO_SUM)
	    {
	      if (GET_CODE (XEXP (dst, 0)) == PRE_MODIFY)
		{
		  rtx basereg = XEXP (XEXP (dst, 0), 0);
		  if (TARGET_UPDATE)
		    {
		      rtx nsrc = simplify_gen_subreg (reg_mode, src, mode, 0);
		      emit_insn (gen_rtx_SET (gen_rtx_MEM (reg_mode,
							   XEXP (dst, 0)),
					      nsrc));
		      used_update = true;
		    }
		  else
		    emit_insn (gen_rtx_SET (basereg,
					    XEXP (XEXP (dst, 0), 1)));
		  dst = replace_equiv_address (dst, basereg);
		}
	      else
		{
		  rtx basereg = XEXP (XEXP (dst, 0), 0);
		  rtx offsetreg = XEXP (XEXP (dst, 0), 1);
		  gcc_assert (GET_CODE (XEXP (dst, 0)) == PLUS
			      && REG_P (basereg)
			      && REG_P (offsetreg)
			      && REGNO (basereg) != REGNO (offsetreg));
		  if (REGNO (basereg) == 0)
		    {
		      rtx tmp = offsetreg;
		      offsetreg = basereg;
		      basereg = tmp;
		    }
		  emit_insn (gen_add3_insn (basereg, basereg, offsetreg));
		  restore_basereg = gen_sub3_insn (basereg, basereg, offsetreg);
		  dst = replace_equiv_address (dst, basereg);
		}
	    }
	  else if (GET_CODE (XEXP (dst, 0)) != LO_SUM)
	    gcc_assert (rs6000_offsettable_memref_p (dst, reg_mode, true));
	}

      for (i = 0; i < nregs; i++)
	{
	  /* Calculate index to next subword.  */
	  ++j;
	  if (j == nregs)
	    j = 0;

	  /* If compiler already emitted move of first word by
	     store with update, no need to do anything.  */
	  if (j == 0 && used_update)
	    continue;

	  emit_insn (gen_rtx_SET (simplify_gen_subreg (reg_mode, dst, mode,
						       j * reg_mode_size),
				  simplify_gen_subreg (reg_mode, src, mode,
						       j * reg_mode_size)));
	}
      if (restore_basereg != NULL_RTX)
	emit_insn (restore_basereg);
    }
}


/* This page contains routines that are used to determine what the
   function prologue and epilogue code will do and write them out.  */

/* Determine whether the REG is really used.  */

static bool
save_reg_p (int reg)
{
  if (reg == RS6000_PIC_OFFSET_TABLE_REGNUM && !TARGET_SINGLE_PIC_BASE)
    {
      /* When calling eh_return, we must return true for all the cases
	 where conditional_register_usage marks the PIC offset reg
	 call used or fixed.  */
      if (crtl->calls_eh_return
	  && ((DEFAULT_ABI == ABI_V4 && flag_pic)
	      || (DEFAULT_ABI == ABI_DARWIN && flag_pic)
	      || (TARGET_TOC && TARGET_MINIMAL_TOC)))
	return true;

      /* We need to mark the PIC offset register live for the same
	 conditions as it is set up in rs6000_emit_prologue, or
	 otherwise it won't be saved before we clobber it.  */
      if (TARGET_TOC && TARGET_MINIMAL_TOC
	  && !constant_pool_empty_p ())
	return true;

      if (DEFAULT_ABI == ABI_V4
	  && (flag_pic == 1 || (flag_pic && TARGET_SECURE_PLT))
	  && df_regs_ever_live_p (RS6000_PIC_OFFSET_TABLE_REGNUM))
	return true;

      if (DEFAULT_ABI == ABI_DARWIN
	  && flag_pic && crtl->uses_pic_offset_table)
	return true;
    }

  return !call_used_regs[reg] && df_regs_ever_live_p (reg);
}

/* Return the first fixed-point register that is required to be
   saved. 32 if none.  */

int
first_reg_to_save (void)
{
  int first_reg;

  /* Find lowest numbered live register.  */
  for (first_reg = 13; first_reg <= 31; first_reg++)
    if (save_reg_p (first_reg))
      break;

  return first_reg;
}

/* Similar, for FP regs.  */

int
first_fp_reg_to_save (void)
{
  int first_reg;

  /* Find lowest numbered live register.  */
  for (first_reg = 14 + 32; first_reg <= 63; first_reg++)
    if (save_reg_p (first_reg))
      break;

  return first_reg;
}

/* Similar, for AltiVec regs.  */

static int
first_altivec_reg_to_save (void)
{
  int i;

  /* Stack frame remains as is unless we are in AltiVec ABI.  */
  if (! TARGET_ALTIVEC_ABI)
    return LAST_ALTIVEC_REGNO + 1;

  /* On Darwin, the unwind routines are compiled without
     TARGET_ALTIVEC, and use save_world to save/restore the
     altivec registers when necessary.  */
  if (DEFAULT_ABI == ABI_DARWIN && crtl->calls_eh_return
      && ! TARGET_ALTIVEC)
    return FIRST_ALTIVEC_REGNO + 20;

  /* Find lowest numbered live register.  */
  for (i = FIRST_ALTIVEC_REGNO + 20; i <= LAST_ALTIVEC_REGNO; ++i)
    if (save_reg_p (i))
      break;

  return i;
}

/* Return a 32-bit mask of the AltiVec registers we need to set in
   VRSAVE.  Bit n of the return value is 1 if Vn is live.  The MSB in
   the 32-bit word is 0.  */

static unsigned int
compute_vrsave_mask (void)
{
  unsigned int i, mask = 0;

  /* On Darwin, the unwind routines are compiled without
     TARGET_ALTIVEC, and use save_world to save/restore the
     call-saved altivec registers when necessary.  */
  if (DEFAULT_ABI == ABI_DARWIN && crtl->calls_eh_return
      && ! TARGET_ALTIVEC)
    mask |= 0xFFF;

  /* First, find out if we use _any_ altivec registers.  */
  for (i = FIRST_ALTIVEC_REGNO; i <= LAST_ALTIVEC_REGNO; ++i)
    if (df_regs_ever_live_p (i))
      mask |= ALTIVEC_REG_BIT (i);

  if (mask == 0)
    return mask;

  /* Next, remove the argument registers from the set.  These must
     be in the VRSAVE mask set by the caller, so we don't need to add
     them in again.  More importantly, the mask we compute here is
     used to generate CLOBBERs in the set_vrsave insn, and we do not
     wish the argument registers to die.  */
  for (i = ALTIVEC_ARG_MIN_REG; i < (unsigned) crtl->args.info.vregno; i++)
    mask &= ~ALTIVEC_REG_BIT (i);

  /* Similarly, remove the return value from the set.  */
  {
    bool yes = false;
    diddle_return_value (is_altivec_return_reg, &yes);
    if (yes)
      mask &= ~ALTIVEC_REG_BIT (ALTIVEC_ARG_RETURN);
  }

  return mask;
}

/* For a very restricted set of circumstances, we can cut down the
   size of prologues/epilogues by calling our own save/restore-the-world
   routines.  */

static void
compute_save_world_info (rs6000_stack_t *info)
{
  info->world_save_p = 1;
  info->world_save_p
    = (WORLD_SAVE_P (info)
       && DEFAULT_ABI == ABI_DARWIN
       && !cfun->has_nonlocal_label
       && info->first_fp_reg_save == FIRST_SAVED_FP_REGNO
       && info->first_gp_reg_save == FIRST_SAVED_GP_REGNO
       && info->first_altivec_reg_save == FIRST_SAVED_ALTIVEC_REGNO
       && info->cr_save_p);

  /* This will not work in conjunction with sibcalls.  Make sure there
     are none.  (This check is expensive, but seldom executed.) */
  if (WORLD_SAVE_P (info))
    {
      rtx_insn *insn;
      for (insn = get_last_insn_anywhere (); insn; insn = PREV_INSN (insn))
	if (CALL_P (insn) && SIBLING_CALL_P (insn))
	  {
	    info->world_save_p = 0;
	    break;
	  }
    }

  if (WORLD_SAVE_P (info))
    {
      /* Even if we're not touching VRsave, make sure there's room on the
	 stack for it, if it looks like we're calling SAVE_WORLD, which
	 will attempt to save it. */
      info->vrsave_size  = 4;

      /* If we are going to save the world, we need to save the link register too.  */
      info->lr_save_p = 1;

      /* "Save" the VRsave register too if we're saving the world.  */
      if (info->vrsave_mask == 0)
	info->vrsave_mask = compute_vrsave_mask ();

      /* Because the Darwin register save/restore routines only handle
	 F14 .. F31 and V20 .. V31 as per the ABI, perform a consistency
	 check.  */
      gcc_assert (info->first_fp_reg_save >= FIRST_SAVED_FP_REGNO
		  && (info->first_altivec_reg_save
		      >= FIRST_SAVED_ALTIVEC_REGNO));
    }

  return;
}


static void
is_altivec_return_reg (rtx reg, void *xyes)
{
  bool *yes = (bool *) xyes;
  if (REGNO (reg) == ALTIVEC_ARG_RETURN)
    *yes = true;
}


/* Return whether REG is a global user reg or has been specifed by
   -ffixed-REG.  We should not restore these, and so cannot use
   lmw or out-of-line restore functions if there are any.  We also
   can't save them (well, emit frame notes for them), because frame
   unwinding during exception handling will restore saved registers.  */

static bool
fixed_reg_p (int reg)
{
  /* Ignore fixed_regs[RS6000_PIC_OFFSET_TABLE_REGNUM] when the
     backend sets it, overriding anything the user might have given.  */
  if (reg == RS6000_PIC_OFFSET_TABLE_REGNUM
      && ((DEFAULT_ABI == ABI_V4 && flag_pic)
	  || (DEFAULT_ABI == ABI_DARWIN && flag_pic)
	  || (TARGET_TOC && TARGET_MINIMAL_TOC)))
    return false;

  return fixed_regs[reg];
}

/* Determine the strategy for savings/restoring registers.  */

enum {
  SAVE_MULTIPLE = 0x1,
  SAVE_INLINE_GPRS = 0x2,
  SAVE_INLINE_FPRS = 0x4,
  SAVE_NOINLINE_GPRS_SAVES_LR = 0x8,
  SAVE_NOINLINE_FPRS_SAVES_LR = 0x10,
  SAVE_INLINE_VRS = 0x20,
  REST_MULTIPLE = 0x100,
  REST_INLINE_GPRS = 0x200,
  REST_INLINE_FPRS = 0x400,
  REST_NOINLINE_FPRS_DOESNT_RESTORE_LR = 0x800,
  REST_INLINE_VRS = 0x1000
};

static int
rs6000_savres_strategy (rs6000_stack_t *info,
			bool using_static_chain_p)
{
  int strategy = 0;

  /* Select between in-line and out-of-line save and restore of regs.
     First, all the obvious cases where we don't use out-of-line.  */
  if (crtl->calls_eh_return
      || cfun->machine->ra_need_lr)
    strategy |= (SAVE_INLINE_FPRS | REST_INLINE_FPRS
		 | SAVE_INLINE_GPRS | REST_INLINE_GPRS
		 | SAVE_INLINE_VRS | REST_INLINE_VRS);

  if (info->first_gp_reg_save == 32)
    strategy |= SAVE_INLINE_GPRS | REST_INLINE_GPRS;

  if (info->first_fp_reg_save == 64)
    strategy |= SAVE_INLINE_FPRS | REST_INLINE_FPRS;

  if (info->first_altivec_reg_save == LAST_ALTIVEC_REGNO + 1)
    strategy |= SAVE_INLINE_VRS | REST_INLINE_VRS;

  /* Define cutoff for using out-of-line functions to save registers.  */
  if (DEFAULT_ABI == ABI_V4 || TARGET_ELF)
    {
      if (!optimize_size)
	{
	  strategy |= SAVE_INLINE_FPRS | REST_INLINE_FPRS;
	  strategy |= SAVE_INLINE_GPRS | REST_INLINE_GPRS;
	  strategy |= SAVE_INLINE_VRS | REST_INLINE_VRS;
	}
      else
	{
	  /* Prefer out-of-line restore if it will exit.  */
	  if (info->first_fp_reg_save > 61)
	    strategy |= SAVE_INLINE_FPRS;
	  if (info->first_gp_reg_save > 29)
	    {
	      if (info->first_fp_reg_save == 64)
		strategy |= SAVE_INLINE_GPRS;
	      else
		strategy |= SAVE_INLINE_GPRS | REST_INLINE_GPRS;
	    }
	  if (info->first_altivec_reg_save == LAST_ALTIVEC_REGNO)
	    strategy |= SAVE_INLINE_VRS | REST_INLINE_VRS;
	}
    }
  else if (DEFAULT_ABI == ABI_DARWIN)
    {
      if (info->first_fp_reg_save > 60)
	strategy |= SAVE_INLINE_FPRS | REST_INLINE_FPRS;
      if (info->first_gp_reg_save > 29)
	strategy |= SAVE_INLINE_GPRS | REST_INLINE_GPRS;
      strategy |= SAVE_INLINE_VRS | REST_INLINE_VRS;
    }
  else
    {
      gcc_checking_assert (DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2);
      if ((flag_shrink_wrap_separate && optimize_function_for_speed_p (cfun))
	  || info->first_fp_reg_save > 61)
	strategy |= SAVE_INLINE_FPRS | REST_INLINE_FPRS;
      strategy |= SAVE_INLINE_GPRS | REST_INLINE_GPRS;
      strategy |= SAVE_INLINE_VRS | REST_INLINE_VRS;
    }

  /* Don't bother to try to save things out-of-line if r11 is occupied
     by the static chain.  It would require too much fiddling and the
     static chain is rarely used anyway.  FPRs are saved w.r.t the stack
     pointer on Darwin, and AIX uses r1 or r12.  */
  if (using_static_chain_p
      && (DEFAULT_ABI == ABI_V4 || DEFAULT_ABI == ABI_DARWIN))
    strategy |= ((DEFAULT_ABI == ABI_DARWIN ? 0 : SAVE_INLINE_FPRS)
		 | SAVE_INLINE_GPRS
		 | SAVE_INLINE_VRS);

  /* Don't ever restore fixed regs.  That means we can't use the
     out-of-line register restore functions if a fixed reg is in the
     range of regs restored.   */
  if (!(strategy & REST_INLINE_FPRS))
    for (int i = info->first_fp_reg_save; i < 64; i++)
      if (fixed_regs[i])
	{
	  strategy |= REST_INLINE_FPRS;
	  break;
	}

  /* We can only use the out-of-line routines to restore fprs if we've
     saved all the registers from first_fp_reg_save in the prologue.
     Otherwise, we risk loading garbage.  Of course, if we have saved
     out-of-line then we know we haven't skipped any fprs.  */
  if ((strategy & SAVE_INLINE_FPRS)
      && !(strategy & REST_INLINE_FPRS))
    for (int i = info->first_fp_reg_save; i < 64; i++)
      if (!save_reg_p (i))
	{
	  strategy |= REST_INLINE_FPRS;
	  break;
	}

  /* Similarly, for altivec regs.  */
  if (!(strategy & REST_INLINE_VRS))
    for (int i = info->first_altivec_reg_save; i < LAST_ALTIVEC_REGNO + 1; i++)
      if (fixed_regs[i])
	{
	  strategy |= REST_INLINE_VRS;
	  break;
	}

  if ((strategy & SAVE_INLINE_VRS)
      && !(strategy & REST_INLINE_VRS))
    for (int i = info->first_altivec_reg_save; i < LAST_ALTIVEC_REGNO + 1; i++)
      if (!save_reg_p (i))
	{
	  strategy |= REST_INLINE_VRS;
	  break;
	}

  /* info->lr_save_p isn't yet set if the only reason lr needs to be
     saved is an out-of-line save or restore.  Set up the value for
     the next test (excluding out-of-line gprs).  */
  bool lr_save_p = (info->lr_save_p
		    || !(strategy & SAVE_INLINE_FPRS)
		    || !(strategy & SAVE_INLINE_VRS)
		    || !(strategy & REST_INLINE_FPRS)
		    || !(strategy & REST_INLINE_VRS));

  if (TARGET_MULTIPLE
      && !TARGET_POWERPC64
      && info->first_gp_reg_save < 31
      && !(flag_shrink_wrap
	   && flag_shrink_wrap_separate
	   && optimize_function_for_speed_p (cfun)))
    {
      int count = 0;
      for (int i = info->first_gp_reg_save; i < 32; i++)
	if (save_reg_p (i))
	  count++;

      if (count <= 1)
	/* Don't use store multiple if only one reg needs to be
	   saved.  This can occur for example when the ABI_V4 pic reg
	   (r30) needs to be saved to make calls, but r31 is not
	   used.  */
	strategy |= SAVE_INLINE_GPRS | REST_INLINE_GPRS;
      else
	{
	  /* Prefer store multiple for saves over out-of-line
	     routines, since the store-multiple instruction will
	     always be smaller.  */
	  strategy |= SAVE_INLINE_GPRS | SAVE_MULTIPLE;

	  /* The situation is more complicated with load multiple.
	     We'd prefer to use the out-of-line routines for restores,
	     since the "exit" out-of-line routines can handle the
	     restore of LR and the frame teardown.  However if doesn't
	     make sense to use the out-of-line routine if that is the
	     only reason we'd need to save LR, and we can't use the
	     "exit" out-of-line gpr restore if we have saved some
	     fprs; In those cases it is advantageous to use load
	     multiple when available.  */
	  if (info->first_fp_reg_save != 64 || !lr_save_p)
	    strategy |= REST_INLINE_GPRS | REST_MULTIPLE;
	}
    }

  /* Using the "exit" out-of-line routine does not improve code size
     if using it would require lr to be saved and if only saving one
     or two gprs.  */
  else if (!lr_save_p && info->first_gp_reg_save > 29)
    strategy |= SAVE_INLINE_GPRS | REST_INLINE_GPRS;

  /* Don't ever restore fixed regs.  */
  if ((strategy & (REST_INLINE_GPRS | REST_MULTIPLE)) != REST_INLINE_GPRS)
    for (int i = info->first_gp_reg_save; i < 32; i++)
      if (fixed_reg_p (i))
	{
	  strategy |= REST_INLINE_GPRS;
	  strategy &= ~REST_MULTIPLE;
	  break;
	}

  /* We can only use load multiple or the out-of-line routines to
     restore gprs if we've saved all the registers from
     first_gp_reg_save.  Otherwise, we risk loading garbage.
     Of course, if we have saved out-of-line or used stmw then we know
     we haven't skipped any gprs.  */
  if ((strategy & (SAVE_INLINE_GPRS | SAVE_MULTIPLE)) == SAVE_INLINE_GPRS
      && (strategy & (REST_INLINE_GPRS | REST_MULTIPLE)) != REST_INLINE_GPRS)
    for (int i = info->first_gp_reg_save; i < 32; i++)
      if (!save_reg_p (i))
	{
	  strategy |= REST_INLINE_GPRS;
	  strategy &= ~REST_MULTIPLE;
	  break;
	}

  if (TARGET_ELF && TARGET_64BIT)
    {
      if (!(strategy & SAVE_INLINE_FPRS))
	strategy |= SAVE_NOINLINE_FPRS_SAVES_LR;
      else if (!(strategy & SAVE_INLINE_GPRS)
	       && info->first_fp_reg_save == 64)
	strategy |= SAVE_NOINLINE_GPRS_SAVES_LR;
    }
  else if (TARGET_AIX && !(strategy & REST_INLINE_FPRS))
    strategy |= REST_NOINLINE_FPRS_DOESNT_RESTORE_LR;

  if (TARGET_MACHO && !(strategy & SAVE_INLINE_FPRS))
    strategy |= SAVE_NOINLINE_FPRS_SAVES_LR;

  return strategy;
}

/* Calculate the stack information for the current function.  This is
   complicated by having two separate calling sequences, the AIX calling
   sequence and the V.4 calling sequence.

   AIX (and Darwin/Mac OS X) stack frames look like:
							  32-bit  64-bit
	SP---->	+---------------------------------------+
		| back chain to caller			| 0	  0
		+---------------------------------------+
		| saved CR				| 4       8 (8-11)
		+---------------------------------------+
		| saved LR				| 8       16
		+---------------------------------------+
		| reserved for compilers		| 12      24
		+---------------------------------------+
		| reserved for binders			| 16      32
		+---------------------------------------+
		| saved TOC pointer			| 20      40
		+---------------------------------------+
		| Parameter save area (+padding*) (P)	| 24      48
		+---------------------------------------+
		| Alloca space (A)			| 24+P    etc.
		+---------------------------------------+
		| Local variable space (L)		| 24+P+A
		+---------------------------------------+
		| Float/int conversion temporary (X)	| 24+P+A+L
		+---------------------------------------+
		| Save area for AltiVec registers (W)	| 24+P+A+L+X
		+---------------------------------------+
		| AltiVec alignment padding (Y)		| 24+P+A+L+X+W
		+---------------------------------------+
		| Save area for VRSAVE register (Z)	| 24+P+A+L+X+W+Y
		+---------------------------------------+
		| Save area for GP registers (G)	| 24+P+A+X+L+X+W+Y+Z
		+---------------------------------------+
		| Save area for FP registers (F)	| 24+P+A+X+L+X+W+Y+Z+G
		+---------------------------------------+
	old SP->| back chain to caller's caller		|
		+---------------------------------------+

     * If the alloca area is present, the parameter save area is
       padded so that the former starts 16-byte aligned.

   The required alignment for AIX configurations is two words (i.e., 8
   or 16 bytes).

   The ELFv2 ABI is a variant of the AIX ABI.  Stack frames look like:

	SP---->	+---------------------------------------+
		| Back chain to caller			|  0
		+---------------------------------------+
		| Save area for CR			|  8
		+---------------------------------------+
		| Saved LR				|  16
		+---------------------------------------+
		| Saved TOC pointer			|  24
		+---------------------------------------+
		| Parameter save area (+padding*) (P)	|  32
		+---------------------------------------+
		| Alloca space (A)			|  32+P
		+---------------------------------------+
		| Local variable space (L)		|  32+P+A
		+---------------------------------------+
		| Save area for AltiVec registers (W)	|  32+P+A+L
		+---------------------------------------+
		| AltiVec alignment padding (Y)		|  32+P+A+L+W
		+---------------------------------------+
		| Save area for GP registers (G)	|  32+P+A+L+W+Y
		+---------------------------------------+
		| Save area for FP registers (F)	|  32+P+A+L+W+Y+G
		+---------------------------------------+
	old SP->| back chain to caller's caller		|  32+P+A+L+W+Y+G+F
		+---------------------------------------+

     * If the alloca area is present, the parameter save area is
       padded so that the former starts 16-byte aligned.

   V.4 stack frames look like:

	SP---->	+---------------------------------------+
		| back chain to caller			| 0
		+---------------------------------------+
		| caller's saved LR			| 4
		+---------------------------------------+
		| Parameter save area (+padding*) (P)	| 8
		+---------------------------------------+
		| Alloca space (A)			| 8+P
		+---------------------------------------+
		| Varargs save area (V)			| 8+P+A
		+---------------------------------------+
		| Local variable space (L)		| 8+P+A+V
		+---------------------------------------+
		| Float/int conversion temporary (X)	| 8+P+A+V+L
		+---------------------------------------+
		| Save area for AltiVec registers (W)	| 8+P+A+V+L+X
		+---------------------------------------+
		| AltiVec alignment padding (Y)		| 8+P+A+V+L+X+W
		+---------------------------------------+
		| Save area for VRSAVE register (Z)	| 8+P+A+V+L+X+W+Y
		+---------------------------------------+
		| saved CR (C)				| 8+P+A+V+L+X+W+Y+Z
		+---------------------------------------+
		| Save area for GP registers (G)	| 8+P+A+V+L+X+W+Y+Z+C
		+---------------------------------------+
		| Save area for FP registers (F)	| 8+P+A+V+L+X+W+Y+Z+C+G
		+---------------------------------------+
	old SP->| back chain to caller's caller		|
		+---------------------------------------+

     * If the alloca area is present and the required alignment is
       16 bytes, the parameter save area is padded so that the
       alloca area starts 16-byte aligned.

   The required alignment for V.4 is 16 bytes, or 8 bytes if -meabi is
   given.  (But note below and in sysv4.h that we require only 8 and
   may round up the size of our stack frame anyways.  The historical
   reason is early versions of powerpc-linux which didn't properly
   align the stack at program startup.  A happy side-effect is that
   -mno-eabi libraries can be used with -meabi programs.)

   The EABI configuration defaults to the V.4 layout.  However,
   the stack alignment requirements may differ.  If -mno-eabi is not
   given, the required stack alignment is 8 bytes; if -mno-eabi is
   given, the required alignment is 16 bytes.  (But see V.4 comment
   above.)  */

#ifndef ABI_STACK_BOUNDARY
#define ABI_STACK_BOUNDARY STACK_BOUNDARY
#endif

static rs6000_stack_t *
rs6000_stack_info (void)
{
  /* We should never be called for thunks, we are not set up for that.  */
  gcc_assert (!cfun->is_thunk);

  rs6000_stack_t *info = &stack_info;
  int reg_size = TARGET_32BIT ? 4 : 8;
  int ehrd_size;
  int ehcr_size;
  int save_align;
  int first_gp;
  HOST_WIDE_INT non_fixed_size;
  bool using_static_chain_p;

  if (reload_completed && info->reload_completed)
    return info;

  memset (info, 0, sizeof (*info));
  info->reload_completed = reload_completed;

  /* Select which calling sequence.  */
  info->abi = DEFAULT_ABI;

  /* Calculate which registers need to be saved & save area size.  */
  info->first_gp_reg_save = first_reg_to_save ();
  /* Assume that we will have to save RS6000_PIC_OFFSET_TABLE_REGNUM,
     even if it currently looks like we won't.  Reload may need it to
     get at a constant; if so, it will have already created a constant
     pool entry for it.  */
  if (((TARGET_TOC && TARGET_MINIMAL_TOC)
       || (flag_pic == 1 && DEFAULT_ABI == ABI_V4)
       || (flag_pic && DEFAULT_ABI == ABI_DARWIN))
      && crtl->uses_const_pool
      && info->first_gp_reg_save > RS6000_PIC_OFFSET_TABLE_REGNUM)
    first_gp = RS6000_PIC_OFFSET_TABLE_REGNUM;
  else
    first_gp = info->first_gp_reg_save;

  info->gp_size = reg_size * (32 - first_gp);

  info->first_fp_reg_save = first_fp_reg_to_save ();
  info->fp_size = 8 * (64 - info->first_fp_reg_save);

  info->first_altivec_reg_save = first_altivec_reg_to_save ();
  info->altivec_size = 16 * (LAST_ALTIVEC_REGNO + 1
				 - info->first_altivec_reg_save);

  /* Does this function call anything?  */
  info->calls_p = (!crtl->is_leaf || cfun->machine->ra_needs_full_frame);

  /* Determine if we need to save the condition code registers.  */
  if (save_reg_p (CR2_REGNO)
      || save_reg_p (CR3_REGNO)
      || save_reg_p (CR4_REGNO))
    {
      info->cr_save_p = 1;
      if (DEFAULT_ABI == ABI_V4)
	info->cr_size = reg_size;
    }

  /* If the current function calls __builtin_eh_return, then we need
     to allocate stack space for registers that will hold data for
     the exception handler.  */
  if (crtl->calls_eh_return)
    {
      unsigned int i;
      for (i = 0; EH_RETURN_DATA_REGNO (i) != INVALID_REGNUM; ++i)
	continue;

      ehrd_size = i * UNITS_PER_WORD;
    }
  else
    ehrd_size = 0;

  /* In the ELFv2 ABI, we also need to allocate space for separate
     CR field save areas if the function calls __builtin_eh_return.  */
  if (DEFAULT_ABI == ABI_ELFv2 && crtl->calls_eh_return)
    {
      /* This hard-codes that we have three call-saved CR fields.  */
      ehcr_size = 3 * reg_size;
      /* We do *not* use the regular CR save mechanism.  */
      info->cr_save_p = 0;
    }
  else
    ehcr_size = 0;

  /* Determine various sizes.  */
  info->reg_size     = reg_size;
  info->fixed_size   = RS6000_SAVE_AREA;
  info->vars_size    = RS6000_ALIGN (get_frame_size (), 8);
  if (cfun->calls_alloca)
    info->parm_size  =
      RS6000_ALIGN (crtl->outgoing_args_size + info->fixed_size,
		    STACK_BOUNDARY / BITS_PER_UNIT) - info->fixed_size;
  else
    info->parm_size  = RS6000_ALIGN (crtl->outgoing_args_size,
				     TARGET_ALTIVEC ? 16 : 8);
  if (FRAME_GROWS_DOWNWARD)
    info->vars_size
      += RS6000_ALIGN (info->fixed_size + info->vars_size + info->parm_size,
		       ABI_STACK_BOUNDARY / BITS_PER_UNIT)
	 - (info->fixed_size + info->vars_size + info->parm_size);

  if (TARGET_ALTIVEC_ABI)
    info->vrsave_mask = compute_vrsave_mask ();

  if (TARGET_ALTIVEC_VRSAVE && info->vrsave_mask)
    info->vrsave_size = 4;

  compute_save_world_info (info);

  /* Calculate the offsets.  */
  switch (DEFAULT_ABI)
    {
    case ABI_NONE:
    default:
      gcc_unreachable ();

    case ABI_AIX:
    case ABI_ELFv2:
    case ABI_DARWIN:
      info->fp_save_offset = -info->fp_size;
      info->gp_save_offset = info->fp_save_offset - info->gp_size;

      if (TARGET_ALTIVEC_ABI)
	{
	  info->vrsave_save_offset = info->gp_save_offset - info->vrsave_size;

	  /* Align stack so vector save area is on a quadword boundary.
	     The padding goes above the vectors.  */
	  if (info->altivec_size != 0)
	    info->altivec_padding_size = info->vrsave_save_offset & 0xF;

	  info->altivec_save_offset = info->vrsave_save_offset
				      - info->altivec_padding_size
				      - info->altivec_size;
	  gcc_assert (info->altivec_size == 0
		      || info->altivec_save_offset % 16 == 0);

	  /* Adjust for AltiVec case.  */
	  info->ehrd_offset = info->altivec_save_offset - ehrd_size;
	}
      else
	info->ehrd_offset = info->gp_save_offset - ehrd_size;

      info->ehcr_offset = info->ehrd_offset - ehcr_size;
      info->cr_save_offset = reg_size; /* first word when 64-bit.  */
      info->lr_save_offset = 2*reg_size;
      break;

    case ABI_V4:
      info->fp_save_offset = -info->fp_size;
      info->gp_save_offset = info->fp_save_offset - info->gp_size;
      info->cr_save_offset = info->gp_save_offset - info->cr_size;

      if (TARGET_ALTIVEC_ABI)
	{
	  info->vrsave_save_offset = info->cr_save_offset - info->vrsave_size;

	  /* Align stack so vector save area is on a quadword boundary.  */
	  if (info->altivec_size != 0)
	    info->altivec_padding_size = 16 - (-info->vrsave_save_offset % 16);

	  info->altivec_save_offset = info->vrsave_save_offset
				      - info->altivec_padding_size
				      - info->altivec_size;

	  /* Adjust for AltiVec case.  */
	  info->ehrd_offset = info->altivec_save_offset;
	}
      else
	info->ehrd_offset = info->cr_save_offset;

      info->ehrd_offset -= ehrd_size;
      info->lr_save_offset = reg_size;
    }

  save_align = (TARGET_ALTIVEC_ABI || DEFAULT_ABI == ABI_DARWIN) ? 16 : 8;
  info->save_size = RS6000_ALIGN (info->fp_size
				  + info->gp_size
				  + info->altivec_size
				  + info->altivec_padding_size
				  + ehrd_size
				  + ehcr_size
				  + info->cr_size
				  + info->vrsave_size,
				  save_align);

  non_fixed_size = info->vars_size + info->parm_size + info->save_size;

  info->total_size = RS6000_ALIGN (non_fixed_size + info->fixed_size,
				   ABI_STACK_BOUNDARY / BITS_PER_UNIT);

  /* Determine if we need to save the link register.  */
  if (info->calls_p
      || ((DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2)
	  && crtl->profile
	  && !TARGET_PROFILE_KERNEL)
      || (DEFAULT_ABI == ABI_V4 && cfun->calls_alloca)
#ifdef TARGET_RELOCATABLE
      || (DEFAULT_ABI == ABI_V4
	  && (TARGET_RELOCATABLE || flag_pic > 1)
	  && !constant_pool_empty_p ())
#endif
      || rs6000_ra_ever_killed ())
    info->lr_save_p = 1;

  using_static_chain_p = (cfun->static_chain_decl != NULL_TREE
			  && df_regs_ever_live_p (STATIC_CHAIN_REGNUM)
			  && call_used_regs[STATIC_CHAIN_REGNUM]);
  info->savres_strategy = rs6000_savres_strategy (info, using_static_chain_p);

  if (!(info->savres_strategy & SAVE_INLINE_GPRS)
      || !(info->savres_strategy & SAVE_INLINE_FPRS)
      || !(info->savres_strategy & SAVE_INLINE_VRS)
      || !(info->savres_strategy & REST_INLINE_GPRS)
      || !(info->savres_strategy & REST_INLINE_FPRS)
      || !(info->savres_strategy & REST_INLINE_VRS))
    info->lr_save_p = 1;

  if (info->lr_save_p)
    df_set_regs_ever_live (LR_REGNO, true);

  /* Determine if we need to allocate any stack frame:

     For AIX we need to push the stack if a frame pointer is needed
     (because the stack might be dynamically adjusted), if we are
     debugging, if we make calls, or if the sum of fp_save, gp_save,
     and local variables are more than the space needed to save all
     non-volatile registers: 32-bit: 18*8 + 19*4 = 220 or 64-bit: 18*8
     + 18*8 = 288 (GPR13 reserved).

     For V.4 we don't have the stack cushion that AIX uses, but assume
     that the debugger can handle stackless frames.  */

  if (info->calls_p)
    info->push_p = 1;

  else if (DEFAULT_ABI == ABI_V4)
    info->push_p = non_fixed_size != 0;

  else if (frame_pointer_needed)
    info->push_p = 1;

  else if (TARGET_XCOFF && write_symbols != NO_DEBUG)
    info->push_p = 1;

  else
    info->push_p = non_fixed_size > (TARGET_32BIT ? 220 : 288);

  return info;
}

static void
debug_stack_info (rs6000_stack_t *info)
{
  const char *abi_string;

  if (! info)
    info = rs6000_stack_info ();

  fprintf (stderr, "\nStack information for function %s:\n",
	   ((current_function_decl && DECL_NAME (current_function_decl))
	    ? IDENTIFIER_POINTER (DECL_NAME (current_function_decl))
	    : "<unknown>"));

  switch (info->abi)
    {
    default:		 abi_string = "Unknown";	break;
    case ABI_NONE:	 abi_string = "NONE";		break;
    case ABI_AIX:	 abi_string = "AIX";		break;
    case ABI_ELFv2:	 abi_string = "ELFv2";		break;
    case ABI_DARWIN:	 abi_string = "Darwin";		break;
    case ABI_V4:	 abi_string = "V.4";		break;
    }

  fprintf (stderr, "\tABI                 = %5s\n", abi_string);

  if (TARGET_ALTIVEC_ABI)
    fprintf (stderr, "\tALTIVEC ABI extensions enabled.\n");

  if (info->first_gp_reg_save != 32)
    fprintf (stderr, "\tfirst_gp_reg_save   = %5d\n", info->first_gp_reg_save);

  if (info->first_fp_reg_save != 64)
    fprintf (stderr, "\tfirst_fp_reg_save   = %5d\n", info->first_fp_reg_save);

  if (info->first_altivec_reg_save <= LAST_ALTIVEC_REGNO)
    fprintf (stderr, "\tfirst_altivec_reg_save = %5d\n",
	     info->first_altivec_reg_save);

  if (info->lr_save_p)
    fprintf (stderr, "\tlr_save_p           = %5d\n", info->lr_save_p);

  if (info->cr_save_p)
    fprintf (stderr, "\tcr_save_p           = %5d\n", info->cr_save_p);

  if (info->vrsave_mask)
    fprintf (stderr, "\tvrsave_mask         = 0x%x\n", info->vrsave_mask);

  if (info->push_p)
    fprintf (stderr, "\tpush_p              = %5d\n", info->push_p);

  if (info->calls_p)
    fprintf (stderr, "\tcalls_p             = %5d\n", info->calls_p);

  if (info->gp_size)
    fprintf (stderr, "\tgp_save_offset      = %5d\n", info->gp_save_offset);

  if (info->fp_size)
    fprintf (stderr, "\tfp_save_offset      = %5d\n", info->fp_save_offset);

  if (info->altivec_size)
    fprintf (stderr, "\taltivec_save_offset = %5d\n",
	     info->altivec_save_offset);

  if (info->vrsave_size)
    fprintf (stderr, "\tvrsave_save_offset  = %5d\n",
	     info->vrsave_save_offset);

  if (info->lr_save_p)
    fprintf (stderr, "\tlr_save_offset      = %5d\n", info->lr_save_offset);

  if (info->cr_save_p)
    fprintf (stderr, "\tcr_save_offset      = %5d\n", info->cr_save_offset);

  if (info->varargs_save_offset)
    fprintf (stderr, "\tvarargs_save_offset = %5d\n", info->varargs_save_offset);

  if (info->total_size)
    fprintf (stderr, "\ttotal_size          = " HOST_WIDE_INT_PRINT_DEC"\n",
	     info->total_size);

  if (info->vars_size)
    fprintf (stderr, "\tvars_size           = " HOST_WIDE_INT_PRINT_DEC"\n",
	     info->vars_size);

  if (info->parm_size)
    fprintf (stderr, "\tparm_size           = %5d\n", info->parm_size);

  if (info->fixed_size)
    fprintf (stderr, "\tfixed_size          = %5d\n", info->fixed_size);

  if (info->gp_size)
    fprintf (stderr, "\tgp_size             = %5d\n", info->gp_size);

  if (info->fp_size)
    fprintf (stderr, "\tfp_size             = %5d\n", info->fp_size);

  if (info->altivec_size)
    fprintf (stderr, "\taltivec_size        = %5d\n", info->altivec_size);

  if (info->vrsave_size)
    fprintf (stderr, "\tvrsave_size         = %5d\n", info->vrsave_size);

  if (info->altivec_padding_size)
    fprintf (stderr, "\taltivec_padding_size= %5d\n",
	     info->altivec_padding_size);

  if (info->cr_size)
    fprintf (stderr, "\tcr_size             = %5d\n", info->cr_size);

  if (info->save_size)
    fprintf (stderr, "\tsave_size           = %5d\n", info->save_size);

  if (info->reg_size != 4)
    fprintf (stderr, "\treg_size            = %5d\n", info->reg_size);

    fprintf (stderr, "\tsave-strategy       =  %04x\n", info->savres_strategy);

  if (info->abi == ABI_DARWIN)
    fprintf (stderr, "\tWORLD_SAVE_P        = %5d\n", WORLD_SAVE_P(info));

  fprintf (stderr, "\n");
}

rtx
rs6000_return_addr (int count, rtx frame)
{
  /* We can't use get_hard_reg_initial_val for LR when count == 0 if LR
     is trashed by the prologue, as it is for PIC on ABI_V4 and Darwin.  */
  if (count != 0
      || ((DEFAULT_ABI == ABI_V4 || DEFAULT_ABI == ABI_DARWIN) && flag_pic))
    {
      cfun->machine->ra_needs_full_frame = 1;

      if (count == 0)
	/* FRAME is set to frame_pointer_rtx by the generic code, but that
	   is good for loading 0(r1) only when !FRAME_GROWS_DOWNWARD.  */
	frame = stack_pointer_rtx;
      rtx prev_frame_addr = memory_address (Pmode, frame);
      rtx prev_frame = copy_to_reg (gen_rtx_MEM (Pmode, prev_frame_addr));
      rtx lr_save_off = plus_constant (Pmode,
				       prev_frame, RETURN_ADDRESS_OFFSET);
      rtx lr_save_addr = memory_address (Pmode, lr_save_off);
      return gen_rtx_MEM (Pmode, lr_save_addr);
    }

  cfun->machine->ra_need_lr = 1;
  return get_hard_reg_initial_val (Pmode, LR_REGNO);
}

/* Helper function for rs6000_function_ok_for_sibcall.  */

static bool
rs6000_decl_ok_for_sibcall (tree decl)
{
  /* Sibcalls are always fine for the Darwin ABI.  */
  if (DEFAULT_ABI == ABI_DARWIN)
    return true;

  if (DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2)
    {
      /* Under the AIX or ELFv2 ABIs we can't allow calls to non-local
	 functions, because the callee may have a different TOC pointer to
	 the caller and there's no way to ensure we restore the TOC when
	 we return.  */
      if (!decl || DECL_EXTERNAL (decl) || DECL_WEAK (decl)
	  || !(*targetm.binds_local_p) (decl))
	return false;

      /* Similarly, if the caller preserves the TOC pointer and the callee
	 doesn't (or vice versa), proper TOC setup or restoration will be
	 missed.  For example, suppose A, B, and C are in the same binary
	 and A -> B -> C.  A and B preserve the TOC pointer but C does not,
	 and B -> C is eligible as a sibcall.  A will call B through its
	 local entry point, so A will not restore its TOC itself.  B calls
	 C with a sibcall, so it will not restore the TOC.  C does not
	 preserve the TOC, so it may clobber r2 with impunity.  Returning
	 from C will result in a corrupted TOC for A.  */
      else if (rs6000_fndecl_pcrel_p (decl) != rs6000_pcrel_p (cfun))
	return false;

      else
	return true;
    }

  /*  With the secure-plt SYSV ABI we can't make non-local calls when
      -fpic/PIC because the plt call stubs use r30.  */
  if (DEFAULT_ABI != ABI_V4
      || (TARGET_SECURE_PLT
	  && flag_pic
	  && (!decl || !((*targetm.binds_local_p) (decl)))))
    return false;

  return true;
}

/* Say whether a function is a candidate for sibcall handling or not.  */

static bool
rs6000_function_ok_for_sibcall (tree decl, tree exp)
{
  tree fntype;

  /* The sibcall epilogue may clobber the static chain register.
     ??? We could work harder and avoid that, but it's probably
     not worth the hassle in practice.  */
  if (CALL_EXPR_STATIC_CHAIN (exp))
    return false;

  if (decl)
    fntype = TREE_TYPE (decl);
  else
    fntype = TREE_TYPE (TREE_TYPE (CALL_EXPR_FN (exp)));

  /* We can't do it if the called function has more vector parameters
     than the current function; there's nowhere to put the VRsave code.  */
  if (TARGET_ALTIVEC_ABI
      && TARGET_ALTIVEC_VRSAVE
      && !(decl && decl == current_function_decl))
    {
      function_args_iterator args_iter;
      tree type;
      int nvreg = 0;

      /* Functions with vector parameters are required to have a
	 prototype, so the argument type info must be available
	 here.  */
      FOREACH_FUNCTION_ARGS(fntype, type, args_iter)
	if (TREE_CODE (type) == VECTOR_TYPE
	    && ALTIVEC_OR_VSX_VECTOR_MODE (TYPE_MODE (type)))
	  nvreg++;

      FOREACH_FUNCTION_ARGS(TREE_TYPE (current_function_decl), type, args_iter)
	if (TREE_CODE (type) == VECTOR_TYPE
	    && ALTIVEC_OR_VSX_VECTOR_MODE (TYPE_MODE (type)))
	  nvreg--;

      if (nvreg > 0)
	return false;
    }

  if (rs6000_decl_ok_for_sibcall (decl))
    {
      tree attr_list = TYPE_ATTRIBUTES (fntype);

      if (!lookup_attribute ("longcall", attr_list)
	  || lookup_attribute ("shortcall", attr_list))
	return true;
    }

  return false;
}

static int
rs6000_ra_ever_killed (void)
{
  rtx_insn *top;
  rtx reg;
  rtx_insn *insn;

  if (cfun->is_thunk)
    return 0;

  if (cfun->machine->lr_save_state)
    return cfun->machine->lr_save_state - 1;

  /* regs_ever_live has LR marked as used if any sibcalls are present,
     but this should not force saving and restoring in the
     pro/epilogue.  Likewise, reg_set_between_p thinks a sibcall
     clobbers LR, so that is inappropriate.  */

  /* Also, the prologue can generate a store into LR that
     doesn't really count, like this:

        move LR->R0
        bcl to set PIC register
        move LR->R31
        move R0->LR

     When we're called from the epilogue, we need to avoid counting
     this as a store.  */

  push_topmost_sequence ();
  top = get_insns ();
  pop_topmost_sequence ();
  reg = gen_rtx_REG (Pmode, LR_REGNO);

  for (insn = NEXT_INSN (top); insn != NULL_RTX; insn = NEXT_INSN (insn))
    {
      if (INSN_P (insn))
	{
	  if (CALL_P (insn))
	    {
	      if (!SIBLING_CALL_P (insn))
		return 1;
	    }
	  else if (find_regno_note (insn, REG_INC, LR_REGNO))
	    return 1;
	  else if (set_of (reg, insn) != NULL_RTX
		   && !prologue_epilogue_contains (insn))
	    return 1;
    	}
    }
  return 0;
}

/* Emit instructions needed to load the TOC register.
   This is only needed when TARGET_TOC, TARGET_MINIMAL_TOC, and there is
   a constant pool; or for SVR4 -fpic.  */

void
rs6000_emit_load_toc_table (int fromprolog)
{
  rtx dest;
  dest = gen_rtx_REG (Pmode, RS6000_PIC_OFFSET_TABLE_REGNUM);

  if (TARGET_ELF && TARGET_SECURE_PLT && DEFAULT_ABI == ABI_V4 && flag_pic)
    {
      char buf[30];
      rtx lab, tmp1, tmp2, got;

      lab = gen_label_rtx ();
      ASM_GENERATE_INTERNAL_LABEL (buf, "L", CODE_LABEL_NUMBER (lab));
      lab = gen_rtx_SYMBOL_REF (Pmode, ggc_strdup (buf));
      if (flag_pic == 2)
	{
	  got = gen_rtx_SYMBOL_REF (Pmode, ggc_strdup (toc_label_name));
	  need_toc_init = 1;
	}
      else
	got = rs6000_got_sym ();
      tmp1 = tmp2 = dest;
      if (!fromprolog)
	{
	  tmp1 = gen_reg_rtx (Pmode);
	  tmp2 = gen_reg_rtx (Pmode);
	}
      emit_insn (gen_load_toc_v4_PIC_1 (lab));
      emit_move_insn (tmp1, gen_rtx_REG (Pmode, LR_REGNO));
      emit_insn (gen_load_toc_v4_PIC_3b (tmp2, tmp1, got, lab));
      emit_insn (gen_load_toc_v4_PIC_3c (dest, tmp2, got, lab));
    }
  else if (TARGET_ELF && DEFAULT_ABI == ABI_V4 && flag_pic == 1)
    {
      emit_insn (gen_load_toc_v4_pic_si ());
      emit_move_insn (dest, gen_rtx_REG (Pmode, LR_REGNO));
    }
  else if (TARGET_ELF && DEFAULT_ABI == ABI_V4 && flag_pic == 2)
    {
      char buf[30];
      rtx temp0 = (fromprolog
		   ? gen_rtx_REG (Pmode, 0)
		   : gen_reg_rtx (Pmode));

      if (fromprolog)
	{
	  rtx symF, symL;

	  ASM_GENERATE_INTERNAL_LABEL (buf, "LCF", rs6000_pic_labelno);
	  symF = gen_rtx_SYMBOL_REF (Pmode, ggc_strdup (buf));

	  ASM_GENERATE_INTERNAL_LABEL (buf, "LCL", rs6000_pic_labelno);
	  symL = gen_rtx_SYMBOL_REF (Pmode, ggc_strdup (buf));

	  emit_insn (gen_load_toc_v4_PIC_1 (symF));
	  emit_move_insn (dest, gen_rtx_REG (Pmode, LR_REGNO));
	  emit_insn (gen_load_toc_v4_PIC_2 (temp0, dest, symL, symF));
	}
      else
	{
	  rtx tocsym, lab;

	  tocsym = gen_rtx_SYMBOL_REF (Pmode, ggc_strdup (toc_label_name));
	  need_toc_init = 1;
	  lab = gen_label_rtx ();
	  emit_insn (gen_load_toc_v4_PIC_1b (tocsym, lab));
	  emit_move_insn (dest, gen_rtx_REG (Pmode, LR_REGNO));
	  if (TARGET_LINK_STACK)
	    emit_insn (gen_addsi3 (dest, dest, GEN_INT (4)));
	  emit_move_insn (temp0, gen_rtx_MEM (Pmode, dest));
	}
      emit_insn (gen_addsi3 (dest, temp0, dest));
    }
  else if (TARGET_ELF && !TARGET_AIX && flag_pic == 0 && TARGET_MINIMAL_TOC)
    {
      /* This is for AIX code running in non-PIC ELF32.  */
      rtx realsym = gen_rtx_SYMBOL_REF (Pmode, ggc_strdup (toc_label_name));

      need_toc_init = 1;
      emit_insn (gen_elf_high (dest, realsym));
      emit_insn (gen_elf_low (dest, dest, realsym));
    }
  else
    {
      gcc_assert (DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2);

      if (TARGET_32BIT)
	emit_insn (gen_load_toc_aix_si (dest));
      else
	emit_insn (gen_load_toc_aix_di (dest));
    }
}

/* Emit instructions to restore the link register after determining where
   its value has been stored.  */

void
rs6000_emit_eh_reg_restore (rtx source, rtx scratch)
{
  rs6000_stack_t *info = rs6000_stack_info ();
  rtx operands[2];

  operands[0] = source;
  operands[1] = scratch;

  if (info->lr_save_p)
    {
      rtx frame_rtx = stack_pointer_rtx;
      HOST_WIDE_INT sp_offset = 0;
      rtx tmp;

      if (frame_pointer_needed
	  || cfun->calls_alloca
	  || info->total_size > 32767)
	{
	  tmp = gen_frame_mem (Pmode, frame_rtx);
	  emit_move_insn (operands[1], tmp);
	  frame_rtx = operands[1];
	}
      else if (info->push_p)
	sp_offset = info->total_size;

      tmp = plus_constant (Pmode, frame_rtx,
			   info->lr_save_offset + sp_offset);
      tmp = gen_frame_mem (Pmode, tmp);
      emit_move_insn (tmp, operands[0]);
    }
  else
    emit_move_insn (gen_rtx_REG (Pmode, LR_REGNO), operands[0]);

  /* Freeze lr_save_p.  We've just emitted rtl that depends on the
     state of lr_save_p so any change from here on would be a bug.  In
     particular, stop rs6000_ra_ever_killed from considering the SET
     of lr we may have added just above.  */ 
  cfun->machine->lr_save_state = info->lr_save_p + 1;
}

static GTY(()) alias_set_type set = -1;

alias_set_type
get_TOC_alias_set (void)
{
  if (set == -1)
    set = new_alias_set ();
  return set;
}

/* This returns nonzero if the current function uses the TOC.  This is
   determined by the presence of (use (unspec ... UNSPEC_TOC)), which
   is generated by the ABI_V4 load_toc_* patterns.
   Return 2 instead of 1 if the load_toc_* pattern is in the function
   partition that doesn't start the function.  */
#if TARGET_ELF
static int
uses_TOC (void)
{
  rtx_insn *insn;
  int ret = 1;

  for (insn = get_insns (); insn; insn = NEXT_INSN (insn))
    {
      if (INSN_P (insn))
	{
	  rtx pat = PATTERN (insn);
	  int i;

	  if (GET_CODE (pat) == PARALLEL)
	    for (i = 0; i < XVECLEN (pat, 0); i++)
	      {
		rtx sub = XVECEXP (pat, 0, i);
		if (GET_CODE (sub) == USE)
		  {
		    sub = XEXP (sub, 0);
		    if (GET_CODE (sub) == UNSPEC
			&& XINT (sub, 1) == UNSPEC_TOC)
		      return ret;
		  }
	      }
	}
      else if (crtl->has_bb_partition
	       && NOTE_P (insn)
	       && NOTE_KIND (insn) == NOTE_INSN_SWITCH_TEXT_SECTIONS)
	ret = 2;
    }
  return 0;
}
#endif

rtx
create_TOC_reference (rtx symbol, rtx largetoc_reg)
{
  rtx tocrel, tocreg, hi;

  if (TARGET_DEBUG_ADDR)
    {
      if (SYMBOL_REF_P (symbol))
	fprintf (stderr, "\ncreate_TOC_reference, (symbol_ref %s)\n",
		 XSTR (symbol, 0));
      else
	{
	  fprintf (stderr, "\ncreate_TOC_reference, code %s:\n",
		   GET_RTX_NAME (GET_CODE (symbol)));
	  debug_rtx (symbol);
	}
    }

  if (!can_create_pseudo_p ())
    df_set_regs_ever_live (TOC_REGISTER, true);

  tocreg = gen_rtx_REG (Pmode, TOC_REGISTER);
  tocrel = gen_rtx_UNSPEC (Pmode, gen_rtvec (2, symbol, tocreg), UNSPEC_TOCREL);
  if (TARGET_CMODEL == CMODEL_SMALL || can_create_pseudo_p ())
    return tocrel;

  hi = gen_rtx_HIGH (Pmode, copy_rtx (tocrel));
  if (largetoc_reg != NULL)
    {
      emit_move_insn (largetoc_reg, hi);
      hi = largetoc_reg;
    }
  return gen_rtx_LO_SUM (Pmode, hi, tocrel);
}

/* Issue assembly directives that create a reference to the given DWARF
   FRAME_TABLE_LABEL from the current function section.  */
void
rs6000_aix_asm_output_dwarf_table_ref (char * frame_table_label)
{
  fprintf (asm_out_file, "\t.ref %s\n",
	   (* targetm.strip_name_encoding) (frame_table_label));
}

/* This ties together stack memory (MEM with an alias set of frame_alias_set)
   and the change to the stack pointer.  */

static void
rs6000_emit_stack_tie (rtx fp, bool hard_frame_needed)
{
  rtvec p;
  int i;
  rtx regs[3];

  i = 0;
  regs[i++] = gen_rtx_REG (Pmode, STACK_POINTER_REGNUM);
  if (hard_frame_needed)
    regs[i++] = gen_rtx_REG (Pmode, HARD_FRAME_POINTER_REGNUM);
  if (!(REGNO (fp) == STACK_POINTER_REGNUM
	|| (hard_frame_needed
	    && REGNO (fp) == HARD_FRAME_POINTER_REGNUM)))
    regs[i++] = fp;

  p = rtvec_alloc (i);
  while (--i >= 0)
    {
      rtx mem = gen_frame_mem (BLKmode, regs[i]);
      RTVEC_ELT (p, i) = gen_rtx_SET (mem, const0_rtx);
    }

  emit_insn (gen_stack_tie (gen_rtx_PARALLEL (VOIDmode, p)));
}

/* Allocate SIZE_INT bytes on the stack using a store with update style insn
   and set the appropriate attributes for the generated insn.  Return the
   first insn which adjusts the stack pointer or the last insn before
   the stack adjustment loop. 

   SIZE_INT is used to create the CFI note for the allocation.

   SIZE_RTX is an rtx containing the size of the adjustment.  Note that
   since stacks grow to lower addresses its runtime value is -SIZE_INT.

   ORIG_SP contains the backchain value that must be stored at *sp.  */

static rtx_insn *
rs6000_emit_allocate_stack_1 (HOST_WIDE_INT size_int, rtx orig_sp)
{
  rtx_insn *insn;

  rtx size_rtx = GEN_INT (-size_int);
  if (size_int > 32767)
    {
      rtx tmp_reg = gen_rtx_REG (Pmode, 0);
      /* Need a note here so that try_split doesn't get confused.  */
      if (get_last_insn () == NULL_RTX)
	emit_note (NOTE_INSN_DELETED);
      insn = emit_move_insn (tmp_reg, size_rtx);
      try_split (PATTERN (insn), insn, 0);
      size_rtx = tmp_reg;
    }
  
  if (TARGET_32BIT)
    insn = emit_insn (gen_movsi_update_stack (stack_pointer_rtx,
					      stack_pointer_rtx,
					      size_rtx,
					      orig_sp));
  else
    insn = emit_insn (gen_movdi_update_stack (stack_pointer_rtx,
					      stack_pointer_rtx,
					      size_rtx,
					      orig_sp));
  rtx par = PATTERN (insn);
  gcc_assert (GET_CODE (par) == PARALLEL);
  rtx set = XVECEXP (par, 0, 0);
  gcc_assert (GET_CODE (set) == SET);
  rtx mem = SET_DEST (set);
  gcc_assert (MEM_P (mem));
  MEM_NOTRAP_P (mem) = 1;
  set_mem_alias_set (mem, get_frame_alias_set ());

  RTX_FRAME_RELATED_P (insn) = 1;
  add_reg_note (insn, REG_FRAME_RELATED_EXPR,
		gen_rtx_SET (stack_pointer_rtx,
			     gen_rtx_PLUS (Pmode,
					   stack_pointer_rtx,
					   GEN_INT (-size_int))));

  /* Emit a blockage to ensure the allocation/probing insns are
     not optimized, combined, removed, etc.  Add REG_STACK_CHECK
     note for similar reasons.  */
  if (flag_stack_clash_protection)
    {
      add_reg_note (insn, REG_STACK_CHECK, const0_rtx);
      emit_insn (gen_blockage ());
    }

  return insn;
}

static HOST_WIDE_INT
get_stack_clash_protection_probe_interval (void)
{
  return (HOST_WIDE_INT_1U
	  << PARAM_VALUE (PARAM_STACK_CLASH_PROTECTION_PROBE_INTERVAL));
}

static HOST_WIDE_INT
get_stack_clash_protection_guard_size (void)
{
  return (HOST_WIDE_INT_1U
	  << PARAM_VALUE (PARAM_STACK_CLASH_PROTECTION_GUARD_SIZE));
}

/* Allocate ORIG_SIZE bytes on the stack and probe the newly
   allocated space every STACK_CLASH_PROTECTION_PROBE_INTERVAL bytes.

   COPY_REG, if non-null, should contain a copy of the original
   stack pointer at exit from this function.

   This is subtly different than the Ada probing in that it tries hard to
   prevent attacks that jump the stack guard.  Thus it is never allowed to
   allocate more than STACK_CLASH_PROTECTION_PROBE_INTERVAL bytes of stack
   space without a suitable probe.  */
static rtx_insn *
rs6000_emit_probe_stack_range_stack_clash (HOST_WIDE_INT orig_size,
					   rtx copy_reg)
{
  rtx orig_sp = copy_reg;

  HOST_WIDE_INT probe_interval = get_stack_clash_protection_probe_interval ();

  /* Round the size down to a multiple of PROBE_INTERVAL.  */
  HOST_WIDE_INT rounded_size = ROUND_DOWN (orig_size, probe_interval);

  /* If explicitly requested,
       or the rounded size is not the same as the original size
       or the the rounded size is greater than a page,
     then we will need a copy of the original stack pointer.  */
  if (rounded_size != orig_size
      || rounded_size > probe_interval
      || copy_reg)
    {
      /* If the caller did not request a copy of the incoming stack
	 pointer, then we use r0 to hold the copy.  */
      if (!copy_reg)
	orig_sp = gen_rtx_REG (Pmode, 0);
      emit_move_insn (orig_sp, stack_pointer_rtx);
    }

  /* There's three cases here.

     One is a single probe which is the most common and most efficiently
     implemented as it does not have to have a copy of the original
     stack pointer if there are no residuals.

     Second is unrolled allocation/probes which we use if there's just
     a few of them.  It needs to save the original stack pointer into a
     temporary for use as a source register in the allocation/probe.

     Last is a loop.  This is the most uncommon case and least efficient.  */
  rtx_insn *retval = NULL;
  if (rounded_size == probe_interval)
    {
      retval = rs6000_emit_allocate_stack_1 (probe_interval, stack_pointer_rtx);

      dump_stack_clash_frame_info (PROBE_INLINE, rounded_size != orig_size);
    }
  else if (rounded_size <= 8 * probe_interval)
    {
      /* The ABI requires using the store with update insns to allocate
	 space and store the backchain into the stack

	 So we save the current stack pointer into a temporary, then
	 emit the store-with-update insns to store the saved stack pointer
	 into the right location in each new page.  */
      for (int i = 0; i < rounded_size; i += probe_interval)
	{
	  rtx_insn *insn
	    = rs6000_emit_allocate_stack_1 (probe_interval, orig_sp);

	  /* Save the first stack adjustment in RETVAL.  */
	  if (i == 0)
	    retval = insn;
	}

      dump_stack_clash_frame_info (PROBE_INLINE, rounded_size != orig_size);
    }
  else
    {
      /* Compute the ending address.  */
      rtx end_addr
	= copy_reg ? gen_rtx_REG (Pmode, 0) : gen_rtx_REG (Pmode, 12);
      rtx rs = GEN_INT (-rounded_size);
      rtx_insn *insn;
      if (add_operand (rs, Pmode))
	insn = emit_insn (gen_add3_insn (end_addr, stack_pointer_rtx, rs));
      else
	{
	  emit_move_insn (end_addr, GEN_INT (-rounded_size));
	  insn = emit_insn (gen_add3_insn (end_addr, end_addr,
					   stack_pointer_rtx));
	  /* Describe the effect of INSN to the CFI engine.  */
	  add_reg_note (insn, REG_FRAME_RELATED_EXPR,
			gen_rtx_SET (end_addr,
				     gen_rtx_PLUS (Pmode, stack_pointer_rtx,
						   rs)));
	}
      RTX_FRAME_RELATED_P (insn) = 1;

      /* Emit the loop.  */
      if (TARGET_64BIT)
	retval = emit_insn (gen_probe_stack_rangedi (stack_pointer_rtx,
						     stack_pointer_rtx, orig_sp,
						     end_addr));
      else
	retval = emit_insn (gen_probe_stack_rangesi (stack_pointer_rtx,
						     stack_pointer_rtx, orig_sp,
						     end_addr));
      RTX_FRAME_RELATED_P (retval) = 1;
      /* Describe the effect of INSN to the CFI engine.  */
      add_reg_note (retval, REG_FRAME_RELATED_EXPR,
		    gen_rtx_SET (stack_pointer_rtx, end_addr));

      /* Emit a blockage to ensure the allocation/probing insns are
	 not optimized, combined, removed, etc.  Other cases handle this
	 within their call to rs6000_emit_allocate_stack_1.  */
      emit_insn (gen_blockage ());

      dump_stack_clash_frame_info (PROBE_LOOP, rounded_size != orig_size);
    }

  if (orig_size != rounded_size)
    {
      /* Allocate (and implicitly probe) any residual space.   */
      HOST_WIDE_INT residual = orig_size - rounded_size;

      rtx_insn *insn = rs6000_emit_allocate_stack_1 (residual, orig_sp);

      /* If the residual was the only allocation, then we can return the
	 allocating insn.  */
      if (!retval)
	retval = insn;
    }

  return retval;
}

/* Emit the correct code for allocating stack space, as insns.
   If COPY_REG, make sure a copy of the old frame is left there.
   The generated code may use hard register 0 as a temporary.  */

static rtx_insn *
rs6000_emit_allocate_stack (HOST_WIDE_INT size, rtx copy_reg, int copy_off)
{
  rtx_insn *insn;
  rtx stack_reg = gen_rtx_REG (Pmode, STACK_POINTER_REGNUM);
  rtx tmp_reg = gen_rtx_REG (Pmode, 0);
  rtx todec = gen_int_mode (-size, Pmode);

  if (INTVAL (todec) != -size)
    {
      warning (0, "stack frame too large");
      emit_insn (gen_trap ());
      return 0;
    }

  if (crtl->limit_stack)
    {
      if (REG_P (stack_limit_rtx)
	  && REGNO (stack_limit_rtx) > 1
	  && REGNO (stack_limit_rtx) <= 31)
	{
	  rtx_insn *insn
	    = gen_add3_insn (tmp_reg, stack_limit_rtx, GEN_INT (size));
	  gcc_assert (insn);
	  emit_insn (insn);
	  emit_insn (gen_cond_trap (LTU, stack_reg, tmp_reg, const0_rtx));
	}
      else if (SYMBOL_REF_P (stack_limit_rtx)
	       && TARGET_32BIT
	       && DEFAULT_ABI == ABI_V4
	       && !flag_pic)
	{
	  rtx toload = gen_rtx_CONST (VOIDmode,
				      gen_rtx_PLUS (Pmode,
						    stack_limit_rtx,
						    GEN_INT (size)));

	  emit_insn (gen_elf_high (tmp_reg, toload));
	  emit_insn (gen_elf_low (tmp_reg, tmp_reg, toload));
	  emit_insn (gen_cond_trap (LTU, stack_reg, tmp_reg,
				    const0_rtx));
	}
      else
	warning (0, "stack limit expression is not supported");
    }

  if (flag_stack_clash_protection)
    {
      if (size < get_stack_clash_protection_guard_size ())
	dump_stack_clash_frame_info (NO_PROBE_SMALL_FRAME, true);
      else
	{
	  rtx_insn *insn = rs6000_emit_probe_stack_range_stack_clash (size,
								      copy_reg);

	  /* If we asked for a copy with an offset, then we still need add in
	     the offset.  */
	  if (copy_reg && copy_off)
	    emit_insn (gen_add3_insn (copy_reg, copy_reg, GEN_INT (copy_off)));
	  return insn;
	}
    }

  if (copy_reg)
    {
      if (copy_off != 0)
	emit_insn (gen_add3_insn (copy_reg, stack_reg, GEN_INT (copy_off)));
      else
	emit_move_insn (copy_reg, stack_reg);
    }

  /* Since we didn't use gen_frame_mem to generate the MEM, grab
     it now and set the alias set/attributes. The above gen_*_update
     calls will generate a PARALLEL with the MEM set being the first
     operation. */
  insn = rs6000_emit_allocate_stack_1 (size, stack_reg);
  return insn;
}

#define PROBE_INTERVAL (1 << STACK_CHECK_PROBE_INTERVAL_EXP)

#if PROBE_INTERVAL > 32768
#error Cannot use indexed addressing mode for stack probing
#endif

/* Emit code to probe a range of stack addresses from FIRST to FIRST+SIZE,
   inclusive.  These are offsets from the current stack pointer.  */

static void
rs6000_emit_probe_stack_range (HOST_WIDE_INT first, HOST_WIDE_INT size)
{
  /* See if we have a constant small number of probes to generate.  If so,
     that's the easy case.  */
  if (first + size <= 32768)
    {
      HOST_WIDE_INT i;

      /* Probe at FIRST + N * PROBE_INTERVAL for values of N from 1 until
	 it exceeds SIZE.  If only one probe is needed, this will not
	 generate any code.  Then probe at FIRST + SIZE.  */
      for (i = PROBE_INTERVAL; i < size; i += PROBE_INTERVAL)
	emit_stack_probe (plus_constant (Pmode, stack_pointer_rtx,
					 -(first + i)));

      emit_stack_probe (plus_constant (Pmode, stack_pointer_rtx,
				       -(first + size)));
    }

  /* Otherwise, do the same as above, but in a loop.  Note that we must be
     extra careful with variables wrapping around because we might be at
     the very top (or the very bottom) of the address space and we have
     to be able to handle this case properly; in particular, we use an
     equality test for the loop condition.  */
  else
    {
      HOST_WIDE_INT rounded_size;
      rtx r12 = gen_rtx_REG (Pmode, 12);
      rtx r0 = gen_rtx_REG (Pmode, 0);

      /* Sanity check for the addressing mode we're going to use.  */
      gcc_assert (first <= 32768);

      /* Step 1: round SIZE to the previous multiple of the interval.  */

      rounded_size = ROUND_DOWN (size, PROBE_INTERVAL);


      /* Step 2: compute initial and final value of the loop counter.  */

      /* TEST_ADDR = SP + FIRST.  */
      emit_insn (gen_rtx_SET (r12, plus_constant (Pmode, stack_pointer_rtx,
						  -first)));

      /* LAST_ADDR = SP + FIRST + ROUNDED_SIZE.  */
      if (rounded_size > 32768)
	{
	  emit_move_insn (r0, GEN_INT (-rounded_size));
	  emit_insn (gen_rtx_SET (r0, gen_rtx_PLUS (Pmode, r12, r0)));
	}
      else
	emit_insn (gen_rtx_SET (r0, plus_constant (Pmode, r12,
						   -rounded_size)));


      /* Step 3: the loop

	 do
	   {
	     TEST_ADDR = TEST_ADDR + PROBE_INTERVAL
	     probe at TEST_ADDR
	   }
	 while (TEST_ADDR != LAST_ADDR)

	 probes at FIRST + N * PROBE_INTERVAL for values of N from 1
	 until it is equal to ROUNDED_SIZE.  */

      if (TARGET_64BIT)
	emit_insn (gen_probe_stack_rangedi (r12, r12, stack_pointer_rtx, r0));
      else
	emit_insn (gen_probe_stack_rangesi (r12, r12, stack_pointer_rtx, r0));


      /* Step 4: probe at FIRST + SIZE if we cannot assert at compile-time
	 that SIZE is equal to ROUNDED_SIZE.  */

      if (size != rounded_size)
	emit_stack_probe (plus_constant (Pmode, r12, rounded_size - size));
    }
}

/* Probe a range of stack addresses from REG1 to REG2 inclusive.  These are
   addresses, not offsets.  */

static const char *
output_probe_stack_range_1 (rtx reg1, rtx reg2)
{
  static int labelno = 0;
  char loop_lab[32];
  rtx xops[2];

  ASM_GENERATE_INTERNAL_LABEL (loop_lab, "LPSRL", labelno++);

  /* Loop.  */
  ASM_OUTPUT_INTERNAL_LABEL (asm_out_file, loop_lab);

  /* TEST_ADDR = TEST_ADDR + PROBE_INTERVAL.  */
  xops[0] = reg1;
  xops[1] = GEN_INT (-PROBE_INTERVAL);
  output_asm_insn ("addi %0,%0,%1", xops);

  /* Probe at TEST_ADDR.  */
  xops[1] = gen_rtx_REG (Pmode, 0);
  output_asm_insn ("stw %1,0(%0)", xops);

  /* Test if TEST_ADDR == LAST_ADDR.  */
  xops[1] = reg2;
  if (TARGET_64BIT)
    output_asm_insn ("cmpd 0,%0,%1", xops);
  else
    output_asm_insn ("cmpw 0,%0,%1", xops);

  /* Branch.  */
  fputs ("\tbne 0,", asm_out_file);
  assemble_name_raw (asm_out_file, loop_lab);
  fputc ('\n', asm_out_file);

  return "";
}

/* This function is called when rs6000_frame_related is processing
   SETs within a PARALLEL, and returns whether the REGNO save ought to
   be marked RTX_FRAME_RELATED_P.  The PARALLELs involved are those
   for out-of-line register save functions, store multiple, and the
   Darwin world_save.  They may contain registers that don't really
   need saving.  */

static bool
interesting_frame_related_regno (unsigned int regno)
{
  /* Saves apparently of r0 are actually saving LR.  It doesn't make
     sense to substitute the regno here to test save_reg_p (LR_REGNO).
     We *know* LR needs saving, and dwarf2cfi.c is able to deduce that
     (set (mem) (r0)) is saving LR from a prior (set (r0) (lr)) marked
     as frame related.  */
  if (regno == 0)
    return true;
  /* If we see CR2 then we are here on a Darwin world save.  Saves of
     CR2 signify the whole CR is being saved.  This is a long-standing
     ABI wart fixed by ELFv2.  As for r0/lr there is no need to check
     that CR needs to be saved.  */
  if (regno == CR2_REGNO)
    return true;
  /* Omit frame info for any user-defined global regs.  If frame info
     is supplied for them, frame unwinding will restore a user reg.
     Also omit frame info for any reg we don't need to save, as that
     bloats frame info and can cause problems with shrink wrapping.
     Since global regs won't be seen as needing to be saved, both of
     these conditions are covered by save_reg_p.  */
  return save_reg_p (regno);
}

/* Probe a range of stack addresses from REG1 to REG3 inclusive.  These are
   addresses, not offsets.

   REG2 contains the backchain that must be stored into *sp at each allocation.

   This is subtly different than the Ada probing above in that it tries hard
   to prevent attacks that jump the stack guard.  Thus, it is never allowed
   to allocate more than PROBE_INTERVAL bytes of stack space without a
   suitable probe.  */

static const char *
output_probe_stack_range_stack_clash (rtx reg1, rtx reg2, rtx reg3)
{
  static int labelno = 0;
  char loop_lab[32];
  rtx xops[3];

  HOST_WIDE_INT probe_interval = get_stack_clash_protection_probe_interval ();

  ASM_GENERATE_INTERNAL_LABEL (loop_lab, "LPSRL", labelno++);

  ASM_OUTPUT_INTERNAL_LABEL (asm_out_file, loop_lab);

  /* This allocates and probes.  */
  xops[0] = reg1;
  xops[1] = reg2;
  xops[2] = GEN_INT (-probe_interval);
  if (TARGET_64BIT)
    output_asm_insn ("stdu %1,%2(%0)", xops);
  else
    output_asm_insn ("stwu %1,%2(%0)", xops);

  /* Jump to LOOP_LAB if TEST_ADDR != LAST_ADDR.  */
  xops[0] = reg1;
  xops[1] = reg3;
  if (TARGET_64BIT)
    output_asm_insn ("cmpd 0,%0,%1", xops);
  else
    output_asm_insn ("cmpw 0,%0,%1", xops);

  fputs ("\tbne 0,", asm_out_file);
  assemble_name_raw (asm_out_file, loop_lab);
  fputc ('\n', asm_out_file);

  return "";
}

/* Wrapper around the output_probe_stack_range routines.  */
const char *
output_probe_stack_range (rtx reg1, rtx reg2, rtx reg3)
{
  if (flag_stack_clash_protection)
    return output_probe_stack_range_stack_clash (reg1, reg2, reg3);
  else
    return output_probe_stack_range_1 (reg1, reg3);
}

/* Add to 'insn' a note which is PATTERN (INSN) but with REG replaced
   with (plus:P (reg 1) VAL), and with REG2 replaced with REPL2 if REG2
   is not NULL.  It would be nice if dwarf2out_frame_debug_expr could
   deduce these equivalences by itself so it wasn't necessary to hold
   its hand so much.  Don't be tempted to always supply d2_f_d_e with
   the actual cfa register, ie. r31 when we are using a hard frame
   pointer.  That fails when saving regs off r1, and sched moves the
   r31 setup past the reg saves.  */

static rtx_insn *
rs6000_frame_related (rtx_insn *insn, rtx reg, HOST_WIDE_INT val,
		      rtx reg2, rtx repl2)
{
  rtx repl;

  if (REGNO (reg) == STACK_POINTER_REGNUM)
    {
      gcc_checking_assert (val == 0);
      repl = NULL_RTX;
    }
  else
    repl = gen_rtx_PLUS (Pmode, gen_rtx_REG (Pmode, STACK_POINTER_REGNUM),
			 GEN_INT (val));

  rtx pat = PATTERN (insn);
  if (!repl && !reg2)
    {
      /* No need for any replacement.  Just set RTX_FRAME_RELATED_P.  */
      if (GET_CODE (pat) == PARALLEL)
	for (int i = 0; i < XVECLEN (pat, 0); i++)
	  if (GET_CODE (XVECEXP (pat, 0, i)) == SET)
	    {
	      rtx set = XVECEXP (pat, 0, i);

	      if (!REG_P (SET_SRC (set))
		  || interesting_frame_related_regno (REGNO (SET_SRC (set))))
		RTX_FRAME_RELATED_P (set) = 1;
	    }
      RTX_FRAME_RELATED_P (insn) = 1;
      return insn;
    }

  /* We expect that 'pat' is either a SET or a PARALLEL containing
     SETs (and possibly other stuff).  In a PARALLEL, all the SETs
     are important so they all have to be marked RTX_FRAME_RELATED_P.
     Call simplify_replace_rtx on the SETs rather than the whole insn
     so as to leave the other stuff alone (for example USE of r12).  */

  set_used_flags (pat);
  if (GET_CODE (pat) == SET)
    {
      if (repl)
	pat = simplify_replace_rtx (pat, reg, repl);
      if (reg2)
	pat = simplify_replace_rtx (pat, reg2, repl2);
    }
  else if (GET_CODE (pat) == PARALLEL)
    {
      pat = shallow_copy_rtx (pat);
      XVEC (pat, 0) = shallow_copy_rtvec (XVEC (pat, 0));

      for (int i = 0; i < XVECLEN (pat, 0); i++)
	if (GET_CODE (XVECEXP (pat, 0, i)) == SET)
	  {
	    rtx set = XVECEXP (pat, 0, i);

	    if (repl)
	      set = simplify_replace_rtx (set, reg, repl);
	    if (reg2)
	      set = simplify_replace_rtx (set, reg2, repl2);
	    XVECEXP (pat, 0, i) = set;

	    if (!REG_P (SET_SRC (set))
		|| interesting_frame_related_regno (REGNO (SET_SRC (set))))
	      RTX_FRAME_RELATED_P (set) = 1;
	  }
    }
  else
    gcc_unreachable ();

  RTX_FRAME_RELATED_P (insn) = 1;
  add_reg_note (insn, REG_FRAME_RELATED_EXPR, copy_rtx_if_shared (pat));

  return insn;
}

/* Returns an insn that has a vrsave set operation with the
   appropriate CLOBBERs.  */

static rtx
generate_set_vrsave (rtx reg, rs6000_stack_t *info, int epiloguep)
{
  int nclobs, i;
  rtx insn, clobs[TOTAL_ALTIVEC_REGS + 1];
  rtx vrsave = gen_rtx_REG (SImode, VRSAVE_REGNO);

  clobs[0]
    = gen_rtx_SET (vrsave,
		   gen_rtx_UNSPEC_VOLATILE (SImode,
					    gen_rtvec (2, reg, vrsave),
					    UNSPECV_SET_VRSAVE));

  nclobs = 1;

  /* We need to clobber the registers in the mask so the scheduler
     does not move sets to VRSAVE before sets of AltiVec registers.

     However, if the function receives nonlocal gotos, reload will set
     all call saved registers live.  We will end up with:

     	(set (reg 999) (mem))
	(parallel [ (set (reg vrsave) (unspec blah))
		    (clobber (reg 999))])

     The clobber will cause the store into reg 999 to be dead, and
     flow will attempt to delete an epilogue insn.  In this case, we
     need an unspec use/set of the register.  */

  for (i = FIRST_ALTIVEC_REGNO; i <= LAST_ALTIVEC_REGNO; ++i)
    if (info->vrsave_mask & ALTIVEC_REG_BIT (i))
      {
	if (!epiloguep || call_used_regs [i])
	  clobs[nclobs++] = gen_hard_reg_clobber (V4SImode, i);
	else
	  {
	    rtx reg = gen_rtx_REG (V4SImode, i);

	    clobs[nclobs++]
	      = gen_rtx_SET (reg,
			     gen_rtx_UNSPEC (V4SImode,
					     gen_rtvec (1, reg), 27));
	  }
      }

  insn = gen_rtx_PARALLEL (VOIDmode, rtvec_alloc (nclobs));

  for (i = 0; i < nclobs; ++i)
    XVECEXP (insn, 0, i) = clobs[i];

  return insn;
}

static rtx
gen_frame_set (rtx reg, rtx frame_reg, int offset, bool store)
{
  rtx addr, mem;

  addr = gen_rtx_PLUS (Pmode, frame_reg, GEN_INT (offset));
  mem = gen_frame_mem (GET_MODE (reg), addr);
  return gen_rtx_SET (store ? mem : reg, store ? reg : mem);
}

static rtx
gen_frame_load (rtx reg, rtx frame_reg, int offset)
{
  return gen_frame_set (reg, frame_reg, offset, false);
}

static rtx
gen_frame_store (rtx reg, rtx frame_reg, int offset)
{
  return gen_frame_set (reg, frame_reg, offset, true);
}

/* Save a register into the frame, and emit RTX_FRAME_RELATED_P notes.
   Save REGNO into [FRAME_REG + OFFSET] in mode MODE.  */

static rtx_insn *
emit_frame_save (rtx frame_reg, machine_mode mode,
		 unsigned int regno, int offset, HOST_WIDE_INT frame_reg_to_sp)
{
  rtx reg;

  /* Some cases that need register indexed addressing.  */
  gcc_checking_assert (!(TARGET_ALTIVEC_ABI && ALTIVEC_VECTOR_MODE (mode))
			 || (TARGET_VSX && ALTIVEC_OR_VSX_VECTOR_MODE (mode)));

  reg = gen_rtx_REG (mode, regno);
  rtx_insn *insn = emit_insn (gen_frame_store (reg, frame_reg, offset));
  return rs6000_frame_related (insn, frame_reg, frame_reg_to_sp,
			       NULL_RTX, NULL_RTX);
}

/* Emit an offset memory reference suitable for a frame store, while
   converting to a valid addressing mode.  */

static rtx
gen_frame_mem_offset (machine_mode mode, rtx reg, int offset)
{
  return gen_frame_mem (mode, gen_rtx_PLUS (Pmode, reg, GEN_INT (offset)));
}

#ifndef TARGET_FIX_AND_CONTINUE
#define TARGET_FIX_AND_CONTINUE 0
#endif

/* It's really GPR 13 or 14, FPR 14 and VR 20.  We need the smallest.  */
#define FIRST_SAVRES_REGISTER FIRST_SAVED_GP_REGNO
#define LAST_SAVRES_REGISTER 31
#define N_SAVRES_REGISTERS (LAST_SAVRES_REGISTER - FIRST_SAVRES_REGISTER + 1)

enum {
  SAVRES_LR = 0x1,
  SAVRES_SAVE = 0x2,
  SAVRES_REG = 0x0c,
  SAVRES_GPR = 0,
  SAVRES_FPR = 4,
  SAVRES_VR  = 8
};

static GTY(()) rtx savres_routine_syms[N_SAVRES_REGISTERS][12];

/* Temporary holding space for an out-of-line register save/restore
   routine name.  */
static char savres_routine_name[30];

/* Return the name for an out-of-line register save/restore routine.
   We are saving/restoring GPRs if GPR is true.  */

static char *
rs6000_savres_routine_name (int regno, int sel)
{
  const char *prefix = "";
  const char *suffix = "";

  /* Different targets are supposed to define
     {SAVE,RESTORE}_FP_{PREFIX,SUFFIX} with the idea that the needed
     routine name could be defined with:

     sprintf (name, "%s%d%s", SAVE_FP_PREFIX, regno, SAVE_FP_SUFFIX)

     This is a nice idea in practice, but in reality, things are
     complicated in several ways:

     - ELF targets have save/restore routines for GPRs.

     - PPC64 ELF targets have routines for save/restore of GPRs that
       differ in what they do with the link register, so having a set
       prefix doesn't work.  (We only use one of the save routines at
       the moment, though.)

     - PPC32 elf targets have "exit" versions of the restore routines
       that restore the link register and can save some extra space.
       These require an extra suffix.  (There are also "tail" versions
       of the restore routines and "GOT" versions of the save routines,
       but we don't generate those at present.  Same problems apply,
       though.)

     We deal with all this by synthesizing our own prefix/suffix and
     using that for the simple sprintf call shown above.  */
  if (DEFAULT_ABI == ABI_V4)
    {
      if (TARGET_64BIT)
	goto aix_names;

      if ((sel & SAVRES_REG) == SAVRES_GPR)
	prefix = (sel & SAVRES_SAVE) ? "_savegpr_" : "_restgpr_";
      else if ((sel & SAVRES_REG) == SAVRES_FPR)
	prefix = (sel & SAVRES_SAVE) ? "_savefpr_" : "_restfpr_";
      else if ((sel & SAVRES_REG) == SAVRES_VR)
	prefix = (sel & SAVRES_SAVE) ? "_savevr_" : "_restvr_";
      else
	abort ();

      if ((sel & SAVRES_LR))
	suffix = "_x";
    }
  else if (DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2)
    {
#if !defined (POWERPC_LINUX) && !defined (POWERPC_FREEBSD)
      /* No out-of-line save/restore routines for GPRs on AIX.  */
      gcc_assert (!TARGET_AIX || (sel & SAVRES_REG) != SAVRES_GPR);
#endif

    aix_names:
      if ((sel & SAVRES_REG) == SAVRES_GPR)
	prefix = ((sel & SAVRES_SAVE)
		  ? ((sel & SAVRES_LR) ? "_savegpr0_" : "_savegpr1_")
		  : ((sel & SAVRES_LR) ? "_restgpr0_" : "_restgpr1_"));
      else if ((sel & SAVRES_REG) == SAVRES_FPR)
	{
#if defined (POWERPC_LINUX) || defined (POWERPC_FREEBSD)
	  if ((sel & SAVRES_LR))
	    prefix = ((sel & SAVRES_SAVE) ? "_savefpr_" : "_restfpr_");
	  else
#endif
	    {
	      prefix = (sel & SAVRES_SAVE) ? SAVE_FP_PREFIX : RESTORE_FP_PREFIX;
	      suffix = (sel & SAVRES_SAVE) ? SAVE_FP_SUFFIX : RESTORE_FP_SUFFIX;
	    }
	}
      else if ((sel & SAVRES_REG) == SAVRES_VR)
	prefix = (sel & SAVRES_SAVE) ? "_savevr_" : "_restvr_";
      else
	abort ();
    }

   if (DEFAULT_ABI == ABI_DARWIN)
    {
      /* The Darwin approach is (slightly) different, in order to be
	 compatible with code generated by the system toolchain.  There is a
	 single symbol for the start of save sequence, and the code here
	 embeds an offset into that code on the basis of the first register
	 to be saved.  */
      prefix = (sel & SAVRES_SAVE) ? "save" : "rest" ;
      if ((sel & SAVRES_REG) == SAVRES_GPR)
	sprintf (savres_routine_name, "*%sGPR%s%s%.0d ; %s r%d-r31", prefix,
		 ((sel & SAVRES_LR) ? "x" : ""), (regno == 13 ? "" : "+"),
		 (regno - 13) * 4, prefix, regno);
      else if ((sel & SAVRES_REG) == SAVRES_FPR)
	sprintf (savres_routine_name, "*%sFP%s%.0d ; %s f%d-f31", prefix,
		 (regno == 14 ? "" : "+"), (regno - 14) * 4, prefix, regno);
      else if ((sel & SAVRES_REG) == SAVRES_VR)
	sprintf (savres_routine_name, "*%sVEC%s%.0d ; %s v%d-v31", prefix,
		 (regno == 20 ? "" : "+"), (regno - 20) * 8, prefix, regno);
      else
	abort ();
    }
  else
    sprintf (savres_routine_name, "%s%d%s", prefix, regno, suffix);

  return savres_routine_name;
}

/* Return an RTL SYMBOL_REF for an out-of-line register save/restore routine.
   We are saving/restoring GPRs if GPR is true.  */

static rtx
rs6000_savres_routine_sym (rs6000_stack_t *info, int sel)
{
  int regno = ((sel & SAVRES_REG) == SAVRES_GPR
	       ? info->first_gp_reg_save
	       : (sel & SAVRES_REG) == SAVRES_FPR
	       ? info->first_fp_reg_save - 32
	       : (sel & SAVRES_REG) == SAVRES_VR
	       ? info->first_altivec_reg_save - FIRST_ALTIVEC_REGNO
	       : -1);
  rtx sym;
  int select = sel;

  /* Don't generate bogus routine names.  */
  gcc_assert (FIRST_SAVRES_REGISTER <= regno
	      && regno <= LAST_SAVRES_REGISTER
	      && select >= 0 && select <= 12);

  sym = savres_routine_syms[regno-FIRST_SAVRES_REGISTER][select];

  if (sym == NULL)
    {
      char *name;

      name = rs6000_savres_routine_name (regno, sel);

      sym = savres_routine_syms[regno-FIRST_SAVRES_REGISTER][select]
	= gen_rtx_SYMBOL_REF (Pmode, ggc_strdup (name));
      SYMBOL_REF_FLAGS (sym) |= SYMBOL_FLAG_FUNCTION;
    }

  return sym;
}

/* Emit a sequence of insns, including a stack tie if needed, for
   resetting the stack pointer.  If UPDT_REGNO is not 1, then don't
   reset the stack pointer, but move the base of the frame into
   reg UPDT_REGNO for use by out-of-line register restore routines.  */

static rtx
rs6000_emit_stack_reset (rtx frame_reg_rtx, HOST_WIDE_INT frame_off,
			 unsigned updt_regno)
{
  /* If there is nothing to do, don't do anything.  */
  if (frame_off == 0 && REGNO (frame_reg_rtx) == updt_regno)
    return NULL_RTX;

  rtx updt_reg_rtx = gen_rtx_REG (Pmode, updt_regno);

  /* This blockage is needed so that sched doesn't decide to move
     the sp change before the register restores.  */
  if (DEFAULT_ABI == ABI_V4)
    return emit_insn (gen_stack_restore_tie (updt_reg_rtx, frame_reg_rtx,
					     GEN_INT (frame_off)));

  /* If we are restoring registers out-of-line, we will be using the
     "exit" variants of the restore routines, which will reset the
     stack for us.  But we do need to point updt_reg into the
     right place for those routines.  */
  if (frame_off != 0)
    return emit_insn (gen_add3_insn (updt_reg_rtx,
				     frame_reg_rtx, GEN_INT (frame_off)));
  else
    return emit_move_insn (updt_reg_rtx, frame_reg_rtx);

  return NULL_RTX;
}

/* Return the register number used as a pointer by out-of-line
   save/restore functions.  */

static inline unsigned
ptr_regno_for_savres (int sel)
{
  if (DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2)
    return (sel & SAVRES_REG) == SAVRES_FPR || (sel & SAVRES_LR) ? 1 : 12;
  return DEFAULT_ABI == ABI_DARWIN && (sel & SAVRES_REG) == SAVRES_FPR ? 1 : 11;
}

/* Construct a parallel rtx describing the effect of a call to an
   out-of-line register save/restore routine, and emit the insn
   or jump_insn as appropriate.  */

static rtx_insn *
rs6000_emit_savres_rtx (rs6000_stack_t *info,
			rtx frame_reg_rtx, int save_area_offset, int lr_offset,
			machine_mode reg_mode, int sel)
{
  int i;
  int offset, start_reg, end_reg, n_regs, use_reg;
  int reg_size = GET_MODE_SIZE (reg_mode);
  rtx sym;
  rtvec p;
  rtx par;
  rtx_insn *insn;

  offset = 0;
  start_reg = ((sel & SAVRES_REG) == SAVRES_GPR
	       ? info->first_gp_reg_save
	       : (sel & SAVRES_REG) == SAVRES_FPR
	       ? info->first_fp_reg_save
	       : (sel & SAVRES_REG) == SAVRES_VR
	       ? info->first_altivec_reg_save
	       : -1);
  end_reg = ((sel & SAVRES_REG) == SAVRES_GPR
	     ? 32
	     : (sel & SAVRES_REG) == SAVRES_FPR
	     ? 64
	     : (sel & SAVRES_REG) == SAVRES_VR
	     ? LAST_ALTIVEC_REGNO + 1
	     : -1);
  n_regs = end_reg - start_reg;
  p = rtvec_alloc (3 + ((sel & SAVRES_LR) ? 1 : 0)
		   + ((sel & SAVRES_REG) == SAVRES_VR ? 1 : 0)
		   + n_regs);

  if (!(sel & SAVRES_SAVE) && (sel & SAVRES_LR))
    RTVEC_ELT (p, offset++) = ret_rtx;

  RTVEC_ELT (p, offset++) = gen_hard_reg_clobber (Pmode, LR_REGNO);

  sym = rs6000_savres_routine_sym (info, sel);
  RTVEC_ELT (p, offset++) = gen_rtx_USE (VOIDmode, sym);

  use_reg = ptr_regno_for_savres (sel);
  if ((sel & SAVRES_REG) == SAVRES_VR)
    {
      /* Vector regs are saved/restored using [reg+reg] addressing.  */
      RTVEC_ELT (p, offset++) = gen_hard_reg_clobber (Pmode, use_reg);
      RTVEC_ELT (p, offset++)
	= gen_rtx_USE (VOIDmode, gen_rtx_REG (Pmode, 0));
    }
  else
    RTVEC_ELT (p, offset++)
      = gen_rtx_USE (VOIDmode, gen_rtx_REG (Pmode, use_reg));

  for (i = 0; i < end_reg - start_reg; i++)
    RTVEC_ELT (p, i + offset)
      = gen_frame_set (gen_rtx_REG (reg_mode, start_reg + i),
		       frame_reg_rtx, save_area_offset + reg_size * i,
		       (sel & SAVRES_SAVE) != 0);

  if ((sel & SAVRES_SAVE) && (sel & SAVRES_LR))
    RTVEC_ELT (p, i + offset)
      = gen_frame_store (gen_rtx_REG (Pmode, 0), frame_reg_rtx, lr_offset);

  par = gen_rtx_PARALLEL (VOIDmode, p);

  if (!(sel & SAVRES_SAVE) && (sel & SAVRES_LR))
    {
      insn = emit_jump_insn (par);
      JUMP_LABEL (insn) = ret_rtx;
    }
  else
    insn = emit_insn (par);
  return insn;
}

/* Emit prologue code to store CR fields that need to be saved into REG.  This
   function should only be called when moving the non-volatile CRs to REG, it
   is not a general purpose routine to move the entire set of CRs to REG.
   Specifically, gen_prologue_movesi_from_cr() does not contain uses of the
   volatile CRs.  */

static void
rs6000_emit_prologue_move_from_cr (rtx reg)
{
  /* Only the ELFv2 ABI allows storing only selected fields.  */
  if (DEFAULT_ABI == ABI_ELFv2 && TARGET_MFCRF)
    {
      int i, cr_reg[8], count = 0;

      /* Collect CR fields that must be saved.  */
      for (i = 0; i < 8; i++)
	if (save_reg_p (CR0_REGNO + i))
	  cr_reg[count++] = i;

      /* If it's just a single one, use mfcrf.  */
      if (count == 1)
	{
	  rtvec p = rtvec_alloc (1);
	  rtvec r = rtvec_alloc (2);
	  RTVEC_ELT (r, 0) = gen_rtx_REG (CCmode, CR0_REGNO + cr_reg[0]);
	  RTVEC_ELT (r, 1) = GEN_INT (1 << (7 - cr_reg[0]));
	  RTVEC_ELT (p, 0)
	    = gen_rtx_SET (reg,
			   gen_rtx_UNSPEC (SImode, r, UNSPEC_MOVESI_FROM_CR));

	  emit_insn (gen_rtx_PARALLEL (VOIDmode, p));
	  return;
	}

      /* ??? It might be better to handle count == 2 / 3 cases here
	 as well, using logical operations to combine the values.  */
    }

  emit_insn (gen_prologue_movesi_from_cr (reg));
}

/* Return whether the split-stack arg pointer (r12) is used.  */

static bool
split_stack_arg_pointer_used_p (void)
{
  /* If the pseudo holding the arg pointer is no longer a pseudo,
     then the arg pointer is used.  */
  if (cfun->machine->split_stack_arg_pointer != NULL_RTX
      && (!REG_P (cfun->machine->split_stack_arg_pointer)
	  || HARD_REGISTER_P (cfun->machine->split_stack_arg_pointer)))
    return true;

  /* Unfortunately we also need to do some code scanning, since
     r12 may have been substituted for the pseudo.  */
  rtx_insn *insn;
  basic_block bb = ENTRY_BLOCK_PTR_FOR_FN (cfun)->next_bb;
  FOR_BB_INSNS (bb, insn)
    if (NONDEBUG_INSN_P (insn))
      {
	/* A call destroys r12.  */
	if (CALL_P (insn))
	  return false;

	df_ref use;
	FOR_EACH_INSN_USE (use, insn)
	  {
	    rtx x = DF_REF_REG (use);
	    if (REG_P (x) && REGNO (x) == 12)
	      return true;
	  }
	df_ref def;
	FOR_EACH_INSN_DEF (def, insn)
	  {
	    rtx x = DF_REF_REG (def);
	    if (REG_P (x) && REGNO (x) == 12)
	      return false;
	  }
      }
  return bitmap_bit_p (DF_LR_OUT (bb), 12);
}

/* Return whether we need to emit an ELFv2 global entry point prologue.  */

static bool
rs6000_global_entry_point_prologue_needed_p (void)
{
  /* Only needed for the ELFv2 ABI.  */
  if (DEFAULT_ABI != ABI_ELFv2)
    return false;

  /* With -msingle-pic-base, we assume the whole program shares the same
     TOC, so no global entry point prologues are needed anywhere.  */
  if (TARGET_SINGLE_PIC_BASE)
    return false;

  /* PC-relative functions never generate a global entry point prologue.  */
  if (rs6000_pcrel_p (cfun))
    return false;

  /* Ensure we have a global entry point for thunks.   ??? We could
     avoid that if the target routine doesn't need a global entry point,
     but we do not know whether this is the case at this point.  */
  if (cfun->is_thunk)
    return true;

  /* For regular functions, rs6000_emit_prologue sets this flag if the
     routine ever uses the TOC pointer.  */
  return cfun->machine->r2_setup_needed;
}

/* Implement TARGET_SHRINK_WRAP_GET_SEPARATE_COMPONENTS.  */
static sbitmap
rs6000_get_separate_components (void)
{
  rs6000_stack_t *info = rs6000_stack_info ();

  if (WORLD_SAVE_P (info))
    return NULL;

  gcc_assert (!(info->savres_strategy & SAVE_MULTIPLE)
	      && !(info->savres_strategy & REST_MULTIPLE));

  /* Component 0 is the save/restore of LR (done via GPR0).
     Component 2 is the save of the TOC (GPR2).
     Components 13..31 are the save/restore of GPR13..GPR31.
     Components 46..63 are the save/restore of FPR14..FPR31.  */

  cfun->machine->n_components = 64;

  sbitmap components = sbitmap_alloc (cfun->machine->n_components);
  bitmap_clear (components);

  int reg_size = TARGET_32BIT ? 4 : 8;
  int fp_reg_size = 8;

  /* The GPRs we need saved to the frame.  */
  if ((info->savres_strategy & SAVE_INLINE_GPRS)
      && (info->savres_strategy & REST_INLINE_GPRS))
    {
      int offset = info->gp_save_offset;
      if (info->push_p)
	offset += info->total_size;

      for (unsigned regno = info->first_gp_reg_save; regno < 32; regno++)
	{
	  if (IN_RANGE (offset, -0x8000, 0x7fff)
	      && save_reg_p (regno))
	    bitmap_set_bit (components, regno);

	  offset += reg_size;
	}
    }

  /* Don't mess with the hard frame pointer.  */
  if (frame_pointer_needed)
    bitmap_clear_bit (components, HARD_FRAME_POINTER_REGNUM);

  /* Don't mess with the fixed TOC register.  */
  if ((TARGET_TOC && TARGET_MINIMAL_TOC)
      || (flag_pic == 1 && DEFAULT_ABI == ABI_V4)
      || (flag_pic && DEFAULT_ABI == ABI_DARWIN))
    bitmap_clear_bit (components, RS6000_PIC_OFFSET_TABLE_REGNUM);

  /* The FPRs we need saved to the frame.  */
  if ((info->savres_strategy & SAVE_INLINE_FPRS)
      && (info->savres_strategy & REST_INLINE_FPRS))
    {
      int offset = info->fp_save_offset;
      if (info->push_p)
	offset += info->total_size;

      for (unsigned regno = info->first_fp_reg_save; regno < 64; regno++)
	{
	  if (IN_RANGE (offset, -0x8000, 0x7fff) && save_reg_p (regno))
	    bitmap_set_bit (components, regno);

	  offset += fp_reg_size;
	}
    }

  /* Optimize LR save and restore if we can.  This is component 0.  Any
     out-of-line register save/restore routines need LR.  */
  if (info->lr_save_p
      && !(flag_pic && (DEFAULT_ABI == ABI_V4 || DEFAULT_ABI == ABI_DARWIN))
      && (info->savres_strategy & SAVE_INLINE_GPRS)
      && (info->savres_strategy & REST_INLINE_GPRS)
      && (info->savres_strategy & SAVE_INLINE_FPRS)
      && (info->savres_strategy & REST_INLINE_FPRS)
      && (info->savres_strategy & SAVE_INLINE_VRS)
      && (info->savres_strategy & REST_INLINE_VRS))
    {
      int offset = info->lr_save_offset;
      if (info->push_p)
	offset += info->total_size;
      if (IN_RANGE (offset, -0x8000, 0x7fff))
	bitmap_set_bit (components, 0);
    }

  /* Optimize saving the TOC.  This is component 2.  */
  if (cfun->machine->save_toc_in_prologue)
    bitmap_set_bit (components, 2);

  return components;
}

/* Implement TARGET_SHRINK_WRAP_COMPONENTS_FOR_BB.  */
static sbitmap
rs6000_components_for_bb (basic_block bb)
{
  rs6000_stack_t *info = rs6000_stack_info ();

  bitmap in = DF_LIVE_IN (bb);
  bitmap gen = &DF_LIVE_BB_INFO (bb)->gen;
  bitmap kill = &DF_LIVE_BB_INFO (bb)->kill;

  sbitmap components = sbitmap_alloc (cfun->machine->n_components);
  bitmap_clear (components);

  /* A register is used in a bb if it is in the IN, GEN, or KILL sets.  */

  /* GPRs.  */
  for (unsigned regno = info->first_gp_reg_save; regno < 32; regno++)
    if (bitmap_bit_p (in, regno)
	|| bitmap_bit_p (gen, regno)
	|| bitmap_bit_p (kill, regno))
      bitmap_set_bit (components, regno);

  /* FPRs.  */
  for (unsigned regno = info->first_fp_reg_save; regno < 64; regno++)
    if (bitmap_bit_p (in, regno)
	|| bitmap_bit_p (gen, regno)
	|| bitmap_bit_p (kill, regno))
      bitmap_set_bit (components, regno);

  /* The link register.  */
  if (bitmap_bit_p (in, LR_REGNO)
      || bitmap_bit_p (gen, LR_REGNO)
      || bitmap_bit_p (kill, LR_REGNO))
    bitmap_set_bit (components, 0);

  /* The TOC save.  */
  if (bitmap_bit_p (in, TOC_REGNUM)
      || bitmap_bit_p (gen, TOC_REGNUM)
      || bitmap_bit_p (kill, TOC_REGNUM))
    bitmap_set_bit (components, 2);

  return components;
}

/* Implement TARGET_SHRINK_WRAP_DISQUALIFY_COMPONENTS.  */
static void
rs6000_disqualify_components (sbitmap components, edge e,
			      sbitmap edge_components, bool /*is_prologue*/)
{
  /* Our LR pro/epilogue code moves LR via R0, so R0 had better not be
     live where we want to place that code.  */
  if (bitmap_bit_p (edge_components, 0)
      && bitmap_bit_p (DF_LIVE_IN (e->dest), 0))
    {
      if (dump_file)
	fprintf (dump_file, "Disqualifying LR because GPR0 is live "
		 "on entry to bb %d\n", e->dest->index);
      bitmap_clear_bit (components, 0);
    }
}

/* Implement TARGET_SHRINK_WRAP_EMIT_PROLOGUE_COMPONENTS.  */
static void
rs6000_emit_prologue_components (sbitmap components)
{
  rs6000_stack_t *info = rs6000_stack_info ();
  rtx ptr_reg = gen_rtx_REG (Pmode, frame_pointer_needed
			     ? HARD_FRAME_POINTER_REGNUM
			     : STACK_POINTER_REGNUM);

  machine_mode reg_mode = Pmode;
  int reg_size = TARGET_32BIT ? 4 : 8;
  machine_mode fp_reg_mode = TARGET_HARD_FLOAT ? DFmode : SFmode;
  int fp_reg_size = 8;

  /* Prologue for LR.  */
  if (bitmap_bit_p (components, 0))
    {
      rtx lr = gen_rtx_REG (reg_mode, LR_REGNO);
      rtx reg = gen_rtx_REG (reg_mode, 0);
      rtx_insn *insn = emit_move_insn (reg, lr);
      RTX_FRAME_RELATED_P (insn) = 1;
      add_reg_note (insn, REG_CFA_REGISTER, gen_rtx_SET (reg, lr));

      int offset = info->lr_save_offset;
      if (info->push_p)
	offset += info->total_size;

      insn = emit_insn (gen_frame_store (reg, ptr_reg, offset));
      RTX_FRAME_RELATED_P (insn) = 1;
      rtx mem = copy_rtx (SET_DEST (single_set (insn)));
      add_reg_note (insn, REG_CFA_OFFSET, gen_rtx_SET (mem, lr));
    }

  /* Prologue for TOC.  */
  if (bitmap_bit_p (components, 2))
    {
      rtx reg = gen_rtx_REG (reg_mode, TOC_REGNUM);
      rtx sp_reg = gen_rtx_REG (Pmode, STACK_POINTER_REGNUM);
      emit_insn (gen_frame_store (reg, sp_reg, RS6000_TOC_SAVE_SLOT));
    }

  /* Prologue for the GPRs.  */
  int offset = info->gp_save_offset;
  if (info->push_p)
    offset += info->total_size;

  for (int i = info->first_gp_reg_save; i < 32; i++)
    {
      if (bitmap_bit_p (components, i))
	{
	  rtx reg = gen_rtx_REG (reg_mode, i);
	  rtx_insn *insn = emit_insn (gen_frame_store (reg, ptr_reg, offset));
	  RTX_FRAME_RELATED_P (insn) = 1;
	  rtx set = copy_rtx (single_set (insn));
	  add_reg_note (insn, REG_CFA_OFFSET, set);
	}

      offset += reg_size;
    }

  /* Prologue for the FPRs.  */
  offset = info->fp_save_offset;
  if (info->push_p)
    offset += info->total_size;

  for (int i = info->first_fp_reg_save; i < 64; i++)
    {
      if (bitmap_bit_p (components, i))
	{
	  rtx reg = gen_rtx_REG (fp_reg_mode, i);
	  rtx_insn *insn = emit_insn (gen_frame_store (reg, ptr_reg, offset));
	  RTX_FRAME_RELATED_P (insn) = 1;
	  rtx set = copy_rtx (single_set (insn));
	  add_reg_note (insn, REG_CFA_OFFSET, set);
	}

      offset += fp_reg_size;
    }
}

/* Implement TARGET_SHRINK_WRAP_EMIT_EPILOGUE_COMPONENTS.  */
static void
rs6000_emit_epilogue_components (sbitmap components)
{
  rs6000_stack_t *info = rs6000_stack_info ();
  rtx ptr_reg = gen_rtx_REG (Pmode, frame_pointer_needed
			     ? HARD_FRAME_POINTER_REGNUM
			     : STACK_POINTER_REGNUM);

  machine_mode reg_mode = Pmode;
  int reg_size = TARGET_32BIT ? 4 : 8;

  machine_mode fp_reg_mode = TARGET_HARD_FLOAT ? DFmode : SFmode;
  int fp_reg_size = 8;

  /* Epilogue for the FPRs.  */
  int offset = info->fp_save_offset;
  if (info->push_p)
    offset += info->total_size;

  for (int i = info->first_fp_reg_save; i < 64; i++)
    {
      if (bitmap_bit_p (components, i))
	{
	  rtx reg = gen_rtx_REG (fp_reg_mode, i);
	  rtx_insn *insn = emit_insn (gen_frame_load (reg, ptr_reg, offset));
	  RTX_FRAME_RELATED_P (insn) = 1;
	  add_reg_note (insn, REG_CFA_RESTORE, reg);
	}

      offset += fp_reg_size;
    }

  /* Epilogue for the GPRs.  */
  offset = info->gp_save_offset;
  if (info->push_p)
    offset += info->total_size;

  for (int i = info->first_gp_reg_save; i < 32; i++)
    {
      if (bitmap_bit_p (components, i))
	{
	  rtx reg = gen_rtx_REG (reg_mode, i);
	  rtx_insn *insn = emit_insn (gen_frame_load (reg, ptr_reg, offset));
	  RTX_FRAME_RELATED_P (insn) = 1;
	  add_reg_note (insn, REG_CFA_RESTORE, reg);
	}

      offset += reg_size;
    }

  /* Epilogue for LR.  */
  if (bitmap_bit_p (components, 0))
    {
      int offset = info->lr_save_offset;
      if (info->push_p)
	offset += info->total_size;

      rtx reg = gen_rtx_REG (reg_mode, 0);
      rtx_insn *insn = emit_insn (gen_frame_load (reg, ptr_reg, offset));

      rtx lr = gen_rtx_REG (Pmode, LR_REGNO);
      insn = emit_move_insn (lr, reg);
      RTX_FRAME_RELATED_P (insn) = 1;
      add_reg_note (insn, REG_CFA_RESTORE, lr);
    }
}

/* Implement TARGET_SHRINK_WRAP_SET_HANDLED_COMPONENTS.  */
static void
rs6000_set_handled_components (sbitmap components)
{
  rs6000_stack_t *info = rs6000_stack_info ();

  for (int i = info->first_gp_reg_save; i < 32; i++)
    if (bitmap_bit_p (components, i))
      cfun->machine->gpr_is_wrapped_separately[i] = true;

  for (int i = info->first_fp_reg_save; i < 64; i++)
    if (bitmap_bit_p (components, i))
      cfun->machine->fpr_is_wrapped_separately[i - 32] = true;

  if (bitmap_bit_p (components, 0))
    cfun->machine->lr_is_wrapped_separately = true;

  if (bitmap_bit_p (components, 2))
    cfun->machine->toc_is_wrapped_separately = true;
}

/* VRSAVE is a bit vector representing which AltiVec registers
   are used.  The OS uses this to determine which vector
   registers to save on a context switch.  We need to save
   VRSAVE on the stack frame, add whatever AltiVec registers we
   used in this function, and do the corresponding magic in the
   epilogue.  */
static void
emit_vrsave_prologue (rs6000_stack_t *info, int save_regno,
		      HOST_WIDE_INT frame_off, rtx frame_reg_rtx)
{
  /* Get VRSAVE into a GPR.  */
  rtx reg = gen_rtx_REG (SImode, save_regno);
  rtx vrsave = gen_rtx_REG (SImode, VRSAVE_REGNO);
  if (TARGET_MACHO)
    emit_insn (gen_get_vrsave_internal (reg));
  else
    emit_insn (gen_rtx_SET (reg, vrsave));

  /* Save VRSAVE.  */
  int offset = info->vrsave_save_offset + frame_off;
  emit_insn (gen_frame_store (reg, frame_reg_rtx, offset));

  /* Include the registers in the mask.  */
  emit_insn (gen_iorsi3 (reg, reg, GEN_INT (info->vrsave_mask)));

  emit_insn (generate_set_vrsave (reg, info, 0));
}

/* Set up the arg pointer (r12) for -fsplit-stack code.  If __morestack was
   called, it left the arg pointer to the old stack in r29.  Otherwise, the
   arg pointer is the top of the current frame.  */
static void
emit_split_stack_prologue (rs6000_stack_t *info, rtx_insn *sp_adjust,
			   HOST_WIDE_INT frame_off, rtx frame_reg_rtx)
{
  cfun->machine->split_stack_argp_used = true;

  if (sp_adjust)
    {
      rtx r12 = gen_rtx_REG (Pmode, 12);
      rtx sp_reg_rtx = gen_rtx_REG (Pmode, STACK_POINTER_REGNUM);
      rtx set_r12 = gen_rtx_SET (r12, sp_reg_rtx);
      emit_insn_before (set_r12, sp_adjust);
    }
  else if (frame_off != 0 || REGNO (frame_reg_rtx) != 12)
    {
      rtx r12 = gen_rtx_REG (Pmode, 12);
      if (frame_off == 0)
	emit_move_insn (r12, frame_reg_rtx);
      else
	emit_insn (gen_add3_insn (r12, frame_reg_rtx, GEN_INT (frame_off)));
    }

  if (info->push_p)
    {
      rtx r12 = gen_rtx_REG (Pmode, 12);
      rtx r29 = gen_rtx_REG (Pmode, 29);
      rtx cr7 = gen_rtx_REG (CCUNSmode, CR7_REGNO);
      rtx not_more = gen_label_rtx ();
      rtx jump;

      jump = gen_rtx_IF_THEN_ELSE (VOIDmode,
				   gen_rtx_GEU (VOIDmode, cr7, const0_rtx),
				   gen_rtx_LABEL_REF (VOIDmode, not_more),
				   pc_rtx);
      jump = emit_jump_insn (gen_rtx_SET (pc_rtx, jump));
      JUMP_LABEL (jump) = not_more;
      LABEL_NUSES (not_more) += 1;
      emit_move_insn (r12, r29);
      emit_label (not_more);
    }
}

/* Emit function prologue as insns.  */

void
rs6000_emit_prologue (void)
{
  rs6000_stack_t *info = rs6000_stack_info ();
  machine_mode reg_mode = Pmode;
  int reg_size = TARGET_32BIT ? 4 : 8;
  machine_mode fp_reg_mode = TARGET_HARD_FLOAT ? DFmode : SFmode;
  int fp_reg_size = 8;
  rtx sp_reg_rtx = gen_rtx_REG (Pmode, STACK_POINTER_REGNUM);
  rtx frame_reg_rtx = sp_reg_rtx;
  unsigned int cr_save_regno;
  rtx cr_save_rtx = NULL_RTX;
  rtx_insn *insn;
  int strategy;
  int using_static_chain_p = (cfun->static_chain_decl != NULL_TREE
			      && df_regs_ever_live_p (STATIC_CHAIN_REGNUM)
			      && call_used_regs[STATIC_CHAIN_REGNUM]);
  int using_split_stack = (flag_split_stack
                           && (lookup_attribute ("no_split_stack",
                                                 DECL_ATTRIBUTES (cfun->decl))
                               == NULL));
 
  /* Offset to top of frame for frame_reg and sp respectively.  */
  HOST_WIDE_INT frame_off = 0;
  HOST_WIDE_INT sp_off = 0;
  /* sp_adjust is the stack adjusting instruction, tracked so that the
     insn setting up the split-stack arg pointer can be emitted just
     prior to it, when r12 is not used here for other purposes.  */
  rtx_insn *sp_adjust = 0;

#if CHECKING_P
  /* Track and check usage of r0, r11, r12.  */
  int reg_inuse = using_static_chain_p ? 1 << 11 : 0;
#define START_USE(R) do \
  {						\
    gcc_assert ((reg_inuse & (1 << (R))) == 0);	\
    reg_inuse |= 1 << (R);			\
  } while (0)
#define END_USE(R) do \
  {						\
    gcc_assert ((reg_inuse & (1 << (R))) != 0);	\
    reg_inuse &= ~(1 << (R));			\
  } while (0)
#define NOT_INUSE(R) do \
  {						\
    gcc_assert ((reg_inuse & (1 << (R))) == 0);	\
  } while (0)
#else
#define START_USE(R) do {} while (0)
#define END_USE(R) do {} while (0)
#define NOT_INUSE(R) do {} while (0)
#endif

  if (DEFAULT_ABI == ABI_ELFv2
      && !TARGET_SINGLE_PIC_BASE)
    {
      cfun->machine->r2_setup_needed = df_regs_ever_live_p (TOC_REGNUM);

      /* With -mminimal-toc we may generate an extra use of r2 below.  */
      if (TARGET_TOC && TARGET_MINIMAL_TOC
	  && !constant_pool_empty_p ())
	cfun->machine->r2_setup_needed = true;
    }


  if (flag_stack_usage_info)
    current_function_static_stack_size = info->total_size;

  if (flag_stack_check == STATIC_BUILTIN_STACK_CHECK)
    {
      HOST_WIDE_INT size = info->total_size;

      if (crtl->is_leaf && !cfun->calls_alloca)
	{
	  if (size > PROBE_INTERVAL && size > get_stack_check_protect ())
	    rs6000_emit_probe_stack_range (get_stack_check_protect (),
					   size - get_stack_check_protect ());
	}
      else if (size > 0)
	rs6000_emit_probe_stack_range (get_stack_check_protect (), size);
    }

  if (TARGET_FIX_AND_CONTINUE)
    {
      /* gdb on darwin arranges to forward a function from the old
	 address by modifying the first 5 instructions of the function
	 to branch to the overriding function.  This is necessary to
	 permit function pointers that point to the old function to
	 actually forward to the new function.  */
      emit_insn (gen_nop ());
      emit_insn (gen_nop ());
      emit_insn (gen_nop ());
      emit_insn (gen_nop ());
      emit_insn (gen_nop ());
    }

  /* Handle world saves specially here.  */
  if (WORLD_SAVE_P (info))
    {
      int i, j, sz;
      rtx treg;
      rtvec p;
      rtx reg0;

      /* save_world expects lr in r0. */
      reg0 = gen_rtx_REG (Pmode, 0);
      if (info->lr_save_p)
	{
	  insn = emit_move_insn (reg0,
				 gen_rtx_REG (Pmode, LR_REGNO));
	  RTX_FRAME_RELATED_P (insn) = 1;
	}

      /* The SAVE_WORLD and RESTORE_WORLD routines make a number of
	 assumptions about the offsets of various bits of the stack
	 frame.  */
      gcc_assert (info->gp_save_offset == -220
		  && info->fp_save_offset == -144
		  && info->lr_save_offset == 8
		  && info->cr_save_offset == 4
		  && info->push_p
		  && info->lr_save_p
		  && (!crtl->calls_eh_return
		      || info->ehrd_offset == -432)
		  && info->vrsave_save_offset == -224
		  && info->altivec_save_offset == -416);

      treg = gen_rtx_REG (SImode, 11);
      emit_move_insn (treg, GEN_INT (-info->total_size));

      /* SAVE_WORLD takes the caller's LR in R0 and the frame size
	 in R11.  It also clobbers R12, so beware!  */

      /* Preserve CR2 for save_world prologues */
      sz = 5;
      sz += 32 - info->first_gp_reg_save;
      sz += 64 - info->first_fp_reg_save;
      sz += LAST_ALTIVEC_REGNO - info->first_altivec_reg_save + 1;
      p = rtvec_alloc (sz);
      j = 0;
      RTVEC_ELT (p, j++) = gen_hard_reg_clobber (SImode, LR_REGNO);
      RTVEC_ELT (p, j++) = gen_rtx_USE (VOIDmode,
					gen_rtx_SYMBOL_REF (Pmode,
							    "*save_world"));
      /* We do floats first so that the instruction pattern matches
	 properly.  */
      for (i = 0; i < 64 - info->first_fp_reg_save; i++)
	RTVEC_ELT (p, j++)
	  = gen_frame_store (gen_rtx_REG (TARGET_HARD_FLOAT ? DFmode : SFmode,
					  info->first_fp_reg_save + i),
			     frame_reg_rtx,
			     info->fp_save_offset + frame_off + 8 * i);
      for (i = 0; info->first_altivec_reg_save + i <= LAST_ALTIVEC_REGNO; i++)
	RTVEC_ELT (p, j++)
	  = gen_frame_store (gen_rtx_REG (V4SImode,
					  info->first_altivec_reg_save + i),
			     frame_reg_rtx,
			     info->altivec_save_offset + frame_off + 16 * i);
      for (i = 0; i < 32 - info->first_gp_reg_save; i++)
	RTVEC_ELT (p, j++)
	  = gen_frame_store (gen_rtx_REG (reg_mode, info->first_gp_reg_save + i),
			     frame_reg_rtx,
			     info->gp_save_offset + frame_off + reg_size * i);

      /* CR register traditionally saved as CR2.  */
      RTVEC_ELT (p, j++)
	= gen_frame_store (gen_rtx_REG (SImode, CR2_REGNO),
			   frame_reg_rtx, info->cr_save_offset + frame_off);
      /* Explain about use of R0.  */
      if (info->lr_save_p)
	RTVEC_ELT (p, j++)
	  = gen_frame_store (reg0,
			     frame_reg_rtx, info->lr_save_offset + frame_off);
      /* Explain what happens to the stack pointer.  */
      {
	rtx newval = gen_rtx_PLUS (Pmode, sp_reg_rtx, treg);
	RTVEC_ELT (p, j++) = gen_rtx_SET (sp_reg_rtx, newval);
      }

      insn = emit_insn (gen_rtx_PARALLEL (VOIDmode, p));
      rs6000_frame_related (insn, frame_reg_rtx, sp_off - frame_off,
			    treg, GEN_INT (-info->total_size));
      sp_off = frame_off = info->total_size;
    }

  strategy = info->savres_strategy;

  /* For V.4, update stack before we do any saving and set back pointer.  */
  if (! WORLD_SAVE_P (info)
      && info->push_p
      && (DEFAULT_ABI == ABI_V4
	  || crtl->calls_eh_return))
    {
      bool need_r11 = (!(strategy & SAVE_INLINE_FPRS)
		       || !(strategy & SAVE_INLINE_GPRS)
		       || !(strategy & SAVE_INLINE_VRS));
      int ptr_regno = -1;
      rtx ptr_reg = NULL_RTX;
      int ptr_off = 0;

      if (info->total_size < 32767)
	frame_off = info->total_size;
      else if (need_r11)
	ptr_regno = 11;
      else if (info->cr_save_p
	       || info->lr_save_p
	       || info->first_fp_reg_save < 64
	       || info->first_gp_reg_save < 32
	       || info->altivec_size != 0
	       || info->vrsave_size != 0
	       || crtl->calls_eh_return)
	ptr_regno = 12;
      else
	{
	  /* The prologue won't be saving any regs so there is no need
	     to set up a frame register to access any frame save area.
	     We also won't be using frame_off anywhere below, but set
	     the correct value anyway to protect against future
	     changes to this function.  */
	  frame_off = info->total_size;
	}
      if (ptr_regno != -1)
	{
	  /* Set up the frame offset to that needed by the first
	     out-of-line save function.  */
	  START_USE (ptr_regno);
	  ptr_reg = gen_rtx_REG (Pmode, ptr_regno);
	  frame_reg_rtx = ptr_reg;
	  if (!(strategy & SAVE_INLINE_FPRS) && info->fp_size != 0)
	    gcc_checking_assert (info->fp_save_offset + info->fp_size == 0);
	  else if (!(strategy & SAVE_INLINE_GPRS) && info->first_gp_reg_save < 32)
	    ptr_off = info->gp_save_offset + info->gp_size;
	  else if (!(strategy & SAVE_INLINE_VRS) && info->altivec_size != 0)
	    ptr_off = info->altivec_save_offset + info->altivec_size;
	  frame_off = -ptr_off;
	}
      sp_adjust = rs6000_emit_allocate_stack (info->total_size,
					      ptr_reg, ptr_off);
      if (REGNO (frame_reg_rtx) == 12)
	sp_adjust = 0;
      sp_off = info->total_size;
      if (frame_reg_rtx != sp_reg_rtx)
	rs6000_emit_stack_tie (frame_reg_rtx, false);
    }

  /* If we use the link register, get it into r0.  */
  if (!WORLD_SAVE_P (info) && info->lr_save_p
      && !cfun->machine->lr_is_wrapped_separately)
    {
      rtx addr, reg, mem;

      reg = gen_rtx_REG (Pmode, 0);
      START_USE (0);
      insn = emit_move_insn (reg, gen_rtx_REG (Pmode, LR_REGNO));
      RTX_FRAME_RELATED_P (insn) = 1;

      if (!(strategy & (SAVE_NOINLINE_GPRS_SAVES_LR
			| SAVE_NOINLINE_FPRS_SAVES_LR)))
	{
	  addr = gen_rtx_PLUS (Pmode, frame_reg_rtx,
			       GEN_INT (info->lr_save_offset + frame_off));
	  mem = gen_rtx_MEM (Pmode, addr);
	  /* This should not be of rs6000_sr_alias_set, because of
	     __builtin_return_address.  */

	  insn = emit_move_insn (mem, reg);
	  rs6000_frame_related (insn, frame_reg_rtx, sp_off - frame_off,
				NULL_RTX, NULL_RTX);
	  END_USE (0);
	}
    }

  /* If we need to save CR, put it into r12 or r11.  Choose r12 except when
     r12 will be needed by out-of-line gpr save.  */
  cr_save_regno = ((DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2)
		   && !(strategy & (SAVE_INLINE_GPRS
				    | SAVE_NOINLINE_GPRS_SAVES_LR))
		   ? 11 : 12);
  if (!WORLD_SAVE_P (info)
      && info->cr_save_p
      && REGNO (frame_reg_rtx) != cr_save_regno
      && !(using_static_chain_p && cr_save_regno == 11)
      && !(using_split_stack && cr_save_regno == 12 && sp_adjust))
    {
      cr_save_rtx = gen_rtx_REG (SImode, cr_save_regno);
      START_USE (cr_save_regno);
      rs6000_emit_prologue_move_from_cr (cr_save_rtx);
    }

  /* Do any required saving of fpr's.  If only one or two to save, do
     it ourselves.  Otherwise, call function.  */
  if (!WORLD_SAVE_P (info) && (strategy & SAVE_INLINE_FPRS))
    {
      int offset = info->fp_save_offset + frame_off;
      for (int i = info->first_fp_reg_save; i < 64; i++)
	{
	  if (save_reg_p (i)
	      && !cfun->machine->fpr_is_wrapped_separately[i - 32])
	    emit_frame_save (frame_reg_rtx, fp_reg_mode, i, offset,
			     sp_off - frame_off);

	  offset += fp_reg_size;
	}
    }
  else if (!WORLD_SAVE_P (info) && info->first_fp_reg_save != 64)
    {
      bool lr = (strategy & SAVE_NOINLINE_FPRS_SAVES_LR) != 0;
      int sel = SAVRES_SAVE | SAVRES_FPR | (lr ? SAVRES_LR : 0);
      unsigned ptr_regno = ptr_regno_for_savres (sel);
      rtx ptr_reg = frame_reg_rtx;

      if (REGNO (frame_reg_rtx) == ptr_regno)
	gcc_checking_assert (frame_off == 0);
      else
	{
	  ptr_reg = gen_rtx_REG (Pmode, ptr_regno);
	  NOT_INUSE (ptr_regno);
	  emit_insn (gen_add3_insn (ptr_reg,
				    frame_reg_rtx, GEN_INT (frame_off)));
	}
      insn = rs6000_emit_savres_rtx (info, ptr_reg,
				     info->fp_save_offset,
				     info->lr_save_offset,
				     DFmode, sel);
      rs6000_frame_related (insn, ptr_reg, sp_off,
			    NULL_RTX, NULL_RTX);
      if (lr)
	END_USE (0);
    }

  /* Save GPRs.  This is done as a PARALLEL if we are using
     the store-multiple instructions.  */
  if (!WORLD_SAVE_P (info) && !(strategy & SAVE_INLINE_GPRS))
    {
      bool lr = (strategy & SAVE_NOINLINE_GPRS_SAVES_LR) != 0;
      int sel = SAVRES_SAVE | SAVRES_GPR | (lr ? SAVRES_LR : 0);
      unsigned ptr_regno = ptr_regno_for_savres (sel);
      rtx ptr_reg = frame_reg_rtx;
      bool ptr_set_up = REGNO (ptr_reg) == ptr_regno;
      int end_save = info->gp_save_offset + info->gp_size;
      int ptr_off;

      if (ptr_regno == 12)
	sp_adjust = 0;
      if (!ptr_set_up)
	ptr_reg = gen_rtx_REG (Pmode, ptr_regno);

      /* Need to adjust r11 (r12) if we saved any FPRs.  */
      if (end_save + frame_off != 0)
	{
	  rtx offset = GEN_INT (end_save + frame_off);

	  if (ptr_set_up)
	    frame_off = -end_save;
	  else
	    NOT_INUSE (ptr_regno);
	  emit_insn (gen_add3_insn (ptr_reg, frame_reg_rtx, offset));
	}
      else if (!ptr_set_up)
	{
	  NOT_INUSE (ptr_regno);
	  emit_move_insn (ptr_reg, frame_reg_rtx);
	}
      ptr_off = -end_save;
      insn = rs6000_emit_savres_rtx (info, ptr_reg,
				     info->gp_save_offset + ptr_off,
				     info->lr_save_offset + ptr_off,
				     reg_mode, sel);
      rs6000_frame_related (insn, ptr_reg, sp_off - ptr_off,
			    NULL_RTX, NULL_RTX);
      if (lr)
	END_USE (0);
    }
  else if (!WORLD_SAVE_P (info) && (strategy & SAVE_MULTIPLE))
    {
      rtvec p;
      int i;
      p = rtvec_alloc (32 - info->first_gp_reg_save);
      for (i = 0; i < 32 - info->first_gp_reg_save; i++)
	RTVEC_ELT (p, i)
	  = gen_frame_store (gen_rtx_REG (reg_mode, info->first_gp_reg_save + i),
			     frame_reg_rtx,
			     info->gp_save_offset + frame_off + reg_size * i);
      insn = emit_insn (gen_rtx_PARALLEL (VOIDmode, p));
      rs6000_frame_related (insn, frame_reg_rtx, sp_off - frame_off,
			    NULL_RTX, NULL_RTX);
    }
  else if (!WORLD_SAVE_P (info))
    {
      int offset = info->gp_save_offset + frame_off;
      for (int i = info->first_gp_reg_save; i < 32; i++)
	{
	  if (save_reg_p (i)
	      && !cfun->machine->gpr_is_wrapped_separately[i])
	    emit_frame_save (frame_reg_rtx, reg_mode, i, offset,
			     sp_off - frame_off);

	  offset += reg_size;
	}
    }

  if (crtl->calls_eh_return)
    {
      unsigned int i;
      rtvec p;

      for (i = 0; ; ++i)
	{
	  unsigned int regno = EH_RETURN_DATA_REGNO (i);
	  if (regno == INVALID_REGNUM)
	    break;
	}

      p = rtvec_alloc (i);

      for (i = 0; ; ++i)
	{
	  unsigned int regno = EH_RETURN_DATA_REGNO (i);
	  if (regno == INVALID_REGNUM)
	    break;

	  rtx set
	    = gen_frame_store (gen_rtx_REG (reg_mode, regno),
			       sp_reg_rtx,
			       info->ehrd_offset + sp_off + reg_size * (int) i);
	  RTVEC_ELT (p, i) = set;
	  RTX_FRAME_RELATED_P (set) = 1;
	}

      insn = emit_insn (gen_blockage ());
      RTX_FRAME_RELATED_P (insn) = 1;
      add_reg_note (insn, REG_FRAME_RELATED_EXPR, gen_rtx_PARALLEL (VOIDmode, p));
    }

  /* In AIX ABI we need to make sure r2 is really saved.  */
  if (TARGET_AIX && crtl->calls_eh_return)
    {
      rtx tmp_reg, tmp_reg_si, hi, lo, compare_result, toc_save_done, jump;
      rtx join_insn, note;
      rtx_insn *save_insn;
      long toc_restore_insn;

      tmp_reg = gen_rtx_REG (Pmode, 11);
      tmp_reg_si = gen_rtx_REG (SImode, 11);
      if (using_static_chain_p)
	{
	  START_USE (0);
	  emit_move_insn (gen_rtx_REG (Pmode, 0), tmp_reg);
	}
      else
	START_USE (11);
      emit_move_insn (tmp_reg, gen_rtx_REG (Pmode, LR_REGNO));
      /* Peek at instruction to which this function returns.  If it's
	 restoring r2, then we know we've already saved r2.  We can't
	 unconditionally save r2 because the value we have will already
	 be updated if we arrived at this function via a plt call or
	 toc adjusting stub.  */
      emit_move_insn (tmp_reg_si, gen_rtx_MEM (SImode, tmp_reg));
      toc_restore_insn = ((TARGET_32BIT ? 0x80410000 : 0xE8410000)
			  + RS6000_TOC_SAVE_SLOT);
      hi = gen_int_mode (toc_restore_insn & ~0xffff, SImode);
      emit_insn (gen_xorsi3 (tmp_reg_si, tmp_reg_si, hi));
      compare_result = gen_rtx_REG (CCUNSmode, CR0_REGNO);
      validate_condition_mode (EQ, CCUNSmode);
      lo = gen_int_mode (toc_restore_insn & 0xffff, SImode);
      emit_insn (gen_rtx_SET (compare_result,
			      gen_rtx_COMPARE (CCUNSmode, tmp_reg_si, lo)));
      toc_save_done = gen_label_rtx ();
      jump = gen_rtx_IF_THEN_ELSE (VOIDmode,
				   gen_rtx_EQ (VOIDmode, compare_result,
					       const0_rtx),
				   gen_rtx_LABEL_REF (VOIDmode, toc_save_done),
				   pc_rtx);
      jump = emit_jump_insn (gen_rtx_SET (pc_rtx, jump));
      JUMP_LABEL (jump) = toc_save_done;
      LABEL_NUSES (toc_save_done) += 1;

      save_insn = emit_frame_save (frame_reg_rtx, reg_mode,
				   TOC_REGNUM, frame_off + RS6000_TOC_SAVE_SLOT,
				   sp_off - frame_off);

      emit_label (toc_save_done);

      /* ??? If we leave SAVE_INSN as marked as saving R2, then we'll
	 have a CFG that has different saves along different paths.
	 Move the note to a dummy blockage insn, which describes that
	 R2 is unconditionally saved after the label.  */
      /* ??? An alternate representation might be a special insn pattern
	 containing both the branch and the store.  That might let the
	 code that minimizes the number of DW_CFA_advance opcodes better
	 freedom in placing the annotations.  */
      note = find_reg_note (save_insn, REG_FRAME_RELATED_EXPR, NULL);
      if (note)
	remove_note (save_insn, note);
      else
	note = alloc_reg_note (REG_FRAME_RELATED_EXPR,
			       copy_rtx (PATTERN (save_insn)), NULL_RTX);
      RTX_FRAME_RELATED_P (save_insn) = 0;

      join_insn = emit_insn (gen_blockage ());
      REG_NOTES (join_insn) = note;
      RTX_FRAME_RELATED_P (join_insn) = 1;

      if (using_static_chain_p)
	{
	  emit_move_insn (tmp_reg, gen_rtx_REG (Pmode, 0));
	  END_USE (0);
	}
      else
	END_USE (11);
    }

  /* Save CR if we use any that must be preserved.  */
  if (!WORLD_SAVE_P (info) && info->cr_save_p)
    {
      rtx addr = gen_rtx_PLUS (Pmode, frame_reg_rtx,
			       GEN_INT (info->cr_save_offset + frame_off));
      rtx mem = gen_frame_mem (SImode, addr);

      /* If we didn't copy cr before, do so now using r0.  */
      if (cr_save_rtx == NULL_RTX)
	{
	  START_USE (0);
	  cr_save_rtx = gen_rtx_REG (SImode, 0);
	  rs6000_emit_prologue_move_from_cr (cr_save_rtx);
	}

      /* Saving CR requires a two-instruction sequence: one instruction
	 to move the CR to a general-purpose register, and a second
	 instruction that stores the GPR to memory.

	 We do not emit any DWARF CFI records for the first of these,
	 because we cannot properly represent the fact that CR is saved in
	 a register.  One reason is that we cannot express that multiple
	 CR fields are saved; another reason is that on 64-bit, the size
	 of the CR register in DWARF (4 bytes) differs from the size of
	 a general-purpose register.

	 This means if any intervening instruction were to clobber one of
	 the call-saved CR fields, we'd have incorrect CFI.  To prevent
	 this from happening, we mark the store to memory as a use of
	 those CR fields, which prevents any such instruction from being
	 scheduled in between the two instructions.  */
      rtx crsave_v[9];
      int n_crsave = 0;
      int i;

      crsave_v[n_crsave++] = gen_rtx_SET (mem, cr_save_rtx);
      for (i = 0; i < 8; i++)
	if (save_reg_p (CR0_REGNO + i))
	  crsave_v[n_crsave++]
	    = gen_rtx_USE (VOIDmode, gen_rtx_REG (CCmode, CR0_REGNO + i));

      insn = emit_insn (gen_rtx_PARALLEL (VOIDmode,
					  gen_rtvec_v (n_crsave, crsave_v)));
      END_USE (REGNO (cr_save_rtx));

      /* Now, there's no way that dwarf2out_frame_debug_expr is going to
	 understand '(unspec:SI [(reg:CC 68) ...] UNSPEC_MOVESI_FROM_CR)',
	 so we need to construct a frame expression manually.  */
      RTX_FRAME_RELATED_P (insn) = 1;

      /* Update address to be stack-pointer relative, like
	 rs6000_frame_related would do.  */
      addr = gen_rtx_PLUS (Pmode, gen_rtx_REG (Pmode, STACK_POINTER_REGNUM),
			   GEN_INT (info->cr_save_offset + sp_off));
      mem = gen_frame_mem (SImode, addr);

      if (DEFAULT_ABI == ABI_ELFv2)
	{
	  /* In the ELFv2 ABI we generate separate CFI records for each
	     CR field that was actually saved.  They all point to the
	     same 32-bit stack slot.  */
	  rtx crframe[8];
	  int n_crframe = 0;

	  for (i = 0; i < 8; i++)
	    if (save_reg_p (CR0_REGNO + i))
	      {
		crframe[n_crframe]
		  = gen_rtx_SET (mem, gen_rtx_REG (SImode, CR0_REGNO + i));

		RTX_FRAME_RELATED_P (crframe[n_crframe]) = 1;
		n_crframe++;
	     }

	  add_reg_note (insn, REG_FRAME_RELATED_EXPR,
			gen_rtx_PARALLEL (VOIDmode,
					  gen_rtvec_v (n_crframe, crframe)));
	}
      else
	{
	  /* In other ABIs, by convention, we use a single CR regnum to
	     represent the fact that all call-saved CR fields are saved.
	     We use CR2_REGNO to be compatible with gcc-2.95 on Linux.  */
	  rtx set = gen_rtx_SET (mem, gen_rtx_REG (SImode, CR2_REGNO));
	  add_reg_note (insn, REG_FRAME_RELATED_EXPR, set);
	}
    }

  /* In the ELFv2 ABI we need to save all call-saved CR fields into
     *separate* slots if the routine calls __builtin_eh_return, so
     that they can be independently restored by the unwinder.  */
  if (DEFAULT_ABI == ABI_ELFv2 && crtl->calls_eh_return)
    {
      int i, cr_off = info->ehcr_offset;
      rtx crsave;

      /* ??? We might get better performance by using multiple mfocrf
	 instructions.  */
      crsave = gen_rtx_REG (SImode, 0);
      emit_insn (gen_prologue_movesi_from_cr (crsave));

      for (i = 0; i < 8; i++)
	if (!call_used_regs[CR0_REGNO + i])
	  {
	    rtvec p = rtvec_alloc (2);
	    RTVEC_ELT (p, 0)
	      = gen_frame_store (crsave, frame_reg_rtx, cr_off + frame_off);
	    RTVEC_ELT (p, 1)
	      = gen_rtx_USE (VOIDmode, gen_rtx_REG (CCmode, CR0_REGNO + i));

	    insn = emit_insn (gen_rtx_PARALLEL (VOIDmode, p));

	    RTX_FRAME_RELATED_P (insn) = 1;
	    add_reg_note (insn, REG_FRAME_RELATED_EXPR,
			  gen_frame_store (gen_rtx_REG (SImode, CR0_REGNO + i),
					   sp_reg_rtx, cr_off + sp_off));

	    cr_off += reg_size;
	  }
    }

  /* If we are emitting stack probes, but allocate no stack, then
     just note that in the dump file.  */
  if (flag_stack_clash_protection
      && dump_file
      && !info->push_p)
    dump_stack_clash_frame_info (NO_PROBE_NO_FRAME, false);

  /* Update stack and set back pointer unless this is V.4,
     for which it was done previously.  */
  if (!WORLD_SAVE_P (info) && info->push_p
      && !(DEFAULT_ABI == ABI_V4 || crtl->calls_eh_return))
    {
      rtx ptr_reg = NULL;
      int ptr_off = 0;

      /* If saving altivec regs we need to be able to address all save
	 locations using a 16-bit offset.  */
      if ((strategy & SAVE_INLINE_VRS) == 0
	  || (info->altivec_size != 0
	      && (info->altivec_save_offset + info->altivec_size - 16
		  + info->total_size - frame_off) > 32767)
	  || (info->vrsave_size != 0
	      && (info->vrsave_save_offset
		  + info->total_size - frame_off) > 32767))
	{
	  int sel = SAVRES_SAVE | SAVRES_VR;
	  unsigned ptr_regno = ptr_regno_for_savres (sel);

	  if (using_static_chain_p
	      && ptr_regno == STATIC_CHAIN_REGNUM)
	    ptr_regno = 12;
	  if (REGNO (frame_reg_rtx) != ptr_regno)
	    START_USE (ptr_regno);
	  ptr_reg = gen_rtx_REG (Pmode, ptr_regno);
	  frame_reg_rtx = ptr_reg;
	  ptr_off = info->altivec_save_offset + info->altivec_size;
	  frame_off = -ptr_off;
	}
      else if (REGNO (frame_reg_rtx) == 1)
	frame_off = info->total_size;
      sp_adjust = rs6000_emit_allocate_stack (info->total_size,
					      ptr_reg, ptr_off);
      if (REGNO (frame_reg_rtx) == 12)
	sp_adjust = 0;
      sp_off = info->total_size;
      if (frame_reg_rtx != sp_reg_rtx)
	rs6000_emit_stack_tie (frame_reg_rtx, false);
    }

  /* Set frame pointer, if needed.  */
  if (frame_pointer_needed)
    {
      insn = emit_move_insn (gen_rtx_REG (Pmode, HARD_FRAME_POINTER_REGNUM),
			     sp_reg_rtx);
      RTX_FRAME_RELATED_P (insn) = 1;
    }

  /* Save AltiVec registers if needed.  Save here because the red zone does
     not always include AltiVec registers.  */
  if (!WORLD_SAVE_P (info)
      && info->altivec_size != 0 && (strategy & SAVE_INLINE_VRS) == 0)
    {
      int end_save = info->altivec_save_offset + info->altivec_size;
      int ptr_off;
      /* Oddly, the vector save/restore functions point r0 at the end
	 of the save area, then use r11 or r12 to load offsets for
	 [reg+reg] addressing.  */
      rtx ptr_reg = gen_rtx_REG (Pmode, 0);
      int scratch_regno = ptr_regno_for_savres (SAVRES_SAVE | SAVRES_VR);
      rtx scratch_reg = gen_rtx_REG (Pmode, scratch_regno);

      gcc_checking_assert (scratch_regno == 11 || scratch_regno == 12);
      NOT_INUSE (0);
      if (scratch_regno == 12)
	sp_adjust = 0;
      if (end_save + frame_off != 0)
	{
	  rtx offset = GEN_INT (end_save + frame_off);

	  emit_insn (gen_add3_insn (ptr_reg, frame_reg_rtx, offset));
	}
      else
	emit_move_insn (ptr_reg, frame_reg_rtx);

      ptr_off = -end_save;
      insn = rs6000_emit_savres_rtx (info, scratch_reg,
				     info->altivec_save_offset + ptr_off,
				     0, V4SImode, SAVRES_SAVE | SAVRES_VR);
      rs6000_frame_related (insn, scratch_reg, sp_off - ptr_off,
			    NULL_RTX, NULL_RTX);
      if (REGNO (frame_reg_rtx) == REGNO (scratch_reg))
	{
	  /* The oddity mentioned above clobbered our frame reg.  */
	  emit_move_insn (frame_reg_rtx, ptr_reg);
	  frame_off = ptr_off;
	}
    }
  else if (!WORLD_SAVE_P (info)
	   && info->altivec_size != 0)
    {
      int i;

      for (i = info->first_altivec_reg_save; i <= LAST_ALTIVEC_REGNO; ++i)
	if (info->vrsave_mask & ALTIVEC_REG_BIT (i))
	  {
	    rtx areg, savereg, mem;
	    HOST_WIDE_INT offset;

	    offset = (info->altivec_save_offset + frame_off
		      + 16 * (i - info->first_altivec_reg_save));

	    savereg = gen_rtx_REG (V4SImode, i);

	    if (TARGET_P9_VECTOR && quad_address_offset_p (offset))
	      {
		mem = gen_frame_mem (V4SImode,
				     gen_rtx_PLUS (Pmode, frame_reg_rtx,
						   GEN_INT (offset)));
		insn = emit_insn (gen_rtx_SET (mem, savereg));
		areg = NULL_RTX;
	      }
	    else
	      {
		NOT_INUSE (0);
		areg = gen_rtx_REG (Pmode, 0);
		emit_move_insn (areg, GEN_INT (offset));

		/* AltiVec addressing mode is [reg+reg].  */
		mem = gen_frame_mem (V4SImode,
				     gen_rtx_PLUS (Pmode, frame_reg_rtx, areg));

		/* Rather than emitting a generic move, force use of the stvx
		   instruction, which we always want on ISA 2.07 (power8) systems.
		   In particular we don't want xxpermdi/stxvd2x for little
		   endian.  */
		insn = emit_insn (gen_altivec_stvx_v4si_internal (mem, savereg));
	      }

	    rs6000_frame_related (insn, frame_reg_rtx, sp_off - frame_off,
				  areg, GEN_INT (offset));
	  }
    }

  /* VRSAVE is a bit vector representing which AltiVec registers
     are used.  The OS uses this to determine which vector
     registers to save on a context switch.  We need to save
     VRSAVE on the stack frame, add whatever AltiVec registers we
     used in this function, and do the corresponding magic in the
     epilogue.  */

  if (!WORLD_SAVE_P (info) && info->vrsave_size != 0)
    {
      /* Get VRSAVE into a GPR.  Note that ABI_V4 and ABI_DARWIN might
	 be using r12 as frame_reg_rtx and r11 as the static chain
	 pointer for nested functions.  */
      int save_regno = 12;
      if ((DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2)
	  && !using_static_chain_p)
	save_regno = 11;
      else if (using_split_stack || REGNO (frame_reg_rtx) == 12)
	{
	  save_regno = 11;
	  if (using_static_chain_p)
	    save_regno = 0;
	}
      NOT_INUSE (save_regno);

      emit_vrsave_prologue (info, save_regno, frame_off, frame_reg_rtx);
    }

  /* If we are using RS6000_PIC_OFFSET_TABLE_REGNUM, we need to set it up.  */
  if (!TARGET_SINGLE_PIC_BASE
      && ((TARGET_TOC && TARGET_MINIMAL_TOC
	   && !constant_pool_empty_p ())
	  || (DEFAULT_ABI == ABI_V4
	      && (flag_pic == 1 || (flag_pic && TARGET_SECURE_PLT))
	      && df_regs_ever_live_p (RS6000_PIC_OFFSET_TABLE_REGNUM))))
    {
      /* If emit_load_toc_table will use the link register, we need to save
	 it.  We use R12 for this purpose because emit_load_toc_table
	 can use register 0.  This allows us to use a plain 'blr' to return
	 from the procedure more often.  */
      int save_LR_around_toc_setup = (TARGET_ELF
				      && DEFAULT_ABI == ABI_V4
				      && flag_pic
				      && ! info->lr_save_p
				      && EDGE_COUNT (EXIT_BLOCK_PTR_FOR_FN (cfun)->preds) > 0);
      if (save_LR_around_toc_setup)
	{
	  rtx lr = gen_rtx_REG (Pmode, LR_REGNO);
	  rtx tmp = gen_rtx_REG (Pmode, 12);

	  sp_adjust = 0;
	  insn = emit_move_insn (tmp, lr);
	  RTX_FRAME_RELATED_P (insn) = 1;

	  rs6000_emit_load_toc_table (TRUE);

	  insn = emit_move_insn (lr, tmp);
	  add_reg_note (insn, REG_CFA_RESTORE, lr);
	  RTX_FRAME_RELATED_P (insn) = 1;
	}
      else
	rs6000_emit_load_toc_table (TRUE);
    }

#if TARGET_MACHO
  if (!TARGET_SINGLE_PIC_BASE
      && DEFAULT_ABI == ABI_DARWIN
      && flag_pic && crtl->uses_pic_offset_table)
    {
      rtx lr = gen_rtx_REG (Pmode, LR_REGNO);
      rtx src = gen_rtx_SYMBOL_REF (Pmode, MACHOPIC_FUNCTION_BASE_NAME);

      /* Save and restore LR locally around this call (in R0).  */
      if (!info->lr_save_p)
	emit_move_insn (gen_rtx_REG (Pmode, 0), lr);

      emit_insn (gen_load_macho_picbase (src));

      emit_move_insn (gen_rtx_REG (Pmode,
				   RS6000_PIC_OFFSET_TABLE_REGNUM),
		      lr);

      if (!info->lr_save_p)
	emit_move_insn (lr, gen_rtx_REG (Pmode, 0));
    }
#endif

  /* If we need to, save the TOC register after doing the stack setup.
     Do not emit eh frame info for this save.  The unwinder wants info,
     conceptually attached to instructions in this function, about
     register values in the caller of this function.  This R2 may have
     already been changed from the value in the caller.
     We don't attempt to write accurate DWARF EH frame info for R2
     because code emitted by gcc for a (non-pointer) function call
     doesn't save and restore R2.  Instead, R2 is managed out-of-line
     by a linker generated plt call stub when the function resides in
     a shared library.  This behavior is costly to describe in DWARF,
     both in terms of the size of DWARF info and the time taken in the
     unwinder to interpret it.  R2 changes, apart from the
     calls_eh_return case earlier in this function, are handled by
     linux-unwind.h frob_update_context.  */
  if (rs6000_save_toc_in_prologue_p ()
      && !cfun->machine->toc_is_wrapped_separately)
    {
      rtx reg = gen_rtx_REG (reg_mode, TOC_REGNUM);
      emit_insn (gen_frame_store (reg, sp_reg_rtx, RS6000_TOC_SAVE_SLOT));
    }

  /* Set up the arg pointer (r12) for -fsplit-stack code.  */
  if (using_split_stack && split_stack_arg_pointer_used_p ())
    emit_split_stack_prologue (info, sp_adjust, frame_off, frame_reg_rtx);
}

/* Output .extern statements for the save/restore routines we use.  */

static void
rs6000_output_savres_externs (FILE *file)
{
  rs6000_stack_t *info = rs6000_stack_info ();

  if (TARGET_DEBUG_STACK)
    debug_stack_info (info);

  /* Write .extern for any function we will call to save and restore
     fp values.  */
  if (info->first_fp_reg_save < 64
      && !TARGET_MACHO
      && !TARGET_ELF)
    {
      char *name;
      int regno = info->first_fp_reg_save - 32;

      if ((info->savres_strategy & SAVE_INLINE_FPRS) == 0)
	{
	  bool lr = (info->savres_strategy & SAVE_NOINLINE_FPRS_SAVES_LR) != 0;
	  int sel = SAVRES_SAVE | SAVRES_FPR | (lr ? SAVRES_LR : 0);
	  name = rs6000_savres_routine_name (regno, sel);
	  fprintf (file, "\t.extern %s\n", name);
	}
      if ((info->savres_strategy & REST_INLINE_FPRS) == 0)
	{
	  bool lr = (info->savres_strategy
		     & REST_NOINLINE_FPRS_DOESNT_RESTORE_LR) == 0;
	  int sel = SAVRES_FPR | (lr ? SAVRES_LR : 0);
	  name = rs6000_savres_routine_name (regno, sel);
	  fprintf (file, "\t.extern %s\n", name);
	}
    }
}

/* Write function prologue.  */

static void
rs6000_output_function_prologue (FILE *file)
{
  if (!cfun->is_thunk)
    {
      rs6000_output_savres_externs (file);
#ifdef USING_ELFOS_H
      const char *curr_machine = rs6000_machine_from_flags ();
      if (rs6000_machine != curr_machine)
	{
	  rs6000_machine = curr_machine;
	  emit_asm_machine ();
	}
#endif
    }

  /* ELFv2 ABI r2 setup code and local entry point.  This must follow
     immediately after the global entry point label.  */
  if (rs6000_global_entry_point_prologue_needed_p ())
    {
      const char *name = XSTR (XEXP (DECL_RTL (current_function_decl), 0), 0);
      (*targetm.asm_out.internal_label) (file, "LCF", rs6000_pic_labelno);

      if (TARGET_CMODEL != CMODEL_LARGE)
	{
	  /* In the small and medium code models, we assume the TOC is less
	     2 GB away from the text section, so it can be computed via the
	     following two-instruction sequence.  */
	  char buf[256];

	  ASM_GENERATE_INTERNAL_LABEL (buf, "LCF", rs6000_pic_labelno);
	  fprintf (file, "0:\taddis 2,12,.TOC.-");
	  assemble_name (file, buf);
	  fprintf (file, "@ha\n");
	  fprintf (file, "\taddi 2,2,.TOC.-");
	  assemble_name (file, buf);
	  fprintf (file, "@l\n");
	}
      else
	{
	  /* In the large code model, we allow arbitrary offsets between the
	     TOC and the text section, so we have to load the offset from
	     memory.  The data field is emitted directly before the global
	     entry point in rs6000_elf_declare_function_name.  */
	  char buf[256];

#ifdef HAVE_AS_ENTRY_MARKERS
	  /* If supported by the linker, emit a marker relocation.  If the
	     total code size of the final executable or shared library
	     happens to fit into 2 GB after all, the linker will replace
	     this code sequence with the sequence for the small or medium
	     code model.  */
	  fprintf (file, "\t.reloc .,R_PPC64_ENTRY\n");
#endif
	  fprintf (file, "\tld 2,");
	  ASM_GENERATE_INTERNAL_LABEL (buf, "LCL", rs6000_pic_labelno);
	  assemble_name (file, buf);
	  fprintf (file, "-");
	  ASM_GENERATE_INTERNAL_LABEL (buf, "LCF", rs6000_pic_labelno);
	  assemble_name (file, buf);
	  fprintf (file, "(12)\n");
	  fprintf (file, "\tadd 2,2,12\n");
	}

      fputs ("\t.localentry\t", file);
      assemble_name (file, name);
      fputs (",.-", file);
      assemble_name (file, name);
      fputs ("\n", file);
    }

  else if (rs6000_pcrel_p (cfun))
    {
      const char *name = XSTR (XEXP (DECL_RTL (current_function_decl), 0), 0);
      /* All functions compiled to use PC-relative addressing will
	 have a .localentry value of 0 or 1.  For now we set it to
	 1 all the time, indicating that the function may clobber
	 the TOC register r2.  Later we may optimize this by setting
	 it to 0 if the function is a leaf and does not clobber r2.  */
      fputs ("\t.localentry\t", file);
      assemble_name (file, name);
      fputs (",1\n", file);
    }

  /* Output -mprofile-kernel code.  This needs to be done here instead of
     in output_function_profile since it must go after the ELFv2 ABI
     local entry point.  */
  if (TARGET_PROFILE_KERNEL && crtl->profile)
    {
      gcc_assert (DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2);
      gcc_assert (!TARGET_32BIT);

      asm_fprintf (file, "\tmflr %s\n", reg_names[0]);

      /* In the ELFv2 ABI we have no compiler stack word.  It must be
	 the resposibility of _mcount to preserve the static chain
	 register if required.  */
      if (DEFAULT_ABI != ABI_ELFv2
	  && cfun->static_chain_decl != NULL)
	{
	  asm_fprintf (file, "\tstd %s,24(%s)\n",
		       reg_names[STATIC_CHAIN_REGNUM], reg_names[1]);
	  fprintf (file, "\tbl %s\n", RS6000_MCOUNT);
	  asm_fprintf (file, "\tld %s,24(%s)\n",
		       reg_names[STATIC_CHAIN_REGNUM], reg_names[1]);
	}
      else
	fprintf (file, "\tbl %s\n", RS6000_MCOUNT);
    }

  rs6000_pic_labelno++;
}

/* -mprofile-kernel code calls mcount before the function prolog,
   so a profiled leaf function should stay a leaf function.  */
static bool
rs6000_keep_leaf_when_profiled ()
{
  return TARGET_PROFILE_KERNEL;
}

/* Non-zero if vmx regs are restored before the frame pop, zero if
   we restore after the pop when possible.  */
#define ALWAYS_RESTORE_ALTIVEC_BEFORE_POP 0

/* Restoring cr is a two step process: loading a reg from the frame
   save, then moving the reg to cr.  For ABI_V4 we must let the
   unwinder know that the stack location is no longer valid at or
   before the stack deallocation, but we can't emit a cfa_restore for
   cr at the stack deallocation like we do for other registers.
   The trouble is that it is possible for the move to cr to be
   scheduled after the stack deallocation.  So say exactly where cr
   is located on each of the two insns.  */

static rtx
load_cr_save (int regno, rtx frame_reg_rtx, int offset, bool exit_func)
{
  rtx mem = gen_frame_mem_offset (SImode, frame_reg_rtx, offset);
  rtx reg = gen_rtx_REG (SImode, regno);
  rtx_insn *insn = emit_move_insn (reg, mem);

  if (!exit_func && DEFAULT_ABI == ABI_V4)
    {
      rtx cr = gen_rtx_REG (SImode, CR2_REGNO);
      rtx set = gen_rtx_SET (reg, cr);

      add_reg_note (insn, REG_CFA_REGISTER, set);
      RTX_FRAME_RELATED_P (insn) = 1;
    }
  return reg;
}

/* Reload CR from REG.  */

static void
restore_saved_cr (rtx reg, bool using_mfcr_multiple, bool exit_func)
{
  int count = 0;
  int i;

  if (using_mfcr_multiple)
    {
      for (i = 0; i < 8; i++)
	if (save_reg_p (CR0_REGNO + i))
	  count++;
      gcc_assert (count);
    }

  if (using_mfcr_multiple && count > 1)
    {
      rtx_insn *insn;
      rtvec p;
      int ndx;

      p = rtvec_alloc (count);

      ndx = 0;
      for (i = 0; i < 8; i++)
	if (save_reg_p (CR0_REGNO + i))
	  {
	    rtvec r = rtvec_alloc (2);
	    RTVEC_ELT (r, 0) = reg;
	    RTVEC_ELT (r, 1) = GEN_INT (1 << (7-i));
	    RTVEC_ELT (p, ndx) =
	      gen_rtx_SET (gen_rtx_REG (CCmode, CR0_REGNO + i),
			   gen_rtx_UNSPEC (CCmode, r, UNSPEC_MOVESI_TO_CR));
	    ndx++;
	  }
      insn = emit_insn (gen_rtx_PARALLEL (VOIDmode, p));
      gcc_assert (ndx == count);

      /* For the ELFv2 ABI we generate a CFA_RESTORE for each
	 CR field separately.  */
      if (!exit_func && DEFAULT_ABI == ABI_ELFv2 && flag_shrink_wrap)
	{
	  for (i = 0; i < 8; i++)
	    if (save_reg_p (CR0_REGNO + i))
	      add_reg_note (insn, REG_CFA_RESTORE,
			    gen_rtx_REG (SImode, CR0_REGNO + i));

	  RTX_FRAME_RELATED_P (insn) = 1;
	}
    }
  else
    for (i = 0; i < 8; i++)
      if (save_reg_p (CR0_REGNO + i))
	{
	  rtx insn = emit_insn (gen_movsi_to_cr_one
				 (gen_rtx_REG (CCmode, CR0_REGNO + i), reg));

	  /* For the ELFv2 ABI we generate a CFA_RESTORE for each
	     CR field separately, attached to the insn that in fact
	     restores this particular CR field.  */
	  if (!exit_func && DEFAULT_ABI == ABI_ELFv2 && flag_shrink_wrap)
	    {
	      add_reg_note (insn, REG_CFA_RESTORE,
			    gen_rtx_REG (SImode, CR0_REGNO + i));

	      RTX_FRAME_RELATED_P (insn) = 1;
	    }
	}

  /* For other ABIs, we just generate a single CFA_RESTORE for CR2.  */
  if (!exit_func && DEFAULT_ABI != ABI_ELFv2
      && (DEFAULT_ABI == ABI_V4 || flag_shrink_wrap))
    {
      rtx_insn *insn = get_last_insn ();
      rtx cr = gen_rtx_REG (SImode, CR2_REGNO);

      add_reg_note (insn, REG_CFA_RESTORE, cr);
      RTX_FRAME_RELATED_P (insn) = 1;
    }
}

/* Like cr, the move to lr instruction can be scheduled after the
   stack deallocation, but unlike cr, its stack frame save is still
   valid.  So we only need to emit the cfa_restore on the correct
   instruction.  */

static void
load_lr_save (int regno, rtx frame_reg_rtx, int offset)
{
  rtx mem = gen_frame_mem_offset (Pmode, frame_reg_rtx, offset);
  rtx reg = gen_rtx_REG (Pmode, regno);

  emit_move_insn (reg, mem);
}

static void
restore_saved_lr (int regno, bool exit_func)
{
  rtx reg = gen_rtx_REG (Pmode, regno);
  rtx lr = gen_rtx_REG (Pmode, LR_REGNO);
  rtx_insn *insn = emit_move_insn (lr, reg);

  if (!exit_func && flag_shrink_wrap)
    {
      add_reg_note (insn, REG_CFA_RESTORE, lr);
      RTX_FRAME_RELATED_P (insn) = 1;
    }
}

static rtx
add_crlr_cfa_restore (const rs6000_stack_t *info, rtx cfa_restores)
{
  if (DEFAULT_ABI == ABI_ELFv2)
    {
      int i;
      for (i = 0; i < 8; i++)
	if (save_reg_p (CR0_REGNO + i))
	  {
	    rtx cr = gen_rtx_REG (SImode, CR0_REGNO + i);
	    cfa_restores = alloc_reg_note (REG_CFA_RESTORE, cr,
					   cfa_restores);
	  }
    }
  else if (info->cr_save_p)
    cfa_restores = alloc_reg_note (REG_CFA_RESTORE,
				   gen_rtx_REG (SImode, CR2_REGNO),
				   cfa_restores);

  if (info->lr_save_p)
    cfa_restores = alloc_reg_note (REG_CFA_RESTORE,
				   gen_rtx_REG (Pmode, LR_REGNO),
				   cfa_restores);
  return cfa_restores;
}

/* Return true if OFFSET from stack pointer can be clobbered by signals.
   V.4 doesn't have any stack cushion, AIX ABIs have 220 or 288 bytes
   below stack pointer not cloberred by signals.  */

static inline bool
offset_below_red_zone_p (HOST_WIDE_INT offset)
{
  return offset < (DEFAULT_ABI == ABI_V4
		   ? 0
		   : TARGET_32BIT ? -220 : -288);
}

/* Append CFA_RESTORES to any existing REG_NOTES on the last insn.  */

static void
emit_cfa_restores (rtx cfa_restores)
{
  rtx_insn *insn = get_last_insn ();
  rtx *loc = &REG_NOTES (insn);

  while (*loc)
    loc = &XEXP (*loc, 1);
  *loc = cfa_restores;
  RTX_FRAME_RELATED_P (insn) = 1;
}

/* Emit function epilogue as insns.  */

void
rs6000_emit_epilogue (enum epilogue_type epilogue_type)
{
  HOST_WIDE_INT frame_off = 0;
  rtx sp_reg_rtx = gen_rtx_REG (Pmode, 1);
  rtx frame_reg_rtx = sp_reg_rtx;
  rtx cfa_restores = NULL_RTX;
  rtx insn;
  rtx cr_save_reg = NULL_RTX;
  machine_mode reg_mode = Pmode;
  int reg_size = TARGET_32BIT ? 4 : 8;
  machine_mode fp_reg_mode = TARGET_HARD_FLOAT ? DFmode : SFmode;
  int fp_reg_size = 8;
  int i;
  unsigned ptr_regno;

  rs6000_stack_t *info = rs6000_stack_info ();

  if (epilogue_type == EPILOGUE_TYPE_NORMAL && crtl->calls_eh_return)
    epilogue_type = EPILOGUE_TYPE_EH_RETURN;

  int strategy = info->savres_strategy;
  bool using_load_multiple = !!(strategy & REST_MULTIPLE);
  bool restoring_GPRs_inline = !!(strategy & REST_INLINE_GPRS);
  bool restoring_FPRs_inline = !!(strategy & REST_INLINE_FPRS);
  if (epilogue_type == EPILOGUE_TYPE_SIBCALL)
    {
      restoring_GPRs_inline = true;
      restoring_FPRs_inline = true;
    }

  bool using_mtcr_multiple = (rs6000_tune == PROCESSOR_PPC601
			      || rs6000_tune == PROCESSOR_PPC603
			      || rs6000_tune == PROCESSOR_PPC750
			      || optimize_size);

  /* Restore via the backchain when we have a large frame, since this
     is more efficient than an addis, addi pair.  The second condition
     here will not trigger at the moment;  We don't actually need a
     frame pointer for alloca, but the generic parts of the compiler
     give us one anyway.  */
  bool use_backchain_to_restore_sp
    = (info->total_size + (info->lr_save_p ? info->lr_save_offset : 0) > 32767
       || (cfun->calls_alloca && !frame_pointer_needed));

  bool restore_lr = (info->lr_save_p
		&& (restoring_FPRs_inline
		    || (strategy & REST_NOINLINE_FPRS_DOESNT_RESTORE_LR))
		&& (restoring_GPRs_inline
		    || info->first_fp_reg_save < 64)
		&& !cfun->machine->lr_is_wrapped_separately);


  if (WORLD_SAVE_P (info))
    {
      gcc_assert (epilogue_type != EPILOGUE_TYPE_SIBCALL);

      /* eh_rest_world_r10 will return to the location saved in the LR
	 stack slot (which is not likely to be our caller.)
	 Input: R10 -- stack adjustment.  Clobbers R0, R11, R12, R7, R8.
	 rest_world is similar, except any R10 parameter is ignored.
	 The exception-handling stuff that was here in 2.95 is no
	 longer necessary.  */

      rtvec p;
      p = rtvec_alloc (9
		       + 32 - info->first_gp_reg_save
		       + LAST_ALTIVEC_REGNO + 1 - info->first_altivec_reg_save
		       + 63 + 1 - info->first_fp_reg_save);

      const char *rname;
      switch (epilogue_type)
	{
	case EPILOGUE_TYPE_NORMAL:
	  rname = ggc_strdup ("*rest_world");
	  break;

	case EPILOGUE_TYPE_EH_RETURN:
	  rname = ggc_strdup ("*eh_rest_world_r10");
	  break;

	default:
	  gcc_unreachable ();
	}

      int j = 0;
      RTVEC_ELT (p, j++) = ret_rtx;
      RTVEC_ELT (p, j++)
	= gen_rtx_USE (VOIDmode, gen_rtx_SYMBOL_REF (Pmode, rname));
      /* The instruction pattern requires a clobber here;
	 it is shared with the restVEC helper. */
      RTVEC_ELT (p, j++) = gen_hard_reg_clobber (Pmode, 11);

      {
	/* CR register traditionally saved as CR2.  */
	rtx reg = gen_rtx_REG (SImode, CR2_REGNO);
	RTVEC_ELT (p, j++)
	  = gen_frame_load (reg, frame_reg_rtx, info->cr_save_offset);
	if (flag_shrink_wrap)
	  {
	    cfa_restores = alloc_reg_note (REG_CFA_RESTORE,
					   gen_rtx_REG (Pmode, LR_REGNO),
					   cfa_restores);
	    cfa_restores = alloc_reg_note (REG_CFA_RESTORE, reg, cfa_restores);
	  }
      }

      int i;
      for (i = 0; i < 32 - info->first_gp_reg_save; i++)
	{
	  rtx reg = gen_rtx_REG (reg_mode, info->first_gp_reg_save + i);
	  RTVEC_ELT (p, j++)
	    = gen_frame_load (reg,
			      frame_reg_rtx, info->gp_save_offset + reg_size * i);
	  if (flag_shrink_wrap
	      && save_reg_p (info->first_gp_reg_save + i))
	    cfa_restores = alloc_reg_note (REG_CFA_RESTORE, reg, cfa_restores);
	}
      for (i = 0; info->first_altivec_reg_save + i <= LAST_ALTIVEC_REGNO; i++)
	{
	  rtx reg = gen_rtx_REG (V4SImode, info->first_altivec_reg_save + i);
	  RTVEC_ELT (p, j++)
	    = gen_frame_load (reg,
			      frame_reg_rtx, info->altivec_save_offset + 16 * i);
	  if (flag_shrink_wrap
	      && save_reg_p (info->first_altivec_reg_save + i))
	    cfa_restores = alloc_reg_note (REG_CFA_RESTORE, reg, cfa_restores);
	}
      for (i = 0; info->first_fp_reg_save + i <= 63; i++)
	{
	  rtx reg = gen_rtx_REG (TARGET_HARD_FLOAT ? DFmode : SFmode,
				 info->first_fp_reg_save + i);
	  RTVEC_ELT (p, j++)
	    = gen_frame_load (reg, frame_reg_rtx, info->fp_save_offset + 8 * i);
	  if (flag_shrink_wrap
	      && save_reg_p (info->first_fp_reg_save + i))
	    cfa_restores = alloc_reg_note (REG_CFA_RESTORE, reg, cfa_restores);
	}
      RTVEC_ELT (p, j++) = gen_hard_reg_clobber (Pmode, 0);
      RTVEC_ELT (p, j++) = gen_hard_reg_clobber (SImode, 12);
      RTVEC_ELT (p, j++) = gen_hard_reg_clobber (SImode, 7);
      RTVEC_ELT (p, j++) = gen_hard_reg_clobber (SImode, 8);
      RTVEC_ELT (p, j++)
	= gen_rtx_USE (VOIDmode, gen_rtx_REG (SImode, 10));
      insn = emit_jump_insn (gen_rtx_PARALLEL (VOIDmode, p));

      if (flag_shrink_wrap)
	{
	  REG_NOTES (insn) = cfa_restores;
	  add_reg_note (insn, REG_CFA_DEF_CFA, sp_reg_rtx);
	  RTX_FRAME_RELATED_P (insn) = 1;
	}
      return;
    }

  /* frame_reg_rtx + frame_off points to the top of this stack frame.  */
  if (info->push_p)
    frame_off = info->total_size;

  /* Restore AltiVec registers if we must do so before adjusting the
     stack.  */
  if (info->altivec_size != 0
      && (ALWAYS_RESTORE_ALTIVEC_BEFORE_POP
	  || (DEFAULT_ABI != ABI_V4
	      && offset_below_red_zone_p (info->altivec_save_offset))))
    {
      int i;
      int scratch_regno = ptr_regno_for_savres (SAVRES_VR);

      gcc_checking_assert (scratch_regno == 11 || scratch_regno == 12);
      if (use_backchain_to_restore_sp)
	{
	  int frame_regno = 11;

	  if ((strategy & REST_INLINE_VRS) == 0)
	    {
	      /* Of r11 and r12, select the one not clobbered by an
		 out-of-line restore function for the frame register.  */
	      frame_regno = 11 + 12 - scratch_regno;
	    }
	  frame_reg_rtx = gen_rtx_REG (Pmode, frame_regno);
	  emit_move_insn (frame_reg_rtx,
			  gen_rtx_MEM (Pmode, sp_reg_rtx));
	  frame_off = 0;
	}
      else if (frame_pointer_needed)
	frame_reg_rtx = hard_frame_pointer_rtx;

      if ((strategy & REST_INLINE_VRS) == 0)
	{
	  int end_save = info->altivec_save_offset + info->altivec_size;
	  int ptr_off;
	  rtx ptr_reg = gen_rtx_REG (Pmode, 0);
	  rtx scratch_reg = gen_rtx_REG (Pmode, scratch_regno);

	  if (end_save + frame_off != 0)
	    {
	      rtx offset = GEN_INT (end_save + frame_off);

	      emit_insn (gen_add3_insn (ptr_reg, frame_reg_rtx, offset));
	    }
	  else
	    emit_move_insn (ptr_reg, frame_reg_rtx);

	  ptr_off = -end_save;
	  insn = rs6000_emit_savres_rtx (info, scratch_reg,
					 info->altivec_save_offset + ptr_off,
					 0, V4SImode, SAVRES_VR);
	}
      else
	{
	  for (i = info->first_altivec_reg_save; i <= LAST_ALTIVEC_REGNO; ++i)
	    if (info->vrsave_mask & ALTIVEC_REG_BIT (i))
	      {
		rtx addr, areg, mem, insn;
		rtx reg = gen_rtx_REG (V4SImode, i);
		HOST_WIDE_INT offset
		  = (info->altivec_save_offset + frame_off
		     + 16 * (i - info->first_altivec_reg_save));

		if (TARGET_P9_VECTOR && quad_address_offset_p (offset))
		  {
		    mem = gen_frame_mem (V4SImode,
					 gen_rtx_PLUS (Pmode, frame_reg_rtx,
						       GEN_INT (offset)));
		    insn = gen_rtx_SET (reg, mem);
		  }
		else
		  {
		    areg = gen_rtx_REG (Pmode, 0);
		    emit_move_insn (areg, GEN_INT (offset));

		    /* AltiVec addressing mode is [reg+reg].  */
		    addr = gen_rtx_PLUS (Pmode, frame_reg_rtx, areg);
		    mem = gen_frame_mem (V4SImode, addr);

		    /* Rather than emitting a generic move, force use of the
		       lvx instruction, which we always want.  In particular we
		       don't want lxvd2x/xxpermdi for little endian.  */
		    insn = gen_altivec_lvx_v4si_internal (reg, mem);
		  }

		(void) emit_insn (insn);
	      }
	}

      for (i = info->first_altivec_reg_save; i <= LAST_ALTIVEC_REGNO; ++i)
	if (((strategy & REST_INLINE_VRS) == 0
	     || (info->vrsave_mask & ALTIVEC_REG_BIT (i)) != 0)
	    && (flag_shrink_wrap
		|| (offset_below_red_zone_p
		    (info->altivec_save_offset
		     + 16 * (i - info->first_altivec_reg_save))))
	    && save_reg_p (i))
	  {
	    rtx reg = gen_rtx_REG (V4SImode, i);
	    cfa_restores = alloc_reg_note (REG_CFA_RESTORE, reg, cfa_restores);
	  }
    }

  /* Restore VRSAVE if we must do so before adjusting the stack.  */
  if (info->vrsave_size != 0
      && (ALWAYS_RESTORE_ALTIVEC_BEFORE_POP
	  || (DEFAULT_ABI != ABI_V4
	      && offset_below_red_zone_p (info->vrsave_save_offset))))
    {
      rtx reg;

      if (frame_reg_rtx == sp_reg_rtx)
	{
	  if (use_backchain_to_restore_sp)
	    {
	      frame_reg_rtx = gen_rtx_REG (Pmode, 11);
	      emit_move_insn (frame_reg_rtx,
			      gen_rtx_MEM (Pmode, sp_reg_rtx));
	      frame_off = 0;
	    }
	  else if (frame_pointer_needed)
	    frame_reg_rtx = hard_frame_pointer_rtx;
	}

      reg = gen_rtx_REG (SImode, 12);
      emit_insn (gen_frame_load (reg, frame_reg_rtx,
				 info->vrsave_save_offset + frame_off));

      emit_insn (generate_set_vrsave (reg, info, 1));
    }

  insn = NULL_RTX;
  /* If we have a large stack frame, restore the old stack pointer
     using the backchain.  */
  if (use_backchain_to_restore_sp)
    {
      if (frame_reg_rtx == sp_reg_rtx)
	{
	  /* Under V.4, don't reset the stack pointer until after we're done
	     loading the saved registers.  */
	  if (DEFAULT_ABI == ABI_V4)
	    frame_reg_rtx = gen_rtx_REG (Pmode, 11);

	  insn = emit_move_insn (frame_reg_rtx,
				 gen_rtx_MEM (Pmode, sp_reg_rtx));
	  frame_off = 0;
	}
      else if (ALWAYS_RESTORE_ALTIVEC_BEFORE_POP
	       && DEFAULT_ABI == ABI_V4)
	/* frame_reg_rtx has been set up by the altivec restore.  */
	;
      else
	{
	  insn = emit_move_insn (sp_reg_rtx, frame_reg_rtx);
	  frame_reg_rtx = sp_reg_rtx;
	}
    }
  /* If we have a frame pointer, we can restore the old stack pointer
     from it.  */
  else if (frame_pointer_needed)
    {
      frame_reg_rtx = sp_reg_rtx;
      if (DEFAULT_ABI == ABI_V4)
	frame_reg_rtx = gen_rtx_REG (Pmode, 11);
      /* Prevent reordering memory accesses against stack pointer restore.  */
      else if (cfun->calls_alloca
	       || offset_below_red_zone_p (-info->total_size))
	rs6000_emit_stack_tie (frame_reg_rtx, true);

      insn = emit_insn (gen_add3_insn (frame_reg_rtx, hard_frame_pointer_rtx,
				       GEN_INT (info->total_size)));
      frame_off = 0;
    }
  else if (info->push_p
	   && DEFAULT_ABI != ABI_V4
	   && epilogue_type != EPILOGUE_TYPE_EH_RETURN)
    {
      /* Prevent reordering memory accesses against stack pointer restore.  */
      if (cfun->calls_alloca
	  || offset_below_red_zone_p (-info->total_size))
	rs6000_emit_stack_tie (frame_reg_rtx, false);
      insn = emit_insn (gen_add3_insn (sp_reg_rtx, sp_reg_rtx,
				       GEN_INT (info->total_size)));
      frame_off = 0;
    }
  if (insn && frame_reg_rtx == sp_reg_rtx)
    {
      if (cfa_restores)
	{
	  REG_NOTES (insn) = cfa_restores;
	  cfa_restores = NULL_RTX;
	}
      add_reg_note (insn, REG_CFA_DEF_CFA, sp_reg_rtx);
      RTX_FRAME_RELATED_P (insn) = 1;
    }

  /* Restore AltiVec registers if we have not done so already.  */
  if (!ALWAYS_RESTORE_ALTIVEC_BEFORE_POP
      && info->altivec_size != 0
      && (DEFAULT_ABI == ABI_V4
	  || !offset_below_red_zone_p (info->altivec_save_offset)))
    {
      int i;

      if ((strategy & REST_INLINE_VRS) == 0)
	{
	  int end_save = info->altivec_save_offset + info->altivec_size;
	  int ptr_off;
	  rtx ptr_reg = gen_rtx_REG (Pmode, 0);
	  int scratch_regno = ptr_regno_for_savres (SAVRES_VR);
	  rtx scratch_reg = gen_rtx_REG (Pmode, scratch_regno);

	  if (end_save + frame_off != 0)
	    {
	      rtx offset = GEN_INT (end_save + frame_off);

	      emit_insn (gen_add3_insn (ptr_reg, frame_reg_rtx, offset));
	    }
	  else
	    emit_move_insn (ptr_reg, frame_reg_rtx);

	  ptr_off = -end_save;
	  insn = rs6000_emit_savres_rtx (info, scratch_reg,
					 info->altivec_save_offset + ptr_off,
					 0, V4SImode, SAVRES_VR);
	  if (REGNO (frame_reg_rtx) == REGNO (scratch_reg))
	    {
	      /* Frame reg was clobbered by out-of-line save.  Restore it
		 from ptr_reg, and if we are calling out-of-line gpr or
		 fpr restore set up the correct pointer and offset.  */
	      unsigned newptr_regno = 1;
	      if (!restoring_GPRs_inline)
		{
		  bool lr = info->gp_save_offset + info->gp_size == 0;
		  int sel = SAVRES_GPR | (lr ? SAVRES_LR : 0);
		  newptr_regno = ptr_regno_for_savres (sel);
		  end_save = info->gp_save_offset + info->gp_size;
		}
	      else if (!restoring_FPRs_inline)
		{
		  bool lr = !(strategy & REST_NOINLINE_FPRS_DOESNT_RESTORE_LR);
		  int sel = SAVRES_FPR | (lr ? SAVRES_LR : 0);
		  newptr_regno = ptr_regno_for_savres (sel);
		  end_save = info->fp_save_offset + info->fp_size;
		}

	      if (newptr_regno != 1 && REGNO (frame_reg_rtx) != newptr_regno)
		frame_reg_rtx = gen_rtx_REG (Pmode, newptr_regno);
		
	      if (end_save + ptr_off != 0)
		{
		  rtx offset = GEN_INT (end_save + ptr_off);

		  frame_off = -end_save;
		  if (TARGET_32BIT)
		    emit_insn (gen_addsi3_carry (frame_reg_rtx,
						 ptr_reg, offset));
		  else
		    emit_insn (gen_adddi3_carry (frame_reg_rtx,
						 ptr_reg, offset));
		}
	      else
		{
		  frame_off = ptr_off;
		  emit_move_insn (frame_reg_rtx, ptr_reg);
		}
	    }
	}
      else
	{
	  for (i = info->first_altivec_reg_save; i <= LAST_ALTIVEC_REGNO; ++i)
	    if (info->vrsave_mask & ALTIVEC_REG_BIT (i))
	      {
		rtx addr, areg, mem, insn;
		rtx reg = gen_rtx_REG (V4SImode, i);
		HOST_WIDE_INT offset
		  = (info->altivec_save_offset + frame_off
		     + 16 * (i - info->first_altivec_reg_save));

		if (TARGET_P9_VECTOR && quad_address_offset_p (offset))
		  {
		    mem = gen_frame_mem (V4SImode,
					 gen_rtx_PLUS (Pmode, frame_reg_rtx,
						       GEN_INT (offset)));
		    insn = gen_rtx_SET (reg, mem);
		  }
		else
		  {
		    areg = gen_rtx_REG (Pmode, 0);
		    emit_move_insn (areg, GEN_INT (offset));

		    /* AltiVec addressing mode is [reg+reg].  */
		    addr = gen_rtx_PLUS (Pmode, frame_reg_rtx, areg);
		    mem = gen_frame_mem (V4SImode, addr);

		    /* Rather than emitting a generic move, force use of the
		       lvx instruction, which we always want.  In particular we
		       don't want lxvd2x/xxpermdi for little endian.  */
		    insn = gen_altivec_lvx_v4si_internal (reg, mem);
		  }

		(void) emit_insn (insn);
	      }
	}

      for (i = info->first_altivec_reg_save; i <= LAST_ALTIVEC_REGNO; ++i)
	if (((strategy & REST_INLINE_VRS) == 0
	     || (info->vrsave_mask & ALTIVEC_REG_BIT (i)) != 0)
	    && (DEFAULT_ABI == ABI_V4 || flag_shrink_wrap)
	    && save_reg_p (i))
	  {
	    rtx reg = gen_rtx_REG (V4SImode, i);
	    cfa_restores = alloc_reg_note (REG_CFA_RESTORE, reg, cfa_restores);
	  }
    }

  /* Restore VRSAVE if we have not done so already.  */
  if (!ALWAYS_RESTORE_ALTIVEC_BEFORE_POP
      && info->vrsave_size != 0
      && (DEFAULT_ABI == ABI_V4
	  || !offset_below_red_zone_p (info->vrsave_save_offset)))
    {
      rtx reg;

      reg = gen_rtx_REG (SImode, 12);
      emit_insn (gen_frame_load (reg, frame_reg_rtx,
				 info->vrsave_save_offset + frame_off));

      emit_insn (generate_set_vrsave (reg, info, 1));
    }

  /* If we exit by an out-of-line restore function on ABI_V4 then that
     function will deallocate the stack, so we don't need to worry
     about the unwinder restoring cr from an invalid stack frame
     location.  */
  bool exit_func = (!restoring_FPRs_inline
		    || (!restoring_GPRs_inline
			&& info->first_fp_reg_save == 64));

  /* In the ELFv2 ABI we need to restore all call-saved CR fields from
     *separate* slots if the routine calls __builtin_eh_return, so
     that they can be independently restored by the unwinder.  */
  if (DEFAULT_ABI == ABI_ELFv2 && crtl->calls_eh_return)
    {
      int i, cr_off = info->ehcr_offset;

      for (i = 0; i < 8; i++)
	if (!call_used_regs[CR0_REGNO + i])
	  {
	    rtx reg = gen_rtx_REG (SImode, 0);
	    emit_insn (gen_frame_load (reg, frame_reg_rtx,
				       cr_off + frame_off));

	    insn = emit_insn (gen_movsi_to_cr_one
				(gen_rtx_REG (CCmode, CR0_REGNO + i), reg));

	    if (!exit_func && flag_shrink_wrap)
	      {
		add_reg_note (insn, REG_CFA_RESTORE,
			      gen_rtx_REG (SImode, CR0_REGNO + i));

		RTX_FRAME_RELATED_P (insn) = 1;
	      }

	    cr_off += reg_size;
	  }
    }

  /* Get the old lr if we saved it.  If we are restoring registers
     out-of-line, then the out-of-line routines can do this for us.  */
  if (restore_lr && restoring_GPRs_inline)
    load_lr_save (0, frame_reg_rtx, info->lr_save_offset + frame_off);

  /* Get the old cr if we saved it.  */
  if (info->cr_save_p)
    {
      unsigned cr_save_regno = 12;

      if (!restoring_GPRs_inline)
	{
	  /* Ensure we don't use the register used by the out-of-line
	     gpr register restore below.  */
	  bool lr = info->gp_save_offset + info->gp_size == 0;
	  int sel = SAVRES_GPR | (lr ? SAVRES_LR : 0);
	  int gpr_ptr_regno = ptr_regno_for_savres (sel);

	  if (gpr_ptr_regno == 12)
	    cr_save_regno = 11;
	  gcc_checking_assert (REGNO (frame_reg_rtx) != cr_save_regno);
	}
      else if (REGNO (frame_reg_rtx) == 12)
	cr_save_regno = 11;

      cr_save_reg = load_cr_save (cr_save_regno, frame_reg_rtx,
				  info->cr_save_offset + frame_off,
				  exit_func);
    }

  /* Set LR here to try to overlap restores below.  */
  if (restore_lr && restoring_GPRs_inline)
    restore_saved_lr (0, exit_func);

  /* Load exception handler data registers, if needed.  */
  if (epilogue_type == EPILOGUE_TYPE_EH_RETURN)
    {
      unsigned int i, regno;

      if (TARGET_AIX)
	{
	  rtx reg = gen_rtx_REG (reg_mode, 2);
	  emit_insn (gen_frame_load (reg, frame_reg_rtx,
				     frame_off + RS6000_TOC_SAVE_SLOT));
	}

      for (i = 0; ; ++i)
	{
	  rtx mem;

	  regno = EH_RETURN_DATA_REGNO (i);
	  if (regno == INVALID_REGNUM)
	    break;

	  mem = gen_frame_mem_offset (reg_mode, frame_reg_rtx,
				      info->ehrd_offset + frame_off
				      + reg_size * (int) i);

	  emit_move_insn (gen_rtx_REG (reg_mode, regno), mem);
	}
    }

  /* Restore GPRs.  This is done as a PARALLEL if we are using
     the load-multiple instructions.  */
  if (!restoring_GPRs_inline)
    {
      /* We are jumping to an out-of-line function.  */
      rtx ptr_reg;
      int end_save = info->gp_save_offset + info->gp_size;
      bool can_use_exit = end_save == 0;
      int sel = SAVRES_GPR | (can_use_exit ? SAVRES_LR : 0);
      int ptr_off;

      /* Emit stack reset code if we need it.  */
      ptr_regno = ptr_regno_for_savres (sel);
      ptr_reg = gen_rtx_REG (Pmode, ptr_regno);
      if (can_use_exit)
	rs6000_emit_stack_reset (frame_reg_rtx, frame_off, ptr_regno);
      else if (end_save + frame_off != 0)
	emit_insn (gen_add3_insn (ptr_reg, frame_reg_rtx,
				  GEN_INT (end_save + frame_off)));
      else if (REGNO (frame_reg_rtx) != ptr_regno)
	emit_move_insn (ptr_reg, frame_reg_rtx);
      if (REGNO (frame_reg_rtx) == ptr_regno)
	frame_off = -end_save;

      if (can_use_exit && info->cr_save_p)
	restore_saved_cr (cr_save_reg, using_mtcr_multiple, true);

      ptr_off = -end_save;
      rs6000_emit_savres_rtx (info, ptr_reg,
			      info->gp_save_offset + ptr_off,
			      info->lr_save_offset + ptr_off,
			      reg_mode, sel);
    }
  else if (using_load_multiple)
    {
      rtvec p;
      p = rtvec_alloc (32 - info->first_gp_reg_save);
      for (i = 0; i < 32 - info->first_gp_reg_save; i++)
	RTVEC_ELT (p, i)
	  = gen_frame_load (gen_rtx_REG (reg_mode, info->first_gp_reg_save + i),
			    frame_reg_rtx,
			    info->gp_save_offset + frame_off + reg_size * i);
      emit_insn (gen_rtx_PARALLEL (VOIDmode, p));
    }
  else
    {
      int offset = info->gp_save_offset + frame_off;
      for (i = info->first_gp_reg_save; i < 32; i++)
	{
	  if (save_reg_p (i)
	      && !cfun->machine->gpr_is_wrapped_separately[i])
	    {
	      rtx reg = gen_rtx_REG (reg_mode, i);
	      emit_insn (gen_frame_load (reg, frame_reg_rtx, offset));
	    }

	  offset += reg_size;
	}
    }

  if (DEFAULT_ABI == ABI_V4 || flag_shrink_wrap)
    {
      /* If the frame pointer was used then we can't delay emitting
	 a REG_CFA_DEF_CFA note.  This must happen on the insn that
	 restores the frame pointer, r31.  We may have already emitted
	 a REG_CFA_DEF_CFA note, but that's OK;  A duplicate is
	 discarded by dwarf2cfi.c/dwarf2out.c, and in any case would
	 be harmless if emitted.  */
      if (frame_pointer_needed)
	{
	  insn = get_last_insn ();
	  add_reg_note (insn, REG_CFA_DEF_CFA,
			plus_constant (Pmode, frame_reg_rtx, frame_off));
	  RTX_FRAME_RELATED_P (insn) = 1;
	}

      /* Set up cfa_restores.  We always need these when
	 shrink-wrapping.  If not shrink-wrapping then we only need
	 the cfa_restore when the stack location is no longer valid.
	 The cfa_restores must be emitted on or before the insn that
	 invalidates the stack, and of course must not be emitted
	 before the insn that actually does the restore.  The latter
	 is why it is a bad idea to emit the cfa_restores as a group
	 on the last instruction here that actually does a restore:
	 That insn may be reordered with respect to others doing
	 restores.  */
      if (flag_shrink_wrap
	  && !restoring_GPRs_inline
	  && info->first_fp_reg_save == 64)
	cfa_restores = add_crlr_cfa_restore (info, cfa_restores);

      for (i = info->first_gp_reg_save; i < 32; i++)
	if (save_reg_p (i)
	    && !cfun->machine->gpr_is_wrapped_separately[i])
	  {
	    rtx reg = gen_rtx_REG (reg_mode, i);
	    cfa_restores = alloc_reg_note (REG_CFA_RESTORE, reg, cfa_restores);
	  }
    }

  if (!restoring_GPRs_inline
      && info->first_fp_reg_save == 64)
    {
      /* We are jumping to an out-of-line function.  */
      if (cfa_restores)
	emit_cfa_restores (cfa_restores);
      return;
    }

  if (restore_lr && !restoring_GPRs_inline)
    {
      load_lr_save (0, frame_reg_rtx, info->lr_save_offset + frame_off);
      restore_saved_lr (0, exit_func);
    }

  /* Restore fpr's if we need to do it without calling a function.  */
  if (restoring_FPRs_inline)
    {
      int offset = info->fp_save_offset + frame_off;
      for (i = info->first_fp_reg_save; i < 64; i++)
	{
	  if (save_reg_p (i)
	      && !cfun->machine->fpr_is_wrapped_separately[i - 32])
	    {
	      rtx reg = gen_rtx_REG (fp_reg_mode, i);
	      emit_insn (gen_frame_load (reg, frame_reg_rtx, offset));
	      if (DEFAULT_ABI == ABI_V4 || flag_shrink_wrap)
		cfa_restores = alloc_reg_note (REG_CFA_RESTORE, reg,
					       cfa_restores);
	    }

	  offset += fp_reg_size;
	}
    }

  /* If we saved cr, restore it here.  Just those that were used.  */
  if (info->cr_save_p)
    restore_saved_cr (cr_save_reg, using_mtcr_multiple, exit_func);

  /* If this is V.4, unwind the stack pointer after all of the loads
     have been done, or set up r11 if we are restoring fp out of line.  */
  ptr_regno = 1;
  if (!restoring_FPRs_inline)
    {
      bool lr = (strategy & REST_NOINLINE_FPRS_DOESNT_RESTORE_LR) == 0;
      int sel = SAVRES_FPR | (lr ? SAVRES_LR : 0);
      ptr_regno = ptr_regno_for_savres (sel);
    }

  insn = rs6000_emit_stack_reset (frame_reg_rtx, frame_off, ptr_regno);
  if (REGNO (frame_reg_rtx) == ptr_regno)
    frame_off = 0;

  if (insn && restoring_FPRs_inline)
    {
      if (cfa_restores)
	{
	  REG_NOTES (insn) = cfa_restores;
	  cfa_restores = NULL_RTX;
	}
      add_reg_note (insn, REG_CFA_DEF_CFA, sp_reg_rtx);
      RTX_FRAME_RELATED_P (insn) = 1;
    }

  if (epilogue_type == EPILOGUE_TYPE_EH_RETURN)
    {
      rtx sa = EH_RETURN_STACKADJ_RTX;
      emit_insn (gen_add3_insn (sp_reg_rtx, sp_reg_rtx, sa));
    }

  if (epilogue_type != EPILOGUE_TYPE_SIBCALL && restoring_FPRs_inline)
    {
      if (cfa_restores)
	{
	  /* We can't hang the cfa_restores off a simple return,
	     since the shrink-wrap code sometimes uses an existing
	     return.  This means there might be a path from
	     pre-prologue code to this return, and dwarf2cfi code
	     wants the eh_frame unwinder state to be the same on
	     all paths to any point.  So we need to emit the
	     cfa_restores before the return.  For -m64 we really
	     don't need epilogue cfa_restores at all, except for
	     this irritating dwarf2cfi with shrink-wrap
	     requirement;  The stack red-zone means eh_frame info
	     from the prologue telling the unwinder to restore
	     from the stack is perfectly good right to the end of
	     the function.  */
	  emit_insn (gen_blockage ());
	  emit_cfa_restores (cfa_restores);
	  cfa_restores = NULL_RTX;
	}

      emit_jump_insn (targetm.gen_simple_return ());
    }

  if (epilogue_type != EPILOGUE_TYPE_SIBCALL && !restoring_FPRs_inline)
    {
      bool lr = (strategy & REST_NOINLINE_FPRS_DOESNT_RESTORE_LR) == 0;
      rtvec p = rtvec_alloc (3 + !!lr + 64 - info->first_fp_reg_save);
      int elt = 0;
      RTVEC_ELT (p, elt++) = ret_rtx;
      if (lr)
	RTVEC_ELT (p, elt++) = gen_hard_reg_clobber (Pmode, LR_REGNO);

      /* We have to restore more than two FP registers, so branch to the
	 restore function.  It will return to our caller.  */
      int i;
      int reg;
      rtx sym;

      if (flag_shrink_wrap)
	cfa_restores = add_crlr_cfa_restore (info, cfa_restores);

      sym = rs6000_savres_routine_sym (info, SAVRES_FPR | (lr ? SAVRES_LR : 0));
      RTVEC_ELT (p, elt++) = gen_rtx_USE (VOIDmode, sym);
      reg = (DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2)? 1 : 11;
      RTVEC_ELT (p, elt++) = gen_rtx_USE (VOIDmode, gen_rtx_REG (Pmode, reg));

      for (i = 0; i < 64 - info->first_fp_reg_save; i++)
	{
	  rtx reg = gen_rtx_REG (DFmode, info->first_fp_reg_save + i);

	  RTVEC_ELT (p, elt++)
	    = gen_frame_load (reg, sp_reg_rtx, info->fp_save_offset + 8 * i);
	  if (flag_shrink_wrap
	      && save_reg_p (info->first_fp_reg_save + i))
	    cfa_restores = alloc_reg_note (REG_CFA_RESTORE, reg, cfa_restores);
	}

      emit_jump_insn (gen_rtx_PARALLEL (VOIDmode, p));
    }

  if (cfa_restores)
    {
      if (epilogue_type == EPILOGUE_TYPE_SIBCALL)
	/* Ensure the cfa_restores are hung off an insn that won't
	   be reordered above other restores.  */
	emit_insn (gen_blockage ());

      emit_cfa_restores (cfa_restores);
    }
}

/* Write function epilogue.  */

static void
rs6000_output_function_epilogue (FILE *file)
{
#if TARGET_MACHO
  macho_branch_islands ();

  {
    rtx_insn *insn = get_last_insn ();
    rtx_insn *deleted_debug_label = NULL;

    /* Mach-O doesn't support labels at the end of objects, so if
       it looks like we might want one, take special action.

       First, collect any sequence of deleted debug labels.  */
    while (insn
	   && NOTE_P (insn)
	   && NOTE_KIND (insn) != NOTE_INSN_DELETED_LABEL)
      {
	/* Don't insert a nop for NOTE_INSN_DELETED_DEBUG_LABEL
	   notes only, instead set their CODE_LABEL_NUMBER to -1,
	   otherwise there would be code generation differences
	   in between -g and -g0.  */
	if (NOTE_P (insn) && NOTE_KIND (insn) == NOTE_INSN_DELETED_DEBUG_LABEL)
	  deleted_debug_label = insn;
	insn = PREV_INSN (insn);
      }

    /* Second, if we have:
       label:
	 barrier
       then this needs to be detected, so skip past the barrier.  */

    if (insn && BARRIER_P (insn))
      insn = PREV_INSN (insn);

    /* Up to now we've only seen notes or barriers.  */
    if (insn)
      {
	if (LABEL_P (insn)
	    || (NOTE_P (insn)
		&& NOTE_KIND (insn) == NOTE_INSN_DELETED_LABEL))
	  /* Trailing label: <barrier>.  */
	  fputs ("\tnop\n", file);
	else
	  {
	    /* Lastly, see if we have a completely empty function body.  */
	    while (insn && ! INSN_P (insn))
	      insn = PREV_INSN (insn);
	    /* If we don't find any insns, we've got an empty function body;
	       I.e. completely empty - without a return or branch.  This is
	       taken as the case where a function body has been removed
	       because it contains an inline __builtin_unreachable().  GCC
	       states that reaching __builtin_unreachable() means UB so we're
	       not obliged to do anything special; however, we want
	       non-zero-sized function bodies.  To meet this, and help the
	       user out, let's trap the case.  */
	    if (insn == NULL)
	      fputs ("\ttrap\n", file);
	  }
      }
    else if (deleted_debug_label)
      for (insn = deleted_debug_label; insn; insn = NEXT_INSN (insn))
	if (NOTE_KIND (insn) == NOTE_INSN_DELETED_DEBUG_LABEL)
	  CODE_LABEL_NUMBER (insn) = -1;
  }
#endif

  /* Output a traceback table here.  See /usr/include/sys/debug.h for info
     on its format.

     We don't output a traceback table if -finhibit-size-directive was
     used.  The documentation for -finhibit-size-directive reads
     ``don't output a @code{.size} assembler directive, or anything
     else that would cause trouble if the function is split in the
     middle, and the two halves are placed at locations far apart in
     memory.''  The traceback table has this property, since it
     includes the offset from the start of the function to the
     traceback table itself.

     System V.4 Powerpc's (and the embedded ABI derived from it) use a
     different traceback table.  */
  if ((DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2)
      && ! flag_inhibit_size_directive
      && rs6000_traceback != traceback_none && !cfun->is_thunk)
    {
      const char *fname = NULL;
      const char *language_string = lang_hooks.name;
      int fixed_parms = 0, float_parms = 0, parm_info = 0;
      int i;
      int optional_tbtab;
      rs6000_stack_t *info = rs6000_stack_info ();

      if (rs6000_traceback == traceback_full)
	optional_tbtab = 1;
      else if (rs6000_traceback == traceback_part)
	optional_tbtab = 0;
      else
	optional_tbtab = !optimize_size && !TARGET_ELF;

      if (optional_tbtab)
	{
	  fname = XSTR (XEXP (DECL_RTL (current_function_decl), 0), 0);
	  while (*fname == '.')	/* V.4 encodes . in the name */
	    fname++;

	  /* Need label immediately before tbtab, so we can compute
	     its offset from the function start.  */
	  ASM_OUTPUT_INTERNAL_LABEL_PREFIX (file, "LT");
	  ASM_OUTPUT_LABEL (file, fname);
	}

      /* The .tbtab pseudo-op can only be used for the first eight
	 expressions, since it can't handle the possibly variable
	 length fields that follow.  However, if you omit the optional
	 fields, the assembler outputs zeros for all optional fields
	 anyways, giving each variable length field is minimum length
	 (as defined in sys/debug.h).  Thus we cannot use the .tbtab
	 pseudo-op at all.  */

      /* An all-zero word flags the start of the tbtab, for debuggers
	 that have to find it by searching forward from the entry
	 point or from the current pc.  */
      fputs ("\t.long 0\n", file);

      /* Tbtab format type.  Use format type 0.  */
      fputs ("\t.byte 0,", file);

      /* Language type.  Unfortunately, there does not seem to be any
	 official way to discover the language being compiled, so we
	 use language_string.
	 C is 0.  Fortran is 1.  Ada is 3.  C++ is 9.
	 Java is 13.  Objective-C is 14.  Objective-C++ isn't assigned
	 a number, so for now use 9.  LTO, Go, D, and JIT aren't assigned
	 numbers either, so for now use 0.  */
      if (lang_GNU_C ()
	  || ! strcmp (language_string, "GNU GIMPLE")
	  || ! strcmp (language_string, "GNU Go")
	  || ! strcmp (language_string, "GNU D")
	  || ! strcmp (language_string, "libgccjit"))
	i = 0;
      else if (! strcmp (language_string, "GNU F77")
	       || lang_GNU_Fortran ())
	i = 1;
      else if (! strcmp (language_string, "GNU Ada"))
	i = 3;
      else if (lang_GNU_CXX ()
	       || ! strcmp (language_string, "GNU Objective-C++"))
	i = 9;
      else if (! strcmp (language_string, "GNU Java"))
	i = 13;
      else if (! strcmp (language_string, "GNU Objective-C"))
	i = 14;
      else
	gcc_unreachable ();
      fprintf (file, "%d,", i);

      /* 8 single bit fields: global linkage (not set for C extern linkage,
	 apparently a PL/I convention?), out-of-line epilogue/prologue, offset
	 from start of procedure stored in tbtab, internal function, function
	 has controlled storage, function has no toc, function uses fp,
	 function logs/aborts fp operations.  */
      /* Assume that fp operations are used if any fp reg must be saved.  */
      fprintf (file, "%d,",
	       (optional_tbtab << 5) | ((info->first_fp_reg_save != 64) << 1));

      /* 6 bitfields: function is interrupt handler, name present in
	 proc table, function calls alloca, on condition directives
	 (controls stack walks, 3 bits), saves condition reg, saves
	 link reg.  */
      /* The `function calls alloca' bit seems to be set whenever reg 31 is
	 set up as a frame pointer, even when there is no alloca call.  */
      fprintf (file, "%d,",
	       ((optional_tbtab << 6)
		| ((optional_tbtab & frame_pointer_needed) << 5)
		| (info->cr_save_p << 1)
		| (info->lr_save_p)));

      /* 3 bitfields: saves backchain, fixup code, number of fpr saved
	 (6 bits).  */
      fprintf (file, "%d,",
	       (info->push_p << 7) | (64 - info->first_fp_reg_save));

      /* 2 bitfields: spare bits (2 bits), number of gpr saved (6 bits).  */
      fprintf (file, "%d,", (32 - first_reg_to_save ()));

      if (optional_tbtab)
	{
	  /* Compute the parameter info from the function decl argument
	     list.  */
	  tree decl;
	  int next_parm_info_bit = 31;

	  for (decl = DECL_ARGUMENTS (current_function_decl);
	       decl; decl = DECL_CHAIN (decl))
	    {
	      rtx parameter = DECL_INCOMING_RTL (decl);
	      machine_mode mode = GET_MODE (parameter);

	      if (REG_P (parameter))
		{
		  if (SCALAR_FLOAT_MODE_P (mode))
		    {
		      int bits;

		      float_parms++;

		      switch (mode)
			{
			case E_SFmode:
			case E_SDmode:
			  bits = 0x2;
			  break;

			case E_DFmode:
			case E_DDmode:
			case E_TFmode:
			case E_TDmode:
			case E_IFmode:
			case E_KFmode:
			  bits = 0x3;
			  break;

			default:
			  gcc_unreachable ();
			}

		      /* If only one bit will fit, don't or in this entry.  */
		      if (next_parm_info_bit > 0)
			parm_info |= (bits << (next_parm_info_bit - 1));
		      next_parm_info_bit -= 2;
		    }
		  else
		    {
		      fixed_parms += ((GET_MODE_SIZE (mode)
				       + (UNITS_PER_WORD - 1))
				      / UNITS_PER_WORD);
		      next_parm_info_bit -= 1;
		    }
		}
	    }
	}

      /* Number of fixed point parameters.  */
      /* This is actually the number of words of fixed point parameters; thus
	 an 8 byte struct counts as 2; and thus the maximum value is 8.  */
      fprintf (file, "%d,", fixed_parms);

      /* 2 bitfields: number of floating point parameters (7 bits), parameters
	 all on stack.  */
      /* This is actually the number of fp registers that hold parameters;
	 and thus the maximum value is 13.  */
      /* Set parameters on stack bit if parameters are not in their original
	 registers, regardless of whether they are on the stack?  Xlc
	 seems to set the bit when not optimizing.  */
      fprintf (file, "%d\n", ((float_parms << 1) | (! optimize)));

      if (optional_tbtab)
	{
	  /* Optional fields follow.  Some are variable length.  */

	  /* Parameter types, left adjusted bit fields: 0 fixed, 10 single
	     float, 11 double float.  */
	  /* There is an entry for each parameter in a register, in the order
	     that they occur in the parameter list.  Any intervening arguments
	     on the stack are ignored.  If the list overflows a long (max
	     possible length 34 bits) then completely leave off all elements
	     that don't fit.  */
	  /* Only emit this long if there was at least one parameter.  */
	  if (fixed_parms || float_parms)
	    fprintf (file, "\t.long %d\n", parm_info);

	  /* Offset from start of code to tb table.  */
	  fputs ("\t.long ", file);
	  ASM_OUTPUT_INTERNAL_LABEL_PREFIX (file, "LT");
	  RS6000_OUTPUT_BASENAME (file, fname);
	  putc ('-', file);
	  rs6000_output_function_entry (file, fname);
	  putc ('\n', file);

	  /* Interrupt handler mask.  */
	  /* Omit this long, since we never set the interrupt handler bit
	     above.  */

	  /* Number of CTL (controlled storage) anchors.  */
	  /* Omit this long, since the has_ctl bit is never set above.  */

	  /* Displacement into stack of each CTL anchor.  */
	  /* Omit this list of longs, because there are no CTL anchors.  */

	  /* Length of function name.  */
	  if (*fname == '*')
	    ++fname;
	  fprintf (file, "\t.short %d\n", (int) strlen (fname));

	  /* Function name.  */
	  assemble_string (fname, strlen (fname));

	  /* Register for alloca automatic storage; this is always reg 31.
	     Only emit this if the alloca bit was set above.  */
	  if (frame_pointer_needed)
	    fputs ("\t.byte 31\n", file);

	  fputs ("\t.align 2\n", file);
	}
    }

  /* Arrange to define .LCTOC1 label, if not already done.  */
  if (need_toc_init)
    {
      need_toc_init = 0;
      if (!toc_initialized)
	{
	  switch_to_section (toc_section);
	  switch_to_section (current_function_section ());
	}
    }
}

/* -fsplit-stack support.  */

/* A SYMBOL_REF for __morestack.  */
static GTY(()) rtx morestack_ref;

static rtx
gen_add3_const (rtx rt, rtx ra, long c)
{
  if (TARGET_64BIT)
    return gen_adddi3 (rt, ra, GEN_INT (c));
 else
    return gen_addsi3 (rt, ra, GEN_INT (c));
}

/* Emit -fsplit-stack prologue, which goes before the regular function
   prologue (at local entry point in the case of ELFv2).  */

void
rs6000_expand_split_stack_prologue (void)
{
  rs6000_stack_t *info = rs6000_stack_info ();
  unsigned HOST_WIDE_INT allocate;
  long alloc_hi, alloc_lo;
  rtx r0, r1, r12, lr, ok_label, compare, jump, call_fusage;
  rtx_insn *insn;

  gcc_assert (flag_split_stack && reload_completed);

  if (!info->push_p)
    return;

  if (global_regs[29])
    {
      error ("%qs uses register r29", "%<-fsplit-stack%>");
      inform (DECL_SOURCE_LOCATION (global_regs_decl[29]),
	      "conflicts with %qD", global_regs_decl[29]);
    }

  allocate = info->total_size;
  if (allocate > (unsigned HOST_WIDE_INT) 1 << 31)
    {
      sorry ("Stack frame larger than 2G is not supported for "
	     "%<-fsplit-stack%>");
      return;
    }
  if (morestack_ref == NULL_RTX)
    {
      morestack_ref = gen_rtx_SYMBOL_REF (Pmode, "__morestack");
      SYMBOL_REF_FLAGS (morestack_ref) |= (SYMBOL_FLAG_LOCAL
					   | SYMBOL_FLAG_FUNCTION);
    }

  r0 = gen_rtx_REG (Pmode, 0);
  r1 = gen_rtx_REG (Pmode, STACK_POINTER_REGNUM);
  r12 = gen_rtx_REG (Pmode, 12);
  emit_insn (gen_load_split_stack_limit (r0));
  /* Always emit two insns here to calculate the requested stack,
     so that the linker can edit them when adjusting size for calling
     non-split-stack code.  */
  alloc_hi = (-allocate + 0x8000) & ~0xffffL;
  alloc_lo = -allocate - alloc_hi;
  if (alloc_hi != 0)
    {
      emit_insn (gen_add3_const (r12, r1, alloc_hi));
      if (alloc_lo != 0)
	emit_insn (gen_add3_const (r12, r12, alloc_lo));
      else
	emit_insn (gen_nop ());
    }
  else
    {
      emit_insn (gen_add3_const (r12, r1, alloc_lo));
      emit_insn (gen_nop ());
    }

  compare = gen_rtx_REG (CCUNSmode, CR7_REGNO);
  emit_insn (gen_rtx_SET (compare, gen_rtx_COMPARE (CCUNSmode, r12, r0)));
  ok_label = gen_label_rtx ();
  jump = gen_rtx_IF_THEN_ELSE (VOIDmode,
			       gen_rtx_GEU (VOIDmode, compare, const0_rtx),
			       gen_rtx_LABEL_REF (VOIDmode, ok_label),
			       pc_rtx);
  insn = emit_jump_insn (gen_rtx_SET (pc_rtx, jump));
  JUMP_LABEL (insn) = ok_label;
  /* Mark the jump as very likely to be taken.  */
  add_reg_br_prob_note (insn, profile_probability::very_likely ());

  lr = gen_rtx_REG (Pmode, LR_REGNO);
  insn = emit_move_insn (r0, lr);
  RTX_FRAME_RELATED_P (insn) = 1;
  insn = emit_insn (gen_frame_store (r0, r1, info->lr_save_offset));
  RTX_FRAME_RELATED_P (insn) = 1;

  insn = emit_call_insn (gen_call (gen_rtx_MEM (SImode, morestack_ref),
				   const0_rtx, const0_rtx));
  call_fusage = NULL_RTX;
  use_reg (&call_fusage, r12);
  /* Say the call uses r0, even though it doesn't, to stop regrename
     from twiddling with the insns saving lr, trashing args for cfun.
     The insns restoring lr are similarly protected by making
     split_stack_return use r0.  */
  use_reg (&call_fusage, r0);
  add_function_usage_to (insn, call_fusage);
  /* Indicate that this function can't jump to non-local gotos.  */
  make_reg_eh_region_note_nothrow_nononlocal (insn);
  emit_insn (gen_frame_load (r0, r1, info->lr_save_offset));
  insn = emit_move_insn (lr, r0);
  add_reg_note (insn, REG_CFA_RESTORE, lr);
  RTX_FRAME_RELATED_P (insn) = 1;
  emit_insn (gen_split_stack_return ());

  emit_label (ok_label);
  LABEL_NUSES (ok_label) = 1;
}

/* Return the internal arg pointer used for function incoming
   arguments.  When -fsplit-stack, the arg pointer is r12 so we need
   to copy it to a pseudo in order for it to be preserved over calls
   and suchlike.  We'd really like to use a pseudo here for the
   internal arg pointer but data-flow analysis is not prepared to
   accept pseudos as live at the beginning of a function.  */

static rtx
rs6000_internal_arg_pointer (void)
{
  if (flag_split_stack
     && (lookup_attribute ("no_split_stack", DECL_ATTRIBUTES (cfun->decl))
         == NULL))

    {
      if (cfun->machine->split_stack_arg_pointer == NULL_RTX)
	{
	  rtx pat;

	  cfun->machine->split_stack_arg_pointer = gen_reg_rtx (Pmode);
	  REG_POINTER (cfun->machine->split_stack_arg_pointer) = 1;

	  /* Put the pseudo initialization right after the note at the
	     beginning of the function.  */
	  pat = gen_rtx_SET (cfun->machine->split_stack_arg_pointer,
			     gen_rtx_REG (Pmode, 12));
	  push_topmost_sequence ();
	  emit_insn_after (pat, get_insns ());
	  pop_topmost_sequence ();
	}
      rtx ret = plus_constant (Pmode, cfun->machine->split_stack_arg_pointer,
			       FIRST_PARM_OFFSET (current_function_decl));
      return copy_to_reg (ret);
    }
  return virtual_incoming_args_rtx;
}

/* We may have to tell the dataflow pass that the split stack prologue
   is initializing a register.  */

static void
rs6000_live_on_entry (bitmap regs)
{
  if (flag_split_stack)
    bitmap_set_bit (regs, 12);
}

/* Emit -fsplit-stack dynamic stack allocation space check.  */

void
rs6000_split_stack_space_check (rtx size, rtx label)
{
  rtx sp = gen_rtx_REG (Pmode, STACK_POINTER_REGNUM);
  rtx limit = gen_reg_rtx (Pmode);
  rtx requested = gen_reg_rtx (Pmode);
  rtx cmp = gen_reg_rtx (CCUNSmode);
  rtx jump;

  emit_insn (gen_load_split_stack_limit (limit));
  if (CONST_INT_P (size))
    emit_insn (gen_add3_insn (requested, sp, GEN_INT (-INTVAL (size))));
  else
    {
      size = force_reg (Pmode, size);
      emit_move_insn (requested, gen_rtx_MINUS (Pmode, sp, size));
    }
  emit_insn (gen_rtx_SET (cmp, gen_rtx_COMPARE (CCUNSmode, requested, limit)));
  jump = gen_rtx_IF_THEN_ELSE (VOIDmode,
			       gen_rtx_GEU (VOIDmode, cmp, const0_rtx),
			       gen_rtx_LABEL_REF (VOIDmode, label),
			       pc_rtx);
  jump = emit_jump_insn (gen_rtx_SET (pc_rtx, jump));
  JUMP_LABEL (jump) = label;
}

/* A C compound statement that outputs the assembler code for a thunk
   function, used to implement C++ virtual function calls with
   multiple inheritance.  The thunk acts as a wrapper around a virtual
   function, adjusting the implicit object parameter before handing
   control off to the real function.

   First, emit code to add the integer DELTA to the location that
   contains the incoming first argument.  Assume that this argument
   contains a pointer, and is the one used to pass the `this' pointer
   in C++.  This is the incoming argument *before* the function
   prologue, e.g. `%o0' on a sparc.  The addition must preserve the
   values of all other incoming arguments.

   After the addition, emit code to jump to FUNCTION, which is a
   `FUNCTION_DECL'.  This is a direct pure jump, not a call, and does
   not touch the return address.  Hence returning from FUNCTION will
   return to whoever called the current `thunk'.

   The effect must be as if FUNCTION had been called directly with the
   adjusted first argument.  This macro is responsible for emitting
   all of the code for a thunk function; output_function_prologue()
   and output_function_epilogue() are not invoked.

   The THUNK_FNDECL is redundant.  (DELTA and FUNCTION have already
   been extracted from it.)  It might possibly be useful on some
   targets, but probably not.

   If you do not define this macro, the target-independent code in the
   C++ frontend will generate a less efficient heavyweight thunk that
   calls FUNCTION instead of jumping to it.  The generic approach does
   not support varargs.  */

static void
rs6000_output_mi_thunk (FILE *file, tree thunk_fndecl ATTRIBUTE_UNUSED,
			HOST_WIDE_INT delta, HOST_WIDE_INT vcall_offset,
			tree function)
{
  const char *fnname = IDENTIFIER_POINTER (DECL_ASSEMBLER_NAME (thunk_fndecl));
  rtx this_rtx, funexp;
  rtx_insn *insn;

  reload_completed = 1;
  epilogue_completed = 1;

  /* Mark the end of the (empty) prologue.  */
  emit_note (NOTE_INSN_PROLOGUE_END);

  /* Find the "this" pointer.  If the function returns a structure,
     the structure return pointer is in r3.  */
  if (aggregate_value_p (TREE_TYPE (TREE_TYPE (function)), function))
    this_rtx = gen_rtx_REG (Pmode, 4);
  else
    this_rtx = gen_rtx_REG (Pmode, 3);

  /* Apply the constant offset, if required.  */
  if (delta)
    emit_insn (gen_add3_insn (this_rtx, this_rtx, GEN_INT (delta)));

  /* Apply the offset from the vtable, if required.  */
  if (vcall_offset)
    {
      rtx vcall_offset_rtx = GEN_INT (vcall_offset);
      rtx tmp = gen_rtx_REG (Pmode, 12);

      emit_move_insn (tmp, gen_rtx_MEM (Pmode, this_rtx));
      if (((unsigned HOST_WIDE_INT) vcall_offset) + 0x8000 >= 0x10000)
	{
	  emit_insn (gen_add3_insn (tmp, tmp, vcall_offset_rtx));
	  emit_move_insn (tmp, gen_rtx_MEM (Pmode, tmp));
	}
      else
	{
	  rtx loc = gen_rtx_PLUS (Pmode, tmp, vcall_offset_rtx);

	  emit_move_insn (tmp, gen_rtx_MEM (Pmode, loc));
	}
      emit_insn (gen_add3_insn (this_rtx, this_rtx, tmp));
    }

  /* Generate a tail call to the target function.  */
  if (!TREE_USED (function))
    {
      assemble_external (function);
      TREE_USED (function) = 1;
    }
  funexp = XEXP (DECL_RTL (function), 0);
  funexp = gen_rtx_MEM (FUNCTION_MODE, funexp);

#if TARGET_MACHO
  if (MACHOPIC_INDIRECT)
    funexp = machopic_indirect_call_target (funexp);
#endif

  /* gen_sibcall expects reload to convert scratch pseudo to LR so we must
     generate sibcall RTL explicitly.  */
  insn = emit_call_insn (
	   gen_rtx_PARALLEL (VOIDmode,
	     gen_rtvec (3,
			gen_rtx_CALL (VOIDmode,
				      funexp, const0_rtx),
			gen_rtx_USE (VOIDmode, const0_rtx),
			simple_return_rtx)));
  SIBLING_CALL_P (insn) = 1;
  emit_barrier ();

  /* Run just enough of rest_of_compilation to get the insns emitted.
     There's not really enough bulk here to make other passes such as
     instruction scheduling worth while.  */
  insn = get_insns ();
  shorten_branches (insn);
  assemble_start_function (thunk_fndecl, fnname);
  final_start_function (insn, file, 1);
  final (insn, file, 1);
  final_end_function ();
  assemble_end_function (thunk_fndecl, fnname);

  reload_completed = 0;
  epilogue_completed = 0;
}

/* A quick summary of the various types of 'constant-pool tables'
   under PowerPC:

   Target	Flags		Name		One table per
   AIX		(none)		AIX TOC		object file
   AIX		-mfull-toc	AIX TOC		object file
   AIX		-mminimal-toc	AIX minimal TOC	translation unit
   SVR4/EABI	(none)		SVR4 SDATA	object file
   SVR4/EABI	-fpic		SVR4 pic	object file
   SVR4/EABI	-fPIC		SVR4 PIC	translation unit
   SVR4/EABI	-mrelocatable	EABI TOC	function
   SVR4/EABI	-maix		AIX TOC		object file
   SVR4/EABI	-maix -mminimal-toc
				AIX minimal TOC	translation unit

   Name			Reg.	Set by	entries	      contains:
					made by	 addrs?	fp?	sum?

   AIX TOC		2	crt0	as	 Y	option	option
   AIX minimal TOC	30	prolog	gcc	 Y	Y	option
   SVR4 SDATA		13	crt0	gcc	 N	Y	N
   SVR4 pic		30	prolog	ld	 Y	not yet	N
   SVR4 PIC		30	prolog	gcc	 Y	option	option
   EABI TOC		30	prolog	gcc	 Y	option	option

*/

/* Hash functions for the hash table.  */

static unsigned
rs6000_hash_constant (rtx k)
{
  enum rtx_code code = GET_CODE (k);
  machine_mode mode = GET_MODE (k);
  unsigned result = (code << 3) ^ mode;
  const char *format;
  int flen, fidx;

  format = GET_RTX_FORMAT (code);
  flen = strlen (format);
  fidx = 0;

  switch (code)
    {
    case LABEL_REF:
      return result * 1231 + (unsigned) INSN_UID (XEXP (k, 0));

    case CONST_WIDE_INT:
      {
	int i;
	flen = CONST_WIDE_INT_NUNITS (k);
	for (i = 0; i < flen; i++)
	  result = result * 613 + CONST_WIDE_INT_ELT (k, i);
	return result;
      }

    case CONST_DOUBLE:
      return real_hash (CONST_DOUBLE_REAL_VALUE (k)) * result;

    case CODE_LABEL:
      fidx = 3;
      break;

    default:
      break;
    }

  for (; fidx < flen; fidx++)
    switch (format[fidx])
      {
      case 's':
	{
	  unsigned i, len;
	  const char *str = XSTR (k, fidx);
	  len = strlen (str);
	  result = result * 613 + len;
	  for (i = 0; i < len; i++)
	    result = result * 613 + (unsigned) str[i];
	  break;
	}
      case 'u':
      case 'e':
	result = result * 1231 + rs6000_hash_constant (XEXP (k, fidx));
	break;
      case 'i':
      case 'n':
	result = result * 613 + (unsigned) XINT (k, fidx);
	break;
      case 'w':
	if (sizeof (unsigned) >= sizeof (HOST_WIDE_INT))
	  result = result * 613 + (unsigned) XWINT (k, fidx);
	else
	  {
	    size_t i;
	    for (i = 0; i < sizeof (HOST_WIDE_INT) / sizeof (unsigned); i++)
	      result = result * 613 + (unsigned) (XWINT (k, fidx)
						  >> CHAR_BIT * i);
	  }
	break;
      case '0':
	break;
      default:
	gcc_unreachable ();
      }

  return result;
}

hashval_t
toc_hasher::hash (toc_hash_struct *thc)
{
  return rs6000_hash_constant (thc->key) ^ thc->key_mode;
}

/* Compare H1 and H2 for equivalence.  */

bool
toc_hasher::equal (toc_hash_struct *h1, toc_hash_struct *h2)
{
  rtx r1 = h1->key;
  rtx r2 = h2->key;

  if (h1->key_mode != h2->key_mode)
    return 0;

  return rtx_equal_p (r1, r2);
}

/* These are the names given by the C++ front-end to vtables, and
   vtable-like objects.  Ideally, this logic should not be here;
   instead, there should be some programmatic way of inquiring as
   to whether or not an object is a vtable.  */

#define VTABLE_NAME_P(NAME)				\
  (strncmp ("_vt.", name, strlen ("_vt.")) == 0		\
  || strncmp ("_ZTV", name, strlen ("_ZTV")) == 0	\
  || strncmp ("_ZTT", name, strlen ("_ZTT")) == 0	\
  || strncmp ("_ZTI", name, strlen ("_ZTI")) == 0	\
  || strncmp ("_ZTC", name, strlen ("_ZTC")) == 0)

#ifdef NO_DOLLAR_IN_LABEL
/* Return a GGC-allocated character string translating dollar signs in
   input NAME to underscores.  Used by XCOFF ASM_OUTPUT_LABELREF.  */

const char *
rs6000_xcoff_strip_dollar (const char *name)
{
  char *strip, *p;
  const char *q;
  size_t len;

  q = (const char *) strchr (name, '$');

  if (q == 0 || q == name)
    return name;

  len = strlen (name);
  strip = XALLOCAVEC (char, len + 1);
  strcpy (strip, name);
  p = strip + (q - name);
  while (p)
    {
      *p = '_';
      p = strchr (p + 1, '$');
    }

  return ggc_alloc_string (strip, len);
}
#endif

void
rs6000_output_symbol_ref (FILE *file, rtx x)
{
  const char *name = XSTR (x, 0);

  /* Currently C++ toc references to vtables can be emitted before it
     is decided whether the vtable is public or private.  If this is
     the case, then the linker will eventually complain that there is
     a reference to an unknown section.  Thus, for vtables only,
     we emit the TOC reference to reference the identifier and not the
     symbol.  */
  if (VTABLE_NAME_P (name))
    {
      RS6000_OUTPUT_BASENAME (file, name);
    }
  else
    assemble_name (file, name);
}

/* Output a TOC entry.  We derive the entry name from what is being
   written.  */

void
output_toc (FILE *file, rtx x, int labelno, machine_mode mode)
{
  char buf[256];
  const char *name = buf;
  rtx base = x;
  HOST_WIDE_INT offset = 0;

  gcc_assert (!TARGET_NO_TOC);

  /* When the linker won't eliminate them, don't output duplicate
     TOC entries (this happens on AIX if there is any kind of TOC,
     and on SVR4 under -fPIC or -mrelocatable).  Don't do this for
     CODE_LABELs.  */
  if (TARGET_TOC && GET_CODE (x) != LABEL_REF)
    {
      struct toc_hash_struct *h;

      /* Create toc_hash_table.  This can't be done at TARGET_OPTION_OVERRIDE
	 time because GGC is not initialized at that point.  */
      if (toc_hash_table == NULL)
	toc_hash_table = hash_table<toc_hasher>::create_ggc (1021);

      h = ggc_alloc<toc_hash_struct> ();
      h->key = x;
      h->key_mode = mode;
      h->labelno = labelno;

      toc_hash_struct **found = toc_hash_table->find_slot (h, INSERT);
      if (*found == NULL)
	*found = h;
      else  /* This is indeed a duplicate.
	       Set this label equal to that label.  */
	{
	  fputs ("\t.set ", file);
	  ASM_OUTPUT_INTERNAL_LABEL_PREFIX (file, "LC");
	  fprintf (file, "%d,", labelno);
	  ASM_OUTPUT_INTERNAL_LABEL_PREFIX (file, "LC");
	  fprintf (file, "%d\n", ((*found)->labelno));

#ifdef HAVE_AS_TLS
	  if (TARGET_XCOFF && SYMBOL_REF_P (x)
	      && (SYMBOL_REF_TLS_MODEL (x) == TLS_MODEL_GLOBAL_DYNAMIC
		  || SYMBOL_REF_TLS_MODEL (x) == TLS_MODEL_LOCAL_DYNAMIC))
	    {
	      fputs ("\t.set ", file);
	      ASM_OUTPUT_INTERNAL_LABEL_PREFIX (file, "LCM");
	      fprintf (file, "%d,", labelno);
	      ASM_OUTPUT_INTERNAL_LABEL_PREFIX (file, "LCM");
	      fprintf (file, "%d\n", ((*found)->labelno));
	    }
#endif
	  return;
	}
    }

  /* If we're going to put a double constant in the TOC, make sure it's
     aligned properly when strict alignment is on.  */
  if ((CONST_DOUBLE_P (x) || CONST_WIDE_INT_P (x))
      && STRICT_ALIGNMENT
      && GET_MODE_BITSIZE (mode) >= 64
      && ! (TARGET_NO_FP_IN_TOC && ! TARGET_MINIMAL_TOC)) {
    ASM_OUTPUT_ALIGN (file, 3);
  }

  (*targetm.asm_out.internal_label) (file, "LC", labelno);

  /* Handle FP constants specially.  Note that if we have a minimal
     TOC, things we put here aren't actually in the TOC, so we can allow
     FP constants.  */
  if (CONST_DOUBLE_P (x)
      && (GET_MODE (x) == TFmode || GET_MODE (x) == TDmode
	  || GET_MODE (x) == IFmode || GET_MODE (x) == KFmode))
    {
      long k[4];

      if (DECIMAL_FLOAT_MODE_P (GET_MODE (x)))
	REAL_VALUE_TO_TARGET_DECIMAL128 (*CONST_DOUBLE_REAL_VALUE (x), k);
      else
	REAL_VALUE_TO_TARGET_LONG_DOUBLE (*CONST_DOUBLE_REAL_VALUE (x), k);

      if (TARGET_64BIT)
	{
	  if (TARGET_ELF || TARGET_MINIMAL_TOC)
	    fputs (DOUBLE_INT_ASM_OP, file);
	  else
	    fprintf (file, "\t.tc FT_%lx_%lx_%lx_%lx[TC],",
		     k[0] & 0xffffffff, k[1] & 0xffffffff,
		     k[2] & 0xffffffff, k[3] & 0xffffffff);
	  fprintf (file, "0x%lx%08lx,0x%lx%08lx\n",
		   k[WORDS_BIG_ENDIAN ? 0 : 1] & 0xffffffff,
		   k[WORDS_BIG_ENDIAN ? 1 : 0] & 0xffffffff,
		   k[WORDS_BIG_ENDIAN ? 2 : 3] & 0xffffffff,
		   k[WORDS_BIG_ENDIAN ? 3 : 2] & 0xffffffff);
	  return;
	}
      else
	{
	  if (TARGET_ELF || TARGET_MINIMAL_TOC)
	    fputs ("\t.long ", file);
	  else
	    fprintf (file, "\t.tc FT_%lx_%lx_%lx_%lx[TC],",
		     k[0] & 0xffffffff, k[1] & 0xffffffff,
		     k[2] & 0xffffffff, k[3] & 0xffffffff);
	  fprintf (file, "0x%lx,0x%lx,0x%lx,0x%lx\n",
		   k[0] & 0xffffffff, k[1] & 0xffffffff,
		   k[2] & 0xffffffff, k[3] & 0xffffffff);
	  return;
	}
    }
  else if (CONST_DOUBLE_P (x)
	   && (GET_MODE (x) == DFmode || GET_MODE (x) == DDmode))
    {
      long k[2];

      if (DECIMAL_FLOAT_MODE_P (GET_MODE (x)))
	REAL_VALUE_TO_TARGET_DECIMAL64 (*CONST_DOUBLE_REAL_VALUE (x), k);
      else
	REAL_VALUE_TO_TARGET_DOUBLE (*CONST_DOUBLE_REAL_VALUE (x), k);

      if (TARGET_64BIT)
	{
	  if (TARGET_ELF || TARGET_MINIMAL_TOC)
	    fputs (DOUBLE_INT_ASM_OP, file);
	  else
	    fprintf (file, "\t.tc FD_%lx_%lx[TC],",
		     k[0] & 0xffffffff, k[1] & 0xffffffff);
	  fprintf (file, "0x%lx%08lx\n",
		   k[WORDS_BIG_ENDIAN ? 0 : 1] & 0xffffffff,
		   k[WORDS_BIG_ENDIAN ? 1 : 0] & 0xffffffff);
	  return;
	}
      else
	{
	  if (TARGET_ELF || TARGET_MINIMAL_TOC)
	    fputs ("\t.long ", file);
	  else
	    fprintf (file, "\t.tc FD_%lx_%lx[TC],",
		     k[0] & 0xffffffff, k[1] & 0xffffffff);
	  fprintf (file, "0x%lx,0x%lx\n",
		   k[0] & 0xffffffff, k[1] & 0xffffffff);
	  return;
	}
    }
  else if (CONST_DOUBLE_P (x)
	   && (GET_MODE (x) == SFmode || GET_MODE (x) == SDmode))
    {
      long l;

      if (DECIMAL_FLOAT_MODE_P (GET_MODE (x)))
	REAL_VALUE_TO_TARGET_DECIMAL32 (*CONST_DOUBLE_REAL_VALUE (x), l);
      else
	REAL_VALUE_TO_TARGET_SINGLE (*CONST_DOUBLE_REAL_VALUE (x), l);

      if (TARGET_64BIT)
	{
	  if (TARGET_ELF || TARGET_MINIMAL_TOC)
	    fputs (DOUBLE_INT_ASM_OP, file);
	  else
	    fprintf (file, "\t.tc FS_%lx[TC],", l & 0xffffffff);
	  if (WORDS_BIG_ENDIAN)
	    fprintf (file, "0x%lx00000000\n", l & 0xffffffff);
	  else
	    fprintf (file, "0x%lx\n", l & 0xffffffff);
	  return;
	}
      else
	{
	  if (TARGET_ELF || TARGET_MINIMAL_TOC)
	    fputs ("\t.long ", file);
	  else
	    fprintf (file, "\t.tc FS_%lx[TC],", l & 0xffffffff);
	  fprintf (file, "0x%lx\n", l & 0xffffffff);
	  return;
	}
    }
  else if (GET_MODE (x) == VOIDmode && CONST_INT_P (x))
    {
      unsigned HOST_WIDE_INT low;
      HOST_WIDE_INT high;

      low = INTVAL (x) & 0xffffffff;
      high = (HOST_WIDE_INT) INTVAL (x) >> 32;

      /* TOC entries are always Pmode-sized, so when big-endian
	 smaller integer constants in the TOC need to be padded.
	 (This is still a win over putting the constants in
	 a separate constant pool, because then we'd have
	 to have both a TOC entry _and_ the actual constant.)

	 For a 32-bit target, CONST_INT values are loaded and shifted
	 entirely within `low' and can be stored in one TOC entry.  */

      /* It would be easy to make this work, but it doesn't now.  */
      gcc_assert (!TARGET_64BIT || POINTER_SIZE >= GET_MODE_BITSIZE (mode));

      if (WORDS_BIG_ENDIAN && POINTER_SIZE > GET_MODE_BITSIZE (mode))
	{
	  low |= high << 32;
	  low <<= POINTER_SIZE - GET_MODE_BITSIZE (mode);
	  high = (HOST_WIDE_INT) low >> 32;
	  low &= 0xffffffff;
	}

      if (TARGET_64BIT)
	{
	  if (TARGET_ELF || TARGET_MINIMAL_TOC)
	    fputs (DOUBLE_INT_ASM_OP, file);
	  else
	    fprintf (file, "\t.tc ID_%lx_%lx[TC],",
		     (long) high & 0xffffffff, (long) low & 0xffffffff);
	  fprintf (file, "0x%lx%08lx\n",
		   (long) high & 0xffffffff, (long) low & 0xffffffff);
	  return;
	}
      else
	{
	  if (POINTER_SIZE < GET_MODE_BITSIZE (mode))
	    {
	      if (TARGET_ELF || TARGET_MINIMAL_TOC)
		fputs ("\t.long ", file);
	      else
		fprintf (file, "\t.tc ID_%lx_%lx[TC],",
			 (long) high & 0xffffffff, (long) low & 0xffffffff);
	      fprintf (file, "0x%lx,0x%lx\n",
		       (long) high & 0xffffffff, (long) low & 0xffffffff);
	    }
	  else
	    {
	      if (TARGET_ELF || TARGET_MINIMAL_TOC)
		fputs ("\t.long ", file);
	      else
		fprintf (file, "\t.tc IS_%lx[TC],", (long) low & 0xffffffff);
	      fprintf (file, "0x%lx\n", (long) low & 0xffffffff);
	    }
	  return;
	}
    }

  if (GET_CODE (x) == CONST)
    {
      gcc_assert (GET_CODE (XEXP (x, 0)) == PLUS
		  && CONST_INT_P (XEXP (XEXP (x, 0), 1)));

      base = XEXP (XEXP (x, 0), 0);
      offset = INTVAL (XEXP (XEXP (x, 0), 1));
    }

  switch (GET_CODE (base))
    {
    case SYMBOL_REF:
      name = XSTR (base, 0);
      break;

    case LABEL_REF:
      ASM_GENERATE_INTERNAL_LABEL (buf, "L",
				   CODE_LABEL_NUMBER (XEXP (base, 0)));
      break;

    case CODE_LABEL:
      ASM_GENERATE_INTERNAL_LABEL (buf, "L", CODE_LABEL_NUMBER (base));
      break;

    default:
      gcc_unreachable ();
    }

  if (TARGET_ELF || TARGET_MINIMAL_TOC)
    fputs (TARGET_32BIT ? "\t.long " : DOUBLE_INT_ASM_OP, file);
  else
    {
      fputs ("\t.tc ", file);
      RS6000_OUTPUT_BASENAME (file, name);

      if (offset < 0)
	fprintf (file, ".N" HOST_WIDE_INT_PRINT_UNSIGNED, - offset);
      else if (offset)
	fprintf (file, ".P" HOST_WIDE_INT_PRINT_UNSIGNED, offset);

      /* Mark large TOC symbols on AIX with [TE] so they are mapped
	 after other TOC symbols, reducing overflow of small TOC access
	 to [TC] symbols.  */
      fputs (TARGET_XCOFF && TARGET_CMODEL != CMODEL_SMALL
	     ? "[TE]," : "[TC],", file);
    }

  /* Currently C++ toc references to vtables can be emitted before it
     is decided whether the vtable is public or private.  If this is
     the case, then the linker will eventually complain that there is
     a TOC reference to an unknown section.  Thus, for vtables only,
     we emit the TOC reference to reference the symbol and not the
     section.  */
  if (VTABLE_NAME_P (name))
    {
      RS6000_OUTPUT_BASENAME (file, name);
      if (offset < 0)
	fprintf (file, HOST_WIDE_INT_PRINT_DEC, offset);
      else if (offset > 0)
	fprintf (file, "+" HOST_WIDE_INT_PRINT_DEC, offset);
    }
  else
    output_addr_const (file, x);

#if HAVE_AS_TLS
  if (TARGET_XCOFF && SYMBOL_REF_P (base))
    {
      switch (SYMBOL_REF_TLS_MODEL (base))
	{
	case 0:
	  break;
	case TLS_MODEL_LOCAL_EXEC:
	  fputs ("@le", file);
	  break;
	case TLS_MODEL_INITIAL_EXEC:
	  fputs ("@ie", file);
	  break;
	/* Use global-dynamic for local-dynamic.  */
	case TLS_MODEL_GLOBAL_DYNAMIC:
	case TLS_MODEL_LOCAL_DYNAMIC:
	  putc ('\n', file);
	  (*targetm.asm_out.internal_label) (file, "LCM", labelno);
	  fputs ("\t.tc .", file);
	  RS6000_OUTPUT_BASENAME (file, name);
	  fputs ("[TC],", file);
	  output_addr_const (file, x);
	  fputs ("@m", file);
	  break;
	default:
	  gcc_unreachable ();
	}
    }
#endif

  putc ('\n', file);
}

/* Output an assembler pseudo-op to write an ASCII string of N characters
   starting at P to FILE.

   On the RS/6000, we have to do this using the .byte operation and
   write out special characters outside the quoted string.
   Also, the assembler is broken; very long strings are truncated,
   so we must artificially break them up early.  */

void
output_ascii (FILE *file, const char *p, int n)
{
  char c;
  int i, count_string;
  const char *for_string = "\t.byte \"";
  const char *for_decimal = "\t.byte ";
  const char *to_close = NULL;

  count_string = 0;
  for (i = 0; i < n; i++)
    {
      c = *p++;
      if (c >= ' ' && c < 0177)
	{
	  if (for_string)
	    fputs (for_string, file);
	  putc (c, file);

	  /* Write two quotes to get one.  */
	  if (c == '"')
	    {
	      putc (c, file);
	      ++count_string;
	    }

	  for_string = NULL;
	  for_decimal = "\"\n\t.byte ";
	  to_close = "\"\n";
	  ++count_string;

	  if (count_string >= 512)
	    {
	      fputs (to_close, file);

	      for_string = "\t.byte \"";
	      for_decimal = "\t.byte ";
	      to_close = NULL;
	      count_string = 0;
	    }
	}
      else
	{
	  if (for_decimal)
	    fputs (for_decimal, file);
	  fprintf (file, "%d", c);

	  for_string = "\n\t.byte \"";
	  for_decimal = ", ";
	  to_close = "\n";
	  count_string = 0;
	}
    }

  /* Now close the string if we have written one.  Then end the line.  */
  if (to_close)
    fputs (to_close, file);
}

/* Generate a unique section name for FILENAME for a section type
   represented by SECTION_DESC.  Output goes into BUF.

   SECTION_DESC can be any string, as long as it is different for each
   possible section type.

   We name the section in the same manner as xlc.  The name begins with an
   underscore followed by the filename (after stripping any leading directory
   names) with the last period replaced by the string SECTION_DESC.  If
   FILENAME does not contain a period, SECTION_DESC is appended to the end of
   the name.  */

void
rs6000_gen_section_name (char **buf, const char *filename,
			 const char *section_desc)
{
  const char *q, *after_last_slash, *last_period = 0;
  char *p;
  int len;

  after_last_slash = filename;
  for (q = filename; *q; q++)
    {
      if (*q == '/')
	after_last_slash = q + 1;
      else if (*q == '.')
	last_period = q;
    }

  len = strlen (after_last_slash) + strlen (section_desc) + 2;
  *buf = (char *) xmalloc (len);

  p = *buf;
  *p++ = '_';

  for (q = after_last_slash; *q; q++)
    {
      if (q == last_period)
	{
	  strcpy (p, section_desc);
	  p += strlen (section_desc);
	  break;
	}

      else if (ISALNUM (*q))
	*p++ = *q;
    }

  if (last_period == 0)
    strcpy (p, section_desc);
  else
    *p = '\0';
}

/* Emit profile function.  */

void
output_profile_hook (int labelno ATTRIBUTE_UNUSED)
{
  /* Non-standard profiling for kernels, which just saves LR then calls
     _mcount without worrying about arg saves.  The idea is to change
     the function prologue as little as possible as it isn't easy to
     account for arg save/restore code added just for _mcount.  */
  if (TARGET_PROFILE_KERNEL)
    return;

  if (DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_ELFv2)
    {
#ifndef NO_PROFILE_COUNTERS
# define NO_PROFILE_COUNTERS 0
#endif
      if (NO_PROFILE_COUNTERS)
	emit_library_call (init_one_libfunc (RS6000_MCOUNT),
			   LCT_NORMAL, VOIDmode);
      else
	{
	  char buf[30];
	  const char *label_name;
	  rtx fun;

	  ASM_GENERATE_INTERNAL_LABEL (buf, "LP", labelno);
	  label_name = ggc_strdup ((*targetm.strip_name_encoding) (buf));
	  fun = gen_rtx_SYMBOL_REF (Pmode, label_name);

	  emit_library_call (init_one_libfunc (RS6000_MCOUNT),
			     LCT_NORMAL, VOIDmode, fun, Pmode);
	}
    }
  else if (DEFAULT_ABI == ABI_DARWIN)
    {
      const char *mcount_name = RS6000_MCOUNT;
      int caller_addr_regno = LR_REGNO;

      /* Be conservative and always set this, at least for now.  */
      crtl->uses_pic_offset_table = 1;

#if TARGET_MACHO
      /* For PIC code, set up a stub and collect the caller's address
	 from r0, which is where the prologue puts it.  */
      if (MACHOPIC_INDIRECT
	  && crtl->uses_pic_offset_table)
	caller_addr_regno = 0;
#endif
      emit_library_call (gen_rtx_SYMBOL_REF (Pmode, mcount_name),
			 LCT_NORMAL, VOIDmode,
			 gen_rtx_REG (Pmode, caller_addr_regno), Pmode);
    }
}

/* Write function profiler code.  */

void
output_function_profiler (FILE *file, int labelno)
{
  char buf[100];

  switch (DEFAULT_ABI)
    {
    default:
      gcc_unreachable ();

    case ABI_V4:
      if (!TARGET_32BIT)
	{
	  warning (0, "no profiling of 64-bit code for this ABI");
	  return;
	}
      ASM_GENERATE_INTERNAL_LABEL (buf, "LP", labelno);
      fprintf (file, "\tmflr %s\n", reg_names[0]);
      if (NO_PROFILE_COUNTERS)
	{
	  asm_fprintf (file, "\tstw %s,4(%s)\n",
		       reg_names[0], reg_names[1]);
	}
      else if (TARGET_SECURE_PLT && flag_pic)
	{
	  if (TARGET_LINK_STACK)
	    {
	      char name[32];
	      get_ppc476_thunk_name (name);
	      asm_fprintf (file, "\tbl %s\n", name);
	    }
	  else
	    asm_fprintf (file, "\tbcl 20,31,1f\n1:\n");
	  asm_fprintf (file, "\tstw %s,4(%s)\n",
		       reg_names[0], reg_names[1]);
	  asm_fprintf (file, "\tmflr %s\n", reg_names[12]);
	  asm_fprintf (file, "\taddis %s,%s,",
		       reg_names[12], reg_names[12]);
	  assemble_name (file, buf);
	  asm_fprintf (file, "-1b@ha\n\tla %s,", reg_names[0]);
	  assemble_name (file, buf);
	  asm_fprintf (file, "-1b@l(%s)\n", reg_names[12]);
	}
      else if (flag_pic == 1)
	{
	  fputs ("\tbl _GLOBAL_OFFSET_TABLE_@local-4\n", file);
	  asm_fprintf (file, "\tstw %s,4(%s)\n",
		       reg_names[0], reg_names[1]);
	  asm_fprintf (file, "\tmflr %s\n", reg_names[12]);
	  asm_fprintf (file, "\tlwz %s,", reg_names[0]);
	  assemble_name (file, buf);
	  asm_fprintf (file, "@got(%s)\n", reg_names[12]);
	}
      else if (flag_pic > 1)
	{
	  asm_fprintf (file, "\tstw %s,4(%s)\n",
		       reg_names[0], reg_names[1]);
	  /* Now, we need to get the address of the label.  */
	  if (TARGET_LINK_STACK)
	    {
	      char name[32];
	      get_ppc476_thunk_name (name);
	      asm_fprintf (file, "\tbl %s\n\tb 1f\n\t.long ", name);
	      assemble_name (file, buf);
	      fputs ("-.\n1:", file);
	      asm_fprintf (file, "\tmflr %s\n", reg_names[11]);
	      asm_fprintf (file, "\taddi %s,%s,4\n",
			   reg_names[11], reg_names[11]);
	    }
	  else
	    {
	      fputs ("\tbcl 20,31,1f\n\t.long ", file);
	      assemble_name (file, buf);
	      fputs ("-.\n1:", file);
	      asm_fprintf (file, "\tmflr %s\n", reg_names[11]);
	    }
	  asm_fprintf (file, "\tlwz %s,0(%s)\n",
		       reg_names[0], reg_names[11]);
	  asm_fprintf (file, "\tadd %s,%s,%s\n",
		       reg_names[0], reg_names[0], reg_names[11]);
	}
      else
	{
	  asm_fprintf (file, "\tlis %s,", reg_names[12]);
	  assemble_name (file, buf);
	  fputs ("@ha\n", file);
	  asm_fprintf (file, "\tstw %s,4(%s)\n",
		       reg_names[0], reg_names[1]);
	  asm_fprintf (file, "\tla %s,", reg_names[0]);
	  assemble_name (file, buf);
	  asm_fprintf (file, "@l(%s)\n", reg_names[12]);
	}

      /* ABI_V4 saves the static chain reg with ASM_OUTPUT_REG_PUSH.  */
      fprintf (file, "\tbl %s%s\n",
	       RS6000_MCOUNT, flag_pic ? "@plt" : "");
      break;

    case ABI_AIX:
    case ABI_ELFv2:
    case ABI_DARWIN:
      /* Don't do anything, done in output_profile_hook ().  */
      break;
    }
}



/* The following variable value is the last issued insn.  */

static rtx_insn *last_scheduled_insn;

/* The following variable helps to balance issuing of load and
   store instructions */

static int load_store_pendulum;

/* The following variable helps pair divide insns during scheduling.  */
static int divide_cnt;
/* The following variable helps pair and alternate vector and vector load
   insns during scheduling.  */
static int vec_pairing;


/* Power4 load update and store update instructions are cracked into a
   load or store and an integer insn which are executed in the same cycle.
   Branches have their own dispatch slot which does not count against the
   GCC issue rate, but it changes the program flow so there are no other
   instructions to issue in this cycle.  */

static int
rs6000_variable_issue_1 (rtx_insn *insn, int more)
{
  last_scheduled_insn = insn;
  if (GET_CODE (PATTERN (insn)) == USE
      || GET_CODE (PATTERN (insn)) == CLOBBER)
    {
      cached_can_issue_more = more;
      return cached_can_issue_more;
    }

  if (insn_terminates_group_p (insn, current_group))
    {
      cached_can_issue_more = 0;
      return cached_can_issue_more;
    }

  /* If no reservation, but reach here */
  if (recog_memoized (insn) < 0)
    return more;

  if (rs6000_sched_groups)
    {
      if (is_microcoded_insn (insn))
        cached_can_issue_more = 0;
      else if (is_cracked_insn (insn))
        cached_can_issue_more = more > 2 ? more - 2 : 0;
      else
        cached_can_issue_more = more - 1;

      return cached_can_issue_more;
    }

  if (rs6000_tune == PROCESSOR_CELL && is_nonpipeline_insn (insn))
    return 0;

  cached_can_issue_more = more - 1;
  return cached_can_issue_more;
}

static int
rs6000_variable_issue (FILE *stream, int verbose, rtx_insn *insn, int more)
{
  int r = rs6000_variable_issue_1 (insn, more);
  if (verbose)
    fprintf (stream, "// rs6000_variable_issue (more = %d) = %d\n", more, r);
  return r;
}

/* Adjust the cost of a scheduling dependency.  Return the new cost of
   a dependency LINK or INSN on DEP_INSN.  COST is the current cost.  */

static int
rs6000_adjust_cost (rtx_insn *insn, int dep_type, rtx_insn *dep_insn, int cost,
		    unsigned int)
{
  enum attr_type attr_type;

  if (recog_memoized (insn) < 0 || recog_memoized (dep_insn) < 0)
    return cost;

  switch (dep_type)
    {
    case REG_DEP_TRUE:
      {
        /* Data dependency; DEP_INSN writes a register that INSN reads
	   some cycles later.  */

	/* Separate a load from a narrower, dependent store.  */
	if ((rs6000_sched_groups || rs6000_tune == PROCESSOR_POWER9
	     || rs6000_tune == PROCESSOR_FUTURE)
	    && GET_CODE (PATTERN (insn)) == SET
	    && GET_CODE (PATTERN (dep_insn)) == SET
	    && MEM_P (XEXP (PATTERN (insn), 1))
	    && MEM_P (XEXP (PATTERN (dep_insn), 0))
	    && (GET_MODE_SIZE (GET_MODE (XEXP (PATTERN (insn), 1)))
		> GET_MODE_SIZE (GET_MODE (XEXP (PATTERN (dep_insn), 0)))))
	  return cost + 14;

        attr_type = get_attr_type (insn);

        switch (attr_type)
          {
          case TYPE_JMPREG:
            /* Tell the first scheduling pass about the latency between
               a mtctr and bctr (and mtlr and br/blr).  The first
               scheduling pass will not know about this latency since
               the mtctr instruction, which has the latency associated
               to it, will be generated by reload.  */
            return 4;
          case TYPE_BRANCH:
            /* Leave some extra cycles between a compare and its
               dependent branch, to inhibit expensive mispredicts.  */
            if ((rs6000_tune == PROCESSOR_PPC603
                 || rs6000_tune == PROCESSOR_PPC604
                 || rs6000_tune == PROCESSOR_PPC604e
                 || rs6000_tune == PROCESSOR_PPC620
                 || rs6000_tune == PROCESSOR_PPC630
                 || rs6000_tune == PROCESSOR_PPC750
                 || rs6000_tune == PROCESSOR_PPC7400
                 || rs6000_tune == PROCESSOR_PPC7450
                 || rs6000_tune == PROCESSOR_PPCE5500
                 || rs6000_tune == PROCESSOR_PPCE6500
                 || rs6000_tune == PROCESSOR_POWER4
                 || rs6000_tune == PROCESSOR_POWER5
		 || rs6000_tune == PROCESSOR_POWER7
		 || rs6000_tune == PROCESSOR_POWER8
		 || rs6000_tune == PROCESSOR_POWER9
		 || rs6000_tune == PROCESSOR_FUTURE
                 || rs6000_tune == PROCESSOR_CELL)
                && recog_memoized (dep_insn)
                && (INSN_CODE (dep_insn) >= 0))

              switch (get_attr_type (dep_insn))
                {
                case TYPE_CMP:
                case TYPE_FPCOMPARE:
                case TYPE_CR_LOGICAL:
		  return cost + 2;
                case TYPE_EXTS:
                case TYPE_MUL:
		  if (get_attr_dot (dep_insn) == DOT_YES)
		    return cost + 2;
		  else
		    break;
                case TYPE_SHIFT:
		  if (get_attr_dot (dep_insn) == DOT_YES
		      && get_attr_var_shift (dep_insn) == VAR_SHIFT_NO)
		    return cost + 2;
		  else
		    break;
		default:
		  break;
		}
            break;

          case TYPE_STORE:
          case TYPE_FPSTORE:
            if ((rs6000_tune == PROCESSOR_POWER6)
                && recog_memoized (dep_insn)
                && (INSN_CODE (dep_insn) >= 0))
              {

                if (GET_CODE (PATTERN (insn)) != SET)
                  /* If this happens, we have to extend this to schedule
                     optimally.  Return default for now.  */
                  return cost;

                /* Adjust the cost for the case where the value written
                   by a fixed point operation is used as the address
                   gen value on a store. */
                switch (get_attr_type (dep_insn))
                  {
                  case TYPE_LOAD:
                  case TYPE_CNTLZ:
                    {
                      if (! rs6000_store_data_bypass_p (dep_insn, insn))
                        return get_attr_sign_extend (dep_insn)
                               == SIGN_EXTEND_YES ? 6 : 4;
                      break;
                    }
                  case TYPE_SHIFT:
                    {
                      if (! rs6000_store_data_bypass_p (dep_insn, insn))
                        return get_attr_var_shift (dep_insn) == VAR_SHIFT_YES ?
                               6 : 3;
                      break;
		    }
                  case TYPE_INTEGER:
                  case TYPE_ADD:
                  case TYPE_LOGICAL:
                  case TYPE_EXTS:
                  case TYPE_INSERT:
                    {
                      if (! rs6000_store_data_bypass_p (dep_insn, insn))
                        return 3;
                      break;
                    }
                  case TYPE_STORE:
                  case TYPE_FPLOAD:
                  case TYPE_FPSTORE:
                    {
                      if (get_attr_update (dep_insn) == UPDATE_YES
                          && ! rs6000_store_data_bypass_p (dep_insn, insn))
                        return 3;
                      break;
                    }
                  case TYPE_MUL:
                    {
                      if (! rs6000_store_data_bypass_p (dep_insn, insn))
                        return 17;
                      break;
                    }
                  case TYPE_DIV:
                    {
                      if (! rs6000_store_data_bypass_p (dep_insn, insn))
                        return get_attr_size (dep_insn) == SIZE_32 ? 45 : 57;
                      break;
                    }
                  default:
                    break;
                  }
              }
	    break;

          case TYPE_LOAD:
            if ((rs6000_tune == PROCESSOR_POWER6)
                && recog_memoized (dep_insn)
                && (INSN_CODE (dep_insn) >= 0))
              {

                /* Adjust the cost for the case where the value written
                   by a fixed point instruction is used within the address
                   gen portion of a subsequent load(u)(x) */
                switch (get_attr_type (dep_insn))
                  {
                  case TYPE_LOAD:
                  case TYPE_CNTLZ:
                    {
                      if (set_to_load_agen (dep_insn, insn))
                        return get_attr_sign_extend (dep_insn)
                               == SIGN_EXTEND_YES ? 6 : 4;
                      break;
                    }
                  case TYPE_SHIFT:
                    {
                      if (set_to_load_agen (dep_insn, insn))
                        return get_attr_var_shift (dep_insn) == VAR_SHIFT_YES ?
                               6 : 3;
                      break;
		    }
                  case TYPE_INTEGER:
                  case TYPE_ADD:
                  case TYPE_LOGICAL:
                  case TYPE_EXTS:
                  case TYPE_INSERT:
                    {
                      if (set_to_load_agen (dep_insn, insn))
                        return 3;
                      break;
                    }
                  case TYPE_STORE:
                  case TYPE_FPLOAD:
                  case TYPE_FPSTORE:
                    {
                      if (get_attr_update (dep_insn) == UPDATE_YES
                          && set_to_load_agen (dep_insn, insn))
                        return 3;
                      break;
                    }
                  case TYPE_MUL:
                    {
                      if (set_to_load_agen (dep_insn, insn))
                        return 17;
                      break;
                    }
                  case TYPE_DIV:
                    {
                      if (set_to_load_agen (dep_insn, insn))
                        return get_attr_size (dep_insn) == SIZE_32 ? 45 : 57;
                      break;
                    }
                  default:
                    break;
                  }
              }
            break;

          case TYPE_FPLOAD:
            if ((rs6000_tune == PROCESSOR_POWER6)
                && get_attr_update (insn) == UPDATE_NO
                && recog_memoized (dep_insn)
                && (INSN_CODE (dep_insn) >= 0)
                && (get_attr_type (dep_insn) == TYPE_MFFGPR))
              return 2;

          default:
            break;
          }

	/* Fall out to return default cost.  */
      }
      break;

    case REG_DEP_OUTPUT:
      /* Output dependency; DEP_INSN writes a register that INSN writes some
	 cycles later.  */
      if ((rs6000_tune == PROCESSOR_POWER6)
          && recog_memoized (dep_insn)
          && (INSN_CODE (dep_insn) >= 0))
        {
          attr_type = get_attr_type (insn);

          switch (attr_type)
            {
            case TYPE_FP:
            case TYPE_FPSIMPLE:
              if (get_attr_type (dep_insn) == TYPE_FP
		  || get_attr_type (dep_insn) == TYPE_FPSIMPLE)
                return 1;
              break;
            case TYPE_FPLOAD:
              if (get_attr_update (insn) == UPDATE_NO
                  && get_attr_type (dep_insn) == TYPE_MFFGPR)
                return 2;
              break;
            default:
              break;
            }
        }
      /* Fall through, no cost for output dependency.  */
      /* FALLTHRU */

    case REG_DEP_ANTI:
      /* Anti dependency; DEP_INSN reads a register that INSN writes some
	 cycles later.  */
      return 0;

    default:
      gcc_unreachable ();
    }

  return cost;
}

/* Debug version of rs6000_adjust_cost.  */

static int
rs6000_debug_adjust_cost (rtx_insn *insn, int dep_type, rtx_insn *dep_insn,
			  int cost, unsigned int dw)
{
  int ret = rs6000_adjust_cost (insn, dep_type, dep_insn, cost, dw);

  if (ret != cost)
    {
      const char *dep;

      switch (dep_type)
	{
	default:	     dep = "unknown depencency"; break;
	case REG_DEP_TRUE:   dep = "data dependency";	 break;
	case REG_DEP_OUTPUT: dep = "output dependency";  break;
	case REG_DEP_ANTI:   dep = "anti depencency";	 break;
	}

      fprintf (stderr,
	       "\nrs6000_adjust_cost, final cost = %d, orig cost = %d, "
	       "%s, insn:\n", ret, cost, dep);

      debug_rtx (insn);
    }

  return ret;
}

/* The function returns a true if INSN is microcoded.
   Return false otherwise.  */

static bool
is_microcoded_insn (rtx_insn *insn)
{
  if (!insn || !NONDEBUG_INSN_P (insn)
      || GET_CODE (PATTERN (insn)) == USE
      || GET_CODE (PATTERN (insn)) == CLOBBER)
    return false;

  if (rs6000_tune == PROCESSOR_CELL)
    return get_attr_cell_micro (insn) == CELL_MICRO_ALWAYS;

  if (rs6000_sched_groups
      && (rs6000_tune == PROCESSOR_POWER4 || rs6000_tune == PROCESSOR_POWER5))
    {
      enum attr_type type = get_attr_type (insn);
      if ((type == TYPE_LOAD
	   && get_attr_update (insn) == UPDATE_YES
	   && get_attr_sign_extend (insn) == SIGN_EXTEND_YES)
	  || ((type == TYPE_LOAD || type == TYPE_STORE)
	      && get_attr_update (insn) == UPDATE_YES
	      && get_attr_indexed (insn) == INDEXED_YES)
	  || type == TYPE_MFCR)
	return true;
    }

  return false;
}

/* The function returns true if INSN is cracked into 2 instructions
   by the processor (and therefore occupies 2 issue slots).  */

static bool
is_cracked_insn (rtx_insn *insn)
{
  if (!insn || !NONDEBUG_INSN_P (insn)
      || GET_CODE (PATTERN (insn)) == USE
      || GET_CODE (PATTERN (insn)) == CLOBBER)
    return false;

  if (rs6000_sched_groups
      && (rs6000_tune == PROCESSOR_POWER4 || rs6000_tune == PROCESSOR_POWER5))
    {
      enum attr_type type = get_attr_type (insn);
      if ((type == TYPE_LOAD
	   && get_attr_sign_extend (insn) == SIGN_EXTEND_YES
	   && get_attr_update (insn) == UPDATE_NO)
	  || (type == TYPE_LOAD
	      && get_attr_sign_extend (insn) == SIGN_EXTEND_NO
	      && get_attr_update (insn) == UPDATE_YES
	      && get_attr_indexed (insn) == INDEXED_NO)
	  || (type == TYPE_STORE
	      && get_attr_update (insn) == UPDATE_YES
	      && get_attr_indexed (insn) == INDEXED_NO)
	  || ((type == TYPE_FPLOAD || type == TYPE_FPSTORE)
	      && get_attr_update (insn) == UPDATE_YES)
	  || (type == TYPE_CR_LOGICAL
	      && get_attr_cr_logical_3op (insn) == CR_LOGICAL_3OP_YES)
	  || (type == TYPE_EXTS
	      && get_attr_dot (insn) == DOT_YES)
	  || (type == TYPE_SHIFT
	      && get_attr_dot (insn) == DOT_YES
	      && get_attr_var_shift (insn) == VAR_SHIFT_NO)
	  || (type == TYPE_MUL
	      && get_attr_dot (insn) == DOT_YES)
	  || type == TYPE_DIV
	  || (type == TYPE_INSERT
	      && get_attr_size (insn) == SIZE_32))
	return true;
    }

  return false;
}

/* The function returns true if INSN can be issued only from
   the branch slot.  */

static bool
is_branch_slot_insn (rtx_insn *insn)
{
  if (!insn || !NONDEBUG_INSN_P (insn)
      || GET_CODE (PATTERN (insn)) == USE
      || GET_CODE (PATTERN (insn)) == CLOBBER)
    return false;

  if (rs6000_sched_groups)
    {
      enum attr_type type = get_attr_type (insn);
      if (type == TYPE_BRANCH || type == TYPE_JMPREG)
	return true;
      return false;
    }

  return false;
}

/* The function returns true if out_inst sets a value that is
   used in the address generation computation of in_insn */
static bool
set_to_load_agen (rtx_insn *out_insn, rtx_insn *in_insn)
{
  rtx out_set, in_set;

  /* For performance reasons, only handle the simple case where
     both loads are a single_set. */
  out_set = single_set (out_insn);
  if (out_set)
    {
      in_set = single_set (in_insn);
      if (in_set)
        return reg_mentioned_p (SET_DEST (out_set), SET_SRC (in_set));
    }

  return false;
}

/* Try to determine base/offset/size parts of the given MEM.
   Return true if successful, false if all the values couldn't
   be determined.

   This function only looks for REG or REG+CONST address forms.
   REG+REG address form will return false. */

static bool
get_memref_parts (rtx mem, rtx *base, HOST_WIDE_INT *offset,
		  HOST_WIDE_INT *size)
{
  rtx addr_rtx;
  if MEM_SIZE_KNOWN_P (mem)
    *size = MEM_SIZE (mem);
  else
    return false;

  addr_rtx = (XEXP (mem, 0));
  if (GET_CODE (addr_rtx) == PRE_MODIFY)
    addr_rtx = XEXP (addr_rtx, 1);

  *offset = 0;
  while (GET_CODE (addr_rtx) == PLUS
	 && CONST_INT_P (XEXP (addr_rtx, 1)))
    {
      *offset += INTVAL (XEXP (addr_rtx, 1));
      addr_rtx = XEXP (addr_rtx, 0);
    }
  if (!REG_P (addr_rtx))
    return false;

  *base = addr_rtx;
  return true;
}

/* The function returns true if the target storage location of
   mem1 is adjacent to the target storage location of mem2 */
/* Return 1 if memory locations are adjacent.  */

static bool
adjacent_mem_locations (rtx mem1, rtx mem2)
{
  rtx reg1, reg2;
  HOST_WIDE_INT off1, size1, off2, size2;

  if (get_memref_parts (mem1, &reg1, &off1, &size1)
      && get_memref_parts (mem2, &reg2, &off2, &size2))
    return ((REGNO (reg1) == REGNO (reg2))
	    && ((off1 + size1 == off2)
		|| (off2 + size2 == off1)));

  return false;
}

/* This function returns true if it can be determined that the two MEM
   locations overlap by at least 1 byte based on base reg/offset/size. */

static bool
mem_locations_overlap (rtx mem1, rtx mem2)
{
  rtx reg1, reg2;
  HOST_WIDE_INT off1, size1, off2, size2;

  if (get_memref_parts (mem1, &reg1, &off1, &size1)
      && get_memref_parts (mem2, &reg2, &off2, &size2))
    return ((REGNO (reg1) == REGNO (reg2))
	    && (((off1 <= off2) && (off1 + size1 > off2))
		|| ((off2 <= off1) && (off2 + size2 > off1))));

  return false;
}

/* A C statement (sans semicolon) to update the integer scheduling
   priority INSN_PRIORITY (INSN). Increase the priority to execute the
   INSN earlier, reduce the priority to execute INSN later.  Do not
   define this macro if you do not need to adjust the scheduling
   priorities of insns.  */

static int
rs6000_adjust_priority (rtx_insn *insn ATTRIBUTE_UNUSED, int priority)
{
  rtx load_mem, str_mem;
  /* On machines (like the 750) which have asymmetric integer units,
     where one integer unit can do multiply and divides and the other
     can't, reduce the priority of multiply/divide so it is scheduled
     before other integer operations.  */

#if 0
  if (! INSN_P (insn))
    return priority;

  if (GET_CODE (PATTERN (insn)) == USE)
    return priority;

  switch (rs6000_tune) {
  case PROCESSOR_PPC750:
    switch (get_attr_type (insn))
      {
      default:
	break;

      case TYPE_MUL:
      case TYPE_DIV:
	fprintf (stderr, "priority was %#x (%d) before adjustment\n",
		 priority, priority);
	if (priority >= 0 && priority < 0x01000000)
	  priority >>= 3;
	break;
      }
  }
#endif

  if (insn_must_be_first_in_group (insn)
      && reload_completed
      && current_sched_info->sched_max_insns_priority
      && rs6000_sched_restricted_insns_priority)
    {

      /* Prioritize insns that can be dispatched only in the first
	 dispatch slot.  */
      if (rs6000_sched_restricted_insns_priority == 1)
	/* Attach highest priority to insn. This means that in
	   haifa-sched.c:ready_sort(), dispatch-slot restriction considerations
	   precede 'priority' (critical path) considerations.  */
	return current_sched_info->sched_max_insns_priority;
      else if (rs6000_sched_restricted_insns_priority == 2)
	/* Increase priority of insn by a minimal amount. This means that in
	   haifa-sched.c:ready_sort(), only 'priority' (critical path)
	   considerations precede dispatch-slot restriction considerations.  */
	return (priority + 1);
    }

  if (rs6000_tune == PROCESSOR_POWER6
      && ((load_store_pendulum == -2 && is_load_insn (insn, &load_mem))
          || (load_store_pendulum == 2 && is_store_insn (insn, &str_mem))))
    /* Attach highest priority to insn if the scheduler has just issued two
       stores and this instruction is a load, or two loads and this instruction
       is a store. Power6 wants loads and stores scheduled alternately
       when possible */
    return current_sched_info->sched_max_insns_priority;

  return priority;
}

/* Return true if the instruction is nonpipelined on the Cell. */
static bool
is_nonpipeline_insn (rtx_insn *insn)
{
  enum attr_type type;
  if (!insn || !NONDEBUG_INSN_P (insn)
      || GET_CODE (PATTERN (insn)) == USE
      || GET_CODE (PATTERN (insn)) == CLOBBER)
    return false;

  type = get_attr_type (insn);
  if (type == TYPE_MUL
      || type == TYPE_DIV
      || type == TYPE_SDIV
      || type == TYPE_DDIV
      || type == TYPE_SSQRT
      || type == TYPE_DSQRT
      || type == TYPE_MFCR
      || type == TYPE_MFCRF
      || type == TYPE_MFJMPR)
    {
      return true;
    }
  return false;
}


/* Return how many instructions the machine can issue per cycle.  */

static int
rs6000_issue_rate (void)
{
  /* Unless scheduling for register pressure, use issue rate of 1 for
     first scheduling pass to decrease degradation.  */
  if (!reload_completed && !flag_sched_pressure)
    return 1;

  switch (rs6000_tune) {
  case PROCESSOR_RS64A:
  case PROCESSOR_PPC601: /* ? */
  case PROCESSOR_PPC7450:
    return 3;
  case PROCESSOR_PPC440:
  case PROCESSOR_PPC603:
  case PROCESSOR_PPC750:
  case PROCESSOR_PPC7400:
  case PROCESSOR_PPC8540:
  case PROCESSOR_PPC8548:
  case PROCESSOR_CELL:
  case PROCESSOR_PPCE300C2:
  case PROCESSOR_PPCE300C3:
  case PROCESSOR_PPCE500MC:
  case PROCESSOR_PPCE500MC64:
  case PROCESSOR_PPCE5500:
  case PROCESSOR_PPCE6500:
  case PROCESSOR_TITAN:
    return 2;
  case PROCESSOR_PPC476:
  case PROCESSOR_PPC604:
  case PROCESSOR_PPC604e:
  case PROCESSOR_PPC620:
  case PROCESSOR_PPC630:
    return 4;
  case PROCESSOR_POWER4:
  case PROCESSOR_POWER5:
  case PROCESSOR_POWER6:
  case PROCESSOR_POWER7:
    return 5;
  case PROCESSOR_POWER8:
    return 7;
  case PROCESSOR_POWER9:
  case PROCESSOR_FUTURE:
    return 6;
  default:
    return 1;
  }
}

/* Return how many instructions to look ahead for better insn
   scheduling.  */

static int
rs6000_use_sched_lookahead (void)
{
  switch (rs6000_tune)
    {
    case PROCESSOR_PPC8540:
    case PROCESSOR_PPC8548:
      return 4;

    case PROCESSOR_CELL:
      return (reload_completed ? 8 : 0);

    default:
      return 0;
    }
}

/* We are choosing insn from the ready queue.  Return zero if INSN can be
   chosen.  */
static int
rs6000_use_sched_lookahead_guard (rtx_insn *insn, int ready_index)
{
  if (ready_index == 0)
    return 0;

  if (rs6000_tune != PROCESSOR_CELL)
    return 0;

  gcc_assert (insn != NULL_RTX && INSN_P (insn));

  if (!reload_completed
      || is_nonpipeline_insn (insn)
      || is_microcoded_insn (insn))
    return 1;

  return 0;
}

/* Determine if PAT refers to memory. If so, set MEM_REF to the MEM rtx
   and return true.  */

static bool
find_mem_ref (rtx pat, rtx *mem_ref)
{
  const char * fmt;
  int i, j;

  /* stack_tie does not produce any real memory traffic.  */
  if (tie_operand (pat, VOIDmode))
    return false;

  if (MEM_P (pat))
    {
      *mem_ref = pat;
      return true;
    }

  /* Recursively process the pattern.  */
  fmt = GET_RTX_FORMAT (GET_CODE (pat));

  for (i = GET_RTX_LENGTH (GET_CODE (pat)) - 1; i >= 0; i--)
    {
      if (fmt[i] == 'e')
	{
	  if (find_mem_ref (XEXP (pat, i), mem_ref))
	    return true;
	}
      else if (fmt[i] == 'E')
	for (j = XVECLEN (pat, i) - 1; j >= 0; j--)
	  {
	    if (find_mem_ref (XVECEXP (pat, i, j), mem_ref))
	      return true;
	  }
    }

  return false;
}

/* Determine if PAT is a PATTERN of a load insn.  */

static bool
is_load_insn1 (rtx pat, rtx *load_mem)
{
  if (!pat || pat == NULL_RTX)
    return false;

  if (GET_CODE (pat) == SET)
    return find_mem_ref (SET_SRC (pat), load_mem);

  if (GET_CODE (pat) == PARALLEL)
    {
      int i;

      for (i = 0; i < XVECLEN (pat, 0); i++)
	if (is_load_insn1 (XVECEXP (pat, 0, i), load_mem))
	  return true;
    }

  return false;
}

/* Determine if INSN loads from memory.  */

static bool
is_load_insn (rtx insn, rtx *load_mem)
{
  if (!insn || !INSN_P (insn))
    return false;

  if (CALL_P (insn))
    return false;

  return is_load_insn1 (PATTERN (insn), load_mem);
}

/* Determine if PAT is a PATTERN of a store insn.  */

static bool
is_store_insn1 (rtx pat, rtx *str_mem)
{
  if (!pat || pat == NULL_RTX)
    return false;

  if (GET_CODE (pat) == SET)
    return find_mem_ref (SET_DEST (pat), str_mem);

  if (GET_CODE (pat) == PARALLEL)
    {
      int i;

      for (i = 0; i < XVECLEN (pat, 0); i++)
	if (is_store_insn1 (XVECEXP (pat, 0, i), str_mem))
	  return true;
    }

  return false;
}

/* Determine if INSN stores to memory.  */

static bool
is_store_insn (rtx insn, rtx *str_mem)
{
  if (!insn || !INSN_P (insn))
    return false;

  return is_store_insn1 (PATTERN (insn), str_mem);
}

/* Return whether TYPE is a Power9 pairable vector instruction type.  */

static bool
is_power9_pairable_vec_type (enum attr_type type)
{
  switch (type)
    {
      case TYPE_VECSIMPLE:
      case TYPE_VECCOMPLEX:
      case TYPE_VECDIV:
      case TYPE_VECCMP:
      case TYPE_VECPERM:
      case TYPE_VECFLOAT:
      case TYPE_VECFDIV:
      case TYPE_VECDOUBLE:
	return true;
      default:
	break;
    }
  return false;
}

/* Returns whether the dependence between INSN and NEXT is considered
   costly by the given target.  */

static bool
rs6000_is_costly_dependence (dep_t dep, int cost, int distance)
{
  rtx insn;
  rtx next;
  rtx load_mem, str_mem;

  /* If the flag is not enabled - no dependence is considered costly;
     allow all dependent insns in the same group.
     This is the most aggressive option.  */
  if (rs6000_sched_costly_dep == no_dep_costly)
    return false;

  /* If the flag is set to 1 - a dependence is always considered costly;
     do not allow dependent instructions in the same group.
     This is the most conservative option.  */
  if (rs6000_sched_costly_dep == all_deps_costly)
    return true;

  insn = DEP_PRO (dep);
  next = DEP_CON (dep);

  if (rs6000_sched_costly_dep == store_to_load_dep_costly
      && is_load_insn (next, &load_mem)
      && is_store_insn (insn, &str_mem))
    /* Prevent load after store in the same group.  */
    return true;

  if (rs6000_sched_costly_dep == true_store_to_load_dep_costly
      && is_load_insn (next, &load_mem)
      && is_store_insn (insn, &str_mem)
      && DEP_TYPE (dep) == REG_DEP_TRUE
      && mem_locations_overlap(str_mem, load_mem))
     /* Prevent load after store in the same group if it is a true
	dependence.  */
     return true;

  /* The flag is set to X; dependences with latency >= X are considered costly,
     and will not be scheduled in the same group.  */
  if (rs6000_sched_costly_dep <= max_dep_latency
      && ((cost - distance) >= (int)rs6000_sched_costly_dep))
    return true;

  return false;
}

/* Return the next insn after INSN that is found before TAIL is reached,
   skipping any "non-active" insns - insns that will not actually occupy
   an issue slot.  Return NULL_RTX if such an insn is not found.  */

static rtx_insn *
get_next_active_insn (rtx_insn *insn, rtx_insn *tail)
{
  if (insn == NULL_RTX || insn == tail)
    return NULL;

  while (1)
    {
      insn = NEXT_INSN (insn);
      if (insn == NULL_RTX || insn == tail)
	return NULL;

      if (CALL_P (insn)
	  || JUMP_P (insn) || JUMP_TABLE_DATA_P (insn)
	  || (NONJUMP_INSN_P (insn)
	      && GET_CODE (PATTERN (insn)) != USE
	      && GET_CODE (PATTERN (insn)) != CLOBBER
	      && INSN_CODE (insn) != CODE_FOR_stack_tie))
	break;
    }
  return insn;
}

/* Do Power9 specific sched_reorder2 reordering of ready list.  */

static int
power9_sched_reorder2 (rtx_insn **ready, int lastpos)
{
  int pos;
  int i;
  rtx_insn *tmp;
  enum attr_type type, type2;

  type = get_attr_type (last_scheduled_insn);

  /* Try to issue fixed point divides back-to-back in pairs so they will be
     routed to separate execution units and execute in parallel.  */
  if (type == TYPE_DIV && divide_cnt == 0)
    {
      /* First divide has been scheduled.  */
      divide_cnt = 1;

      /* Scan the ready list looking for another divide, if found move it
	 to the end of the list so it is chosen next.  */
      pos = lastpos;
      while (pos >= 0)
	{
	  if (recog_memoized (ready[pos]) >= 0
	      && get_attr_type (ready[pos]) == TYPE_DIV)
	    {
	      tmp = ready[pos];
	      for (i = pos; i < lastpos; i++)
		ready[i] = ready[i + 1];
	      ready[lastpos] = tmp;
	      break;
	    }
	  pos--;
	}
    }
  else
    {
      /* Last insn was the 2nd divide or not a divide, reset the counter.  */
      divide_cnt = 0;

      /* The best dispatch throughput for vector and vector load insns can be
	 achieved by interleaving a vector and vector load such that they'll
	 dispatch to the same superslice. If this pairing cannot be achieved
	 then it is best to pair vector insns together and vector load insns
	 together.

	 To aid in this pairing, vec_pairing maintains the current state with
	 the following values:

	     0  : Initial state, no vecload/vector pairing has been started.

	     1  : A vecload or vector insn has been issued and a candidate for
		  pairing has been found and moved to the end of the ready
		  list.  */
      if (type == TYPE_VECLOAD)
	{
	  /* Issued a vecload.  */
	  if (vec_pairing == 0)
	    {
	      int vecload_pos = -1;
	      /* We issued a single vecload, look for a vector insn to pair it
		 with.  If one isn't found, try to pair another vecload.  */
	      pos = lastpos;
	      while (pos >= 0)
		{
		  if (recog_memoized (ready[pos]) >= 0)
		    {
		      type2 = get_attr_type (ready[pos]);
		      if (is_power9_pairable_vec_type (type2))
			{
			  /* Found a vector insn to pair with, move it to the
			     end of the ready list so it is scheduled next.  */
			  tmp = ready[pos];
			  for (i = pos; i < lastpos; i++)
			    ready[i] = ready[i + 1];
			  ready[lastpos] = tmp;
			  vec_pairing = 1;
			  return cached_can_issue_more;
			}
		      else if (type2 == TYPE_VECLOAD && vecload_pos == -1)
			/* Remember position of first vecload seen.  */
			vecload_pos = pos;
		    }
		  pos--;
		}
	      if (vecload_pos >= 0)
		{
		  /* Didn't find a vector to pair with but did find a vecload,
		     move it to the end of the ready list.  */
		  tmp = ready[vecload_pos];
		  for (i = vecload_pos; i < lastpos; i++)
		    ready[i] = ready[i + 1];
		  ready[lastpos] = tmp;
		  vec_pairing = 1;
		  return cached_can_issue_more;
		}
	    }
	}
      else if (is_power9_pairable_vec_type (type))
	{
	  /* Issued a vector operation.  */
	  if (vec_pairing == 0)
	    {
	      int vec_pos = -1;
	      /* We issued a single vector insn, look for a vecload to pair it
		 with.  If one isn't found, try to pair another vector.  */
	      pos = lastpos;
	      while (pos >= 0)
		{
		  if (recog_memoized (ready[pos]) >= 0)
		    {
		      type2 = get_attr_type (ready[pos]);
		      if (type2 == TYPE_VECLOAD)
			{
			  /* Found a vecload insn to pair with, move it to the
			     end of the ready list so it is scheduled next.  */
			  tmp = ready[pos];
			  for (i = pos; i < lastpos; i++)
			    ready[i] = ready[i + 1];
			  ready[lastpos] = tmp;
			  vec_pairing = 1;
			  return cached_can_issue_more;
			}
		      else if (is_power9_pairable_vec_type (type2)
			       && vec_pos == -1)
			/* Remember position of first vector insn seen.  */
			vec_pos = pos;
		    }
		  pos--;
		}
	      if (vec_pos >= 0)
		{
		  /* Didn't find a vecload to pair with but did find a vector
		     insn, move it to the end of the ready list.  */
		  tmp = ready[vec_pos];
		  for (i = vec_pos; i < lastpos; i++)
		    ready[i] = ready[i + 1];
		  ready[lastpos] = tmp;
		  vec_pairing = 1;
		  return cached_can_issue_more;
		}
	    }
	}

      /* We've either finished a vec/vecload pair, couldn't find an insn to
	 continue the current pair, or the last insn had nothing to do with
	 with pairing.  In any case, reset the state.  */
      vec_pairing = 0;
    }

  return cached_can_issue_more;
}

/* We are about to begin issuing insns for this clock cycle. */

static int
rs6000_sched_reorder (FILE *dump ATTRIBUTE_UNUSED, int sched_verbose,
                        rtx_insn **ready ATTRIBUTE_UNUSED,
                        int *pn_ready ATTRIBUTE_UNUSED,
		        int clock_var ATTRIBUTE_UNUSED)
{
  int n_ready = *pn_ready;

  if (sched_verbose)
    fprintf (dump, "// rs6000_sched_reorder :\n");

  /* Reorder the ready list, if the second to last ready insn
     is a nonepipeline insn.  */
  if (rs6000_tune == PROCESSOR_CELL && n_ready > 1)
  {
    if (is_nonpipeline_insn (ready[n_ready - 1])
        && (recog_memoized (ready[n_ready - 2]) > 0))
      /* Simply swap first two insns.  */
      std::swap (ready[n_ready - 1], ready[n_ready - 2]);
  }

  if (rs6000_tune == PROCESSOR_POWER6)
    load_store_pendulum = 0;

  return rs6000_issue_rate ();
}

/* Like rs6000_sched_reorder, but called after issuing each insn.  */

static int
rs6000_sched_reorder2 (FILE *dump, int sched_verbose, rtx_insn **ready,
		         int *pn_ready, int clock_var ATTRIBUTE_UNUSED)
{
  if (sched_verbose)
    fprintf (dump, "// rs6000_sched_reorder2 :\n");

  /* For Power6, we need to handle some special cases to try and keep the
     store queue from overflowing and triggering expensive flushes.

     This code monitors how load and store instructions are being issued
     and skews the ready list one way or the other to increase the likelihood
     that a desired instruction is issued at the proper time.

     A couple of things are done.  First, we maintain a "load_store_pendulum"
     to track the current state of load/store issue.

       - If the pendulum is at zero, then no loads or stores have been
         issued in the current cycle so we do nothing.

       - If the pendulum is 1, then a single load has been issued in this
         cycle and we attempt to locate another load in the ready list to
         issue with it.

       - If the pendulum is -2, then two stores have already been
         issued in this cycle, so we increase the priority of the first load
         in the ready list to increase it's likelihood of being chosen first
         in the next cycle.

       - If the pendulum is -1, then a single store has been issued in this
         cycle and we attempt to locate another store in the ready list to
         issue with it, preferring a store to an adjacent memory location to
         facilitate store pairing in the store queue.

       - If the pendulum is 2, then two loads have already been
         issued in this cycle, so we increase the priority of the first store
         in the ready list to increase it's likelihood of being chosen first
         in the next cycle.

       - If the pendulum < -2 or > 2, then do nothing.

       Note: This code covers the most common scenarios.  There exist non
             load/store instructions which make use of the LSU and which
             would need to be accounted for to strictly model the behavior
             of the machine.  Those instructions are currently unaccounted
             for to help minimize compile time overhead of this code.
   */
  if (rs6000_tune == PROCESSOR_POWER6 && last_scheduled_insn)
    {
      int pos;
      int i;
      rtx_insn *tmp;
      rtx load_mem, str_mem;

      if (is_store_insn (last_scheduled_insn, &str_mem))
        /* Issuing a store, swing the load_store_pendulum to the left */
        load_store_pendulum--;
      else if (is_load_insn (last_scheduled_insn, &load_mem))
        /* Issuing a load, swing the load_store_pendulum to the right */
        load_store_pendulum++;
      else
        return cached_can_issue_more;

      /* If the pendulum is balanced, or there is only one instruction on
         the ready list, then all is well, so return. */
      if ((load_store_pendulum == 0) || (*pn_ready <= 1))
        return cached_can_issue_more;

      if (load_store_pendulum == 1)
        {
          /* A load has been issued in this cycle.  Scan the ready list
             for another load to issue with it */
          pos = *pn_ready-1;

          while (pos >= 0)
            {
              if (is_load_insn (ready[pos], &load_mem))
                {
                  /* Found a load.  Move it to the head of the ready list,
                     and adjust it's priority so that it is more likely to
                     stay there */
                  tmp = ready[pos];
                  for (i=pos; i<*pn_ready-1; i++)
                    ready[i] = ready[i + 1];
                  ready[*pn_ready-1] = tmp;

                  if (!sel_sched_p () && INSN_PRIORITY_KNOWN (tmp))
                    INSN_PRIORITY (tmp)++;
                  break;
                }
              pos--;
            }
        }
      else if (load_store_pendulum == -2)
        {
          /* Two stores have been issued in this cycle.  Increase the
             priority of the first load in the ready list to favor it for
             issuing in the next cycle. */
          pos = *pn_ready-1;

          while (pos >= 0)
            {
              if (is_load_insn (ready[pos], &load_mem)
                  && !sel_sched_p ()
		  && INSN_PRIORITY_KNOWN (ready[pos]))
                {
                  INSN_PRIORITY (ready[pos])++;

                  /* Adjust the pendulum to account for the fact that a load
                     was found and increased in priority.  This is to prevent
                     increasing the priority of multiple loads */
                  load_store_pendulum--;

                  break;
                }
              pos--;
            }
        }
      else if (load_store_pendulum == -1)
        {
          /* A store has been issued in this cycle.  Scan the ready list for
             another store to issue with it, preferring a store to an adjacent
             memory location */
          int first_store_pos = -1;

          pos = *pn_ready-1;

          while (pos >= 0)
            {
              if (is_store_insn (ready[pos], &str_mem))
                {
		  rtx str_mem2;
                  /* Maintain the index of the first store found on the
                     list */
                  if (first_store_pos == -1)
                    first_store_pos = pos;

                  if (is_store_insn (last_scheduled_insn, &str_mem2)
                      && adjacent_mem_locations (str_mem, str_mem2))
                    {
                      /* Found an adjacent store.  Move it to the head of the
                         ready list, and adjust it's priority so that it is
                         more likely to stay there */
                      tmp = ready[pos];
                      for (i=pos; i<*pn_ready-1; i++)
                        ready[i] = ready[i + 1];
                      ready[*pn_ready-1] = tmp;

                      if (!sel_sched_p () && INSN_PRIORITY_KNOWN (tmp))
                        INSN_PRIORITY (tmp)++;

                      first_store_pos = -1;

                      break;
                    };
                }
              pos--;
            }

          if (first_store_pos >= 0)
            {
              /* An adjacent store wasn't found, but a non-adjacent store was,
                 so move the non-adjacent store to the front of the ready
                 list, and adjust its priority so that it is more likely to
                 stay there. */
              tmp = ready[first_store_pos];
              for (i=first_store_pos; i<*pn_ready-1; i++)
                ready[i] = ready[i + 1];
              ready[*pn_ready-1] = tmp;
              if (!sel_sched_p () && INSN_PRIORITY_KNOWN (tmp))
                INSN_PRIORITY (tmp)++;
            }
        }
      else if (load_store_pendulum == 2)
       {
           /* Two loads have been issued in this cycle.  Increase the priority
              of the first store in the ready list to favor it for issuing in
              the next cycle. */
          pos = *pn_ready-1;

          while (pos >= 0)
            {
              if (is_store_insn (ready[pos], &str_mem)
                  && !sel_sched_p ()
		  && INSN_PRIORITY_KNOWN (ready[pos]))
                {
                  INSN_PRIORITY (ready[pos])++;

                  /* Adjust the pendulum to account for the fact that a store
                     was found and increased in priority.  This is to prevent
                     increasing the priority of multiple stores */
                  load_store_pendulum++;

                  break;
                }
              pos--;
            }
        }
    }

  /* Do Power9 dependent reordering if necessary.  */
  if (rs6000_tune == PROCESSOR_POWER9 && last_scheduled_insn
      && recog_memoized (last_scheduled_insn) >= 0)
    return power9_sched_reorder2 (ready, *pn_ready - 1);

  return cached_can_issue_more;
}

/* Return whether the presence of INSN causes a dispatch group termination
   of group WHICH_GROUP.

   If WHICH_GROUP == current_group, this function will return true if INSN
   causes the termination of the current group (i.e, the dispatch group to
   which INSN belongs). This means that INSN will be the last insn in the
   group it belongs to.

   If WHICH_GROUP == previous_group, this function will return true if INSN
   causes the termination of the previous group (i.e, the dispatch group that
   precedes the group to which INSN belongs).  This means that INSN will be
   the first insn in the group it belongs to).  */

static bool
insn_terminates_group_p (rtx_insn *insn, enum group_termination which_group)
{
  bool first, last;

  if (! insn)
    return false;

  first = insn_must_be_first_in_group (insn);
  last = insn_must_be_last_in_group (insn);

  if (first && last)
    return true;

  if (which_group == current_group)
    return last;
  else if (which_group == previous_group)
    return first;

  return false;
}


static bool
insn_must_be_first_in_group (rtx_insn *insn)
{
  enum attr_type type;

  if (!insn
      || NOTE_P (insn)
      || DEBUG_INSN_P (insn)
      || GET_CODE (PATTERN (insn)) == USE
      || GET_CODE (PATTERN (insn)) == CLOBBER)
    return false;

  switch (rs6000_tune)
    {
    case PROCESSOR_POWER5:
      if (is_cracked_insn (insn))
        return true;
      /* FALLTHRU */
    case PROCESSOR_POWER4:
      if (is_microcoded_insn (insn))
        return true;

      if (!rs6000_sched_groups)
        return false;

      type = get_attr_type (insn);

      switch (type)
        {
        case TYPE_MFCR:
        case TYPE_MFCRF:
        case TYPE_MTCR:
        case TYPE_CR_LOGICAL:
        case TYPE_MTJMPR:
        case TYPE_MFJMPR:
        case TYPE_DIV:
        case TYPE_LOAD_L:
        case TYPE_STORE_C:
        case TYPE_ISYNC:
        case TYPE_SYNC:
          return true;
        default:
          break;
        }
      break;
    case PROCESSOR_POWER6:
      type = get_attr_type (insn);

      switch (type)
        {
        case TYPE_EXTS:
        case TYPE_CNTLZ:
        case TYPE_TRAP:
        case TYPE_MUL:
        case TYPE_INSERT:
        case TYPE_FPCOMPARE:
        case TYPE_MFCR:
        case TYPE_MTCR:
        case TYPE_MFJMPR:
        case TYPE_MTJMPR:
        case TYPE_ISYNC:
        case TYPE_SYNC:
        case TYPE_LOAD_L:
        case TYPE_STORE_C:
          return true;
        case TYPE_SHIFT:
          if (get_attr_dot (insn) == DOT_NO
              || get_attr_var_shift (insn) == VAR_SHIFT_NO)
            return true;
          else
            break;
        case TYPE_DIV:
          if (get_attr_size (insn) == SIZE_32)
            return true;
          else
            break;
        case TYPE_LOAD:
        case TYPE_STORE:
        case TYPE_FPLOAD:
        case TYPE_FPSTORE:
          if (get_attr_update (insn) == UPDATE_YES)
            return true;
          else
            break;
        default:
          break;
        }
      break;
    case PROCESSOR_POWER7:
      type = get_attr_type (insn);

      switch (type)
        {
        case TYPE_CR_LOGICAL:
        case TYPE_MFCR:
        case TYPE_MFCRF:
        case TYPE_MTCR:
        case TYPE_DIV:
        case TYPE_ISYNC:
        case TYPE_LOAD_L:
        case TYPE_STORE_C:
        case TYPE_MFJMPR:
        case TYPE_MTJMPR:
          return true;
        case TYPE_MUL:
        case TYPE_SHIFT:
        case TYPE_EXTS:
          if (get_attr_dot (insn) == DOT_YES)
            return true;
          else
            break;
        case TYPE_LOAD:
          if (get_attr_sign_extend (insn) == SIGN_EXTEND_YES
              || get_attr_update (insn) == UPDATE_YES)
            return true;
          else
            break;
        case TYPE_STORE:
        case TYPE_FPLOAD:
        case TYPE_FPSTORE:
          if (get_attr_update (insn) == UPDATE_YES)
            return true;
          else
            break;
        default:
          break;
        }
      break;
    case PROCESSOR_POWER8:
      type = get_attr_type (insn);

      switch (type)
        {
        case TYPE_CR_LOGICAL:
        case TYPE_MFCR:
        case TYPE_MFCRF:
        case TYPE_MTCR:
        case TYPE_SYNC:
        case TYPE_ISYNC:
        case TYPE_LOAD_L:
        case TYPE_STORE_C:
        case TYPE_VECSTORE:
        case TYPE_MFJMPR:
        case TYPE_MTJMPR:
          return true;
        case TYPE_SHIFT:
        case TYPE_EXTS:
        case TYPE_MUL:
          if (get_attr_dot (insn) == DOT_YES)
            return true;
          else
            break;
        case TYPE_LOAD:
          if (get_attr_sign_extend (insn) == SIGN_EXTEND_YES
              || get_attr_update (insn) == UPDATE_YES)
            return true;
          else
            break;
        case TYPE_STORE:
          if (get_attr_update (insn) == UPDATE_YES
              && get_attr_indexed (insn) == INDEXED_YES)
            return true;
          else
            break;
        default:
          break;
        }
      break;
    default:
      break;
    }

  return false;
}

static bool
insn_must_be_last_in_group (rtx_insn *insn)
{
  enum attr_type type;

  if (!insn
      || NOTE_P (insn)
      || DEBUG_INSN_P (insn)
      || GET_CODE (PATTERN (insn)) == USE
      || GET_CODE (PATTERN (insn)) == CLOBBER)
    return false;

  switch (rs6000_tune) {
  case PROCESSOR_POWER4:
  case PROCESSOR_POWER5:
    if (is_microcoded_insn (insn))
      return true;

    if (is_branch_slot_insn (insn))
      return true;

    break;
  case PROCESSOR_POWER6:
    type = get_attr_type (insn);

    switch (type)
      {
      case TYPE_EXTS:
      case TYPE_CNTLZ:
      case TYPE_TRAP:
      case TYPE_MUL:
      case TYPE_FPCOMPARE:
      case TYPE_MFCR:
      case TYPE_MTCR:
      case TYPE_MFJMPR:
      case TYPE_MTJMPR:
      case TYPE_ISYNC:
      case TYPE_SYNC:
      case TYPE_LOAD_L:
      case TYPE_STORE_C:
        return true;
      case TYPE_SHIFT:
        if (get_attr_dot (insn) == DOT_NO
            || get_attr_var_shift (insn) == VAR_SHIFT_NO)
          return true;
        else
          break;
      case TYPE_DIV:
        if (get_attr_size (insn) == SIZE_32)
          return true;
        else
          break;
      default:
        break;
    }
    break;
  case PROCESSOR_POWER7:
    type = get_attr_type (insn);

    switch (type)
      {
      case TYPE_ISYNC:
      case TYPE_SYNC:
      case TYPE_LOAD_L:
      case TYPE_STORE_C:
        return true;
      case TYPE_LOAD:
        if (get_attr_sign_extend (insn) == SIGN_EXTEND_YES
            && get_attr_update (insn) == UPDATE_YES)
          return true;
        else
          break;
      case TYPE_STORE:
        if (get_attr_update (insn) == UPDATE_YES
            && get_attr_indexed (insn) == INDEXED_YES)
          return true;
        else
          break;
      default:
        break;
    }
    break;
  case PROCESSOR_POWER8:
    type = get_attr_type (insn);

    switch (type)
      {
      case TYPE_MFCR:
      case TYPE_MTCR:
      case TYPE_ISYNC:
      case TYPE_SYNC:
      case TYPE_LOAD_L:
      case TYPE_STORE_C:
        return true;
      case TYPE_LOAD:
        if (get_attr_sign_extend (insn) == SIGN_EXTEND_YES
            && get_attr_update (insn) == UPDATE_YES)
          return true;
        else
          break;
      case TYPE_STORE:
        if (get_attr_update (insn) == UPDATE_YES
            && get_attr_indexed (insn) == INDEXED_YES)
          return true;
        else
          break;
      default:
        break;
    }
    break;
  default:
    break;
  }

  return false;
}

/* Return true if it is recommended to keep NEXT_INSN "far" (in a separate
   dispatch group) from the insns in GROUP_INSNS.  Return false otherwise.  */

static bool
is_costly_group (rtx *group_insns, rtx next_insn)
{
  int i;
  int issue_rate = rs6000_issue_rate ();

  for (i = 0; i < issue_rate; i++)
    {
      sd_iterator_def sd_it;
      dep_t dep;
      rtx insn = group_insns[i];

      if (!insn)
	continue;

      FOR_EACH_DEP (insn, SD_LIST_RES_FORW, sd_it, dep)
	{
	  rtx next = DEP_CON (dep);

	  if (next == next_insn
	      && rs6000_is_costly_dependence (dep, dep_cost (dep), 0))
	    return true;
	}
    }

  return false;
}

/* Utility of the function redefine_groups.
   Check if it is too costly to schedule NEXT_INSN together with GROUP_INSNS
   in the same dispatch group.  If so, insert nops before NEXT_INSN, in order
   to keep it "far" (in a separate group) from GROUP_INSNS, following
   one of the following schemes, depending on the value of the flag
   -minsert_sched_nops = X:
   (1) X == sched_finish_regroup_exact: insert exactly as many nops as needed
       in order to force NEXT_INSN into a separate group.
   (2) X < sched_finish_regroup_exact: insert exactly X nops.
   GROUP_END, CAN_ISSUE_MORE and GROUP_COUNT record the state after nop
   insertion (has a group just ended, how many vacant issue slots remain in the
   last group, and how many dispatch groups were encountered so far).  */

static int
force_new_group (int sched_verbose, FILE *dump, rtx *group_insns,
		 rtx_insn *next_insn, bool *group_end, int can_issue_more,
		 int *group_count)
{
  rtx nop;
  bool force;
  int issue_rate = rs6000_issue_rate ();
  bool end = *group_end;
  int i;

  if (next_insn == NULL_RTX || DEBUG_INSN_P (next_insn))
    return can_issue_more;

  if (rs6000_sched_insert_nops > sched_finish_regroup_exact)
    return can_issue_more;

  force = is_costly_group (group_insns, next_insn);
  if (!force)
    return can_issue_more;

  if (sched_verbose > 6)
    fprintf (dump,"force: group count = %d, can_issue_more = %d\n",
	     *group_count ,can_issue_more);

  if (rs6000_sched_insert_nops == sched_finish_regroup_exact)
    {
      if (*group_end)
	can_issue_more = 0;

      /* Since only a branch can be issued in the last issue_slot, it is
	 sufficient to insert 'can_issue_more - 1' nops if next_insn is not
	 a branch. If next_insn is a branch, we insert 'can_issue_more' nops;
	 in this case the last nop will start a new group and the branch
	 will be forced to the new group.  */
      if (can_issue_more && !is_branch_slot_insn (next_insn))
	can_issue_more--;

      /* Do we have a special group ending nop? */
      if (rs6000_tune == PROCESSOR_POWER6 || rs6000_tune == PROCESSOR_POWER7
	  || rs6000_tune == PROCESSOR_POWER8)
	{
	  nop = gen_group_ending_nop ();
	  emit_insn_before (nop, next_insn);
	  can_issue_more = 0;
	}
      else
	while (can_issue_more > 0)
	  {
	    nop = gen_nop ();
	    emit_insn_before (nop, next_insn);
	    can_issue_more--;
	  }

      *group_end = true;
      return 0;
    }

  if (rs6000_sched_insert_nops < sched_finish_regroup_exact)
    {
      int n_nops = rs6000_sched_insert_nops;

      /* Nops can't be issued from the branch slot, so the effective
	 issue_rate for nops is 'issue_rate - 1'.  */
      if (can_issue_more == 0)
	can_issue_more = issue_rate;
      can_issue_more--;
      if (can_issue_more == 0)
	{
	  can_issue_more = issue_rate - 1;
	  (*group_count)++;
	  end = true;
	  for (i = 0; i < issue_rate; i++)
	    {
	      group_insns[i] = 0;
	    }
	}

      while (n_nops > 0)
	{
	  nop = gen_nop ();
	  emit_insn_before (nop, next_insn);
	  if (can_issue_more == issue_rate - 1) /* new group begins */
	    end = false;
	  can_issue_more--;
	  if (can_issue_more == 0)
	    {
	      can_issue_more = issue_rate - 1;
	      (*group_count)++;
	      end = true;
	      for (i = 0; i < issue_rate; i++)
		{
		  group_insns[i] = 0;
		}
	    }
	  n_nops--;
	}

      /* Scale back relative to 'issue_rate' (instead of 'issue_rate - 1').  */
      can_issue_more++;

      /* Is next_insn going to start a new group?  */
      *group_end
	= (end
	   || (can_issue_more == 1 && !is_branch_slot_insn (next_insn))
	   || (can_issue_more <= 2 && is_cracked_insn (next_insn))
	   || (can_issue_more < issue_rate &&
	       insn_terminates_group_p (next_insn, previous_group)));
      if (*group_end && end)
	(*group_count)--;

      if (sched_verbose > 6)
	fprintf (dump, "done force: group count = %d, can_issue_more = %d\n",
		 *group_count, can_issue_more);
      return can_issue_more;
    }

  return can_issue_more;
}

/* This function tries to synch the dispatch groups that the compiler "sees"
   with the dispatch groups that the processor dispatcher is expected to
   form in practice.  It tries to achieve this synchronization by forcing the
   estimated processor grouping on the compiler (as opposed to the function
   'pad_goups' which tries to force the scheduler's grouping on the processor).

   The function scans the insn sequence between PREV_HEAD_INSN and TAIL and
   examines the (estimated) dispatch groups that will be formed by the processor
   dispatcher.  It marks these group boundaries to reflect the estimated
   processor grouping, overriding the grouping that the scheduler had marked.
   Depending on the value of the flag '-minsert-sched-nops' this function can
   force certain insns into separate groups or force a certain distance between
   them by inserting nops, for example, if there exists a "costly dependence"
   between the insns.

   The function estimates the group boundaries that the processor will form as
   follows:  It keeps track of how many vacant issue slots are available after
   each insn.  A subsequent insn will start a new group if one of the following
   4 cases applies:
   - no more vacant issue slots remain in the current dispatch group.
   - only the last issue slot, which is the branch slot, is vacant, but the next
     insn is not a branch.
   - only the last 2 or less issue slots, including the branch slot, are vacant,
     which means that a cracked insn (which occupies two issue slots) can't be
     issued in this group.
   - less than 'issue_rate' slots are vacant, and the next insn always needs to
     start a new group.  */

static int
redefine_groups (FILE *dump, int sched_verbose, rtx_insn *prev_head_insn,
		 rtx_insn *tail)
{
  rtx_insn *insn, *next_insn;
  int issue_rate;
  int can_issue_more;
  int slot, i;
  bool group_end;
  int group_count = 0;
  rtx *group_insns;

  /* Initialize.  */
  issue_rate = rs6000_issue_rate ();
  group_insns = XALLOCAVEC (rtx, issue_rate);
  for (i = 0; i < issue_rate; i++)
    {
      group_insns[i] = 0;
    }
  can_issue_more = issue_rate;
  slot = 0;
  insn = get_next_active_insn (prev_head_insn, tail);
  group_end = false;

  while (insn != NULL_RTX)
    {
      slot = (issue_rate - can_issue_more);
      group_insns[slot] = insn;
      can_issue_more =
	rs6000_variable_issue (dump, sched_verbose, insn, can_issue_more);
      if (insn_terminates_group_p (insn, current_group))
	can_issue_more = 0;

      next_insn = get_next_active_insn (insn, tail);
      if (next_insn == NULL_RTX)
	return group_count + 1;

      /* Is next_insn going to start a new group?  */
      group_end
	= (can_issue_more == 0
	   || (can_issue_more == 1 && !is_branch_slot_insn (next_insn))
	   || (can_issue_more <= 2 && is_cracked_insn (next_insn))
	   || (can_issue_more < issue_rate &&
	       insn_terminates_group_p (next_insn, previous_group)));

      can_issue_more = force_new_group (sched_verbose, dump, group_insns,
					next_insn, &group_end, can_issue_more,
					&group_count);

      if (group_end)
	{
	  group_count++;
	  can_issue_more = 0;
	  for (i = 0; i < issue_rate; i++)
	    {
	      group_insns[i] = 0;
	    }
	}

      if (GET_MODE (next_insn) == TImode && can_issue_more)
	PUT_MODE (next_insn, VOIDmode);
      else if (!can_issue_more && GET_MODE (next_insn) != TImode)
	PUT_MODE (next_insn, TImode);

      insn = next_insn;
      if (can_issue_more == 0)
	can_issue_more = issue_rate;
    } /* while */

  return group_count;
}

/* Scan the insn sequence between PREV_HEAD_INSN and TAIL and examine the
   dispatch group boundaries that the scheduler had marked.  Pad with nops
   any dispatch groups which have vacant issue slots, in order to force the
   scheduler's grouping on the processor dispatcher.  The function
   returns the number of dispatch groups found.  */

static int
pad_groups (FILE *dump, int sched_verbose, rtx_insn *prev_head_insn,
	    rtx_insn *tail)
{
  rtx_insn *insn, *next_insn;
  rtx nop;
  int issue_rate;
  int can_issue_more;
  int group_end;
  int group_count = 0;

  /* Initialize issue_rate.  */
  issue_rate = rs6000_issue_rate ();
  can_issue_more = issue_rate;

  insn = get_next_active_insn (prev_head_insn, tail);
  next_insn = get_next_active_insn (insn, tail);

  while (insn != NULL_RTX)
    {
      can_issue_more =
      	rs6000_variable_issue (dump, sched_verbose, insn, can_issue_more);

      group_end = (next_insn == NULL_RTX || GET_MODE (next_insn) == TImode);

      if (next_insn == NULL_RTX)
	break;

      if (group_end)
	{
	  /* If the scheduler had marked group termination at this location
	     (between insn and next_insn), and neither insn nor next_insn will
	     force group termination, pad the group with nops to force group
	     termination.  */
	  if (can_issue_more
	      && (rs6000_sched_insert_nops == sched_finish_pad_groups)
	      && !insn_terminates_group_p (insn, current_group)
	      && !insn_terminates_group_p (next_insn, previous_group))
	    {
	      if (!is_branch_slot_insn (next_insn))
		can_issue_more--;

	      while (can_issue_more)
		{
		  nop = gen_nop ();
		  emit_insn_before (nop, next_insn);
		  can_issue_more--;
		}
	    }

	  can_issue_more = issue_rate;
	  group_count++;
	}

      insn = next_insn;
      next_insn = get_next_active_insn (insn, tail);
    }

  return group_count;
}

/* We're beginning a new block.  Initialize data structures as necessary.  */

static void
rs6000_sched_init (FILE *dump ATTRIBUTE_UNUSED,
		     int sched_verbose ATTRIBUTE_UNUSED,
		     int max_ready ATTRIBUTE_UNUSED)
{
  last_scheduled_insn = NULL;
  load_store_pendulum = 0;
  divide_cnt = 0;
  vec_pairing = 0;
}

/* The following function is called at the end of scheduling BB.
   After reload, it inserts nops at insn group bundling.  */

static void
rs6000_sched_finish (FILE *dump, int sched_verbose)
{
  int n_groups;

  if (sched_verbose)
    fprintf (dump, "=== Finishing schedule.\n");

  if (reload_completed && rs6000_sched_groups)
    {
      /* Do not run sched_finish hook when selective scheduling enabled.  */
      if (sel_sched_p ())
	return;

      if (rs6000_sched_insert_nops == sched_finish_none)
	return;

      if (rs6000_sched_insert_nops == sched_finish_pad_groups)
	n_groups = pad_groups (dump, sched_verbose,
			       current_sched_info->prev_head,
			       current_sched_info->next_tail);
      else
	n_groups = redefine_groups (dump, sched_verbose,
				    current_sched_info->prev_head,
				    current_sched_info->next_tail);

      if (sched_verbose >= 6)
	{
    	  fprintf (dump, "ngroups = %d\n", n_groups);
	  print_rtl (dump, current_sched_info->prev_head);
	  fprintf (dump, "Done finish_sched\n");
	}
    }
}

struct rs6000_sched_context
{
  short cached_can_issue_more;
  rtx_insn *last_scheduled_insn;
  int load_store_pendulum;
  int divide_cnt;
  int vec_pairing;
};

typedef struct rs6000_sched_context rs6000_sched_context_def;
typedef rs6000_sched_context_def *rs6000_sched_context_t;

/* Allocate store for new scheduling context.  */
static void *
rs6000_alloc_sched_context (void)
{
  return xmalloc (sizeof (rs6000_sched_context_def));
}

/* If CLEAN_P is true then initializes _SC with clean data,
   and from the global context otherwise.  */
static void
rs6000_init_sched_context (void *_sc, bool clean_p)
{
  rs6000_sched_context_t sc = (rs6000_sched_context_t) _sc;

  if (clean_p)
    {
      sc->cached_can_issue_more = 0;
      sc->last_scheduled_insn = NULL;
      sc->load_store_pendulum = 0;
      sc->divide_cnt = 0;
      sc->vec_pairing = 0;
    }
  else
    {
      sc->cached_can_issue_more = cached_can_issue_more;
      sc->last_scheduled_insn = last_scheduled_insn;
      sc->load_store_pendulum = load_store_pendulum;
      sc->divide_cnt = divide_cnt;
      sc->vec_pairing = vec_pairing;
    }
}

/* Sets the global scheduling context to the one pointed to by _SC.  */
static void
rs6000_set_sched_context (void *_sc)
{
  rs6000_sched_context_t sc = (rs6000_sched_context_t) _sc;

  gcc_assert (sc != NULL);

  cached_can_issue_more = sc->cached_can_issue_more;
  last_scheduled_insn = sc->last_scheduled_insn;
  load_store_pendulum = sc->load_store_pendulum;
  divide_cnt = sc->divide_cnt;
  vec_pairing = sc->vec_pairing;
}

/* Free _SC.  */
static void
rs6000_free_sched_context (void *_sc)
{
  gcc_assert (_sc != NULL);

  free (_sc);
}

static bool
rs6000_sched_can_speculate_insn (rtx_insn *insn)
{
  switch (get_attr_type (insn))
    {
    case TYPE_DIV:
    case TYPE_SDIV:
    case TYPE_DDIV:
    case TYPE_VECDIV:
    case TYPE_SSQRT:
    case TYPE_DSQRT:
      return false;

    default:
      return true;
  }
}

/* Length in units of the trampoline for entering a nested function.  */

int
rs6000_trampoline_size (void)
{
  int ret = 0;

  switch (DEFAULT_ABI)
    {
    default:
      gcc_unreachable ();

    case ABI_AIX:
      ret = (TARGET_32BIT) ? 12 : 24;
      break;

    case ABI_ELFv2:
      gcc_assert (!TARGET_32BIT);
      ret = 32;
      break;

    case ABI_DARWIN:
    case ABI_V4:
      ret = (TARGET_32BIT) ? 40 : 48;
      break;
    }

  return ret;
}

/* Emit RTL insns to initialize the variable parts of a trampoline.
   FNADDR is an RTX for the address of the function's pure code.
   CXT is an RTX for the static chain value for the function.  */

static void
rs6000_trampoline_init (rtx m_tramp, tree fndecl, rtx cxt)
{
  int regsize = (TARGET_32BIT) ? 4 : 8;
  rtx fnaddr = XEXP (DECL_RTL (fndecl), 0);
  rtx ctx_reg = force_reg (Pmode, cxt);
  rtx addr = force_reg (Pmode, XEXP (m_tramp, 0));

  switch (DEFAULT_ABI)
    {
    default:
      gcc_unreachable ();

    /* Under AIX, just build the 3 word function descriptor */
    case ABI_AIX:
      {
	rtx fnmem, fn_reg, toc_reg;

	if