/* PR c/102989 */
/* { dg-do run { target bitint } } */
/* { dg-options "-std=c2x -pedantic-errors" } */
/* { dg-skip-if "" { ! run_expensive_tests }  { "*" } { "-O0" "-O2" } } */
/* { dg-skip-if "" { ! run_expensive_tests } { "-flto" } { "" } } */

#if __BITINT_MAXWIDTH__ >= 256
__attribute__((noipa)) _Bool
test256 (_BitInt(256) *q)
{
  return __builtin_sub_overflow ((_BitInt(256)) 0, q[0], q + 1);
}
#endif

int
main ()
{
#if __BITINT_MAXWIDTH__ >= 256
  static _BitInt(256) q256[] = {
    45345032714412617256156490782169070529322290545773058110333871537162440472587wb,
    0wb,
    -45345032714412617256156490782169070529322290545773058110333871537162440472587wb,
    -45345032714412617256156490782169070529322290545773058110333871537162440472587wb,
    0wb,
    45345032714412617256156490782169070529322290545773058110333871537162440472587wb,
    -57896044618658097711785492504343953926634992332820282019728792003956564819967wb - 1,
    0wb,
    -57896044618658097711785492504343953926634992332820282019728792003956564819967wb - 1
  };
  for (int i = 0; i < 3; ++i)
    if (test256 (q256 + 3 * i) != (i == 2) || q256[3 * i + 1] != q256[3 * i + 2])
      __builtin_abort ();
#endif
}
