/* PR c/102989 */
/* { dg-do run { target bitint } } */
/* { dg-options "-std=c2x -pedantic-errors" } */
/* { dg-skip-if "" { ! run_expensive_tests }  { "*" } { "-O0" "-O2" } } */
/* { dg-skip-if "" { ! run_expensive_tests } { "-flto" } { "" } } */

#if __BITINT_MAXWIDTH__ >= 135
__attribute__((noipa)) _BitInt(135)
test_135 (_BitInt(135) x)
{
  return x;
}
#endif

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) unsigned _BitInt(192)
test_192 (unsigned _BitInt(192) x)
{
  return x;
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) _BitInt(575)
test_575 (_BitInt(575) x)
{
  return x;
}
#endif

int
main ()
{
#if __BITINT_MAXWIDTH__ >= 135
  if (test_135 (-3544625980220396993429741165699996713118wb)
      != -3544625980220396993429741165699996713118wb)
    __builtin_abort ();
  if (test_135 (2169804wb) != 2169804wb)
    __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 192
  if (test_192 (3548247468860296534428690122730090696161878417599647607527uwb)
      != 3548247468860296534428690122730090696161878417599647607527uwb)
    __builtin_abort ();
  if (test_192 (2169804wb) != 2169804wb)
    __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 575
  if (test_575 (-33874713055088145128482141398907153733216500583643955589065159154103468056485975553675944430696955474989655597693729139818286384955989466009330817447458608627989731550807841wb)
      != -33874713055088145128482141398907153733216500583643955589065159154103468056485975553675944430696955474989655597693729139818286384955989466009330817447458608627989731550807841wb)
    __builtin_abort ();
  if (test_575 (-3433547832854987708194667330190358661244810661613962474981319303539871wb)
      != -3433547832854987708194667330190358661244810661613962474981319303539871wb)
    __builtin_abort ();
  if (test_575 (-49693319wb) != -49693319wb)
    __builtin_abort ();
  if (test_575 (57563058931861084391041643822550577259264793697002277417254009715684553274763772399490655207001200602249198262962055591804634113396033194657392511369609233430583407788096333wb)
      != 57563058931861084391041643822550577259264793697002277417254009715684553274763772399490655207001200602249198262962055591804634113396033194657392511369609233430583407788096333wb)
    __builtin_abort ();
  if (test_575 (158093724114624905837287422406159616673122916308832353wb)
      != 158093724114624905837287422406159616673122916308832353wb)
    __builtin_abort ();
  if (test_575 (3807354285642wb) != 3807354285642wb)
    __builtin_abort ();
#endif
}
