/* PR c/102989 */
/* { dg-do run { target bitint } } */
/* { dg-options "-std=c2x" } */
/* { dg-skip-if "" { ! run_expensive_tests }  { "*" } { "-O0" "-O2" } } */
/* { dg-skip-if "" { ! run_expensive_tests } { "-flto" } { "" } } */

#if __LDBL_MANT_DIG__ == 64
#if __BITINT_MAXWIDTH__ >= 135
__attribute__((noipa)) long double
testldbl_135 (_BitInt(135) b)
{
  return b;
}

__attribute__((noipa)) long double
testldblu_135 (unsigned _BitInt(135) b)
{
  return b;
}
#endif

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) long double
testldbl_192 (_BitInt(192) b)
{
  return b;
}

__attribute__((noipa)) long double
testldblu_192 (unsigned _BitInt(192) b)
{
  return b;
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) long double
testldbl_575 (_BitInt(575) b)
{
  return b;
}

__attribute__((noipa)) long double
testldblu_575 (unsigned _BitInt(575) b)
{
  return b;
}
#endif
#endif

#if __FLT128_MANT_DIG__ == 113
#if __BITINT_MAXWIDTH__ >= 135
__attribute__((noipa)) _Float128
testflt128_135 (_BitInt(135) b)
{
  return b;
}

__attribute__((noipa)) _Float128
testflt128u_135 (unsigned _BitInt(135) b)
{
  return b;
}
#endif

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) _Float128
testflt128_192 (_BitInt(192) b)
{
  return b;
}

__attribute__((noipa)) _Float128
testflt128u_192 (unsigned _BitInt(192) b)
{
  return b;
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) _Float128
testflt128_575 (_BitInt(575) b)
{
  return b;
}

__attribute__((noipa)) _Float128
testflt128u_575 (unsigned _BitInt(575) b)
{
  return b;
}
#endif
#endif

int
main ()
{
#if __BITINT_MAXWIDTH__ >= 135
  static _BitInt(135) s_135[] = {
    -39242093wb,
    -36246971635108657318127321wb,
    -816440703352wb,
    8409360wb,
    231875wb,
    -1859wb,
    8123250453541347379290840008816194983wb,
    42642091wb,
    -2499664813007708583619356686wb,
    -14022533493907734339644wb,
    737816709430180009697449492wb,
    3094418595787172583521548578719419wb,
    84096wb,
    -3856393637064417wb,
    5494wb,
    -7227655824382622730861wb,
    185250722103742953wb,
    -266695839223233222300219080587185431wb,
    124wb,
    -4540724906728461994579131745203067wb,
    -34474123wb,
    6171186wb,
    -1738448518309495501564259945530043942wb,
    3714wb,
    22759310366655438105064084505115489wb,
    -461wb,
    -1891475049610273521994429918325638525836wb,
    -350wb,
    3721759411106519959861226774340wb,
    -42485872965031409753wb,
    4362279409022137273490486629950wb,
    521928664204421037572709995195346211111wb,
    -50129wb,
    -21525556783117336078661729wb
  };
  static unsigned _BitInt(135) u_135[] = {
    773802493804221964748670742461281016363uwb,
    897485218654369665002411485681173uwb,
    37306898634990773758633uwb,
    3uwb,
    920156uwb,
    15230973698181139105641901258312096uwb,
    1383843491123931387484696uwb,
    143810081711544975903357370071668200uwb,
    83615891310230331473978uwb,
    1239150390uwb,
    39792042288uwb,
    20985035121604uwb,
    3700707uwb,
    14510535740825uwb,
    5675982879048653163399531637816917uwb,
    593909622129190124122830uwb,
    413008891327830587264uwb,
    34694483328uwb,
    592129uwb,
    2649uwb,
    154468451808267466822214091328849uwb,
    8905088171048376399858691570634230197204uwb,
    456uwb,
    12101uwb,
    5879086272uwb,
    115170058487623uwb,
    2274163249406113742515726136586945854500uwb,
    63923152267905666653uwb,
    624302860090054295150365837280525227924uwb,
    9uwb,
    5703520721951508439418uwb,
    44653119094uwb,
    1440439605268989101uwb,
    3496654014361uwb
  };
#endif
#if __BITINT_MAXWIDTH__ >= 192
  static _BitInt(192) s_192[] = {
    81945579384314684613279565479277935940wb,
    1640150770700583136800158704601080wb,
    432402469012491481987292073086668wb,
    -15369197386440508323548800500962985157137866798390wb,
    217705797486262wb,
    1wb,
    -150837356854711044278780637wb,
    1247354027519369533750440146304wb,
    -700073531555662209687924602081wb,
    -441651351073606706893667405889558445894wb,
    -743993151249791392844844248857961054wb,
    1681039wb,
    -170386616439159353410812029301398243129730wb,
    -97703172400304820221345002831889wb,
    9wb,
    7277656199366069102639319241893wb,
    7201222364wb,
    -4671533967546296507223686237333335wb,
    13311155734490577635922550wb,
    76150533189365685907637983428512213977569647wb,
    -283560863483321465221194695455688610811wb,
    6438368552004797088499844257634549000496626110080371wb,
    1122038765213390728664343086041576wb,
    -9541613313421359977755878156940wb,
    21551012076757076795102244535269250wb,
    -4794294047755173531367558272wb,
    -5708612827808554221wb,
    -2649648007071280662902443553973167294046518180wb,
    -35698660478241255546377wb,
    -79587921140918wb,
    469393710173925646wb,
    -261330983098092746969723637867599382044980841179747207wb,
    -115wb,
    -1717706681396wb
  };
  static unsigned _BitInt(192) u_192[] = {
    87197051833867272589618945858714291675632402028uwb,
    175207476610687227705633653396153452205075322355946uwb,
    289472685412214318981767004188uwb,
    58352315342320048378103056601781218026976uwb,
    68512267071922032916894194298300228491490143452269uwb,
    8654067584750856592691725728280108682858075uwb,
    57027948061283099317671673937496946487124629uwb,
    512829256101uwb,
    8815296701808550493421309771596155666520uwb,
    1918805208198312310092547265227uwb,
    99680639255733807uwb,
    313647272226958893709907781719uwb,
    534434342549592762863366619879590694414818uwb,
    1751643652514709uwb,
    24084146046683127013882581681582087uwb,
    1282076uwb,
    13590701668411111769uwb,
    62207549230439503653uwb,
    144040025133692457990548614076288499046uwb,
    11981724905403945793356785358565398049196880116uwb,
    1823479497818478859136796209626920064416489979129893695uwb,
    4649uwb,
    2095541338428713427585867932062430293488017906261402uwb,
    605377488765896342050766363050545164888333863362uwb,
    11488350477184223uwb,
    9492972359709013710789022084605392630683565515935199uwb,
    36826148417259uwb,
    554404239122129842026250702689uwb,
    2804528919100uwb,
    127uwb,
    66823885107232870336040073990324uwb,
    297736625249uwb,
    3701132312864550550157874952341371502832960625370598966uwb,
    107247048428uwb
  };
#endif
#if __BITINT_MAXWIDTH__ >= 575
  static _BitInt(575) s_575[] = {
    822555268170764275096048134868384963633463468104839796862654006268369616wb,
    -960580267694575830808697063169243963045681635800151938720065734940592300657700227419337766780029829446319203wb,
    33504080263976494448954627475165765154890874061543914469206217657999706310163279811015042121096338719830090426757797138233202615461wb,
    275983725374553564148936957707321552749wb,
    5534912144897227754137156977371639235252437172582938580045103986268272085395760563838753817115093434280932847973705994570261258933419373885658991359441723005813683395590541wb,
    1412920302762671055711845665320769771488824036206881359103417821581950493952853265134760513685359011001836948515905971331797139790wb,
    -262974997977953570994865210107604152900839198803859287819970850481583440338320059wb,
    -92488905333378799268618025132022462336176863903734682501838771365453998891689279398wb,
    242604167696163732697906496386839396751068wb,
    -3523803651131338645439245946293wb,
    -5147220779398204849222374563179412010462379234108857688330486391319694172748210918710342389194957287070617133280194810193962683650761347126311504766504260691wb,
    -126995956651641937332005246092202755154992252553028943468563459072746155379181900761169956344678911600wb,
    8137926360495wb,
    -15994393111836746332671329788635258wb,
    -277068516868681202554828866807401284583187899477211188256772654837767448404666578906477389363058609157862574wb,
    12643256666940489874033990964997310860090310878838229112053311027168830831623703103010815387wb,
    197250790460297242975596746662998763328365874997wb,
    2003391279347376998472wb,
    -199877387236416475658211887841938073691092213166438343739wb,
    683783725793437346966376731991835336458591392078548990419792641719902684445391913394174240265031277360362886303597899811253111402611797905136669wb,
    13527430925075101894748577029275389339063875642859674079897983403256wb,
    539267000300803493510458136103246878203019746178696339759252798818676107273127463057162208073142618039409911wb,
    25132435181738021677664552852329012363786311024121402747618663944355967806315928846073722774898wb,
    -24501129715197464074815490290653wb,
    -26621511339033230503491791253914731850253401wb,
    219726795681725191949095808767196099036895435893837474958165415185577738548053399820419849wb,
    142706206515281341916417852232439287400819155237127620529348000437671770471697052705666056232742428920527wb,
    -1272097813202031618710288063584910456400985264371503722255927680393419899507092728461wb,
    104580584066897755717617980935051171929519336855902844943415231226523598033953128466889325153396268078513996620240379420239887wb,
    -10163452549280413821027501723364683075067110986059205073343287754152825761658667193285948456506970145368258900765489010580419998927374372004822965287098902519382wb,
    -1462817702603947401421838547412731208810505797188084686210372939517152226213737422286025118826482655559744680456146694118022879735528111700409wb,
    -1004473459167555639043426932334304398038355185104669wb,
    383945882095471823332216311173956104021530654187057868803605149628498470119801535759629951357637987556377174553957515312582545289930138018wb,
    147266903774875157001493887893421901156259749590403482558013070wb
  };
  static unsigned _BitInt(575) u_575[] = {
    340315902121482071031uwb,
    9193736781349493374149172723522049938732355975055uwb,
    121133456126887617775249483436586396232697894267611535022240817951287068117843073672uwb,
    1253811282917666038992497uwb,
    279807426767721176279253888473522991149118862415710500804613956730247764438409575562386uwb,
    4763192686302836059965684032432862167583119264783uwb,
    19433750446582365356875213925336734177599085624532213292961813424848222698351037862663241858724337375675uwb,
    8615689860907972907203187028321798323548254692780962654211537619771698680316938530412569744897459065621193843349775333790731199245018643579445580816793381624810616262uwb,
    126055589776274659515356020606486923511478187977197128509709117843059226901071386846700207970626608150351060714322162254429913496135590117225450775153364768928781244uwb,
    34636325529158225079379169125604752070369970834816893592982969115088710130160324580864333959889906313467177163564702338046445540uwb,
    2295982750677874548137685137480985649627965059590627454944uwb,
    22288650253829612832302454550260146151077393473uwb,
    61551827uwb,
    948415991495935226718622697967024251064408554619458611515264819726244946850447758605031396753280209023664964305741301009407513619686102uwb,
    7599947921908039117808602805272900633862767543347735124983729771592896283177667324402886239291446uwb,
    3064098671438076295010586583414642866550259610904044948559784636731818131096680869327433283805326015689481397549653557650965154282598345191654721039973597171695049076467uwb,
    26163216482276433755253744705785501134309546797499410671258175352214852627310317854549342428286751107453875459uwb,
    1083530146709801198539441549736949256980046185455966999062614188586191607484611079705240990524552846829821534154580456458426794497253838343299379036578711641930103uwb,
    241446995995054305582384233456322509709013171336859127uwb,
    224319712854uwb,
    1851847735563213275uwb,
    3517907813008404838784133683859253992uwb,
    57026061017409510123542169719303829618100077009666501089739966522905673377916488253uwb,
    218054639772618074096850378810323560503313926757275788155487065187235936858569852576120793613879980uwb,
    1035184782769221379uwb,
    20229959242348674822834301353257599618846169820699281424077697412860273533283192155424030349307384555863768665398854990uwb,
    48688062002166777196074419660880812175599377353811333642743225865182422320253615211852611218169059717666168172585704763331192485699241038689921302806665184uwb,
    38974159722814402881994907079236516884965127718714589284306855526034875317101125387287977578141556918226042568695412232uwb,
    195268331869690963115384309853070889302314974440838447729079592004150231uwb,
    131384791058457562831689753115846222538215620945564207628285200123621656731679644407994773520965uwb,
    1334982489788592107403503927792629194402uwb,
    2146uwb,
    25165296015221802429838428736907886uwb,
    6254uwb
  };
#endif
#if __LDBL_MANT_DIG__ == 64
#if __BITINT_MAXWIDTH__ >= 135
  static long double ldbl_135[] = {
    -39242093.0L,
    -36246971635108657317806080.0L,
    -816440703352.0L,
    8409360.0L,
    231875.0L,
    -1859.0L,
    8123250453541347379469761730828042240.0L,
    42642091.0L,
    -2499664813007708583503069184.0L,
    -14022533493907734339584.0L,
    737816709430180009723559936.0L,
    3094418595787172583474668509331456.0L,
    84096.0L,
    -3856393637064417.0L,
    5494.0L,
    -7227655824382622730752.0L,
    185250722103742953.0L,
    -266695839223233222305995365384454144.0L,
    124.0L,
    -4540724906728461994627321936478208.0L,
    -34474123.0L,
    6171186.0L,
    -1738448518309495501607474587347451904.0L,
    3714.0L,
    22759310366655438104798293506654208.0L,
    -461.0L,
    -1891475049610273521975332702278492618752.0L,
    -350.0L,
    3721759411106519959735009017856.0L,
    -42485872965031409752.0L,
    4362279409022137273388535644160.0L,
    521928664204421037567490386336795328512.0L,
    -50129.0L,
    -21525556783117336078974976.0L
  };
  static long double ldblu_135[] = {
    773802493804221964731523995050312728576.0L,
    897485218654369665019834468925440.0L,
    37306898634990773757952.0L,
    3.0L,
    920156.0L,
    15230973698181139106030422216146944.0L,
    1383843491123931387527168.0L,
    143810081711544975903121569568784384.0L,
    83615891310230331473920.0L,
    1239150390.0L,
    39792042288.0L,
    20985035121604.0L,
    3700707.0L,
    14510535740825.0L,
    5675982879048653163182084577034240.0L,
    593909622129190124126208.0L,
    413008891327830587264.0L,
    34694483328.0L,
    592129.0L,
    2649.0L,
    154468451808267466823175803764736.0L,
    8905088171048376400013977264402823380992.0L,
    456.0L,
    12101.0L,
    5879086272.0L,
    115170058487623.0L,
    2274163249406113742443724808818842927104.0L,
    63923152267905666652.0L,
    624302860090054295134491019551908560896.0L,
    9.0L,
    5703520721951508439552.0L,
    44653119094.0L,
    1440439605268989101.0L,
    3496654014361.0L
  };
  for (int i = 0; i < 34; ++i)
    if (testldbl_135 (s_135[i]) != ldbl_135[i])
      __builtin_abort ();
  for (int i = 0; i < 34; ++i)
    if (testldblu_135 (u_135[i]) != ldblu_135[i])
      __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 192
  static long double ldbl_192[] = {
    81945579384314684615486553814565126144.0L,
    1640150770700583136824020921483264.0L,
    432402469012491481997169632739328.0L,
    -15369197386440508323699427265690859620608677773312.0L,
    217705797486262.0L,
    1.0L,
    -150837356854711044278321152.0L,
    1247354027519369533773926367232.0L,
    -700073531555662209714428575744.0L,
    -441651351073606706894128730685912907776.0L,
    -743993151249791392856039956714356736.0L,
    1681039.0L,
    -170386616439159353411571089494999662854144.0L,
    -97703172400304820218983461421056.0L,
    9.0L,
    7277656199366069102773721366528.0L,
    7201222364.0L,
    -4671533967546296507225268333576192.0L,
    13311155734490577636425728.0L,
    76150533189365685909073333864980807126351872.0L,
    -283560863483321465221954398498764881920.0L,
    6438368552004797088286842127358606670130187958484992.0L,
    1122038765213390728647299370582016.0L,
    -9541613313421359977544883896320.0L,
    21551012076757076794749160467202048.0L,
    -4794294047755173531333165056.0L,
    -5708612827808554221.0L,
    -2649648007071280662943908311143037314611019776.0L,
    -35698660478241255546880.0L,
    -79587921140918.0L,
    469393710173925646.0L,
    -261330983098092746965490195259240226746743657452273664.0L,
    -115.0L,
    -1717706681396.0L
  };
  static long double ldblu_192[] = {
    87197051833867272588273235452569162784769572864.0L,
    175207476610687227706687797568524886702441101262848.0L,
    289472685412214318984721334272.0L,
    58352315342320048378267314962278412976128.0L,
    68512267071922032918571353538687014836972935970816.0L,
    8654067584750856592762121211182827528257536.0L,
    57027948061283099315414259852803440866492416.0L,
    512829256101.0L,
    8815296701808550493422802574317577043968.0L,
    1918805208198312310068180156416.0L,
    99680639255733807.0L,
    313647272226958893711859122176.0L,
    534434342549592762879721307175636579647488.0L,
    1751643652514709.0L,
    24084146046683127014125128497758208.0L,
    1282076.0L,
    13590701668411111769.0L,
    62207549230439503652.0L,
    144040025133692457990249596390545031168.0L,
    11981724905403945793671003738109723829870788608.0L,
    1823479497818478859069120464961329580751135834288160768.0L,
    4649.0L,
    2095541338428713427646614015896834392659590161367040.0L,
    605377488765896342059796742106757546391141089280.0L,
    11488350477184223.0L,
    9492972359709013711015472005202975871148440705564672.0L,
    36826148417259.0L,
    554404239122129842012080308224.0L,
    2804528919100.0L,
    127.0L,
    66823885107232870337998237990912.0L,
    297736625249.0L,
    3701132312864550550087325046630338074858031302905430016.0L,
    107247048428.0L
  };
  for (int i = 0; i < 34; ++i)
    if (testldbl_192 (s_192[i]) != ldbl_192[i])
      __builtin_abort ();
  for (int i = 0; i < 34; ++i)
    if (testldblu_192 (u_192[i]) != ldblu_192[i])
      __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 575
  static long double ldbl_575[] = {
    822555268170764275077806657331958312785072234722196584950240570089930752.0L,
    -960580267694575830812783278498171621690403946709581436518965868233794729994615679173272606109483012722786304.0L,
    33504080263976494448478492229617991564043478238504231331124912879329149376584163966764611121993710792934518914942887118335291424768.0L,
    275983725374553564145377013770043260928.0L,
    5534912144897227754208044441151874379702287612174069453950291607680839007181861996360330547973886690095069343864416739797783816199380471673982675880600014677768303758278656.0L,
    1412920302762671055675563434211562120848328209741725967322941102900395775694793728702679689406728724040334624347456855689117302784.0L,
    -262974997977953570989611804750151836163609455430948784164618597359252696534614016.0L,
    -92488905333378799268155556881914668962189440213360997930258834387927208673968914432.0L,
    242604167696163732690645137756322057420800.0L,
    -3523803651131338645559050240000.0L,
    -5147220779398204849257508190774210744388677252688140210517976277065981842998232251783846790859222005317012238819263034139406832143929230632126090335152504832.0L,
    -126995956651641937331951286489675247329200371648605762035297081195775007184684091195737834711064510464.0L,
    8137926360495.0L,
    -15994393111836746332220340607909888.0L,
    -277068516868681202557212831225058932276240633526059351948516115207300877649787450206685852465539880786591744.0L,
    12643256666940489873646135309702875993528109590137490134559735498193302898793674757994708992.0L,
    197250790460297242979551814062140644203109023744.0L,
    2003391279347376998528.0L,
    -199877387236416475651341878965641904464653154051860463616.0L,
    683783725793437346957771892228315489408774085809131650337993219889398577200119614673432810174598052160906191944536223932553104679193775255322624.0L,
    13527430925075101895119202629107559447133788166435502697026955509760.0L,
    539267000300803493497377352922791719626542478240740953329921195747662290582499442246914945221535539392413696.0L,
    25132435181738021677436908541817803462240416694341366601465742717478799945180412844899030794240.0L,
    -24501129715197464074399946637312.0L,
    -26621511339033230503970770955171473406296064.0L,
    219726795681725191947197274288751751131300579623020247100319392523607242309690678380068864.0L,
    142706206515281341912722598102787801262511939753862115682796537774690209934320984609531887855849227419648.0L,
    -1272097813202031618686076349197106943277274743836448162114522403548727854475931287552.0L,
    104580584066897755721462109894862071102150680746488173021715848651881249493019658369304827516906027223482984669789074019581952.0L,
    -10163452549280413820781685181828332647679763634230328394877439998644536448688077844493834184118223902098524496370094218227350253632267534838755399334577766924288.0L,
    -1462817702603947401460379075968185573663143558708148172616668782116177216739740002633588435639151707520878885121466080144202470951229168025600.0L,
    -1004473459167555639022590826165981346984598475636736.0L,
    383945882095471823335289502673360394820076368186253637060368537085404663434451033274997076104121125319917967630183508209073164612376985600.0L,
    147266903774875157000698971886464128985498372744856873180594176.0L
  };
  static long double ldblu_575[] = {
    340315902121482071040.0L,
    9193736781349493374213713986696905438099568328704.0L,
    121133456126887617773526383630522733268849231796244390648544501184867233045273378816.0L,
    1253811282917666039005184.0L,
    279807426767721176282774705066477746529679092594765002865548096525989858075665567318016.0L,
    4763192686302836060022861615709466380079764340736.0L,
    19433750446582365356243841895010508514709904909750555910761104889681456249932954817669662897799021199360.0L,
    8615689860907972907222987015567999691990010815316564361117521521881809095333131098584672097178927461838400993199702306526955489286031755082939241644835174978131329024.0L,
    126055589776274659510297467904389237873624120132406221380350474491493460160959938222126650105936552657875183912780356083785858555181180003532557375481178518259236864.0L,
    34636325529158225078961380771473094521787740905726267965061232731631589683984587408777114033008811740835389841050115225879052288.0L,
    2295982750677874548189777005986107945005083683202176909312.0L,
    22288650253829612832625936906216823076906074112.0L,
    61551827.0L,
    948415991495935226723497275802282711176800359354343687935431821975740085005513640520546841077796705045317773075243223746142080749010944.0L,
    7599947921908039117650085272592622557045482160051694630122205426595170751482611426300682100015104.0L,
    3064098671438076294956291179633525016992278379765933214428836815032632500735568461039018643426109912566222922020667353487719095386222010158443081500511850171532585205760.0L,
    26163216482276433754726515355485427397196865766902718455812787467581155703138962108081214195725927010405449728.0L,
    1083530146709801198518741455890332623877113096673714750194062874316360337538555304664904549334408175509822671036217297610308526225295574707709647653730601851158528.0L,
    241446995995054305577613396367243923288085288827486208.0L,
    224319712854.0L,
    1851847735563213275.0L,
    3517907813008404838855514029591363584.0L,
    57026061017409510124756586261527283120773656504559685146885133984875447971917856768.0L,
    218054639772618074103918318492639949832541424857847525973689094242831096606721142712632506945896448.0L,
    1035184782769221379.0L,
    20229959242348674822030474865930581759882432185790556800837709536659306775612115303354290565630013099091822016569802752.0L,
    48688062002166777197217906565531932202748743487730562775775885775077288260863868471270436338269362633469095873857458641986964902395586782692041797794791424.0L,
    38974159722814402882041466859823829059112658796999627209873147217197515116287035613100423934964813946613319590312148992.0L,
    195268331869690963115301358617419463247405494910442809797401817422757888.0L,
    131384791058457562832910671881942611444639653628436820141165072497889292487990472973483579015168.0L,
    1334982489788592107381730508641253982208.0L,
    2146.0L,
    25165296015221802429839839397412864.0L,
    6254.0L
  };
  for (int i = 0; i < 34; ++i)
    if (testldbl_575 (s_575[i]) != ldbl_575[i])
      __builtin_abort ();
  for (int i = 0; i < 34; ++i)
    if (testldblu_575 (u_575[i]) != ldblu_575[i])
      __builtin_abort ();
#endif
#endif
#if __FLT128_MANT_DIG__ == 113
#if __BITINT_MAXWIDTH__ >= 135
  static _Float128 flt128_135[] = {
    -39242093.0F128,
    -36246971635108657318127321.0F128,
    -816440703352.0F128,
    8409360.0F128,
    231875.0F128,
    -1859.0F128,
    8123250453541347379290840008816194560.0F128,
    42642091.0F128,
    -2499664813007708583619356686.0F128,
    -14022533493907734339644.0F128,
    737816709430180009697449492.0F128,
    3094418595787172583521548578719419.0F128,
    84096.0F128,
    -3856393637064417.0F128,
    5494.0F128,
    -7227655824382622730861.0F128,
    185250722103742953.0F128,
    -266695839223233222300219080587185440.0F128,
    124.0F128,
    -4540724906728461994579131745203067.0F128,
    -34474123.0F128,
    6171186.0F128,
    -1738448518309495501564259945530043904.0F128,
    3714.0F128,
    22759310366655438105064084505115488.0F128,
    -461.0F128,
    -1891475049610273521994429918325638430720.0F128,
    -350.0F128,
    3721759411106519959861226774340.0F128,
    -42485872965031409753.0F128,
    4362279409022137273490486629950.0F128,
    521928664204421037572709995195346190336.0F128,
    -50129.0F128,
    -21525556783117336078661729.0F128
  };
  static _Float128 flt128u_135[] = {
    773802493804221964748670742461281075200.0F128,
    897485218654369665002411485681173.0F128,
    37306898634990773758633.0F128,
    3.0F128,
    920156.0F128,
    15230973698181139105641901258312096.0F128,
    1383843491123931387484696.0F128,
    143810081711544975903357370071668192.0F128,
    83615891310230331473978.0F128,
    1239150390.0F128,
    39792042288.0F128,
    20985035121604.0F128,
    3700707.0F128,
    14510535740825.0F128,
    5675982879048653163399531637816917.0F128,
    593909622129190124122830.0F128,
    413008891327830587264.0F128,
    34694483328.0F128,
    592129.0F128,
    2649.0F128,
    154468451808267466822214091328849.0F128,
    8905088171048376399858691570634230595584.0F128,
    456.0F128,
    12101.0F128,
    5879086272.0F128,
    115170058487623.0F128,
    2274163249406113742515726136586945953792.0F128,
    63923152267905666653.0F128,
    624302860090054295150365837280525221888.0F128,
    9.0F128,
    5703520721951508439418.0F128,
    44653119094.0F128,
    1440439605268989101.0F128,
    3496654014361.0F128,
  };
  for (int i = 0; i < 34; ++i)
    if (testflt128_135 (s_135[i]) != flt128_135[i])
      __builtin_abort ();
  for (int i = 0; i < 34; ++i)
    if (testflt128u_135 (u_135[i]) != flt128u_135[i])
      __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 192
  static _Float128 flt128_192[] = {
    81945579384314684613279565479277936640.0F128,
    1640150770700583136800158704601080.0F128,
    432402469012491481987292073086668.0F128,
    -15369197386440508323548800500962985275185701060608.0F128,
    217705797486262.0F128,
    1.0F128,
    -150837356854711044278780637.0F128,
    1247354027519369533750440146304.0F128,
    -700073531555662209687924602081.0F128,
    -441651351073606706893667405889558413312.0F128,
    -743993151249791392844844248857961088.0F128,
    1681039.0F128,
    -170386616439159353410812029301398240755712.0F128,
    -97703172400304820221345002831889.0F128,
    9.0F128,
    7277656199366069102639319241893.0F128,
    7201222364.0F128,
    -4671533967546296507223686237333335.0F128,
    13311155734490577635922550.0F128,
    76150533189365685907637983428512210753683456.0F128,
    -283560863483321465221194695455688622080.0F128,
    6438368552004797088499844257634549357780509986390016.0F128,
    1122038765213390728664343086041576.0F128,
    -9541613313421359977755878156940.0F128,
    21551012076757076795102244535269248.0F128,
    -4794294047755173531367558272.0F128,
    -5708612827808554221.0F128,
    -2649648007071280662902443553973167373493993472.0F128,
    -35698660478241255546377.0F128,
    -79587921140918.0F128,
    469393710173925646.0F128,
    -261330983098092746969723637867599366653101971873988608.0F128,
    -115.0F128,
    -1717706681396.0F128
  };
  static _Float128 flt128u_192[] = {
    87197051833867272589618945858714289326891466752.0F128,
    175207476610687227705633653396153448946982933495808.0F128,
    289472685412214318981767004188.0F128,
    58352315342320048378103056601781215690752.0F128,
    68512267071922032916894194298300226631128387158016.0F128,
    8654067584750856592691725728280108697911296.0F128,
    57027948061283099317671673937496946996412416.0F128,
    512829256101.0F128,
    8815296701808550493421309771596155584512.0F128,
    1918805208198312310092547265227.0F128,
    99680639255733807.0F128,
    313647272226958893709907781719.0F128,
    534434342549592762863366619879590707855360.0F128,
    1751643652514709.0F128,
    24084146046683127013882581681582088.0F128,
    1282076.0F128,
    13590701668411111769.0F128,
    62207549230439503653.0F128,
    144040025133692457990548614076288499712.0F128,
    11981724905403945793356785358565397335132602368.0F128,
    1823479497818478859136796209626919944362858664695955456.0F128,
    4649.0F128,
    2095541338428713427585867932062430298743231209275392.0F128,
    605377488765896342050766363050545174870818291712.0F128,
    11488350477184223.0F128,
    9492972359709013710789022084605392379617455653257216.0F128,
    36826148417259.0F128,
    554404239122129842026250702689.0F128,
    2804528919100.0F128,
    127.0F128,
    66823885107232870336040073990324.0F128,
    297736625249.0F128,
    3701132312864550550157874952341371337719347203092250624.0F128,
    107247048428.0F128
  };
  for (int i = 0; i < 34; ++i)
    if (testflt128_192 (s_192[i]) != flt128_192[i])
      __builtin_abort ();
  for (int i = 0; i < 34; ++i)
    if (testflt128u_192 (u_192[i]) != flt128u_192[i])
      __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 575
  static _Float128 flt128_575[] = {
    822555268170764275096048134868384975231305202380698070398256893835345920.0F128,
    -960580267694575830808697063169243925424347053477730475548747760281578375092219925810414573005477242346668032.0F128,
    33504080263976494448954627475165766133582184724974885918953650948043300306793972216863395126909133067122418159809305365193504587776.0F128,
    275983725374553564148936957707321540608.0F128,
    5534912144897227754137156977371639095192412221957522338641107839687274928618580082609389790489874004597965113744368228739650952266120186965187634240183436521269153476116480.0F128,
    1412920302762671055711845665320769739585982745090302228751251561257591917233120715027663177911819317605963828665882521916923707392.0F128,
    -262974997977953570994865210107604174211285573449595140085961138156042539763761152.0F128,
    -92488905333378799268618025132022457141142846570320249542701164032605273639863975936.0F128,
    242604167696163732697906496386839380754432.0F128,
    -3523803651131338645439245946293.0F128,
    -5147220779398204849222374563179412133730483913244844947741095427844771020506369407923839149503287374038736861390994705329184147880909168291858806583886610432.0F128,
    -126995956651641937332005246092202760396991711130361124184051111962275756857424469430504968451843424256.0F128,
    8137926360495.0F128,
    -15994393111836746332671329788635258.0F128,
    -277068516868681202554828866807401284897736575250260327862135188106751832616437168642952110232327515317207040.0F128,
    12643256666940489874033990964997310311509982541568852403544135424197738165753506401380990976.0F128,
    197250790460297242975596746662998771990764978176.0F128,
    2003391279347376998472.0F128,
    -199877387236416475658211887841938078116745459015943716864.0F128,
    683783725793437346966376731991835350216389560350369725901413018663785858547865033572885485563448799017573485017347368404816660544180811049467904.0F128,
    13527430925075101894748577029275390536381026872613143284679822016512.0F128,
    539267000300803493510458136103246882259019817595681864105782809148075261013592028608675098514927074416787456.0F128,
    25132435181738021677664552852329012575221796248107329953164935247044160207130354864627942162432.0F128,
    -24501129715197464074815490290653.0F128,
    -26621511339033230503491791253914733242220544.0F128,
    219726795681725191949095808767196088027323027463729625239897408186970438805069530998505472.0F128,
    142706206515281341916417852232439290189748851664859866651282555201592789754864805842059991220441617268736.0F128,
    -1272097813202031618710288063584910381967486400606337174633920325485235383013308628992.0F128,
    104580584066897755717617980935051170305797669115984125432799736278374300011999760896397625133977276440200975782266619201323008.0F128,
    -10163452549280413821027501723364683055953700133730297193238300661557892457130680244331940377983114543931479834308368189407852102459256936746559008186557007921152.0F128,
    -1462817702603947401421838547412731245576629932826602450317303690796368281340685443455159080277069867736216994863788876540424722028886424027136.0F128,
    -1004473459167555639043426932334304453164309296447488.0F128,
    383945882095471823332216311173956128684860565442900813809054240626596219564185981250247929792487147923720686617427927221102360379955085312.0F128,
    147266903774875157001493887893421894471609745020407505370480640.0F128
  };
  static _Float128 flt128u_575[] = {
    340315902121482071031.0F128,
    9193736781349493374149172723522049989237037596672.0F128,
    121133456126887617775249483436586393077503068671965236572261282102895601164339904512.0F128,
    1253811282917666038992497.0F128,
    279807426767721176279253888473523001912720192704990464927491539867791671603022985691136.0F128,
    4763192686302836059965684032432862322867369410560.0F128,
    19433750446582365356875213925336732513880424973437320406724993874129714386347241802580335495811686203392.0F128,
    8615689860907972907203187028321797859877386013383767881250826182682427913148188824772809437492048511967461413139431335435390421932095562711387007040942408370667651072.0F128,
    126055589776274659515356020606486933259536337762793314648917307764206055685941649262118277933003906979239670868955670671312897309994725986907806357486538234999603200.0F128,
    34636325529158225079379169125604750695785810484482739930710385070599465675115027923570016766582469711320673437462251387815460864.0F128,
    2295982750677874548137685137480985746757882615322149650432.0F128,
    22288650253829612832302454550260146257726013440.0F128,
    61551827.0F128,
    948415991495935226718622697967024239258764159275032239689900905479457935391294424204960412146551901344394652585549587358170098052366336.0F128,
    7599947921908039117808602805272900645537701743475990438308994289927813380793983514791799884349440.0F128,
    3064098671438076295010586583414642942579869059363710430687661115226367832562244997089071440248013792356608654440236754254640577193658338300579944911876551907294312398848.0F128,
    26163216482276433755253744705785501643665555701904644656073951369763934041725743914298920119135277939192496128.0F128,
    1083530146709801198539441549736949272615707866142747675126337487600174059213906750437224937669383865518151504262638122920877713397402240447485732907072897115226112.0F128,
    241446995995054305582384233456322524985744615968604160.0F128,
    224319712854.0F128,
    1851847735563213275.0F128,
    3517907813008404838784133683859253760.0F128,
    57026061017409510123542169719303831161096310734855482941686454210514675616939245568.0F128,
    218054639772618074096850378810323562095353038053985944696037552052916135283715799629412817614929920.0F128,
    1035184782769221379.0F128,
    20229959242348674822834301353257600173306714018005091825486635184900252137125196224692061477495530409091482128339697664.0F128,
    48688062002166777196074419660880812364369698930536203875840059698600317657977119368587792531578529291152047948106379901115479025495192432692355212848922624.0F128,
    38974159722814402881994907079236517852974167599450685098668223152330886687288507721175784841029076691372600892770484224.0F128,
    195268331869690963115384309853070885336463825745125450367383853651197952.0F128,
    131384791058457562831689753115846222841883611947373268365763186683292391066729693706687923355648.0F128,
    1334982489788592107403503927792629186560.0F128,
    2146.0F128,
    25165296015221802429838428736907888.0F128,
    6254.0F128
  };
  for (int i = 0; i < 34; ++i)
    if (testflt128_575 (s_575[i]) != flt128_575[i])
      __builtin_abort ();
  for (int i = 0; i < 34; ++i)
    if (testflt128u_575 (u_575[i]) != flt128u_575[i])
      __builtin_abort ();
#endif
#endif
}
