/* PR c/102989 */
/* { dg-do run { target { bitint && int32plus } } } */
/* { dg-options "-std=c2x -pedantic-errors" } */
/* { dg-skip-if "" { ! run_expensive_tests }  { "*" } { "-O0" "-O2" } } */
/* { dg-skip-if "" { ! run_expensive_tests } { "-flto" } { "" } } */

#if __BITINT_MAXWIDTH__ >= 135
__attribute__((noipa)) void
test_135 (_BitInt(135) *p, _BitInt(39) *q, int i)
{
  p[3] = p[0] / p[1];
  p[4] = p[2] / *q;
  p[5] = p[i] % p[1 + i];
  p[6] = p[2 + i] % q[i];
}
#endif

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) void
test_192 (_BitInt(192) *p, _BitInt(62) *q, int i)
{
  p[3] = p[0] / p[1];
  p[4] = p[2] / *q;
  p[5] = p[i] % p[1 + i];
  p[6] = p[2 + i] % q[i];
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) void
test_575 (_BitInt(575) *p, _BitInt(125) *q, int i)
{
  p[3] = p[0] / p[1];
  p[4] = p[2] / *q;
  p[5] = p[i] % p[1 + i];
  p[6] = p[2 + i] % q[i];
}
#endif

int
main ()
{
#if __BITINT_MAXWIDTH__ >= 135
  static _BitInt(135) s135[] = {
    11379259456099690377988816293288418659013wb,
    -18507519859761926375595173102925837392wb,
    -3487341362606172228883239379216537732914wb,
    0, 0, 0, 0,
    -18302253895694594136150902133229wb,
    2910721282054679865681699220999829323779wb,
    -17020765241462394475777917185801328548533wb,
    0, 0, 0, 0,
    18652952612120070842749648336935165019219wb,
    -1wb,
    -2328827552140837061029007041281845428062wb,
    0, 0, 0, 0,
    4586448317141516754412034429451793085778wb,
    302326133131500453732826275685wb,
    -13254392454085872482685218784341305341217wb,
    0, 0, 0, 0,
    -614wb,
    16712959282178433685159137405wb,
    15642262205867583373380008091954500325wb,
    -27731730774wb,
    0wb,
    -75263829692564968827327018348wb,
    -18302253895694594136150902133229wb,
    -35227765213wb,
    -18652952612120070842749648336935165019219wb,
    112934753510539598517482519823570410wb,
    0wb,
    -3452wb,
    15170532132wb,
    -315580772716330297206790923436697746219wb,
    126779339685614070998610275358wb,
    -19wb
  };
  static _BitInt(39) s39[] = {
    -208660914188wb,
    226148009090wb,
    -20621wb,
    42wb
  };
  for (int i = 0; i < 4; ++i)
    {
      test_135 (s135 + 7 * i, s39 + i, 0);
      for (int j = 0; j < 4; ++j)
	if (s135[7 * i + 3 + j] != s135[7 * 4 + 4 * i + j])
	  __builtin_abort ();
    }
#endif
#if __BITINT_MAXWIDTH__ >= 192
  static _BitInt(192) s192[] = {
    -2179289138164349400542345646041597314396798352437085702063wb,
    -79910962432789464031897580939163427724139130993wb,
    -3036473005246707700116012885952806814462013063553154406939wb,
    0, 0, 0, 0,
    641265343041674918120574087098wb,
    -72968858271155659573911879940731439944647195520825153965wb,
    2701717062040203003887103138051480805185032453926240220524wb,
    0, 0, 0, 0,
    -841691204113630961349106466971783187865820857103239354134wb,
    3wb,
    -87971197399776002207343095550078219wb,
    0, 0, 0, 0,
    1975530920339244356926809414608241391203379490466789216052wb,
    -1491609620853264847219953011450130087411551266523269wb,
    -1446625088493520499379069533952596205wb,
    0, 0, 0, 0,
    27271466539wb,
    1706692225050149442221770028739016905019wb,
    -79245495764706738784157700565393118980948358836wb,
    -1501915295097973757wb,
    0wb,
    4771029735868622050569106388224414265428wb,
    641265343041674918120574087098wb,
    333711124246457812wb,
    -280563734704543653783035488990594395955273619034413118044wb,
    -11314906111712376578wb,
    -2wb,
    -2479408421589529wb,
    -1324428wb,
    -11301758503855628901398980734004657wb,
    1373411796501852981487559368499793073469647909100920wb,
    -109wb
  };
  static _BitInt(62) s62[] = {
    -1779156757544544378wb,
    566275460772898254wb,
    7774805776666105wb,
    128wb
  };
  for (int i = 0; i < 4; ++i)
    {
      test_192 (s192 + 7 * i, s62 + i, 0);
      for (int j = 0; j < 4; ++j)
	if (s192[7 * i + 3 + j] != s192[7 * 4 + 4 * i + j])
	  __builtin_abort ();
    }
#endif
#if __BITINT_MAXWIDTH__ >= 575
  static _BitInt(575) s575[] = {
    -46295454425650349106237210715560972814514774894381316941718135777652722445546437187679065682949497046056192846156902024414635126978980056110286059194406244047429103543013567wb,
    8168911130831183937943637579544406842555974190640492967747336926965525847745100099776294868623258477082653103560744709659980631459947315392636659059426713543595666476280533wb,
    -35562636740560878776057515364478086997557966107967281638887951768166903062463010597490396666936792092197907362468852658846219038084825902297279012227062238709275022706654710wb,
    0, 0, 0, 0,
    8943720225181967953483417970wb,
    -5686323784402794959708902425053022672027524027657863695096812917030055678499948429234881641591266594283291408732579354863768974925810198523510127753699305465302067821wb,
    45545655058039702583745674825335158540648677810736798412180196426599514263661272184545433928331514411963531127261916383264154901783937763805071704477825859668914160192614845wb,
    0, 0, 0, 0,
    50424935157410302671220896696045811569932594372403814676921199727418115659236492512040645301161966980307514350263276765199536014825688175664310129375564263158984wb,
    -7wb,
    -1570414268527860342275074326241251266943768106178059338676497087694509262100926288185672140837995480549018141550944901112529623354869552332831768648238175848946606383367442wb,
    0, 0, 0, 0,
    33743599683183012321962199340752013311691198627837686174760810997243129260923502613536719907475631360213576483574943246620765095970215288302282988013296681749186377007244629wb,
    -241344364975185779312145695113143874342953936016290256207617251781961618409457239212648767218870128884542434148wb,
    264442076257762743508952577439304094891926651736030778233607159152726518015778933421402285405943871924053070093963838538880775338376789919798084050039162wb,
    0, 0, 0, 0,
    -5wb,
    5102554304763340573123278154007968305825944534675387388100485979831828339912883404866537264221784637582259122678928387415569088293221166wb,
    -5450898771494429416519022817838938601734903941178852102981451142825093206820936688797591339833204660642927328353178476114731969679243479147102763897272676329450771161610902wb,
    -27841416716804082903535753217607970wb,
    0wb,
    2845786405948228702992300882035725001599103765023382470517698884483710061812613500615722877137078798659301720051530203483092161498954792wb,
    8943720225181967953483417970wb,
    14857023063025350938701283170104334549wb,
    -7203562165344328953031556670863687367133227767486259239560171389631159379890927501720092185880280997186787764323325252171362287832241167952044304196509180451283wb,
    193782868826267453015550702420724985315443493285153355021508389301944425453072371810496604181725982879795555170278476391923261741289049794434571591514767wb,
    3wb,
    -5203319495353646668wb,
    -139815154526820696318711149230487844769233301636772309388492158wb,
    -323204355193745164479045143032958628560847774063940216640778815817376770038460708119250193248428869489076997487384931038wb,
    180305213672139436589458419226578301650781616412684462286468318018185661952458180767935939240752755560277833245wb,
    316649622804067950787613592683370wb
  };
  static _BitInt(125) s125[] = {
    -6969575357064287919545125499931812390wb,
    16004593655673074838414651760840291513wb,
    -8103989160857077722wb,
    -818188468095495446473587377169784wb
  };
  for (int i = 0; i < 4; ++i)
    {
      test_575 (s575 + 7 * i, s125 + i, 0);
      for (int j = 0; j < 4; ++j)
	if (s575[7 * i + 3 + j] != s575[7 * 4 + 4 * i + j])
	  __builtin_abort ();
    }
#endif
}
