/* PR c/102989 */
/* { dg-do run { target bitint } } */
/* { dg-require-effective-target fenv_exceptions } */
/* { dg-options "-std=c2x" } */

#include <fenv.h>

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) _BitInt(192)
tests192_32 (_Decimal32 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(192)
testu192_32 (_Decimal32 d)
{
  return d;
}

__attribute__((noipa)) _BitInt(192)
tests192_64 (_Decimal64 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(192)
testu192_64 (_Decimal64 d)
{
  return d;
}

__attribute__((noipa)) _BitInt(192)
tests192_128 (_Decimal128 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(192)
testu192_128 (_Decimal128 d)
{
  return d;
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) _BitInt(575)
tests575_32 (_Decimal32 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(575)
testu575_32 (_Decimal32 d)
{
  return d;
}

__attribute__((noipa)) _BitInt(575)
tests575_64 (_Decimal64 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(575)
testu575_64 (_Decimal64 d)
{
  return d;
}

__attribute__((noipa)) _BitInt(575)
tests575_128 (_Decimal128 d)
{
  return d;
}

__attribute__((noipa)) unsigned _BitInt(575)
testu575_128 (_Decimal128 d)
{
  return d;
}
#endif

__attribute__((noipa)) void
check_invalid (int test, int inv)
{
  if (!test)
    __builtin_abort ();
  if ((!fetestexcept (FE_INVALID)) != (!inv))
    __builtin_abort ();
  feclearexcept (FE_INVALID);
}

int
main ()
{
#if __BITINT_MAXWIDTH__ >= 192
  check_invalid (tests192_32 (__builtin_infd32 ()) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (tests192_32 (-__builtin_infd32 ()) == -3138550867693340381917894711603833208051177722232017256447wb - 1wb, 1);
  check_invalid (tests192_32 (__builtin_nand32 ("")) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (tests192_32 (-313855.0e+52DF) == -3138550000000000000000000000000000000000000000000000000000wb, 0);
  check_invalid (tests192_32 (-313855.1e+52DF) == -3138550867693340381917894711603833208051177722232017256447wb - 1wb, 1);
  check_invalid (tests192_32 (313855.0e+52DF) == 3138550000000000000000000000000000000000000000000000000000wb, 0);
  check_invalid (tests192_32 (313855.1e+52DF) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (testu192_32 (__builtin_infd32 ()) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
  check_invalid (testu192_32 (-__builtin_infd32 ()) == 0uwb, 1);
  check_invalid (testu192_32 (__builtin_nand32 ("")) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
  check_invalid (testu192_32 (-0.9999999DF) == 0uwb, 0);
  check_invalid (testu192_32 (-1.0DF) == 0uwb, 1);
  check_invalid (testu192_32 (6277101.0e+51DF) == 6277101000000000000000000000000000000000000000000000000000uwb, 0);
  check_invalid (testu192_32 (6277102.0e+51DF) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
  check_invalid (tests192_64 (__builtin_infd64 ()) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (tests192_64 (-__builtin_infd64 ()) == -3138550867693340381917894711603833208051177722232017256447wb - 1wb, 1);
  check_invalid (tests192_64 (__builtin_nand64 ("")) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (tests192_64 (-313855086769334.0e+43DD) == -3138550867693340000000000000000000000000000000000000000000wb, 0);
  check_invalid (tests192_64 (-313855086769334.1e+43DD) == -3138550867693340381917894711603833208051177722232017256447wb - 1wb, 1);
  check_invalid (tests192_64 (313855086769334.0e+43DD) == 3138550867693340000000000000000000000000000000000000000000wb, 0);
  check_invalid (tests192_64 (313855086769334.1e+43DD) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (testu192_64 (__builtin_infd64 ()) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
  check_invalid (testu192_64 (-__builtin_infd64 ()) == 0wb, 1);
  check_invalid (testu192_64 (__builtin_nand64 ("")) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
  check_invalid (testu192_64 (-0.9999999999999999DD) == 0uwb, 0);
  check_invalid (testu192_64 (-1.0DD) == 0uwb, 1);
  check_invalid (testu192_64 (627710173538668.0e+43DD) == 6277101735386680000000000000000000000000000000000000000000uwb, 0);
  check_invalid (testu192_64 (627710173538668.1e+43DD) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
  check_invalid (tests192_128 (__builtin_infd128 ()) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (tests192_128 (-__builtin_infd128 ()) == -3138550867693340381917894711603833208051177722232017256447wb - 1wb, 1);
  check_invalid (tests192_128 (__builtin_nand128 ("")) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (tests192_128 (-3138550867693340381917894711603833.0e+24DL) == -3138550867693340381917894711603833000000000000000000000000wb, 0);
  check_invalid (tests192_128 (-3138550867693340381917894711603834.0e+24DL) == -3138550867693340381917894711603833208051177722232017256447wb - 1wb, 1);
  check_invalid (tests192_128 (3138550867693340381917894711603833.0e+24DL) == 3138550867693340381917894711603833000000000000000000000000wb, 0);
  check_invalid (tests192_128 (3138550867693340381917894711603834.0e+24DL) == 3138550867693340381917894711603833208051177722232017256447wb, 1);
  check_invalid (testu192_128 (__builtin_infd128 ()) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
  check_invalid (testu192_128 (-__builtin_infd128 ()) == 0wb, 1);
  check_invalid (testu192_128 (__builtin_nand128 ("")) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
  check_invalid (testu192_128 (-0.9999999999999999999999999999999999DL) == 0uwb, 0);
  check_invalid (testu192_128 (-1.0DL) == 0uwb, 1);
  check_invalid (testu192_128 (6277101735386680763835789423207666.0e+24DL) == 6277101735386680763835789423207666000000000000000000000000uwb, 0);
  check_invalid (testu192_128 (6277101735386680763835789423207667.0e+24DL) == 6277101735386680763835789423207666416102355444464034512895uwb, 1);
#endif
#if __BITINT_MAXWIDTH__ >= 575
  check_invalid (tests575_32 (__builtin_infd32 ()) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (tests575_32 (-__builtin_infd32 ()) == -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1wb, 1);
  check_invalid (tests575_32 (__builtin_nand32 ("")) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (tests575_32 (-9999999e+90DF) == -9999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb, 0);
  check_invalid (tests575_32 (9999999e+90DF) == 9999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb, 0);
  check_invalid (testu575_32 (__builtin_infd32 ()) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
  check_invalid (testu575_32 (-__builtin_infd32 ()) == 0uwb, 1);
  check_invalid (testu575_32 (__builtin_nand32 ("")) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
  check_invalid (testu575_32 (-0.9999999DF) == 0uwb, 0);
  check_invalid (testu575_32 (-1.0DF) == 0uwb, 1);
  check_invalid (testu575_32 (9999999e+90DF) == 9999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb, 0);
  check_invalid (tests575_64 (__builtin_infd64 ()) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (tests575_64 (-__builtin_infd64 ()) == -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1wb, 1);
  check_invalid (tests575_64 (__builtin_nand64 ("")) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (tests575_64 (-6183260036827613.0e+157DD) == -61832600368276130000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb, 0);
  check_invalid (tests575_64 (-6183260036827614.0e+157DD) == -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1wb, 1);
  check_invalid (tests575_64 (6183260036827613.0e+157DD) == 61832600368276130000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb, 0);
  check_invalid (tests575_64 (6183260036827614.0e+157DD) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (testu575_64 (__builtin_infd64 ()) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
  check_invalid (testu575_64 (-__builtin_infd64 ()) == 0wb, 1);
  check_invalid (testu575_64 (__builtin_nand64 ("")) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
  check_invalid (testu575_64 (-0.9999999999999999DD) == 0uwb, 0);
  check_invalid (testu575_64 (-1.0DD) == 0uwb, 1);
  check_invalid (testu575_64 (1236652007365522.0e+158DD) == 123665200736552200000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb, 0);
  check_invalid (testu575_64 (1236652007365523.0e+158DD) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
  check_invalid (tests575_128 (__builtin_infd128 ()) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (tests575_128 (-__builtin_infd128 ()) == -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1wb, 1);
  check_invalid (tests575_128 (__builtin_nand128 ("")) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (tests575_128 (-6183260036827613351512563025491179.0e+139DL) == -61832600368276133515125630254911790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb, 0);
  check_invalid (tests575_128 (-618326003682761335151256302549118.0e+140DL) == -61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1wb, 1);
  check_invalid (tests575_128 (6183260036827613351512563025491179.0e+139DL) == 61832600368276133515125630254911790000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb, 0);
  check_invalid (tests575_128 (618326003682761335151256302549118.0e+140DL) == 61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb, 1);
  check_invalid (testu575_128 (__builtin_infd128 ()) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
  check_invalid (testu575_128 (-__builtin_infd128 ()) == 0wb, 1);
  check_invalid (testu575_128 (__builtin_nand128 ("")) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
  check_invalid (testu575_128 (-0.9999999999999999999999999999999999DL) == 0uwb, 0);
  check_invalid (testu575_128 (-1.0DL) == 0uwb, 1);
  check_invalid (testu575_128 (1236652007365522670302512605098235.0e+140DL) == 123665200736552267030251260509823500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb, 0);
  check_invalid (testu575_128 (1236652007365522670302512605098236.0e+140DL) == 123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb, 1);
#endif
}
