/* PR c/102989 */
/* { dg-do run { target bitint } } */
/* { dg-options "-O2 -std=c2x -pedantic-errors" } */

#if __BITINT_MAXWIDTH__ >= 192
__attribute__((noipa)) _Decimal32
tests192 (_BitInt(192) b)
{
  return b;
}

__attribute__((noipa)) _Decimal32
testu192 (unsigned _BitInt(192) b)
{
  return b;
}
#endif

#if __BITINT_MAXWIDTH__ >= 575
__attribute__((noipa)) _Decimal32
tests575 (_BitInt(575) b)
{
  return b;
}

__attribute__((noipa)) _Decimal32
testu575 (unsigned _BitInt(575) b)
{
  return b;
}
#endif

int
main ()
{
  _Decimal32 a, b;
#define CHECK(x, y) (a = (x), b = (y), a != (y) || __builtin_memcmp (&a, &b, sizeof (a)))
#if __BITINT_MAXWIDTH__ >= 192
  if (CHECK (tests192 (0wb), 0.DF)
      || CHECK (tests192 (7wb), 7.DF)
      || CHECK (tests192 (-42wb), -42.DF)
      || CHECK (tests192 (-777777wb), -777777.DF)
      || CHECK (tests192 (9999000wb), 9999000.DF)
      || CHECK (tests192 (-9999999wb), -9999999.DF)
      || CHECK (tests192 (99999994wb), 9999999.e+1DF)
      || CHECK (tests192 (99999995wb), 1000000.e+2DF)
      || CHECK (tests192 (999999900wb), 9999999.e+2DF)
      || CHECK (tests192 (-9999999000wb), -9999999.e+3DF)
      || CHECK (tests192 (999999900000wb), 9999999.e+5DF)
      || CHECK (tests192 (-9999999000000wb), -9999999.e+6DF)
      || CHECK (tests192 (123456700000000000wb), 1234567.e+11DF)
      || CHECK (tests192 (34242310000000000000000000000wb), 3424231e+22DF)
      || CHECK (tests192 (999999900000000000000000000000000000000wb), 9999999.e+32DF)
      || CHECK (tests192 (-999999900000000000000000000000000000000000000000wb), -9999999.e+41DF)
      || CHECK (tests192 (-2138551000000000000000000000000000000000000000000000000000wb), -2138551e+51DF)
      || CHECK (tests192 (-2138551500000000000000000000000000000000000000000000000000wb), -2138552e+51DF)
      || CHECK (tests192 (-2138551499999999999999999999999999999999999999999999999999wb), -2138551e+51DF)
      || CHECK (tests192 (-2138551999999999999999999999999999999999999999999999999999wb), -2138552e+51DF)
      || CHECK (tests192 (-2138552000000000000000000000000000000000000000000000000000wb), -2138552e+51DF)
      || CHECK (tests192 (-2138552500000000000000000000000000000000000000000000000000wb), -2138552e+51DF)
      || CHECK (tests192 (-2138552500000000000000000000000000000000000000000000000001wb), -2138553e+51DF)
      || CHECK (tests192 (3138550000000000000000000000000000000000000000000000000000wb), 3138550e+51DF)
      || CHECK (tests192 (3138550867693340381917894711603833208051177722232017256447wb), 3138551e+51DF)
      || CHECK (tests192 (-3138550000000000000000000000000000000000000000000000000000wb), -3138550e+51DF)
      || CHECK (tests192 (-3138550867693340381917894711603833208051177722232017256447wb - 1wb), -3138551e+51DF))
    __builtin_abort ();
  if (CHECK (testu192 (0uwb), 0.DF)
      || CHECK (testu192 (7uwb), 7.DF)
      || CHECK (testu192 (42uwb), 42.DF)
      || CHECK (testu192 (77777uwb), 77777.DF)
      || CHECK (testu192 (9999000uwb), 9999000.DF)
      || CHECK (testu192 (999999900uwb), 9999999.e+2DF)
      || CHECK (testu192 (999999949uwb), 9999999.e+2DF)
      || CHECK (testu192 (9999999000uwb), 9999999.e+3DF)
      || CHECK (testu192 (9999999499uwb), 9999999.e+3DF)
      || CHECK (testu192 (999999900000uwb), 9999999.e+5DF)
      || CHECK (testu192 (9999999000000uwb), 9999999.e+6DF)
      || CHECK (testu192 (123456700000000uwb), 1234567.e+8DF)
      || CHECK (testu192 (34242310000000000000000000000uwb), 3424231e+22DF)
      || CHECK (testu192 (9999999000000000000000000000000000000000uwb), 9999999.e+33DF)
      || CHECK (testu192 (61893590000000000000000000000000000000000000000000000uwb), 6189359e+46DF)
      || CHECK (testu192 (61893595000000000000000000000000000000000000000000000uwb), 6189360e+46DF)
      || CHECK (testu192 (61893594999999999999999999999999999999999999999999999uwb), 6189359e+46DF)
      || CHECK (testu192 (61893599999999999999999999999999999999999999999999999uwb), 6189360e+46DF)
      || CHECK (testu192 (61893580000000000000000000000000000000000000000000000uwb), 6189358e+46DF)
      || CHECK (testu192 (61893585000000000000000000000000000000000000000000000uwb), 6189358e+46DF)
      || CHECK (testu192 (61893585000000000000000000000000000000000000000000001uwb), 6189359e+46DF)
      || CHECK (testu192 (999999900000000000000000000000000000000000000000000000uwb), 9999999.e+47DF)
      || CHECK (testu192 (6277100500000000000000000000000000000000000000000000000000uwb), 6277100e+51DF)
      || CHECK (testu192 (6277100500000000000000000000000000000000000000000000000001uwb), 6277101e+51DF)
      || CHECK (testu192 (6277100500000000000000000000000000000010000000000000000000uwb), 6277101e+51DF)
      || CHECK (testu192 (6277101000000000000000000000000000000000000000000000000000uwb), 6277101e+51DF)
      || CHECK (testu192 (6277101499999999999999999999999999999999999999999999999999uwb), 6277101e+51DF)
      || CHECK (testu192 (6277101500000000000000000000000000000000000000000000000000uwb), 6277102e+51DF)
      || CHECK (testu192 (6277101735386680763835789423207666416102355444464034512895uwb), 6277102e+51DF))
    __builtin_abort ();
#endif
#if __BITINT_MAXWIDTH__ >= 575
  if (CHECK (tests575 (0wb), 0.DF)
      || CHECK (tests575 (7wb), 7.DF)
      || CHECK (tests575 (-42wb), -42.DF)
      || CHECK (tests575 (-44444wb), -44444.DF)
      || CHECK (tests575 (9999000wb), 9999000.DF)
      || CHECK (tests575 (-9999999wb), -9999999.DF)
      || CHECK (tests575 (999999900wb), 9999999.e+2DF)
      || CHECK (tests575 (-9999999000wb), -9999999.e+3DF)
      || CHECK (tests575 (999999900000wb), 9999999.e+5DF)
      || CHECK (tests575 (999999949999wb), 9999999.e+5DF)
      || CHECK (tests575 (-99999990000000wb), -9999999.e+7DF)
      || CHECK (tests575 (1234567000000000000000000wb), 1234567.e+18DF)
      || CHECK (tests575 (3424231000000000000000000000000000000000wb), 3424231e+33DF)
      || CHECK (tests575 (99999990000000000000000000000000000000000000000wb), 9999999.e+40DF)
      || CHECK (tests575 (-9999999000000000000000000000000000000000000000000000000000000000000000wb), -9999999.e+63DF)
      || CHECK (tests575 (-2138559000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb), -2138559e+90DF)
      || CHECK (tests575 (-2138559500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb), -2138560e+90DF)
      || CHECK (tests575 (-2138559499999999999999999999999999999999999999999999999999999999999999999999999999999999999999999wb), -2138559e+90DF)
      || CHECK (tests575 (-2138559999999999999999999999999999999999999999999999999999999999999999999999999999999999999999999wb), -2138560e+90DF)
      || CHECK (tests575 (-2138558000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb), -2138558e+90DF)
      || CHECK (tests575 (-2138558500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb), -2138558e+90DF)
      || CHECK (tests575 (-2138558500000000000000000000000000000000000000000000000000000000000000000000000000000000000000001wb), -2138559e+90DF)
      || CHECK (tests575 (9999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb), 9999999e+90DF)
      || CHECK (tests575 (9999999499999999999999999999999999999999999999999999999999999999999999999999999999999999999999999wb), 9999999e+90DF)
      || CHECK (tests575 (9999999500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb), __builtin_infd32 ())
      || CHECK (tests575 (-9999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb), -9999999e+90DF)
      || CHECK (tests575 (-9999999499999999999999999999999999999999999999999999999999999999999999999999999999999999999999999wb), -9999999e+90DF)
      || CHECK (tests575 (-9999999500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000wb), -__builtin_infd32 ())
      || CHECK (tests575 (61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb), __builtin_infd32 ())
      || CHECK (tests575 (-61832600368276133515125630254911797508782837275302959978515764023224306276632966792579100265310761247399417856504034834837841258576687802491886538775473291979151693037174783wb - 1wb), -__builtin_infd32 ()))
    __builtin_abort ();
  if (CHECK (testu575 (0uwb), 0.DF)
      || CHECK (testu575 (17uwb), 17.DF)
      || CHECK (testu575 (420uwb), 420.DF)
      || CHECK (testu575 (888uwb), 888.DF)
      || CHECK (testu575 (9999000uwb), 9999000.DF)
      || CHECK (testu575 (99999990000000uwb), 9999999.e+7DF)
      || CHECK (testu575 (99999994999999uwb), 9999999.e+7DF)
      || CHECK (testu575 (9999999000000000uwb), 9999999.e+9DF)
      || CHECK (testu575 (9999999499999999uwb), 9999999.e+9DF)
      || CHECK (testu575 (99999990000000000000uwb), 9999999.e+13DF)
      || CHECK (testu575 (99999994999999999999uwb), 9999999.e+13DF)
      || CHECK (testu575 (9999999000000000000000uwb), 9999999.e+15DF)
      || CHECK (testu575 (9999999499999999999999uwb), 9999999.e+15DF)
      || CHECK (testu575 (1234567000000000000000000uwb), 1234567.e+18DF)
      || CHECK (testu575 (34242310000000000000000000000uwb), 3424231e+22DF)
      || CHECK (testu575 (9999999000000000000000000000000000000000uwb), 9999999.e+33DF)
      || CHECK (testu575 (61893590000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb), 6189359e+88DF)
      || CHECK (testu575 (61893595000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb), 6189360e+88DF)
      || CHECK (testu575 (61893594999999999999999999999999999999999999999999999999999999999999999999999999999999999999999uwb), 6189359e+88DF)
      || CHECK (testu575 (61893599999999999999999999999999999999999999999999999999999999999999999999999999999999999999999uwb), 6189360e+88DF)
      || CHECK (testu575 (61893580000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb), 6189358e+88DF)
      || CHECK (testu575 (61893585000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb), 6189358e+88DF)
      || CHECK (testu575 (61893585000000000000000000000000000000000000000000000000000000000000000000000000000000000000001uwb), 6189359e+88DF)
      || CHECK (testu575 (9999999000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb), 9999999.e+90DF)
      || CHECK (tests575 (9999999499999999999999999999999999999999999999999999999999999999999999999999999999999999999999999uwb), 9999999e+90DF)
      || CHECK (tests575 (9999999500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000uwb), __builtin_infd32 ())
      || CHECK (testu575 (123665200736552267030251260509823595017565674550605919957031528046448612553265933585158200530621522494798835713008069669675682517153375604983773077550946583958303386074349567uwb), __builtin_infd32 ()))
    __builtin_abort ();
#endif
}
