#ifndef PCREG_EX_H
#define PCREG_EX_H

/*
 * pcreg_ex.h - object for dynamic  Perl compatible Regular Expression storage.
 * 
 * include LICENSE
 */

#include <pcre.h>

#include <appclass.h>
#include <arraystr.h>

/* flags indicating no extract of sub pattern, just return ovector */
#define  PCREG_NO_EXTRACT  (1 << 16)
#define  PCREG_EX_MASK     (PCREG_NO_EXTRACT - 1)
 
typedef struct _Pcregex Pcregex;

struct _Pcregex {
   AppClass parent;
   char *pattern;       /* the regex string */
   pcre *creg;          /* the compiled regex, null if not compiled */
   int options;         /* flags for compile regex -see pcre.h */
   int exflags;         /* pcreg_ex flags  */
   int nmatch;          /* number of match expected */
   int *ovector;        /* array of int for substring info  */
   ArrayStr *matchStr;     /* arrayObj pointer of matched string */
   unsigned char *tableptr; /* Pointer to character tables, or NULL */
};

/*
 * prototypes
 */
Pcregex *pcregex_new( char *pattern, int options, int nmatch );
void pcregex_construct( Pcregex *re, char *pattern, int options, int nmatch );
void pcregex_destroy(void *re);

int pcregex_exec(Pcregex *re, char *subject, int length );
pcre *pcregex_compile(Pcregex *re);
char *pcregex_subst(Pcregex *re, char *subject, int len, char *subst, int i );

int pcregex_str_cmp( AppClass *d1, AppClass *d2 );

#endif /* PCREG_EX_H */
