
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/


#include <string.h>
#include "runtime.h"

/* index.c -- Implement the INDEX intrinsic function */


#define index2 prefix(index2)

G95_DINT index2(char *string, char *sub, G95_DINT string_len,
		G95_DINT sub_len) {
G95_DINT i, max_index;

    if (sub_len == 0)
	return (string_len > 0) ? 1 : 0;

    max_index = string_len - sub_len;

    for(i=0; i<=max_index; i++)
	if (strncmp(string+i, sub, sub_len) == 0)
	    return i+1;

    return 0;
}


#define index3 prefix(index3)

G95_DINT index3(char *string, char *sub, G95_DINT *back, G95_DINT string_len,
		G95_DINT sub_len) {
G95_DINT i, max_index;

    if (sub_len > string_len)
	return 0;

    if (back == NULL || *back == 0)
	return index2(string, sub, string_len, sub_len);

    max_index = string_len - sub_len;

    for(i=max_index; i>=0; i--)
	if (strncmp(string+i, sub, sub_len) == 0)
	    return i+1;

    return 0;
}
