
#include "comb/composition-colex.h"
#include "comb/comp2comb.h"

#include "comb/comb-print.h"
#include "nextarg.h"

#include "fxttypes.h"
#include "fxtio.h"


//% Generating all compositions of n into k parts
//% in co-lexicographic (colex) order.

// Cf. comb/composition-colex2-demo.cc

//#define TIMING  // uncomment to disable printing

int
main(int argc, char **argv)
{
    ulong n = 3;
    NXARG(n, "Compositions of n (n>=1)");
    ulong k = 5;
    NXARG(k, "Into k parts  (k-compositions of n) (k>=1) ");
    bool rq = 0;
    NXARG(rq, "Whether to reverse order");

    composition_colex P(n, k);

    if ( rq )  P.last();
    else       P.first();

    ulong ct = 0;

#if defined TIMING
    if ( rq )  do { ++ct; }  while  ( P.prev() != k );
    else       do { ++ct; }  while  ( P.next() != k );

#else
    ulong K = n;
    ulong N = n + k -1;
    ulong *c = new ulong[K];
    const ulong *p = P.data();
    ulong q = k-1;
    do
    {
        ++ct;
        cout << setw(4) << ct << ":";
        P.print("    ", true);
        cout << "  " << q << "  ";

        comp2comb(p, k, c);
        print_set_as_deltaset("    ", c, K, N);
        print_vec("    ", c, K, false);

        cout << endl;

        if ( rq )  q = P.prev();
        else       q = P.next();
    }
    while ( q != k );
    delete [] c;

#endif

    cout << " ct=" << ct << endl;

    return 0;
}
// -------------------------


/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

----------- next():

 time ./bin 30 10 0
arg 1: 30 == n  [Compositions of n (n>=1)]  default=3
arg 2: 10 == k  [Into k parts  (k-compositions of n) (k>=1) ]  default=5
arg 3: 0 == rq  [Whether to reverse order]  default=0
 ct=211915132
0.35user 0.00system 0:00.35elapsed 99%CPU
 ==> 211915132/0.35 == 605,471,805 per second

 time ./bin 10 30 0
arg 1: 10 == n  [Compositions of n (n>=1)]  default=3
arg 2: 30 == k  [Into k parts  (k-compositions of n) (k>=1) ]  default=5
arg 3: 0 == rq  [Whether to reverse order]  default=0
 ct=635745396
1.92user 0.00system 0:01.93elapsed 99%CPU
 ==> 635745396/1.92 == 331,117,393 per second

// very sparse case:
 time ./bin 5 100
arg 1: 5 == n  [Compositions of n (n>=1)]  default=3
arg 2: 100 == k  [Into k parts  (k-compositions of n) (k>=1) ]  default=5
arg 3: 0 == rq  [Whether to reverse order]  default=0
 ct=91962520
1.15user 0.00system 0:01.15elapsed 100%CPU
 ==> 91962520/1.15 == 79,967,408 per second

----------- prev():

 time ./bin 30 10 1
arg 1: 30 == n  [Compositions of n (n>=1)]  default=3
arg 2: 10 == k  [Into k parts  (k-compositions of n) (k>=1) ]  default=5
arg 3: 1 == rq  [Whether to reverse order]  default=0
 ct=211915132
0.40user 0.00system 0:00.40elapsed 100%CPU
 ==> 211915132/0.40 == 529,787,830 per second

 time ./bin 10 30 1
arg 1: 10 == n  [Compositions of n (n>=1)]  default=3
arg 2: 30 == k  [Into k parts  (k-compositions of n) (k>=1) ]  default=5
arg 3: 1 == rq  [Whether to reverse order]  default=0
 ct=635745396
1.79user 0.00system 0:01.79elapsed 100%CPU
 ==> 635745396/1.79 == 355,165,025 per second

// very sparse case:
 time ./bin 5 100 1
arg 1: 5 == n  [Compositions of n (n>=1)]  default=3
arg 2: 100 == k  [Into k parts  (k-compositions of n) (k>=1) ]  default=5
arg 3: 1 == rq  [Whether to reverse order]  default=0
 ct=91962520
1.20user 0.00system 0:01.20elapsed 100%CPU
 ==> 91962520/1.20 == 76,635,433 per second
*/

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/composition-colex-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/composition-colex-demo.cc DEMOFLAGS=-DTIMING"
/// End:
