#if !defined  HAVE_SQUARE_WAVE_TRANSFORM_H__
#define       HAVE_SQUARE_WAVE_TRANSFORM_H__
// This file is part of the FXT library.
// Copyright (C) 2011, 2012, 2014, 2023, 2024 Joerg Arndt
// License: GNU General Public License version 3 or later,
// see the file COPYING.txt in the main directory.


#include "fxttypes.h"


//: Square wave transform

// walsh/square-wave-transform.cc:

void square_wave_basis(double *f, ulong n, ulong k);

void swt_normalize(double *f, ulong n);

void square_wave_transform(double *f, ulong ldn, bool nq=true);

void inverse_square_wave_transform(double *f, ulong ldn, bool nq=true);


#endif  // !defined HAVE_SQUARE_WAVE_TRANSFORM_H__
