
#include "comb/setpart-noncrossing-ll.h"

#include "fxtio.h"
#include "fxttypes.h"
#include "jjassert.h"

#include "nextarg.h"

//% Noncrossing set partitions via Catalan restricted growth strings (RGS).
//% Sets are in the form vector< vector<ulong> > for easy traversal,
//%   see the print() method in class setpart_noncrossing_ll.


int
main(int argc, char **argv)
{
    ulong n = 5;
    NXARG(n, "Number of elements");

    setpart_noncrossing_ll P(n);

    ulong ct = 0;
    P.first();
#if defined TIMING
#if defined SETPART_NONCROSSING_LL_OPT
    cout << "SETPART_NONCROSSING_LL_OPT is defined.\n";
#endif
    do  { ++ct; }  while ( P.next() );
#else  // TIMING
    do
    {
        ++ct;
        cout << setw(4) << ct << ":";
        P.print_rgs("  ", true);

        cout << setw(6) << P.num_sets();
        P.print(":  ");

#if 0  // usage example:
        auto VV = P.data();  // has P.num_sets() non-empty sets
        for (const auto & V : VV)
        {
            if ( V.size() == 0 )  { break; }
            for (auto e : V)  { /* do something with e */; }
        }
#endif

        cout << endl;

        jjassert( P.OK() );
    }
    while ( P.next() );
#endif  // TIMING

    cout << " ct=" << ct;  // Catalan number n
    cout << endl;

    return 0;
}
// -------------------------


/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

time ./bin 17
arg 1: 17 == n  [Number of elements]  default=5
 ct=129644790
6.60user 0.00system 0:06.61elapsed 99%CPU
 ==> 129644790/6.60 == 19,643,150 per second
(rather slow: setup_mset_part() at every step)

time ./bin 17
arg 1: 17 == n  [Number of elements]  default=5
SETPART_NONCROSSING_LL_OPT is defined.
 ct=129644790
6.74user 0.00system 0:06.74elapsed 100%CPU
 ==> 129644790/6.74 == 19,235,132 per second
 (even slower...)

*/

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/setpart-noncrossing-ll-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/setpart-noncrossing-ll-demo.cc DEMOFLAGS=-DTIMING"
/// End:
