
#include "comb/ksubset-twoclose-list-rec.h"

#include "comb/comb-print.h"  // print_deltaset_as_set()
#include "aux0/binomial.h"

#include "bits/bitset2set.h"  // deltaset2bitset()
#include "bits/bitcount.h"
#include "bits/bit2pow.h"
#include "bits/bitlow.h"
#include "bits/print-bin.h"
#include "aux0/swap.h"

#include "fxtio.h"
#include "jjassert.h"
#include "nextarg.h"
#include "fxttypes.h"


//% k-subsets (kmin<=k<=kmax) in two-close order with homogeneous moves.
//% Representation as list of elements.
//% Recursive algorithm.

// With kmin==kmax one obtains a two-close order for combinations (n choose k).

// Cf. comb/ksubset-twoclose-demo.cc
// Cf. comb/ksubset-twoclose-rec-demo.cc
// Cf. comb/ksubset-twoclose-list-demo.cc


//#define TIMING  // uncomment to disable printing

ulong ct;

#if defined TIMING
void visit(const ksubset_twoclose_list_rec &)  { ++ct; }

#else
void visit(const ksubset_twoclose_list_rec &C)
{
    ++ct;
    cout << setw(4) << ct << ";";
    C.print_deltaset("    ");
    C.print("    ");
    cout << endl;
}
// -------------------------
#endif  // TIMING


int
main(int argc, char **argv)
{
    ulong n = 6;
    NXARG(n, "Subsets of n-element set.");
    ulong kmin = 2;
    NXARG(kmin, "Minimal number of elements in subsets.");
    ulong kmax = 4;
    NXARG(kmax, "Maximal number of elements in subsets.");

    if ( kmin > kmax )  swap2(kmin, kmax);
    if ( kmax > n )  kmax = n;
    if ( kmin > n )  kmin = n;

    bool w = false;
    NXARG(w, "Whether to modify ordering (bool).");

    ksubset_twoclose_list_rec C(n, w);
    ct = 0;
    C.generate(visit, kmin, kmax);

    cout << "ct=" << ct << endl;

    ulong z = 0;
    for (ulong k=kmin; k<=kmax; ++k)  z += binomial(n, k);
    jjassert( ct==z );

    return 0;
}
// -------------------------


/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

time ./bin 29 0 29
arg 1: 29 == n  [Subsets of n-element set.]  default=6
arg 2: 0 == kmin  [Minimal number of elements in subsets.]  default=2
arg 3: 29 == kmax  [Maximal number of elements in subsets.]  default=4
arg 4: 0 == w  [Whether to modify ordering (bool).]  default=0
ct=536870912
1.77user 0.00system 0:01.77elapsed 100%CPU
 ==> 536870912/1.77 == 303,316,899 per second

time ./bin 29 15 29
arg 1: 29 == n  [Subsets of n-element set.]  default=6
arg 2: 15 == kmin  [Minimal number of elements in subsets.]  default=2
arg 3: 29 == kmax  [Maximal number of elements in subsets.]  default=4
arg 4: 0 == w  [Whether to modify ordering (bool).]  default=0
ct=268435456
1.09user 0.00system 0:01.10elapsed 99%CPU
 ==> 268435456/1.09 == 246,271,060 per second

time ./bin 29 0 15
arg 1: 29 == n  [Subsets of n-element set.]  default=6
arg 2: 0 == kmin  [Minimal number of elements in subsets.]  default=2
arg 3: 15 == kmax  [Maximal number of elements in subsets.]  default=4
arg 4: 0 == w  [Whether to modify ordering (bool).]  default=0
ct=345994216
1.28user 0.00system 0:01.28elapsed 100%CPU
 ==> 345994216/1.28 == 270,307,981 per second

*/


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/ksubset-twoclose-list-rec-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/ksubset-twoclose-list-rec-demo.cc DEMOFLAGS=-DTIMING"
/// End:

