
#include "comb/kperm-lex.h"

#include "comb/check-kpermgen.h"
#include "comb/comb-print.h"

//#include "comb/fact2perm.h"


#include "jjassert.h"

#include "fxttypes.h"
#include "fxtio.h"
#include "nextarg.h"


//% Generate all k-permutations of n elements in lexicographic order.
//% Same as: k-prefixes of permutations of n elements.
//% Same as: arrangements of k out of n elements.

// Cf. comb/kperm-gray-demo.cc for minimal-change order
// Cf. comb/arrangement-rgs-demo.cc for all arrangements

//#define TIMING  // uncomment to disable printing


int
main(int argc, char **argv)
{
    ulong n = 5;
    NXARG(n, "Total of n elements, n>=1");
    jjassert( n >= 1 );

    ulong k = 3;
    NXARG(k, "Prefix length: permutations of k elements, (1<=k<=n)");
    jjassert( k <= n );

    kperm_lex P(n);
    P.first(k);

    ulong ct = 0;
#if defined TIMING

    do { ++ct; }  while ( P.next() );

#else
    const bool dfz = true;  // whether to print dots for zeros
    const ulong *x = P.data();
    const ulong *d = P.d_;
    const ulong *ix = P.invdata();

//    ulong *F = new ulong[n];

    check_kpermgen C(n, k);
    C.first(P.data());

    do
    {
        ++ct;
        cout << setw(4) << ct << ":";
        print_perm("    ", x, k, dfz);  // prefix
        print_perm("", x+k, n-k, dfz);  // rest
        print_mixedradix("    ", d, n-1, dfz);

//        perm2ffact(x, n, F);  // first k k positions same as in d[]
//        print_vec("  ", F, n-1, true);

        print_perm("    ", ix, n, dfz);  // inverse permutation

        cout << endl;

        jjassert( ! C.is_repeat() );
    }
    while ( P.next() );

    jjassert( C.have_all() );

#endif  // TIMING

    cout << " ct=" << ct << endl;

//    delete [] F;

    return 0;
}
// -------------------------


/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

time ./bin 12 12
arg 1: 12 == n  [Total of n elements, n>=1]  default=5
arg 2: 12 == k  [Permutations of k elements, (1<=k<=n)]  default=3
 ct=479001600
6.19user 0.00system 0:06.19elapsed 99%CPU
 ==> 479001600/6.19 == 77,383,134 per second

time ./bin 12 11
arg 1: 12 == n  [Total of n elements, n>=1]  default=5
arg 2: 11 == k  [Permutations of k elements, (1<=k<=n)]  default=3
 ct=479001600
5.92user 0.00system 0:05.92elapsed 100%CPU
 ==> 479001600/5.92 == 80,912,432 per second

time ./bin 12 10
arg 1: 12 == n  [Total of n elements, n>=1]  default=5
arg 2: 10 == k  [Permutations of k elements, (1<=k<=n)]  default=3
 ct=239500800
2.89user 0.00system 0:02.89elapsed 100%CPU
 ==> 239500800/2.89 == 82,872,249 per second

time ./bin 24 6
arg 1: 24 == n  [Total of n elements, n>=1]  default=5
arg 2: 6 == k  [Permutations of k elements, (1<=k<=n)]  default=3
 ct=96909120
0.57user 0.00system 0:00.57elapsed 100%CPU
 ==> 96909120/0.57 == 170,016,000 per second

time ./bin 52 5
arg 1: 52 == n  [Total of n elements, n>=1]  default=5
arg 2: 5 == k  [Permutations of k elements, (1<=k<=n)]  default=3
 ct=311875200
1.48user 0.00system 0:01.48elapsed 99%CPU
 ==> 311875200/1.48 == 210,726,486 per second

time ./bin 100 4
arg 1: 100 == n  [Total of n elements, n>=1]  default=5
arg 2: 4 == k  [Permutations of k elements, (1<=k<=n)]  default=3
 ct=94109400
0.42user 0.00system 0:00.42elapsed 99%CPU
 ==> 94109400/0.42 == 224,070,000 per second
*/


/*
BENCHARGS=12 12
BENCHARGS=12 11
BENCHARGS=12 10
BENCHARGS=24 6
BENCHARGS=52 5
BENCHARGS=100 4
*/


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/kperm-lex-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/kperm-lex-demo.cc DEMOFLAGS=-DTIMING"
/// End:

