#if !defined  HAVE_PERM_STAR_INV_H__
#define       HAVE_PERM_STAR_INV_H__
// This file is part of the FXT library.
// Copyright (C) 2023 Joerg Arndt
// License: GNU General Public License version 3 or later,
// see the file COPYING.txt in the main directory.

#include "comb/perm-rev.h"
#include "fxtio.h"


class perm_star_inv
// Inverse star transposition permutations
//  via permutations by prefix reversals.
{
private:
    perm_rev RV;
    ulong *P;  // permutation
    ulong n;   // permutations of n elements
    ulong i0;   // index to swap with, see next()

    perm_star_inv(const perm_star_inv&) = delete;
    perm_star_inv & operator = (const perm_star_inv&) = delete;

public:
    explicit perm_star_inv(ulong tn)
        : RV( tn )
    {
        n = tn;
        P = new ulong[n];
        first();
    }

    ~perm_star_inv()
    {
        delete [] P;
    }

    const ulong * data()  const  { return P; }

    void first()
    {
        RV.first();
        for (ulong k=0; k < n; ++k)  P[k] = k;
        i0 = 0;
    }

    bool next()
    {
        if ( false == RV.next() )  { return false; }
        const ulong i1 = RV.data()[0];
        swap2( P[i0], P[i1] );
        i0 = i1;
        return true;
    }

    ulong swp0()  const  { return i0; }

    void print(const char *bla, bool dfz=false)  const
    // If dfz is true then Dots are printed For Zeros.
    { print_perm(bla, data(), n, dfz); }
};
// -------------------------



#endif  // !defined HAVE_PERM_STAR_INV_H__
