
#include "walsh/square-wave-transform.h"
// demo-include "walsh/square-wave-transform.cc"

#include "fxtio.h"
#include "fxttypes.h"
#include "jjassert.h"
#include "nextarg.h"

#include <cmath>

//% Show basis of the square wave transform or its inverse.

static inline
void delta_func(double *f, ulong n, ulong d)
{
    for (ulong j=0; j<n; ++j)  { f[j] = 0.0; }
    f[d] = 1.0;
}
// -------------------------

static inline
double norm_l2_sqr(const double *f, ulong n)
{
    double s = 0.0;
    for (ulong j=0; j<n; ++j)
    {
        s += f[j] * f[j];
    }
    s = std::abs( s );
//    s = std::sqrt( s );
    return s;
}
// -------------------------

static inline
void print_vec(const double *f, ulong n, ulong d)
{
    cout << setw(4) << d << ": [ ";
    for (ulong j=0; j<n; ++j)
    {
        double fj = f[j];
        if ( std::abs( fj ) < 1e-6 )  { fj = 0.0; }
        if ( fj == 0.0 )
        {
            cout << "  ";
//            cout << " 0,";
        }
        else
        {
            cout << ( fj > 0 ? '+' : '-' ) << ' ';
//            cout <<  fj << ' ';
//            cout <<  fj << ",";
        }
    }
    cout << "]";
    cout << "  " << norm_l2_sqr( f, n );
    cout << endl;
}
// -------------------------


int
main(int argc, char **argv)
{
    ulong ldn = 5;
    NXARG(ldn, "Using 2**ldn elements");
    const ulong n = 1UL<<ldn;
    bool qq = 0;
    NXARG(qq, "0 ==> basis of SWT, 1 ==> basis of inverse SWT");
    bool nq = 1;
    NXARG(nq, "Whether to use normalization");

    double *f = new double[n];
    double *b = new double[n];

    for (ulong d=0; d<n; ++d)
    {
        delta_func( f, n, d );
        if ( qq )  { inverse_square_wave_transform( f, ldn, nq ); }
        else       { square_wave_transform( f, ldn, nq ); }
#if 1  // print basis vectors
        print_vec( f, n, d );

        if ( qq && ! nq )  // check function square_wave_basis():
        {
            square_wave_basis( b, n, d );
//            print_vec( b, n, d );
            for (ulong j=0; j<n; ++j)
            { jjassert( std::abs(f[j]-b[j]) < 1e-6 ); }
        }
#else  // check inverse
        if ( ! qq )  { inverse_square_wave_transform( f, ldn, nq ); }
        else         { square_wave_transform( f, ldn, nq ); }
        print_vec( f, n, d );
#endif
    }

    delete [] f;
    delete [] b;
    return 0;
}
// -------------------------


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/fft"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/fft/square-wave-basis-demo.cc"
/// make-target2: "1demo DSRC=demo/fft/square-wave-basis-demo.cc DEMOFLAGS=-DTIMING"
/// End:
