
#include "ds/dichotomy.h"

#include "nextarg.h"  // NXARG()
#include "fxttypes.h"
#include "fxtio.h"
#include "jjassert.h"

//% Partitioning of n elements into two classes, 'left' and 'right'.
//% Elements can be moved (by value or index) between 'left' and 'right' in O(1).


int
main(int argc, char **argv)
{
    ulong n = 10;
    NXARG(n, "Length of things");

    dichotomy D(n);

    D.print();
    bool q;
//    ulong e;
    for (ulong j=0; j<7; ++j)
    {
        q = D.move_elem_left(j+2);
//        q = D.move_first_left( e );
//        cout << " e = " << e << "\n";
        D.print();
        jjassert( q );
        jjassert( D.OK() );
    }

    for (ulong j=0; j<7; ++j)
    {
        q = D.move_elem_right(j+2);
//        q = D.move_last_right( e );
//        cout << " e = " << e << "\n";
        D.print();
        jjassert( q );
        jjassert( D.OK() );
    }

    jjassert( D.OK() );


    return 0;
}
// -------------------------

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/ds"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/ds/dichotomy-demo.cc"
/// make-target2: "1demo DSRC=demo/ds/dichotomy-demo.cc DEMOFLAGS=-DTIMING"
/// End:
