
#include "comb/subset-sl-gray.h"

#include "nextarg.h"  // NXARG()
#include "fxttypes.h"
#include "fxtalloca.h"
#include "fxtio.h"
#include "jjassert.h"

//% Nonempty subsets of the set {0,1,2,...,n-1} in SL-Gray order.
//% Representation as list of parts.
//% Loopless generation.

//#define TIMING  // uncomment to disable printing

// Cf. comb/binary-sl-gray-demo.cc for representation as delta-set
// Cf. comb/subset-lex-demo.cc

int
main(int argc, char **argv)
{
    ulong n = 6;
    NXARG(n, "Number of digits");
//    jjassert( n>=1 );

    subset_sl_gray M(n);

    ulong ct = 0;
#if defined TIMING
    M.first();
    do  { ++ct; }  while ( M.next() );
#else

    cout << endl;
    do
    {
        cout << setw(4) << ct;
//        cout << setw(4) << M.len();
        cout << ":";
//        print_set_as_deltaset("    ", M.data(), M.len(), true );
        M.print("  ", 0 );

//        // position and direction of change:
//        cout << "  " << M.pos();
//        cout << "  " << (M.dir() > 0 ? '+' : '-');


        cout << endl;

        ++ct;
    }
    while ( M.next() );


#endif  // TIMING

    cout << " ct=" << ct << endl;

    return 0;
}
// -------------------------

/*
Timing:GCC 12.2.0
Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz

time ./bin 30
arg 1: 30 == n  [Number of digits]  default=6
 ct=1073741824
2.60user 0.00system 0:02.60elapsed 99%CPU
 ==> 1073741824 / 2.60 == 412,977,624 per second

*/


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/subset-sl-gray-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/subset-sl-gray-demo.cc DEMOFLAGS=-DTIMING"
/// End:

