
#include "comb/perm1-topsort.h"
#include "comb/young-tab-fixed-shape.h"

#include "comb/comb-print.h"

#include "fxtio.h"
#include "aux0/swap.h"
#include "fxttypes.h"
#include "jjassert.h"

#include "nextarg.h"  // NXARG()

//#define TIMING  // uncomment to disable printing

//% Young tableaux of given shape.
//% The underlying driver is class perm1_topsort.

int
main(int argc, char **argv)
{
    ulong *R;  // element i is repeated R[i] times
    cout << "args: multiplicities of elements" << endl;
    ulong k;
    if ( argc<=2 )
    {
        ulong t[]={3, 3, 3, 0};
        k=0;  while ( t[k] )  { ++k; }
        R = new ulong[k];
        for (ulong j=0; j<k; ++j)  R[j] = t[j];
    }
    else
    {
        k = (ulong)argc - 1;
        R = new ulong[k];
        for (ulong j=0; j<k; ++j)
        {
            ulong t = strtoul(argv[j+1], nullptr, 10);
            R[j] = t;
        }
    }
//    cout << " k = " << k << endl;
//    print_vec(" R[] = ", R, k, false );  cout << endl;
    print_vec("shape R[] = ", R, k );  cout << "\n\n";

    const bool shiftq = false;  // default == false
    if ( shiftq )  { cout << "shiftq = true!\n"; }
    young_tab_fixed_shape Y( R, k, shiftq );
    Y.first();
    ulong ct = 0;
    do
    {
        ++ct;
#if ! defined TIMING
//        cout << setw(4) << ct << ":  ";
        cout << ct << ":\n";
//        const perm1_topsort * P = Y.topsort_obj();
//        print_vec("   Q[] = ", P.data(), P.get_n() );
//        print_vec("   P[] = ", P.data_perm(), P.get_n() );
//        cout << endl;
        Y.print("");
        cout << endl;
#endif
    }
    while( Y.next() );

    cout << " ct=" << ct << endl;

    delete  [] R;

    return 0;
}
// -------------------------


/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

time ./bin 5 5 5 5 5
 ct=701149020
7.64user 0.00system 0:07.64elapsed 100%CPU
 ==> 701149020/7.64 == 91,773,431 per second
*/


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/perm1-topsort-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/perm1-topsort-demo.cc DEMOFLAGS=-DTIMING"
/// End:

