
#include "comb/perm-star-swaps.h"

//#include "perm/permq.h"
#include "comb/comb-print.h"

#include "fxttypes.h"
#include "nextarg.h"  // NXARG()
#include "fxtio.h"

//% Permutations in star-transposition order (a Gray code).
//% Compute swaps only.
//% Algorithm by Gideon Ehrlich, as given by Knuth,
//%  TAOCP 4A/1, Algorithm E "Ehrlich swaps", p.337.
//% Cf. OEIS sequences A123400 and A159880.

//#define TIMING  // uncomment to disable printing



int
main(int argc, char **argv)
{
    ulong n = 4;
    NXARG(n, "Number of elements to permute");
//    jjassert( n>0 );

    perm_star_swaps P(n);
    P.first();

#if defined TIMING
#if defined PERM_STAR_SWAPS_FIXARRAYS
    cout << "PERM_STAR_SWAPS_FIXARRAYS is defined." << endl;
#endif
    while ( P.next() ) {;}
    ulong dummy;  P.get_swap(dummy, dummy);
    if ( dummy > n )  { return 1; }  // never
#else

    bool dfz= true;  // whether to print dots for zeros
    ulong *x = new ulong[n];  // permutations
    ulong *xi = new ulong[n];  // inverse permutations
    for (ulong k=0; k<n; ++k)  x[k] = xi[k] = k;

    ulong ct = 0;
    do
    {
        cout << setw(4) << ct << ":";
        ulong sw1, sw2;
        P.get_swap(sw1, sw2);
        swap2( x[sw1], x[sw2] );  // update permutation
        print_perm("    ", x, n, dfz);
//        print_perm("  b[]: ", P.b_, n, dfz);

        // right element in swap gives OEIS sequence A123400
        cout << "     (" << sw1 << ", " << sw2 << ") ";

        swap2( xi[x[sw1]], xi[x[sw2]] );  // update inverse permutation
        print_perm("    ", xi, n, dfz);

        cout << endl;
        ++ct;
    }
    while ( P.next() );

    cout << " ct=" << ct << endl;

    delete [] x;
    delete [] xi;
#endif

    return 0;
}
// -------------------------

/*
A123400:
echo $(./bin 5 | g -F \) | cut -d, -f2 | cut -d\) -f1 ) | tr ' ' ','

A159880:
./bin 5 | g -F \) | cut -d] -f1 | cut -d[ -f2 | cut -d' ' -f2 | tr . 0
*/

/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

time ./bin 12
arg 1: 12 == n  [Number of elements to permute]  default=4
PERM_STAR_SWAPS_FIXARRAYS is defined.
0.60user 0.00system 0:00.60elapsed 100%CPU
 ==> 12!/0.60 == 798,336,000 per second

time ./bin 12
arg 1: 12 == n  [Number of elements to permute]  default=4
0.64user 0.00system 0:00.64elapsed 100%CPU
 ==> 12!/0.64 == 748,440,000 per second

*/

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/perm-star-swaps-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/perm-star-swaps-demo.cc DEMOFLAGS=-DTIMING"
/// End:

