
#include "comb/mset-perm-gray.h"

#include "comb/comb-print.h"
#include "comb/fact2perm.h"

#include "fxttypes.h"
#include "fxtio.h"
//#include "jjassert.h"

#include <cstdlib>  // strtoul()


//% All multiset permutations in minimal-change order (Fred Lunnon's Gray code).
//% Same as: all strings with fixed content.


//#define TIMING  // uncomment to disable printing

//#define DETAILS  // define to print full internal state of the class


int
main(int argc, char **argv)
{
    ulong k;   // number of sorts of elements
    ulong *r;  // element i is repeated r[i] times

    cout << "args: multiplicities of elements" << endl;
    if ( argc <= 1 )
    {
        ulong t[]={3, 2, 1, 0};  // proper multisets  ct=60
//        ulong t[]={2, 2, 1, 0};  // proper multisets  ct=30
//        ulong t[]={2, 2, 2, 0};  // proper multisets  ct=90
//        ulong t[]={1, 1, 1, 1, 0};  // permutations  ct = 24
//        ulong t[]={6, 2, 0};  // combinations  ct=28
        k=0;  while ( t[k] )  { ++k; }
        r = new ulong[k];
        for (ulong j=0; j<k; ++j)  r[j] = t[j];
    }
    else
    {
        k = (ulong)argc - 1;
        r = new ulong[k];
        for (ulong j=0; j<k; ++j)
        {
            ulong t = strtoul(argv[j+1], nullptr, 10);
            r[j] = t;
        }
    }

    mset_perm_gray P(r, k);
    const ulong n = P.get_n();

    cout << "multiplicities: ( ";
    for (ulong i=0; i<k; ++i)  cout << r[i] << (i<k-1?", ":" ");
    cout << ")";
    cout << "  k=" << k << "  n=" << n;
    cout << endl;

    ulong ct = 0;

#if defined TIMING

    do
    {
        ++ct;
    }
    while ( P.next() );

#else  // TIMING

//    ulong F[n];
    do
    {
        ++ct;
        cout << setw(4) << ct << ":";

#if !defined DETAILS
        P.print("  ");
//        perm2ffact( P.data_perm(), n, F);
//        print_vec( "    ", F, n-1, true );
#else  // DETAILS
        {
//            const ulong nn = n + 4;
            P.print("  ms=");
            P.print_perm("  P=");
            P.print_inv_perm("  Q=");
            P.print_dirs("  D=");
        }
#endif  // DETAILS
        if ( ct>1 )
        {
            ulong s1, s2;
            P.get_swaps(s1, s2);
            cout << "  (" << s1 << ", " << s2 << ")";
        }

        cout << endl;
    }
    while ( P.next() );

    delete [] r;

#endif  // TIMING

    cout << " ct=" << ct << endl;

    return 0;
}
// -------------------------


/*
Timing: Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
GCC 12.2.0

time ./bin 2 2 2 3 3 3
args: multiplicities of elements
multiplicities: ( 2, 2, 2, 3, 3, 3 )  k=6  n=15
 ct=756756000
8.00user 0.00system 0:08.00elapsed 100%CPU
 ==> 756756000/8.00 == 94,594,500 per second

time ./bin 3 3 3 2 2 2 ## reordered
args: multiplicities of elements
multiplicities: ( 3, 3, 3, 2, 2, 2 )  k=6  n=15
 ct=756756000
8.34user 0.00system 0:08.34elapsed 100%CPU
 ==> 756756000/8.34 == 90,738,129 per second

time ./bin 1 1 1 1 1 1 1 1 1 1 1 1  ## permutations of 12
args: multiplicities of elements
multiplicities: ( 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 )  k=12  n=12
 ct=479001600
4.68user 0.00system 0:04.68elapsed 100%CPU
 ==> 479001600/4.68 == 102,350,769 per second

time ./bin 15 15  ## combination (30 choose 15)
args: multiplicities of elements
multiplicities: ( 15, 15 )  k=2  n=30
 ct=155117520
2.07user 0.00system 0:02.07elapsed 100%CPU
 ==> 155117520/2.07 == 74,936,000 per second

*/

/*
BENCHARGS= 2 2 2 3 3 3
BENCHARGS= 3 3 3 2 2 2 ## reordered
BENCHARGS= 1 1 1 1 1 1 1 1 1 1 1 1  ## permutations of 12
BENCHARGS= 15 15  ## combinations (30 choose 15)
*/


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/mset-perm-gray-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/mset-perm-gray-demo.cc DEMOFLAGS=-DTIMING"
/// End:
