
#include "comb/descent-rgs.h"
#include "comb/word-stats.h"

#include "comb/comb-print.h"


#include "fxtio.h"
#include "fxttypes.h"
#include "jjassert.h"

#include "nextarg.h"

//% Statistics for descent sequences.
//% A descent sequence is a sequence [d(1), d(2), ..., d(n)] where d(1)=0,
//%  d(k)>=0, and d(k) <= 1 + desc([d(1), d(2), ..., d(k-1)]) and desc(.)
//%  counts the number of descents of its argument.
//% Cf. the following OEIS sequences:
//% A225624: triangle, length-n descent sequences with k-1 descents.

// Cf. comb/ascent-rgs-stats-demo.cc for stats for ascent sequences
// Cf. comb/descent-rgs-demo.cc

//#define TIMING  // uncomment to disable printing


int
main(int argc, char **argv)
{
    ulong n = 5;
    NXARG(n, "Length of strings, n>=1");

    ulong sq = 1;
    NXARG(sq, "Select stats:\n"
          "    0 ==> max element\n"
          "    1 ==> number of descents\n"
          "    2 ==> number of ascents\n"
          "    3 ==> number of zeros - 1\n"
          "    4 ==> number of maximal digits - 1\n"
          "    6 ==> position of last occurrence of zero\n"
          "    7 ==> position of first occurrence of the maximal value\n"
          "    8 ==> position of last occurrence of the maximal value\n"
          "   10 ==> number of odd values\n"
          "   40 ==> number of flat steps\n"
//          "   80 ==> number of fixed points - 1\n"
          );

    descent_rgs A(n);
    word_stats W(A.data(), n);

    ulong ct = 0;
    ulong * st = new ulong[n+1];  // stats
    for (ulong k=0; k<=n; ++k)  st[k] = 0;

#if !defined TIMING
    const ulong *x = A.data();
#endif

    ulong j = 0;
    do
    {
        ++ct;
        ulong s = 0;
        switch ( sq )
        {
        case 0:  // by max element: A000000
            s = W.max_val();
            break;
            // 1,
            // 1, 1,
            // 1, 3, 0,
            // 1, 7, 1, 0,
            // 1, 15, 7, 0, 0,
            // 1, 31, 32, 3, 0, 0,
            // 1, 63, 122, 35, 1, 0, 0,
            // 1, 127, 423, 249, 32, 0, 0, 0,
            // 1, 255, 1389, 1413, 421, 22, 0, 0, 0,
            // 1, 511, 4414, 7078, 3789, 606, 13, 0, 0, 0,
            // 1, 1023, 13744, 32898, 27738, 8859, 794, 5, 0, 0, 0,
            // 1, 2047, 42245, 145854, 179415, 94394, 19131, 925, 1, 0, 0, 0,


        case 1:  // by number of descents: A225624
            s = A.num_descents();  // simplified: s==A.m[n-1]
//            jjassert( s == W.num_ascents() );
            break;
            // 1,
            // 2, 0,
            // 3, 1, 0,
            // 4, 5, 0, 0,
            // 5, 15, 3, 0, 0,
            // 6, 35, 25, 1, 0, 0,
            // 7, 70, 117, 28, 0, 0, 0,
            // 8, 126, 405, 271, 22, 0, 0, 0,
            // 9, 210, 1155, 1631, 483, 13, 0, 0, 0,
            // 10, 330, 2871, 7359, 5126, 711, 5, 0, 0, 0,
            // 11, 495, 6435, 27223, 36526, 13482, 889, 1, 0, 0, 0,
            // 12, 715, 13299, 86919, 199924, 151276, 30906, 962, 0, 0, 0, 0,

        case 2:  // by number of ascents: A000000
            s = W.num_ascents();
            break;
            // 1,
            // 1, 1,
            // 1, 3, 0,
            // 1, 6, 2, 0,
            // 1, 10, 11, 1, 0,
            // 1, 15, 36, 15, 0, 0,
            // 1, 21, 91, 97, 12, 0, 0,
            // 1, 28, 196, 421, 180, 6, 0, 0,
            // 1, 36, 378, 1435, 1411, 239, 1, 0, 0,
            // 1, 45, 672, 4148, 7821, 3506, 219, 0, 0, 0,
            // 1, 55, 1122, 10626, 34634, 31982, 6506, 136, 0, 0, 0,
            // 1, 66, 1782, 24805, 130729, 217829, 99620, 9129, 52, 0, 0, 0,
            // second col: A000217, g.f. x/(1-x)^3
            // third col: A005583, g.f.: x*(2-x)/(1-x)^6


        case 3:  // by number of zeros (=min values): A000000
            s = W.num_zeros();
//            jjassert( s == W.num_min_val() );
            break;
            // 1,
            // 1, 1,
            // 1, 2, 1,
            // 1, 4, 3, 1,
            // 1, 8, 9, 4, 1,
            // 1, 17, 27, 16, 5, 1,
            // 1, 40, 85, 64, 25, 6, 1,
            // 1, 107, 289, 266, 125, 36, 7, 1,
            // 1, 329, 1078, 1174, 645, 216, 49, 8, 1,
            // 1, 1161, 4440, 5567, 3495, 1331, 343, 64, 9, 1,
            // 1, 4662, 20201, 28515, 20076, 8546, 2457, 512, 81, 10, 1,
            // 1, 21074, 101226, 157996, 122828, 57632, 18235, 4180, 729, 100, 11, 1,

        case 4:  // by number of max digits: A000000
            s = W.num_max_val();
            break;
            // 1,
            // 1, 1,
            // 2, 1, 1,
            // 4, 3, 1, 1,
            // 10, 7, 4, 1, 1,
            // 31, 18, 11, 5, 1, 1,
            // 111, 57, 30, 16, 6, 1, 1,
            // 444, 213, 97, 47, 22, 7, 1, 1,
            // 1969, 892, 375, 156, 70, 29, 8, 1, 1,
            // 9643, 4123, 1638, 620, 240, 100, 37, 9, 1, 1,
            // 51864, 20985, 7871, 2813, 977, 356, 138, 46, 10, 1, 1,
            // 304526, 117141, 41485, 14028, 4585, 1482, 512, 185, 56, 11, 1, 1,



        case 6:  // position of last zero (last occurrence of min): A000000
            s = W.last_zero_idx();
//            jjassert( s == W.last_min_idx() );
            break;
            // 1,
            // 1, 1,
            // 1, 1, 2,
            // 1, 1, 3, 4,
            // 1, 1, 5, 7, 9,
            // 1, 1, 10, 13, 19, 23,
            // 1, 1, 24, 28, 43, 58, 67,
            // 1, 1, 68, 70, 115, 156, 199, 222,
            // 1, 1, 223, 202, 361, 491, 625, 765, 832,
            // 1, 1, 833, 667, 1313, 1786, 2266, 2765, 3279, 3501,
            // 1, 1, 3502, 2497, 5451, 7410, 9352, 11395, 13461, 15580, 16412,
            // 1, 1, 16413, 10504, 25477, 34636, 43396, 52854, 62292, 71816, 81561, 85062,


        case 7:  // position of first occurrence of max: A000000
            s = W.first_max_idx();
            break;
            // 1,
            // 1, 1,
            // 1, 2, 1,
            // 1, 4, 2, 2,
            // 1, 8, 4, 5, 5,
            // 1, 16, 8, 13, 14, 15,
            // 1, 32, 16, 35, 40, 47, 51,
            // 1, 64, 32, 97, 116, 151, 177, 194,
            // 1, 128, 64, 275, 340, 497, 631, 744, 821,
            // 1, 256, 128, 793, 1004, 1675, 2307, 2936, 3467, 3845,
            // 1, 512, 256, 2315, 2980, 5777, 8635, 11898, 15073, 17802, 19813,
            // 1, 1024, 512, 6817, 8876, 20371, 33027, 49412, 67313, 84844, 100116, 111700,

        case 8:  // position of last occurrence of max: A000000
            s = W.last_max_idx();
            break;
            // 1,
            // 0, 2,
            // 0, 1, 3,
            // 0, 1, 2, 6,
            // 0, 1, 2, 6, 14,
            // 0, 1, 2, 8, 18, 38,
            // 0, 1, 2, 12, 28, 61, 118,
            // 0, 1, 2, 20, 48, 115, 230, 416,
            // 0, 1, 2, 36, 88, 241, 514, 966, 1653,
            // 0, 1, 2, 68, 168, 547, 1262, 2524, 4494, 7346,
            // 0, 1, 2, 132, 328, 1321, 3322, 7176, 13532, 23023, 36225,
            // 0, 1, 2, 260, 648, 3355, 9230, 21760, 43956, 78899, 129140, 196762,


        case 10:  // number of odd values: (reversal of "even values")
            s = W.num_odd_val();
            break;
            // 1,
            // 1, 1,
            // 1, 2, 1,
            // 1, 4, 3, 1,
            // 1, 8, 9, 4, 1,
            // 1, 16, 26, 18, 5, 1,
            // 1, 32, 73, 74, 35, 6, 1,
            // 1, 65, 205, 285, 200, 68, 7, 1,
            // 1, 138, 591, 1077, 1025, 527, 133, 8, 1,
            // 1, 315, 1770, 4086, 5035, 3543, 1388, 264, 9, 1,
            // 1, 783, 5522, 15722, 24298, 22259, 12179, 3746, 541, 10, 1,
            // 1, 2114, 18018, 61970, 117030, 134294, 96417, 42451, 10534, 1172, 11, 1,

        case 11:  // number of even values: A000000
            s = W.num_even_val();
            break;
            // 1,
            // 1, 1,
            // 1, 2, 1,
            // 1, 3, 4, 1,
            // 1, 4, 9, 8, 1,
            // 1, 5, 18, 26, 16, 1,
            // 1, 6, 35, 74, 73, 32, 1,
            // 1, 7, 68, 200, 285, 205, 65, 1,
            // 1, 8, 133, 527, 1025, 1077, 591, 138, 1,
            // 1, 9, 264, 1388, 3543, 5035, 4086, 1770, 315, 1,
            // 1, 10, 541, 3746, 12179, 22259, 24298, 15722, 5522, 783, 1,
            // 1, 11, 1172, 10534, 42451, 96417, 134294, 117030, 61970, 18018, 2114, 1,


        case 40:  // number of flat steps: A000000
            s = W.num_flat_steps();
            break;
            // 1,
            // 1, 1,
            // 1, 2, 1,
            // 2, 3, 3, 1,
            // 4, 8, 6, 4, 1,
            // 11, 20, 20, 10, 5, 1,
            // 34, 66, 60, 40, 15, 6, 1,
            // 124, 238, 231, 140, 70, 21, 7, 1,
            // 512, 992, 952, 616, 280, 112, 28, 8, 1,
            // 2380, 4608, 4464, 2856, 1386, 504, 168, 36, 9, 1,
            // 12294, 23800, 23040, 14880, 7140, 2772, 840, 240, 45, 10, 1,
            // 69972, 135234, 130900, 84480, 40920, 15708, 5082, 1320, 330, 55, 11, 1,
            // 435399, 839664, 811404, 523600, 253440, 98208, 31416, 8712, 1980, 440, 66, 12, 1,

        case 41:  // number of non-flat steps: A000000
            s = W.num_nonflat_steps();
            break;
            // 1,
            // 1, 1,
            // 1, 2, 1,
            // 1, 3, 3, 2,
            // 1, 4, 6, 8, 4,
            // 1, 5, 10, 20, 20, 11,
            // 1, 6, 15, 40, 60, 66, 34,
            // 1, 7, 21, 70, 140, 231, 238, 124,
            // 1, 8, 28, 112, 280, 616, 952, 992, 512,
            // 1, 9, 36, 168, 504, 1386, 2856, 4464, 4608, 2380,
            // 1, 10, 45, 240, 840, 2772, 7140, 14880, 23040, 23800, 12294,
            // 1, 11, 55, 330, 1320, 5082, 15708, 40920, 84480, 130900, 135234, 69972,
            // 1, 12, 66, 440, 1980, 8712, 31416, 98208, 253440, 523600, 811404, 839664, 435399,


//        case 60:  // maxval - minval == maxval
//            s = W.min_max_diff();
//            break;

        case 61:  // abs(#minval - #maxval): A000000
            s = W.min_max_num_diff();
            break;
            // 1,
            // 2, 0,
            // 1, 3, 0,
            // 4, 1, 4, 0,
            // 2, 13, 3, 5, 0,
            // 15, 12, 28, 6, 6, 0,
            // 17, 78, 55, 55, 10, 7, 0,
            // 96, 163, 280, 172, 98, 15, 8, 0,
            // 235, 769, 957, 928, 421, 161, 21, 9, 0,
            // 1087, 2717, 4561, 4303, 2581, 877, 248, 28, 10, 0,
            // 4232, 12861, 21356, 23570, 14850, 6151, 1632, 363, 36, 11, 0,
            // 20664, 61532, 114442, 134350, 94699, 41973, 12991, 2795, 510, 45, 12, 0,


        case 80:  // by number of fixed points:
            s = W.num_fixed_points();
            break;
            // 1,
            // 1, 1,
            // 2, 2, 0,
            // 4, 5, 0, 0,
            // 9, 14, 0, 0, 0,
            // 23, 44, 0, 0, 0, 0,
            // 67, 155, 0, 0, 0, 0, 0,
            // 222, 610, 0, 0, 0, 0, 0, 0,
            // 832, 2669, 0, 0, 0, 0, 0, 0, 0,
            // 3501, 12911, 0, 0, 0, 0, 0, 0, 0, 0,
            // 16412, 68650, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            // 85062, 398951, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            // 484013, 2520329, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

            // colum 0: A225588 descent sequences of length n
            // colum 1: first diffs of A225588

        case 95:  // value of last part: A000000
            s = A.data()[n-1];
            break;
            // 1,
            // 1, 1,
            // 2, 2, 0,
            // 4, 4, 1, 0,
            // 9, 9, 5, 0, 0,
            // 23, 23, 18, 3, 0, 0,
            // 67, 67, 61, 26, 1, 0, 0,
            // 222, 222, 215, 145, 28, 0, 0, 0,
            // 832, 832, 824, 698, 293, 22, 0, 0, 0,
            // 3501, 3501, 3492, 3282, 2127, 496, 13, 0, 0, 0,
            // 16412, 16412, 16402, 16072, 13201, 5842, 716, 5, 0, 0, 0,
            // 85062, 85062, 85051, 84556, 78121, 50898, 14372, 890, 1, 0, 0, 0,
            // 484013, 484013, 484001, 483286, 469987, 383068, 183144, 31868, 962, 0, 0, 0, 0,


        default:
            cerr << "Invalid choice (exiting)." << endl;
            return 1;
        }


        st[ s ] += 1;


#if !defined TIMING
        cout << setw(4) << ct << ":  ";

        // print RGS:
        print_vec("  ", x, n, true );
//        print_vec("    ", A.m_, n, true );

        cout << setw(4) << s;

//        cout << setw(3) << A.num_zeros() << setw(3) << A.num_fixed_points();

//        cout << setw(4) << j;

        cout << endl;

        jjassert( A.OK() );
#endif  // TIMING
    }
    while ( (j=A.next()) );


    ulong sct = 0;
    for (ulong k=0; k<=n; ++k)
    {
        cout << st[k] << ", ";
        sct += st[k];
    }
    cout << endl;

    cout << " ct=" << ct;  // total: OEIS sequence A225588
    cout << endl;

    jjassert( sct == ct );

    delete [] st;

    return 0;
}
// -------------------------

/*

Print triangle for stats q:


OEIS example:
q=0; for n in $(seq 0 13) ; do ./bin $n $q | grep ', $' ; done | nl -v0 -s':  ' -w2 -n rz

C++ comment:
q=0;  for n in $(seq 0 13) ; do ./bin $n $q | grep ', $' ; done | sed 's/^/\/\/ /; s/ $//;'

Extract column c from stats q:
q=0;  c=0;  echo $(for n in $(seq 0 13) ; do ./bin $n $q | grep ', $' ; done | cut -d, -f$((c+1))) | sed 's/ /, /g;'

*/

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/descent-rgs-stats-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/descent-rgs-stats-demo.cc DEMOFLAGS=-DTIMING"
/// End:
