
#include "comb/perm-lex.h"
#include "comb/lex-compare.h"


#include "nextarg.h"  // NXARG()
#include "fxttypes.h"
#include "fxtio.h"

#include <vector>

//% Test, ignore.

//#define TIMING  // uncomment to disable printing

static bool
is_funny(const ulong *x, ulong n)
{
    if ( n <= 1 )  return true;

    std::vector<ulong> S;
    S.push_back(0);
    for (ulong j=1; j<n; ++j)
    {
        if ( x[j-1] > x[j] )  S.push_back(j);
    }
    S.push_back(n);

    for (ulong j=2; j<S.size(); ++j)
    {
        if ( S[j-2] > S[j-1] )  return false;
    }
    return true;
}
// -------------------------

static void
print_funny(const ulong *x, ulong n)
{
    cout << "{";
    for (ulong j = 0;  j < n-1;  ++j)
    {
        cout << x[j];
        if ( x[j] > x[j+1] )  cout << "} {";
        else   cout << ", ";
    }
    cout << x[n-1];
    cout << "}";
}
// -------------------------


int
main(int argc, char **argv)
{
    ulong n = 4;
    NXARG(n, "Length of things");

    perm_lex P(n);

#ifdef TIMING
    ulong ct = 0;
    do
    {
        if ( is_funny( P.data(), n) ) ++ct;
    }
    while ( P.next() );

#else  // TIMING

    ulong ct = 0;
    do
    {
        if ( is_funny( P.data(), n) )
        {
            cout << setw(4) << ct << ":";
            P.print("    ", false);
//            P.print_inv("    ", false);
            cout << "    ";
            print_funny( P.data(), n);
            cout << endl;

            ++ct;
        }
    }
    while ( P.next() );

#endif // TIMING
    cout << "ct=" << ct << endl;

    return 0;
}
// -------------------------

/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/zzztest-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/zzztest-demo.cc DEMOFLAGS=-DTIMING"
/// End:
