
#include "comb/setpart-rgs-lex.h"

#include "comb/comb-print.h"


#include "jjassert.h"
#include "fxtio.h"
#include "fxttypes.h"

#include "nextarg.h"

//% Set partitions of the n-set as restricted growth strings (RGS):
//% strings s[0, 1, ..., n-1] such that s[k] <= max(s[0], s[1], ..., s[k-1]) + 1.
//% Lexicographic order.


//#define TIMING  // uncomment to disable printing

// Cf. comb/setpart-p-rgs-lex-demo.cc for the RGS for set partitions into p parts
// Cf. comb/setpart-ck-rgs-demo.cc for the Cooper-Kennedy RGS
// Cf. comb/setpart-zero-map-rgs-demo.cc for RGS using certain maps


int
main(int argc, char **argv)
{
    ulong n = 5;
    NXARG(n, "Partition set of n elements");
    bool bq = false;
    NXARG(bq, "whether to list backwards");

    setpart_rgs_lex P(n);
    if ( bq )  P.last();

    ulong ct = 0;

#ifdef TIMING
    if ( bq )
    {
        cout << "backward:" << endl;
        do  { ++ct; }  while ( P.prev() );
    }
    else
    {
        cout << "forward:" << endl;
        do  { ++ct; }  while ( P.next() );
    }

#else  // TIMING

    do
    {
        ++ct;

        cout << setw(4) << ct << ":";
        P.print("  ", true);  // RGS

        print_vec("  ", P.mxp_, n);  // array of max in prefix
        P.print_sets("    ", 1);  // sets

        cout << endl;

        jjassert( P.OK() );
    }
    while ( bq ? P.prev() : P.next() );
#endif  // TIMING

    cout << " ct=" << ct << endl;

    return 0;
}
// -------------------------


/*
Timing: (Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz)

GCC 10.2.1

 time ./bin 15 0
arg 1: 15 == n  [Length of RGS]  default=5
arg 2: 0 == bw  [Whether to generate backward order]  default=0
SETPART_RGS_SUBSET_LEX_SC is defined
forward:
 ct=1382958545
./bin 15 0  1.97s user 0.00s system 99% cpu 1.969 total
 ==> 1382958545/1.97 == 702,009,413 per second

 time ./bin 15 1
arg 1: 15 == n  [Length of RGS]  default=5
arg 2: 1 == bw  [Whether to generate backward order]  default=0
SETPART_RGS_SUBSET_LEX_SC is defined
backward:
 ct=1382958545
./bin 15 1  1.88s user 0.00s system 99% cpu 1.885 total
 ==> 1382958545/1.88 == 735,616,247 per second



GCC 8.30

 time ./bin 15 0
 ct = 1382958545
./bin 15 0  3.49s user 0.00s system 99% cpu 3.486 total
 ==> 1382958545/3.49 == 396,263,193 per second

 time ./bin 15 1
 ct = 1382958545
./bin 15 1  3.05s user 0.00s system 99% cpu 3.051 total
 ==> 1382958545/3.05 == 453,429,031 per second

*/

/*
Timing:

 time ./bin 15 0
 ct = 1382958545
./bin 15 0  8.79s user 0.03s system 99% cpu 8.822 total
 ==> 1382958545/8.79 == 157,333,167 per second

 time ./bin 15 1
 ct = 1382958545
./bin 15 1  7.28s user 0.01s system 100% cpu 7.286 total
 ==> 1382958545/7.28 == 189,966,833 per second

*/

/*
Timing: (AMD Phenom II X4 945 3000MHz)

 time ./bin 15 0
 ct = 1382958545
./bin 15 0  5.24s user 0.00s system 99% cpu 5.243 total
 ==> 1382958545/5.24 == 263,923,386 per second

 time ./bin 15 1
 ct = 1382958545
./bin 15 1  4.47s user 0.00s system 99% cpu 4.476 total
 ==> 1382958545/4.47 == 309,386,699 per second

*/

/*
BENCHARGS=15 0
BENCHARGS=15 1
*/


/// Emacs:
/// Local Variables:
/// MyRelDir: "demo/comb"
/// makefile-dir: "../../"
/// make-target: "1demo DSRC=demo/comb/setpart-rgs-lex-demo.cc"
/// make-target2: "1demo DSRC=demo/comb/setpart-rgs-lex-demo.cc DEMOFLAGS=-DTIMING"
/// End:

